import{s as We,o as Fe,n as Re}from"../chunks/scheduler.182ea377.js";import{S as Ye,i as Xe,g as r,s as i,r as _,A as Qe,h as l,f as n,c as s,j as R,u as v,x as m,k as W,y as d,a as o,v as b,d as M,t as w,w as y}from"../chunks/index.abf12888.js";import{T as Ke}from"../chunks/Tip.230e2334.js";import{D as oe}from"../chunks/Docstring.93f6f462.js";import{C as et}from"../chunks/CodeBlock.57fe6e13.js";import{E as tt}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as ye}from"../chunks/Heading.16916d63.js";function nt(F){let a,$='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){a=r("p"),a.innerHTML=$},l(u){a=l(u,"P",{"data-svelte-h":!0}),m(a)!=="svelte-1wmc0l4"&&(a.innerHTML=$)},m(u,h){o(u,a,h)},p:Re,d(u){u&&n(a)}}}function ot(F){let a,$="Examples:",u,h,g;return h=new et({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1ZGlvTERNUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHNjaXB5JTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmN2c3NwJTJGYXVkaW9sZG0tcy1mdWxsLXYyJTIyJTBBcGlwZSUyMCUzRCUyMEF1ZGlvTERNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJUZWNobm8lMjBtdXNpYyUyMHdpdGglMjBhJTIwc3Ryb25nJTJDJTIwdXBiZWF0JTIwdGVtcG8lMjBhbmQlMjBoaWdoJTIwbWVsb2RpYyUyMHJpZmZzJTIyJTBBYXVkaW8lMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxMCUyQyUyMGF1ZGlvX2xlbmd0aF9pbl9zJTNENS4wKS5hdWRpb3MlNUIwJTVEJTBBJTBBJTIzJTIwc2F2ZSUyMHRoZSUyMGF1ZGlvJTIwc2FtcGxlJTIwYXMlMjBhJTIwLndhdiUyMGZpbGUlMEFzY2lweS5pby53YXZmaWxlLndyaXRlKCUyMnRlY2huby53YXYlMjIlMkMlMjByYXRlJTNEMTYwMDAlMkMlMjBkYXRhJTNEYXVkaW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AudioLDMPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;cvssp/audioldm-s-full-v2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AudioLDMPipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Techno music with a strong, upbeat tempo and high melodic riffs&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(prompt, num_inference_steps=<span class="hljs-number">10</span>, audio_length_in_s=<span class="hljs-number">5.0</span>).audios[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save the audio sample as a .wav file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio)`,wrap:!1}}),{c(){a=r("p"),a.textContent=$,u=i(),_(h.$$.fragment)},l(p){a=l(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-kvfsh7"&&(a.textContent=$),u=s(p),v(h.$$.fragment,p)},m(p,x){o(p,a,x),o(p,u,x),b(h,p,x),g=!0},p:Re,i(p){g||(M(h.$$.fragment,p),g=!0)},o(p){w(h.$$.fragment,p),g=!1},d(p){p&&(n(a),n(u)),y(h,p)}}}function it(F){let a,$,u,h,g,p,x,Ue=`AudioLDM was proposed in <a href="https://huggingface.co/papers/2301.12503" rel="nofollow">AudioLDM: Text-to-Audio Generation with Latent Diffusion Models</a> by Haohe Liu et al. Inspired by <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a>, AudioLDM
is a text-to-audio <em>latent diffusion model (LDM)</em> that learns continuous audio representations from <a href="https://huggingface.co/docs/transformers/main/model_doc/clap" rel="nofollow">CLAP</a>
latents. AudioLDM takes a text prompt as input and predicts the corresponding audio. It can generate text-conditional
sound effects, human speech and music.`,ie,j,Ge="The abstract from the paper is:",se,U,Ie='<em>Text-to-audio (TTA) system has recently gained attention for its ability to synthesize general audio based on text descriptions. However, previous studies in TTA have limited generation quality with high computational costs. In this study, we propose AudioLDM, a TTA system that is built on a latent space to learn the continuous audio representations from contrastive language-audio pretraining (CLAP) latents. The pretrained CLAP models enable us to train LDMs with audio embedding while providing text embedding as a condition during sampling. By learning the latent representations of audio signals and their compositions without modeling the cross-modal relationship, AudioLDM is advantageous in both generation quality and computational efficiency. Trained on AudioCaps with a single GPU, AudioLDM achieves state-of-the-art TTA performance measured by both objective and subjective metrics (e.g., frechet distance). Moreover, AudioLDM is the first TTA system that enables various text-guided audio manipulations (e.g., style transfer) in a zero-shot fashion. Our implementation and demos are available at <a href="https://audioldm.github.io/" rel="nofollow">this https URL</a>.</em>',ae,G,He='The original codebase can be found at <a href="https://github.com/haoheliu/AudioLDM" rel="nofollow">haoheliu/AudioLDM</a>.',re,I,le,H,Be="When constructing a prompt, keep in mind:",de,B,Je="<li>Descriptive prompt inputs work best; you can use adjectives to describe the sound (for example, “high quality” or “clear”) and make the prompt context specific (for example, “water stream in a forest” instead of “stream”).</li> <li>It’s best to use general terms like “cat” or “dog” instead of specific names or abstract objects the model may not be familiar with.</li>",pe,J,Se="During inference:",ce,S,Ee="<li>The <em>quality</em> of the predicted audio sample can be controlled by the <code>num_inference_steps</code> argument; higher steps give higher quality audio at the expense of slower inference.</li> <li>The <em>length</em> of the predicted audio sample can be controlled by varying the <code>audio_length_in_s</code> argument.</li>",ue,D,me,E,fe,c,N,xe,Y,Ne="Pipeline for text-to-audio generation using AudioLDM.",$e,X,Ve=`This model inherits from <a href="/docs/diffusers/v0.26.3/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Te,T,V,Ae,Q,qe="The call function to the pipeline for generation.",Le,P,De,C,q,Pe,K,Oe=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ce,k,O,ke,ee,Ze=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,he,Z,ge,A,z,je,te,ze="Output class for audio pipelines.",_e,ne,ve;return g=new ye({props:{title:"AudioLDM",local:"audioldm",headingTag:"h1"}}),I=new ye({props:{title:"Tips",local:"tips",headingTag:"h2"}}),D=new Ke({props:{$$slots:{default:[nt]},$$scope:{ctx:F}}}),E=new ye({props:{title:"AudioLDMPipeline",local:"diffusers.AudioLDMPipeline",headingTag:"h2"}}),N=new oe({props:{name:"class diffusers.AudioLDMPipeline",anchor:"diffusers.AudioLDMPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": ClapTextModelWithProjection"},{name:"tokenizer",val:": Union"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vocoder",val:": SpeechT5HifiGan"}],parametersDescription:[{anchor:"diffusers.AudioLDMPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.26.3/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AudioLDMPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.37.2/en/model_doc/clap#transformers.ClapTextModelWithProjection" rel="nofollow">ClapTextModelWithProjection</a>) &#x2014;
Frozen text-encoder (<code>ClapTextModelWithProjection</code>, specifically the
<a href="https://huggingface.co/laion/clap-htsat-unfused" rel="nofollow">laion/clap-htsat-unfused</a> variant.`,name:"text_encoder"},{anchor:"diffusers.AudioLDMPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.37.2/en/model_doc/roberta#transformers.RobertaTokenizer" rel="nofollow">RobertaTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AudioLDMPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.26.3/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded audio latents.`,name:"unet"},{anchor:"diffusers.AudioLDMPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.26.3/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded audio latents. Can be one of
<a href="/docs/diffusers/v0.26.3/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.26.3/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.26.3/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.AudioLDMPipeline.vocoder",description:`<strong>vocoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.37.2/en/model_doc/speecht5#transformers.SpeechT5HifiGan" rel="nofollow">SpeechT5HifiGan</a>) &#x2014;
Vocoder of class <code>SpeechT5HifiGan</code>.`,name:"vocoder"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/audioldm/pipeline_audioldm.py#L52"}}),V=new oe({props:{name:"__call__",anchor:"diffusers.AudioLDMPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"audio_length_in_s",val:": Optional = None"},{name:"num_inference_steps",val:": int = 10"},{name:"guidance_scale",val:": float = 2.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_waveforms_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": Optional = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"output_type",val:": Optional = 'np'"}],parametersDescription:[{anchor:"diffusers.AudioLDMPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide audio generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AudioLDMPipeline.__call__.audio_length_in_s",description:`<strong>audio_length_in_s</strong> (<code>int</code>, <em>optional</em>, defaults to 5.12) &#x2014;
The length of the generated audio sample in seconds.`,name:"audio_length_in_s"},{anchor:"diffusers.AudioLDMPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality audio at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AudioLDMPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
A higher guidance scale value encourages the model to generate audio that is closely linked to the text
<code>prompt</code> at the expense of lower sound quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AudioLDMPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in audio generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AudioLDMPipeline.__call__.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of waveforms to generate per prompt.`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.AudioLDMPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.26.3/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AudioLDMPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AudioLDMPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.AudioLDMPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AudioLDMPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AudioLDMPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.3/en/api/pipelines/audioldm#diffusers.AudioPipelineOutput">AudioPipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AudioLDMPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.AudioLDMPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.AudioLDMPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AudioLDMPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>&quot;np&quot;</code> to return a NumPy <code>np.ndarray</code> or
<code>&quot;pt&quot;</code> to return a PyTorch <code>torch.Tensor</code> object.`,name:"output_type"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/audioldm/pipeline_audioldm.py#L367",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.26.3/en/api/pipelines/audioldm#diffusers.AudioPipelineOutput"
>AudioPipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.26.3/en/api/pipelines/audioldm#diffusers.AudioPipelineOutput"
>AudioPipelineOutput</a> or <code>tuple</code></p>
`}}),P=new tt({props:{anchor:"diffusers.AudioLDMPipeline.__call__.example",$$slots:{default:[ot]},$$scope:{ctx:F}}}),q=new oe({props:{name:"disable_vae_slicing",anchor:"diffusers.AudioLDMPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/audioldm/pipeline_audioldm.py#L108"}}),O=new oe({props:{name:"enable_vae_slicing",anchor:"diffusers.AudioLDMPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/audioldm/pipeline_audioldm.py#L100"}}),Z=new ye({props:{title:"AudioPipelineOutput",local:"diffusers.AudioPipelineOutput",headingTag:"h2"}}),z=new oe({props:{name:"class diffusers.AudioPipelineOutput",anchor:"diffusers.AudioPipelineOutput",parameters:[{name:"audios",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.AudioPipelineOutput.audios",description:`<strong>audios</strong> (<code>np.ndarray</code>) &#x2014;
List of denoised audio samples of a NumPy array of shape <code>(batch_size, num_channels, sample_rate)</code>.`,name:"audios"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.3/src/diffusers/pipelines/pipeline_utils.py#L130"}}),{c(){a=r("meta"),$=i(),u=r("p"),h=i(),_(g.$$.fragment),p=i(),x=r("p"),x.innerHTML=Ue,ie=i(),j=r("p"),j.textContent=Ge,se=i(),U=r("p"),U.innerHTML=Ie,ae=i(),G=r("p"),G.innerHTML=He,re=i(),_(I.$$.fragment),le=i(),H=r("p"),H.textContent=Be,de=i(),B=r("ul"),B.innerHTML=Je,pe=i(),J=r("p"),J.textContent=Se,ce=i(),S=r("ul"),S.innerHTML=Ee,ue=i(),_(D.$$.fragment),me=i(),_(E.$$.fragment),fe=i(),c=r("div"),_(N.$$.fragment),xe=i(),Y=r("p"),Y.textContent=Ne,$e=i(),X=r("p"),X.innerHTML=Ve,Te=i(),T=r("div"),_(V.$$.fragment),Ae=i(),Q=r("p"),Q.textContent=qe,Le=i(),_(P.$$.fragment),De=i(),C=r("div"),_(q.$$.fragment),Pe=i(),K=r("p"),K.innerHTML=Oe,Ce=i(),k=r("div"),_(O.$$.fragment),ke=i(),ee=r("p"),ee.textContent=Ze,he=i(),_(Z.$$.fragment),ge=i(),A=r("div"),_(z.$$.fragment),je=i(),te=r("p"),te.textContent=ze,_e=i(),ne=r("p"),this.h()},l(e){const t=Qe("svelte-u9bgzb",document.head);a=l(t,"META",{name:!0,content:!0}),t.forEach(n),$=s(e),u=l(e,"P",{}),R(u).forEach(n),h=s(e),v(g.$$.fragment,e),p=s(e),x=l(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1ozr8g7"&&(x.innerHTML=Ue),ie=s(e),j=l(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1cwsb16"&&(j.textContent=Ge),se=s(e),U=l(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-64lmgc"&&(U.innerHTML=Ie),ae=s(e),G=l(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n8fwj9"&&(G.innerHTML=He),re=s(e),v(I.$$.fragment,e),le=s(e),H=l(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1dvtu0c"&&(H.textContent=Be),de=s(e),B=l(e,"UL",{"data-svelte-h":!0}),m(B)!=="svelte-msgw5q"&&(B.innerHTML=Je),pe=s(e),J=l(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1g0t9wk"&&(J.textContent=Se),ce=s(e),S=l(e,"UL",{"data-svelte-h":!0}),m(S)!=="svelte-jm9a2k"&&(S.innerHTML=Ee),ue=s(e),v(D.$$.fragment,e),me=s(e),v(E.$$.fragment,e),fe=s(e),c=l(e,"DIV",{class:!0});var f=R(c);v(N.$$.fragment,f),xe=s(f),Y=l(f,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1vrcpd4"&&(Y.textContent=Ne),$e=s(f),X=l(f,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1vu93js"&&(X.innerHTML=Ve),Te=s(f),T=l(f,"DIV",{class:!0});var L=R(T);v(V.$$.fragment,L),Ae=s(L),Q=l(L,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-50j04k"&&(Q.textContent=qe),Le=s(L),v(P.$$.fragment,L),L.forEach(n),De=s(f),C=l(f,"DIV",{class:!0});var be=R(C);v(q.$$.fragment,be),Pe=s(be),K=l(be,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1s3c06i"&&(K.innerHTML=Oe),be.forEach(n),Ce=s(f),k=l(f,"DIV",{class:!0});var Me=R(k);v(O.$$.fragment,Me),ke=s(Me),ee=l(Me,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-14bnrb6"&&(ee.textContent=Ze),Me.forEach(n),f.forEach(n),he=s(e),v(Z.$$.fragment,e),ge=s(e),A=l(e,"DIV",{class:!0});var we=R(A);v(z.$$.fragment,we),je=s(we),te=l(we,"P",{"data-svelte-h":!0}),m(te)!=="svelte-19ryw33"&&(te.textContent=ze),we.forEach(n),_e=s(e),ne=l(e,"P",{}),R(ne).forEach(n),this.h()},h(){W(a,"name","hf:doc:metadata"),W(a,"content",st),W(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,a),o(e,$,t),o(e,u,t),o(e,h,t),b(g,e,t),o(e,p,t),o(e,x,t),o(e,ie,t),o(e,j,t),o(e,se,t),o(e,U,t),o(e,ae,t),o(e,G,t),o(e,re,t),b(I,e,t),o(e,le,t),o(e,H,t),o(e,de,t),o(e,B,t),o(e,pe,t),o(e,J,t),o(e,ce,t),o(e,S,t),o(e,ue,t),b(D,e,t),o(e,me,t),b(E,e,t),o(e,fe,t),o(e,c,t),b(N,c,null),d(c,xe),d(c,Y),d(c,$e),d(c,X),d(c,Te),d(c,T),b(V,T,null),d(T,Ae),d(T,Q),d(T,Le),b(P,T,null),d(c,De),d(c,C),b(q,C,null),d(C,Pe),d(C,K),d(c,Ce),d(c,k),b(O,k,null),d(k,ke),d(k,ee),o(e,he,t),b(Z,e,t),o(e,ge,t),o(e,A,t),b(z,A,null),d(A,je),d(A,te),o(e,_e,t),o(e,ne,t),ve=!0},p(e,[t]){const f={};t&2&&(f.$$scope={dirty:t,ctx:e}),D.$set(f);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),P.$set(L)},i(e){ve||(M(g.$$.fragment,e),M(I.$$.fragment,e),M(D.$$.fragment,e),M(E.$$.fragment,e),M(N.$$.fragment,e),M(V.$$.fragment,e),M(P.$$.fragment,e),M(q.$$.fragment,e),M(O.$$.fragment,e),M(Z.$$.fragment,e),M(z.$$.fragment,e),ve=!0)},o(e){w(g.$$.fragment,e),w(I.$$.fragment,e),w(D.$$.fragment,e),w(E.$$.fragment,e),w(N.$$.fragment,e),w(V.$$.fragment,e),w(P.$$.fragment,e),w(q.$$.fragment,e),w(O.$$.fragment,e),w(Z.$$.fragment,e),w(z.$$.fragment,e),ve=!1},d(e){e&&(n($),n(u),n(h),n(p),n(x),n(ie),n(j),n(se),n(U),n(ae),n(G),n(re),n(le),n(H),n(de),n(B),n(pe),n(J),n(ce),n(S),n(ue),n(me),n(fe),n(c),n(he),n(ge),n(A),n(_e),n(ne)),n(a),y(g,e),y(I,e),y(D,e),y(E,e),y(N),y(V),y(P),y(q),y(O),y(Z,e),y(z)}}}const st='{"title":"AudioLDM","local":"audioldm","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"AudioLDMPipeline","local":"diffusers.AudioLDMPipeline","sections":[],"depth":2},{"title":"AudioPipelineOutput","local":"diffusers.AudioPipelineOutput","sections":[],"depth":2}],"depth":1}';function at(F){return Fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ft extends Ye{constructor(a){super(),Xe(this,a,at,it,We,{})}}export{ft as component};
