import{s as St,n as Qt,o as Ft}from"../chunks/scheduler.e4ff9b64.js";import{S as Yt,i as Dt,e as a,s as i,c as m,h as Et,a as p,d as t,b as n,f as Nt,g as c,j as r,k as y,l as Pt,m as s,n as o,t as f,o as M,p as u}from"../chunks/index.09f1bca0.js";import{C as At,H as $,E as qt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.77e6395b.js";import{C as d}from"../chunks/CodeBlock.4320727b.js";import{D as Kt}from"../chunks/DocNotebookDropdown.02241b22.js";function Ot(et){let b,Be,He,xe,v,Re,W,Xe,_,ze,V,lt="让 <code>DiffusionPipeline</code> 生成特定风格或包含你所想要的内容的图像可能会有些棘手。 通常情况下，你需要多次运行 <code>DiffusionPipeline</code> 才能得到满意的图像。但是从无到有生成图像是一个计算密集的过程，特别是如果你要一遍又一遍地进行推理运算。",Le,k,tt="这就是为什么从pipeline中获得最高的 <em>computational</em> (speed) 和 <em>memory</em> (GPU RAM) 非常重要 ，以减少推理周期之间的时间，从而使迭代速度更快。",Ne,C,st="本教程将指导您如何通过 <code>DiffusionPipeline</code>  更快、更好地生成图像。",Se,H,it='首先，加载 <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a> 模型:',Qe,I,Fe,B,nt="本教程将使用的提示词是 <code>portrait photo of a old warrior chief</code> ，但是你可以随心所欲的想象和构造自己的提示词：",Ye,x,De,R,Ee,h,at='<p>💡 如果你没有 GPU, 你可以从像 <a href="https://colab.research.google.com/" rel="nofollow">Colab</a> 这样的 GPU 提供商获取免费的 GPU !</p>',Pe,X,pt="加速推理的最简单方法之一是将 pipeline 放在 GPU 上 ，就像使用任何 PyTorch 模块一样：",Ae,z,qe,L,rt='为了确保您可以使用相同的图像并对其进行改进，使用 <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>Generator</code></a> 方法，然后设置一个随机数种子 以确保其 <a href="./using-diffusers/reusing_seeds">复现性</a>:',Ke,N,Oe,S,mt="现在，你可以生成一个图像：",el,Q,ll,J,ct='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_1.png"/>',tl,F,ot="在 T4 GPU 上，这个过程大概要30秒（如果你的 GPU 比 T4 好，可能会更快）。在默认情况下，<code>DiffusionPipeline</code> 使用完整的 <code>float32</code> 精度进行 50 步推理。你可以通过降低精度（如 <code>float16</code> ）或者减少推理步数来加速整个过程",sl,Y,ft="让我们把模型的精度降低至 <code>float16</code> ，然后生成一张图像：",il,D,nl,w,Mt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_2.png"/>',al,E,ut="这一次，生成图像只花了约 11 秒，比之前快了近 3 倍！",pl,T,dt="<p>💡 我们强烈建议把 pipeline 精度降低至 <code>float16</code> , 到目前为止, 我们很少看到输出质量有任何下降。</p>",rl,P,yt="另一个选择是减少推理步数。 你可以选择一个更高效的调度器 (<em>scheduler</em>) 可以减少推理步数同时保证输出质量。您可以在 [DiffusionPipeline] 中通过调用compatibles方法找到与当前模型兼容的调度器 (<em>scheduler</em>)。",ml,A,cl,q,bt="Stable Diffusion 模型默认使用的是 <code>PNDMScheduler</code> ，通常要大概50步推理, 但是像 <code>DPMSolverMultistepScheduler</code> 这样更高效的调度器只要大概 20 或 25 步推理. 使用 <code>ConfigMixin.from_config()</code> 方法加载新的调度器:",ol,K,fl,O,ht="现在将 <code>num_inference_steps</code> 设置为 20:",Ml,ee,ul,U,Jt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_3.png"/>',dl,le,wt="太棒了！你成功把推理时间缩短到 4 秒！⚡️",yl,te,bl,se,Tt="改善 pipeline 性能的另一个关键是减少内存的使用量，这间接意味着速度更快，因为你经常试图最大化每秒生成的图像数量。要想知道你一次可以生成多少张图片，最简单的方法是尝试不同的batch size，直到出现<code>OutOfMemoryError</code> (OOM)。",hl,ie,Ut="创建一个函数，为每一批要生成的图像分配提示词和 <code>Generators</code> 。请务必为每个<code>Generator</code> 分配一个种子，以便于复现良好的结果。",Jl,ne,wl,ae,Zt="设置 <code>batch_size=4</code> ，然后看一看我们消耗了多少内存:",Tl,pe,Ul,re,gt="除非你有一个更大内存的GPU, 否则上述代码会返回 <code>OOM</code> 错误! 大部分内存被 cross-attention 层使用。按顺序运行可以节省大量内存，而不是在批处理中进行。你可以为 pipeline 配置 <code>enable_attention_slicing()</code> 函数:",Zl,me,gl,ce,Gt="现在尝试把 <code>batch_size</code> 增加到 8!",Gl,oe,jl,Z,jt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_5.png"/>',$l,fe,$t="以前你不能一批生成 4 张图片，而现在你可以在一张图片里面生成八张图片而只需要大概3.5秒！这可能是 T4 GPU 在不牺牲质量的情况运行速度最快的一种方法。",vl,Me,Wl,ue,vt="在最后两节中, 你要学习如何通过 <code>fp16</code> 来优化 pipeline 的速度, 通过使用性能更高的调度器来减少推理步数, 使用注意力切片（<em>enabling attention slicing</em>）方法来节省内存。现在，你将关注的是如何提高图像的质量。",_l,de,Vl,ye,Wt='有个显而易见的方法是使用更好的 checkpoints。 Stable Diffusion 模型是一个很好的起点, 自正式发布以来，还发布了几个改进版本。然而, 使用更新的版本并不意味着你会得到更好的结果。你仍然需要尝试不同的 checkpoints ，并做一些研究 (例如使用 <a href="https://minimaxir.com/2022/11/stable-diffusion-negative-prompt/" rel="nofollow">negative prompts</a>) 来获得更好的结果。',kl,be,_t='随着该领域的发展, 有越来越多经过微调的高质量的 checkpoints 用来生成不一样的风格. 在 <a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">Hub</a> 和 <a href="https://huggingface.co/spaces/huggingface-projects/diffusers-gallery" rel="nofollow">Diffusers Gallery</a> 寻找你感兴趣的一种!',Cl,he,Hl,Je,Vt='也可以尝试用新版本替换当前 pipeline 组件。让我们加载最新的 <a href="https://huggingface.co/stabilityai/stable-diffusion-2-1/tree/main/vae" rel="nofollow">autodecoder</a> 从 Stability AI 加载到 pipeline, 并生成一些图像:',Il,we,Bl,g,kt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_6.png"/>',xl,Te,Rl,Ue,Ct="用于生成图像的文本非常重要, 因此被称为 <em>提示词工程</em>。 在设计提示词工程应注意如下事项:",Xl,Ze,Ht="<li>我想生成的图像或类似图像如何存储在互联网上？</li> <li>我可以提供哪些额外的细节来引导模型朝着我想要的风格生成？</li>",zl,ge,It="考虑到这一点，让我们改进提示词，以包含颜色和更高质量的细节：",Ll,Ge,Nl,je,Bt="使用新的提示词生成一批图像:",Sl,$e,Ql,G,xt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_7.png"/>',Fl,ve,Rt="非常的令人印象深刻! Let’s tweak the second image - 把 <code>Generator</code> 的种子设置为 <code>1</code> - 添加一些关于年龄的主题文本:",Yl,We,Dl,j,Xt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_8.png"/>',El,_e,Pl,Ve,zt="在本教程中, 您学习了如何优化<code>DiffusionPipeline</code>以提高计算和内存效率，以及提高生成输出的质量. 如果你有兴趣让你的 pipeline 更快, 可以看一看以下资源:",Al,ke,Lt='<li>学习 <a href="./optimization/torch2.0">PyTorch 2.0</a> 和 <a href="https://pytorch.org/docs/stable/generated/torch.compile.html" rel="nofollow"><code>torch.compile</code></a> 可以让推理速度提高 5 - 300% . 在 A100 GPU 上, 推理速度可以提高 50% !</li> <li>如果你没法用 PyTorch 2, 我们建议你安装 <a href="./optimization/xformers">xFormers</a>。它的内存高效注意力机制（<em>memory-efficient attention mechanism</em>）与PyTorch 1.13.1配合使用，速度更快，内存消耗更少。</li> <li>其他的优化技术, 如：模型卸载（<em>model offloading</em>）, 包含在 <a href="./optimization/fp16">这份指南</a>.</li>',ql,Ce,Kl,Ie,Ol;return v=new At({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),W=new Kt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/zh/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/zh/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/zh/tensorflow/stable_diffusion.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/zh/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/zh/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/zh/tensorflow/stable_diffusion.ipynb"}]}}),_=new $({props:{title:"有效且高效的扩散",local:"有效且高效的扩散",headingTag:"h1"}}),I=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),x=new d({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIycG9ydHJhaXQlMjBwaG90byUyMG9mJTIwYSUyMG9sZCUyMHdhcnJpb3IlMjBjaGllZiUyMg==",highlighted:'prompt = <span class="hljs-string">&quot;portrait photo of a old warrior chief&quot;</span>',wrap:!1}}),R=new $({props:{title:"速度",local:"速度",headingTag:"h2"}}),z=new d({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKQ==",highlighted:'pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),N=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCk=",highlighted:`<span class="hljs-keyword">import</span> torch

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)`,wrap:!1}}),Q=new d({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),D=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),A=new d({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbXBhdGlibGVzJTBBJTVCJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19sbXNfZGlzY3JldGUuTE1TRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3VuaXBjX211bHRpc3RlcC5VbmlQQ011bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfa19kcG1fMl9kaXNjcmV0ZS5LRFBNMkRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kZWlzX211bHRpc3RlcC5ERUlTTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9kaXNjcmV0ZS5FdWxlckRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfbXVsdGlzdGVwLkRQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRwbS5ERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfc2luZ2xlc3RlcC5EUE1Tb2x2ZXJTaW5nbGVzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19rX2RwbV8yX2FuY2VzdHJhbF9kaXNjcmV0ZS5LRFBNMkFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19oZXVuX2Rpc2NyZXRlLkhldW5EaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfcG5kbS5QTkRNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9hbmNlc3RyYWxfZGlzY3JldGUuRXVsZXJBbmNlc3RyYWxEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRpbS5ERElNU2NoZWR1bGVyJTJDJTBBJTVE",highlighted:`pipeline.scheduler.compatibles
[
    diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler,
    diffusers.schedulers.scheduling_unipc_multistep.UniPCMultistepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_discrete.KDPM2DiscreteScheduler,
    diffusers.schedulers.scheduling_deis_multistep.DEISMultistepScheduler,
    diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler,
    diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler,
    diffusers.schedulers.scheduling_ddpm.DDPMScheduler,
    diffusers.schedulers.scheduling_dpmsolver_singlestep.DPMSolverSinglestepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_ancestral_discrete.KDPM2AncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_heun_discrete.HeunDiscreteScheduler,
    diffusers.schedulers.scheduling_pndm.PNDMScheduler,
    diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_ddim.DDIMScheduler,
]`,wrap:!1}}),K=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),ee=new d({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),te=new $({props:{title:"内存",local:"内存",headingTag:"h2"}}),ne=new d({props:{code:"ZGVmJTIwZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNEMSklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlMjAlM0QlMjAlNUJ0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoaSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShiYXRjaF9zaXplKSU1RCUwQSUyMCUyMCUyMCUyMHByb21wdHMlMjAlM0QlMjBiYXRjaF9zaXplJTIwKiUyMCU1QnByb21wdCU1RCUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyMCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnByb21wdCUyMiUzQSUyMHByb21wdHMlMkMlMjAlMjJnZW5lcmF0b3IlMjIlM0ElMjBnZW5lcmF0b3IlMkMlMjAlMjJudW1faW5mZXJlbmNlX3N0ZXBzJTIyJTNBJTIwbnVtX2luZmVyZW5jZV9zdGVwcyU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_inputs</span>(<span class="hljs-params">batch_size=<span class="hljs-number">1</span></span>):
    generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(i) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size)]
    prompts = batch_size * [prompt]
    num_inference_steps = <span class="hljs-number">20</span>

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;prompt&quot;</span>: prompts, <span class="hljs-string">&quot;generator&quot;</span>: generator, <span class="hljs-string">&quot;num_inference_steps&quot;</span>: num_inference_steps}`,wrap:!1}}),pe=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCoqZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNENCkpLmltYWdlcyUwQW1ha2VfaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjAyJTJDJTIwMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

images = pipeline(**get_inputs(batch_size=<span class="hljs-number">4</span>)).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),me=new d({props:{code:"cGlwZWxpbmUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCk=",highlighted:"pipeline.enable_attention_slicing()",wrap:!1}}),oe=new d({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),Me=new $({props:{title:"质量",local:"质量",headingTag:"h2"}}),de=new $({props:{title:"更好的 checkpoints",local:"更好的-checkpoints",headingTag:"h3"}}),he=new $({props:{title:"更好的 pipeline 组件",local:"更好的-pipeline-组件",headingTag:"h3"}}),we=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0wlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkLXZhZS1mdC1tc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUudmFlJTIwJTNEJTIwdmFlJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.vae = vae
images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),Te=new $({props:{title:"更好的提示词工程",local:"更好的提示词工程",headingTag:"h3"}}),Ge=new d({props:{code:"cHJvbXB0JTIwJTJCJTNEJTIwJTIyJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMiUwQXByb21wdCUyMCUyQiUzRCUyMCUyMiUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMg==",highlighted:`prompt += <span class="hljs-string">&quot;, tribal panther make up, blue on red, side profile, looking away, serious eyes&quot;</span>
prompt += <span class="hljs-string">&quot; 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>`,wrap:!1}}),$e=new d({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),We=new d({props:{code:"cHJvbXB0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnBvcnRyYWl0JTIwcGhvdG8lMjBvZiUyMHRoZSUyMG9sZGVzdCUyMHdhcnJpb3IlMjBjaGllZiUyQyUyMHRyaWJhbCUyMHBhbnRoZXIlMjBtYWtlJTIwdXAlMkMlMjBibHVlJTIwb24lMjByZWQlMkMlMjBzaWRlJTIwcHJvZmlsZSUyQyUyMGxvb2tpbmclMjBhd2F5JTJDJTIwc2VyaW91cyUyMGV5ZXMlMjA1MG1tJTIwcG9ydHJhaXQlMjBwaG90b2dyYXBoeSUyQyUyMGhhcmQlMjByaW0lMjBsaWdodGluZyUyMHBob3RvZ3JhcGh5LS1iZXRhJTIwLS1hciUyMDIlM0EzJTIwJTIwLS1iZXRhJTIwLS11cGJldGElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJwb3J0cmFpdCUyMHBob3RvJTIwb2YlMjBhJTIwb2xkJTIwd2FycmlvciUyMGNoaWVmJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnBvcnRyYWl0JTIwcGhvdG8lMjBvZiUyMGElMjB3YXJyaW9yJTIwY2hpZWYlMkMlMjB0cmliYWwlMjBwYW50aGVyJTIwbWFrZSUyMHVwJTJDJTIwYmx1ZSUyMG9uJTIwcmVkJTJDJTIwc2lkZSUyMHByb2ZpbGUlMkMlMjBsb29raW5nJTIwYXdheSUyQyUyMHNlcmlvdXMlMjBleWVzJTIwNTBtbSUyMHBvcnRyYWl0JTIwcGhvdG9ncmFwaHklMkMlMjBoYXJkJTIwcmltJTIwbGlnaHRpbmclMjBwaG90b2dyYXBoeS0tYmV0YSUyMC0tYXIlMjAyJTNBMyUyMCUyMC0tYmV0YSUyMC0tdXBiZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycG9ydHJhaXQlMjBwaG90byUyMG9mJTIwYSUyMHlvdW5nJTIwd2FycmlvciUyMGNoaWVmJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMiUyQyUwQSU1RCUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMCU1QnRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgxKSUyMGZvciUyMF8lMjBpbiUyMHJhbmdlKGxlbihwcm9tcHRzKSklNUQlMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHRzJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlMEFtYWtlX2ltYWdlX2dyaWQoaW1hZ2VzJTJDJTIwMiUyQyUyMDIp",highlighted:`prompts = [
    <span class="hljs-string">&quot;portrait photo of the oldest warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a old warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a young warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
]

generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(prompts))]
images = pipeline(prompt=prompts, generator=generator, num_inference_steps=<span class="hljs-number">25</span>).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),_e=new $({props:{title:"最后",local:"最后",headingTag:"h2"}}),Ce=new qt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/zh/stable_diffusion.md"}}),{c(){b=a("meta"),Be=i(),He=a("p"),xe=i(),m(v.$$.fragment),Re=i(),m(W.$$.fragment),Xe=i(),m(_.$$.fragment),ze=i(),V=a("p"),V.innerHTML=lt,Le=i(),k=a("p"),k.innerHTML=tt,Ne=i(),C=a("p"),C.innerHTML=st,Se=i(),H=a("p"),H.innerHTML=it,Qe=i(),m(I.$$.fragment),Fe=i(),B=a("p"),B.innerHTML=nt,Ye=i(),m(x.$$.fragment),De=i(),m(R.$$.fragment),Ee=i(),h=a("blockquote"),h.innerHTML=at,Pe=i(),X=a("p"),X.textContent=pt,Ae=i(),m(z.$$.fragment),qe=i(),L=a("p"),L.innerHTML=rt,Ke=i(),m(N.$$.fragment),Oe=i(),S=a("p"),S.textContent=mt,el=i(),m(Q.$$.fragment),ll=i(),J=a("div"),J.innerHTML=ct,tl=i(),F=a("p"),F.innerHTML=ot,sl=i(),Y=a("p"),Y.innerHTML=ft,il=i(),m(D.$$.fragment),nl=i(),w=a("div"),w.innerHTML=Mt,al=i(),E=a("p"),E.textContent=ut,pl=i(),T=a("blockquote"),T.innerHTML=dt,rl=i(),P=a("p"),P.innerHTML=yt,ml=i(),m(A.$$.fragment),cl=i(),q=a("p"),q.innerHTML=bt,ol=i(),m(K.$$.fragment),fl=i(),O=a("p"),O.innerHTML=ht,Ml=i(),m(ee.$$.fragment),ul=i(),U=a("div"),U.innerHTML=Jt,dl=i(),le=a("p"),le.textContent=wt,yl=i(),m(te.$$.fragment),bl=i(),se=a("p"),se.innerHTML=Tt,hl=i(),ie=a("p"),ie.innerHTML=Ut,Jl=i(),m(ne.$$.fragment),wl=i(),ae=a("p"),ae.innerHTML=Zt,Tl=i(),m(pe.$$.fragment),Ul=i(),re=a("p"),re.innerHTML=gt,Zl=i(),m(me.$$.fragment),gl=i(),ce=a("p"),ce.innerHTML=Gt,Gl=i(),m(oe.$$.fragment),jl=i(),Z=a("div"),Z.innerHTML=jt,$l=i(),fe=a("p"),fe.textContent=$t,vl=i(),m(Me.$$.fragment),Wl=i(),ue=a("p"),ue.innerHTML=vt,_l=i(),m(de.$$.fragment),Vl=i(),ye=a("p"),ye.innerHTML=Wt,kl=i(),be=a("p"),be.innerHTML=_t,Cl=i(),m(he.$$.fragment),Hl=i(),Je=a("p"),Je.innerHTML=Vt,Il=i(),m(we.$$.fragment),Bl=i(),g=a("div"),g.innerHTML=kt,xl=i(),m(Te.$$.fragment),Rl=i(),Ue=a("p"),Ue.innerHTML=Ct,Xl=i(),Ze=a("ul"),Ze.innerHTML=Ht,zl=i(),ge=a("p"),ge.textContent=It,Ll=i(),m(Ge.$$.fragment),Nl=i(),je=a("p"),je.textContent=Bt,Sl=i(),m($e.$$.fragment),Ql=i(),G=a("div"),G.innerHTML=xt,Fl=i(),ve=a("p"),ve.innerHTML=Rt,Yl=i(),m(We.$$.fragment),Dl=i(),j=a("div"),j.innerHTML=Xt,El=i(),m(_e.$$.fragment),Pl=i(),Ve=a("p"),Ve.innerHTML=zt,Al=i(),ke=a("ul"),ke.innerHTML=Lt,ql=i(),m(Ce.$$.fragment),Kl=i(),Ie=a("p"),this.h()},l(e){const l=Et("svelte-u9bgzb",document.head);b=p(l,"META",{name:!0,content:!0}),l.forEach(t),Be=n(e),He=p(e,"P",{}),Nt(He).forEach(t),xe=n(e),c(v.$$.fragment,e),Re=n(e),c(W.$$.fragment,e),Xe=n(e),c(_.$$.fragment,e),ze=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1v0o1kl"&&(V.innerHTML=lt),Le=n(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-leukn8"&&(k.innerHTML=tt),Ne=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-8fx6wg"&&(C.innerHTML=st),Se=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-t3ajyn"&&(H.innerHTML=it),Qe=n(e),c(I.$$.fragment,e),Fe=n(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-tpz466"&&(B.innerHTML=nt),Ye=n(e),c(x.$$.fragment,e),De=n(e),c(R.$$.fragment,e),Ee=n(e),h=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-dhfwfj"&&(h.innerHTML=at),Pe=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-140tryr"&&(X.textContent=pt),Ae=n(e),c(z.$$.fragment,e),qe=n(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1y2bzt"&&(L.innerHTML=rt),Ke=n(e),c(N.$$.fragment,e),Oe=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-4x6dr0"&&(S.textContent=mt),el=n(e),c(Q.$$.fragment,e),ll=n(e),J=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1of5nwm"&&(J.innerHTML=ct),tl=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-dxn1az"&&(F.innerHTML=ot),sl=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-qtbizy"&&(Y.innerHTML=ft),il=n(e),c(D.$$.fragment,e),nl=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1why3l7"&&(w.innerHTML=Mt),al=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-pogsc6"&&(E.textContent=ut),pl=n(e),T=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1tdgn79"&&(T.innerHTML=dt),rl=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1b7m8op"&&(P.innerHTML=yt),ml=n(e),c(A.$$.fragment,e),cl=n(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-ug0tja"&&(q.innerHTML=bt),ol=n(e),c(K.$$.fragment,e),fl=n(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1hxt66h"&&(O.innerHTML=ht),Ml=n(e),c(ee.$$.fragment,e),ul=n(e),U=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-19w49w4"&&(U.innerHTML=Jt),dl=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-uzam9p"&&(le.textContent=wt),yl=n(e),c(te.$$.fragment,e),bl=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-13ch8y2"&&(se.innerHTML=Tt),hl=n(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-cfkbaa"&&(ie.innerHTML=Ut),Jl=n(e),c(ne.$$.fragment,e),wl=n(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-15a7i1a"&&(ae.innerHTML=Zt),Tl=n(e),c(pe.$$.fragment,e),Ul=n(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1xqk7ef"&&(re.innerHTML=gt),Zl=n(e),c(me.$$.fragment,e),gl=n(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1sdpqou"&&(ce.innerHTML=Gt),Gl=n(e),c(oe.$$.fragment,e),jl=n(e),Z=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-vxa9bu"&&(Z.innerHTML=jt),$l=n(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-f1534l"&&(fe.textContent=$t),vl=n(e),c(Me.$$.fragment,e),Wl=n(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1c8v1nf"&&(ue.innerHTML=vt),_l=n(e),c(de.$$.fragment,e),Vl=n(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-p1zz72"&&(ye.innerHTML=Wt),kl=n(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-i5so0v"&&(be.innerHTML=_t),Cl=n(e),c(he.$$.fragment,e),Hl=n(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-o0zap8"&&(Je.innerHTML=Vt),Il=n(e),c(we.$$.fragment,e),Bl=n(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-610rhb"&&(g.innerHTML=kt),xl=n(e),c(Te.$$.fragment,e),Rl=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-18d69j8"&&(Ue.innerHTML=Ct),Xl=n(e),Ze=p(e,"UL",{"data-svelte-h":!0}),r(Ze)!=="svelte-1n2jyxj"&&(Ze.innerHTML=Ht),zl=n(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-60602z"&&(ge.textContent=It),Ll=n(e),c(Ge.$$.fragment,e),Nl=n(e),je=p(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-610aip"&&(je.textContent=Bt),Sl=n(e),c($e.$$.fragment,e),Ql=n(e),G=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(G)!=="svelte-n1o5lk"&&(G.innerHTML=xt),Fl=n(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1ncypu7"&&(ve.innerHTML=Rt),Yl=n(e),c(We.$$.fragment,e),Dl=n(e),j=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1lkw2bx"&&(j.innerHTML=Xt),El=n(e),c(_e.$$.fragment,e),Pl=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-o28ro3"&&(Ve.innerHTML=zt),Al=n(e),ke=p(e,"UL",{"data-svelte-h":!0}),r(ke)!=="svelte-14q6wc5"&&(ke.innerHTML=Lt),ql=n(e),c(Ce.$$.fragment,e),Kl=n(e),Ie=p(e,"P",{}),Nt(Ie).forEach(t),this.h()},h(){y(b,"name","hf:doc:metadata"),y(b,"content",es),y(h,"class","tip"),y(J,"class","flex justify-center"),y(w,"class","flex justify-center"),y(T,"class","tip"),y(U,"class","flex justify-center"),y(Z,"class","flex justify-center"),y(g,"class","flex justify-center"),y(G,"class","flex justify-center"),y(j,"class","flex justify-center")},m(e,l){Pt(document.head,b),s(e,Be,l),s(e,He,l),s(e,xe,l),o(v,e,l),s(e,Re,l),o(W,e,l),s(e,Xe,l),o(_,e,l),s(e,ze,l),s(e,V,l),s(e,Le,l),s(e,k,l),s(e,Ne,l),s(e,C,l),s(e,Se,l),s(e,H,l),s(e,Qe,l),o(I,e,l),s(e,Fe,l),s(e,B,l),s(e,Ye,l),o(x,e,l),s(e,De,l),o(R,e,l),s(e,Ee,l),s(e,h,l),s(e,Pe,l),s(e,X,l),s(e,Ae,l),o(z,e,l),s(e,qe,l),s(e,L,l),s(e,Ke,l),o(N,e,l),s(e,Oe,l),s(e,S,l),s(e,el,l),o(Q,e,l),s(e,ll,l),s(e,J,l),s(e,tl,l),s(e,F,l),s(e,sl,l),s(e,Y,l),s(e,il,l),o(D,e,l),s(e,nl,l),s(e,w,l),s(e,al,l),s(e,E,l),s(e,pl,l),s(e,T,l),s(e,rl,l),s(e,P,l),s(e,ml,l),o(A,e,l),s(e,cl,l),s(e,q,l),s(e,ol,l),o(K,e,l),s(e,fl,l),s(e,O,l),s(e,Ml,l),o(ee,e,l),s(e,ul,l),s(e,U,l),s(e,dl,l),s(e,le,l),s(e,yl,l),o(te,e,l),s(e,bl,l),s(e,se,l),s(e,hl,l),s(e,ie,l),s(e,Jl,l),o(ne,e,l),s(e,wl,l),s(e,ae,l),s(e,Tl,l),o(pe,e,l),s(e,Ul,l),s(e,re,l),s(e,Zl,l),o(me,e,l),s(e,gl,l),s(e,ce,l),s(e,Gl,l),o(oe,e,l),s(e,jl,l),s(e,Z,l),s(e,$l,l),s(e,fe,l),s(e,vl,l),o(Me,e,l),s(e,Wl,l),s(e,ue,l),s(e,_l,l),o(de,e,l),s(e,Vl,l),s(e,ye,l),s(e,kl,l),s(e,be,l),s(e,Cl,l),o(he,e,l),s(e,Hl,l),s(e,Je,l),s(e,Il,l),o(we,e,l),s(e,Bl,l),s(e,g,l),s(e,xl,l),o(Te,e,l),s(e,Rl,l),s(e,Ue,l),s(e,Xl,l),s(e,Ze,l),s(e,zl,l),s(e,ge,l),s(e,Ll,l),o(Ge,e,l),s(e,Nl,l),s(e,je,l),s(e,Sl,l),o($e,e,l),s(e,Ql,l),s(e,G,l),s(e,Fl,l),s(e,ve,l),s(e,Yl,l),o(We,e,l),s(e,Dl,l),s(e,j,l),s(e,El,l),o(_e,e,l),s(e,Pl,l),s(e,Ve,l),s(e,Al,l),s(e,ke,l),s(e,ql,l),o(Ce,e,l),s(e,Kl,l),s(e,Ie,l),Ol=!0},p:Qt,i(e){Ol||(f(v.$$.fragment,e),f(W.$$.fragment,e),f(_.$$.fragment,e),f(I.$$.fragment,e),f(x.$$.fragment,e),f(R.$$.fragment,e),f(z.$$.fragment,e),f(N.$$.fragment,e),f(Q.$$.fragment,e),f(D.$$.fragment,e),f(A.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(oe.$$.fragment,e),f(Me.$$.fragment,e),f(de.$$.fragment,e),f(he.$$.fragment,e),f(we.$$.fragment,e),f(Te.$$.fragment,e),f(Ge.$$.fragment,e),f($e.$$.fragment,e),f(We.$$.fragment,e),f(_e.$$.fragment,e),f(Ce.$$.fragment,e),Ol=!0)},o(e){M(v.$$.fragment,e),M(W.$$.fragment,e),M(_.$$.fragment,e),M(I.$$.fragment,e),M(x.$$.fragment,e),M(R.$$.fragment,e),M(z.$$.fragment,e),M(N.$$.fragment,e),M(Q.$$.fragment,e),M(D.$$.fragment,e),M(A.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(oe.$$.fragment,e),M(Me.$$.fragment,e),M(de.$$.fragment,e),M(he.$$.fragment,e),M(we.$$.fragment,e),M(Te.$$.fragment,e),M(Ge.$$.fragment,e),M($e.$$.fragment,e),M(We.$$.fragment,e),M(_e.$$.fragment,e),M(Ce.$$.fragment,e),Ol=!1},d(e){e&&(t(Be),t(He),t(xe),t(Re),t(Xe),t(ze),t(V),t(Le),t(k),t(Ne),t(C),t(Se),t(H),t(Qe),t(Fe),t(B),t(Ye),t(De),t(Ee),t(h),t(Pe),t(X),t(Ae),t(qe),t(L),t(Ke),t(Oe),t(S),t(el),t(ll),t(J),t(tl),t(F),t(sl),t(Y),t(il),t(nl),t(w),t(al),t(E),t(pl),t(T),t(rl),t(P),t(ml),t(cl),t(q),t(ol),t(fl),t(O),t(Ml),t(ul),t(U),t(dl),t(le),t(yl),t(bl),t(se),t(hl),t(ie),t(Jl),t(wl),t(ae),t(Tl),t(Ul),t(re),t(Zl),t(gl),t(ce),t(Gl),t(jl),t(Z),t($l),t(fe),t(vl),t(Wl),t(ue),t(_l),t(Vl),t(ye),t(kl),t(be),t(Cl),t(Hl),t(Je),t(Il),t(Bl),t(g),t(xl),t(Rl),t(Ue),t(Xl),t(Ze),t(zl),t(ge),t(Ll),t(Nl),t(je),t(Sl),t(Ql),t(G),t(Fl),t(ve),t(Yl),t(Dl),t(j),t(El),t(Pl),t(Ve),t(Al),t(ke),t(ql),t(Kl),t(Ie)),t(b),u(v,e),u(W,e),u(_,e),u(I,e),u(x,e),u(R,e),u(z,e),u(N,e),u(Q,e),u(D,e),u(A,e),u(K,e),u(ee,e),u(te,e),u(ne,e),u(pe,e),u(me,e),u(oe,e),u(Me,e),u(de,e),u(he,e),u(we,e),u(Te,e),u(Ge,e),u($e,e),u(We,e),u(_e,e),u(Ce,e)}}}const es='{"title":"有效且高效的扩散","local":"有效且高效的扩散","sections":[{"title":"速度","local":"速度","sections":[],"depth":2},{"title":"内存","local":"内存","sections":[],"depth":2},{"title":"质量","local":"质量","sections":[{"title":"更好的 checkpoints","local":"更好的-checkpoints","sections":[],"depth":3},{"title":"更好的 pipeline 组件","local":"更好的-pipeline-组件","sections":[],"depth":3},{"title":"更好的提示词工程","local":"更好的提示词工程","sections":[],"depth":3}],"depth":2},{"title":"最后","local":"最后","sections":[],"depth":2}],"depth":1}';function ls(et){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ps extends Yt{constructor(b){super(),Dt(this,b,ls,Ot,St,{})}}export{ps as component};
