import{s as nt,n as pt,o as rt}from"../chunks/scheduler.32f3c0d7.js";import{S as mt,i as dt,e as i,s as l,c as r,h as ut,a as n,d as a,b as o,f as it,j as m,g as p,k as $,l as ct,m as t,n as d,t as u,o as c,p as f}from"../chunks/index.a3055d2a.js";import{C as ft,H as Ie,E as gt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.bfae11ef.js";import{C as g}from"../chunks/CodeBlock.e9930956.js";import{D as ht}from"../chunks/DocNotebookDropdown.03988dd0.js";function bt(ua){let h,Be,Pe,Ne,T,Xe,U,De,_,Re,x,ca="Modelos de difusão são treinados para remover o ruído Gaussiano aleatório passo a passo para gerar uma amostra de interesse, como uma imagem ou áudio. Isso despertou um tremendo interesse em IA generativa, e você provavelmente já viu exemplos de imagens geradas por difusão na internet. 🧨 Diffusers é uma biblioteca que visa tornar os modelos de difusão amplamente acessíveis a todos.",Ee,C,fa="Seja você um desenvolvedor ou um usuário, esse tour rápido irá introduzir você ao 🧨 Diffusers e ajudar você a começar a gerar rapidamente! Há três componentes principais da biblioteca para conhecer:",Ye,q,ga='<li>O <code>DiffusionPipeline</code> é uma classe de alto nível de ponta a ponta desenhada para gerar rapidamente amostras de modelos de difusão pré-treinados para inferência.</li> <li><a href="./api/models">Modelos</a> pré-treinados populares e módulos que podem ser usados como blocos de construção para criar sistemas de difusão.</li> <li>Vários <a href="./api/schedulers/overview">Agendadores</a> diferentes - algoritmos que controlam como o ruído é adicionado para treinamento, e como gerar imagens sem o ruído durante a inferência.</li>',Ae,J,ha="Esse tour rápido mostrará como usar o <code>DiffusionPipeline</code> para inferência, e então mostrará como combinar um modelo e um agendador para replicar o que está acontecendo dentro do <code>DiffusionPipeline</code>.",Qe,b,ba='<p>Esse tour rápido é uma versão simplificada da introdução 🧨 Diffusers <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/diffusers_intro.ipynb" rel="nofollow">notebook</a> para ajudar você a começar rápido. Se você quer aprender mais sobre o objetivo do 🧨 Diffusers, filosofia de design, e detalhes adicionais sobre a API principal, veja o notebook!</p>',Fe,Z,Ma="Antes de começar, certifique-se de ter todas as bibliotecas necessárias instaladas:",Ke,k,Oe,G,ya='<li><a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate</a> acelera o carregamento do modelo para geração e treinamento.</li> <li><a href="https://huggingface.co/docs/transformers/index" rel="nofollow">🤗 Transformers</a> é necessário para executar os modelos mais populares de difusão, como o <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a>.</li>',es,W,ss,H,ja='O <code>DiffusionPipeline</code> é a forma mais fácil de usar um sistema de difusão pré-treinado para geração. É um sistema de ponta a ponta contendo o modelo e o agendador. Você pode usar o <code>DiffusionPipeline</code> pronto para muitas tarefas. Dê uma olhada na tabela abaixo para algumas tarefas suportadas, e para uma lista completa de tarefas suportadas, veja a tabela <a href="./api/pipelines/overview#diffusers-summary">Resumo do 🧨 Diffusers</a>.',as,L,va='<thead><tr><th><strong>Tarefa</strong></th> <th><strong>Descrição</strong></th> <th><strong>Pipeline</strong></th></tr></thead> <tbody><tr><td>Unconditional Image Generation</td> <td>gera uma imagem a partir do ruído Gaussiano</td> <td><a href="./using-diffusers/unconditional_image_generation">unconditional_image_generation</a></td></tr> <tr><td>Text-Guided Image Generation</td> <td>gera uma imagem a partir de um prompt de texto</td> <td><a href="./using-diffusers/conditional_image_generation">conditional_image_generation</a></td></tr> <tr><td>Text-Guided Image-to-Image Translation</td> <td>adapta uma imagem guiada por um prompt de texto</td> <td><a href="./using-diffusers/img2img">img2img</a></td></tr> <tr><td>Text-Guided Image-Inpainting</td> <td>preenche a parte da máscara da imagem, dado a imagem, a máscara e o prompt de texto</td> <td><a href="./using-diffusers/inpaint">inpaint</a></td></tr> <tr><td>Text-Guided Depth-to-Image Translation</td> <td>adapta as partes de uma imagem guiada por um prompt de texto enquanto preserva a estrutura por estimativa de profundidade</td> <td><a href="./using-diffusers/depth2img">depth2img</a></td></tr></tbody>',ts,z,wa=`Comece criando uma instância do <code>DiffusionPipeline</code> e especifique qual checkpoint do pipeline você gostaria de baixar.
Você pode usar o <code>DiffusionPipeline</code> para qualquer <a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">checkpoint</a> armazenado no Hugging Face Hub.
Nesse quicktour, você carregará o checkpoint <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5</code></a> para geração de texto para imagem.`,ls,M,$a='<p>Para os modelos de <a href="https://huggingface.co/CompVis/stable-diffusion" rel="nofollow">Stable Diffusion</a>, por favor leia cuidadosamente a <a href="https://huggingface.co/spaces/CompVis/stable-diffusion-license" rel="nofollow">licença</a> primeiro antes de rodar o modelo. 🧨 Diffusers implementa uma verificação de segurança: <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow"><code>safety_checker</code></a> para prevenir conteúdo ofensivo ou nocivo, mas as capacidades de geração de imagem aprimorada do modelo podem ainda produzir conteúdo potencialmente nocivo.</p>',os,V,Ta="Para carregar o modelo com o método <code>from_pretrained()</code>:",is,I,ns,P,Ua="O <code>DiffusionPipeline</code> baixa e armazena em cache todos os componentes de modelagem, tokenização, e agendamento. Você verá que o pipeline do Stable Diffusion é composto pelo <code>UNet2DConditionModel</code> e <code>PNDMScheduler</code> entre outras coisas:",ps,S,rs,B,_a=`Nós fortemente recomendamos rodar o pipeline em uma placa de vídeo, pois o modelo consiste em aproximadamente 1.4 bilhões de parâmetros.
Você pode mover o objeto gerador para uma placa de vídeo, assim como você faria no PyTorch:`,ms,N,ds,X,xa='Agora você pode passar o prompt de texto para o <code>pipeline</code> para gerar uma imagem, e então acessar a imagem sem ruído. Por padrão, a saída da imagem é embrulhada em um objeto <a href="https://pillow.readthedocs.io/en/stable/reference/Image.html?highlight=image#the-image-class" rel="nofollow"><code>PIL.Image</code></a>.',us,D,cs,y,Ca='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/image_of_squirrel_painting.png"/>',fs,R,qa="Salve a imagem chamando o <code>save</code>:",gs,E,hs,Y,bs,A,Ja="Você também pode utilizar o pipeline localmente. A única diferença é que você precisa baixar os pesos primeiro:",Ms,Q,ys,F,Za="Assim carregue os pesos salvos no pipeline:",js,K,vs,O,ka="Agora você pode rodar o pipeline como você faria na seção acima.",ws,ee,$s,se,Ga="Agendadores diferentes tem diferentes velocidades de retirar o ruído e compensações de qualidade. A melhor forma de descobrir qual funciona melhor para você é testar eles! Uma das principais características do 🧨 Diffusers é permitir que você troque facilmente entre agendadores. Por exemplo, para substituir o <code>PNDMScheduler</code> padrão com o <code>EulerDiscreteScheduler</code>, carregue ele com o método <code>from_config()</code>:",Ts,ae,Us,te,Wa="Tente gerar uma imagem com o novo agendador e veja se você nota alguma diferença!",_s,le,Ha="Na próxima seção, você irá dar uma olhada mais de perto nos componentes - o modelo e o agendador - que compõe o <code>DiffusionPipeline</code> e aprender como usar esses componentes para gerar uma imagem de um gato.",xs,oe,Cs,ie,La='A maioria dos modelos recebe uma amostra de ruído, e em cada <em>timestep</em> ele prevê o <em>noise residual</em> (outros modelos aprendem a prever a amostra anterior diretamente ou a velocidade ou <a href="https://github.com/huggingface/diffusers/blob/5e5ce13e2f89ac45a0066cb3f369462a3cf1d9ef/src/diffusers/schedulers/scheduling_ddim.py#L110" rel="nofollow"><code>v-prediction</code></a>), a diferença entre uma imagem menos com ruído e a imagem de entrada. Você pode misturar e combinar modelos para criar outros sistemas de difusão.',qs,ne,za="Modelos são inicializados com o método <code>from_pretrained()</code> que também armazena em cache localmente os pesos do modelo para que seja mais rápido na próxima vez que você carregar o modelo. Para o tour rápido, você irá carregar o <code>UNet2DModel</code>, um modelo básico de geração de imagem incondicional com um checkpoint treinado em imagens de gato:",Js,pe,Zs,re,Va="Para acessar os parâmetros do modelo, chame <code>model.config</code>:",ks,me,Gs,de,Ia="A configuração do modelo é um dicionário 🧊 congelado 🧊, o que significa que esses parâmetros não podem ser mudados depois que o modelo é criado. Isso é intencional e garante que os parâmetros usados para definir a arquitetura do modelo no início permaneçam os mesmos, enquanto outros parâmetros ainda podem ser ajustados durante a geração.",Ws,ue,Pa="Um dos parâmetros mais importantes são:",Hs,ce,Sa="<li><code>sample_size</code>: a dimensão da altura e largura da amostra de entrada.</li> <li><code>in_channels</code>: o número de canais de entrada da amostra de entrada.</li> <li><code>down_block_types</code> e <code>up_block_types</code>: o tipo de blocos de downsampling e upsampling usados para criar a arquitetura UNet.</li> <li><code>block_out_channels</code>: o número de canais de saída dos blocos de downsampling; também utilizado como uma order reversa do número de canais de entrada dos blocos de upsampling.</li> <li><code>layers_per_block</code>: o número de blocks ResNet presentes em cada block UNet.</li>",Ls,fe,Ba="Para usar o modelo para geração, crie a forma da imagem com ruído Gaussiano aleatório. Deve ter um eixo <code>batch</code> porque o modelo pode receber múltiplos ruídos aleatórios, um eixo <code>channel</code> correspondente ao número de canais de entrada, e um eixo <code>sample_size</code> para a altura e largura da imagem:",zs,ge,Vs,he,Na="Para geração, passe a imagem com ruído para o modelo e um <code>timestep</code>. O <code>timestep</code> indica o quão ruidosa a imagem de entrada é, com mais ruído no início e menos no final. Isso ajuda o modelo a determinar sua posição no processo de difusão, se está mais perto do início ou do final. Use o método <code>sample</code> para obter a saída do modelo:",Is,be,Ps,Me,Xa="Para geração de exemplos reais, você precisará de um agendador para guiar o processo de retirada do ruído. Na próxima seção, você irá aprender como acoplar um modelo com um agendador.",Ss,ye,Bs,je,Da="Agendadores gerenciam a retirada do ruído de uma amostra ruidosa para uma amostra menos ruidosa dado a saída do modelo - nesse caso, é o <code>noisy_residual</code>.",Ns,j,Ra="<p>🧨 Diffusers é uma caixa de ferramentas para construir sistemas de difusão. Enquanto o <code>DiffusionPipeline</code> é uma forma conveniente de começar com um sistema de difusão pré-construído, você também pode escolher seus próprios modelos e agendadores separadamente para construir um sistema de difusão personalizado.</p>",Xs,ve,Ea="Para o tour rápido, você irá instanciar o <code>DDPMScheduler</code> com o método <code>from_config()</code>:",Ds,we,Rs,v,Ya="<p>💡 Perceba como o agendador é instanciado de uma configuração. Diferentemente de um modelo, um agendador não tem pesos treináveis e é livre de parâmetros!</p>",Es,$e,Aa="Um dos parâmetros mais importante são:",Ys,Te,Qa="<li><code>num_train_timesteps</code>: o tamanho do processo de retirar ruído ou em outras palavras, o número de <em>timesteps</em> necessários para o processo de ruídos Gausianos aleatórios dentro de uma amostra de dados.</li> <li><code>beta_schedule</code>: o tipo de agendados de ruído para o uso de geração e treinamento.</li> <li><code>beta_start</code> e <code>beta_end</code>: para começar e terminar os valores de ruído para o agendador de ruído.</li>",As,Ue,Fa="Para predizer uma imagem com um pouco menos de ruído, passe o seguinte para o método do agendador <code>step()</code>: saída do modelo, <code>timestep</code>, e a atual <code>amostra</code>.",Qs,_e,Fs,xe,Ka="O <code>less_noisy_sample</code> pode ser passado para o próximo <code>timestep</code> onde ele ficará ainda com menos ruído! Vamos juntar tudo agora e visualizar o processo inteiro de retirada de ruído.",Ks,Ce,Oa="Comece, criando a função que faça o pós-processamento e mostre a imagem sem ruído como uma <code>PIL.Image</code>:",Os,qe,ea,Je,et="Para acelerar o processo de retirada de ruído, mova a entrada e o modelo para uma GPU:",sa,Ze,aa,ke,st="Agora, crie um loop de retirada de ruído que prediz o residual da amostra menos ruidosa, e computa a amostra menos ruidosa com o agendador:",ta,Ge,la,We,at="Sente-se e assista o gato ser gerado do nada além de ruído! 😻",oa,w,tt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/diffusion-quicktour.png"/>',ia,He,na,Le,lt="Esperamos que você tenha gerado algumas imagens legais com o 🧨 Diffusers neste tour rápido! Para suas próximas etapas, você pode",pa,ze,ot='<li>Treine ou faça a configuração fina de um modelo para gerar suas próprias imagens no tutorial de <a href="./tutorials/basic_training">treinamento</a>.</li> <li>Veja exemplos oficiais e da comunidade de <a href="https://github.com/huggingface/diffusers/tree/main/examples#-diffusers-examples" rel="nofollow">scripts de treinamento ou configuração fina</a> para os mais variados casos de uso.</li> <li>Aprenda sobre como carregar, acessar, mudar e comparar agendadores no guia <a href="./using-diffusers/schedulers">Usando diferentes agendadores</a>.</li> <li>Explore engenharia de prompt, otimizações de velocidade e memória, e dicas e truques para gerar imagens de maior qualidade com o guia <a href="./stable_diffusion">Stable Diffusion</a>.</li> <li>Se aprofunde em acelerar 🧨 Diffusers com guias sobre <a href="./optimization/fp16">PyTorch otimizado em uma GPU</a>, e guias de inferência para rodar <a href="./optimization/mps">Stable Diffusion em Apple Silicon (M1/M2)</a> e <a href="./optimization/onnx">ONNX Runtime</a>.</li>',ra,Ve,ma,Se,da;return T=new ft({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new ht({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/pt/quicktour.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/pt/pytorch/quicktour.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/pt/tensorflow/quicktour.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/pt/quicktour.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/pt/pytorch/quicktour.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/pt/tensorflow/quicktour.ipynb"}]}}),_=new Ie({props:{title:"Tour rápido",local:"tour-rápido",headingTag:"h1"}}),k=new g({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLS11cGdyYWRlJTIwZGlmZnVzZXJzJTIwYWNjZWxlcmF0ZSUyMHRyYW5zZm9ybWVycw==",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install --upgrade diffusers accelerate transformers</span>`,wrap:!1}}),W=new Ie({props:{title:"DiffusionPipeline",local:"diffusionpipeline",headingTag:"h2"}}),I=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),S=new g({props:{code:"cGlwZWxpbmU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline
StableDiffusionPipeline {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.13.1&quot;</span>,
  ...,
  <span class="hljs-string">&quot;scheduler&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  ],
  ...,
  <span class="hljs-string">&quot;unet&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  ],
  <span class="hljs-string">&quot;vae&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  ]
}`,wrap:!1}}),N=new g({props:{code:"cGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),D=new g({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJBbiUyMGltYWdlJTIwb2YlMjBhJTIwc3F1aXJyZWwlMjBpbiUyMFBpY2Fzc28lMjBzdHlsZSUyMikuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipeline(<span class="hljs-string">&quot;An image of a squirrel in Picasso style&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),E=new g({props:{code:"aW1hZ2Uuc2F2ZSglMjJpbWFnZV9vZl9zcXVpcnJlbF9wYWludGluZy5wbmclMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;image_of_squirrel_painting.png&quot;</span>)',wrap:!1}}),Y=new Ie({props:{title:"Pipeline local",local:"pipeline-local",headingTag:"h3"}}),Q=new g({props:{code:"IWdpdCUyMGxmcyUyMGluc3RhbGwlMEEhZ2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01",highlighted:`!git lfs install
!git <span class="hljs-built_in">clone</span> https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5`,wrap:!1}}),K=new g({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)',wrap:!1}}),ee=new Ie({props:{title:"Troca dos agendadores",local:"troca-dos-agendadores",headingTag:"h3"}}),ae=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = EulerDiscreteScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),oe=new Ie({props:{title:"Modelos",local:"modelos",headingTag:"h2"}}),pe=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiUwQW1vZGVsJTIwJTNEJTIwVU5ldDJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),me=new g({props:{code:"bW9kZWwuY29uZmln",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.config',wrap:!1}}),ge=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5tYW51YWxfc2VlZCgwKSUwQSUwQW5vaXN5X3NhbXBsZSUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjBtb2RlbC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBtb2RlbC5jb25maWcuc2FtcGxlX3NpemUlMkMlMjBtb2RlbC5jb25maWcuc2FtcGxlX3NpemUpJTBBbm9pc3lfc2FtcGxlLnNoYXBl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample = torch.randn(<span class="hljs-number">1</span>, model.config.in_channels, model.config.sample_size, model.config.sample_size)
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample.shape
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>])`,wrap:!1}}),be=new g({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG5vaXN5X3Jlc2lkdWFsJTIwJTNEJTIwbW9kZWwoc2FtcGxlJTNEbm9pc3lfc2FtcGxlJTJDJTIwdGltZXN0ZXAlM0QyKS5zYW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    noisy_residual = model(sample=noisy_sample, timestep=<span class="hljs-number">2</span>).sample`,wrap:!1}}),ye=new Ie({props:{title:"Agendadores",local:"agendadores",headingTag:"h2"}}),we=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fY29uZmlnKHJlcG9faWQpJTBBc2NoZWR1bGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDPMScheduler.from_config(repo_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler
DDPMScheduler {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;DDPMScheduler&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.13.1&quot;</span>,
  <span class="hljs-string">&quot;beta_end&quot;</span>: <span class="hljs-number">0.02</span>,
  <span class="hljs-string">&quot;beta_schedule&quot;</span>: <span class="hljs-string">&quot;linear&quot;</span>,
  <span class="hljs-string">&quot;beta_start&quot;</span>: <span class="hljs-number">0.0001</span>,
  <span class="hljs-string">&quot;clip_sample&quot;</span>: true,
  <span class="hljs-string">&quot;clip_sample_range&quot;</span>: <span class="hljs-number">1.0</span>,
  <span class="hljs-string">&quot;num_train_timesteps&quot;</span>: <span class="hljs-number">1000</span>,
  <span class="hljs-string">&quot;prediction_type&quot;</span>: <span class="hljs-string">&quot;epsilon&quot;</span>,
  <span class="hljs-string">&quot;trained_betas&quot;</span>: null,
  <span class="hljs-string">&quot;variance_type&quot;</span>: <span class="hljs-string">&quot;fixed_small&quot;</span>
}`,wrap:!1}}),_e=new g({props:{code:"bGVzc19ub2lzeV9zYW1wbGUlMjAlM0QlMjBzY2hlZHVsZXIuc3RlcChtb2RlbF9vdXRwdXQlM0Rub2lzeV9yZXNpZHVhbCUyQyUyMHRpbWVzdGVwJTNEMiUyQyUyMHNhbXBsZSUzRG5vaXN5X3NhbXBsZSkucHJldl9zYW1wbGUlMEFsZXNzX25vaXN5X3NhbXBsZS5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>less_noisy_sample = scheduler.step(model_output=noisy_residual, timestep=<span class="hljs-number">2</span>, sample=noisy_sample).prev_sample
<span class="hljs-meta">&gt;&gt;&gt; </span>less_noisy_sample.shape`,wrap:!1}}),qe=new g({props:{code:"aW1wb3J0JTIwUElMLkltYWdlJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwZGlzcGxheV9zYW1wbGUoc2FtcGxlJTJDJTIwaSklM0ElMEElMjAlMjAlMjAlMjBpbWFnZV9wcm9jZXNzZWQlMjAlM0QlMjBzYW1wbGUuY3B1KCkucGVybXV0ZSgwJTJDJTIwMiUyQyUyMDMlMkMlMjAxKSUwQSUyMCUyMCUyMCUyMGltYWdlX3Byb2Nlc3NlZCUyMCUzRCUyMChpbWFnZV9wcm9jZXNzZWQlMjAlMkIlMjAxLjApJTIwKiUyMDEyNy41JTBBJTIwJTIwJTIwJTIwaW1hZ2VfcHJvY2Vzc2VkJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc2VkLm51bXB5KCkuYXN0eXBlKG5wLnVpbnQ4KSUwQSUwQSUyMCUyMCUyMCUyMGltYWdlX3BpbCUyMCUzRCUyMFBJTC5JbWFnZS5mcm9tYXJyYXkoaW1hZ2VfcHJvY2Vzc2VkJTVCMCU1RCklMEElMjAlMjAlMjAlMjBkaXNwbGF5KGYlMjJJbWFnZSUyMGF0JTIwc3RlcCUyMCU3QmklN0QlMjIpJTBBJTIwJTIwJTIwJTIwZGlzcGxheShpbWFnZV9waWwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL.Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">display_sample</span>(<span class="hljs-params">sample, i</span>):
<span class="hljs-meta">... </span>    image_processed = sample.cpu().permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    image_processed = (image_processed + <span class="hljs-number">1.0</span>) * <span class="hljs-number">127.5</span>
<span class="hljs-meta">... </span>    image_processed = image_processed.numpy().astype(np.uint8)

<span class="hljs-meta">... </span>    image_pil = PIL.Image.fromarray(image_processed[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>    display(<span class="hljs-string">f&quot;Image at step <span class="hljs-subst">{i}</span>&quot;</span>)
<span class="hljs-meta">... </span>    display(image_pil)`,wrap:!1}}),Ze=new g({props:{code:"bW9kZWwudG8oJTIyY3VkYSUyMiklMEFub2lzeV9zYW1wbGUlMjAlM0QlMjBub2lzeV9zYW1wbGUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample = noisy_sample.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Ge=new g({props:{code:"aW1wb3J0JTIwdHFkbSUwQSUwQXNhbXBsZSUyMCUzRCUyMG5vaXN5X3NhbXBsZSUwQSUwQWZvciUyMGklMkMlMjB0JTIwaW4lMjBlbnVtZXJhdGUodHFkbS50cWRtKHNjaGVkdWxlci50aW1lc3RlcHMpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMDEuJTIwcHJlZGljdCUyMG5vaXNlJTIwcmVzaWR1YWwlMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWwlMjAlM0QlMjBtb2RlbChzYW1wbGUlMkMlMjB0KS5zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAyLiUyMGNvbXB1dGUlMjBsZXNzJTIwbm9pc3klMjBpbWFnZSUyMGFuZCUyMHNldCUyMHhfdCUyMC0lM0UlMjB4X3QtMSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKHJlc2lkdWFsJTJDJTIwdCUyQyUyMHNhbXBsZSkucHJldl9zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAzLiUyMG9wdGlvbmFsbHklMjBsb29rJTIwYXQlMjBpbWFnZSUwQSUyMCUyMCUyMCUyMGlmJTIwKGklMjAlMkIlMjAxKSUyMCUyNSUyMDUwJTIwJTNEJTNEJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc3BsYXlfc2FtcGxlKHNhbXBsZSUyQyUyMGklMjAlMkIlMjAxKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>sample = noisy_sample

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm.tqdm(scheduler.timesteps)):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># 1. predict noise residual</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        residual = model(sample, t).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># 2. compute less noisy image and set x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    sample = scheduler.step(residual, t, sample).prev_sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># 3. optionally look at image</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> (i + <span class="hljs-number">1</span>) % <span class="hljs-number">50</span> == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>        display_sample(sample, i + <span class="hljs-number">1</span>)`,wrap:!1}}),He=new Ie({props:{title:"Próximos passos",local:"próximos-passos",headingTag:"h2"}}),Ve=new gt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/pt/quicktour.md"}}),{c(){h=i("meta"),Be=l(),Pe=i("p"),Ne=l(),r(T.$$.fragment),Xe=l(),r(U.$$.fragment),De=l(),r(_.$$.fragment),Re=l(),x=i("p"),x.textContent=ca,Ee=l(),C=i("p"),C.textContent=fa,Ye=l(),q=i("ul"),q.innerHTML=ga,Ae=l(),J=i("p"),J.innerHTML=ha,Qe=l(),b=i("blockquote"),b.innerHTML=ba,Fe=l(),Z=i("p"),Z.textContent=Ma,Ke=l(),r(k.$$.fragment),Oe=l(),G=i("ul"),G.innerHTML=ya,es=l(),r(W.$$.fragment),ss=l(),H=i("p"),H.innerHTML=ja,as=l(),L=i("table"),L.innerHTML=va,ts=l(),z=i("p"),z.innerHTML=wa,ls=l(),M=i("blockquote"),M.innerHTML=$a,os=l(),V=i("p"),V.innerHTML=Ta,is=l(),r(I.$$.fragment),ns=l(),P=i("p"),P.innerHTML=Ua,ps=l(),r(S.$$.fragment),rs=l(),B=i("p"),B.textContent=_a,ms=l(),r(N.$$.fragment),ds=l(),X=i("p"),X.innerHTML=xa,us=l(),r(D.$$.fragment),cs=l(),y=i("div"),y.innerHTML=Ca,fs=l(),R=i("p"),R.innerHTML=qa,gs=l(),r(E.$$.fragment),hs=l(),r(Y.$$.fragment),bs=l(),A=i("p"),A.textContent=Ja,Ms=l(),r(Q.$$.fragment),ys=l(),F=i("p"),F.textContent=Za,js=l(),r(K.$$.fragment),vs=l(),O=i("p"),O.textContent=ka,ws=l(),r(ee.$$.fragment),$s=l(),se=i("p"),se.innerHTML=Ga,Ts=l(),r(ae.$$.fragment),Us=l(),te=i("p"),te.textContent=Wa,_s=l(),le=i("p"),le.innerHTML=Ha,xs=l(),r(oe.$$.fragment),Cs=l(),ie=i("p"),ie.innerHTML=La,qs=l(),ne=i("p"),ne.innerHTML=za,Js=l(),r(pe.$$.fragment),Zs=l(),re=i("p"),re.innerHTML=Va,ks=l(),r(me.$$.fragment),Gs=l(),de=i("p"),de.textContent=Ia,Ws=l(),ue=i("p"),ue.textContent=Pa,Hs=l(),ce=i("ul"),ce.innerHTML=Sa,Ls=l(),fe=i("p"),fe.innerHTML=Ba,zs=l(),r(ge.$$.fragment),Vs=l(),he=i("p"),he.innerHTML=Na,Is=l(),r(be.$$.fragment),Ps=l(),Me=i("p"),Me.textContent=Xa,Ss=l(),r(ye.$$.fragment),Bs=l(),je=i("p"),je.innerHTML=Da,Ns=l(),j=i("blockquote"),j.innerHTML=Ra,Xs=l(),ve=i("p"),ve.innerHTML=Ea,Ds=l(),r(we.$$.fragment),Rs=l(),v=i("blockquote"),v.innerHTML=Ya,Es=l(),$e=i("p"),$e.textContent=Aa,Ys=l(),Te=i("ul"),Te.innerHTML=Qa,As=l(),Ue=i("p"),Ue.innerHTML=Fa,Qs=l(),r(_e.$$.fragment),Fs=l(),xe=i("p"),xe.innerHTML=Ka,Ks=l(),Ce=i("p"),Ce.innerHTML=Oa,Os=l(),r(qe.$$.fragment),ea=l(),Je=i("p"),Je.textContent=et,sa=l(),r(Ze.$$.fragment),aa=l(),ke=i("p"),ke.textContent=st,ta=l(),r(Ge.$$.fragment),la=l(),We=i("p"),We.textContent=at,oa=l(),w=i("div"),w.innerHTML=tt,ia=l(),r(He.$$.fragment),na=l(),Le=i("p"),Le.textContent=lt,pa=l(),ze=i("ul"),ze.innerHTML=ot,ra=l(),r(Ve.$$.fragment),ma=l(),Se=i("p"),this.h()},l(e){const s=ut("svelte-u9bgzb",document.head);h=n(s,"META",{name:!0,content:!0}),s.forEach(a),Be=o(e),Pe=n(e,"P",{}),it(Pe).forEach(a),Ne=o(e),m(T.$$.fragment,e),Xe=o(e),m(U.$$.fragment,e),De=o(e),m(_.$$.fragment,e),Re=o(e),x=n(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-5d3hlg"&&(x.textContent=ca),Ee=o(e),C=n(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-tkfmfk"&&(C.textContent=fa),Ye=o(e),q=n(e,"UL",{"data-svelte-h":!0}),p(q)!=="svelte-1bp7yfw"&&(q.innerHTML=ga),Ae=o(e),J=n(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-sqpmf8"&&(J.innerHTML=ha),Qe=o(e),b=n(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-mhj3h4"&&(b.innerHTML=ba),Fe=o(e),Z=n(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-16jlltr"&&(Z.textContent=Ma),Ke=o(e),m(k.$$.fragment,e),Oe=o(e),G=n(e,"UL",{"data-svelte-h":!0}),p(G)!=="svelte-l49o4a"&&(G.innerHTML=ya),es=o(e),m(W.$$.fragment,e),ss=o(e),H=n(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1fm3zhc"&&(H.innerHTML=ja),as=o(e),L=n(e,"TABLE",{"data-svelte-h":!0}),p(L)!=="svelte-1wldcuj"&&(L.innerHTML=va),ts=o(e),z=n(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1ywycy7"&&(z.innerHTML=wa),ls=o(e),M=n(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(M)!=="svelte-eq1ac4"&&(M.innerHTML=$a),os=o(e),V=n(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-14st4zt"&&(V.innerHTML=Ta),is=o(e),m(I.$$.fragment,e),ns=o(e),P=n(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-15d6klf"&&(P.innerHTML=Ua),ps=o(e),m(S.$$.fragment,e),rs=o(e),B=n(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1lh10u2"&&(B.textContent=_a),ms=o(e),m(N.$$.fragment,e),ds=o(e),X=n(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1fzeyvx"&&(X.innerHTML=xa),us=o(e),m(D.$$.fragment,e),cs=o(e),y=n(e,"DIV",{class:!0,"data-svelte-h":!0}),p(y)!=="svelte-6cjtp1"&&(y.innerHTML=Ca),fs=o(e),R=n(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1qpz3ys"&&(R.innerHTML=qa),gs=o(e),m(E.$$.fragment,e),hs=o(e),m(Y.$$.fragment,e),bs=o(e),A=n(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-11z96s9"&&(A.textContent=Ja),Ms=o(e),m(Q.$$.fragment,e),ys=o(e),F=n(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-nca5xy"&&(F.textContent=Za),js=o(e),m(K.$$.fragment,e),vs=o(e),O=n(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-18fxe39"&&(O.textContent=ka),ws=o(e),m(ee.$$.fragment,e),$s=o(e),se=n(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1bdwzfu"&&(se.innerHTML=Ga),Ts=o(e),m(ae.$$.fragment,e),Us=o(e),te=n(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-rjqaf3"&&(te.textContent=Wa),_s=o(e),le=n(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-yp9if5"&&(le.innerHTML=Ha),xs=o(e),m(oe.$$.fragment,e),Cs=o(e),ie=n(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-cl1ldd"&&(ie.innerHTML=La),qs=o(e),ne=n(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-onulph"&&(ne.innerHTML=za),Js=o(e),m(pe.$$.fragment,e),Zs=o(e),re=n(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-qcoyrg"&&(re.innerHTML=Va),ks=o(e),m(me.$$.fragment,e),Gs=o(e),de=n(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-i890oq"&&(de.textContent=Ia),Ws=o(e),ue=n(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1wzn7ma"&&(ue.textContent=Pa),Hs=o(e),ce=n(e,"UL",{"data-svelte-h":!0}),p(ce)!=="svelte-o5msyb"&&(ce.innerHTML=Sa),Ls=o(e),fe=n(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-obxecp"&&(fe.innerHTML=Ba),zs=o(e),m(ge.$$.fragment,e),Vs=o(e),he=n(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1qo9t3f"&&(he.innerHTML=Na),Is=o(e),m(be.$$.fragment,e),Ps=o(e),Me=n(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1ljqqs3"&&(Me.textContent=Xa),Ss=o(e),m(ye.$$.fragment,e),Bs=o(e),je=n(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1c3rc74"&&(je.innerHTML=Da),Ns=o(e),j=n(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-kw0jm4"&&(j.innerHTML=Ra),Xs=o(e),ve=n(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-7pekzf"&&(ve.innerHTML=Ea),Ds=o(e),m(we.$$.fragment,e),Rs=o(e),v=n(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-1o3oicu"&&(v.innerHTML=Ya),Es=o(e),$e=n(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-kydn7r"&&($e.textContent=Aa),Ys=o(e),Te=n(e,"UL",{"data-svelte-h":!0}),p(Te)!=="svelte-1xnw77s"&&(Te.innerHTML=Qa),As=o(e),Ue=n(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-3wttzd"&&(Ue.innerHTML=Fa),Qs=o(e),m(_e.$$.fragment,e),Fs=o(e),xe=n(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1tpggdq"&&(xe.innerHTML=Ka),Ks=o(e),Ce=n(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1xrm0cs"&&(Ce.innerHTML=Oa),Os=o(e),m(qe.$$.fragment,e),ea=o(e),Je=n(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-19fphdr"&&(Je.textContent=et),sa=o(e),m(Ze.$$.fragment,e),aa=o(e),ke=n(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1ff49gu"&&(ke.textContent=st),ta=o(e),m(Ge.$$.fragment,e),la=o(e),We=n(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1tdl2pq"&&(We.textContent=at),oa=o(e),w=n(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-1yzsrw6"&&(w.innerHTML=tt),ia=o(e),m(He.$$.fragment,e),na=o(e),Le=n(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-tfhhyg"&&(Le.textContent=lt),pa=o(e),ze=n(e,"UL",{"data-svelte-h":!0}),p(ze)!=="svelte-1r1xmc2"&&(ze.innerHTML=ot),ra=o(e),m(Ve.$$.fragment,e),ma=o(e),Se=n(e,"P",{}),it(Se).forEach(a),this.h()},h(){$(h,"name","hf:doc:metadata"),$(h,"content",Mt),$(b,"class","tip"),$(M,"class","warning"),$(y,"class","flex justify-center"),$(j,"class","tip"),$(v,"class","tip"),$(w,"class","flex justify-center")},m(e,s){ct(document.head,h),t(e,Be,s),t(e,Pe,s),t(e,Ne,s),d(T,e,s),t(e,Xe,s),d(U,e,s),t(e,De,s),d(_,e,s),t(e,Re,s),t(e,x,s),t(e,Ee,s),t(e,C,s),t(e,Ye,s),t(e,q,s),t(e,Ae,s),t(e,J,s),t(e,Qe,s),t(e,b,s),t(e,Fe,s),t(e,Z,s),t(e,Ke,s),d(k,e,s),t(e,Oe,s),t(e,G,s),t(e,es,s),d(W,e,s),t(e,ss,s),t(e,H,s),t(e,as,s),t(e,L,s),t(e,ts,s),t(e,z,s),t(e,ls,s),t(e,M,s),t(e,os,s),t(e,V,s),t(e,is,s),d(I,e,s),t(e,ns,s),t(e,P,s),t(e,ps,s),d(S,e,s),t(e,rs,s),t(e,B,s),t(e,ms,s),d(N,e,s),t(e,ds,s),t(e,X,s),t(e,us,s),d(D,e,s),t(e,cs,s),t(e,y,s),t(e,fs,s),t(e,R,s),t(e,gs,s),d(E,e,s),t(e,hs,s),d(Y,e,s),t(e,bs,s),t(e,A,s),t(e,Ms,s),d(Q,e,s),t(e,ys,s),t(e,F,s),t(e,js,s),d(K,e,s),t(e,vs,s),t(e,O,s),t(e,ws,s),d(ee,e,s),t(e,$s,s),t(e,se,s),t(e,Ts,s),d(ae,e,s),t(e,Us,s),t(e,te,s),t(e,_s,s),t(e,le,s),t(e,xs,s),d(oe,e,s),t(e,Cs,s),t(e,ie,s),t(e,qs,s),t(e,ne,s),t(e,Js,s),d(pe,e,s),t(e,Zs,s),t(e,re,s),t(e,ks,s),d(me,e,s),t(e,Gs,s),t(e,de,s),t(e,Ws,s),t(e,ue,s),t(e,Hs,s),t(e,ce,s),t(e,Ls,s),t(e,fe,s),t(e,zs,s),d(ge,e,s),t(e,Vs,s),t(e,he,s),t(e,Is,s),d(be,e,s),t(e,Ps,s),t(e,Me,s),t(e,Ss,s),d(ye,e,s),t(e,Bs,s),t(e,je,s),t(e,Ns,s),t(e,j,s),t(e,Xs,s),t(e,ve,s),t(e,Ds,s),d(we,e,s),t(e,Rs,s),t(e,v,s),t(e,Es,s),t(e,$e,s),t(e,Ys,s),t(e,Te,s),t(e,As,s),t(e,Ue,s),t(e,Qs,s),d(_e,e,s),t(e,Fs,s),t(e,xe,s),t(e,Ks,s),t(e,Ce,s),t(e,Os,s),d(qe,e,s),t(e,ea,s),t(e,Je,s),t(e,sa,s),d(Ze,e,s),t(e,aa,s),t(e,ke,s),t(e,ta,s),d(Ge,e,s),t(e,la,s),t(e,We,s),t(e,oa,s),t(e,w,s),t(e,ia,s),d(He,e,s),t(e,na,s),t(e,Le,s),t(e,pa,s),t(e,ze,s),t(e,ra,s),d(Ve,e,s),t(e,ma,s),t(e,Se,s),da=!0},p:pt,i(e){da||(u(T.$$.fragment,e),u(U.$$.fragment,e),u(_.$$.fragment,e),u(k.$$.fragment,e),u(W.$$.fragment,e),u(I.$$.fragment,e),u(S.$$.fragment,e),u(N.$$.fragment,e),u(D.$$.fragment,e),u(E.$$.fragment,e),u(Y.$$.fragment,e),u(Q.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(ge.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u(_e.$$.fragment,e),u(qe.$$.fragment,e),u(Ze.$$.fragment,e),u(Ge.$$.fragment,e),u(He.$$.fragment,e),u(Ve.$$.fragment,e),da=!0)},o(e){c(T.$$.fragment,e),c(U.$$.fragment,e),c(_.$$.fragment,e),c(k.$$.fragment,e),c(W.$$.fragment,e),c(I.$$.fragment,e),c(S.$$.fragment,e),c(N.$$.fragment,e),c(D.$$.fragment,e),c(E.$$.fragment,e),c(Y.$$.fragment,e),c(Q.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(ge.$$.fragment,e),c(be.$$.fragment,e),c(ye.$$.fragment,e),c(we.$$.fragment,e),c(_e.$$.fragment,e),c(qe.$$.fragment,e),c(Ze.$$.fragment,e),c(Ge.$$.fragment,e),c(He.$$.fragment,e),c(Ve.$$.fragment,e),da=!1},d(e){e&&(a(Be),a(Pe),a(Ne),a(Xe),a(De),a(Re),a(x),a(Ee),a(C),a(Ye),a(q),a(Ae),a(J),a(Qe),a(b),a(Fe),a(Z),a(Ke),a(Oe),a(G),a(es),a(ss),a(H),a(as),a(L),a(ts),a(z),a(ls),a(M),a(os),a(V),a(is),a(ns),a(P),a(ps),a(rs),a(B),a(ms),a(ds),a(X),a(us),a(cs),a(y),a(fs),a(R),a(gs),a(hs),a(bs),a(A),a(Ms),a(ys),a(F),a(js),a(vs),a(O),a(ws),a($s),a(se),a(Ts),a(Us),a(te),a(_s),a(le),a(xs),a(Cs),a(ie),a(qs),a(ne),a(Js),a(Zs),a(re),a(ks),a(Gs),a(de),a(Ws),a(ue),a(Hs),a(ce),a(Ls),a(fe),a(zs),a(Vs),a(he),a(Is),a(Ps),a(Me),a(Ss),a(Bs),a(je),a(Ns),a(j),a(Xs),a(ve),a(Ds),a(Rs),a(v),a(Es),a($e),a(Ys),a(Te),a(As),a(Ue),a(Qs),a(Fs),a(xe),a(Ks),a(Ce),a(Os),a(ea),a(Je),a(sa),a(aa),a(ke),a(ta),a(la),a(We),a(oa),a(w),a(ia),a(na),a(Le),a(pa),a(ze),a(ra),a(ma),a(Se)),a(h),f(T,e),f(U,e),f(_,e),f(k,e),f(W,e),f(I,e),f(S,e),f(N,e),f(D,e),f(E,e),f(Y,e),f(Q,e),f(K,e),f(ee,e),f(ae,e),f(oe,e),f(pe,e),f(me,e),f(ge,e),f(be,e),f(ye,e),f(we,e),f(_e,e),f(qe,e),f(Ze,e),f(Ge,e),f(He,e),f(Ve,e)}}}const Mt='{"title":"Tour rápido","local":"tour-rápido","sections":[{"title":"DiffusionPipeline","local":"diffusionpipeline","sections":[{"title":"Pipeline local","local":"pipeline-local","sections":[],"depth":3},{"title":"Troca dos agendadores","local":"troca-dos-agendadores","sections":[],"depth":3}],"depth":2},{"title":"Modelos","local":"modelos","sections":[],"depth":2},{"title":"Agendadores","local":"agendadores","sections":[],"depth":2},{"title":"Próximos passos","local":"próximos-passos","sections":[],"depth":2}],"depth":1}';function yt(ua){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ut extends mt{constructor(h){super(),dt(this,h,yt,bt,nt,{})}}export{Ut as component};
