# Pipeline states

## PipelineState[[diffusers.modular_pipelines.PipelineState]]

#### diffusers.modular_pipelines.PipelineState[[diffusers.modular_pipelines.PipelineState]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L69)

`PipelineState` stores the state of a pipeline. It is used to pass data between pipeline blocks.

getdiffusers.modular_pipelines.PipelineState.gethttps://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L94[{"name": "keys", "val": ": typing.Union[str, typing.List[str]]"}, {"name": "default", "val": ": typing.Any = None"}]- **keys** (Union[str, List[str]]) -- Key or list of keys for the values
- **default** (Any) -- The default value to return if not found0Union[Any, Dict[str, Any]]Single value if keys is str, dictionary of values if keys is list

Get one or multiple values from the pipeline state.

**Parameters:**

keys (Union[str, List[str]]) : Key or list of keys for the values

default (Any) : The default value to return if not found

**Returns:**

`Union[Any, Dict[str, Any]]`

Single value if keys is str, dictionary of values if keys is list
#### get_by_kwargs[[diffusers.modular_pipelines.PipelineState.get_by_kwargs]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L109)

Get all values with matching kwargs_type.

**Parameters:**

kwargs_type (str) : The kwargs_type to filter by

**Returns:**

`Dict[str, Any]`

Dictionary of values with matching kwargs_type
#### set[[diffusers.modular_pipelines.PipelineState.set]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L77)

Add a value to the pipeline state.

**Parameters:**

key (str) : The key for the value

value (Any) : The value to store

kwargs_type (str) : The kwargs_type with which the value is associated
#### to_dict[[diffusers.modular_pipelines.PipelineState.to_dict]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L122)

Convert PipelineState to a dictionary.

## BlockState[[diffusers.modular_pipelines.BlockState]]

#### diffusers.modular_pipelines.BlockState[[diffusers.modular_pipelines.BlockState]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L159)

Container for block state data with attribute access and formatted representation.

as_dictdiffusers.modular_pipelines.BlockState.as_dicthttps://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L176[]Dict[str, Any]Dictionary containing all attributes of the BlockState

Convert BlockState to a dictionary.

**Returns:**

`Dict[str, Any]`

Dictionary containing all attributes of the BlockState

