# Pipeline blocks

## ModularPipelineBlocks[[diffusers.ModularPipelineBlocks]]

#### diffusers.ModularPipelineBlocks[[diffusers.ModularPipelineBlocks]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L230)

Base class for all Pipeline Blocks: PipelineBlock, AutoPipelineBlocks, SequentialPipelineBlocks,
LoopSequentialPipelineBlocks

[ModularPipelineBlocks](/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks) provides method to load and save the definition of pipeline blocks.

> [!WARNING] > This is an experimental feature and is likely to change in the future.

combine_inputsdiffusers.ModularPipelineBlocks.combine_inputshttps://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L434[{"name": "*named_input_lists", "val": ": typing.List[typing.Tuple[str, typing.List[diffusers.modular_pipelines.modular_pipeline_utils.InputParam]]]"}]- **named_input_lists** -- List of tuples containing (block_name, input_param_list) pairs0List[InputParam]Combined list of unique InputParam objects

Combines multiple lists of InputParam objects from different blocks. For duplicate inputs, updates only if
current default value is None and new default value is not None. Warns if multiple non-None default values
exist for the same input.

**Parameters:**

named_input_lists : List of tuples containing (block_name, input_param_list) pairs

**Returns:**

`List[InputParam]`

Combined list of unique InputParam objects
#### combine_outputs[[diffusers.ModularPipelineBlocks.combine_outputs]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L477)

Combines multiple lists of OutputParam objects from different blocks. For duplicate outputs, keeps the first
occurrence of each output name.

**Parameters:**

named_output_lists : List of tuples containing (block_name, output_param_list) pairs

**Returns:**

`List[OutputParam]`

Combined list of unique OutputParam objects
#### get_block_state[[diffusers.ModularPipelineBlocks.get_block_state]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L377)

Get all inputs and intermediates in one dictionary
#### init_pipeline[[diffusers.ModularPipelineBlocks.init_pipeline]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L356)

create a ModularPipeline, optionally accept pretrained_model_name_or_path to load from hub.

## SequentialPipelineBlocks[[diffusers.modular_pipelines.SequentialPipelineBlocks]]

#### diffusers.modular_pipelines.SequentialPipelineBlocks[[diffusers.modular_pipelines.SequentialPipelineBlocks]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L781)

A Pipeline Blocks that combines multiple pipeline block classes into one. When called, it will call each block in
sequence.

This class inherits from [ModularPipelineBlocks](/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks). Check the superclass documentation for the generic methods the
library implements for all the pipeline blocks (such as loading or saving etc.)

> [!WARNING] > This is an experimental feature and is likely to change in the future.

from_blocks_dictdiffusers.modular_pipelines.SequentialPipelineBlocks.from_blocks_dicthttps://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L825[{"name": "blocks_dict", "val": ": typing.Dict[str, typing.Any]"}, {"name": "description", "val": ": typing.Optional[str] = None"}]- **blocks_dict** -- Dictionary mapping block names to block classes or instances0A new SequentialPipelineBlocks instance
Creates a SequentialPipelineBlocks instance from a dictionary of blocks.

**Parameters:**

block_classes : List of block classes to be used

block_names : List of prefixes for each block

**Returns:**

A new SequentialPipelineBlocks instance

## LoopSequentialPipelineBlocks[[diffusers.modular_pipelines.LoopSequentialPipelineBlocks]]

#### diffusers.modular_pipelines.LoopSequentialPipelineBlocks[[diffusers.modular_pipelines.LoopSequentialPipelineBlocks]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L1140)

A Pipeline blocks that combines multiple pipeline block classes into a For Loop. When called, it will call each
block in sequence.

This class inherits from [ModularPipelineBlocks](/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks). Check the superclass documentation for the generic methods the
library implements for all the pipeline blocks (such as loading or saving etc.)

> [!WARNING] > This is an experimental feature and is likely to change in the future.

from_blocks_dictdiffusers.modular_pipelines.LoopSequentialPipelineBlocks.from_blocks_dicthttps://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L1292[{"name": "blocks_dict", "val": ": typing.Dict[str, typing.Any]"}]- **blocks_dict** -- Dictionary mapping block names to block instances0A new LoopSequentialPipelineBlocks instance

Creates a LoopSequentialPipelineBlocks instance from a dictionary of blocks.

**Parameters:**

block_classes : List of block classes to be used

block_names : List of prefixes for each block

**Returns:**

A new LoopSequentialPipelineBlocks instance

## AutoPipelineBlocks[[diffusers.modular_pipelines.AutoPipelineBlocks]]

#### diffusers.modular_pipelines.AutoPipelineBlocks[[diffusers.modular_pipelines.AutoPipelineBlocks]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline.py#L524)

A Pipeline Blocks that automatically selects a block to run based on the inputs.

This class inherits from [ModularPipelineBlocks](/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks). Check the superclass documentation for the generic methods the
library implements for all the pipeline blocks (such as loading or saving etc.)

> [!WARNING] > This is an experimental feature and is likely to change in the future.

**Parameters:**

block_classes : List of block classes to be used

block_names : List of prefixes for each block

block_trigger_inputs : List of input names that trigger specific blocks, with None for default

