import{s as Is,n as vs,o as _s}from"../chunks/scheduler.53228c21.js";import{S as Bs,i as ks,e as n,s as a,c as r,h as xs,a as o,d as l,b as i,f as kl,g as m,j as p,k as y,l as xl,m as s,n as d,t as f,o as c,p as u}from"../chunks/index.100fac89.js";import{C as Xs}from"../chunks/CopyLLMTxtMenu.e0e1615c.js";import{C as M}from"../chunks/CodeBlock.d30a6509.js";import{D as Cs}from"../chunks/DocNotebookDropdown.74a16910.js";import{H as b,E as $s}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e3ac3f07.js";function Rs(Xl){let h,Ke,Ae,Oe,x,et,X,tt,C,lt,$,Cl='<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">Stable Diffusion XL</a> (SDXL) is a powerful text-to-image generation model that iterates on the previous Stable Diffusion models in three key ways:',st,R,$l="<li>the UNet is 3x larger and SDXL combines a second text encoder (OpenCLIP ViT-bigG/14) with the original text encoder to significantly increase the number of parameters</li> <li>introduces size and crop-conditioning to preserve training data from being discarded and gain more control over how a generated image should be cropped</li> <li>introduces a two-stage model process; the <em>base</em> model (can also be run as a standalone model) generates an image as an input to the <em>refiner</em> model which adds additional high-quality details</li>",at,V,Rl="This guide will show you how to use SDXL for text-to-image, image-to-image, and inpainting.",it,Y,Vl="Before you begin, make sure you have the following libraries installed:",nt,S,ot,g,De,Yl='We recommend installing the <a href="https://pypi.org/project/invisible-watermark/" rel="nofollow">invisible-watermark</a> library to help identify images that are generated. If the invisible-watermark library is installed, it is used by default. To disable the watermarker:',Bl,E,pt,N,rt,Q,Sl='Model weights may be stored in separate subfolders on the Hub or locally, in which case, you should use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method:',mt,F,dt,L,El='You can also use the <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> method to load a model checkpoint stored in a single file format (<code>.ckpt</code> or <code>.safetensors</code>) from the Hub or locally:',ft,H,ct,z,ut,q,Nl="For text-to-image, pass a text prompt. By default, SDXL generates a 1024x1024 image for the best results. You can try setting the <code>height</code> and <code>width</code> parameters to 768x768 or 512x512, but anything below 512x512 is not likely to work.",Mt,D,yt,J,Ql='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png" alt="generated image of an astronaut in a jungle"/>',bt,A,ht,P,Fl="For image-to-image, SDXL works especially well with image sizes between 768x768 and 1024x1024. Pass an initial image, and a text prompt to condition the image with:",gt,K,Jt,T,Ll='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-img2img.png" alt="generated image of a dog catching a frisbee in a jungle"/>',Tt,O,wt,ee,Hl="For inpainting, you’ll need the original image and a mask of what you want to replace in the original image. Create a prompt to describe what you want to replace the masked area with.",Zt,te,Ut,w,zl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint.png" alt="generated image of a deep sea diver in a jungle"/>',jt,le,Wt,se,ql='SDXL includes a <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">refiner model</a> specialized in denoising low-noise stage images to generate higher-quality images from the base model. There are two ways to use the refiner:',Gt,ae,Dl="<li>use the base and refiner models together to produce a refined image</li> <li>use the base model to produce an image, and subsequently use the refiner model to add more details to the image (this is how SDXL was originally trained)</li>",It,ie,vt,ne,Al='When you use the base and refiner model together to generate an image, this is known as an <a href="https://research.nvidia.com/labs/dir/eDiff-I/" rel="nofollow"><em>ensemble of expert denoisers</em></a>. The ensemble of expert denoisers approach requires fewer overall denoising steps versus passing the base model’s output to the refiner model, so it should be significantly faster to run. However, you won’t be able to inspect the base model’s output because it still contains a large amount of noise.',_t,oe,Pl="As an ensemble of expert denoisers, the base model serves as the expert during the high-noise diffusion stage and the refiner model serves as the expert during the low-noise diffusion stage. Load the base and refiner model:",Bt,pe,kt,re,Kl='To use this approach, you need to define the number of timesteps for each model to run through their respective stages. For the base model, this is controlled by the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline.__call__.denoising_end" rel="nofollow"><code>denoising_end</code></a> parameter and for the refiner model, it is controlled by the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline.__call__.denoising_start" rel="nofollow"><code>denoising_start</code></a> parameter.',xt,Z,Ol="<p>The <code>denoising_end</code> and <code>denoising_start</code> parameters should be a float between 0 and 1. These parameters are represented as a proportion of discrete timesteps as defined by the scheduler. If you’re also using the <code>strength</code> parameter, it’ll be ignored because the number of denoising steps is determined by the discrete timesteps the model is trained on and the declared fractional cutoff.</p>",Xt,me,es="Let’s set <code>denoising_end=0.8</code> so the base model performs the first 80% of denoising the <strong>high-noise</strong> timesteps and set <code>denoising_start=0.8</code> so the refiner model performs the last 20% of denoising the <strong>low-noise</strong> timesteps. The base model output should be in <strong>latent</strong> space instead of a PIL image.",Ct,de,$t,U,ts='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lion_base.png" alt="generated image of a lion on a rock at night"/> <figcaption class="mt-2 text-center text-sm text-gray-500">default base model</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lion_refined.png" alt="generated image of a lion on a rock at night in higher quality"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ensemble of expert denoisers</figcaption></div>',Rt,fe,ls='The refiner model can also be used for inpainting in the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline">StableDiffusionXLInpaintPipeline</a>:',Vt,ce,Yt,ue,ss="This ensemble of expert denoisers method works well for all available schedulers!",St,Me,Et,ye,as="SDXL gets a boost in image quality by using the refiner model to add additional high-quality details to the fully-denoised image from the base model, in an image-to-image setting.",Nt,be,is="Load the base and refiner models:",Qt,he,Ft,j,ns='<p>You can use SDXL refiner with a different base model. For example, you can use the <a href="../api/pipelines/hunyuandit">Hunyuan-DiT</a> or <a href="../api/pipelines/pixart_sigma">PixArt-Sigma</a> pipelines to generate images with better prompt adherence. Once you have generated an image, you can pass it to the SDXL refiner model to enhance final generation quality.</p>',Lt,ge,os="Generate an image from the base model, and set the model output to <strong>latent</strong> space:",Ht,Je,zt,Te,ps="Pass the generated image to the refiner model:",qt,we,Dt,W,rs='<div><img class="rounded-xl" src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/sd_xl/init_image.png" alt="generated image of an astronaut riding a green horse on Mars"/> <figcaption class="mt-2 text-center text-sm text-gray-500">base model</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/sd_xl/refined_image.png" alt="higher quality generated image of an astronaut riding a green horse on Mars"/> <figcaption class="mt-2 text-center text-sm text-gray-500">base model + refiner model</figcaption></div>',At,Ze,ms='For inpainting, load the base and the refiner model in the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline">StableDiffusionXLInpaintPipeline</a>, remove the <code>denoising_end</code> and <code>denoising_start</code> parameters, and choose a smaller number of inference steps for the refiner.',Pt,Ue,Kt,je,ds="SDXL training involves several additional conditioning techniques, which are referred to as <em>micro-conditioning</em>. These include original image size, target image size, and cropping parameters. The micro-conditionings can be used at inference time to create high-quality, centered images.",Ot,G,fs='<p>You can use both micro-conditioning and negative micro-conditioning parameters thanks to classifier-free guidance. They are available in the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>, <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline">StableDiffusionXLImg2ImgPipeline</a>, <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline">StableDiffusionXLInpaintPipeline</a>, and <a href="/docs/diffusers/main/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a>.</p>',el,We,tl,Ge,cs="There are two types of size conditioning:",ll,Ie,us='<li><p><a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline.__call__.original_size" rel="nofollow"><code>original_size</code></a> conditioning comes from upscaled images in the training batch (because it would be wasteful to discard the smaller images which make up almost 40% of the total training data). This way, SDXL learns that upscaling artifacts are not supposed to be present in high-resolution images. During inference, you can use <code>original_size</code> to indicate the original image resolution. Using the default value of <code>(1024, 1024)</code> produces higher-quality images that resemble the 1024x1024 images in the dataset. If you choose to use a lower resolution, such as <code>(256, 256)</code>, the model still generates 1024x1024 images, but they’ll look like the low resolution images (simpler patterns, blurring) in the dataset.</p></li> <li><p><a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline.__call__.target_size" rel="nofollow"><code>target_size</code></a> conditioning comes from finetuning SDXL to support different image aspect ratios. During inference, if you use the default value of <code>(1024, 1024)</code>, you’ll get an image that resembles the composition of square images in the dataset. We recommend using the same value for <code>target_size</code> and <code>original_size</code>, but feel free to experiment with other options!</p></li>',sl,ve,Ms="🤗 Diffusers also lets you specify negative conditions about an image’s size to steer generation away from certain image resolutions:",al,_e,il,I,ys='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/sd_xl/negative_conditions.png"/> <figcaption class="text-center">Images negatively conditioned on image resolutions of (128, 128), (256, 256), and (512, 512).</figcaption>',nl,Be,ol,ke,bs="Images generated by previous Stable Diffusion models may sometimes appear to be cropped. This is because images are actually cropped during training so that all the images in a batch have the same size. By conditioning on crop coordinates, SDXL <em>learns</em> that no cropping - coordinates <code>(0, 0)</code> - usually correlates with centered subjects and complete faces (this is the default value in 🤗 Diffusers). You can experiment with different coordinates if you want to generate off-centered compositions!",pl,xe,rl,v,hs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-cropped.png" alt="generated image of an astronaut in a jungle, slightly cropped"/>',ml,Xe,gs="You can also specify negative cropping coordinates to steer generation away from certain cropping parameters:",dl,Ce,fl,$e,cl,Re,Js='SDXL uses two text-encoders, so it is possible to pass a different prompt to each text-encoder, which can <a href="https://github.com/huggingface/diffusers/issues/4004#issuecomment-1627764201" rel="nofollow">improve quality</a>. Pass your original prompt to <code>prompt</code> and the second prompt to <code>prompt_2</code> (use <code>negative_prompt</code> and <code>negative_prompt_2</code> if you’re using negative prompts):',ul,Ve,Ml,_,Ts='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-double-prompt.png" alt="generated image of an astronaut in a jungle in the style of a van gogh painting"/>',yl,Ye,ws='The dual text-encoders also support textual inversion embeddings that need to be loaded separately as explained in the <a href="textual_inversion_inference#stable-diffusion-xl">SDXL textual inversion</a> section.',bl,Se,hl,Ee,Zs="SDXL is a large model, and you may need to optimize memory to get it to run on your hardware. Here are some tips to save memory and speed up inference.",gl,Ne,Us='<li>Offload the model to the CPU with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> for out-of-memory errors:</li>',Jl,Qe,Tl,B,js="<li>Use <code>torch.compile</code> for ~20% speed-up (you need <code>torch&gt;=2.0</code>):</li>",wl,Fe,Zl,k,Ws='<li>Enable <a href="../optimization/xformers">xFormers</a> to run SDXL if <code>torch&lt;2.0</code>:</li>',Ul,Le,jl,He,Wl,ze,Gs='If you’re interested in experimenting with a minimal version of the <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used in SDXL, take a look at the <a href="https://github.com/cloneofsimo/minSDXL" rel="nofollow">minSDXL</a> implementation which is written in PyTorch and directly compatible with 🤗 Diffusers.',Gl,qe,Il,Pe,vl;return x=new Xs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),X=new Cs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl.ipynb"}]}}),C=new b({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h1"}}),S=new M({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwaW52aXNpYmxlLXdhdGVybWFyayUzRSUzRDAuMi4w",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate invisible-watermark&gt;=0.2.0</span>`,wrap:!1}}),E=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBhZGRfd2F0ZXJtYXJrZXIlM0RGYWxzZSk=",highlighted:'pipeline = StableDiffusionXLPipeline.from_pretrained(..., add_watermarker=<span class="hljs-literal">False</span>)',wrap:!1}}),N=new b({props:{title:"Load model checkpoints",local:"load-model-checkpoints",headingTag:"h2"}}),F=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcmVmaW5lciUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtcmVmaW5lci0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, StableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

refiner = StableDiffusionXLImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),H=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyRmJsb2IlMkZtYWluJTJGc2RfeGxfYmFzZV8xLjAuc2FmZXRlbnNvcnMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcmVmaW5lciUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyRmJsb2IlMkZtYWluJTJGc2RfeGxfcmVmaW5lcl8xLjAuc2FmZXRlbnNvcnMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, StableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0.safetensors&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

refiner = StableDiffusionXLImg2ImgPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0/blob/main/sd_xl_refiner_1.0.safetensors&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),z=new b({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),D=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lX3RleHQyaW1hZ2UlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmVfdGV4dDJpbWFnZShwcm9tcHQlM0Rwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2image = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipeline_text2image(prompt=prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),A=new b({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h2"}}),K=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMjMlMjB1c2UlMjBmcm9tX3BpcGUlMjB0byUyMGF2b2lkJTIwY29uc3VtaW5nJTIwYWRkaXRpb25hbCUyMG1lbW9yeSUyMHdoZW4lMjBsb2FkaW5nJTIwYSUyMGNoZWNrcG9pbnQlMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltYWdlKS50byglMjJjdWRhJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtdGV4dDJpbWcucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBjYXRjaGluZyUyMGElMjBmcmlzYmVlJTIwaW4lMjB0aGUlMjBqdW5nbGUlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC44JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMC41KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># use from_pipe to avoid consuming additional memory when loading a checkpoint</span>
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_text2image).to(<span class="hljs-string">&quot;cuda&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
init_image = load_image(url)
prompt = <span class="hljs-string">&quot;a dog catching a frisbee in the jungle&quot;</span>
image = pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.8</span>, guidance_scale=<span class="hljs-number">10.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),O=new b({props:{title:"Inpainting",local:"inpainting",headingTag:"h2"}}),te=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQSUyMyUyMHVzZSUyMGZyb21fcGlwZSUyMHRvJTIwYXZvaWQlMjBjb25zdW1pbmclMjBhZGRpdGlvbmFsJTIwbWVtb3J5JTIwd2hlbiUyMGxvYWRpbmclMjBhJTIwY2hlY2twb2ludCUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZy5mcm9tX3BpcGUocGlwZWxpbmVfdGV4dDJpbWFnZSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGc2R4bC10ZXh0MmltZy5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtaW5wYWludC1tYXNrLnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpJTBBbWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UobWFza191cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGRlZXAlMjBzZWElMjBkaXZlciUyMGZsb2F0aW5nJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC44NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMTIuNSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># use from_pipe to avoid consuming additional memory when loading a checkpoint</span>
pipeline = AutoPipelineForInpainting.from_pipe(pipeline_text2image).to(<span class="hljs-string">&quot;cuda&quot;</span>)

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png&quot;</span>

init_image = load_image(img_url)
mask_image = load_image(mask_url)

prompt = <span class="hljs-string">&quot;A deep sea diver floating&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.85</span>, guidance_scale=<span class="hljs-number">12.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),le=new b({props:{title:"Refine image quality",local:"refine-image-quality",headingTag:"h2"}}),ie=new b({props:{title:"Base + refiner model",local:"base--refiner-model",headingTag:"h3"}}),pe=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFiYXNlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFyZWZpbmVyJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8yJTNEYmFzZS50ZXh0X2VuY29kZXJfMiUyQyUwQSUyMCUyMCUyMCUyMHZhZSUzRGJhc2UudmFlJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

base = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

refiner = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>,
    text_encoder_2=base.text_encoder_2,
    vae=base.vae,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),de=new M({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQSUwQWltYWdlJTIwJTNEJTIwYmFzZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENDAlMkMlMEElMjAlMjAlMjAlMjBkZW5vaXNpbmdfZW5kJTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIlMkMlMEEpLmltYWdlcyUwQWltYWdlJTIwJTNEJTIwcmVmaW5lciglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENDAlMkMlMEElMjAlMjAlMjAlMjBkZW5vaXNpbmdfc3RhcnQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>

image = base(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_end=<span class="hljs-number">0.8</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images
image = refiner(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_start=<span class="hljs-number">0.8</span>,
    image=image,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ce=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">import</span> torch

base = StableDiffusionXLInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

refiner = StableDiffusionXLInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>,
    text_encoder_2=base.text_encoder_2,
    vae=base.vae,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url)
mask_image = load_image(mask_url)

prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>
num_inference_steps = <span class="hljs-number">75</span>
high_noise_frac = <span class="hljs-number">0.7</span>

image = base(
    prompt=prompt,
    image=init_image,
    mask_image=mask_image,
    num_inference_steps=num_inference_steps,
    denoising_end=high_noise_frac,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images
image = refiner(
    prompt=prompt,
    image=image,
    mask_image=mask_image,
    num_inference_steps=num_inference_steps,
    denoising_start=high_noise_frac,
).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),Me=new b({props:{title:"Base to refiner model",local:"base-to-refiner-model",headingTag:"h3"}}),he=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFiYXNlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFyZWZpbmVyJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8yJTNEYmFzZS50ZXh0X2VuY29kZXJfMiUyQyUwQSUyMCUyMCUyMCUyMHZhZSUzRGJhc2UudmFlJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

base = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

refiner = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>,
    text_encoder_2=base.text_encoder_2,
    vae=base.vae,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Je=new M({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwYmFzZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMikuaW1hZ2VzJTVCMCU1RA==",highlighted:`prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),we=new M({props:{code:"aW1hZ2UlMjAlM0QlMjByZWZpbmVyKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW1hZ2UlNUJOb25lJTJDJTIwJTNBJTVEKS5pbWFnZXMlNUIwJTVE",highlighted:'image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]',wrap:!1}}),Ue=new b({props:{title:"Micro-conditioning",local:"micro-conditioning",headingTag:"h2"}}),We=new b({props:{title:"Size conditioning",local:"size-conditioning",headingTag:"h3"}}),_e=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9vcmlnaW5hbF9zaXplJTNEKDUxMiUyQyUyMDUxMiklMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV90YXJnZXRfc2l6ZSUzRCgxMDI0JTJDJTIwMTAyNCklMkMlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(
    prompt=prompt,
    negative_original_size=(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>),
    negative_target_size=(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>),
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Be=new b({props:{title:"Crop conditioning",local:"crop-conditioning",headingTag:"h3"}}),xe=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGNyb3BzX2Nvb3Jkc190b3BfbGVmdCUzRCgyNTYlMkMlMjAwKSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, crops_coords_top_left=(<span class="hljs-number">256</span>, <span class="hljs-number">0</span>)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ce=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9vcmlnaW5hbF9zaXplJTNEKDUxMiUyQyUyMDUxMiklMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9jcm9wc19jb29yZHNfdG9wX2xlZnQlM0QoMCUyQyUyMDApJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfdGFyZ2V0X3NpemUlM0QoMTAyNCUyQyUyMDEwMjQpJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(
    prompt=prompt,
    negative_original_size=(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>),
    negative_crops_coords_top_left=(<span class="hljs-number">0</span>, <span class="hljs-number">0</span>),
    negative_target_size=(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>),
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),$e=new b({props:{title:"Use a different prompt for each text-encoder",local:"use-a-different-prompt-for-each-text-encoder",headingTag:"h2"}}),Ve=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMHByb21wdCUyMGlzJTIwcGFzc2VkJTIwdG8lMjBPQUklMjBDTElQLVZpVCUyRkwtMTQlMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTIzJTIwcHJvbXB0XzIlMjBpcyUyMHBhc3NlZCUyMHRvJTIwT3BlbkNMSVAtVmlUJTJGYmlnRy0xNCUwQXByb21wdF8yJTIwJTNEJTIwJTIyVmFuJTIwR29naCUyMHBhaW50aW5nJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBwcm9tcHRfMiUzRHByb21wdF8yKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># prompt is passed to OAI CLIP-ViT/L-14</span>
prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
<span class="hljs-comment"># prompt_2 is passed to OpenCLIP-ViT/bigG-14</span>
prompt_2 = <span class="hljs-string">&quot;Van Gogh painting&quot;</span>
image = pipeline(prompt=prompt, prompt_2=prompt_2).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Se=new b({props:{title:"Optimizations",local:"optimizations",headingTag:"h2"}}),Qe=new M({props:{code:"LSUyMGJhc2UudG8oJTIyY3VkYSUyMiklMEEtJTIwcmVmaW5lci50byglMjJjdWRhJTIyKSUwQSUyQiUyMGJhc2UuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjByZWZpbmVyLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-deletion">- base.to(&quot;cuda&quot;)</span>
<span class="hljs-deletion">- refiner.to(&quot;cuda&quot;)</span>
<span class="hljs-addition">+ base.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ refiner.enable_model_cpu_offload()</span>`,wrap:!1}}),Fe=new M({props:{code:"JTJCJTIwYmFzZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShiYXNlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMkIlMjByZWZpbmVyLnVuZXQlMjAlM0QlMjB0b3JjaC5jb21waWxlKHJlZmluZXIudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:`<span class="hljs-addition">+ base.unet = torch.compile(base.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>
<span class="hljs-addition">+ refiner.unet = torch.compile(refiner.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>`,wrap:!1}}),Le=new M({props:{code:"JTJCJTIwYmFzZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUyQiUyMHJlZmluZXIuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCk=",highlighted:`<span class="hljs-addition">+ base.enable_xformers_memory_efficient_attention()</span>
<span class="hljs-addition">+ refiner.enable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),He=new b({props:{title:"Other resources",local:"other-resources",headingTag:"h2"}}),qe=new $s({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/sdxl.md"}}),{c(){h=n("meta"),Ke=a(),Ae=n("p"),Oe=a(),r(x.$$.fragment),et=a(),r(X.$$.fragment),tt=a(),r(C.$$.fragment),lt=a(),$=n("p"),$.innerHTML=Cl,st=a(),R=n("ol"),R.innerHTML=$l,at=a(),V=n("p"),V.textContent=Rl,it=a(),Y=n("p"),Y.textContent=Vl,nt=a(),r(S.$$.fragment),ot=a(),g=n("blockquote"),De=n("p"),De.innerHTML=Yl,Bl=a(),r(E.$$.fragment),pt=a(),r(N.$$.fragment),rt=a(),Q=n("p"),Q.innerHTML=Sl,mt=a(),r(F.$$.fragment),dt=a(),L=n("p"),L.innerHTML=El,ft=a(),r(H.$$.fragment),ct=a(),r(z.$$.fragment),ut=a(),q=n("p"),q.innerHTML=Nl,Mt=a(),r(D.$$.fragment),yt=a(),J=n("div"),J.innerHTML=Ql,bt=a(),r(A.$$.fragment),ht=a(),P=n("p"),P.textContent=Fl,gt=a(),r(K.$$.fragment),Jt=a(),T=n("div"),T.innerHTML=Ll,Tt=a(),r(O.$$.fragment),wt=a(),ee=n("p"),ee.textContent=Hl,Zt=a(),r(te.$$.fragment),Ut=a(),w=n("div"),w.innerHTML=zl,jt=a(),r(le.$$.fragment),Wt=a(),se=n("p"),se.innerHTML=ql,Gt=a(),ae=n("ol"),ae.innerHTML=Dl,It=a(),r(ie.$$.fragment),vt=a(),ne=n("p"),ne.innerHTML=Al,_t=a(),oe=n("p"),oe.textContent=Pl,Bt=a(),r(pe.$$.fragment),kt=a(),re=n("p"),re.innerHTML=Kl,xt=a(),Z=n("blockquote"),Z.innerHTML=Ol,Xt=a(),me=n("p"),me.innerHTML=es,Ct=a(),r(de.$$.fragment),$t=a(),U=n("div"),U.innerHTML=ts,Rt=a(),fe=n("p"),fe.innerHTML=ls,Vt=a(),r(ce.$$.fragment),Yt=a(),ue=n("p"),ue.textContent=ss,St=a(),r(Me.$$.fragment),Et=a(),ye=n("p"),ye.textContent=as,Nt=a(),be=n("p"),be.textContent=is,Qt=a(),r(he.$$.fragment),Ft=a(),j=n("blockquote"),j.innerHTML=ns,Lt=a(),ge=n("p"),ge.innerHTML=os,Ht=a(),r(Je.$$.fragment),zt=a(),Te=n("p"),Te.textContent=ps,qt=a(),r(we.$$.fragment),Dt=a(),W=n("div"),W.innerHTML=rs,At=a(),Ze=n("p"),Ze.innerHTML=ms,Pt=a(),r(Ue.$$.fragment),Kt=a(),je=n("p"),je.innerHTML=ds,Ot=a(),G=n("blockquote"),G.innerHTML=fs,el=a(),r(We.$$.fragment),tl=a(),Ge=n("p"),Ge.textContent=cs,ll=a(),Ie=n("ul"),Ie.innerHTML=us,sl=a(),ve=n("p"),ve.textContent=Ms,al=a(),r(_e.$$.fragment),il=a(),I=n("div"),I.innerHTML=ys,nl=a(),r(Be.$$.fragment),ol=a(),ke=n("p"),ke.innerHTML=bs,pl=a(),r(xe.$$.fragment),rl=a(),v=n("div"),v.innerHTML=hs,ml=a(),Xe=n("p"),Xe.textContent=gs,dl=a(),r(Ce.$$.fragment),fl=a(),r($e.$$.fragment),cl=a(),Re=n("p"),Re.innerHTML=Js,ul=a(),r(Ve.$$.fragment),Ml=a(),_=n("div"),_.innerHTML=Ts,yl=a(),Ye=n("p"),Ye.innerHTML=ws,bl=a(),r(Se.$$.fragment),hl=a(),Ee=n("p"),Ee.textContent=Zs,gl=a(),Ne=n("ol"),Ne.innerHTML=Us,Jl=a(),r(Qe.$$.fragment),Tl=a(),B=n("ol"),B.innerHTML=js,wl=a(),r(Fe.$$.fragment),Zl=a(),k=n("ol"),k.innerHTML=Ws,Ul=a(),r(Le.$$.fragment),jl=a(),r(He.$$.fragment),Wl=a(),ze=n("p"),ze.innerHTML=Gs,Gl=a(),r(qe.$$.fragment),Il=a(),Pe=n("p"),this.h()},l(e){const t=xs("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),Ke=i(e),Ae=o(e,"P",{}),kl(Ae).forEach(l),Oe=i(e),m(x.$$.fragment,e),et=i(e),m(X.$$.fragment,e),tt=i(e),m(C.$$.fragment,e),lt=i(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-8e6ihk"&&($.innerHTML=Cl),st=i(e),R=o(e,"OL",{"data-svelte-h":!0}),p(R)!=="svelte-kzd5ve"&&(R.innerHTML=$l),at=i(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1dmebl2"&&(V.textContent=Rl),it=i(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-cwruts"&&(Y.textContent=Vl),nt=i(e),m(S.$$.fragment,e),ot=i(e),g=o(e,"BLOCKQUOTE",{class:!0});var _l=kl(g);De=o(_l,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1pmihy9"&&(De.innerHTML=Yl),Bl=i(_l),m(E.$$.fragment,_l),_l.forEach(l),pt=i(e),m(N.$$.fragment,e),rt=i(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-hva56b"&&(Q.innerHTML=Sl),mt=i(e),m(F.$$.fragment,e),dt=i(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1bnykxt"&&(L.innerHTML=El),ft=i(e),m(H.$$.fragment,e),ct=i(e),m(z.$$.fragment,e),ut=i(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-14g8zj2"&&(q.innerHTML=Nl),Mt=i(e),m(D.$$.fragment,e),yt=i(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(J)!=="svelte-olxauf"&&(J.innerHTML=Ql),bt=i(e),m(A.$$.fragment,e),ht=i(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1wfw5z2"&&(P.textContent=Fl),gt=i(e),m(K.$$.fragment,e),Jt=i(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-qmwul6"&&(T.innerHTML=Ll),Tt=i(e),m(O.$$.fragment,e),wt=i(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-9ro4ak"&&(ee.textContent=Hl),Zt=i(e),m(te.$$.fragment,e),Ut=i(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-oeht90"&&(w.innerHTML=zl),jt=i(e),m(le.$$.fragment,e),Wt=i(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-c9rvzh"&&(se.innerHTML=ql),Gt=i(e),ae=o(e,"OL",{"data-svelte-h":!0}),p(ae)!=="svelte-11dgpwz"&&(ae.innerHTML=Dl),It=i(e),m(ie.$$.fragment,e),vt=i(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-13hawme"&&(ne.innerHTML=Al),_t=i(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-ytk0zd"&&(oe.textContent=Pl),Bt=i(e),m(pe.$$.fragment,e),kt=i(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-fh96ip"&&(re.innerHTML=Kl),xt=i(e),Z=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(Z)!=="svelte-1rf1l30"&&(Z.innerHTML=Ol),Xt=i(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-6bxxkd"&&(me.innerHTML=es),Ct=i(e),m(de.$$.fragment,e),$t=i(e),U=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-1nh65b"&&(U.innerHTML=ts),Rt=i(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1fh5v19"&&(fe.innerHTML=ls),Vt=i(e),m(ce.$$.fragment,e),Yt=i(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1x3hdt3"&&(ue.textContent=ss),St=i(e),m(Me.$$.fragment,e),Et=i(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1t0l7j9"&&(ye.textContent=as),Nt=i(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1ct6jhk"&&(be.textContent=is),Qt=i(e),m(he.$$.fragment,e),Ft=i(e),j=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-gk11bn"&&(j.innerHTML=ns),Lt=i(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-10ioafw"&&(ge.innerHTML=os),Ht=i(e),m(Je.$$.fragment,e),zt=i(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-ht9d3m"&&(Te.textContent=ps),qt=i(e),m(we.$$.fragment,e),Dt=i(e),W=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(W)!=="svelte-1u8njyh"&&(W.innerHTML=rs),At=i(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1ikkntc"&&(Ze.innerHTML=ms),Pt=i(e),m(Ue.$$.fragment,e),Kt=i(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1jtnlpo"&&(je.innerHTML=ds),Ot=i(e),G=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-nifbmk"&&(G.innerHTML=fs),el=i(e),m(We.$$.fragment,e),tl=i(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-h89lzu"&&(Ge.textContent=cs),ll=i(e),Ie=o(e,"UL",{"data-svelte-h":!0}),p(Ie)!=="svelte-bqvi0g"&&(Ie.innerHTML=us),sl=i(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-2b2q2"&&(ve.textContent=Ms),al=i(e),m(_e.$$.fragment,e),il=i(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-thc7vn"&&(I.innerHTML=ys),nl=i(e),m(Be.$$.fragment,e),ol=i(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-14lnf5x"&&(ke.innerHTML=bs),pl=i(e),m(xe.$$.fragment,e),rl=i(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-167e9h5"&&(v.innerHTML=hs),ml=i(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-f4u8tr"&&(Xe.textContent=gs),dl=i(e),m(Ce.$$.fragment,e),fl=i(e),m($e.$$.fragment,e),cl=i(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-189in7b"&&(Re.innerHTML=Js),ul=i(e),m(Ve.$$.fragment,e),Ml=i(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(_)!=="svelte-1h8rgz0"&&(_.innerHTML=Ts),yl=i(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-5rqyoz"&&(Ye.innerHTML=ws),bl=i(e),m(Se.$$.fragment,e),hl=i(e),Ee=o(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1a85yi5"&&(Ee.textContent=Zs),gl=i(e),Ne=o(e,"OL",{"data-svelte-h":!0}),p(Ne)!=="svelte-1v77ccs"&&(Ne.innerHTML=Us),Jl=i(e),m(Qe.$$.fragment,e),Tl=i(e),B=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(B)!=="svelte-wmj8zo"&&(B.innerHTML=js),wl=i(e),m(Fe.$$.fragment,e),Zl=i(e),k=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(k)!=="svelte-fvjjw8"&&(k.innerHTML=Ws),Ul=i(e),m(Le.$$.fragment,e),jl=i(e),m(He.$$.fragment,e),Wl=i(e),ze=o(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1stjah9"&&(ze.innerHTML=Gs),Gl=i(e),m(qe.$$.fragment,e),Il=i(e),Pe=o(e,"P",{}),kl(Pe).forEach(l),this.h()},h(){y(h,"name","hf:doc:metadata"),y(h,"content",Vs),y(g,"class","warning"),y(J,"class","flex justify-center"),y(T,"class","flex justify-center"),y(w,"class","flex justify-center"),y(Z,"class","tip"),y(U,"class","flex gap-4"),y(j,"class","warning"),y(W,"class","flex gap-4"),y(G,"class","tip"),y(I,"class","flex flex-col justify-center"),y(v,"class","flex justify-center"),y(_,"class","flex justify-center"),y(B,"start","2"),y(k,"start","3")},m(e,t){xl(document.head,h),s(e,Ke,t),s(e,Ae,t),s(e,Oe,t),d(x,e,t),s(e,et,t),d(X,e,t),s(e,tt,t),d(C,e,t),s(e,lt,t),s(e,$,t),s(e,st,t),s(e,R,t),s(e,at,t),s(e,V,t),s(e,it,t),s(e,Y,t),s(e,nt,t),d(S,e,t),s(e,ot,t),s(e,g,t),xl(g,De),xl(g,Bl),d(E,g,null),s(e,pt,t),d(N,e,t),s(e,rt,t),s(e,Q,t),s(e,mt,t),d(F,e,t),s(e,dt,t),s(e,L,t),s(e,ft,t),d(H,e,t),s(e,ct,t),d(z,e,t),s(e,ut,t),s(e,q,t),s(e,Mt,t),d(D,e,t),s(e,yt,t),s(e,J,t),s(e,bt,t),d(A,e,t),s(e,ht,t),s(e,P,t),s(e,gt,t),d(K,e,t),s(e,Jt,t),s(e,T,t),s(e,Tt,t),d(O,e,t),s(e,wt,t),s(e,ee,t),s(e,Zt,t),d(te,e,t),s(e,Ut,t),s(e,w,t),s(e,jt,t),d(le,e,t),s(e,Wt,t),s(e,se,t),s(e,Gt,t),s(e,ae,t),s(e,It,t),d(ie,e,t),s(e,vt,t),s(e,ne,t),s(e,_t,t),s(e,oe,t),s(e,Bt,t),d(pe,e,t),s(e,kt,t),s(e,re,t),s(e,xt,t),s(e,Z,t),s(e,Xt,t),s(e,me,t),s(e,Ct,t),d(de,e,t),s(e,$t,t),s(e,U,t),s(e,Rt,t),s(e,fe,t),s(e,Vt,t),d(ce,e,t),s(e,Yt,t),s(e,ue,t),s(e,St,t),d(Me,e,t),s(e,Et,t),s(e,ye,t),s(e,Nt,t),s(e,be,t),s(e,Qt,t),d(he,e,t),s(e,Ft,t),s(e,j,t),s(e,Lt,t),s(e,ge,t),s(e,Ht,t),d(Je,e,t),s(e,zt,t),s(e,Te,t),s(e,qt,t),d(we,e,t),s(e,Dt,t),s(e,W,t),s(e,At,t),s(e,Ze,t),s(e,Pt,t),d(Ue,e,t),s(e,Kt,t),s(e,je,t),s(e,Ot,t),s(e,G,t),s(e,el,t),d(We,e,t),s(e,tl,t),s(e,Ge,t),s(e,ll,t),s(e,Ie,t),s(e,sl,t),s(e,ve,t),s(e,al,t),d(_e,e,t),s(e,il,t),s(e,I,t),s(e,nl,t),d(Be,e,t),s(e,ol,t),s(e,ke,t),s(e,pl,t),d(xe,e,t),s(e,rl,t),s(e,v,t),s(e,ml,t),s(e,Xe,t),s(e,dl,t),d(Ce,e,t),s(e,fl,t),d($e,e,t),s(e,cl,t),s(e,Re,t),s(e,ul,t),d(Ve,e,t),s(e,Ml,t),s(e,_,t),s(e,yl,t),s(e,Ye,t),s(e,bl,t),d(Se,e,t),s(e,hl,t),s(e,Ee,t),s(e,gl,t),s(e,Ne,t),s(e,Jl,t),d(Qe,e,t),s(e,Tl,t),s(e,B,t),s(e,wl,t),d(Fe,e,t),s(e,Zl,t),s(e,k,t),s(e,Ul,t),d(Le,e,t),s(e,jl,t),d(He,e,t),s(e,Wl,t),s(e,ze,t),s(e,Gl,t),d(qe,e,t),s(e,Il,t),s(e,Pe,t),vl=!0},p:vs,i(e){vl||(f(x.$$.fragment,e),f(X.$$.fragment,e),f(C.$$.fragment,e),f(S.$$.fragment,e),f(E.$$.fragment,e),f(N.$$.fragment,e),f(F.$$.fragment,e),f(H.$$.fragment,e),f(z.$$.fragment,e),f(D.$$.fragment,e),f(A.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(Me.$$.fragment,e),f(he.$$.fragment,e),f(Je.$$.fragment,e),f(we.$$.fragment,e),f(Ue.$$.fragment,e),f(We.$$.fragment,e),f(_e.$$.fragment,e),f(Be.$$.fragment,e),f(xe.$$.fragment,e),f(Ce.$$.fragment,e),f($e.$$.fragment,e),f(Ve.$$.fragment,e),f(Se.$$.fragment,e),f(Qe.$$.fragment,e),f(Fe.$$.fragment,e),f(Le.$$.fragment,e),f(He.$$.fragment,e),f(qe.$$.fragment,e),vl=!0)},o(e){c(x.$$.fragment,e),c(X.$$.fragment,e),c(C.$$.fragment,e),c(S.$$.fragment,e),c(E.$$.fragment,e),c(N.$$.fragment,e),c(F.$$.fragment,e),c(H.$$.fragment,e),c(z.$$.fragment,e),c(D.$$.fragment,e),c(A.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),c(ce.$$.fragment,e),c(Me.$$.fragment,e),c(he.$$.fragment,e),c(Je.$$.fragment,e),c(we.$$.fragment,e),c(Ue.$$.fragment,e),c(We.$$.fragment,e),c(_e.$$.fragment,e),c(Be.$$.fragment,e),c(xe.$$.fragment,e),c(Ce.$$.fragment,e),c($e.$$.fragment,e),c(Ve.$$.fragment,e),c(Se.$$.fragment,e),c(Qe.$$.fragment,e),c(Fe.$$.fragment,e),c(Le.$$.fragment,e),c(He.$$.fragment,e),c(qe.$$.fragment,e),vl=!1},d(e){e&&(l(Ke),l(Ae),l(Oe),l(et),l(tt),l(lt),l($),l(st),l(R),l(at),l(V),l(it),l(Y),l(nt),l(ot),l(g),l(pt),l(rt),l(Q),l(mt),l(dt),l(L),l(ft),l(ct),l(ut),l(q),l(Mt),l(yt),l(J),l(bt),l(ht),l(P),l(gt),l(Jt),l(T),l(Tt),l(wt),l(ee),l(Zt),l(Ut),l(w),l(jt),l(Wt),l(se),l(Gt),l(ae),l(It),l(vt),l(ne),l(_t),l(oe),l(Bt),l(kt),l(re),l(xt),l(Z),l(Xt),l(me),l(Ct),l($t),l(U),l(Rt),l(fe),l(Vt),l(Yt),l(ue),l(St),l(Et),l(ye),l(Nt),l(be),l(Qt),l(Ft),l(j),l(Lt),l(ge),l(Ht),l(zt),l(Te),l(qt),l(Dt),l(W),l(At),l(Ze),l(Pt),l(Kt),l(je),l(Ot),l(G),l(el),l(tl),l(Ge),l(ll),l(Ie),l(sl),l(ve),l(al),l(il),l(I),l(nl),l(ol),l(ke),l(pl),l(rl),l(v),l(ml),l(Xe),l(dl),l(fl),l(cl),l(Re),l(ul),l(Ml),l(_),l(yl),l(Ye),l(bl),l(hl),l(Ee),l(gl),l(Ne),l(Jl),l(Tl),l(B),l(wl),l(Zl),l(k),l(Ul),l(jl),l(Wl),l(ze),l(Gl),l(Il),l(Pe)),l(h),u(x,e),u(X,e),u(C,e),u(S,e),u(E),u(N,e),u(F,e),u(H,e),u(z,e),u(D,e),u(A,e),u(K,e),u(O,e),u(te,e),u(le,e),u(ie,e),u(pe,e),u(de,e),u(ce,e),u(Me,e),u(he,e),u(Je,e),u(we,e),u(Ue,e),u(We,e),u(_e,e),u(Be,e),u(xe,e),u(Ce,e),u($e,e),u(Ve,e),u(Se,e),u(Qe,e),u(Fe,e),u(Le,e),u(He,e),u(qe,e)}}}const Vs='{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Load model checkpoints","local":"load-model-checkpoints","sections":[],"depth":2},{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":2},{"title":"Inpainting","local":"inpainting","sections":[],"depth":2},{"title":"Refine image quality","local":"refine-image-quality","sections":[{"title":"Base + refiner model","local":"base--refiner-model","sections":[],"depth":3},{"title":"Base to refiner model","local":"base-to-refiner-model","sections":[],"depth":3}],"depth":2},{"title":"Micro-conditioning","local":"micro-conditioning","sections":[{"title":"Size conditioning","local":"size-conditioning","sections":[],"depth":3},{"title":"Crop conditioning","local":"crop-conditioning","sections":[],"depth":3}],"depth":2},{"title":"Use a different prompt for each text-encoder","local":"use-a-different-prompt-for-each-text-encoder","sections":[],"depth":2},{"title":"Optimizations","local":"optimizations","sections":[],"depth":2},{"title":"Other resources","local":"other-resources","sections":[],"depth":2}],"depth":1}';function Ys(Xl){return _s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends Bs{constructor(h){super(),ks(this,h,Ys,Rs,Is,{})}}export{Hs as component};
