# IA3

Infused Adapter by Inhibiting and Amplifying Inner Activations, or [IA3](https://hf.co/papers/2205.05638), is a method that adds three learned vectors to rescale the keys and values of the self-attention and encoder-decoder attention layers, and the intermediate activation of the position-wise feed-forward network.

The abstract from the paper is:

*Few-shot in-context learning (ICL) enables pre-trained language models to perform a previously-unseen task without any gradient-based training by feeding a small number of training examples as part of the input. ICL incurs substantial computational, memory, and storage costs because it involves processing all of the training examples every time a prediction is made. Parameter-efficient fine-tuning (PEFT) (e.g. adapter modules, prompt tuning, sparse update methods, etc.) offers an alternative paradigm where a small set of parameters are trained to enable a model to perform the new task. In this paper, we rigorously compare few-shot ICL and PEFT and demonstrate that the latter offers better accuracy as well as dramatically lower computational costs. Along the way, we introduce a new PEFT method called (IA)^3 that scales activations by learned vectors, attaining stronger performance while only introducing a relatively tiny amount of new parameters. We also propose a simple recipe based on the T0 model called T-Few that can be applied to new tasks without task-specific tuning or modifications. We validate the effectiveness of T-Few on completely unseen tasks by applying it to the RAFT benchmark, attaining super-human performance for the first time and outperforming the state-of-the-art by 6% absolute. All of the code used in our experiments is publicly available*.

## IA3Config[[peft.IA3Config]]

#### peft.IA3Config[[peft.IA3Config]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/tuners/ia3/config.py#L25)

This is the configuration class to store the configuration of a [IA3Model](/docs/peft/v0.18.0/en/package_reference/ia3#peft.IA3Model).

**Parameters:**

target_modules (`Optional[Union[List[str], str]]`) : The names of the modules to apply the adapter to. If this is specified, only the modules with the specified names will be replaced. When passing a string, a regex match will be performed. When passing a list of strings, either an exact match will be performed or it is checked if the name of the module ends with any of the passed strings. If this is specified as 'all-linear', then all linear/Conv1D modules are chosen, excluding the output layer. If this is not specified, modules will be chosen according to the model architecture. If the architecture is not known, an error will be raised -- in this case, you should specify the target modules manually.

exclude_modules (`Optional[Union[List[str], str]]`) : The names of the modules to not apply the adapter. When passing a string, a regex match will be performed. When passing a list of strings, either an exact match will be performed or it is checked if the name of the module ends with any of the passed strings.

feedforward_modules (`Optional[Union[List[str], str]]`) : The names of the modules to be treated as feedforward modules, as in the original paper. These modules will have (IA)³ vectors multiplied to the input, instead of the output. `feedforward_modules` must be a name or a subset of names present in `target_modules`.

fan_in_fan_out (`bool`) : Set this to True if the layer to replace stores weight like (fan_in, fan_out). For example, gpt-2 uses `Conv1D` which stores weights like (fan_in, fan_out) and hence this should be set to `True`.

modules_to_save (`Optional[List[str]]`) : List of modules apart from (IA)³ layers to be set as trainable and saved in the final checkpoint.

init_ia3_weights (`bool`) : Whether to initialize the vectors in the (IA)³ layers, defaults to `True`. Setting this to `False` is discouraged.

## IA3Model[[peft.IA3Model]]

#### peft.IA3Model[[peft.IA3Model]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/tuners/ia3/model.py#L36)

Creates a Infused Adapter by Inhibiting and Amplifying Inner Activations ((IA)^3) model from a pretrained
transformers model. The method is described in detail in https://huggingface.co/papers/2205.05638

Example:

```py
>>> from transformers import AutoModelForSeq2SeqLM, ia3Config
>>> from peft import IA3Model, IA3Config

>>> config = IA3Config(
...     peft_type="IA3",
...     task_type="SEQ_2_SEQ_LM",
...     target_modules=["k", "v", "w0"],
...     feedforward_modules=["w0"],
... )

>>> model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")
>>> ia3_model = IA3Model(config, model)
```

**Attributes**:
- **model** ([PreTrainedModel](https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/model#transformers.PreTrainedModel)) -- The model to be adapted.
- **peft_config** (`ia3Config`): The configuration of the (IA)^3 model.

add_weighted_adapterpeft.IA3Model.add_weighted_adapterhttps://github.com/huggingface/peft/blob/v0.18.0/src/peft/tuners/ia3/model.py#L266[{"name": "adapters", "val": ": list[str]"}, {"name": "weights", "val": ": list[float]"}, {"name": "adapter_name", "val": ": str"}]- **adapters** (`list`) --
  List of adapter names to be merged.
- **weights** (`list`) --
  List of weights for each adapter.
- **adapter_name** (`str`) --
  Name of the new adapter.0

This method adds a new adapter by merging the given adapters with the given weights.

**Parameters:**

model ([PreTrainedModel](https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/model#transformers.PreTrainedModel)) : The model to be adapted.

config ([IA3Config](/docs/peft/v0.18.0/en/package_reference/ia3#peft.IA3Config)) : The configuration of the (IA)^3 model.

adapter_name (`str`) : The name of the adapter, defaults to `"default"`.

low_cpu_mem_usage (`bool`, `optional`, defaults to `False`) : Create empty adapter weights on meta device. Useful to speed up the loading process.

**Returns:**

``torch.nn.Module``

The (IA)^3 model.

