# Context-aware Prompt Tuning: Advancing In-Context Learning with Adversarial Methods

[CPT](https://huggingface.co/papers/2410.17222) combines In-Context Learning (ICL), Prompt Tuning (PT), and adversarial optimization to improve few-shot learning by refining context embeddings. CPT updates the context tokens by optimizing both the context and the training examples, encapsulating them into a novel loss design that minimizes overfitting, enables more effective optimization, and drives significant improvements in classification tasks.

[//]: # ([CPT]&#40;https://huggingface.co/papers/2410.17222&#41; for the paper)

The abstract from the paper is:

> Large Language Models (LLMs) can perform few-shot learning using either optimization-based approaches or In-Context Learning (ICL). Optimization-based methods often suffer from overfitting, as they require updating a large number of parameters with limited data. In contrast, ICL avoids overfitting but typically underperforms compared to optimization-based methods and is highly sensitive to the selection, order, and format of demonstration examples. To overcome these challenges, we introduce Context-aware Prompt Tuning (CPT), a method inspired by ICL, Prompt Tuning (PT), and adversarial attacks. CPT builds on the ICL strategy of concatenating examples before the input, extending it by incorporating PT-like learning to refine the context embedding through iterative optimization, extracting deeper insights from the training examples. Our approach carefully modifies specific context tokens, considering the unique structure of the examples within the context. In addition to updating the context with PT-like optimization, CPT draws inspiration from adversarial attacks, adjusting the input based on the labels present in the context while preserving the inherent value of the user-provided data. To ensure robustness and stability during optimization, we employ a projected gradient descent algorithm, constraining token embeddings to remain close to their original values and safeguarding the quality of the context. Our method has demonstrated superior accuracy across multiple classification tasks using various LLM models, outperforming existing baselines and effectively addressing the overfitting challenge in few-shot learning.

Take a look at [Example](https://github.com/huggingface/peft/blob/main/examples/cpt_finetuning/README.md) for a step-by-step guide on how to train a model with CPT.

## CPTConfig[[peft.CPTConfig]]

#### peft.CPTConfig[[peft.CPTConfig]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/tuners/cpt/config.py#L23)

CPT Configuration class extending PeftConfig for Context-aware Prompt Tuning (CPT).

This class introduces additional parameters required for CPT, such as:
- Token type masks
- Prompt tuning initialization
- Loss weighting
- Projection settings

For more details, see the paper: https://huggingface.co/papers/2410.17222

## CPTEmbedding[[peft.CPTEmbedding]]

#### peft.CPTEmbedding[[peft.CPTEmbedding]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/tuners/cpt/model.py#L23)

CPTEmbedding is a custom embedding layer designed for Context-aware Prompt Tuning (CPT) in PEFT. It initializes
embeddings, applies prompt-specific projections, and computes loss using label masks.

calculate_losspeft.CPTEmbedding.calculate_losshttps://github.com/huggingface/peft/blob/v0.18.0/src/peft/tuners/cpt/model.py#L143[{"name": "base_model_output", "val": ""}, {"name": "labels", "val": ""}, {"name": "cpt_type_mask", "val": ""}, {"name": "config", "val": ""}]- **base_model_output** (ModelOutput) --
  Output from the base model containing logits.
- **labels** (torch.Tensor) --
  Ground-truth labels for the input tokens.
- **cpt_type_mask** (torch.Tensor) --
  Token type mask used for filtering valid loss terms.
- **config** (Namespace) --
  Configuration object containing loss-related hyperparameters.0ModelOutputThe base model output with computed loss.

Computes the loss for CPT models with optional exponential decay.

**Parameters:**

base_model_output (ModelOutput) : Output from the base model containing logits.

labels (torch.Tensor) : Ground-truth labels for the input tokens.

cpt_type_mask (torch.Tensor) : Token type mask used for filtering valid loss terms.

config (Namespace) : Configuration object containing loss-related hyperparameters.

**Returns:**

`ModelOutput`

The base model output with computed loss.
#### forward[[peft.CPTEmbedding.forward]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/tuners/cpt/model.py#L65)

Computes the prompt embeddings and applies delta adjustments.

**Parameters:**

indices (torch.Tensor) : Indices of the tokens to be embedded.

**Returns:**

`torch.Tensor`

Sum of prompt embeddings and delta embeddings.
#### get_projection[[peft.CPTEmbedding.get_projection]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/tuners/cpt/model.py#L125)

Applies epsilon-based projection to the delta embeddings to control their norm.
#### set_updated_tokens[[peft.CPTEmbedding.set_updated_tokens]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/tuners/cpt/model.py#L86)

Sets up a backward hook to selectively update token gradients based on the CPT token type mask.

