# AutoPeftModels

The `AutoPeftModel` classes loads the appropriate PEFT model for the task type by automatically inferring it from the configuration file. They are designed to quickly and easily load a PEFT model in a single line of code without having to worry about which exact model class you need or manually loading a [PeftConfig](/docs/peft/v0.18.0/en/package_reference/config#peft.PeftConfig).

## AutoPeftModel[[peft.AutoPeftModel]]

#### peft.AutoPeftModel[[peft.AutoPeftModel]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/auto.py#L152)

from_pretrainedpeft.AutoPeftModel.from_pretrainedhttps://github.com/huggingface/peft/blob/v0.18.0/src/peft/auto.py#L67[{"name": "pretrained_model_name_or_path", "val": ""}, {"name": "adapter_name", "val": ": str = 'default'"}, {"name": "is_trainable", "val": ": bool = False"}, {"name": "config", "val": ": Optional[PeftConfig] = None"}, {"name": "revision", "val": ": Optional[str] = None"}, {"name": "**kwargs", "val": ""}]

A wrapper around all the preprocessing steps a user needs to perform in order to load a PEFT model. The kwargs
are passed along to `PeftConfig` that automatically takes care of filtering the kwargs of the Hub methods and
the config object init.

## AutoPeftModelForCausalLM[[peft.AutoPeftModelForCausalLM]]

#### peft.AutoPeftModelForCausalLM[[peft.AutoPeftModelForCausalLM]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/auto.py#L157)

## AutoPeftModelForSeq2SeqLM[[peft.AutoPeftModelForSeq2SeqLM]]

#### peft.AutoPeftModelForSeq2SeqLM[[peft.AutoPeftModelForSeq2SeqLM]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/auto.py#L162)

## AutoPeftModelForSequenceClassification[[peft.AutoPeftModelForSequenceClassification]]

#### peft.AutoPeftModelForSequenceClassification[[peft.AutoPeftModelForSequenceClassification]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/auto.py#L167)

## AutoPeftModelForTokenClassification[[peft.AutoPeftModelForTokenClassification]]

#### peft.AutoPeftModelForTokenClassification[[peft.AutoPeftModelForTokenClassification]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/auto.py#L172)

## AutoPeftModelForQuestionAnswering[[peft.AutoPeftModelForQuestionAnswering]]

#### peft.AutoPeftModelForQuestionAnswering[[peft.AutoPeftModelForQuestionAnswering]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/auto.py#L177)

## AutoPeftModelForFeatureExtraction[[peft.AutoPeftModelForFeatureExtraction]]

#### peft.AutoPeftModelForFeatureExtraction[[peft.AutoPeftModelForFeatureExtraction]]

[Source](https://github.com/huggingface/peft/blob/v0.18.0/src/peft/auto.py#L182)

