import{s as Zt,o as kt,n as nt}from"../chunks/scheduler.78382b47.js";import{S as Bt,i as Gt,e as d,s as n,c as J,h as Wt,a as u,d as e,b as p,f as _t,g as y,j as U,k as yl,l as Vt,m as s,n as T,t as h,o as w,p as f}from"../chunks/index.6dd35eb6.js";import{C as Xt,H as ul,E as $t}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6888f903.js";import{C as I}from"../chunks/CodeBlock.658dd679.js";import{H as Rt,a as at}from"../chunks/HfOption.a1db6210.js";function vt(g){let i,b='<a href="../conceptual_guides/prompting#p-tuning">P-tuning</a> adds a trainable embedding tensor where the prompt tokens can be added anywhere in the input sequence. Create a <a href="/docs/peft/v0.18.0/en/package_reference/p_tuning#peft.PromptEncoderConfig">PromptEncoderConfig</a> with the task type, the number of virtual tokens to add and learn, and the hidden size of the encoder for learning the prompt parameters.',r,M,m;return M=new I({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQcm9tcHRFbmNvZGVyQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMFByb21wdEVuY29kZXJDb25maWcodGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTIwbnVtX3ZpcnR1YWxfdG9rZW5zJTNEMjAlMkMlMjBlbmNvZGVyX2hpZGRlbl9zaXplJTNEMTI4KSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMzAwJTJDMjg4JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwNTU5JTJDNTE0JTJDODgwJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMC4wNTM2NjkzNTAxMzQxNzMzOCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PromptEncoderConfig, get_peft_model

peft_config = PromptEncoderConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>, num_virtual_tokens=<span class="hljs-number">20</span>, encoder_hidden_size=<span class="hljs-number">128</span>)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 300,288 || all params: 559,514,880 || trainable%: 0.05366935013417338&quot;</span>`,wrap:!1}}),{c(){i=d("p"),i.innerHTML=b,r=n(),J(M.$$.fragment)},l(o){i=u(o,"P",{"data-svelte-h":!0}),U(i)!=="svelte-rpe1ri"&&(i.innerHTML=b),r=p(o),y(M.$$.fragment,o)},m(o,a){s(o,i,a),s(o,r,a),T(M,o,a),m=!0},p:nt,i(o){m||(h(M.$$.fragment,o),m=!0)},o(o){w(M.$$.fragment,o),m=!1},d(o){o&&(e(i),e(r)),f(M,o)}}}function Nt(g){let i,b='<a href="../conceptual_guides/prompting#prefix-tuning">Prefix tuning</a> adds task-specific parameters in all of the model layers, which are optimized by a separate feed-forward network. Create a <a href="/docs/peft/v0.18.0/en/package_reference/prefix_tuning#peft.PrefixTuningConfig">PrefixTuningConfig</a> with the task type and number of virtual tokens to add and learn.',r,M,m;return M=new I({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQcmVmaXhUdW5pbmdDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwUHJlZml4VHVuaW5nQ29uZmlnKHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUyMG51bV92aXJ0dWFsX3Rva2VucyUzRDIwKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwOTgzJTJDMDQwJTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwNTYwJTJDMTk3JTJDNjMyJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMC4xNzU0ODA5Mjc0MTY3MDE0JTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PrefixTuningConfig, get_peft_model

peft_config = PrefixTuningConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>, num_virtual_tokens=<span class="hljs-number">20</span>)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 983,040 || all params: 560,197,632 || trainable%: 0.1754809274167014&quot;</span>`,wrap:!1}}),{c(){i=d("p"),i.innerHTML=b,r=n(),J(M.$$.fragment)},l(o){i=u(o,"P",{"data-svelte-h":!0}),U(i)!=="svelte-1rck8a4"&&(i.innerHTML=b),r=p(o),y(M.$$.fragment,o)},m(o,a){s(o,i,a),s(o,r,a),T(M,o,a),m=!0},p:nt,i(o){m||(h(M.$$.fragment,o),m=!0)},o(o){w(M.$$.fragment,o),m=!1},d(o){o&&(e(i),e(r)),f(M,o)}}}function zt(g){let i,b='<a href="../conceptual_guides/prompting#prompt-tuning">Prompt tuning</a> formulates all tasks as a <em>generation</em> task and it adds a task-specific prompt to the input which is updated independently. The <code>prompt_tuning_init_text</code> parameter specifies how to finetune the model (in this case, it is classifying whether tweets are complaints or not). For the best results, the <code>prompt_tuning_init_text</code> should have the same number of tokens that should be predicted. To do this, you can set <code>num_virtual_tokens</code> to the number of tokens of the <code>prompt_tuning_init_text</code>.',r,M,m='Create a <a href="/docs/peft/v0.18.0/en/package_reference/prompt_tuning#peft.PromptTuningConfig">PromptTuningConfig</a> with the task type, the initial prompt tuning text to train the model with, the number of virtual tokens to add and learn, and a tokenizer.',o,a,j;return a=new I({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQcm9tcHRUdW5pbmdDb25maWclMkMlMjBQcm9tcHRUdW5pbmdJbml0JTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFwcm9tcHRfdHVuaW5nX2luaXRfdGV4dCUyMCUzRCUyMCUyMkNsYXNzaWZ5JTIwaWYlMjB0aGUlMjB0d2VldCUyMGlzJTIwYSUyMGNvbXBsYWludCUyMG9yJTIwbm8lMjBjb21wbGFpbnQuJTVDbiUyMiUwQXBlZnRfY29uZmlnJTIwJTNEJTIwUHJvbXB0VHVuaW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90dW5pbmdfaW5pdCUzRFByb21wdFR1bmluZ0luaXQuVEVYVCUyQyUwQSUyMCUyMCUyMCUyMG51bV92aXJ0dWFsX3Rva2VucyUzRGxlbih0b2tlbml6ZXIocHJvbXB0X3R1bmluZ19pbml0X3RleHQpJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90dW5pbmdfaW5pdF90ZXh0JTNEcHJvbXB0X3R1bmluZ19pbml0X3RleHQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfbmFtZV9vcl9wYXRoJTNEJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwOCUyQzE5MiUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDU1OSUyQzIyMiUyQzc4NCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuMDAxNDY0ODkwMjQzMDk4NTM1OCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PromptTuningConfig, PromptTuningInit, get_peft_model

prompt_tuning_init_text = <span class="hljs-string">&quot;Classify if the tweet is a complaint or no complaint.\\n&quot;</span>
peft_config = PromptTuningConfig(
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
    prompt_tuning_init=PromptTuningInit.TEXT,
    num_virtual_tokens=<span class="hljs-built_in">len</span>(tokenizer(prompt_tuning_init_text)[<span class="hljs-string">&quot;input_ids&quot;</span>]),
    prompt_tuning_init_text=prompt_tuning_init_text,
    tokenizer_name_or_path=<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>,
)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 8,192 || all params: 559,222,784 || trainable%: 0.0014648902430985358&quot;</span>`,wrap:!1}}),{c(){i=d("p"),i.innerHTML=b,r=n(),M=d("p"),M.innerHTML=m,o=n(),J(a.$$.fragment)},l(c){i=u(c,"P",{"data-svelte-h":!0}),U(i)!=="svelte-1vtqt32"&&(i.innerHTML=b),r=p(c),M=u(c,"P",{"data-svelte-h":!0}),U(M)!=="svelte-ehika4"&&(M.innerHTML=m),o=p(c),y(a.$$.fragment,c)},m(c,C){s(c,i,C),s(c,r,C),s(c,M,C),s(c,o,C),T(a,c,C),j=!0},p:nt,i(c){j||(h(a.$$.fragment,c),j=!0)},o(c){w(a.$$.fragment,c),j=!1},d(c){c&&(e(i),e(r),e(M),e(o)),f(a,c)}}}function Et(g){let i,b,r,M,m,o;return i=new at({props:{id:"configurations",option:"p-tuning",$$slots:{default:[vt]},$$scope:{ctx:g}}}),r=new at({props:{id:"configurations",option:"prefix tuning",$$slots:{default:[Nt]},$$scope:{ctx:g}}}),m=new at({props:{id:"configurations",option:"prompt tuning",$$slots:{default:[zt]},$$scope:{ctx:g}}}),{c(){J(i.$$.fragment),b=n(),J(r.$$.fragment),M=n(),J(m.$$.fragment)},l(a){y(i.$$.fragment,a),b=p(a),y(r.$$.fragment,a),M=p(a),y(m.$$.fragment,a)},m(a,j){T(i,a,j),s(a,b,j),T(r,a,j),s(a,M,j),T(m,a,j),o=!0},p(a,j){const c={};j&2&&(c.$$scope={dirty:j,ctx:a}),i.$set(c);const C={};j&2&&(C.$$scope={dirty:j,ctx:a}),r.$set(C);const G={};j&2&&(G.$$scope={dirty:j,ctx:a}),m.$set(G)},i(a){o||(h(i.$$.fragment,a),h(r.$$.fragment,a),h(m.$$.fragment,a),o=!0)},o(a){w(i.$$.fragment,a),w(r.$$.fragment,a),w(m.$$.fragment,a),o=!1},d(a){a&&(e(b),e(M)),f(i,a),f(r,a),f(m,a)}}}function Ft(g){let i,b,r,M,m,o,a,j,c,C="A prompt can describe a task or provide an example of a task you want the model to learn. Instead of manually creating these prompts, soft prompting methods add learnable parameters to the input embeddings that can be optimized for a specific task while keeping the pretrained model’s parameters frozen. This makes it both faster and easier to finetune large language models (LLMs) for new downstream tasks.",G,W,pt='The PEFT library supports several types of prompting methods (p-tuning, prefix tuning, prompt tuning) and you can learn more about how these methods work conceptually in the <a href="../conceptual_guides/prompting">Soft prompts</a> guide. If you’re interested in applying these methods to other tasks and use cases, take a look at our <a href="https://huggingface.co/spaces/PEFT/soft-prompting" rel="nofollow">notebook collection</a>!',Tl,V,ot="This guide will show you how to train a causal language model - with a soft prompting method - to <em>generate a classification</em> for whether a tweet is a complaint or not.",hl,_,it='<p>Some familiarity with the general process of training a causal language model would be really helpful and allow you to focus on the soft prompting methods. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/language_modeling" rel="nofollow">Causal language modeling</a> guide first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!</p>',wl,X,Mt="Before you begin, make sure you have all the necessary libraries installed.",fl,$,Ul,R,jl,v,rt='For this guide, you’ll use the <code>twitter_complaints</code> subset of the <a href="https://huggingface.co/datasets/ought/raft" rel="nofollow">RAFT</a> dataset. The <code>twitter_complaints</code> subset contains tweets labeled as <code>complaint</code> and <code>no complaint</code> and you can check out the <a href="https://huggingface.co/datasets/ought/raft/viewer/twitter_complaints" rel="nofollow">dataset viewer</a> for a better idea of what the data looks like.',bl,N,mt='Use the <a href="https://huggingface.co/docs/datasets/v4.4.1/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">load_dataset</a> function to load the dataset and create a new <code>text_label</code> column so it is easier to understand what the <code>Label</code> values, <code>1</code> and <code>2</code> mean.',Il,z,Cl,E,ct="Load a tokenizer, define the padding token to use, and determine the maximum length of the tokenized label.",gl,F,_l,Q,dt="Create a preprocessing function that tokenizes the tweet text and labels, pad the inputs and labels in each batch, create an attention mask, and truncate sequences to the <code>max_length</code>. Then convert the <code>input_ids</code>, <code>attention_mask</code>, and <code>labels</code> to PyTorch tensors.",Zl,x,kl,Y,ut='Apply the preprocessing function to the entire dataset with the <a href="https://huggingface.co/docs/datasets/v4.4.1/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> function, and remove the unprocessed columns because the model won’t need them.',Bl,A,Gl,H,Jt='Finally, create a training and evaluation <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a>. You can set <code>pin_memory=True</code> to speed up the data transfer to the GPU during training if the samples in your dataset are on a CPU.',Wl,q,Vl,S,Xl,L,yt='Now let’s load a pretrained model to use as the base model for the soft prompt method. This guide uses the <a href="https://huggingface.co/bigscience/bloomz-560m" rel="nofollow">bigscience/bloomz-560m</a> model, but you can use any causal language model you want.',$l,D,Rl,P,vl,K,Tt='For any PEFT method, you’ll need to create a configuration which contains all the parameters that specify how the PEFT method should be applied. Once the configuration is setup, pass it to the <a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Nl,Z,ht='<p>Call the <a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of trainable parameters of <a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!</p>',zl,k,El,O,Fl,ll,wt="Set up an optimizer and learning rate scheduler.",Ql,tl,xl,el,ft="Move the model to the GPU and create a training loop that reports the loss and perplexity for each epoch.",Yl,sl,Al,al,Hl,nl,Ut='Once training is complete, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.',ql,pl,Sl,ol,jt="If you check the model file size in the repository, you’ll see that it is a lot smaller than a full sized model!",Ll,B,bt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/PEFT-hub-screenshot.png"/> <figcaption class="text-center">For example, the adapter weights for a opt-350m model stored on the Hub are only ~6MB compared to the full model size which can be ~700MB.</figcaption>',Dl,il,Pl,Ml,It="Let’s load the model for inference and test it out on a tweet!",Kl,rl,Ol,ml,Ct='Call the <a href="https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow">generate</a> method to generate the predicted classification label.',lt,cl,tt,dl,et,Jl,st;return m=new Xt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),a=new ul({props:{title:"Prompt-based methods",local:"prompt-based-methods",headingTag:"h1"}}),$=new I({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcGVmdCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRz",highlighted:"pip install -q peft transformers datasets",wrap:!1}}),R=new ul({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),z=new I({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIycGFycXVldCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfZmlsZXMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFpbiUyMiUzQSUyMCUyMmhmJTNBJTJGJTJGZGF0YXNldHMlMkZvdWdodCUyRnJhZnQlNDByZWZzJTJGY29udmVydCUyRnBhcnF1ZXQlMkZ0d2l0dGVyX2NvbXBsYWludHMlMkZ0cmFpbiUyRjAwMDAucGFycXVldCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlc3QlMjIlM0ElMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGb3VnaHQlMkZyYWZ0JTQwcmVmcyUyRmNvbnZlcnQlMkZwYXJxdWV0JTJGdHdpdHRlcl9jb21wbGFpbnRzJTJGdGVzdCUyRjAwMDAucGFycXVldCUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSklMEElMEFjbGFzc2VzJTIwJTNEJTIwJTVCay5yZXBsYWNlKCUyMl8lMjIlMkMlMjAlMjIlMjAlMjIpJTIwZm9yJTIwayUyMGluJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMkxhYmVsJTIyJTVELm5hbWVzJTVEJTBBZHMlMjAlM0QlMjBkcy5tYXAoJTBBJTIwJTIwJTIwJTIwbGFtYmRhJTIweCUzQSUyMCU3QiUyMnRleHRfbGFiZWwlMjIlM0ElMjAlNUJjbGFzc2VzJTVCbGFiZWwlNUQlMjBmb3IlMjBsYWJlbCUyMGluJTIweCU1QiUyMkxhYmVsJTIyJTVEJTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBudW1fcHJvYyUzRDElMkMlMEEpJTBBZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQlMEElN0IlMjJUd2VldCUyMHRleHQlMjIlM0ElMjAlMjIlNDBITVJDY3VzdG9tZXJzJTIwTm8lMjB0aGlzJTIwaXMlMjBteSUyMGZpcnN0JTIwam9iJTIyJTJDJTIwJTIySUQlMjIlM0ElMjAwJTJDJTIwJTIyTGFiZWwlMjIlM0ElMjAyJTJDJTIwJTIydGV4dF9sYWJlbCUyMiUzQSUyMCUyMm5vJTIwY29tcGxhaW50JTIyJTdE",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(
    <span class="hljs-string">&quot;parquet&quot;</span>,
    data_files={
        <span class="hljs-string">&quot;train&quot;</span>: <span class="hljs-string">&quot;hf://datasets/ought/raft@refs/convert/parquet/twitter_complaints/train/0000.parquet&quot;</span>,
        <span class="hljs-string">&quot;test&quot;</span>: <span class="hljs-string">&quot;hf://datasets/ought/raft@refs/convert/parquet/twitter_complaints/test/0000.parquet&quot;</span>
    }
)

classes = [k.replace(<span class="hljs-string">&quot;_&quot;</span>, <span class="hljs-string">&quot; &quot;</span>) <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;Label&quot;</span>].names]
ds = ds.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;text_label&quot;</span>: [classes[label] <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> x[<span class="hljs-string">&quot;Label&quot;</span>]]},
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
)
ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&quot;Tweet text&quot;</span>: <span class="hljs-string">&quot;@HMRCcustomers No this is my first job&quot;</span>, <span class="hljs-string">&quot;ID&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;Label&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;text_label&quot;</span>: <span class="hljs-string">&quot;no complaint&quot;</span>}`,wrap:!1}}),F=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBaWYlMjB0b2tlbml6ZXIucGFkX3Rva2VuX2lkJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyLnBhZF90b2tlbl9pZCUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW5faWQlMEF0YXJnZXRfbWF4X2xlbmd0aCUyMCUzRCUyMG1heCglNUJsZW4odG9rZW5pemVyKGNsYXNzX2xhYmVsKSU1QiUyMmlucHV0X2lkcyUyMiU1RCklMjBmb3IlMjBjbGFzc19sYWJlbCUyMGluJTIwY2xhc3NlcyU1RCklMEFwcmludCh0YXJnZXRfbWF4X2xlbmd0aCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-keyword">if</span> tokenizer.pad_token_id <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    tokenizer.pad_token_id = tokenizer.eos_token_id
target_max_length = <span class="hljs-built_in">max</span>([<span class="hljs-built_in">len</span>(tokenizer(class_label)[<span class="hljs-string">&quot;input_ids&quot;</span>]) <span class="hljs-keyword">for</span> class_label <span class="hljs-keyword">in</span> classes])
<span class="hljs-built_in">print</span>(target_max_length)`,wrap:!1}}),x=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch

max_length = <span class="hljs-number">64</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples, text_column=<span class="hljs-string">&quot;Tweet text&quot;</span>, label_column=<span class="hljs-string">&quot;text_label&quot;</span></span>):
    batch_size = <span class="hljs-built_in">len</span>(examples[text_column])
    inputs = [<span class="hljs-string">f&quot;<span class="hljs-subst">{text_column}</span> : <span class="hljs-subst">{x}</span> Label : &quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples[text_column]]
    targets = [<span class="hljs-built_in">str</span>(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples[label_column]]
    model_inputs = tokenizer(inputs)
    labels = tokenizer(targets)
    classes = [k.replace(<span class="hljs-string">&quot;_&quot;</span>, <span class="hljs-string">&quot; &quot;</span>) <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;Label&quot;</span>].names]
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size):
        sample_input_ids = model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i]
        label_input_ids = labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i]
        model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = [tokenizer.pad_token_id] * (
            max_length - <span class="hljs-built_in">len</span>(sample_input_ids)
        ) + sample_input_ids
        model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i] = [<span class="hljs-number">0</span>] * (max_length - <span class="hljs-built_in">len</span>(sample_input_ids)) + model_inputs[
            <span class="hljs-string">&quot;attention_mask&quot;</span>
        ][i]
        labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = [-<span class="hljs-number">100</span>] * (max_length - <span class="hljs-built_in">len</span>(label_input_ids)) + label_input_ids
        model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = torch.tensor(model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i][:max_length])
        model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i] = torch.tensor(model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i][:max_length])
        labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = torch.tensor(labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i][:max_length])
    model_inputs[<span class="hljs-string">&quot;labels&quot;</span>] = labels[<span class="hljs-string">&quot;input_ids&quot;</span>]
    <span class="hljs-keyword">return</span> model_inputs`,wrap:!1}}),A=new I({props:{code:"cHJvY2Vzc2VkX2RzJTIwJTNEJTIwZHMubWFwKCUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3NfZnVuY3Rpb24lMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV9jb2x1bW5zJTNEZHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXMlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Zyb21fY2FjaGVfZmlsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwZGVzYyUzRCUyMlJ1bm5pbmclMjB0b2tlbml6ZXIlMjBvbiUyMGRhdGFzZXQlMjIlMkMlMEEp",highlighted:`processed_ds = ds.<span class="hljs-built_in">map</span>(
    preprocess_function,
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
    remove_columns=ds[<span class="hljs-string">&quot;train&quot;</span>].column_names,
    load_from_cache_file=<span class="hljs-literal">False</span>,
    desc=<span class="hljs-string">&quot;Running tokenizer on dataset&quot;</span>,
)`,wrap:!1}}),q=new I({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGRlZmF1bHRfZGF0YV9jb2xsYXRvciUwQSUwQXRyYWluX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydHJhaW4lMjIlNUQlMEFldmFsX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydGVzdCUyMiU1RCUwQSUwQWJhdGNoX3NpemUlMjAlM0QlMjAxNiUwQSUwQXRyYWluX2RhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKHRyYWluX2RzJTJDJTIwc2h1ZmZsZSUzRFRydWUlMkMlMjBjb2xsYXRlX2ZuJTNEZGVmYXVsdF9kYXRhX2NvbGxhdG9yJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBwaW5fbWVtb3J5JTNEVHJ1ZSklMEFldmFsX2RhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKGV2YWxfZHMlMkMlMjBjb2xsYXRlX2ZuJTNEZGVmYXVsdF9kYXRhX2NvbGxhdG9yJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBwaW5fbWVtb3J5JTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> default_data_collator

train_ds = processed_ds[<span class="hljs-string">&quot;train&quot;</span>]
eval_ds = processed_ds[<span class="hljs-string">&quot;test&quot;</span>]

batch_size = <span class="hljs-number">16</span>

train_dataloader = DataLoader(train_ds, shuffle=<span class="hljs-literal">True</span>, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)
eval_dataloader = DataLoader(eval_ds, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)`,wrap:!1}}),S=new ul({props:{title:"Model",local:"model",headingTag:"h2"}}),D=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)`,wrap:!1}}),P=new ul({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),k=new Rt({props:{id:"configurations",options:["p-tuning","prefix tuning","prompt tuning"],$$slots:{default:[Et]},$$scope:{ctx:g}}}),O=new ul({props:{title:"Training",local:"training",headingTag:"h3"}}),tl=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9saW5lYXJfc2NoZWR1bGVfd2l0aF93YXJtdXAlMEElMEFsciUyMCUzRCUyMDNlLTIlMEFudW1fZXBvY2hzJTIwJTNEJTIwNTAlMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjB0b3JjaC5vcHRpbS5BZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRGxyKSUwQWxyX3NjaGVkdWxlciUyMCUzRCUyMGdldF9saW5lYXJfc2NoZWR1bGVfd2l0aF93YXJtdXAoJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3dhcm11cF9zdGVwcyUzRDAlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0QobGVuKHRyYWluX2RhdGFsb2FkZXIpJTIwKiUyMG51bV9lcG9jaHMpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_linear_schedule_with_warmup

lr = <span class="hljs-number">3e-2</span>
num_epochs = <span class="hljs-number">50</span>

optimizer = torch.optim.AdamW(model.parameters(), lr=lr)
lr_scheduler = get_linear_schedule_with_warmup(
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * num_epochs),
)`,wrap:!1}}),sl=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

device = <span class="hljs-string">&quot;cuda&quot;</span>
model = model.to(device)

<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    model.train()
    total_loss = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(train_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        total_loss += loss.detach().<span class="hljs-built_in">float</span>()
        loss.backward()
        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()

    model.<span class="hljs-built_in">eval</span>()
    eval_loss = <span class="hljs-number">0</span>
    eval_preds = []
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(eval_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        <span class="hljs-keyword">with</span> torch.no_grad():
            outputs = model(**batch)
        loss = outputs.loss
        eval_loss += loss.detach().<span class="hljs-built_in">float</span>()
        eval_preds.extend(
            tokenizer.batch_decode(torch.argmax(outputs.logits, -<span class="hljs-number">1</span>).detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>)
        )

    eval_epoch_loss = eval_loss / <span class="hljs-built_in">len</span>(eval_dataloader)
    eval_ppl = torch.exp(eval_epoch_loss)
    train_epoch_loss = total_loss / <span class="hljs-built_in">len</span>(train_dataloader)
    train_ppl = torch.exp(train_epoch_loss)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{epoch=}</span>: <span class="hljs-subst">{train_ppl=}</span> <span class="hljs-subst">{train_epoch_loss=}</span> <span class="hljs-subst">{eval_ppl=}</span> <span class="hljs-subst">{eval_epoch_loss=}</span>&quot;</span>)`,wrap:!1}}),al=new ul({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),pl=new I({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBYWNjb3VudCUyMCUzRCUyMCUzQ3lvdXItaGYtYWNjb3VudC1uYW1lJTNFJTBBcGVmdF9tb2RlbF9pZCUyMCUzRCUyMGYlMjIlN0JhY2NvdW50JTdEJTJGYmxvb216LTU2MC1tLXBlZnQtbWV0aG9kJTIyJTBBbW9kZWwucHVzaF90b19odWIocGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

account = &lt;your-hf-account-name&gt;
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/bloomz-560-m-peft-method&quot;</span>
model.push_to_hub(peft_model_id)`,wrap:!1}}),il=new ul({props:{title:"Inference",local:"inference",headingTag:"h2"}}),rl=new I({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBdXRvUGVmdE1vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9QZWZ0TW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIycGVmdF9tb2RlbF9pZCUyMikudG8oJTIyY3VkYSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaSUyMCUzRCUyMDE1JTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGYnJTdCdGV4dF9jb2x1bW4lN0QlMjAlM0ElMjAlN0JkcyU1QiUyMnRlc3QlMjIlNUQlNUJpJTVEJTVCJTIyVHdlZXQlMjB0ZXh0JTIyJTVEJTdEJTIwTGFiZWwlMjAlM0ElMjAnJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludChkcyU1QiUyMnRlc3QlMjIlNUQlNUJpJTVEJTVCJTIyVHdlZXQlMjB0ZXh0JTIyJTVEKSUwQSUyMiU0ME5ZVHN1cHBvcnQlMjBpJTIwaGF2ZSUyMGNvbXBsYWluZWQlMjBhJTIwZG96ZW4lMjB0aW1lcyUyMCUyNmFtcCUzQiUyMHlldCUyMG15JTIwcGFwZXJzJTIwYXJlJTIwc3RpbGwlMjB0aHJvd24lMjBGQVIlMjBmcm9tJTIwbXklMjBkb29yLiUyMFdoeSUyMGlzJTIwdGhpcyUyMHNvJTIwaGFyZCUyMHRvJTIwcmVzb2x2ZSUzRiUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AutoPeftModelForCausalLM

model = AutoPeftModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;peft_model_id&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

i = <span class="hljs-number">15</span>
inputs = tokenizer(<span class="hljs-string">f&#x27;<span class="hljs-subst">{text_column}</span> : <span class="hljs-subst">{ds[<span class="hljs-string">&quot;test&quot;</span>][i][<span class="hljs-string">&quot;Tweet text&quot;</span>]}</span> Label : &#x27;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(ds[<span class="hljs-string">&quot;test&quot;</span>][i][<span class="hljs-string">&quot;Tweet text&quot;</span>])
<span class="hljs-string">&quot;@NYTsupport i have complained a dozen times &amp;amp; yet my papers are still thrown FAR from my door. Why is this so hard to resolve?&quot;</span>`,wrap:!1}}),cl=new I({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMjIlNUInVHdlZXQlMjB0ZXh0JTIwJTNBJTIwJTQwTllUc3VwcG9ydCUyMGklMjBoYXZlJTIwY29tcGxhaW5lZCUyMGElMjBkb3plbiUyMHRpbWVzJTIwJTI2YW1wJTNCJTIweWV0JTIwbXklMjBwYXBlcnMlMjBhcmUlMjBzdGlsbCUyMHRocm93biUyMEZBUiUyMGZyb20lMjBteSUyMGRvb3IuJTIwV2h5JTIwaXMlMjB0aGlzJTIwc28lMjBoYXJkJTIwdG8lMjByZXNvbHZlJTNGJTIwTGFiZWwlMjAlM0ElMjBjb21wbGFpbnQnJTVEJTIy",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
    outputs = model.generate(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">10</span>)
    <span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>))
<span class="hljs-string">&quot;[&#x27;Tweet text : @NYTsupport i have complained a dozen times &amp;amp; yet my papers are still thrown FAR from my door. Why is this so hard to resolve? Label : complaint&#x27;]&quot;</span>`,wrap:!1}}),dl=new $t({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/task_guides/prompt_based_methods.md"}}),{c(){i=d("meta"),b=n(),r=d("p"),M=n(),J(m.$$.fragment),o=n(),J(a.$$.fragment),j=n(),c=d("p"),c.textContent=C,G=n(),W=d("p"),W.innerHTML=pt,Tl=n(),V=d("p"),V.innerHTML=ot,hl=n(),_=d("blockquote"),_.innerHTML=it,wl=n(),X=d("p"),X.textContent=Mt,fl=n(),J($.$$.fragment),Ul=n(),J(R.$$.fragment),jl=n(),v=d("p"),v.innerHTML=rt,bl=n(),N=d("p"),N.innerHTML=mt,Il=n(),J(z.$$.fragment),Cl=n(),E=d("p"),E.textContent=ct,gl=n(),J(F.$$.fragment),_l=n(),Q=d("p"),Q.innerHTML=dt,Zl=n(),J(x.$$.fragment),kl=n(),Y=d("p"),Y.innerHTML=ut,Bl=n(),J(A.$$.fragment),Gl=n(),H=d("p"),H.innerHTML=Jt,Wl=n(),J(q.$$.fragment),Vl=n(),J(S.$$.fragment),Xl=n(),L=d("p"),L.innerHTML=yt,$l=n(),J(D.$$.fragment),Rl=n(),J(P.$$.fragment),vl=n(),K=d("p"),K.innerHTML=Tt,Nl=n(),Z=d("blockquote"),Z.innerHTML=ht,zl=n(),J(k.$$.fragment),El=n(),J(O.$$.fragment),Fl=n(),ll=d("p"),ll.textContent=wt,Ql=n(),J(tl.$$.fragment),xl=n(),el=d("p"),el.textContent=ft,Yl=n(),J(sl.$$.fragment),Al=n(),J(al.$$.fragment),Hl=n(),nl=d("p"),nl.innerHTML=Ut,ql=n(),J(pl.$$.fragment),Sl=n(),ol=d("p"),ol.textContent=jt,Ll=n(),B=d("div"),B.innerHTML=bt,Dl=n(),J(il.$$.fragment),Pl=n(),Ml=d("p"),Ml.textContent=It,Kl=n(),J(rl.$$.fragment),Ol=n(),ml=d("p"),ml.innerHTML=Ct,lt=n(),J(cl.$$.fragment),tt=n(),J(dl.$$.fragment),et=n(),Jl=d("p"),this.h()},l(l){const t=Wt("svelte-u9bgzb",document.head);i=u(t,"META",{name:!0,content:!0}),t.forEach(e),b=p(l),r=u(l,"P",{}),_t(r).forEach(e),M=p(l),y(m.$$.fragment,l),o=p(l),y(a.$$.fragment,l),j=p(l),c=u(l,"P",{"data-svelte-h":!0}),U(c)!=="svelte-1nma30k"&&(c.textContent=C),G=p(l),W=u(l,"P",{"data-svelte-h":!0}),U(W)!=="svelte-qxepz2"&&(W.innerHTML=pt),Tl=p(l),V=u(l,"P",{"data-svelte-h":!0}),U(V)!=="svelte-10gyoze"&&(V.innerHTML=ot),hl=p(l),_=u(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),U(_)!=="svelte-1p5rdzu"&&(_.innerHTML=it),wl=p(l),X=u(l,"P",{"data-svelte-h":!0}),U(X)!=="svelte-1rdzhb1"&&(X.textContent=Mt),fl=p(l),y($.$$.fragment,l),Ul=p(l),y(R.$$.fragment,l),jl=p(l),v=u(l,"P",{"data-svelte-h":!0}),U(v)!=="svelte-b49pm"&&(v.innerHTML=rt),bl=p(l),N=u(l,"P",{"data-svelte-h":!0}),U(N)!=="svelte-gwwyoa"&&(N.innerHTML=mt),Il=p(l),y(z.$$.fragment,l),Cl=p(l),E=u(l,"P",{"data-svelte-h":!0}),U(E)!=="svelte-gjlxro"&&(E.textContent=ct),gl=p(l),y(F.$$.fragment,l),_l=p(l),Q=u(l,"P",{"data-svelte-h":!0}),U(Q)!=="svelte-s6tghk"&&(Q.innerHTML=dt),Zl=p(l),y(x.$$.fragment,l),kl=p(l),Y=u(l,"P",{"data-svelte-h":!0}),U(Y)!=="svelte-196li54"&&(Y.innerHTML=ut),Bl=p(l),y(A.$$.fragment,l),Gl=p(l),H=u(l,"P",{"data-svelte-h":!0}),U(H)!=="svelte-zejkx4"&&(H.innerHTML=Jt),Wl=p(l),y(q.$$.fragment,l),Vl=p(l),y(S.$$.fragment,l),Xl=p(l),L=u(l,"P",{"data-svelte-h":!0}),U(L)!=="svelte-bbm736"&&(L.innerHTML=yt),$l=p(l),y(D.$$.fragment,l),Rl=p(l),y(P.$$.fragment,l),vl=p(l),K=u(l,"P",{"data-svelte-h":!0}),U(K)!=="svelte-1f2kc7f"&&(K.innerHTML=Tt),Nl=p(l),Z=u(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),U(Z)!=="svelte-11uv400"&&(Z.innerHTML=ht),zl=p(l),y(k.$$.fragment,l),El=p(l),y(O.$$.fragment,l),Fl=p(l),ll=u(l,"P",{"data-svelte-h":!0}),U(ll)!=="svelte-tlkvop"&&(ll.textContent=wt),Ql=p(l),y(tl.$$.fragment,l),xl=p(l),el=u(l,"P",{"data-svelte-h":!0}),U(el)!=="svelte-bqhytl"&&(el.textContent=ft),Yl=p(l),y(sl.$$.fragment,l),Al=p(l),y(al.$$.fragment,l),Hl=p(l),nl=u(l,"P",{"data-svelte-h":!0}),U(nl)!=="svelte-146xwka"&&(nl.innerHTML=Ut),ql=p(l),y(pl.$$.fragment,l),Sl=p(l),ol=u(l,"P",{"data-svelte-h":!0}),U(ol)!=="svelte-b4rki0"&&(ol.textContent=jt),Ll=p(l),B=u(l,"DIV",{class:!0,"data-svelte-h":!0}),U(B)!=="svelte-i5cvgh"&&(B.innerHTML=bt),Dl=p(l),y(il.$$.fragment,l),Pl=p(l),Ml=u(l,"P",{"data-svelte-h":!0}),U(Ml)!=="svelte-19ver11"&&(Ml.textContent=It),Kl=p(l),y(rl.$$.fragment,l),Ol=p(l),ml=u(l,"P",{"data-svelte-h":!0}),U(ml)!=="svelte-1lpi858"&&(ml.innerHTML=Ct),lt=p(l),y(cl.$$.fragment,l),tt=p(l),y(dl.$$.fragment,l),et=p(l),Jl=u(l,"P",{}),_t(Jl).forEach(e),this.h()},h(){yl(i,"name","hf:doc:metadata"),yl(i,"content",Qt),yl(_,"class","tip"),yl(Z,"class","tip"),yl(B,"class","flex flex-col justify-center")},m(l,t){Vt(document.head,i),s(l,b,t),s(l,r,t),s(l,M,t),T(m,l,t),s(l,o,t),T(a,l,t),s(l,j,t),s(l,c,t),s(l,G,t),s(l,W,t),s(l,Tl,t),s(l,V,t),s(l,hl,t),s(l,_,t),s(l,wl,t),s(l,X,t),s(l,fl,t),T($,l,t),s(l,Ul,t),T(R,l,t),s(l,jl,t),s(l,v,t),s(l,bl,t),s(l,N,t),s(l,Il,t),T(z,l,t),s(l,Cl,t),s(l,E,t),s(l,gl,t),T(F,l,t),s(l,_l,t),s(l,Q,t),s(l,Zl,t),T(x,l,t),s(l,kl,t),s(l,Y,t),s(l,Bl,t),T(A,l,t),s(l,Gl,t),s(l,H,t),s(l,Wl,t),T(q,l,t),s(l,Vl,t),T(S,l,t),s(l,Xl,t),s(l,L,t),s(l,$l,t),T(D,l,t),s(l,Rl,t),T(P,l,t),s(l,vl,t),s(l,K,t),s(l,Nl,t),s(l,Z,t),s(l,zl,t),T(k,l,t),s(l,El,t),T(O,l,t),s(l,Fl,t),s(l,ll,t),s(l,Ql,t),T(tl,l,t),s(l,xl,t),s(l,el,t),s(l,Yl,t),T(sl,l,t),s(l,Al,t),T(al,l,t),s(l,Hl,t),s(l,nl,t),s(l,ql,t),T(pl,l,t),s(l,Sl,t),s(l,ol,t),s(l,Ll,t),s(l,B,t),s(l,Dl,t),T(il,l,t),s(l,Pl,t),s(l,Ml,t),s(l,Kl,t),T(rl,l,t),s(l,Ol,t),s(l,ml,t),s(l,lt,t),T(cl,l,t),s(l,tt,t),T(dl,l,t),s(l,et,t),s(l,Jl,t),st=!0},p(l,[t]){const gt={};t&2&&(gt.$$scope={dirty:t,ctx:l}),k.$set(gt)},i(l){st||(h(m.$$.fragment,l),h(a.$$.fragment,l),h($.$$.fragment,l),h(R.$$.fragment,l),h(z.$$.fragment,l),h(F.$$.fragment,l),h(x.$$.fragment,l),h(A.$$.fragment,l),h(q.$$.fragment,l),h(S.$$.fragment,l),h(D.$$.fragment,l),h(P.$$.fragment,l),h(k.$$.fragment,l),h(O.$$.fragment,l),h(tl.$$.fragment,l),h(sl.$$.fragment,l),h(al.$$.fragment,l),h(pl.$$.fragment,l),h(il.$$.fragment,l),h(rl.$$.fragment,l),h(cl.$$.fragment,l),h(dl.$$.fragment,l),st=!0)},o(l){w(m.$$.fragment,l),w(a.$$.fragment,l),w($.$$.fragment,l),w(R.$$.fragment,l),w(z.$$.fragment,l),w(F.$$.fragment,l),w(x.$$.fragment,l),w(A.$$.fragment,l),w(q.$$.fragment,l),w(S.$$.fragment,l),w(D.$$.fragment,l),w(P.$$.fragment,l),w(k.$$.fragment,l),w(O.$$.fragment,l),w(tl.$$.fragment,l),w(sl.$$.fragment,l),w(al.$$.fragment,l),w(pl.$$.fragment,l),w(il.$$.fragment,l),w(rl.$$.fragment,l),w(cl.$$.fragment,l),w(dl.$$.fragment,l),st=!1},d(l){l&&(e(b),e(r),e(M),e(o),e(j),e(c),e(G),e(W),e(Tl),e(V),e(hl),e(_),e(wl),e(X),e(fl),e(Ul),e(jl),e(v),e(bl),e(N),e(Il),e(Cl),e(E),e(gl),e(_l),e(Q),e(Zl),e(kl),e(Y),e(Bl),e(Gl),e(H),e(Wl),e(Vl),e(Xl),e(L),e($l),e(Rl),e(vl),e(K),e(Nl),e(Z),e(zl),e(El),e(Fl),e(ll),e(Ql),e(xl),e(el),e(Yl),e(Al),e(Hl),e(nl),e(ql),e(Sl),e(ol),e(Ll),e(B),e(Dl),e(Pl),e(Ml),e(Kl),e(Ol),e(ml),e(lt),e(tt),e(et),e(Jl)),e(i),f(m,l),f(a,l),f($,l),f(R,l),f(z,l),f(F,l),f(x,l),f(A,l),f(q,l),f(S,l),f(D,l),f(P,l),f(k,l),f(O,l),f(tl,l),f(sl,l),f(al,l),f(pl,l),f(il,l),f(rl,l),f(cl,l),f(dl,l)}}}const Qt='{"title":"Prompt-based methods","local":"prompt-based-methods","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function xt(g){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lt extends Bt{constructor(i){super(),Gt(this,i,xt,Ft,Zt,{})}}export{Lt as component};
