import{s as Ht,o as Lt,n as wt}from"../chunks/scheduler.78382b47.js";import{S as qt,i as St,e as U,s as n,c,h as Dt,a as w,d as a,b as o,f as Nt,g as d,j as b,k as ge,l as Pt,m as l,n as y,t as f,o as h,p as u}from"../chunks/index.6dd35eb6.js";import{C as Kt,H as Te,E as Ot}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6888f903.js";import{C as j}from"../chunks/CodeBlock.658dd679.js";import{H as ea,a as Ut}from"../chunks/HfOption.a1db6210.js";function ta(C){let r,T='<a href="../conceptual_guides/adapter#low-rank-adaptation-lora">LoRA</a> decomposes the weight update matrix into <em>two</em> smaller matrices. The size of these low-rank matrices is determined by its <em>rank</em> or <code>r</code>. A higher rank means the model has more parameters to train, but it also means the model has more learning capacity. You’ll also want to specify the <code>target_modules</code> which determine where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>lora_alpha</code> (scaling factor), <code>bias</code> (whether <code>none</code>, <code>all</code> or only the LoRA bias parameters should be trained), and <code>modules_to_save</code> (the modules apart from the LoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.18.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>.',M,p,m;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiU1RCUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKSUwQW1vZGVsLnByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKCklMEElMjJ0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjA2NjclMkM0OTMlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA4NiUyQzU0MyUyQzgxOCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuNzcxMjc3NTA0NzY2NDI5NCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    lora_dropout=<span class="hljs-number">0.1</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 667,493 || all params: 86,543,818 || trainable%: 0.7712775047664294&quot;</span>`,wrap:!1}}),{c(){r=U("p"),r.innerHTML=T,M=n(),c(p.$$.fragment)},l(s){r=w(s,"P",{"data-svelte-h":!0}),b(r)!=="svelte-cmkl63"&&(r.innerHTML=T),M=o(s),d(p.$$.fragment,s)},m(s,J){l(s,r,J),l(s,M,J),y(p,s,J),m=!0},p:wt,i(s){m||(f(p.$$.fragment,s),m=!0)},o(s){h(p.$$.fragment,s),m=!1},d(s){s&&(a(r),a(M)),u(p,s)}}}function aa(C){let r,T='<a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">LoHa</a> decomposes the weight update matrix into <em>four</em> smaller matrices and each pair of smaller matrices is combined with the Hadamard product. This allows the weight update matrix to keep the same number of trainable parameters when compared to LoRA, but with a higher rank (<code>r^2</code> for LoHA when compared to <code>2*r</code> for LoRA). The size of the smaller matrices is determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoHa layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.18.0/en/package_reference/loha#peft.LoHaConfig">LoHaConfig</a>.',M,p,m;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0hhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0hhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMSUyQzI1NyUyQzMxNyUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDg3JTJDMTMzJTJDNjQyJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS40NDI5NzUzNzc5ODMxNjc2JTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoHaConfig, get_peft_model

config = LoHaConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 1,257,317 || all params: 87,133,642 || trainable%: 1.4429753779831676&quot;</span>`,wrap:!1}}),{c(){r=U("p"),r.innerHTML=T,M=n(),c(p.$$.fragment)},l(s){r=w(s,"P",{"data-svelte-h":!0}),b(r)!=="svelte-5fxk6o"&&(r.innerHTML=T),M=o(s),d(p.$$.fragment,s)},m(s,J){l(s,r,J),l(s,M,J),y(p,s,J),m=!0},p:wt,i(s){m||(f(p.$$.fragment,s),m=!0)},o(s){h(p.$$.fragment,s),m=!1},d(s){s&&(a(r),a(M)),u(p,s)}}}function la(C){let r,T='<a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">LoKr</a> expresses the weight update matrix as a decomposition of a Kronecker product, creating a block matrix that is able to preserve the rank of the original weight matrix. The size of the smaller matrices are determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoKr layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.18.0/en/package_reference/lokr#peft.LoKrConfig">LoKrConfig</a>.',M,p,m;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0tyQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0tyQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMTE2JTJDMDY5JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkMxNzIlMkMwNDIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjEzMzE0OTM0MTYyMDMzMjgyJTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoKrConfig, get_peft_model

config = LoKrConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 116,069 || all params: 87,172,042 || trainable%: 0.13314934162033282&quot;</span>`,wrap:!1}}),{c(){r=U("p"),r.innerHTML=T,M=n(),c(p.$$.fragment)},l(s){r=w(s,"P",{"data-svelte-h":!0}),b(r)!=="svelte-ns97kt"&&(r.innerHTML=T),M=o(s),d(p.$$.fragment,s)},m(s,J){l(s,r,J),l(s,M,J),y(p,s,J),m=!0},p:wt,i(s){m||(f(p.$$.fragment,s),m=!0)},o(s){h(p.$$.fragment,s),m=!1},d(s){s&&(a(r),a(M)),u(p,s)}}}function sa(C){let r,T='<a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">AdaLoRA</a> efficiently manages the LoRA parameter budget by assigning important weight matrices more parameters and pruning less important ones. In contrast, LoRA evenly distributes parameters across all modules. You can control the average desired <em>rank</em> or <code>r</code> of the matrices, and which modules to apply AdaLoRA to with <code>target_modules</code>. Other important parameters to set are <code>lora_alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the AdaLoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.18.0/en/package_reference/adalora#peft.AdaLoraConfig">AdaLoraConfig</a>.',M,p,m;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBZGFMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBBZGFMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwaW5pdF9yJTNEMTIlMkMlMEElMjAlMjAlMjAlMjB0aW5pdCUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHRmaW5hbCUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBkZWx0YVQlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNTIwJTJDMzI1JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkM2MTQlMkM3MjIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjU5Mzg3ODUwMzY2MDYwNjIlMjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AdaLoraConfig, get_peft_model

config = AdaLoraConfig(
    r=<span class="hljs-number">8</span>,
    init_r=<span class="hljs-number">12</span>,
    tinit=<span class="hljs-number">200</span>,
    tfinal=<span class="hljs-number">1000</span>,
    deltaT=<span class="hljs-number">10</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 520,325 || all params: 87,614,722 || trainable%: 0.5938785036606062&quot;</span>`,wrap:!1}}),{c(){r=U("p"),r.innerHTML=T,M=n(),c(p.$$.fragment)},l(s){r=w(s,"P",{"data-svelte-h":!0}),b(r)!=="svelte-1mbyu3x"&&(r.innerHTML=T),M=o(s),d(p.$$.fragment,s)},m(s,J){l(s,r,J),l(s,M,J),y(p,s,J),m=!0},p:wt,i(s){m||(f(p.$$.fragment,s),m=!0)},o(s){h(p.$$.fragment,s),m=!1},d(s){s&&(a(r),a(M)),u(p,s)}}}function na(C){let r,T,M,p,m,s,J,Z;return r=new Ut({props:{id:"loras",option:"LoRA",$$slots:{default:[ta]},$$scope:{ctx:C}}}),M=new Ut({props:{id:"loras",option:"LoHa",$$slots:{default:[aa]},$$scope:{ctx:C}}}),m=new Ut({props:{id:"loras",option:"LoKr",$$slots:{default:[la]},$$scope:{ctx:C}}}),J=new Ut({props:{id:"loras",option:"AdaLoRA",$$slots:{default:[sa]},$$scope:{ctx:C}}}),{c(){c(r.$$.fragment),T=n(),c(M.$$.fragment),p=n(),c(m.$$.fragment),s=n(),c(J.$$.fragment)},l(i){d(r.$$.fragment,i),T=o(i),d(M.$$.fragment,i),p=o(i),d(m.$$.fragment,i),s=o(i),d(J.$$.fragment,i)},m(i,g){y(r,i,g),l(i,T,g),y(M,i,g),l(i,p,g),y(m,i,g),l(i,s,g),y(J,i,g),Z=!0},p(i,g){const B={};g&2&&(B.$$scope={dirty:g,ctx:i}),r.$set(B);const $={};g&2&&($.$$scope={dirty:g,ctx:i}),M.$set($);const je={};g&2&&(je.$$scope={dirty:g,ctx:i}),m.$set(je);const Q={};g&2&&(Q.$$scope={dirty:g,ctx:i}),J.$set(Q)},i(i){Z||(f(r.$$.fragment,i),f(M.$$.fragment,i),f(m.$$.fragment,i),f(J.$$.fragment,i),Z=!0)},o(i){h(r.$$.fragment,i),h(M.$$.fragment,i),h(m.$$.fragment,i),h(J.$$.fragment,i),Z=!1},d(i){i&&(a(T),a(p),a(s)),u(r,i),u(M,i),u(m,i),u(J,i)}}}function oa(C){let r,T,M,p,m,s,J,Z,i,g="A popular way to efficiently train large models is to insert (typically in the attention blocks) smaller trainable matrices that are a low-rank decomposition of the delta weight matrix to be learnt during finetuning. The pretrained model’s original weight matrix is frozen and only the smaller matrices are updated during training. This reduces the number of trainable parameters, reducing memory usage and training time which can be very expensive for large models.",B,$,je='There are several different ways to express the weight matrix as a low-rank decomposition, but <a href="../conceptual_guides/adapter#low-rank-adaptation-lora">Low-Rank Adaptation (LoRA)</a> is the most common method. The PEFT library supports several other LoRA variants, such as <a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">Low-Rank Hadamard Product (LoHa)</a>, <a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">Low-Rank Kronecker Product (LoKr)</a>, and <a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">Adaptive Low-Rank Adaptation (AdaLoRA)</a>. You can learn more about how these methods work conceptually in the <a href="../conceptual_guides/adapter">Adapters</a> guide. If you’re interested in applying these methods to other tasks and use cases like semantic segmentation, token classification, take a look at our <a href="https://huggingface.co/collections/PEFT/notebooks-6573b28b33e5a4bf5b157fc1" rel="nofollow">notebook collection</a>!',Q,R,bt='Additionally, PEFT supports the <a href="../conceptual_guides/adapter#mixture-of-lora-experts-x-lora">X-LoRA</a> Mixture of LoRA Experts method.',$e,G,Tt="This guide will show you how to quickly train an image classification model - with a low-rank decomposition method - to identify the class of food shown in an image.",Ze,_,gt='<p>Some familiarity with the general process of training an image classification model would be really helpful and allow you to focus on the low-rank decomposition methods. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/image_classification" rel="nofollow">Image classification</a> guide first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!</p>',_e,X,jt="Before you begin, make sure you have all the necessary libraries installed.",Ie,F,ke,Y,ve,x,Ct='In this guide, you’ll use the <a href="https://huggingface.co/datasets/food101" rel="nofollow">Food-101</a> dataset which contains images of 101 food classes (take a look at the <a href="https://huggingface.co/datasets/food101/viewer/default/train" rel="nofollow">dataset viewer</a> to get a better idea of what the dataset looks like).',We,A,$t='Load the dataset with the <a href="https://huggingface.co/docs/datasets/v4.4.1/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">load_dataset</a> function.',Be,z,Qe,V,Zt="Each food class is labeled with an integer, so to make it easier to understand what these integers represent, you’ll create a <code>label2id</code> and <code>id2label</code> dictionary to map the integer to its class label.",Re,E,Ge,N,_t="Load an image processor to properly resize and normalize the pixel values of the training and evaluation images.",Xe,H,Fe,L,It="You can also use the image processor to prepare some transformation functions for data augmentation and pixel scaling.",Ye,q,xe,S,kt='Define the training and validation datasets, and use the <a href="https://huggingface.co/docs/datasets/v4.4.1/en/package_reference/main_classes#datasets.Dataset.set_transform" rel="nofollow">set_transform</a> function to apply the transformations on-the-fly.',Ae,D,ze,P,vt="Finally, you’ll need a data collator to create a batch of training and evaluation data and convert the labels to <code>torch.tensor</code> objects.",Ve,K,Ee,O,Ne,ee,Wt='Now let’s load a pretrained model to use as the base model. This guide uses the <a href="https://huggingface.co/google/vit-base-patch16-224-in21k" rel="nofollow">google/vit-base-patch16-224-in21k</a> model, but you can use any image classification model you want. Pass the <code>label2id</code> and <code>id2label</code> dictionaries to the model so it knows how to map the integer labels to their class labels, and you can optionally pass the <code>ignore_mismatched_sizes=True</code> parameter if you’re finetuning a checkpoint that has already been finetuned.',He,te,Le,ae,qe,le,Bt='Every PEFT method requires a configuration that holds all the parameters specifying how the PEFT method should be applied. Once the configuration is setup, pass it to the <a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Se,I,Qt='<p>Call the <a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of parameters of <a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!</p>',De,k,Pe,se,Ke,ne,Rt='For training, let’s use the <a href="https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from Transformers. The <code>Trainer</code> contains a PyTorch training loop, and when you’re ready, call <a href="https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a> to start training. To customize the training run, configure the training hyperparameters in the <a href="https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> class. With LoRA-like methods, you can afford to use a higher batch size and learning rate.',Oe,v,Gt='<p>AdaLoRA has an <a href="/docs/peft/v0.18.0/en/package_reference/adalora#peft.AdaLoraModel.update_and_allocate">update_and_allocate()</a> method that should be called at each training step to update the parameter budget and mask, otherwise the adaptation step is not performed. This requires writing a custom training loop or subclassing the <a href="https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> to incorporate this method. As an example, take a look at this <a href="https://github.com/huggingface/peft/blob/912ad41e96e03652cabf47522cd876076f7a0c4f/examples/conditional_generation/peft_adalora_seq2seq.py#L120" rel="nofollow">custom training loop</a>.</p>',et,oe,tt,re,Xt='Begin training with <a href="https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a>.',at,ie,lt,pe,st,me,Ft='Once training is complete, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.',nt,Me,ot,ce,Yt='Call <a href="https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> to save your model to your repositoy.',rt,de,it,ye,pt,fe,xt="Let’s load the model from the Hub and test it out on a food image.",mt,he,Mt,W,At='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg"/>',ct,ue,zt="Convert the image to RGB and return the underlying PyTorch tensors.",dt,Je,yt,Ue,Vt="Now run the model and return the predicted class!",ft,we,ht,be,ut,Ce,Jt;return m=new Kt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new Te({props:{title:"LoRA methods",local:"lora-methods",headingTag:"h1"}}),F=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcGVmdCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRz",highlighted:"pip install -q peft transformers datasets",wrap:!1}}),Y=new Te({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),z=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZm9vZDEwMSUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)`,wrap:!1}}),E=new j({props:{code:"bGFiZWxzJTIwJTNEJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVELm5hbWVzJTBBbGFiZWwyaWQlMkMlMjBpZDJsYWJlbCUyMCUzRCUyMGRpY3QoKSUyQyUyMGRpY3QoKSUwQWZvciUyMGklMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjBsYWJlbDJpZCU1QmxhYmVsJTVEJTIwJTNEJTIwaSUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTVCaSU1RCUyMCUzRCUyMGxhYmVsJTBBJTBBaWQybGFiZWwlNUIyJTVEJTBBJTIyYmFrbGF2YSUyMg==",highlighted:`labels = ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>].names
label2id, id2label = <span class="hljs-built_in">dict</span>(), <span class="hljs-built_in">dict</span>()
<span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(labels):
    label2id[label] = i
    id2label[i] = label

id2label[<span class="hljs-number">2</span>]
<span class="hljs-string">&quot;baklava&quot;</span>`,wrap:!1}}),H=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQtaW4yMWslMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>)`,wrap:!1}}),q=new j({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ2VudGVyQ3JvcCUyQyUwQSUyMCUyMCUyMCUyMENvbXBvc2UlMkMlMEElMjAlMjAlMjAlMjBOb3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbVJlc2l6ZWRDcm9wJTJDJTBBJTIwJTIwJTIwJTIwUmVzaXplJTJDJTBBJTIwJTIwJTIwJTIwVG9UZW5zb3IlMkMlMEEpJTBBJTBBbm9ybWFsaXplJTIwJTNEJTIwTm9ybWFsaXplKG1lYW4lM0RpbWFnZV9wcm9jZXNzb3IuaW1hZ2VfbWVhbiUyQyUyMHN0ZCUzRGltYWdlX3Byb2Nlc3Nvci5pbWFnZV9zdGQpJTBBdHJhaW5fdHJhbnNmb3JtcyUyMCUzRCUyMENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tUmVzaXplZENyb3AoaW1hZ2VfcHJvY2Vzc29yLnNpemUlNUIlMjJoZWlnaHQlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBdmFsX3RyYW5zZm9ybXMlMjAlM0QlMjBDb21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlc2l6ZShpbWFnZV9wcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDZW50ZXJDcm9wKGltYWdlX3Byb2Nlc3Nvci5zaXplJTVCJTIyaGVpZ2h0JTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVfYmF0Y2glNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjAlNUJ0cmFpbl90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaCUwQSUwQWRlZiUyMHByZXByb2Nlc3NfdmFsKGV4YW1wbGVfYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZV9iYXRjaCU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnZhbF90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaA==",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
    CenterCrop,
    Compose,
    Normalize,
    RandomHorizontalFlip,
    RandomResizedCrop,
    Resize,
    ToTensor,
)

normalize = Normalize(mean=image_processor.image_mean, std=image_processor.image_std)
train_transforms = Compose(
    [
        RandomResizedCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        RandomHorizontalFlip(),
        ToTensor(),
        normalize,
    ]
)

val_transforms = Compose(
    [
        Resize(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        CenterCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        ToTensor(),
        normalize,
    ]
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [train_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_val</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch`,wrap:!1}}),D=new j({props:{code:"dHJhaW5fZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVEJTBBdmFsX2RzJTIwJTNEJTIwZHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTBBJTBBdHJhaW5fZHMuc2V0X3RyYW5zZm9ybShwcmVwcm9jZXNzX3RyYWluKSUwQXZhbF9kcy5zZXRfdHJhbnNmb3JtKHByZXByb2Nlc3NfdmFsKQ==",highlighted:`train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
val_ds = ds[<span class="hljs-string">&quot;validation&quot;</span>]

train_ds.set_transform(preprocess_train)
val_ds.set_transform(preprocess_val)`,wrap:!1}}),K=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBjb2xsYXRlX2ZuKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QmV4YW1wbGUlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZXhhbXBsZSU1QiUyMmxhYmVsJTIyJTVEJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwcGl4ZWxfdmFsdWVzJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwbGFiZWxzJTdE",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    pixel_values = torch.stack([example[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}`,wrap:!1}}),O=new Te({props:{title:"Model",local:"model",headingTag:"h2"}}),te=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUyMFRyYWluZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, TrainingArguments, Trainer

model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),ae=new Te({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),k=new ea({props:{id:"loras",options:["LoRA","LoHa","LoKr","AdaLoRA"],$$slots:{default:[na]},$$scope:{ctx:C}}}),se=new Te({props:{title:"Training",local:"training",headingTag:"h3"}}),oe=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQWFjY291bnQlMjAlM0QlMjAlMjJzdGV2aGxpdSUyMiUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjBmJTIyJTdCYWNjb3VudCU3RCUyRmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrLWxvcmElMjIlMEFiYXRjaF9zaXplJTIwJTNEJTIwMTI4JTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlZnRfbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfdW51c2VkX2NvbHVtbnMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0Q1ZS0zJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

account = <span class="hljs-string">&quot;stevhliu&quot;</span>
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/google/vit-base-patch16-224-in21k-lora&quot;</span>
batch_size = <span class="hljs-number">128</span>

args = TrainingArguments(
    peft_model_id,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">5e-3</span>,
    per_device_train_batch_size=batch_size,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    per_device_eval_batch_size=batch_size,
    fp16=<span class="hljs-literal">True</span>,
    num_train_epochs=<span class="hljs-number">5</span>,
    logging_steps=<span class="hljs-number">10</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
)`,wrap:!1}}),ie=new j({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdmFsX2RzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19jbGFzcyUzRGltYWdlX3Byb2Nlc3NvciUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRlX2ZuJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`trainer = Trainer(
    model,
    args,
    train_dataset=train_ds,
    eval_dataset=val_ds,
    processing_class=image_processor,
    data_collator=collate_fn,
)
trainer.train()`,wrap:!1}}),pe=new Te({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),Me=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),de=new j({props:{code:"bW9kZWwucHVzaF90b19odWIocGVmdF9tb2RlbF9pZCk=",highlighted:"model.push_to_hub(peft_model_id)",wrap:!1}}),ye=new Te({props:{title:"Inference",local:"inference",headingTag:"h2"}}),he=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTJDJTIwUGVmdE1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyc3RldmhsaXUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1pbjIxay1sb3JhJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLmJhc2VfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwJTIyc3RldmhsaXUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1pbjIxay1sb3JhJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnNheWFrcGF1bCUyRnNhbXBsZS1kYXRhc2V0cyUyRnJlc29sdmUlMkZtYWluJTJGYmVpZ25ldHMuanBlZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig, PeftModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

config = PeftConfig.from_pretrained(<span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(
    config.base_model_name_or_path,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)
model = PeftModel.from_pretrained(model, <span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image`,wrap:!1}}),Je=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'encoding = image_processor(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),we=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kaW5nKSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCklMEElMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMGJlaWduZXRzJTIy",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**encoding)
    logits = outputs.logits

predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
<span class="hljs-string">&quot;Predicted class: beignets&quot;</span>`,wrap:!1}}),be=new Ot({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/task_guides/lora_based_methods.md"}}),{c(){r=U("meta"),T=n(),M=U("p"),p=n(),c(m.$$.fragment),s=n(),c(J.$$.fragment),Z=n(),i=U("p"),i.textContent=g,B=n(),$=U("p"),$.innerHTML=je,Q=n(),R=U("p"),R.innerHTML=bt,$e=n(),G=U("p"),G.textContent=Tt,Ze=n(),_=U("blockquote"),_.innerHTML=gt,_e=n(),X=U("p"),X.textContent=jt,Ie=n(),c(F.$$.fragment),ke=n(),c(Y.$$.fragment),ve=n(),x=U("p"),x.innerHTML=Ct,We=n(),A=U("p"),A.innerHTML=$t,Be=n(),c(z.$$.fragment),Qe=n(),V=U("p"),V.innerHTML=Zt,Re=n(),c(E.$$.fragment),Ge=n(),N=U("p"),N.textContent=_t,Xe=n(),c(H.$$.fragment),Fe=n(),L=U("p"),L.textContent=It,Ye=n(),c(q.$$.fragment),xe=n(),S=U("p"),S.innerHTML=kt,Ae=n(),c(D.$$.fragment),ze=n(),P=U("p"),P.innerHTML=vt,Ve=n(),c(K.$$.fragment),Ee=n(),c(O.$$.fragment),Ne=n(),ee=U("p"),ee.innerHTML=Wt,He=n(),c(te.$$.fragment),Le=n(),c(ae.$$.fragment),qe=n(),le=U("p"),le.innerHTML=Bt,Se=n(),I=U("blockquote"),I.innerHTML=Qt,De=n(),c(k.$$.fragment),Pe=n(),c(se.$$.fragment),Ke=n(),ne=U("p"),ne.innerHTML=Rt,Oe=n(),v=U("blockquote"),v.innerHTML=Gt,et=n(),c(oe.$$.fragment),tt=n(),re=U("p"),re.innerHTML=Xt,at=n(),c(ie.$$.fragment),lt=n(),c(pe.$$.fragment),st=n(),me=U("p"),me.innerHTML=Ft,nt=n(),c(Me.$$.fragment),ot=n(),ce=U("p"),ce.innerHTML=Yt,rt=n(),c(de.$$.fragment),it=n(),c(ye.$$.fragment),pt=n(),fe=U("p"),fe.textContent=xt,mt=n(),c(he.$$.fragment),Mt=n(),W=U("div"),W.innerHTML=At,ct=n(),ue=U("p"),ue.textContent=zt,dt=n(),c(Je.$$.fragment),yt=n(),Ue=U("p"),Ue.textContent=Vt,ft=n(),c(we.$$.fragment),ht=n(),c(be.$$.fragment),ut=n(),Ce=U("p"),this.h()},l(e){const t=Dt("svelte-u9bgzb",document.head);r=w(t,"META",{name:!0,content:!0}),t.forEach(a),T=o(e),M=w(e,"P",{}),Nt(M).forEach(a),p=o(e),d(m.$$.fragment,e),s=o(e),d(J.$$.fragment,e),Z=o(e),i=w(e,"P",{"data-svelte-h":!0}),b(i)!=="svelte-3c4mx2"&&(i.textContent=g),B=o(e),$=w(e,"P",{"data-svelte-h":!0}),b($)!=="svelte-1mec8a1"&&($.innerHTML=je),Q=o(e),R=w(e,"P",{"data-svelte-h":!0}),b(R)!=="svelte-wawyyc"&&(R.innerHTML=bt),$e=o(e),G=w(e,"P",{"data-svelte-h":!0}),b(G)!=="svelte-3yvnz9"&&(G.textContent=Tt),Ze=o(e),_=w(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),b(_)!=="svelte-bg3xwr"&&(_.innerHTML=gt),_e=o(e),X=w(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-1rdzhb1"&&(X.textContent=jt),Ie=o(e),d(F.$$.fragment,e),ke=o(e),d(Y.$$.fragment,e),ve=o(e),x=w(e,"P",{"data-svelte-h":!0}),b(x)!=="svelte-l33v6t"&&(x.innerHTML=Ct),We=o(e),A=w(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-1n5qm8r"&&(A.innerHTML=$t),Be=o(e),d(z.$$.fragment,e),Qe=o(e),V=w(e,"P",{"data-svelte-h":!0}),b(V)!=="svelte-1a5q7dy"&&(V.innerHTML=Zt),Re=o(e),d(E.$$.fragment,e),Ge=o(e),N=w(e,"P",{"data-svelte-h":!0}),b(N)!=="svelte-13cytaa"&&(N.textContent=_t),Xe=o(e),d(H.$$.fragment,e),Fe=o(e),L=w(e,"P",{"data-svelte-h":!0}),b(L)!=="svelte-1p1x6w4"&&(L.textContent=It),Ye=o(e),d(q.$$.fragment,e),xe=o(e),S=w(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-1lng197"&&(S.innerHTML=kt),Ae=o(e),d(D.$$.fragment,e),ze=o(e),P=w(e,"P",{"data-svelte-h":!0}),b(P)!=="svelte-mznco7"&&(P.innerHTML=vt),Ve=o(e),d(K.$$.fragment,e),Ee=o(e),d(O.$$.fragment,e),Ne=o(e),ee=w(e,"P",{"data-svelte-h":!0}),b(ee)!=="svelte-akpunr"&&(ee.innerHTML=Wt),He=o(e),d(te.$$.fragment,e),Le=o(e),d(ae.$$.fragment,e),qe=o(e),le=w(e,"P",{"data-svelte-h":!0}),b(le)!=="svelte-gzv6l8"&&(le.innerHTML=Bt),Se=o(e),I=w(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),b(I)!=="svelte-1anu1s6"&&(I.innerHTML=Qt),De=o(e),d(k.$$.fragment,e),Pe=o(e),d(se.$$.fragment,e),Ke=o(e),ne=w(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-1w6x4fc"&&(ne.innerHTML=Rt),Oe=o(e),v=w(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),b(v)!=="svelte-4pmxjb"&&(v.innerHTML=Gt),et=o(e),d(oe.$$.fragment,e),tt=o(e),re=w(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-d3q18x"&&(re.innerHTML=Xt),at=o(e),d(ie.$$.fragment,e),lt=o(e),d(pe.$$.fragment,e),st=o(e),me=w(e,"P",{"data-svelte-h":!0}),b(me)!=="svelte-146xwka"&&(me.innerHTML=Ft),nt=o(e),d(Me.$$.fragment,e),ot=o(e),ce=w(e,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-1v7crs6"&&(ce.innerHTML=Yt),rt=o(e),d(de.$$.fragment,e),it=o(e),d(ye.$$.fragment,e),pt=o(e),fe=w(e,"P",{"data-svelte-h":!0}),b(fe)!=="svelte-1whrqzq"&&(fe.textContent=xt),mt=o(e),d(he.$$.fragment,e),Mt=o(e),W=w(e,"DIV",{class:!0,"data-svelte-h":!0}),b(W)!=="svelte-sucph9"&&(W.innerHTML=At),ct=o(e),ue=w(e,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-1nlb27h"&&(ue.textContent=zt),dt=o(e),d(Je.$$.fragment,e),yt=o(e),Ue=w(e,"P",{"data-svelte-h":!0}),b(Ue)!=="svelte-1mvhoi"&&(Ue.textContent=Vt),ft=o(e),d(we.$$.fragment,e),ht=o(e),d(be.$$.fragment,e),ut=o(e),Ce=w(e,"P",{}),Nt(Ce).forEach(a),this.h()},h(){ge(r,"name","hf:doc:metadata"),ge(r,"content",ra),ge(_,"class","tip"),ge(I,"class","tip"),ge(v,"class","warning"),ge(W,"class","flex justify-center")},m(e,t){Pt(document.head,r),l(e,T,t),l(e,M,t),l(e,p,t),y(m,e,t),l(e,s,t),y(J,e,t),l(e,Z,t),l(e,i,t),l(e,B,t),l(e,$,t),l(e,Q,t),l(e,R,t),l(e,$e,t),l(e,G,t),l(e,Ze,t),l(e,_,t),l(e,_e,t),l(e,X,t),l(e,Ie,t),y(F,e,t),l(e,ke,t),y(Y,e,t),l(e,ve,t),l(e,x,t),l(e,We,t),l(e,A,t),l(e,Be,t),y(z,e,t),l(e,Qe,t),l(e,V,t),l(e,Re,t),y(E,e,t),l(e,Ge,t),l(e,N,t),l(e,Xe,t),y(H,e,t),l(e,Fe,t),l(e,L,t),l(e,Ye,t),y(q,e,t),l(e,xe,t),l(e,S,t),l(e,Ae,t),y(D,e,t),l(e,ze,t),l(e,P,t),l(e,Ve,t),y(K,e,t),l(e,Ee,t),y(O,e,t),l(e,Ne,t),l(e,ee,t),l(e,He,t),y(te,e,t),l(e,Le,t),y(ae,e,t),l(e,qe,t),l(e,le,t),l(e,Se,t),l(e,I,t),l(e,De,t),y(k,e,t),l(e,Pe,t),y(se,e,t),l(e,Ke,t),l(e,ne,t),l(e,Oe,t),l(e,v,t),l(e,et,t),y(oe,e,t),l(e,tt,t),l(e,re,t),l(e,at,t),y(ie,e,t),l(e,lt,t),y(pe,e,t),l(e,st,t),l(e,me,t),l(e,nt,t),y(Me,e,t),l(e,ot,t),l(e,ce,t),l(e,rt,t),y(de,e,t),l(e,it,t),y(ye,e,t),l(e,pt,t),l(e,fe,t),l(e,mt,t),y(he,e,t),l(e,Mt,t),l(e,W,t),l(e,ct,t),l(e,ue,t),l(e,dt,t),y(Je,e,t),l(e,yt,t),l(e,Ue,t),l(e,ft,t),y(we,e,t),l(e,ht,t),y(be,e,t),l(e,ut,t),l(e,Ce,t),Jt=!0},p(e,[t]){const Et={};t&2&&(Et.$$scope={dirty:t,ctx:e}),k.$set(Et)},i(e){Jt||(f(m.$$.fragment,e),f(J.$$.fragment,e),f(F.$$.fragment,e),f(Y.$$.fragment,e),f(z.$$.fragment,e),f(E.$$.fragment,e),f(H.$$.fragment,e),f(q.$$.fragment,e),f(D.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(k.$$.fragment,e),f(se.$$.fragment,e),f(oe.$$.fragment,e),f(ie.$$.fragment,e),f(pe.$$.fragment,e),f(Me.$$.fragment,e),f(de.$$.fragment,e),f(ye.$$.fragment,e),f(he.$$.fragment,e),f(Je.$$.fragment,e),f(we.$$.fragment,e),f(be.$$.fragment,e),Jt=!0)},o(e){h(m.$$.fragment,e),h(J.$$.fragment,e),h(F.$$.fragment,e),h(Y.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(H.$$.fragment,e),h(q.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(k.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(Me.$$.fragment,e),h(de.$$.fragment,e),h(ye.$$.fragment,e),h(he.$$.fragment,e),h(Je.$$.fragment,e),h(we.$$.fragment,e),h(be.$$.fragment,e),Jt=!1},d(e){e&&(a(T),a(M),a(p),a(s),a(Z),a(i),a(B),a($),a(Q),a(R),a($e),a(G),a(Ze),a(_),a(_e),a(X),a(Ie),a(ke),a(ve),a(x),a(We),a(A),a(Be),a(Qe),a(V),a(Re),a(Ge),a(N),a(Xe),a(Fe),a(L),a(Ye),a(xe),a(S),a(Ae),a(ze),a(P),a(Ve),a(Ee),a(Ne),a(ee),a(He),a(Le),a(qe),a(le),a(Se),a(I),a(De),a(Pe),a(Ke),a(ne),a(Oe),a(v),a(et),a(tt),a(re),a(at),a(lt),a(st),a(me),a(nt),a(ot),a(ce),a(rt),a(it),a(pt),a(fe),a(mt),a(Mt),a(W),a(ct),a(ue),a(dt),a(yt),a(Ue),a(ft),a(ht),a(ut),a(Ce)),a(r),u(m,e),u(J,e),u(F,e),u(Y,e),u(z,e),u(E,e),u(H,e),u(q,e),u(D,e),u(K,e),u(O,e),u(te,e),u(ae,e),u(k,e),u(se,e),u(oe,e),u(ie,e),u(pe,e),u(Me,e),u(de,e),u(ye,e),u(he,e),u(Je,e),u(we,e),u(be,e)}}}const ra='{"title":"LoRA methods","local":"lora-methods","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function ia(C){return Lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ya extends qt{constructor(r){super(),St(this,r,ia,oa,Ht,{})}}export{ya as component};
