import{s as Ft,o as xt,n as Rt}from"../chunks/scheduler.78382b47.js";import{S as Wt,i as It,e as d,s as l,c as u,h as Vt,a as m,d as a,b as o,f as dt,g as M,j as g,k as mt,l as i,m as s,n as y,t as b,o as T,p as J}from"../chunks/index.6dd35eb6.js";import{C as Xt,H as it,E as Et}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6888f903.js";import{D as $t}from"../chunks/Docstring.286e0aef.js";import{C as bt}from"../chunks/CodeBlock.658dd679.js";import{E as Ht}from"../chunks/ExampleCodeBlock.3f133c9f.js";function Lt(S){let p,G="Example:",j,w,f;return w=new bt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQWZyb20lMjBwZWZ0LnV0aWxzLmhvdHN3YXAlMjBpbXBvcnQlMjBob3Rzd2FwX2FkYXB0ZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMC4uLiUwQWlucHV0cyUyMCUzRCUyMC4uLiUwQWRldmljZSUyMCUzRCUyMC4uLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKS50byhkZXZpY2UpJTBBJTBBJTIzJTIwbG9hZCUyMGxvcmElMjAwJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwJTIycGF0aC1hZGFwdGVyLTAlMjIpJTBBbW9kZWwlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsKSUyMCUyMCUyMyUyMG9wdGlvbmFsbHklMjBjb21waWxlJTIwdGhlJTIwbW9kZWwlMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF9hZGFwdGVyXzAlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTBBJTIzJTIwcmVwbGFjZSUyMHRoZSUyMCUyMmRlZmF1bHQlMjIlMjBsb3JhJTIwYWRhcHRlciUyMHdpdGglMjB0aGUlMjBuZXclMjBvbmUlMEFob3Rzd2FwX2FkYXB0ZXIobW9kZWwlMkMlMjAlMjJwYXRoLWFkYXB0ZXItMSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRlZmF1bHQlMjIlMkMlMjB0b3JjaF9kZXZpY2UlM0RkZXZpY2UpJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRfYWRhcHRlcl8xJTIwJTNEJTIwbW9kZWwoaW5wdXRzKS5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft.utils.hotswap <span class="hljs-keyword">import</span> hotswap_adapter

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>device = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load lora 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PeftModel.from_pretrained(model, <span class="hljs-string">&quot;path-adapter-0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = torch.<span class="hljs-built_in">compile</span>(model)  <span class="hljs-comment"># optionally compile the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    output_adapter_0 = model(inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># replace the &quot;default&quot; lora adapter with the new one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hotswap_adapter(model, <span class="hljs-string">&quot;path-adapter-1&quot;</span>, adapter_name=<span class="hljs-string">&quot;default&quot;</span>, torch_device=device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    output_adapter_1 = model(inputs).logits`,wrap:!1}}),{c(){p=d("p"),p.textContent=G,j=l(),u(w.$$.fragment)},l(n){p=m(n,"P",{"data-svelte-h":!0}),g(p)!=="svelte-11lpom8"&&(p.textContent=G),j=o(n),M(w.$$.fragment,n)},m(n,_){s(n,p,_),s(n,j,_),y(w,n,_),f=!0},p:Rt,i(n){f||(b(w.$$.fragment,n),f=!0)},o(n){T(w.$$.fragment,n),f=!1},d(n){n&&(a(p),a(j)),J(w,n)}}}function Qt(S){let p,G,j,w,f,n,_,P,U,Tt="The idea of hotswapping an adapter is the following: We can already load multiple adapters, e.g. two LoRAs, at the same time. But sometimes, we want to load one LoRA and then replace its weights in-place with the LoRA weights of another adapter. This is now possible the <code>hotswap_adapter</code> function.",q,C,Jt="In general, this should be faster than deleting one adapter and loading the adapter in its place, which would be the how to achieve the same final outcome without hotswapping. Another advantage of hotswapping is that it prevents re-compilation in case the PEFT model is already compiled using <code>torch.compile</code>. This can save quite a lot of time.",K,B,D,k,O,$,tt,F,et,x,at,R,_t="Hotswapping works with transformers models and diffusers models. However, there are some caveats:",st,W,jt="<li>Right now, only LoRA is properly supported.</li> <li>It only works for the same PEFT method, so no swapping LoRA and LoHa, for example.</li> <li>The adapter that is being swapped in must target the same layers as the previous adapter or a subset of those layers. It cannot target new layers. Therefore, if possible, start with the adapter that targets most layers.</li>",lt,r,I,ct,E,Zt="Substitute old adapter data with new adapter data, keeping the rest the same.",ht,H,vt="As of now, only LoRA is supported.",wt,L,Gt=`This function is useful when you want to replace the loaded adapter with a new adapter. The adapter name will
remain the same, but the weights and other parameters will be swapped out.`,ft,Q,Ut=`If the adapters are incomptabile, e.g. targeting different layers or having different alpha values, an error will
be raised.`,ut,Z,ot,h,V,Mt,Y,Ct="Swap out the adapter weights from the model with the weights from state_dict.",gt,A,Bt="As of now, only LoRA is supported.",yt,z,kt=`This is a low-level function that assumes that the adapters have been checked for compatibility and that the
state_dict has been correctly mapped to work with PEFT. For a high level function that performs this work for you,
use <code>hotswap_adapter</code> instead.`,nt,X,pt,N,rt;return f=new Xt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),_=new it({props:{title:"Hotswapping adapters",local:"hotswapping-adapters",headingTag:"h1"}}),B=new it({props:{title:"Example without torch.compile",local:"example-without-torchcompile",headingTag:"h2"}}),k=new bt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQWZyb20lMjBwZWZ0LnV0aWxzLmhvdHN3YXAlMjBpbXBvcnQlMjBob3Rzd2FwX2FkYXB0ZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMC4uLiUwQWlucHV0cyUyMCUzRCUyMC4uLiUwQWRldmljZSUyMCUzRCUyMC4uLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKS50byhkZXZpY2UpJTBBJTBBJTIzJTIwbG9hZCUyMGxvcmElMjAwJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwJTNDcGF0aC1hZGFwdGVyLTAlM0UpJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRfYWRhcHRlcl8wJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUwQSUyMyUyMHJlcGxhY2UlMjB0aGUlMjAlMjJkZWZhdWx0JTIyJTIwbG9yYSUyMGFkYXB0ZXIlMjB3aXRoJTIwdGhlJTIwbmV3JTIwb25lJTBBaG90c3dhcF9hZGFwdGVyKG1vZGVsJTJDJTIwJTNDcGF0aC1hZGFwdGVyLTElM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkZWZhdWx0JTIyJTJDJTIwdG9yY2hfZGV2aWNlJTNEZGV2aWNlKSUwQXdpdGglMjB0b3JjaC5pbmZlcmVuY2VfbW9kZSgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2FkYXB0ZXJfMSUyMCUzRCUyMG1vZGVsKGlucHV0cykubG9naXRz",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">from</span> peft.utils.hotswap <span class="hljs-keyword">import</span> hotswap_adapter

model_id = ...
inputs = ...
device = ...
model = AutoModelForCausalLM.from_pretrained(model_id).to(device)

<span class="hljs-comment"># load lora 0</span>
model = PeftModel.from_pretrained(model, &lt;path-adapter-<span class="hljs-number">0</span>&gt;)
<span class="hljs-keyword">with</span> torch.inference_mode():
    output_adapter_0 = model(inputs)

<span class="hljs-comment"># replace the &quot;default&quot; lora adapter with the new one</span>
hotswap_adapter(model, &lt;path-adapter-<span class="hljs-number">1</span>&gt;, adapter_name=<span class="hljs-string">&quot;default&quot;</span>, torch_device=device)
<span class="hljs-keyword">with</span> torch.inference_mode():
    output_adapter_1 = model(inputs).logits`,wrap:!1}}),$=new it({props:{title:"Example with torch.compile",local:"example-with-torchcompile",headingTag:"h2"}}),F=new bt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQWZyb20lMjBwZWZ0LnV0aWxzLmhvdHN3YXAlMjBpbXBvcnQlMjBob3Rzd2FwX2FkYXB0ZXIlMkMlMjBwcmVwYXJlX21vZGVsX2Zvcl9jb21waWxlZF9ob3Rzd2FwJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEFpbnB1dHMlMjAlM0QlMjAuLi4lMEFkZXZpY2UlMjAlM0QlMjAuLi4lMEFtYXhfcmFuayUyMCUzRCUyMC4uLiUyMCUyMCUyMyUyMG1heGltdW0lMjByYW5rJTIwYW1vbmclMjBhbGwlMjBMb1JBJTIwYWRhcHRlcnMlMjB0aGF0JTIwd2lsbCUyMGJlJTIwdXNlZCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKS50byhkZXZpY2UpJTBBJTBBJTIzJTIwbG9hZCUyMGxvcmElMjAwJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwJTNDcGF0aC1hZGFwdGVyLTAlM0UpJTBBJTIzJTIwUHJlcGFyZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBhbGxvdyUyMGhvdHN3YXBwaW5nJTIwZXZlbiUyMGlmJTIwcmFua3MlMkZzY2FsaW5ncyUyMG9mJTIwMm5kJTIwYWRhcHRlciUyMGRpZmZlci4lMEElMjMlMjBZb3UlMjBjYW4lMjBza2lwJTIwdGhpcyUyMHN0ZXAlMjBpZiUyMGFsbCUyMHJhbmtzJTIwYW5kJTIwc2NhbGluZ3MlMjBhcmUlMjBpZGVudGljYWwuJTBBcHJlcGFyZV9tb2RlbF9mb3JfY29tcGlsZWRfaG90c3dhcChtb2RlbCUyQyUyMHRhcmdldF9yYW5rJTNEbWF4X3JhbmspJTBBbW9kZWwlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsKSUwQXdpdGglMjB0b3JjaC5pbmZlcmVuY2VfbW9kZSgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2FkYXB0ZXJfMCUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMEElMjMlMjByZXBsYWNlJTIwdGhlJTIwJTIyZGVmYXVsdCUyMiUyMGxvcmElMjBhZGFwdGVyJTIwd2l0aCUyMHRoZSUyMG5ldyUyMG9uZSUwQWhvdHN3YXBfYWRhcHRlcihtb2RlbCUyQyUyMCUzQ3BhdGgtYWRhcHRlci0xJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyZGVmYXVsdCUyMiUyQyUyMHRvcmNoX2RldmljZSUzRGRldmljZSklMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF9hZGFwdGVyXzElMjAlM0QlMjBtb2RlbChpbnB1dHMpLmxvZ2l0cw==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">from</span> peft.utils.hotswap <span class="hljs-keyword">import</span> hotswap_adapter, prepare_model_for_compiled_hotswap

model_id = ...
inputs = ...
device = ...
max_rank = ...  <span class="hljs-comment"># maximum rank among all LoRA adapters that will be used</span>
model = AutoModelForCausalLM.from_pretrained(model_id).to(device)

<span class="hljs-comment"># load lora 0</span>
model = PeftModel.from_pretrained(model, &lt;path-adapter-<span class="hljs-number">0</span>&gt;)
<span class="hljs-comment"># Prepare the model to allow hotswapping even if ranks/scalings of 2nd adapter differ.</span>
<span class="hljs-comment"># You can skip this step if all ranks and scalings are identical.</span>
prepare_model_for_compiled_hotswap(model, target_rank=max_rank)
model = torch.<span class="hljs-built_in">compile</span>(model)
<span class="hljs-keyword">with</span> torch.inference_mode():
    output_adapter_0 = model(inputs)

<span class="hljs-comment"># replace the &quot;default&quot; lora adapter with the new one</span>
hotswap_adapter(model, &lt;path-adapter-<span class="hljs-number">1</span>&gt;, adapter_name=<span class="hljs-string">&quot;default&quot;</span>, torch_device=device)
<span class="hljs-keyword">with</span> torch.inference_mode():
    output_adapter_1 = model(inputs).logits`,wrap:!1}}),x=new it({props:{title:"Caveats",local:"peft.utils.hotswap.hotswap_adapter",headingTag:"h2"}}),I=new $t({props:{name:"peft.utils.hotswap.hotswap_adapter",anchor:"peft.utils.hotswap.hotswap_adapter",parameters:[{name:"model",val:""},{name:"model_name_or_path",val:""},{name:"adapter_name",val:""},{name:"torch_device",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"peft.utils.hotswap.hotswap_adapter.model",description:`<strong>model</strong> (<a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.PeftModel">~PeftModel</a>) &#x2014;
The PEFT model with the loaded adapter.`,name:"model"},{anchor:"peft.utils.hotswap.hotswap_adapter.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>str</code>) &#x2014;
The name or path of the model to load the new adapter from.`,name:"model_name_or_path"},{anchor:"peft.utils.hotswap.hotswap_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>) &#x2014;
The name of the adapter to swap, e.g. <code>&quot;default&quot;</code>. The name will stay the same after swapping.`,name:"adapter_name"},{anchor:"peft.utils.hotswap.hotswap_adapter.torch_device",description:`<strong>torch_device</strong> &#x2014; (<code>str</code>, <em>optional</em>, defaults to None):
The device to load the new adapter onto.`,name:"torch_device"},{anchor:"peft.utils.hotswap.hotswap_adapter.*kwargs",description:`*<strong>*kwargs</strong> (<code>optional</code>) &#x2014;
Additional keyword arguments used for loading the config and weights.`,name:"*kwargs"}],source:"https://github.com/huggingface/peft/blob/v0.18.0/src/peft/utils/hotswap.py#L545"}}),Z=new Ht({props:{anchor:"peft.utils.hotswap.hotswap_adapter.example",$$slots:{default:[Lt]},$$scope:{ctx:S}}}),V=new $t({props:{name:"peft.utils.hotswap.hotswap_adapter_from_state_dict",anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict",parameters:[{name:"model",val:": torch.nn.Module"},{name:"state_dict",val:": dict[str, torch.Tensor]"},{name:"adapter_name",val:": str"},{name:"config",val:": LoraConfig"},{name:"parameter_prefix",val:": str = 'lora_'"}],parametersDescription:[{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
The model with the loaded adapter.`,name:"model"},{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.state_dict",description:`<strong>state_dict</strong> (<code>dict[str, torch.Tensor]</code>) &#x2014;
The state dict of the new adapter, which needs to be compatible (targeting same modules etc.).`,name:"state_dict"},{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>) &#x2014;
The name of the adapter that should be hot-swapped, e.g. <code>&quot;default&quot;</code>. The name will remain the same after
swapping.`,name:"adapter_name"},{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.config",description:`<strong>config</strong> (<code>LoraConfig</code>) &#x2014;
The config of the LoRA adapter. This is used to determine the scaling and rank of the adapter.`,name:"config"},{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.parameter_prefix",description:`<strong>parameter_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;lora_&quot;</code>) &#x2014;
The prefix used to identify the adapter&#x2019;s keys in the state dict. For LoRA, this would be <code>&quot;lora_&quot;</code> (the
default).`,name:"parameter_prefix"}],source:"https://github.com/huggingface/peft/blob/v0.18.0/src/peft/utils/hotswap.py#L369",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>RuntimeError</code> —
If the old and the new adapter are not compatible, a RuntimeError is raised.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>RuntimeError</code></p>
`}}),X=new Et({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/package_reference/hotswap.md"}}),{c(){p=d("meta"),G=l(),j=d("p"),w=l(),u(f.$$.fragment),n=l(),u(_.$$.fragment),P=l(),U=d("p"),U.innerHTML=Tt,q=l(),C=d("p"),C.innerHTML=Jt,K=l(),u(B.$$.fragment),D=l(),u(k.$$.fragment),O=l(),u($.$$.fragment),tt=l(),u(F.$$.fragment),et=l(),u(x.$$.fragment),at=l(),R=d("p"),R.textContent=_t,st=l(),W=d("ul"),W.innerHTML=jt,lt=l(),r=d("div"),u(I.$$.fragment),ct=l(),E=d("p"),E.textContent=Zt,ht=l(),H=d("p"),H.textContent=vt,wt=l(),L=d("p"),L.textContent=Gt,ft=l(),Q=d("p"),Q.textContent=Ut,ut=l(),u(Z.$$.fragment),ot=l(),h=d("div"),u(V.$$.fragment),Mt=l(),Y=d("p"),Y.textContent=Ct,gt=l(),A=d("p"),A.textContent=Bt,yt=l(),z=d("p"),z.innerHTML=kt,nt=l(),u(X.$$.fragment),pt=l(),N=d("p"),this.h()},l(t){const e=Vt("svelte-u9bgzb",document.head);p=m(e,"META",{name:!0,content:!0}),e.forEach(a),G=o(t),j=m(t,"P",{}),dt(j).forEach(a),w=o(t),M(f.$$.fragment,t),n=o(t),M(_.$$.fragment,t),P=o(t),U=m(t,"P",{"data-svelte-h":!0}),g(U)!=="svelte-1r4koev"&&(U.innerHTML=Tt),q=o(t),C=m(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-2f3tnn"&&(C.innerHTML=Jt),K=o(t),M(B.$$.fragment,t),D=o(t),M(k.$$.fragment,t),O=o(t),M($.$$.fragment,t),tt=o(t),M(F.$$.fragment,t),et=o(t),M(x.$$.fragment,t),at=o(t),R=m(t,"P",{"data-svelte-h":!0}),g(R)!=="svelte-1904uk3"&&(R.textContent=_t),st=o(t),W=m(t,"UL",{"data-svelte-h":!0}),g(W)!=="svelte-1ybjwin"&&(W.innerHTML=jt),lt=o(t),r=m(t,"DIV",{class:!0});var c=dt(r);M(I.$$.fragment,c),ct=o(c),E=m(c,"P",{"data-svelte-h":!0}),g(E)!=="svelte-9ihruw"&&(E.textContent=Zt),ht=o(c),H=m(c,"P",{"data-svelte-h":!0}),g(H)!=="svelte-10f33xj"&&(H.textContent=vt),wt=o(c),L=m(c,"P",{"data-svelte-h":!0}),g(L)!=="svelte-rl33pg"&&(L.textContent=Gt),ft=o(c),Q=m(c,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-1e6bpeq"&&(Q.textContent=Ut),ut=o(c),M(Z.$$.fragment,c),c.forEach(a),ot=o(t),h=m(t,"DIV",{class:!0});var v=dt(h);M(V.$$.fragment,v),Mt=o(v),Y=m(v,"P",{"data-svelte-h":!0}),g(Y)!=="svelte-1sueth6"&&(Y.textContent=Ct),gt=o(v),A=m(v,"P",{"data-svelte-h":!0}),g(A)!=="svelte-10f33xj"&&(A.textContent=Bt),yt=o(v),z=m(v,"P",{"data-svelte-h":!0}),g(z)!=="svelte-1dqtnq6"&&(z.innerHTML=kt),v.forEach(a),nt=o(t),M(X.$$.fragment,t),pt=o(t),N=m(t,"P",{}),dt(N).forEach(a),this.h()},h(){mt(p,"name","hf:doc:metadata"),mt(p,"content",Yt),mt(r,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),mt(h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){i(document.head,p),s(t,G,e),s(t,j,e),s(t,w,e),y(f,t,e),s(t,n,e),y(_,t,e),s(t,P,e),s(t,U,e),s(t,q,e),s(t,C,e),s(t,K,e),y(B,t,e),s(t,D,e),y(k,t,e),s(t,O,e),y($,t,e),s(t,tt,e),y(F,t,e),s(t,et,e),y(x,t,e),s(t,at,e),s(t,R,e),s(t,st,e),s(t,W,e),s(t,lt,e),s(t,r,e),y(I,r,null),i(r,ct),i(r,E),i(r,ht),i(r,H),i(r,wt),i(r,L),i(r,ft),i(r,Q),i(r,ut),y(Z,r,null),s(t,ot,e),s(t,h,e),y(V,h,null),i(h,Mt),i(h,Y),i(h,gt),i(h,A),i(h,yt),i(h,z),s(t,nt,e),y(X,t,e),s(t,pt,e),s(t,N,e),rt=!0},p(t,[e]){const c={};e&2&&(c.$$scope={dirty:e,ctx:t}),Z.$set(c)},i(t){rt||(b(f.$$.fragment,t),b(_.$$.fragment,t),b(B.$$.fragment,t),b(k.$$.fragment,t),b($.$$.fragment,t),b(F.$$.fragment,t),b(x.$$.fragment,t),b(I.$$.fragment,t),b(Z.$$.fragment,t),b(V.$$.fragment,t),b(X.$$.fragment,t),rt=!0)},o(t){T(f.$$.fragment,t),T(_.$$.fragment,t),T(B.$$.fragment,t),T(k.$$.fragment,t),T($.$$.fragment,t),T(F.$$.fragment,t),T(x.$$.fragment,t),T(I.$$.fragment,t),T(Z.$$.fragment,t),T(V.$$.fragment,t),T(X.$$.fragment,t),rt=!1},d(t){t&&(a(G),a(j),a(w),a(n),a(P),a(U),a(q),a(C),a(K),a(D),a(O),a(tt),a(et),a(at),a(R),a(st),a(W),a(lt),a(r),a(ot),a(h),a(nt),a(pt),a(N)),a(p),J(f,t),J(_,t),J(B,t),J(k,t),J($,t),J(F,t),J(x,t),J(I),J(Z),J(V),J(X,t)}}}const Yt='{"title":"Hotswapping adapters","local":"hotswapping-adapters","sections":[{"title":"Example without torch.compile","local":"example-without-torchcompile","sections":[],"depth":2},{"title":"Example with torch.compile","local":"example-with-torchcompile","sections":[],"depth":2},{"title":"Caveats","local":"peft.utils.hotswap.hotswap_adapter","sections":[],"depth":2}],"depth":1}';function At(S){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends Wt{constructor(p){super(),It(this,p,At,Qt,Ft,{})}}export{Dt as component};
