import{s as xt,n as Tt,o as yt}from"../chunks/scheduler.78382b47.js";import{S as wt,i as Pt,e as d,s as n,c as p,h as Ct,a as l,d as a,b as o,f as w,g as c,j as i,k as P,l as r,m as s,n as m,t as f,o as _,p as u}from"../chunks/index.6dd35eb6.js";import{C as Et,H as q,E as Ft}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6888f903.js";import{D as J}from"../chunks/Docstring.286e0aef.js";function qt(at){let T,ge,ue,ve,D,$e,j,be,L,nt="A collection of functions that could be useful for non-PeftModel models, e.g. transformers or diffusers integration",xe,M,ot="The functions provided here can be considered “public API” of PEFT and hence are safe to be used by packages that provide PEFT integrations.",Te,k,ye,$,I,Ne,K,rt="A helper method to cast the adapter weights to the correct dtype.",Be,Q,st="Currently, this only upcasts float16 and bfloat16 to float32.",we,S,Pe,b,z,Ve,X,dt="Delete an existing PEFT adapter.",Ge,Z,lt=`Note: This function does not delete the PEFT config on the model, if there is one. It will also not completely
purge the PEFT layers if the last PEFT adapter is deleted. For this, consider using <code>model.unload()</code> if using a
PEFT model instance, or just reloading the base model.`,Ce,H,Ee,h,A,Ue,ee,it="Get the state dict of the given adapter of the PEFT model.",We,te,pt=`This only includes the PEFT parameters, not the parameters of the base model. Thus the returned <code>state_dict</code> is
generally small compared to the full model size. To retrieve the full <code>state_dict</code>, just call <code>model.state_dict()</code>.`,Oe,ae,ct=`Note that the adapter name is removed from the <code>state_dict</code>, as this is just an arbitrary name that can be changed
when loading the adapter. So e.g. if the adapter name is <code>&#39;default&#39;</code> and the original key is
<code>&#39;model.q_proj.lora_A.default.weight&#39;</code>, the returned key will be <code>&#39;model.q_proj.lora_A.weight&#39;</code>. Use this function
in conjunction with <a href="/docs/peft/v0.18.0/en/package_reference/functional#peft.set_peft_model_state_dict">set_peft_model_state_dict()</a> to take care of the adapter name when loading weights.`,Fe,N,qe,g,B,Re,ne,mt="Create PEFT layers and inject them into the model in-place.",Ye,oe,ft="Currently the API does not support prompt learning methods and adaption prompt.",Je,re,_t=`This function is similar to <a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> but it does not return a <a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> instance. Instead, it returns
the original, mutated instance of the passed model.`,De,V,je,x,G,Ke,se,ut="Set the active PEFT adapter(s) of the model.",Qe,de,ht=`Active adapters are those adapters that participate in the forward pass. Use this function if you want to switch
between multiple PEFT adapters.`,Le,U,Me,y,W,Xe,le,gt="Enable or disable gradients on the given adapter(s).",ke,O,Ie,v,R,Ze,ie,vt="Set the state dict of the PEFT model.",et,pe,$t=`Given a PEFT <code>state_dict</code> (as returned by <a href="/docs/peft/v0.18.0/en/package_reference/functional#peft.get_peft_model_state_dict">get_peft_model_state_dict()</a>), insert the weights into the model. The
model needs to have the PEFT adapters already in place (e.g. via <a href="/docs/peft/v0.18.0/en/package_reference/functional#peft.inject_adapter_in_model">inject_adapter_in_model()</a>).`,tt,ce,bt=`Setting the adapter weights also takes care of re-inserting the adapter name. This name may be a different name
than the one originally used to train the adapter.`,Se,Y,ze,he,He;return D=new Et({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new q({props:{title:"Functions for PEFT integration",local:"functions-for-peft-integration",headingTag:"h1"}}),k=new q({props:{title:"Cast the adapter weight dtypes",local:"peft.tuners.tuners_utils.cast_adapter_dtype",headingTag:"h2"}}),I=new J({props:{name:"peft.tuners.tuners_utils.cast_adapter_dtype",anchor:"peft.tuners.tuners_utils.cast_adapter_dtype",parameters:[{name:"model",val:": nn.Module"},{name:"adapter_name",val:": str"},{name:"autocast_adapter_dtype",val:": bool = True"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.cast_adapter_dtype.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>) &#x2014;
The adapter name.`,name:"adapter_name"},{anchor:"peft.tuners.tuners_utils.cast_adapter_dtype.autocast_adapter_dtype",description:`<strong>autocast_adapter_dtype</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to autocast the adapter dtype. Defaults to <code>True</code>.`,name:"autocast_adapter_dtype"}],source:"https://github.com/huggingface/peft/blob/v0.18.0/src/peft/tuners/tuners_utils.py#L1958"}}),S=new q({props:{title:"Delete the PEFT adapter from model",local:"peft.tuners.tuners_utils.delete_adapter",headingTag:"h2"}}),z=new J({props:{name:"peft.tuners.tuners_utils.delete_adapter",anchor:"peft.tuners.tuners_utils.delete_adapter",parameters:[{name:"model",val:": nn.Module"},{name:"adapter_name",val:": str"},{name:"prefix",val:": str"},{name:"layer_cls",val:": type[BaseTunerLayer] = <class 'peft.tuners.tuners_utils.BaseTunerLayer'>"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.delete_adapter.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
The model from which the adapter should be deleted.`,name:"model"},{anchor:"peft.tuners.tuners_utils.delete_adapter.adapter_name",description:`<strong>adapter_name</strong> (str) &#x2014;
The name of the adapter to be deleted.`,name:"adapter_name"},{anchor:"peft.tuners.tuners_utils.delete_adapter.prefix",description:`<strong>prefix</strong> (str) &#x2014;
The prefix of the PEFT method, e.g. &#x201C;lora_&#x201D; for LoRA.`,name:"prefix"},{anchor:"peft.tuners.tuners_utils.delete_adapter.layer_cls",description:`<strong>layer_cls</strong> (type, optional) &#x2014;
The class of the adapter layer. Defaults to <code>BaseTunerLayer</code>.`,name:"layer_cls"}],source:"https://github.com/huggingface/peft/blob/v0.18.0/src/peft/tuners/tuners_utils.py#L1919",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The name of remaining adapter(s) after deletion, or <code>None</code> if there are no active adapters left. Use this
to set the new active adapter of the model if necessary.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>new_adapter (list[str] | None)</p>
`}}),H=new q({props:{title:"Get the state dict of the PEFT adapter",local:"peft.get_peft_model_state_dict",headingTag:"h2"}}),A=new J({props:{name:"peft.get_peft_model_state_dict",anchor:"peft.get_peft_model_state_dict",parameters:[{name:"model",val:""},{name:"state_dict",val:" = None"},{name:"adapter_name",val:" = 'default'"},{name:"unwrap_compiled",val:" = False"},{name:"save_embedding_layers",val:" = 'auto'"}],parametersDescription:[{anchor:"peft.get_peft_model_state_dict.model",description:`<strong>model</strong> (<a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>) &#x2014; The Peft model. When using torch.nn.DistributedDataParallel, DeepSpeed or FSDP,
the model should be the underlying model/unwrapped model (i.e. model.module).`,name:"model"},{anchor:"peft.get_peft_model_state_dict.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The state dict of the model. If not provided, the state dict of the passed model will be used.`,name:"state_dict"},{anchor:"peft.get_peft_model_state_dict.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The name of the adapter whose state dict should be returned.`,name:"adapter_name"},{anchor:"peft.get_peft_model_state_dict.unwrap_compiled",description:`<strong>unwrap_compiled</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to unwrap the model if torch.compile was used.`,name:"unwrap_compiled"},{anchor:"peft.get_peft_model_state_dict.save_embedding_layers",description:`<strong>save_embedding_layers</strong> (<code>Union[bool, str]</code>, , <em>optional</em>, defaults to <code>auto</code>) &#x2014;
If <code>True</code>, save the embedding layers in addition to adapter weights. If <code>auto</code>, checks the common embedding
layers <code>peft.utils.other.EMBEDDING_LAYER_NAMES</code> in config&#x2019;s <code>target_modules</code> when available. Based on it
sets the boolean flag. This only works for &#x1F917; transformers models.`,name:"save_embedding_layers"}],source:"https://github.com/huggingface/peft/blob/v0.18.0/src/peft/utils/save_and_load.py#L57"}}),N=new q({props:{title:"Inject a PEFT adapter into the model based on a PEFT config",local:"peft.inject_adapter_in_model",headingTag:"h2"}}),B=new J({props:{name:"peft.inject_adapter_in_model",anchor:"peft.inject_adapter_in_model",parameters:[{name:"peft_config",val:": PeftConfig"},{name:"model",val:": torch.nn.Module"},{name:"adapter_name",val:": str = 'default'"},{name:"low_cpu_mem_usage",val:": bool = False"},{name:"state_dict",val:": Optional[dict[str, torch.Tensor]] = None"}],parametersDescription:[{anchor:"peft.inject_adapter_in_model.peft_config",description:`<strong>peft_config</strong> (<code>PeftConfig</code>) &#x2014;
Configuration object containing the parameters of the PEFT model.`,name:"peft_config"},{anchor:"peft.inject_adapter_in_model.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The input model where the adapter will be injected.`,name:"model"},{anchor:"peft.inject_adapter_in_model.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <code>optional</code>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The name of the adapter to be injected, if not provided, the default adapter name is used (&#x201C;default&#x201D;).`,name:"adapter_name"},{anchor:"peft.inject_adapter_in_model.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>False</code>) &#x2014;
Create empty adapter weights on meta device. Useful to speed up the loading process.`,name:"low_cpu_mem_usage"},{anchor:"peft.inject_adapter_in_model.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If a <code>state_dict</code> is passed here, the adapters will be injected based on the entries of the state_dict.
This can be useful when the exact <code>target_modules</code> of the PEFT method is unknown, for instance because the
checkpoint was created without meta data. Note that the values from the <code>state_dict</code> are not used, only the
keys are used to determine the correct layers that should be adapted.`,name:"state_dict"}],source:"https://github.com/huggingface/peft/blob/v0.18.0/src/peft/mapping.py#L47"}}),V=new q({props:{title:"Set the active PEFT adapter(s) of the model",local:"peft.tuners.tuners_utils.set_adapter",headingTag:"h2"}}),G=new J({props:{name:"peft.tuners.tuners_utils.set_adapter",anchor:"peft.tuners.tuners_utils.set_adapter",parameters:[{name:"model",val:""},{name:"adapter_name",val:": str | list[str]"},{name:"inference_mode",val:": bool = False"},{name:"layer_cls",val:": type[BaseTunerLayer] = <class 'peft.tuners.tuners_utils.BaseTunerLayer'>"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.set_adapter.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
The model on which the adapter(s) should be set.`,name:"model"},{anchor:"peft.tuners.tuners_utils.set_adapter.adapter_name",description:`<strong>adapter_name</strong> (str, list[str]) &#x2014;
The name(s) of the adapter(s) to set as active`,name:"adapter_name"},{anchor:"peft.tuners.tuners_utils.set_adapter.inference_mode",description:`<strong>inference_mode</strong> (bool, optional) &#x2014;
Whether the activated adapter should be frozen (i.e. <code>requires_grad=False</code>). Default is False.`,name:"inference_mode"},{anchor:"peft.tuners.tuners_utils.set_adapter.layer_cls",description:`<strong>layer_cls</strong> (type, optional) &#x2014;
The class of the adapter layer. Defaults to <code>BaseTunerLayer</code>.`,name:"layer_cls"}],source:"https://github.com/huggingface/peft/blob/v0.18.0/src/peft/tuners/tuners_utils.py#L1883"}}),U=new q({props:{title:"Set the requires_grad attribute of the specified adapters",local:"peft.tuners.tuners_utils.set_requires_grad",headingTag:"h2"}}),W=new J({props:{name:"peft.tuners.tuners_utils.set_requires_grad",anchor:"peft.tuners.tuners_utils.set_requires_grad",parameters:[{name:"model",val:""},{name:"adapter_names",val:": str | Sequence[str]"},{name:"requires_grad",val:": bool = True"}],parametersDescription:[{anchor:"peft.tuners.tuners_utils.set_requires_grad.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
The model from which the adapter should be deleted.`,name:"model"},{anchor:"peft.tuners.tuners_utils.set_requires_grad.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code> or <code>Sequence[str]</code>) &#x2014;
The name of the adapter(s) whose gradients should be enabled/disabled.`,name:"adapter_name"},{anchor:"peft.tuners.tuners_utils.set_requires_grad.requires_grad",description:`<strong>requires_grad</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to enable (<code>True</code>, default) or disable (<code>False</code>).`,name:"requires_grad"}],source:"https://github.com/huggingface/peft/blob/v0.18.0/src/peft/tuners/tuners_utils.py#L2001"}}),O=new q({props:{title:"Load the weights of the PEFT state dict into the model",local:"peft.set_peft_model_state_dict",headingTag:"h2"}}),R=new J({props:{name:"peft.set_peft_model_state_dict",anchor:"peft.set_peft_model_state_dict",parameters:[{name:"model",val:""},{name:"peft_model_state_dict",val:""},{name:"adapter_name",val:" = 'default'"},{name:"ignore_mismatched_sizes",val:": bool = False"},{name:"low_cpu_mem_usage",val:": bool = False"}],parametersDescription:[{anchor:"peft.set_peft_model_state_dict.model",description:`<strong>model</strong> (<a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>) &#x2014;
The Peft model.`,name:"model"},{anchor:"peft.set_peft_model_state_dict.peft_model_state_dict",description:`<strong>peft_model_state_dict</strong> (<code>dict</code>) &#x2014;
The state dict of the Peft model.`,name:"peft_model_state_dict"},{anchor:"peft.set_peft_model_state_dict.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The name of the adapter whose state dict should be set.`,name:"adapter_name"},{anchor:"peft.set_peft_model_state_dict.ignore_mismatched_sizes",description:`<strong>ignore_mismatched_sizes</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to ignore mismatched in the state dict.`,name:"ignore_mismatched_sizes"},{anchor:"peft.set_peft_model_state_dict.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>False</code>) &#x2014;
This argument must be <code>True</code> if the <code>model</code> was loaded with adapter weights on the meta device, e.g. after
calling <code>inject_adapter_in_model</code> with <code>low_cpu_mem_usage=True</code>. Otherwise, leave it as <code>False</code>.`,name:"low_cpu_mem_usage"}],source:"https://github.com/huggingface/peft/blob/v0.18.0/src/peft/utils/save_and_load.py#L405"}}),Y=new Ft({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/package_reference/functional.md"}}),{c(){T=d("meta"),ge=n(),ue=d("p"),ve=n(),p(D.$$.fragment),$e=n(),p(j.$$.fragment),be=n(),L=d("p"),L.textContent=nt,xe=n(),M=d("p"),M.textContent=ot,Te=n(),p(k.$$.fragment),ye=n(),$=d("div"),p(I.$$.fragment),Ne=n(),K=d("p"),K.textContent=rt,Be=n(),Q=d("p"),Q.textContent=st,we=n(),p(S.$$.fragment),Pe=n(),b=d("div"),p(z.$$.fragment),Ve=n(),X=d("p"),X.textContent=dt,Ge=n(),Z=d("p"),Z.innerHTML=lt,Ce=n(),p(H.$$.fragment),Ee=n(),h=d("div"),p(A.$$.fragment),Ue=n(),ee=d("p"),ee.textContent=it,We=n(),te=d("p"),te.innerHTML=pt,Oe=n(),ae=d("p"),ae.innerHTML=ct,Fe=n(),p(N.$$.fragment),qe=n(),g=d("div"),p(B.$$.fragment),Re=n(),ne=d("p"),ne.textContent=mt,Ye=n(),oe=d("p"),oe.textContent=ft,Je=n(),re=d("p"),re.innerHTML=_t,De=n(),p(V.$$.fragment),je=n(),x=d("div"),p(G.$$.fragment),Ke=n(),se=d("p"),se.textContent=ut,Qe=n(),de=d("p"),de.textContent=ht,Le=n(),p(U.$$.fragment),Me=n(),y=d("div"),p(W.$$.fragment),Xe=n(),le=d("p"),le.textContent=gt,ke=n(),p(O.$$.fragment),Ie=n(),v=d("div"),p(R.$$.fragment),Ze=n(),ie=d("p"),ie.textContent=vt,et=n(),pe=d("p"),pe.innerHTML=$t,tt=n(),ce=d("p"),ce.textContent=bt,Se=n(),p(Y.$$.fragment),ze=n(),he=d("p"),this.h()},l(e){const t=Ct("svelte-u9bgzb",document.head);T=l(t,"META",{name:!0,content:!0}),t.forEach(a),ge=o(e),ue=l(e,"P",{}),w(ue).forEach(a),ve=o(e),c(D.$$.fragment,e),$e=o(e),c(j.$$.fragment,e),be=o(e),L=l(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1lozxs3"&&(L.textContent=nt),xe=o(e),M=l(e,"P",{"data-svelte-h":!0}),i(M)!=="svelte-lkesqg"&&(M.textContent=ot),Te=o(e),c(k.$$.fragment,e),ye=o(e),$=l(e,"DIV",{class:!0});var me=w($);c(I.$$.fragment,me),Ne=o(me),K=l(me,"P",{"data-svelte-h":!0}),i(K)!=="svelte-xcbuq9"&&(K.textContent=rt),Be=o(me),Q=l(me,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-duui02"&&(Q.textContent=st),me.forEach(a),we=o(e),c(S.$$.fragment,e),Pe=o(e),b=l(e,"DIV",{class:!0});var fe=w(b);c(z.$$.fragment,fe),Ve=o(fe),X=l(fe,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1ibhfjd"&&(X.textContent=dt),Ge=o(fe),Z=l(fe,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-fjkgve"&&(Z.innerHTML=lt),fe.forEach(a),Ce=o(e),c(H.$$.fragment,e),Ee=o(e),h=l(e,"DIV",{class:!0});var C=w(h);c(A.$$.fragment,C),Ue=o(C),ee=l(C,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-gnbqlm"&&(ee.textContent=it),We=o(C),te=l(C,"P",{"data-svelte-h":!0}),i(te)!=="svelte-qojlyp"&&(te.innerHTML=pt),Oe=o(C),ae=l(C,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-o47z0a"&&(ae.innerHTML=ct),C.forEach(a),Fe=o(e),c(N.$$.fragment,e),qe=o(e),g=l(e,"DIV",{class:!0});var E=w(g);c(B.$$.fragment,E),Re=o(E),ne=l(E,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-pzx6vm"&&(ne.textContent=mt),Ye=o(E),oe=l(E,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-1kmvq6f"&&(oe.textContent=ft),Je=o(E),re=l(E,"P",{"data-svelte-h":!0}),i(re)!=="svelte-5y9vc7"&&(re.innerHTML=_t),E.forEach(a),De=o(e),c(V.$$.fragment,e),je=o(e),x=l(e,"DIV",{class:!0});var _e=w(x);c(G.$$.fragment,_e),Ke=o(_e),se=l(_e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-1rz47ta"&&(se.textContent=ut),Qe=o(_e),de=l(_e,"P",{"data-svelte-h":!0}),i(de)!=="svelte-1r4gjvt"&&(de.textContent=ht),_e.forEach(a),Le=o(e),c(U.$$.fragment,e),Me=o(e),y=l(e,"DIV",{class:!0});var Ae=w(y);c(W.$$.fragment,Ae),Xe=o(Ae),le=l(Ae,"P",{"data-svelte-h":!0}),i(le)!=="svelte-aqtirv"&&(le.textContent=gt),Ae.forEach(a),ke=o(e),c(O.$$.fragment,e),Ie=o(e),v=l(e,"DIV",{class:!0});var F=w(v);c(R.$$.fragment,F),Ze=o(F),ie=l(F,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-prfap2"&&(ie.textContent=vt),et=o(F),pe=l(F,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-t4zkbn"&&(pe.innerHTML=$t),tt=o(F),ce=l(F,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-2dtopq"&&(ce.textContent=bt),F.forEach(a),Se=o(e),c(Y.$$.fragment,e),ze=o(e),he=l(e,"P",{}),w(he).forEach(a),this.h()},h(){P(T,"name","hf:doc:metadata"),P(T,"content",Dt),P($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,T),s(e,ge,t),s(e,ue,t),s(e,ve,t),m(D,e,t),s(e,$e,t),m(j,e,t),s(e,be,t),s(e,L,t),s(e,xe,t),s(e,M,t),s(e,Te,t),m(k,e,t),s(e,ye,t),s(e,$,t),m(I,$,null),r($,Ne),r($,K),r($,Be),r($,Q),s(e,we,t),m(S,e,t),s(e,Pe,t),s(e,b,t),m(z,b,null),r(b,Ve),r(b,X),r(b,Ge),r(b,Z),s(e,Ce,t),m(H,e,t),s(e,Ee,t),s(e,h,t),m(A,h,null),r(h,Ue),r(h,ee),r(h,We),r(h,te),r(h,Oe),r(h,ae),s(e,Fe,t),m(N,e,t),s(e,qe,t),s(e,g,t),m(B,g,null),r(g,Re),r(g,ne),r(g,Ye),r(g,oe),r(g,Je),r(g,re),s(e,De,t),m(V,e,t),s(e,je,t),s(e,x,t),m(G,x,null),r(x,Ke),r(x,se),r(x,Qe),r(x,de),s(e,Le,t),m(U,e,t),s(e,Me,t),s(e,y,t),m(W,y,null),r(y,Xe),r(y,le),s(e,ke,t),m(O,e,t),s(e,Ie,t),s(e,v,t),m(R,v,null),r(v,Ze),r(v,ie),r(v,et),r(v,pe),r(v,tt),r(v,ce),s(e,Se,t),m(Y,e,t),s(e,ze,t),s(e,he,t),He=!0},p:Tt,i(e){He||(f(D.$$.fragment,e),f(j.$$.fragment,e),f(k.$$.fragment,e),f(I.$$.fragment,e),f(S.$$.fragment,e),f(z.$$.fragment,e),f(H.$$.fragment,e),f(A.$$.fragment,e),f(N.$$.fragment,e),f(B.$$.fragment,e),f(V.$$.fragment,e),f(G.$$.fragment,e),f(U.$$.fragment,e),f(W.$$.fragment,e),f(O.$$.fragment,e),f(R.$$.fragment,e),f(Y.$$.fragment,e),He=!0)},o(e){_(D.$$.fragment,e),_(j.$$.fragment,e),_(k.$$.fragment,e),_(I.$$.fragment,e),_(S.$$.fragment,e),_(z.$$.fragment,e),_(H.$$.fragment,e),_(A.$$.fragment,e),_(N.$$.fragment,e),_(B.$$.fragment,e),_(V.$$.fragment,e),_(G.$$.fragment,e),_(U.$$.fragment,e),_(W.$$.fragment,e),_(O.$$.fragment,e),_(R.$$.fragment,e),_(Y.$$.fragment,e),He=!1},d(e){e&&(a(ge),a(ue),a(ve),a($e),a(be),a(L),a(xe),a(M),a(Te),a(ye),a($),a(we),a(Pe),a(b),a(Ce),a(Ee),a(h),a(Fe),a(qe),a(g),a(De),a(je),a(x),a(Le),a(Me),a(y),a(ke),a(Ie),a(v),a(Se),a(ze),a(he)),a(T),u(D,e),u(j,e),u(k,e),u(I),u(S,e),u(z),u(H,e),u(A),u(N,e),u(B),u(V,e),u(G),u(U,e),u(W),u(O,e),u(R),u(Y,e)}}}const Dt='{"title":"Functions for PEFT integration","local":"functions-for-peft-integration","sections":[{"title":"Cast the adapter weight dtypes","local":"peft.tuners.tuners_utils.cast_adapter_dtype","sections":[],"depth":2},{"title":"Delete the PEFT adapter from model","local":"peft.tuners.tuners_utils.delete_adapter","sections":[],"depth":2},{"title":"Get the state dict of the PEFT adapter","local":"peft.get_peft_model_state_dict","sections":[],"depth":2},{"title":"Inject a PEFT adapter into the model based on a PEFT config","local":"peft.inject_adapter_in_model","sections":[],"depth":2},{"title":"Set the active PEFT adapter(s) of the model","local":"peft.tuners.tuners_utils.set_adapter","sections":[],"depth":2},{"title":"Set the requires_grad attribute of the specified adapters","local":"peft.tuners.tuners_utils.set_requires_grad","sections":[],"depth":2},{"title":"Load the weights of the PEFT state dict into the model","local":"peft.set_peft_model_state_dict","sections":[],"depth":2}],"depth":1}';function jt(at){return yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends wt{constructor(T){super(),Pt(this,T,jt,qt,xt,{})}}export{St as component};
