import{s as El,n as Il,o as xl}from"../chunks/scheduler.78382b47.js";import{S as Gl,i as Al,e as o,s as a,c as p,h as Hl,a as s,d as l,b as i,f as Xl,g as m,j as r,k as Rl,l as Nl,m as n,n as f,t as u,o as d,p as h}from"../chunks/index.6dd35eb6.js";import{C as Vl,H as M,E as Yl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6888f903.js";import{C as c}from"../chunks/CodeBlock.658dd679.js";function Pl(tl){let b,Fe,Le,Ue,g,Xe,y,Re,w,ll="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",Ee,T,nl='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li> <li>quantizing to as low as 2-bit precision with the <a href="https://huggingface.co/papers/2401.06118" rel="nofollow">AQLM</a> algorithm</li>',Ie,J,al='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',xe,$,il="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",Ge,_,Ae,q,ol='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',He,v,sl="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",Ne,j,Ve,Z,rl='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/v4.57.1/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',Ye,C,Pe,z,pl='Next, you should call the <a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for training.',Se,W,De,k,ml="Now that the quantized model is ready, let’s set up a configuration.",Ke,Q,Oe,L,fl='Create a <a href="/docs/peft/v0.18.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',et,B,tt,F,ul='Then use the <a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/v0.18.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',lt,U,nt,X,dl="You’re all set for training with whichever training method you prefer!",at,R,it,E,hl='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',ot,I,cl="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",st,x,rt,G,Ml="QLoRA adds trainable weights to all the linear layers in the transformer architecture. Since the attribute names for these linear layers can vary across architectures, set <code>target_modules</code> to <code>&quot;all-linear&quot;</code> to add LoRA to all the linear layers:",pt,A,mt,H,ft,N,bl='You can learn more about gptq based <code>[2, 3, 4, 8]</code> bits quantization at <a href="https://github.com/ModelCloud/GPTQModel" rel="nofollow">GPTQModel</a> and the Transformers <a href="https://huggingface.co/docs/transformers/quantization/gptq" rel="nofollow">GPTQ</a> doc. Post-quant training, PEFT can use both <a href="https://github.com/ModelCloud/GPTQModel" rel="nofollow">GPTQModel</a> or <a href="https://github.com/autogptq/autogptq" rel="nofollow">AutoGPTQ</a> libraries, but we recommend GPTQModel because AutoGPTQ will be deprecated in a future release.',ut,V,dt,Y,ht,P,gl="Once quantized, you can post-train GPTQ models with PEFT APIs.",ct,S,Mt,D,yl='Additive Quantization of Language Models (<a href="https://huggingface.co/papers/2401.06118" rel="nofollow">AQLM</a>) is a Large Language Models compression method. It quantizes multiple weights together and takes advantage of interdependencies between them. AQLM represents groups of 8-16 weights as a sum of multiple vector codes. This allows it to compress models down to as low as 2-bit with considerably low accuracy losses.',bt,K,wl='Since the AQLM quantization process is computationally expensive, the use of prequantized models is recommended. A partial list of available models can be found in the official aqlm <a href="https://github.com/Vahe1994/AQLM" rel="nofollow">repository</a>.',gt,O,Tl="The models support LoRA adapter tuning. To tune the quantized model you’ll need to install the <code>aqlm</code> inference library: <code>pip install aqlm&gt;=1.0.2</code>. Finetuned LoRA adapters shall be saved separately, as merging them with AQLM quantized weights is not possible.",yt,ee,wt,te,Jl='You can refer to the <a href="https://colab.research.google.com/drive/12GTp1FCj5_0SnnNQH18h_2XFh9vS_guX?usp=sharing" rel="nofollow">Google Colab</a> example for an overview of AQLM+LoRA finetuning.',Tt,le,Jt,ne,$l='You can also perform LoRA fine-tuning on EETQ quantized models. <a href="https://github.com/NetEase-FuXi/EETQ" rel="nofollow">EETQ</a> package offers simple and efficient way to perform 8-bit quantization, which is claimed to be faster than the <code>LLM.int8()</code> algorithm. First, make sure that you have a transformers version that is compatible with EETQ (e.g. by installing it from latest pypi or from source).',$t,ae,_t,ie,_l='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/v4.57.1/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',qt,oe,vt,se,ql="and create a <code>LoraConfig</code> and pass it to <code>get_peft_model</code>:",jt,re,Zt,pe,Ct,me,vl='The models that are quantized using Half-Quadratic Quantization of Large Machine Learning Models (<a href="https://mobiusml.github.io/hqq_blog/" rel="nofollow">HQQ</a>) support LoRA adapter tuning. To tune the quantized model, you’ll need to install the <code>hqq</code> library with: <code>pip install hqq</code>.',zt,fe,Wt,ue,jl="Or using transformers version that is compatible with HQQ (e.g. by installing it from latest pypi or from source).",kt,de,Qt,he,Lt,ce,Zl='PEFT supports models quantized with <a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> (“ao”) for int8 quantization.',Bt,Me,Ft,be,Ut,ge,Cl="<li>Use the most recent versions of torchao (&gt;= v0.4.0) and transformers (&gt; 4.42).</li> <li>Only linear layers are currently supported.</li> <li><code>quant_type = &quot;int4_weight_only&quot;</code> is currently not supported.</li> <li><code>NF4</code> is not implemented in transformers as of yet and is thus also not supported.</li> <li>DoRA only works with <code>quant_type = &quot;int8_weight_only&quot;</code> at the moment.</li> <li>There is explicit support for torchao when used with LoRA. However, when torchao quantizes a layer, its class does not change, only the type of the underlying tensor. For this reason, PEFT methods other than LoRA will generally also work with torchao, even if not explicitly supported. Be aware, however, that <strong>merging only works correctly with LoRA and with <code>quant_type = &quot;int8_weight_only&quot;</code></strong>. If you use a different PEFT method or dtype, merging will likely result in an error, and even it doesn’t, the results will still be incorrect.</li>",Xt,ye,Rt,we,zl=`Intel Neural Compressor (<a href="https://github.com/intel/neural-compressor" rel="nofollow">INC</a>) enables model quantization for various devices,
including Intel Gaudi accelerators (also known as HPU devices). You can perform LoRA fine-tuning on models that have been
quantized using INC. To use INC with PyTorch models, install the library with: <code>pip install neural-compressor[pt]</code>.
Quantizing a model to FP8 precision for HPU devices can be done with the following single-step quantization workflow:`,Et,Te,It,Je,Wl=`Pass the config to the <code>prepare</code> method, run inference to gather calibration stats, and call <code>finalize_calibration</code>
and <code>convert</code> methods to quantize model to FP8 precision:`,xt,$e,Gt,_e,kl=`An example demonstrating how to load a PEFT LoRA adapter into an INC-quantized FLUX text-to-image model for HPU
devices is provided <a href="https://github.com/huggingface/peft/blob/main/examples/stable_diffusion/inc_flux_lora_hpu.py" rel="nofollow">here</a>.`,At,qe,Ht,ve,Ql="<li><code>merge()</code> and <code>unmerge()</code> methods are currently not supported for INC-quantized models.</li> <li>Currently, only <strong>Linear</strong> INC-quantized layers are supported when loading PEFT adapters.</li>",Nt,je,Vt,Ze,Ll="Besides LoRA, the following PEFT methods also support quantization:",Yt,Ce,Bl="<li><strong>VeRA</strong> (supports bitsandbytes quantization)</li> <li><strong>AdaLoRA</strong> (supports both bitsandbytes and GPTQ quantization)</li> <li><strong>(IA)³</strong> (supports bitsandbytes quantization)</li>",Pt,ze,St,We,Fl="If you’re interested in learning more about quantization, the following may be helpful:",Dt,ke,Ul='<li>Learn more details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',Kt,Qe,Ot,Be,el;return g=new Vl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new M({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),_=new M({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),j=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),C=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),W=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),Q=new M({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),B=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),U=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),R=new M({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),x=new M({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),A=new c({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),H=new M({props:{title:"GPTQ quantization",local:"gptq-quantization",headingTag:"h2"}}),V=new c({props:{code:"JTIzJTIwZ3B0cW1vZGVsJTIwaW5zdGFsbCUwQXBpcCUyMGluc3RhbGwlMjBncHRxbW9kZWwlMjAtLW5vLWJ1aWxkLWlzb2xhdGlvbg==",highlighted:`<span class="hljs-comment"># gptqmodel install</span>
pip install gptqmodel --no-build-isolation`,wrap:!1}}),Y=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEdQVFFDb25maWclMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmZhY2Vib29rJTJGb3B0LTEyNW0lMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFncHRxX2NvbmZpZyUyMCUzRCUyMEdQVFFDb25maWcoYml0cyUzRDQlMkMlMjBncm91cF9zaXplJTNEMTI4JTJDJTIwZGF0YXNldCUzRCUyMndpa2l0ZXh0MiUyMiUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RncHRxX2NvbmZpZyklMEElMEElMjMlMjBzYXZlJTIwcXVhbnRpemVkJTIwbW9kZWwlMEFxdWFudGl6ZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMi4lMkZvcHQtMTI1bS1ncHRxJTIyKSUwQXRva2VuaXplci5zYXZlX3ByZXRyYWluZWQoJTIyLiUyRm9wdC0xMjVtLWdwdHElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, GPTQConfig

model_id = <span class="hljs-string">&quot;facebook/opt-125m&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)

gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, group_size=<span class="hljs-number">128</span>, dataset=<span class="hljs-string">&quot;wikitext2&quot;</span>, tokenizer=tokenizer)

quantized_model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=gptq_config)

<span class="hljs-comment"># save quantized model</span>
quantized_model.save_pretrained(<span class="hljs-string">&quot;./opt-125m-gptq&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;./opt-125m-gptq&quot;</span>)`,wrap:!1}}),S=new M({props:{title:"AQLM quantization",local:"aqlm-quantization",headingTag:"h2"}}),ee=new c({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkJsYWNrU2Ftb3JleiUyRk1peHRyYWwtOHg3Yi1BUUxNLTJCaXQtMXgxNi1oZi10ZXN0LWRpc3BhdGNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEEpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;BlackSamorez/Mixtral-8x7b-AQLM-2Bit-1x16-hf-test-dispatch&quot;</span>,
    dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>,
)

peft_config = LoraConfig(...)

quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),le=new M({props:{title:"EETQ quantization",local:"eetq-quantization",headingTag:"h2"}}),ae=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwRWV0cUNvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMEVldHFDb25maWcoJTIyaW50OCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> EetqConfig

config = EetqConfig(<span class="hljs-string">&quot;int8&quot;</span>)`,wrap:!1}}),oe=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),re=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0Q4JTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0QlNUIlMjJxX3Byb2olMjIlMkMlMjAlMjJrX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlMkMlMjAlMjJvX3Byb2olMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model = get_peft_model(model, config)`,wrap:!1}}),pe=new M({props:{title:"HQQ quantization",local:"hqq-quantization",headingTag:"h2"}}),fe=new c({props:{code:"ZnJvbSUyMGhxcS5lbmdpbmUuaGYlMjBpbXBvcnQlMjBIUVFNb2RlbEZvckNhdXNhbExNJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guYWNjZWxlcmF0b3IuY3VycmVudF9hY2NlbGVyYXRvcigpLnR5cGUlMjBpZiUyMGhhc2F0dHIodG9yY2glMkMlMjAlMjJhY2NlbGVyYXRvciUyMiklMjBlbHNlJTIwJTIyY3VkYSUyMiUwQSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMEhRUU1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9xdWFudGl6ZWQoc2F2ZV9kaXJfb3JfaGZodWIlMkMlMjBkZXZpY2UlM0RkZXZpY2UpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> hqq.engine.hf <span class="hljs-keyword">import</span> HQQModelForCausalLM

device = torch.accelerator.current_accelerator().<span class="hljs-built_in">type</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(torch, <span class="hljs-string">&quot;accelerator&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span>

quantized_model = HQQModelForCausalLM.from_quantized(save_dir_or_hfhub, device=device)
peft_config = LoraConfig(...)
quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),de=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhxcUNvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwSHFxQ29uZmlnKG5iaXRzJTNENCUyQyUyMGdyb3VwX3NpemUlM0Q2NCklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJfb3JfaGZodWIlMkMlMjBkZXZpY2VfbWFwJTNEZGV2aWNlX21hcCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWcpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HqqConfig, AutoModelForCausalLM

quant_config = HqqConfig(nbits=<span class="hljs-number">4</span>, group_size=<span class="hljs-number">64</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(save_dir_or_hfhub, device_map=device_map, quantization_config=quant_config)
peft_config = LoraConfig(...)
quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),he=new M({props:{title:"torchao (PyTorch Architecture Optimization)",local:"torchao-pytorch-architecture-optimization",headingTag:"h2"}}),Me=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBUb3JjaEFvQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwVG9yY2hBb0NvbmZpZyhxdWFudF90eXBlJTNEJTIyaW50OF93ZWlnaHRfb25seSUyMiklMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, TorchAoConfig

model_id = ...
quantization_config = TorchAoConfig(quant_type=<span class="hljs-string">&quot;int8_weight_only&quot;</span>)
base_model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=quantization_config)
peft_config = LoraConfig(...)
model = get_peft_model(base_model, peft_config)`,wrap:!1}}),be=new M({props:{title:"Caveats:",local:"caveats",headingTag:"h3"}}),ye=new M({props:{title:"INC quantization",local:"inc-quantization",headingTag:"h2"}}),Te=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwbmV1cmFsX2NvbXByZXNzb3IudG9yY2gucXVhbnRpemF0aW9uJTIwaW1wb3J0JTIwRlA4Q29uZmlnJTJDJTIwY29udmVydCUyQyUyMGZpbmFsaXplX2NhbGlicmF0aW9uJTJDJTIwcHJlcGFyZSUwQXF1YW50X2NvbmZpZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAuLi4lMEElN0QlMEFjb25maWclMjAlM0QlMjBGUDhDb25maWcoKipxdWFudF9jb25maWdzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> neural_compressor.torch.quantization <span class="hljs-keyword">import</span> FP8Config, convert, finalize_calibration, prepare
quant_configs = {
    ...
}
config = FP8Config(**quant_configs)`,wrap:!1}}),$e=new c({props:{code:"",highlighted:`model = prepare(model, config)
<span class="hljs-comment"># Run inference to collect calibration statistics</span>
...
<span class="hljs-comment"># Finalize calibration and convert the model to FP8 precision</span>
finalize_calibration(model)
model = convert(model)
<span class="hljs-comment"># Load PEFT LoRA adapter as usual</span>
...`,wrap:!1}}),qe=new M({props:{title:"Caveats:",local:"caveats",headingTag:"h3"}}),je=new M({props:{title:"Other Supported PEFT Methods",local:"other-supported-peft-methods",headingTag:"h2"}}),ze=new M({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Qe=new Yl({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/quantization.md"}}),{c(){b=o("meta"),Fe=a(),Le=o("p"),Ue=a(),p(g.$$.fragment),Xe=a(),p(y.$$.fragment),Re=a(),w=o("p"),w.textContent=ll,Ee=a(),T=o("ul"),T.innerHTML=nl,Ie=a(),J=o("p"),J.innerHTML=al,xe=a(),$=o("p"),$.textContent=il,Ge=a(),p(_.$$.fragment),Ae=a(),q=o("p"),q.innerHTML=ol,He=a(),v=o("ul"),v.innerHTML=sl,Ne=a(),p(j.$$.fragment),Ve=a(),Z=o("p"),Z.innerHTML=rl,Ye=a(),p(C.$$.fragment),Pe=a(),z=o("p"),z.innerHTML=pl,Se=a(),p(W.$$.fragment),De=a(),k=o("p"),k.textContent=ml,Ke=a(),p(Q.$$.fragment),Oe=a(),L=o("p"),L.innerHTML=fl,et=a(),p(B.$$.fragment),tt=a(),F=o("p"),F.innerHTML=ul,lt=a(),p(U.$$.fragment),nt=a(),X=o("p"),X.textContent=dl,at=a(),p(R.$$.fragment),it=a(),E=o("p"),E.innerHTML=hl,ot=a(),I=o("p"),I.innerHTML=cl,st=a(),p(x.$$.fragment),rt=a(),G=o("p"),G.innerHTML=Ml,pt=a(),p(A.$$.fragment),mt=a(),p(H.$$.fragment),ft=a(),N=o("p"),N.innerHTML=bl,ut=a(),p(V.$$.fragment),dt=a(),p(Y.$$.fragment),ht=a(),P=o("p"),P.textContent=gl,ct=a(),p(S.$$.fragment),Mt=a(),D=o("p"),D.innerHTML=yl,bt=a(),K=o("p"),K.innerHTML=wl,gt=a(),O=o("p"),O.innerHTML=Tl,yt=a(),p(ee.$$.fragment),wt=a(),te=o("p"),te.innerHTML=Jl,Tt=a(),p(le.$$.fragment),Jt=a(),ne=o("p"),ne.innerHTML=$l,$t=a(),p(ae.$$.fragment),_t=a(),ie=o("p"),ie.innerHTML=_l,qt=a(),p(oe.$$.fragment),vt=a(),se=o("p"),se.innerHTML=ql,jt=a(),p(re.$$.fragment),Zt=a(),p(pe.$$.fragment),Ct=a(),me=o("p"),me.innerHTML=vl,zt=a(),p(fe.$$.fragment),Wt=a(),ue=o("p"),ue.textContent=jl,kt=a(),p(de.$$.fragment),Qt=a(),p(he.$$.fragment),Lt=a(),ce=o("p"),ce.innerHTML=Zl,Bt=a(),p(Me.$$.fragment),Ft=a(),p(be.$$.fragment),Ut=a(),ge=o("ul"),ge.innerHTML=Cl,Xt=a(),p(ye.$$.fragment),Rt=a(),we=o("p"),we.innerHTML=zl,Et=a(),p(Te.$$.fragment),It=a(),Je=o("p"),Je.innerHTML=Wl,xt=a(),p($e.$$.fragment),Gt=a(),_e=o("p"),_e.innerHTML=kl,At=a(),p(qe.$$.fragment),Ht=a(),ve=o("ul"),ve.innerHTML=Ql,Nt=a(),p(je.$$.fragment),Vt=a(),Ze=o("p"),Ze.textContent=Ll,Yt=a(),Ce=o("ul"),Ce.innerHTML=Bl,Pt=a(),p(ze.$$.fragment),St=a(),We=o("p"),We.textContent=Fl,Dt=a(),ke=o("ul"),ke.innerHTML=Ul,Kt=a(),p(Qe.$$.fragment),Ot=a(),Be=o("p"),this.h()},l(e){const t=Hl("svelte-u9bgzb",document.head);b=s(t,"META",{name:!0,content:!0}),t.forEach(l),Fe=i(e),Le=s(e,"P",{}),Xl(Le).forEach(l),Ue=i(e),m(g.$$.fragment,e),Xe=i(e),m(y.$$.fragment,e),Re=i(e),w=s(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-famg4s"&&(w.textContent=ll),Ee=i(e),T=s(e,"UL",{"data-svelte-h":!0}),r(T)!=="svelte-1hhuofo"&&(T.innerHTML=nl),Ie=i(e),J=s(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-142xot4"&&(J.innerHTML=al),xe=i(e),$=s(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1demhiu"&&($.textContent=il),Ge=i(e),m(_.$$.fragment,e),Ae=i(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1w3vp62"&&(q.innerHTML=ol),He=i(e),v=s(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-hfynw8"&&(v.innerHTML=sl),Ne=i(e),m(j.$$.fragment,e),Ve=i(e),Z=s(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-13w70lw"&&(Z.innerHTML=rl),Ye=i(e),m(C.$$.fragment,e),Pe=i(e),z=s(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-v0b2zg"&&(z.innerHTML=pl),Se=i(e),m(W.$$.fragment,e),De=i(e),k=s(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-11mx7fc"&&(k.textContent=ml),Ke=i(e),m(Q.$$.fragment,e),Oe=i(e),L=s(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-wl9z8g"&&(L.innerHTML=fl),et=i(e),m(B.$$.fragment,e),tt=i(e),F=s(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-19r7r0s"&&(F.innerHTML=ul),lt=i(e),m(U.$$.fragment,e),nt=i(e),X=s(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-xd402n"&&(X.textContent=dl),at=i(e),m(R.$$.fragment,e),it=i(e),E=s(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-f32n60"&&(E.innerHTML=hl),ot=i(e),I=s(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-7f0aai"&&(I.innerHTML=cl),st=i(e),m(x.$$.fragment,e),rt=i(e),G=s(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1c7jiea"&&(G.innerHTML=Ml),pt=i(e),m(A.$$.fragment,e),mt=i(e),m(H.$$.fragment,e),ft=i(e),N=s(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-waooev"&&(N.innerHTML=bl),ut=i(e),m(V.$$.fragment,e),dt=i(e),m(Y.$$.fragment,e),ht=i(e),P=s(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-lqq230"&&(P.textContent=gl),ct=i(e),m(S.$$.fragment,e),Mt=i(e),D=s(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1myyhap"&&(D.innerHTML=yl),bt=i(e),K=s(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1qhybjf"&&(K.innerHTML=wl),gt=i(e),O=s(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-wlm3ol"&&(O.innerHTML=Tl),yt=i(e),m(ee.$$.fragment,e),wt=i(e),te=s(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1f1bzer"&&(te.innerHTML=Jl),Tt=i(e),m(le.$$.fragment,e),Jt=i(e),ne=s(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-16tz5mo"&&(ne.innerHTML=$l),$t=i(e),m(ae.$$.fragment,e),_t=i(e),ie=s(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-13w70lw"&&(ie.innerHTML=_l),qt=i(e),m(oe.$$.fragment,e),vt=i(e),se=s(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1wgonl8"&&(se.innerHTML=ql),jt=i(e),m(re.$$.fragment,e),Zt=i(e),m(pe.$$.fragment,e),Ct=i(e),me=s(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1yzgecf"&&(me.innerHTML=vl),zt=i(e),m(fe.$$.fragment,e),Wt=i(e),ue=s(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-p9acs7"&&(ue.textContent=jl),kt=i(e),m(de.$$.fragment,e),Qt=i(e),m(he.$$.fragment,e),Lt=i(e),ce=s(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-gynv46"&&(ce.innerHTML=Zl),Bt=i(e),m(Me.$$.fragment,e),Ft=i(e),m(be.$$.fragment,e),Ut=i(e),ge=s(e,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-4si0iy"&&(ge.innerHTML=Cl),Xt=i(e),m(ye.$$.fragment,e),Rt=i(e),we=s(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-8d7dps"&&(we.innerHTML=zl),Et=i(e),m(Te.$$.fragment,e),It=i(e),Je=s(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-10yr85u"&&(Je.innerHTML=Wl),xt=i(e),m($e.$$.fragment,e),Gt=i(e),_e=s(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1ugpcug"&&(_e.innerHTML=kl),At=i(e),m(qe.$$.fragment,e),Ht=i(e),ve=s(e,"UL",{"data-svelte-h":!0}),r(ve)!=="svelte-h65blx"&&(ve.innerHTML=Ql),Nt=i(e),m(je.$$.fragment,e),Vt=i(e),Ze=s(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-14evo3v"&&(Ze.textContent=Ll),Yt=i(e),Ce=s(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-ro48c4"&&(Ce.innerHTML=Bl),Pt=i(e),m(ze.$$.fragment,e),St=i(e),We=s(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-agdyn7"&&(We.textContent=Fl),Dt=i(e),ke=s(e,"UL",{"data-svelte-h":!0}),r(ke)!=="svelte-10zqaf7"&&(ke.innerHTML=Ul),Kt=i(e),m(Qe.$$.fragment,e),Ot=i(e),Be=s(e,"P",{}),Xl(Be).forEach(l),this.h()},h(){Rl(b,"name","hf:doc:metadata"),Rl(b,"content",Sl)},m(e,t){Nl(document.head,b),n(e,Fe,t),n(e,Le,t),n(e,Ue,t),f(g,e,t),n(e,Xe,t),f(y,e,t),n(e,Re,t),n(e,w,t),n(e,Ee,t),n(e,T,t),n(e,Ie,t),n(e,J,t),n(e,xe,t),n(e,$,t),n(e,Ge,t),f(_,e,t),n(e,Ae,t),n(e,q,t),n(e,He,t),n(e,v,t),n(e,Ne,t),f(j,e,t),n(e,Ve,t),n(e,Z,t),n(e,Ye,t),f(C,e,t),n(e,Pe,t),n(e,z,t),n(e,Se,t),f(W,e,t),n(e,De,t),n(e,k,t),n(e,Ke,t),f(Q,e,t),n(e,Oe,t),n(e,L,t),n(e,et,t),f(B,e,t),n(e,tt,t),n(e,F,t),n(e,lt,t),f(U,e,t),n(e,nt,t),n(e,X,t),n(e,at,t),f(R,e,t),n(e,it,t),n(e,E,t),n(e,ot,t),n(e,I,t),n(e,st,t),f(x,e,t),n(e,rt,t),n(e,G,t),n(e,pt,t),f(A,e,t),n(e,mt,t),f(H,e,t),n(e,ft,t),n(e,N,t),n(e,ut,t),f(V,e,t),n(e,dt,t),f(Y,e,t),n(e,ht,t),n(e,P,t),n(e,ct,t),f(S,e,t),n(e,Mt,t),n(e,D,t),n(e,bt,t),n(e,K,t),n(e,gt,t),n(e,O,t),n(e,yt,t),f(ee,e,t),n(e,wt,t),n(e,te,t),n(e,Tt,t),f(le,e,t),n(e,Jt,t),n(e,ne,t),n(e,$t,t),f(ae,e,t),n(e,_t,t),n(e,ie,t),n(e,qt,t),f(oe,e,t),n(e,vt,t),n(e,se,t),n(e,jt,t),f(re,e,t),n(e,Zt,t),f(pe,e,t),n(e,Ct,t),n(e,me,t),n(e,zt,t),f(fe,e,t),n(e,Wt,t),n(e,ue,t),n(e,kt,t),f(de,e,t),n(e,Qt,t),f(he,e,t),n(e,Lt,t),n(e,ce,t),n(e,Bt,t),f(Me,e,t),n(e,Ft,t),f(be,e,t),n(e,Ut,t),n(e,ge,t),n(e,Xt,t),f(ye,e,t),n(e,Rt,t),n(e,we,t),n(e,Et,t),f(Te,e,t),n(e,It,t),n(e,Je,t),n(e,xt,t),f($e,e,t),n(e,Gt,t),n(e,_e,t),n(e,At,t),f(qe,e,t),n(e,Ht,t),n(e,ve,t),n(e,Nt,t),f(je,e,t),n(e,Vt,t),n(e,Ze,t),n(e,Yt,t),n(e,Ce,t),n(e,Pt,t),f(ze,e,t),n(e,St,t),n(e,We,t),n(e,Dt,t),n(e,ke,t),n(e,Kt,t),f(Qe,e,t),n(e,Ot,t),n(e,Be,t),el=!0},p:Il,i(e){el||(u(g.$$.fragment,e),u(y.$$.fragment,e),u(_.$$.fragment,e),u(j.$$.fragment,e),u(C.$$.fragment,e),u(W.$$.fragment,e),u(Q.$$.fragment,e),u(B.$$.fragment,e),u(U.$$.fragment,e),u(R.$$.fragment,e),u(x.$$.fragment,e),u(A.$$.fragment,e),u(H.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(S.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(fe.$$.fragment,e),u(de.$$.fragment,e),u(he.$$.fragment,e),u(Me.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(Te.$$.fragment,e),u($e.$$.fragment,e),u(qe.$$.fragment,e),u(je.$$.fragment,e),u(ze.$$.fragment,e),u(Qe.$$.fragment,e),el=!0)},o(e){d(g.$$.fragment,e),d(y.$$.fragment,e),d(_.$$.fragment,e),d(j.$$.fragment,e),d(C.$$.fragment,e),d(W.$$.fragment,e),d(Q.$$.fragment,e),d(B.$$.fragment,e),d(U.$$.fragment,e),d(R.$$.fragment,e),d(x.$$.fragment,e),d(A.$$.fragment,e),d(H.$$.fragment,e),d(V.$$.fragment,e),d(Y.$$.fragment,e),d(S.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(fe.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),d(Me.$$.fragment,e),d(be.$$.fragment,e),d(ye.$$.fragment,e),d(Te.$$.fragment,e),d($e.$$.fragment,e),d(qe.$$.fragment,e),d(je.$$.fragment,e),d(ze.$$.fragment,e),d(Qe.$$.fragment,e),el=!1},d(e){e&&(l(Fe),l(Le),l(Ue),l(Xe),l(Re),l(w),l(Ee),l(T),l(Ie),l(J),l(xe),l($),l(Ge),l(Ae),l(q),l(He),l(v),l(Ne),l(Ve),l(Z),l(Ye),l(Pe),l(z),l(Se),l(De),l(k),l(Ke),l(Oe),l(L),l(et),l(tt),l(F),l(lt),l(nt),l(X),l(at),l(it),l(E),l(ot),l(I),l(st),l(rt),l(G),l(pt),l(mt),l(ft),l(N),l(ut),l(dt),l(ht),l(P),l(ct),l(Mt),l(D),l(bt),l(K),l(gt),l(O),l(yt),l(wt),l(te),l(Tt),l(Jt),l(ne),l($t),l(_t),l(ie),l(qt),l(vt),l(se),l(jt),l(Zt),l(Ct),l(me),l(zt),l(Wt),l(ue),l(kt),l(Qt),l(Lt),l(ce),l(Bt),l(Ft),l(Ut),l(ge),l(Xt),l(Rt),l(we),l(Et),l(It),l(Je),l(xt),l(Gt),l(_e),l(At),l(Ht),l(ve),l(Nt),l(Vt),l(Ze),l(Yt),l(Ce),l(Pt),l(St),l(We),l(Dt),l(ke),l(Kt),l(Ot),l(Be)),l(b),h(g,e),h(y,e),h(_,e),h(j,e),h(C,e),h(W,e),h(Q,e),h(B,e),h(U,e),h(R,e),h(x,e),h(A,e),h(H,e),h(V,e),h(Y,e),h(S,e),h(ee,e),h(le,e),h(ae,e),h(oe,e),h(re,e),h(pe,e),h(fe,e),h(de,e),h(he,e),h(Me,e),h(be,e),h(ye,e),h(Te,e),h($e,e),h(qe,e),h(je,e),h(ze,e),h(Qe,e)}}}const Sl='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"GPTQ quantization","local":"gptq-quantization","sections":[],"depth":2},{"title":"AQLM quantization","local":"aqlm-quantization","sections":[],"depth":2},{"title":"EETQ quantization","local":"eetq-quantization","sections":[],"depth":2},{"title":"HQQ quantization","local":"hqq-quantization","sections":[],"depth":2},{"title":"torchao (PyTorch Architecture Optimization)","local":"torchao-pytorch-architecture-optimization","sections":[{"title":"Caveats:","local":"caveats","sections":[],"depth":3}],"depth":2},{"title":"INC quantization","local":"inc-quantization","sections":[{"title":"Caveats:","local":"caveats","sections":[],"depth":3}],"depth":2},{"title":"Other Supported PEFT Methods","local":"other-supported-peft-methods","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Dl(tl){return xl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ln extends Gl{constructor(b){super(),Al(this,b,Dl,Pl,El,{})}}export{ln as component};
