import{s as _a,n as $a,o as Ba}from"../chunks/scheduler.3a17fb72.js";import{S as va,i as Ea,e as j,s as n,c as e,h as Za,a as h,d as l,b as p,f as ba,g as u,j as r,k as qa,l as ka,m as t,n as i,t as o,o as M,p as c}from"../chunks/index.093f8863.js";import{C as Qa,H as T,E as Na}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f595492c.js";import{C as os}from"../chunks/CodeBlock.614e60d2.js";function Wa(ua){let J,js,Ms,hs,y,rs,d,Ts,m,ia="Lighteval provides comprehensive logging and result management through the <code>EvaluationTracker</code> class. This system allows you to save results locally and optionally push them to various platforms for collaboration and analysis.",Js,U,ys,w,oa=`Lighteval automatically saves results and evaluation details in the
directory specified with the <code>--output-dir</code> option. The results are saved in
<code>{output_dir}/results/{model_name}/results_{timestamp}.json</code>. <a href="#example-of-a-result-file">Here is an
example of a result file</a>. The output path can be
any <a href="https://filesystem-spec.readthedocs.io/en/latest/index.html" rel="nofollow">fsspec</a>
compliant path (local, S3, Hugging Face Hub, Google Drive, FTP, etc.).`,ds,I,Ma=`To save detailed evaluation information, you can use the <code>--save-details</code>
option. The details are saved in Parquet files at
<code>{output_dir}/details/{model_name}/{timestamp}/details_{task}_{timestamp}.parquet</code>.`,ms,g,ca=`If you want results to be saved in a custom path structure, you can set the <code>results-path-template</code> option.
This allows you to specify a string template for the path. The template must contain the following
variables: <code>output_dir</code>, <code>model_name</code>, <code>org</code>. For example:
<code>{output_dir}/{org}_{model}</code>. The template will be used to create the path for the results file.`,Us,f,ws,C,ja=`You can push results and evaluation details to the Hugging Face Hub. To do
so, you need to set the <code>--push-to-hub</code> option as well as the <code>--results-org</code>
option. The results are saved in a dataset with the name
<code>{results_org}/{model_org}/{model_name}</code>. To push the details, you need to set
the <code>--save-details</code> option.`,Is,A,ha=`The dataset created will be private by default. You can make it public by
setting the <code>--public-run</code> option.`,gs,b,fs,q,ra=`You can push results to TensorBoard by setting <code>--push-to-tensorboard</code>.
This creates a TensorBoard dashboard in a Hugging Face organization specified with the <code>--results-org</code>
option.`,Cs,_,As,$,Ta=`You can push results to Weights &amp; Biases by setting <code>--wandb</code>. This initializes a W&amp;B
run and logs the results.`,bs,B,Ja="W&B arguments need to be set in your environment variables:",qs,v,_s,E,ya='You can find a complete list of variables in the <a href="https://docs.wandb.ai/guides/track/environment-variables/" rel="nofollow">W&amp;B documentation</a>.',$s,Z,da=`If Trackio is available in your environment (<code>pip install lighteval[trackio]</code>), it will be used to log and push results to a
Hugging Face dataset. Choose the dataset name and organization with:`,Bs,k,vs,Q,Es,N,Zs,W,ks,z,Qs,G,Ns,X,Ws,R,ma="The detail file contains the following columns:",zs,F,Ua="<li><strong><code>__doc__</code></strong>: The document used for evaluation, containing the gold reference, few-shot examples, and other hyperparameters used for the task.</li> <li><strong><code>__model_response__</code></strong>: Contains model generations, log probabilities, and the input that was sent to the model.</li> <li><strong><code>__metric__</code></strong>: The value of the metrics for this sample.</li>",Gs,V,Xs,Y,wa="The <code>EvaluationTracker</code> class provides several configuration options for customizing how results are saved and pushed:",Rs,x,Fs,H,Vs,S,Ys,L,xs,D,Hs,P,Ia="<li><strong><code>output_dir</code></strong>: Local directory to save evaluation results and logs</li> <li><strong><code>results_path_template</code></strong>: Template for results directory structure</li> <li><strong><code>save_details</code></strong>: Whether to save detailed evaluation records (default: True)</li> <li><strong><code>push_to_hub</code></strong>: Whether to push results to Hugging Face Hub (default: False)</li> <li><strong><code>push_to_tensorboard</code></strong>: Whether to push metrics to TensorBoard (default: False)</li> <li><strong><code>hub_results_org</code></strong>: Hugging Face Hub organization to push results to</li> <li><strong><code>tensorboard_metric_prefix</code></strong>: Prefix for TensorBoard metrics (default: “eval”)</li> <li><strong><code>public</code></strong>: Whether to make Hub datasets public (default: False)</li> <li><strong><code>use_wandb</code></strong>: Whether to log to Weights &amp; Biases or Trackio (default: False)</li>",Ss,O,Ls,K,ga="The main results file contains several sections:",Ds,ss,Ps,as,fa="<li><strong><code>config_general</code></strong>: Overall evaluation configuration including model information, timing, and system details</li> <li><strong><code>summary_general</code></strong>: General statistics about the evaluation run</li>",Os,ls,Ks,ts,Ca="<li><strong><code>config_tasks</code></strong>: Configuration details for each evaluated task</li> <li><strong><code>summary_tasks</code></strong>: Task-specific statistics and metadata</li> <li><strong><code>versions</code></strong>: Version information for tasks and datasets</li>",sa,ns,aa,ps,Aa="<li><strong><code>results</code></strong>: Actual evaluation metrics and scores for each task</li>",la,es,ta,us,na,is,pa,cs,ea;return y=new Qa({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new T({props:{title:"Saving and Reading Results",local:"saving-and-reading-results",headingTag:"h1"}}),U=new T({props:{title:"Saving Results Locally",local:"saving-results-locally",headingTag:"h2"}}),f=new T({props:{title:"Pushing Results to the Hugging Face Hub",local:"pushing-results-to-the-hugging-face-hub",headingTag:"h2"}}),b=new T({props:{title:"Pushing Results to TensorBoard",local:"pushing-results-to-tensorboard",headingTag:"h2"}}),_=new T({props:{title:"Pushing Results to Weights & Biases or Trackio",local:"pushing-results-to-weights--biases-or-trackio",headingTag:"h2"}}),v=new os({props:{code:"ZXhwb3J0JTIwV0FOREJfUFJPSkVDVCUzRCUyMmxpZ2h0ZXZhbCUyMg==",highlighted:'<span class="hljs-built_in">export</span> WANDB_PROJECT=<span class="hljs-string">&quot;lighteval&quot;</span>',wrap:!1}}),k=new os({props:{code:"ZXhwb3J0JTIwV0FOREJfU1BBQ0VfSUQlM0QlMjJvcmclMkZuYW1lJTIy",highlighted:'<span class="hljs-built_in">export</span> WANDB_SPACE_ID=<span class="hljs-string">&quot;org/name&quot;</span>',wrap:!1}}),Q=new T({props:{title:"How to Load and Investigate Details",local:"how-to-load-and-investigate-details",headingTag:"h2"}}),N=new T({props:{title:"Loading from Local Detail Files",local:"loading-from-local-detail-files",headingTag:"h3"}}),W=new os({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBnbG9iJTBBJTBBb3V0cHV0X2RpciUyMCUzRCUyMCUyMmV2YWxzX2RvYyUyMiUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0aW1lc3RhbXAlMjAlM0QlMjAlMjJsYXRlc3QlMjIlMEF0YXNrJTIwJTNEJTIwJTIyZ3NtOGslMjIlMEElMEFpZiUyMHRpbWVzdGFtcCUyMCUzRCUzRCUyMCUyMmxhdGVzdCUyMiUzQSUwQSUyMCUyMCUyMCUyMHBhdGglMjAlM0QlMjBmJTIyJTdCb3V0cHV0X2RpciU3RCUyRmRldGFpbHMlMkYlN0Jtb2RlbF9uYW1lJTdEJTJGKiUyRiUyMiUwQSUyMCUyMCUyMCUyMHRpbWVzdGFtcHMlMjAlM0QlMjBnbG9iLmdsb2IocGF0aCklMEElMjAlMjAlMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjBzb3J0ZWQodGltZXN0YW1wcyklNUItMSU1RC5zcGxpdCglMjIlMkYlMjIpJTVCLTIlNUQlMEElMjAlMjAlMjAlMjBwcmludChmJTIyTGF0ZXN0JTIwdGltZXN0YW1wJTNBJTIwJTdCdGltZXN0YW1wJTdEJTIyKSUwQSUwQWRldGFpbHNfcGF0aCUyMCUzRCUyMGYlMjIlN0JvdXRwdXRfZGlyJTdEJTJGZGV0YWlscyUyRiU3Qm1vZGVsX25hbWUlN0QlMkYlN0J0aW1lc3RhbXAlN0QlMkZkZXRhaWxzXyU3QnRhc2slN0RfJTdCdGltZXN0YW1wJTdELnBhcnF1ZXQlMjIlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwZGV0YWlscyUwQWRldGFpbHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIycGFycXVldCUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkZXRhaWxzX3BhdGglMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQWZvciUyMGRldGFpbCUyMGluJTIwZGV0YWlscyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRldGFpbCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> glob

output_dir = <span class="hljs-string">&quot;evals_doc&quot;</span>
model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
timestamp = <span class="hljs-string">&quot;latest&quot;</span>
task = <span class="hljs-string">&quot;gsm8k&quot;</span>

<span class="hljs-keyword">if</span> timestamp == <span class="hljs-string">&quot;latest&quot;</span>:
    path = <span class="hljs-string">f&quot;<span class="hljs-subst">{output_dir}</span>/details/<span class="hljs-subst">{model_name}</span>/*/&quot;</span>
    timestamps = glob.glob(path)
    timestamp = <span class="hljs-built_in">sorted</span>(timestamps)[-<span class="hljs-number">1</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">2</span>]
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Latest timestamp: <span class="hljs-subst">{timestamp}</span>&quot;</span>)

details_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{output_dir}</span>/details/<span class="hljs-subst">{model_name}</span>/<span class="hljs-subst">{timestamp}</span>/details_<span class="hljs-subst">{task}</span>_<span class="hljs-subst">{timestamp}</span>.parquet&quot;</span>

<span class="hljs-comment"># Load the details</span>
details = load_dataset(<span class="hljs-string">&quot;parquet&quot;</span>, data_files=details_path, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-keyword">for</span> detail <span class="hljs-keyword">in</span> details:
    <span class="hljs-built_in">print</span>(detail)`,wrap:!1}}),z=new T({props:{title:"Loading from the Hugging Face Hub",local:"loading-from-the-hugging-face-hub",headingTag:"h3"}}),G=new os({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcmVzdWx0c19vcmclMjAlM0QlMjAlMjJTYXlsb3JUd2lmdCUyMiUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEFzYW5pdGl6ZWRfbW9kZWxfbmFtZSUyMCUzRCUyMG1vZGVsX25hbWUucmVwbGFjZSglMjIlMkYlMjIlMkMlMjAlMjJfXyUyMiklMEF0YXNrJTIwJTNEJTIwJTIyZ3NtOGslMjIlMEFwdWJsaWNfcnVuJTIwJTNEJTIwRmFsc2UlMEElMEFkYXRhc2V0X3BhdGglMjAlM0QlMjBmJTIyJTdCcmVzdWx0c19vcmclN0QlMkZkZXRhaWxzXyU3QnNhbml0aXplZF9tb2RlbF9uYW1lJTdEJTdCJ19wcml2YXRlJyUyMGlmJTIwbm90JTIwcHVibGljX3J1biUyMGVsc2UlMjAnJyU3RCUyMiUwQWRldGFpbHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9wYXRoJTJDJTIwdGFzay5yZXBsYWNlKCUyMiU3QyUyMiUyQyUyMCUyMl8lMjIpJTJDJTIwc3BsaXQlM0QlMjJsYXRlc3QlMjIpJTBBJTBBZm9yJTIwZGV0YWlsJTIwaW4lMjBkZXRhaWxzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZGV0YWlsKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

results_org = <span class="hljs-string">&quot;SaylorTwift&quot;</span>
model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
sanitized_model_name = model_name.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;__&quot;</span>)
task = <span class="hljs-string">&quot;gsm8k&quot;</span>
public_run = <span class="hljs-literal">False</span>

dataset_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{results_org}</span>/details_<span class="hljs-subst">{sanitized_model_name}</span><span class="hljs-subst">{<span class="hljs-string">&#x27;_private&#x27;</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> public_run <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;&#x27;</span>}</span>&quot;</span>
details = load_dataset(dataset_path, task.replace(<span class="hljs-string">&quot;|&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>), split=<span class="hljs-string">&quot;latest&quot;</span>)

<span class="hljs-keyword">for</span> detail <span class="hljs-keyword">in</span> details:
    <span class="hljs-built_in">print</span>(detail)`,wrap:!1}}),X=new T({props:{title:"Detail File Structure",local:"detail-file-structure",headingTag:"h2"}}),V=new T({props:{title:"EvaluationTracker Configuration",local:"evaluationtracker-configuration",headingTag:"h2"}}),x=new T({props:{title:"Basic Configuration",local:"basic-configuration",headingTag:"h3"}}),H=new os({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC5sb2dnaW5nLmV2YWx1YXRpb25fdHJhY2tlciUyMGltcG9ydCUyMEV2YWx1YXRpb25UcmFja2VyJTBBJTBBdHJhY2tlciUyMCUzRCUyMEV2YWx1YXRpb25UcmFja2VyKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGcmVzdWx0cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfZGV0YWlscyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBodWJfcmVzdWx0c19vcmclM0QlMjJ5b3VyX3VzZXJuYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwcHVibGljJTNERmFsc2UlMEEp",highlighted:`<span class="hljs-keyword">from</span> lighteval.logging.evaluation_tracker <span class="hljs-keyword">import</span> EvaluationTracker

tracker = EvaluationTracker(
    output_dir=<span class="hljs-string">&quot;./results&quot;</span>,
    save_details=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    hub_results_org=<span class="hljs-string">&quot;your_username&quot;</span>,
    public=<span class="hljs-literal">False</span>
)`,wrap:!1}}),S=new T({props:{title:"Advanced Configuration",local:"advanced-configuration",headingTag:"h3"}}),L=new os({props:{code:"dHJhY2tlciUyMCUzRCUyMEV2YWx1YXRpb25UcmFja2VyKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGcmVzdWx0cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlc3VsdHNfcGF0aF90ZW1wbGF0ZSUzRCUyMiU3Qm91dHB1dF9kaXIlN0QlMkZjdXN0b20lMkYlN0JvcmclN0RfJTdCbW9kZWwlN0QlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX2RldGFpbHMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b190ZW5zb3Jib2FyZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBodWJfcmVzdWx0c19vcmclM0QlMjJteS1vcmclMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW5zb3Jib2FyZF9tZXRyaWNfcHJlZml4JTNEJTIyZXZhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHB1YmxpYyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB1c2Vfd2FuZGIlM0RUcnVlJTBBKQ==",highlighted:`tracker = EvaluationTracker(
    output_dir=<span class="hljs-string">&quot;./results&quot;</span>,
    results_path_template=<span class="hljs-string">&quot;{output_dir}/custom/{org}_{model}&quot;</span>,
    save_details=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    push_to_tensorboard=<span class="hljs-literal">True</span>,
    hub_results_org=<span class="hljs-string">&quot;my-org&quot;</span>,
    tensorboard_metric_prefix=<span class="hljs-string">&quot;eval&quot;</span>,
    public=<span class="hljs-literal">True</span>,
    use_wandb=<span class="hljs-literal">True</span>
)`,wrap:!1}}),D=new T({props:{title:"Key Parameters",local:"key-parameters",headingTag:"h3"}}),O=new T({props:{title:"Result File Structure",local:"result-file-structure",headingTag:"h2"}}),ss=new T({props:{title:"General Configuration",local:"general-configuration",headingTag:"h3"}}),ls=new T({props:{title:"Task-Specific Information",local:"task-specific-information",headingTag:"h3"}}),ns=new T({props:{title:"Results",local:"results",headingTag:"h3"}}),es=new T({props:{title:"Example of a Result File",local:"example-of-a-result-file",headingTag:"h2"}}),us=new os({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;config_general&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval_sha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;203045a8431bc9b77245c9998e05fc54509ea07f&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_fewshot_seeds&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;max_samples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;job_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;start_time&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">620979.879320166</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;end_time&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">621004.632108041</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;total_evaluation_time_secondes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;24.752787875011563&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gpt2&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_sha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;607a30d783dfa663caf39e06633721c8d4cfcd7e&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_dtype&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;476.2 MB&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;results&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;em&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;em_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;all&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;em&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;em_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;versions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;config_tasks&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;prompt_function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_repo&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_subset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;main&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;metric&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;metric_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;em&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;higher_is_better&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;category&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;3&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;use_case&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;sample_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;compute&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;corpus_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mean&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;metric_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;maj@8&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;higher_is_better&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;category&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;use_case&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;sample_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;compute&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;corpus_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mean&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_avail_splits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;train&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-string">&quot;test&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;evaluation_splits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;test&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;few_shots_split&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;few_shots_select&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;random_sampling_from_train&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;generation_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">256</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;generation_grammar&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;stop_sequence&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;Question=&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;num_samples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;original_num_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1319</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;effective_num_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;must_remove_duplicate_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;summary_tasks&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;hashes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;hash_examples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;8517d5bf7e880086&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_full_prompts&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;8517d5bf7e880086&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_input_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;29916e7afe5cb51d&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_cont_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;37f91ce23ef6d435&quot;</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;non_padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;effective_few_shots&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;summary_general&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;hashes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;hash_examples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5f383c395f01096e&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_full_prompts&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5f383c395f01096e&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_input_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;ac933feb14f96d7b&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_cont_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;9d03fb26f8da7277&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;non_padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),is=new Na({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/saving-and-reading-results.mdx"}}),{c(){J=j("meta"),js=n(),Ms=j("p"),hs=n(),e(y.$$.fragment),rs=n(),e(d.$$.fragment),Ts=n(),m=j("p"),m.innerHTML=ia,Js=n(),e(U.$$.fragment),ys=n(),w=j("p"),w.innerHTML=oa,ds=n(),I=j("p"),I.innerHTML=Ma,ms=n(),g=j("p"),g.innerHTML=ca,Us=n(),e(f.$$.fragment),ws=n(),C=j("p"),C.innerHTML=ja,Is=n(),A=j("p"),A.innerHTML=ha,gs=n(),e(b.$$.fragment),fs=n(),q=j("p"),q.innerHTML=ra,Cs=n(),e(_.$$.fragment),As=n(),$=j("p"),$.innerHTML=Ta,bs=n(),B=j("p"),B.textContent=Ja,qs=n(),e(v.$$.fragment),_s=n(),E=j("p"),E.innerHTML=ya,$s=n(),Z=j("p"),Z.innerHTML=da,Bs=n(),e(k.$$.fragment),vs=n(),e(Q.$$.fragment),Es=n(),e(N.$$.fragment),Zs=n(),e(W.$$.fragment),ks=n(),e(z.$$.fragment),Qs=n(),e(G.$$.fragment),Ns=n(),e(X.$$.fragment),Ws=n(),R=j("p"),R.textContent=ma,zs=n(),F=j("ul"),F.innerHTML=Ua,Gs=n(),e(V.$$.fragment),Xs=n(),Y=j("p"),Y.innerHTML=wa,Rs=n(),e(x.$$.fragment),Fs=n(),e(H.$$.fragment),Vs=n(),e(S.$$.fragment),Ys=n(),e(L.$$.fragment),xs=n(),e(D.$$.fragment),Hs=n(),P=j("ul"),P.innerHTML=Ia,Ss=n(),e(O.$$.fragment),Ls=n(),K=j("p"),K.textContent=ga,Ds=n(),e(ss.$$.fragment),Ps=n(),as=j("ul"),as.innerHTML=fa,Os=n(),e(ls.$$.fragment),Ks=n(),ts=j("ul"),ts.innerHTML=Ca,sa=n(),e(ns.$$.fragment),aa=n(),ps=j("ul"),ps.innerHTML=Aa,la=n(),e(es.$$.fragment),ta=n(),e(us.$$.fragment),na=n(),e(is.$$.fragment),pa=n(),cs=j("p"),this.h()},l(s){const a=Za("svelte-u9bgzb",document.head);J=h(a,"META",{name:!0,content:!0}),a.forEach(l),js=p(s),Ms=h(s,"P",{}),ba(Ms).forEach(l),hs=p(s),u(y.$$.fragment,s),rs=p(s),u(d.$$.fragment,s),Ts=p(s),m=h(s,"P",{"data-svelte-h":!0}),r(m)!=="svelte-9aqcbu"&&(m.innerHTML=ia),Js=p(s),u(U.$$.fragment,s),ys=p(s),w=h(s,"P",{"data-svelte-h":!0}),r(w)!=="svelte-nzo4lv"&&(w.innerHTML=oa),ds=p(s),I=h(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-103anxe"&&(I.innerHTML=Ma),ms=p(s),g=h(s,"P",{"data-svelte-h":!0}),r(g)!=="svelte-h64e6b"&&(g.innerHTML=ca),Us=p(s),u(f.$$.fragment,s),ws=p(s),C=h(s,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1cjd5zg"&&(C.innerHTML=ja),Is=p(s),A=h(s,"P",{"data-svelte-h":!0}),r(A)!=="svelte-icxxh7"&&(A.innerHTML=ha),gs=p(s),u(b.$$.fragment,s),fs=p(s),q=h(s,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1bci1gp"&&(q.innerHTML=ra),Cs=p(s),u(_.$$.fragment,s),As=p(s),$=h(s,"P",{"data-svelte-h":!0}),r($)!=="svelte-17ozben"&&($.innerHTML=Ta),bs=p(s),B=h(s,"P",{"data-svelte-h":!0}),r(B)!=="svelte-qmfp1v"&&(B.textContent=Ja),qs=p(s),u(v.$$.fragment,s),_s=p(s),E=h(s,"P",{"data-svelte-h":!0}),r(E)!=="svelte-407scl"&&(E.innerHTML=ya),$s=p(s),Z=h(s,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-174dmv1"&&(Z.innerHTML=da),Bs=p(s),u(k.$$.fragment,s),vs=p(s),u(Q.$$.fragment,s),Es=p(s),u(N.$$.fragment,s),Zs=p(s),u(W.$$.fragment,s),ks=p(s),u(z.$$.fragment,s),Qs=p(s),u(G.$$.fragment,s),Ns=p(s),u(X.$$.fragment,s),Ws=p(s),R=h(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1w33ibm"&&(R.textContent=ma),zs=p(s),F=h(s,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-1wz4paq"&&(F.innerHTML=Ua),Gs=p(s),u(V.$$.fragment,s),Xs=p(s),Y=h(s,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-vgm6ps"&&(Y.innerHTML=wa),Rs=p(s),u(x.$$.fragment,s),Fs=p(s),u(H.$$.fragment,s),Vs=p(s),u(S.$$.fragment,s),Ys=p(s),u(L.$$.fragment,s),xs=p(s),u(D.$$.fragment,s),Hs=p(s),P=h(s,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-n2g9hd"&&(P.innerHTML=Ia),Ss=p(s),u(O.$$.fragment,s),Ls=p(s),K=h(s,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1ieqcct"&&(K.textContent=ga),Ds=p(s),u(ss.$$.fragment,s),Ps=p(s),as=h(s,"UL",{"data-svelte-h":!0}),r(as)!=="svelte-r2q4i7"&&(as.innerHTML=fa),Os=p(s),u(ls.$$.fragment,s),Ks=p(s),ts=h(s,"UL",{"data-svelte-h":!0}),r(ts)!=="svelte-a95mdm"&&(ts.innerHTML=Ca),sa=p(s),u(ns.$$.fragment,s),aa=p(s),ps=h(s,"UL",{"data-svelte-h":!0}),r(ps)!=="svelte-1iqqkon"&&(ps.innerHTML=Aa),la=p(s),u(es.$$.fragment,s),ta=p(s),u(us.$$.fragment,s),na=p(s),u(is.$$.fragment,s),pa=p(s),cs=h(s,"P",{}),ba(cs).forEach(l),this.h()},h(){qa(J,"name","hf:doc:metadata"),qa(J,"content",za)},m(s,a){ka(document.head,J),t(s,js,a),t(s,Ms,a),t(s,hs,a),i(y,s,a),t(s,rs,a),i(d,s,a),t(s,Ts,a),t(s,m,a),t(s,Js,a),i(U,s,a),t(s,ys,a),t(s,w,a),t(s,ds,a),t(s,I,a),t(s,ms,a),t(s,g,a),t(s,Us,a),i(f,s,a),t(s,ws,a),t(s,C,a),t(s,Is,a),t(s,A,a),t(s,gs,a),i(b,s,a),t(s,fs,a),t(s,q,a),t(s,Cs,a),i(_,s,a),t(s,As,a),t(s,$,a),t(s,bs,a),t(s,B,a),t(s,qs,a),i(v,s,a),t(s,_s,a),t(s,E,a),t(s,$s,a),t(s,Z,a),t(s,Bs,a),i(k,s,a),t(s,vs,a),i(Q,s,a),t(s,Es,a),i(N,s,a),t(s,Zs,a),i(W,s,a),t(s,ks,a),i(z,s,a),t(s,Qs,a),i(G,s,a),t(s,Ns,a),i(X,s,a),t(s,Ws,a),t(s,R,a),t(s,zs,a),t(s,F,a),t(s,Gs,a),i(V,s,a),t(s,Xs,a),t(s,Y,a),t(s,Rs,a),i(x,s,a),t(s,Fs,a),i(H,s,a),t(s,Vs,a),i(S,s,a),t(s,Ys,a),i(L,s,a),t(s,xs,a),i(D,s,a),t(s,Hs,a),t(s,P,a),t(s,Ss,a),i(O,s,a),t(s,Ls,a),t(s,K,a),t(s,Ds,a),i(ss,s,a),t(s,Ps,a),t(s,as,a),t(s,Os,a),i(ls,s,a),t(s,Ks,a),t(s,ts,a),t(s,sa,a),i(ns,s,a),t(s,aa,a),t(s,ps,a),t(s,la,a),i(es,s,a),t(s,ta,a),i(us,s,a),t(s,na,a),i(is,s,a),t(s,pa,a),t(s,cs,a),ea=!0},p:$a,i(s){ea||(o(y.$$.fragment,s),o(d.$$.fragment,s),o(U.$$.fragment,s),o(f.$$.fragment,s),o(b.$$.fragment,s),o(_.$$.fragment,s),o(v.$$.fragment,s),o(k.$$.fragment,s),o(Q.$$.fragment,s),o(N.$$.fragment,s),o(W.$$.fragment,s),o(z.$$.fragment,s),o(G.$$.fragment,s),o(X.$$.fragment,s),o(V.$$.fragment,s),o(x.$$.fragment,s),o(H.$$.fragment,s),o(S.$$.fragment,s),o(L.$$.fragment,s),o(D.$$.fragment,s),o(O.$$.fragment,s),o(ss.$$.fragment,s),o(ls.$$.fragment,s),o(ns.$$.fragment,s),o(es.$$.fragment,s),o(us.$$.fragment,s),o(is.$$.fragment,s),ea=!0)},o(s){M(y.$$.fragment,s),M(d.$$.fragment,s),M(U.$$.fragment,s),M(f.$$.fragment,s),M(b.$$.fragment,s),M(_.$$.fragment,s),M(v.$$.fragment,s),M(k.$$.fragment,s),M(Q.$$.fragment,s),M(N.$$.fragment,s),M(W.$$.fragment,s),M(z.$$.fragment,s),M(G.$$.fragment,s),M(X.$$.fragment,s),M(V.$$.fragment,s),M(x.$$.fragment,s),M(H.$$.fragment,s),M(S.$$.fragment,s),M(L.$$.fragment,s),M(D.$$.fragment,s),M(O.$$.fragment,s),M(ss.$$.fragment,s),M(ls.$$.fragment,s),M(ns.$$.fragment,s),M(es.$$.fragment,s),M(us.$$.fragment,s),M(is.$$.fragment,s),ea=!1},d(s){s&&(l(js),l(Ms),l(hs),l(rs),l(Ts),l(m),l(Js),l(ys),l(w),l(ds),l(I),l(ms),l(g),l(Us),l(ws),l(C),l(Is),l(A),l(gs),l(fs),l(q),l(Cs),l(As),l($),l(bs),l(B),l(qs),l(_s),l(E),l($s),l(Z),l(Bs),l(vs),l(Es),l(Zs),l(ks),l(Qs),l(Ns),l(Ws),l(R),l(zs),l(F),l(Gs),l(Xs),l(Y),l(Rs),l(Fs),l(Vs),l(Ys),l(xs),l(Hs),l(P),l(Ss),l(Ls),l(K),l(Ds),l(Ps),l(as),l(Os),l(Ks),l(ts),l(sa),l(aa),l(ps),l(la),l(ta),l(na),l(pa),l(cs)),l(J),c(y,s),c(d,s),c(U,s),c(f,s),c(b,s),c(_,s),c(v,s),c(k,s),c(Q,s),c(N,s),c(W,s),c(z,s),c(G,s),c(X,s),c(V,s),c(x,s),c(H,s),c(S,s),c(L,s),c(D,s),c(O,s),c(ss,s),c(ls,s),c(ns,s),c(es,s),c(us,s),c(is,s)}}}const za='{"title":"Saving and Reading Results","local":"saving-and-reading-results","sections":[{"title":"Saving Results Locally","local":"saving-results-locally","sections":[],"depth":2},{"title":"Pushing Results to the Hugging Face Hub","local":"pushing-results-to-the-hugging-face-hub","sections":[],"depth":2},{"title":"Pushing Results to TensorBoard","local":"pushing-results-to-tensorboard","sections":[],"depth":2},{"title":"Pushing Results to Weights & Biases or Trackio","local":"pushing-results-to-weights--biases-or-trackio","sections":[],"depth":2},{"title":"How to Load and Investigate Details","local":"how-to-load-and-investigate-details","sections":[{"title":"Loading from Local Detail Files","local":"loading-from-local-detail-files","sections":[],"depth":3},{"title":"Loading from the Hugging Face Hub","local":"loading-from-the-hugging-face-hub","sections":[],"depth":3}],"depth":2},{"title":"Detail File Structure","local":"detail-file-structure","sections":[],"depth":2},{"title":"EvaluationTracker Configuration","local":"evaluationtracker-configuration","sections":[{"title":"Basic Configuration","local":"basic-configuration","sections":[],"depth":3},{"title":"Advanced Configuration","local":"advanced-configuration","sections":[],"depth":3},{"title":"Key Parameters","local":"key-parameters","sections":[],"depth":3}],"depth":2},{"title":"Result File Structure","local":"result-file-structure","sections":[{"title":"General Configuration","local":"general-configuration","sections":[],"depth":3},{"title":"Task-Specific Information","local":"task-specific-information","sections":[],"depth":3},{"title":"Results","local":"results","sections":[],"depth":3}],"depth":2},{"title":"Example of a Result File","local":"example-of-a-result-file","sections":[],"depth":2}],"depth":1}';function Ga(ua){return Ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ya extends va{constructor(J){super(),Ea(this,J,Ga,Wa,_a,{})}}export{Ya as component};
