import{S as nw,i as aw,s as iw,e as t,k as l,w as _,t as a,M as cw,c as s,d as r,m as d,a as n,x as P,h as i,b as c,N as lw,G as e,g as h,y as b,q as w,o as y,B as $,v as dw,L as xo}from"../../chunks/vendor-hf-doc-builder.js";import{T as Sr}from"../../chunks/Tip-hf-doc-builder.js";import{D as x}from"../../chunks/Docstring-hf-doc-builder.js";import{C as Eo}from"../../chunks/CodeBlock-hf-doc-builder.js";import{I as j}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{E as To}from"../../chunks/ExampleCodeBlock-hf-doc-builder.js";function pw(E){let u,T,v,g,k;return g=new Eo({props:{code:`from transformers import PerceiverModel, PerceiverConfig

# Initializing a Perceiver deepmind/language-perceiver style configuration
configuration = PerceiverConfig()

# Initializing a model from the deepmind/language-perceiver style configuration
model = PerceiverModel(configuration)

# Accessing the model configuration
configuration = model.config`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverModel, PerceiverConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Perceiver deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PerceiverConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){u=t("p"),T=a("Example:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Example:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:xo,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function mw(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function hw(E){let u,T,v,g,k;return g=new Eo({props:{code:`from transformers import PerceiverConfig, PerceiverTokenizer, PerceiverImageProcessor, PerceiverModel
from transformers.models.perceiver.modeling_perceiver import (
    PerceiverTextPreprocessor,
    PerceiverImagePreprocessor,
    PerceiverClassificationDecoder,
)
import torch
import requests
from PIL import Image

# EXAMPLE 1: using the Perceiver to classify texts
# - we define a TextPreprocessor, which can be used to embed tokens
# - we define a ClassificationDecoder, which can be used to decode the
# final hidden states of the latents to classification logits
# using trainable position embeddings
config = PerceiverConfig()
preprocessor = PerceiverTextPreprocessor(config)
decoder = PerceiverClassificationDecoder(
    config,
    num_channels=config.d_latents,
    trainable_position_encoding_kwargs=dict(num_channels=config.d_latents, index_dims=1),
    use_query_residual=True,
)
model = PerceiverModel(config, input_preprocessor=preprocessor, decoder=decoder)

# you can then do a forward pass as follows:
tokenizer = PerceiverTokenizer()
text = "hello world"
inputs = tokenizer(text, return_tensors="pt").input_ids

with torch.no_grad():
    outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# to train, one can train the model using standard cross-entropy:
criterion = torch.nn.CrossEntropyLoss()

labels = torch.tensor([1])
loss = criterion(logits, labels)

# EXAMPLE 2: using the Perceiver to classify images
# - we define an ImagePreprocessor, which can be used to embed images
config = PerceiverConfig(image_size=224)
preprocessor = PerceiverImagePreprocessor(
    config,
    prep_type="conv1x1",
    spatial_downsample=1,
    out_channels=256,
    position_encoding_type="trainable",
    concat_or_add_pos="concat",
    project_pos_dim=256,
    trainable_position_encoding_kwargs=dict(
        num_channels=256,
        index_dims=config.image_size**2,
    ),
)

model = PerceiverModel(
    config,
    input_preprocessor=preprocessor,
    decoder=PerceiverClassificationDecoder(
        config,
        num_channels=config.d_latents,
        trainable_position_encoding_kwargs=dict(num_channels=config.d_latents, index_dims=1),
        use_query_residual=True,
    ),
)

# you can then do a forward pass as follows:
image_processor = PerceiverImageProcessor()
url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)
inputs = image_processor(image, return_tensors="pt").pixel_values

with torch.no_grad():
    outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# to train, one can train the model using standard cross-entropy:
criterion = torch.nn.CrossEntropyLoss()

labels = torch.tensor([1])
loss = criterion(logits, labels)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverConfig, PerceiverTokenizer, PerceiverImageProcessor, PerceiverModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.models.perceiver.modeling_perceiver <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    PerceiverTextPreprocessor,
<span class="hljs-meta">... </span>    PerceiverImagePreprocessor,
<span class="hljs-meta">... </span>    PerceiverClassificationDecoder,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 1: using the Perceiver to classify texts</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a TextPreprocessor, which can be used to embed tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a ClassificationDecoder, which can be used to decode the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># final hidden states of the latents to classification logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># using trainable position embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverTextPreprocessor(config)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    num_channels=config.d_latents,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(config, input_preprocessor=preprocessor, decoder=decoder)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 2: using the Perceiver to classify images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define an ImagePreprocessor, which can be used to embed images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig(image_size=<span class="hljs-number">224</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverImagePreprocessor(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    prep_type=<span class="hljs-string">&quot;conv1x1&quot;</span>,
<span class="hljs-meta">... </span>    spatial_downsample=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    position_encoding_type=<span class="hljs-string">&quot;trainable&quot;</span>,
<span class="hljs-meta">... </span>    concat_or_add_pos=<span class="hljs-string">&quot;concat&quot;</span>,
<span class="hljs-meta">... </span>    project_pos_dim=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(
<span class="hljs-meta">... </span>        num_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>        index_dims=config.image_size**<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    input_preprocessor=preprocessor,
<span class="hljs-meta">... </span>    decoder=PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>        config,
<span class="hljs-meta">... </span>        num_channels=config.d_latents,
<span class="hljs-meta">... </span>        trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>        use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = PerceiverImageProcessor()
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:xo,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function uw(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function fw(E){let u,T,v,g,k;return g=new Eo({props:{code:`from transformers import AutoTokenizer, PerceiverForMaskedLM
import torch

tokenizer = AutoTokenizer.from_pretrained("deepmind/language-perceiver")
model = PerceiverForMaskedLM.from_pretrained("deepmind/language-perceiver")

# training
text = "This is an incomplete sentence where some words are missing."
inputs = tokenizer(text, padding="max_length", return_tensors="pt")
# mask " missing."
inputs["input_ids"][0, 52:61] = tokenizer.mask_token_id
labels = tokenizer(text, padding="max_length", return_tensors="pt").input_ids

outputs = model(**inputs, labels=labels)
loss = outputs.loss
round(loss.item(), 2)

logits = outputs.logits
list(logits.shape)

# inference
text = "This is an incomplete sentence where some words are missing."
encoding = tokenizer(text, padding="max_length", return_tensors="pt")

# mask bytes corresponding to " missing.". Note that the model performs much better if the masked span starts with a space.
encoding["input_ids"][0, 52:61] = tokenizer.mask_token_id

# forward pass
with torch.no_grad():
    outputs = model(**encoding)
logits = outputs.logits
list(logits.shape)

masked_tokens_predictions = logits[0, 52:61].argmax(dim=-1).tolist()
tokenizer.decode(masked_tokens_predictions)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PerceiverForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMaskedLM.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask &quot; missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">19.87</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">262</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask bytes corresponding to &quot; missing.&quot;. Note that the model performs much better if the masked span starts with a space.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">262</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>masked_tokens_predictions = logits[<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>].argmax(dim=-<span class="hljs-number">1</span>).tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(masked_tokens_predictions)
<span class="hljs-string">&#x27; missing.&#x27;</span>`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:xo,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function gw(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function vw(E){let u,T,v,g,k;return g=new Eo({props:{code:`from transformers import AutoTokenizer, PerceiverForSequenceClassification

tokenizer = AutoTokenizer.from_pretrained("deepmind/language-perceiver")
model = PerceiverForSequenceClassification.from_pretrained("deepmind/language-perceiver")

text = "hello world"
inputs = tokenizer(text, return_tensors="pt").input_ids
outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PerceiverForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:xo,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function _w(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function Pw(E){let u,T,v,g,k;return g=new Eo({props:{code:`from transformers import AutoImageProcessor, PerceiverForImageClassificationLearned
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

image_processor = AutoImageProcessor.from_pretrained("deepmind/vision-perceiver-learned")
model = PerceiverForImageClassificationLearned.from_pretrained("deepmind/vision-perceiver-learned")

inputs = image_processor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationLearned
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationLearned.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:xo,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function bw(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function ww(E){let u,T,v,g,k;return g=new Eo({props:{code:`from transformers import AutoImageProcessor, PerceiverForImageClassificationFourier
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

image_processor = AutoImageProcessor.from_pretrained("deepmind/vision-perceiver-fourier")
model = PerceiverForImageClassificationFourier.from_pretrained("deepmind/vision-perceiver-fourier")

inputs = image_processor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationFourier
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationFourier.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:xo,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function yw(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function $w(E){let u,T,v,g,k;return g=new Eo({props:{code:`from transformers import AutoImageProcessor, PerceiverForImageClassificationConvProcessing
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

image_processor = AutoImageProcessor.from_pretrained("deepmind/vision-perceiver-conv")
model = PerceiverForImageClassificationConvProcessing.from_pretrained("deepmind/vision-perceiver-conv")

inputs = image_processor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationConvProcessing
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationConvProcessing.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:xo,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function kw(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function Tw(E){let u,T,v,g,k;return g=new Eo({props:{code:`from transformers import PerceiverForOpticalFlow
import torch

model = PerceiverForOpticalFlow.from_pretrained("deepmind/optical-flow-perceiver")

# in the Perceiver IO paper, the authors extract a 3 x 3 patch around each pixel,
# leading to 3 x 3 x 3 = 27 values for each pixel (as each pixel also has 3 color channels)
# patches have shape (batch_size, num_frames, num_channels, height, width)
# the authors train on resolutions of 368 x 496
patches = torch.randn(1, 2, 27, 368, 496)
outputs = model(inputs=patches)
logits = outputs.logits
list(logits.shape)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForOpticalFlow
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForOpticalFlow.from_pretrained(<span class="hljs-string">&quot;deepmind/optical-flow-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, the authors extract a 3 x 3 patch around each pixel,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># leading to 3 x 3 x 3 = 27 values for each pixel (as each pixel also has 3 color channels)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># patches have shape (batch_size, num_frames, num_channels, height, width)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the authors train on resolutions of 368 x 496</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>patches = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">27</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=patches)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>, <span class="hljs-number">2</span>]`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:xo,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function xw(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function Ew(E){let u,T,v,g,k;return g=new Eo({props:{code:`from transformers import PerceiverForMultimodalAutoencoding
import torch
import numpy as np

# create multimodal inputs
images = torch.randn((1, 16, 3, 224, 224))
audio = torch.randn((1, 30720, 1))
inputs = dict(image=images, audio=audio, label=torch.zeros((images.shape[0], 700)))

model = PerceiverForMultimodalAutoencoding.from_pretrained("deepmind/multimodal-perceiver")

# in the Perceiver IO paper, videos are auto-encoded in chunks
# each chunk subsamples different index dimensions of the image and audio modality decoder queries
nchunks = 128
image_chunk_size = np.prod((16, 224, 224)) // nchunks
audio_chunk_size = audio.shape[1] // model.config.samples_per_patch // nchunks
# process the first chunk
chunk_idx = 0
subsampling = {
    "image": torch.arange(image_chunk_size * chunk_idx, image_chunk_size * (chunk_idx + 1)),
    "audio": torch.arange(audio_chunk_size * chunk_idx, audio_chunk_size * (chunk_idx + 1)),
    "label": None,
}

outputs = model(inputs=inputs, subsampled_output_points=subsampling)
logits = outputs.logits
list(logits["audio"].shape)

list(logits["image"].shape)

list(logits["label"].shape)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForMultimodalAutoencoding
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create multimodal inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">16</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">30720</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(image=images, audio=audio, label=torch.zeros((images.shape[<span class="hljs-number">0</span>], <span class="hljs-number">700</span>)))

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMultimodalAutoencoding.from_pretrained(<span class="hljs-string">&quot;deepmind/multimodal-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, videos are auto-encoded in chunks</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># each chunk subsamples different index dimensions of the image and audio modality decoder queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>nchunks = <span class="hljs-number">128</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_chunk_size = np.prod((<span class="hljs-number">16</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)) // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_chunk_size = audio.shape[<span class="hljs-number">1</span>] // model.config.samples_per_patch // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># process the first chunk</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chunk_idx = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>subsampling = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;image&quot;</span>: torch.arange(image_chunk_size * chunk_idx, image_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;audio&quot;</span>: torch.arange(audio_chunk_size * chunk_idx, audio_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs, subsampled_output_points=subsampling)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;audio&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">240</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;image&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">6272</span>, <span class="hljs-number">3</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;label&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">700</span>]`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:xo,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function jw(E){let u,T,v,g,k,p,f,C,Ep,Rc,$e,jo,ia,Br,jp,ca,Cp,Uc,Co,Fp,Wr,Ip,Mp,Kc,Fo,qp,Hr,zp,Ap,Gc,Us,Dp,Jc,Ks,la,Op,Xc,Gs,Np,Zc,Js,Lp,Yc,D,Sp,Xs,Bp,Wp,da,Hp,Vp,pa,Rp,Up,ma,Kp,Gp,ha,Jp,Xp,Qc,Zs,Zp,el,I,Yp,ua,Qp,em,fa,om,rm,ga,tm,sm,va,nm,am,_a,im,cm,Pa,lm,dm,ol,Io,aP,rl,Vr,pm,Ys,mm,tl,ve,hm,Rr,um,fm,Ur,gm,vm,sl,Qs,_m,nl,Mo,Kr,Pm,Gr,bm,wm,ym,Jr,$m,Xr,km,Tm,al,Zr,ba,xm,Em,il,en,_e,jm,wa,Cm,Fm,ya,Im,Mm,Yr,qm,cl,ke,qo,$a,Qr,zm,ka,Am,ll,Pe,Ta,on,Dm,Om,xa,rn,Nm,Lm,Ea,tn,Sm,dl,Te,zo,ja,et,Bm,Ca,Wm,pl,xe,ot,Hm,Fa,Vm,ml,Ee,rt,Rm,Ia,Um,hl,je,tt,Km,Ma,Gm,ul,Ce,st,Jm,qa,Xm,fl,Fe,Ao,za,nt,Zm,Aa,Ym,gl,H,at,Qm,Ie,eh,sn,oh,rh,it,th,sh,nh,Me,ah,nn,ih,ch,an,lh,dh,ph,Do,vl,qe,Oo,Da,ct,mh,Oa,hh,_l,V,lt,uh,Na,fh,gh,dt,vh,cn,_h,Ph,bh,No,pt,wh,La,yh,Pl,ze,Lo,Sa,mt,$h,Ba,kh,bl,Ae,ht,Th,So,ut,xh,Wa,Eh,wl,De,Bo,Ha,ft,jh,Va,Ch,yl,ne,gt,Fh,Ra,Ih,Mh,Wo,vt,qh,Ua,zh,$l,Oe,Ho,Ka,_t,Ah,Ga,Dh,kl,ae,Pt,Oh,bt,Nh,Ja,Lh,Sh,Bh,wt,Wh,Xa,Hh,Vh,Tl,Ne,Vo,Za,yt,Rh,Ya,Uh,xl,ie,$t,Kh,Qa,Gh,Jh,R,Xh,ei,Zh,Yh,oi,Qh,eu,ri,ou,ru,ti,tu,su,El,Le,Ro,si,kt,nu,ni,au,jl,Se,Tt,iu,ai,cu,Cl,Be,Uo,ii,xt,lu,ci,du,Fl,We,Et,pu,li,mu,Il,He,Ko,di,jt,hu,pi,uu,Ml,ce,Ct,fu,mi,gu,vu,hi,_u,ql,Ve,Go,ui,Ft,Pu,fi,bu,zl,Re,It,wu,gi,yu,Al,Ue,Jo,vi,Mt,$u,_i,ku,Dl,le,qt,Tu,Pi,xu,Eu,bi,ju,Ol,Ke,Xo,wi,zt,Cu,yi,Fu,Nl,Ge,At,Iu,Dt,Mu,$i,qu,zu,Ll,Je,Zo,ki,Ot,Au,Ti,Du,Sl,Xe,Nt,Ou,xi,Nu,Bl,Ze,Yo,Ei,Lt,Lu,ji,Su,Wl,Ye,St,Bu,Bt,Wu,Ci,Hu,Vu,Hl,Qe,Qo,Fi,Wt,Ru,Ii,Uu,Vl,de,Ht,Ku,Vt,Gu,Mi,Ju,Xu,Zu,qi,Yu,Rl,eo,er,zi,Rt,Qu,Ai,ef,Ul,oo,Ut,of,Di,rf,Kl,ro,or,Oi,Kt,tf,Ni,sf,Gl,to,Gt,nf,Li,af,Jl,so,rr,Si,Jt,cf,Bi,lf,Xl,no,Xt,df,Wi,pf,Zl,ao,tr,Hi,Zt,mf,Vi,hf,Yl,io,Yt,uf,Ri,ff,Ql,co,sr,Ui,Qt,gf,Ki,vf,ed,pe,es,_f,os,Pf,rs,bf,wf,yf,U,ts,$f,lo,kf,ln,Tf,xf,Gi,Ef,jf,Cf,nr,Ff,ar,od,po,ir,Ji,ss,If,Xi,Mf,rd,me,ns,qf,as,zf,is,Af,Df,Of,K,cs,Nf,mo,Lf,dn,Sf,Bf,Zi,Wf,Hf,Vf,cr,Rf,lr,td,ho,dr,Yi,ls,Uf,Qi,Kf,sd,he,ds,Gf,ps,Jf,ms,Xf,Zf,Yf,G,hs,Qf,uo,eg,pn,og,rg,ec,tg,sg,ng,pr,ag,mr,nd,fo,hr,oc,us,ig,rc,cg,ad,q,fs,lg,tc,dg,pg,sc,mg,hg,L,mn,ug,fg,hn,gg,vg,nc,_g,Pg,un,bg,wg,fn,yg,$g,kg,gs,Tg,vs,xg,Eg,jg,J,_s,Cg,go,Fg,gn,Ig,Mg,ac,qg,zg,Ag,ur,Dg,fr,id,vo,gr,ic,Ps,Og,cc,Ng,cd,z,bs,Lg,lc,Sg,Bg,dc,Wg,Hg,S,vn,Vg,Rg,_n,Ug,Kg,pc,Gg,Jg,Pn,Xg,Zg,bn,Yg,Qg,ev,ws,ov,ys,rv,tv,sv,X,$s,nv,_o,av,wn,iv,cv,mc,lv,dv,pv,vr,mv,_r,ld,Po,Pr,hc,ks,hv,uc,uv,dd,A,Ts,fv,fc,gv,vv,gc,_v,Pv,B,yn,bv,wv,$n,yv,$v,vc,kv,Tv,kn,xv,Ev,Tn,jv,Cv,Fv,xs,Iv,Es,Mv,qv,zv,Z,js,Av,bo,Dv,xn,Ov,Nv,_c,Lv,Sv,Bv,br,Wv,wr,pd,wo,yr,Pc,Cs,Hv,bc,Vv,md,O,Fs,Rv,N,Uv,En,Kv,Gv,jn,Jv,Xv,wc,Zv,Yv,Cn,Qv,e_,Fn,o_,r_,t_,yc,s_,n_,Is,a_,Ms,i_,c_,l_,Y,qs,d_,yo,p_,In,m_,h_,$c,u_,f_,g_,$r,v_,kr,hd,$o,Tr,kc,zs,__,Tc,P_,ud,F,As,b_,xc,w_,y_,xr,Mn,$_,k_,qn,T_,x_,E_,be,zn,j_,C_,An,F_,I_,Dn,M_,q_,z_,Er,On,A_,D_,Nn,O_,N_,L_,Ds,S_,Ec,B_,W_,H_,jc,V_,R_,Os,U_,Ns,K_,G_,J_,Q,Ls,X_,ko,Z_,Ln,Y_,Q_,Cc,eP,oP,rP,jr,tP,Cr,fd;return p=new j({}),Br=new j({}),Qr=new j({}),et=new j({}),ot=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"last_hidden_state",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L61"}}),rt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Output of the basic decoder.`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L92"}}),tt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L110"}}),st=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L141"}}),nt=new j({}),at=new x({props:{name:"class transformers.PerceiverConfig",anchor:"transformers.PerceiverConfig",parameters:[{name:"num_latents",val:" = 256"},{name:"d_latents",val:" = 1280"},{name:"d_model",val:" = 768"},{name:"num_blocks",val:" = 1"},{name:"num_self_attends_per_block",val:" = 26"},{name:"num_self_attention_heads",val:" = 8"},{name:"num_cross_attention_heads",val:" = 8"},{name:"qk_channels",val:" = None"},{name:"v_channels",val:" = None"},{name:"cross_attention_shape_for_attention",val:" = 'kv'"},{name:"self_attention_widening_factor",val:" = 1"},{name:"cross_attention_widening_factor",val:" = 1"},{name:"hidden_act",val:" = 'gelu'"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"use_query_residual",val:" = True"},{name:"vocab_size",val:" = 262"},{name:"max_position_embeddings",val:" = 2048"},{name:"image_size",val:" = 56"},{name:"train_size",val:" = [368, 496]"},{name:"num_frames",val:" = 16"},{name:"audio_samples_per_frame",val:" = 1920"},{name:"samples_per_patch",val:" = 16"},{name:"output_shape",val:" = [1, 16, 224, 224]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverConfig.num_latents",description:`<strong>num_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of latents.`,name:"num_latents"},{anchor:"transformers.PerceiverConfig.d_latents",description:`<strong>d_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
Dimension of the latent embeddings.`,name:"d_latents"},{anchor:"transformers.PerceiverConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the inputs. Should only be provided in case [<em>PerceiverTextPreprocessor</em>] is used or no
preprocessor is provided.`,name:"d_model"},{anchor:"transformers.PerceiverConfig.num_blocks",description:`<strong>num_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of blocks in the Transformer encoder.`,name:"num_blocks"},{anchor:"transformers.PerceiverConfig.num_self_attends_per_block",description:`<strong>num_self_attends_per_block</strong> (<code>int</code>, <em>optional</em>, defaults to 26) &#x2014;
The number of self-attention layers per block.`,name:"num_self_attends_per_block"},{anchor:"transformers.PerceiverConfig.num_self_attention_heads",description:`<strong>num_self_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each self-attention layer in the Transformer encoder.`,name:"num_self_attention_heads"},{anchor:"transformers.PerceiverConfig.num_cross_attention_heads",description:`<strong>num_cross_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each cross-attention layer in the Transformer encoder.`,name:"num_cross_attention_heads"},{anchor:"transformers.PerceiverConfig.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the queries + keys before applying attention in the cross-attention and self-attention
layers of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"qk_channels"},{anchor:"transformers.PerceiverConfig.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the values before applying attention in the cross-attention and self-attention layers
of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"v_channels"},{anchor:"transformers.PerceiverConfig.cross_attention_shape_for_attention",description:`<strong>cross_attention_shape_for_attention</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&apos;kv&apos;</code>) &#x2014;
Dimension to use when downsampling the queries and keys in the cross-attention layer of the encoder.`,name:"cross_attention_shape_for_attention"},{anchor:"transformers.PerceiverConfig.self_attention_widening_factor",description:`<strong>self_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the cross-attention layer of the Transformer encoder.`,name:"self_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.cross_attention_widening_factor",description:`<strong>cross_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the self-attention layers of the Transformer encoder.`,name:"cross_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.PerceiverConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.PerceiverConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PerceiverConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.PerceiverConfig.use_query_residual",description:`<strong>use_query_residual</strong> (<code>float</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a query residual in the cross-attention layer of the encoder.`,name:"use_query_residual"},{anchor:"transformers.PerceiverConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 262) &#x2014;
Vocabulary size for the masked language modeling model.`,name:"vocab_size"},{anchor:"transformers.PerceiverConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that the masked language modeling model might ever be used with. Typically set
this to something large just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.PerceiverConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 56) &#x2014;
Size of the images after preprocessing, for <a href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a>.`,name:"image_size"},{anchor:"transformers.PerceiverConfig.train_size",description:`<strong>train_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to [368, 496]) &#x2014;
Training size of the images for the optical flow model.`,name:"train_size"},{anchor:"transformers.PerceiverConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of video frames used for the multimodal autoencoding model.`,name:"num_frames"},{anchor:"transformers.PerceiverConfig.audio_samples_per_frame",description:`<strong>audio_samples_per_frame</strong> (<code>int</code>, <em>optional</em>, defaults to 1920) &#x2014;
Number of audio samples per frame for the multimodal autoencoding model.`,name:"audio_samples_per_frame"},{anchor:"transformers.PerceiverConfig.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of audio samples per patch when preprocessing the audio for the multimodal autoencoding model.`,name:"samples_per_patch"},{anchor:"transformers.PerceiverConfig.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 16, 224, 224]</code>) &#x2014;
Shape of the output (batch_size, num_frames, height, width) for the video decoder queries of the multimodal
autoencoding model. This excludes the channel dimension.`,name:"output_shape"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/configuration_perceiver.py#L36"}}),Do=new To({props:{anchor:"transformers.PerceiverConfig.example",$$slots:{default:[pw]},$$scope:{ctx:E}}}),ct=new j({}),lt=new x({props:{name:"class transformers.PerceiverTokenizer",anchor:"transformers.PerceiverTokenizer",parameters:[{name:"pad_token",val:" = '[PAD]'"},{name:"bos_token",val:" = '[BOS]'"},{name:"eos_token",val:" = '[EOS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"model_max_length",val:" = 2048"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.PerceiverTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[BOS]&quot;</code>) &#x2014;
The BOS token (reserved in the vocab, but not actually used).`,name:"bos_token"},{anchor:"transformers.PerceiverTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[EOS]&quot;</code>) &#x2014;
The end of sequence token (reserved in the vocab, but not actually used).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.PerceiverTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The MASK token, useful for masked language modeling.`,name:"mask_token"},{anchor:"transformers.PerceiverTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The CLS token (reserved in the vocab, but not actually used).`,name:"cls_token"},{anchor:"transformers.PerceiverTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from two sequences.`,name:"sep_token"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/tokenization_perceiver.py#L27"}}),pt=new x({props:{name:"__call__",anchor:"transformers.PerceiverTokenizer.__call__",parameters:[{name:"text",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]]] = None"},{name:"text_pair",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"text_target",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]]] = None"},{name:"text_pair_target",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.tokenization_utils_base.TruncationStrategy] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"stride",val:": int = 0"},{name:"is_split_into_words",val:": bool = False"},{name:"pad_to_multiple_of",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"return_token_type_ids",val:": typing.Optional[bool] = None"},{name:"return_attention_mask",val:": typing.Optional[bool] = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair",description:`<strong>text_pair</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair"},{anchor:"transformers.PerceiverTokenizer.__call__.text_target",description:`<strong>text_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_target"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair_target",description:`<strong>text_pair_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair_target"},{anchor:"transformers.PerceiverTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to encode the sequences with the special tokens relative to their model.`,name:"add_special_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.29.1/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.PerceiverTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.29.1/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.PerceiverTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.PerceiverTokenizer.__call__.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.PerceiverTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.PerceiverTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.PerceiverTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.29.1/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverTokenizer.__call__.return_token_type_ids",description:`<strong>return_token_type_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return token type IDs. If left to the default, will return the token type IDs according to
the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"return_token_type_ids"},{anchor:"transformers.PerceiverTokenizer.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"return_attention_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_overflowing_tokens",description:`<strong>return_overflowing_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return overflowing token sequences. If a pair of sequences of input ids (or a batch
of pairs) is provided with <code>truncation_strategy = longest_first</code> or <code>True</code>, an error is raised instead
of returning overflowing tokens.`,name:"return_overflowing_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.return_special_tokens_mask",description:`<strong>return_special_tokens_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return special tokens mask information.`,name:"return_special_tokens_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_offsets_mapping",description:`<strong>return_offsets_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return <code>(char_start, char_end)</code> for each token.</p>
<p>This is only available on fast tokenizers inheriting from <a href="/docs/transformers/v4.29.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a>, if using
Python&#x2019;s tokenizer, this method will raise <code>NotImplementedError</code>.`,name:"return_offsets_mapping"},{anchor:"transformers.PerceiverTokenizer.__call__.return_length",description:`<strong>return_length</strong>  (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the lengths of the encoded inputs.`,name:"return_length"},{anchor:"transformers.PerceiverTokenizer.__call__.verbose",description:`<strong>verbose</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to print more information and warnings.
**kwargs &#x2014; passed to the <code>self.tokenize()</code> method`,name:"verbose"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/tokenization_utils_base.py#L2474",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.29.1/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a> with the following fields:</p>
<ul>
<li>
<p><strong>input_ids</strong> \u2014 List of token ids to be fed to a model.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
</li>
<li>
<p><strong>token_type_ids</strong> \u2014 List of token type ids to be fed to a model (when <code>return_token_type_ids=True</code> or
if <em>\u201Ctoken_type_ids\u201D</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a></p>
</li>
<li>
<p><strong>attention_mask</strong> \u2014 List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>\u201Cattention_mask\u201D</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
</li>
<li>
<p><strong>overflowing_tokens</strong> \u2014 List of overflowing tokens sequences (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>num_truncated_tokens</strong> \u2014 Number of tokens truncated (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>special_tokens_mask</strong> \u2014 List of 0s and 1s, with 1 specifying added special tokens and 0 specifying
regular sequence tokens (when <code>add_special_tokens=True</code> and <code>return_special_tokens_mask=True</code>).</p>
</li>
<li>
<p><strong>length</strong> \u2014 The length of the inputs (when <code>return_length=True</code>)</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),mt=new j({}),ht=new x({props:{name:"class transformers.PerceiverFeatureExtractor",anchor:"transformers.PerceiverFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/feature_extraction_perceiver.py#L26"}}),ut=new x({props:{name:"__call__",anchor:"transformers.PerceiverFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/image_processing_utils.py#L462"}}),ft=new j({}),gt=new x({props:{name:"class transformers.PerceiverImageProcessor",anchor:"transformers.PerceiverImageProcessor",parameters:[{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>True</code>) &#x2014;
Whether or not to center crop the image. If the input size if smaller than <code>crop_size</code> along any edge, the
image will be padded with zeros and then center cropped. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Desired output size when applying center-cropping. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image to <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by the <code>do_resize</code>
parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.PerceiverImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Defines the resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter
in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.
do_normalize &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/image_processing_perceiver.py#L44"}}),vt=new x({props:{name:"preprocess",anchor:"transformers.PerceiverImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[transformers.utils.generic.TensorType, str, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess.`,name:"images"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to <code>crop_size</code>.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Desired output size after applying the center crop.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.PerceiverImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.PerceiverImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.PerceiverImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/image_processing_perceiver.py#L220"}}),_t=new j({}),Pt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L2846"}}),yt=new j({}),$t=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:" = 'conv'"},{name:"spatial_downsample",val:": int = 4"},{name:"temporal_downsample",val:": int = 1"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 64"},{name:"conv_after_patching",val:": bool = False"},{name:"conv_after_patching_in_channels",val:": int = 54"},{name:"conv2d_use_batchnorm",val:": bool = True"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"project_pos_dim",val:": int = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;conv&quot;</code>) &#x2014;
Preprocessing type. Can be &#x201C;conv1x1&#x201D;, &#x201C;conv&#x201D;, &#x201C;patches&#x201D;, &#x201C;pixels&#x201D;.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.spatial_downsample",description:`<strong>spatial_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Spatial downsampling factor.`,name:"spatial_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.temporal_downsample",description:`<strong>temporal_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Temporal downsampling factor (only relevant in case a time dimension is present).`,name:"temporal_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Position encoding type. Can be &#x201C;fourier&#x201D; or &#x201C;trainable&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching",description:`<strong>conv_after_patching</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply a convolutional layer after patching.`,name:"conv_after_patching"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching_in_channels",description:`<strong>conv_after_patching_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 54) &#x2014;
Number of channels in the input of the convolutional layer after patching.`,name:"conv_after_patching_in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv2d_use_batchnorm",description:`<strong>conv2d_use_batchnorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use batch normalization in the convolutional layer.`,name:"conv2d_use_batchnorm"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L3003"}}),kt=new j({}),Tt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L3232"}}),xt=new j({}),Et=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:": str = 'patches'"},{name:"samples_per_patch",val:": int = 96"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"out_channels",val:" = 64"},{name:"project_pos_dim",val:" = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Preprocessor type to use. Only &#x201C;patches&#x201D; is supported.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Number of samples per patch.`,name:"samples_per_patch"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Type of position encoding to use. Can be &#x201C;trainable&#x201D; or &#x201C;fourier&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L3258"}}),jt=new j({}),Ct=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",parameters:[{name:"modalities",val:": typing.Mapping[str, typing.Callable[..., typing.Tuple[torch.Tensor, typing.Optional[torch.Tensor], torch.Tensor]]]"},{name:"mask_probs",val:": typing.Union[typing.Mapping[str, float], NoneType] = None"},{name:"min_padding_size",val:": int = 2"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.modalities",description:`<strong>modalities</strong> (<code>Mapping[str, PreprocessorType]</code>) &#x2014;
Dict mapping modality name to preprocessor.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.mask_probs",description:`<strong>mask_probs</strong> (<code>Dict[str, float]</code>) &#x2014;
Dict mapping modality name to masking probability of that modality.`,name:"mask_probs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L3355"}}),Ft=new j({}),It=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L2051"}}),Mt=new j({}),qt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_num_channels",val:": int"},{name:"position_encoding_type",val:": typing.Optional[str] = 'trainable'"},{name:"output_index_dims",val:": typing.Optional[int] = None"},{name:"num_channels",val:": typing.Optional[int] = 128"},{name:"subsampled_index_dims",val:": typing.Optional[int] = None"},{name:"qk_channels",val:": typing.Optional[int] = None"},{name:"v_channels",val:": typing.Optional[int] = None"},{name:"num_heads",val:": typing.Optional[int] = 1"},{name:"widening_factor",val:": typing.Optional[int] = 1"},{name:"use_query_residual",val:": typing.Optional[bool] = False"},{name:"concat_preprocessed_input",val:": typing.Optional[bool] = False"},{name:"final_project",val:": typing.Optional[bool] = True"},{name:"position_encoding_only",val:": typing.Optional[bool] = False"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels in the output. Will only be used in case <em>final_project</em> is set to <code>True</code>.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;trainable&#x201D;) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_index_dims",description:`<strong>output_index_dims</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of dimensions of the output queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"output_index_dims"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The number of channels of the decoder queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the queries and keys in the cross-attention layer.`,name:"qk_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the values in the cross-attention layer.`,name:"v_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of attention heads in the cross-attention layer.`,name:"num_heads"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.widening_factor",description:`<strong>widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The widening factor of the cross-attention layer.`,name:"widening_factor"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.use_query_residual",description:`<strong>use_query_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a residual connection between the query and the output of the cross-attention layer.`,name:"use_query_residual"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.concat_preprocessed_input",description:`<strong>concat_preprocessed_input</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the preprocessed input to the query.`,name:"concat_preprocessed_input"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.final_project",description:`<strong>final_project</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to project the output of the cross-attention layer to a target dimension.`,name:"final_project"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_only",description:`<strong>position_encoding_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only use this class to define output queries.`,name:"position_encoding_only"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L2077"}}),zt=new j({}),At=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",parameters:[{name:"config",val:""},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L2263"}}),Ot=new j({}),Nt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",parameters:[{name:"config",val:""},{name:"output_image_shape",val:""},{name:"output_num_channels",val:" = 2"},{name:"rescale_factor",val:" = 100.0"},{name:"**decoder_kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L2309"}}),Lt=new j({}),St=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_shape",val:": typing.List[int]"},{name:"position_encoding_type",val:": str"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>) &#x2014;
Shape of the output as (batch_size, num_frames, height, width), excluding the channel dimension.`,name:"output_shape"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L2344"}}),Wt=new j({}),Ht=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"modalities",val:": typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder]"},{name:"num_outputs",val:": int"},{name:"output_num_channels",val:": int"},{name:"min_padding_size",val:": typing.Optional[int] = 2"},{name:"subsampled_index_dims",val:": typing.Union[typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder], NoneType] = None"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>) &#x2014;
Dictionary mapping modality name to the decoder of that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.num_outputs",description:`<strong>num_outputs</strong> (<code>int</code>) &#x2014;
The number of outputs of the decoder.`,name:"num_outputs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>) &#x2014;
The number of channels in the output.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.subsampled_index_dims",description:`<strong>subsampled_index_dims</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>, <em>optional</em>) &#x2014;
Dictionary mapping modality name to the subsampled index dimensions to use for the decoder query of that
modality.`,name:"subsampled_index_dims"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L2421"}}),Rt=new j({}),Ut=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",parameters:[{name:"in_channels",val:": int"},{name:"out_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the output.`,name:"out_channels"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L2982"}}),Kt=new j({}),Gt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"},{name:"postproc_type",val:": str = 'patches'"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.postproc_type",description:`<strong>postproc_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Postprocessor type to use. Currently, only &#x201C;patches&#x201D; is supported.`,name:"postproc_type"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L2955"}}),Jt=new j({}),Xt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L2935"}}),Zt=new j({}),Yt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",parameters:[{name:"modalities",val:": typing.Mapping[str, typing.Callable[..., typing.Any]]"},{name:"input_is_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.modalities",description:`<strong>modalities</strong> (<code>Mapping[str, PostprocessorType]</code>) &#x2014;
Dictionary mapping modality name to postprocessor class for that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.input_is_dict",description:`<strong>input_is_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, input is assumed to be dictionary structured, and outputs keep the same dictionary shape. If
False, input is a tensor which is sliced up during postprocessing by <em>modality_sizes</em>.`,name:"input_is_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L2901"}}),Qt=new j({}),es=new x({props:{name:"class transformers.PerceiverModel",anchor:"transformers.PerceiverModel",parameters:[{name:"config",val:""},{name:"decoder",val:" = None"},{name:"input_preprocessor",val:": typing.Callable[..., typing.Tuple[torch.Tensor, typing.Optional[torch.Tensor], torch.Tensor]] = None"},{name:"output_postprocessor",val:": typing.Callable[..., typing.Any] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.29.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.PerceiverModel.decoder",description:`<strong>decoder</strong> (<em>DecoderType</em>, <em>optional</em>) &#x2014;
Optional decoder to use to decode the latent representation of the encoder. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder</em>.`,name:"decoder"},{anchor:"transformers.PerceiverModel.input_preprocessor",description:`<strong>input_preprocessor</strong> (<em>PreprocessorType</em>, <em>optional</em>) &#x2014;
Optional input preprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor</em>.`,name:"input_preprocessor"},{anchor:"transformers.PerceiverModel.output_postprocessor",description:`<strong>output_postprocessor</strong> (<em>PostprocessorType</em>, <em>optional</em>) &#x2014;
Optional output postprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor</em>.`,name:"output_postprocessor"},{anchor:"transformers.PerceiverModel.Note",description:"<strong>Note</strong> that you can define your own decoders, preprocessors and/or postprocessors to fit your use-case. &#x2014;",name:"Note"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L716"}}),ts=new x({props:{name:"forward",anchor:"transformers.PerceiverModel.forward",parameters:[{name:"inputs",val:": FloatTensor"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"subsampled_output_points",val:": typing.Union[typing.Dict[str, torch.Tensor], NoneType] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L752",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) \u2014 Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),nr=new Sr({props:{$$slots:{default:[mw]},$$scope:{ctx:E}}}),ar=new To({props:{anchor:"transformers.PerceiverModel.forward.example",$$slots:{default:[hw]},$$scope:{ctx:E}}}),ss=new j({}),ns=new x({props:{name:"class transformers.PerceiverForMaskedLM",anchor:"transformers.PerceiverForMaskedLM",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.29.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L954"}}),cs=new x({props:{name:"forward",anchor:"transformers.PerceiverForMaskedLM.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L986",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Masked language modeling (MLM) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) \u2014 Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),cr=new Sr({props:{$$slots:{default:[uw]},$$scope:{ctx:E}}}),lr=new To({props:{anchor:"transformers.PerceiverForMaskedLM.forward.example",$$slots:{default:[fw]},$$scope:{ctx:E}}}),ls=new j({}),ds=new x({props:{name:"class transformers.PerceiverForSequenceClassification",anchor:"transformers.PerceiverForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.29.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L1089"}}),hs=new x({props:{name:"forward",anchor:"transformers.PerceiverForSequenceClassification.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L1110",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pr=new Sr({props:{$$slots:{default:[gw]},$$scope:{ctx:E}}}),mr=new To({props:{anchor:"transformers.PerceiverForSequenceClassification.forward.example",$$slots:{default:[vw]},$$scope:{ctx:E}}}),us=new j({}),fs=new x({props:{name:"class transformers.PerceiverForImageClassificationLearned",anchor:"transformers.PerceiverForImageClassificationLearned",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.29.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L1214"}}),_s=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationLearned.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L1245",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ur=new Sr({props:{$$slots:{default:[_w]},$$scope:{ctx:E}}}),fr=new To({props:{anchor:"transformers.PerceiverForImageClassificationLearned.forward.example",$$slots:{default:[Pw]},$$scope:{ctx:E}}}),Ps=new j({}),bs=new x({props:{name:"class transformers.PerceiverForImageClassificationFourier",anchor:"transformers.PerceiverForImageClassificationFourier",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.29.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L1357"}}),$s=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationFourier.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L1389",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),vr=new Sr({props:{$$slots:{default:[bw]},$$scope:{ctx:E}}}),_r=new To({props:{anchor:"transformers.PerceiverForImageClassificationFourier.forward.example",$$slots:{default:[ww]},$$scope:{ctx:E}}}),ks=new j({}),Ts=new x({props:{name:"class transformers.PerceiverForImageClassificationConvProcessing",anchor:"transformers.PerceiverForImageClassificationConvProcessing",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.29.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L1500"}}),js=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L1533",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),br=new Sr({props:{$$slots:{default:[yw]},$$scope:{ctx:E}}}),wr=new To({props:{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.example",$$slots:{default:[$w]},$$scope:{ctx:E}}}),Cs=new j({}),Fs=new x({props:{name:"class transformers.PerceiverForOpticalFlow",anchor:"transformers.PerceiverForOpticalFlow",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.29.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L1644"}}),qs=new x({props:{name:"forward",anchor:"transformers.PerceiverForOpticalFlow.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForOpticalFlow.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForOpticalFlow.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForOpticalFlow.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the optical flow loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L1694",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$r=new Sr({props:{$$slots:{default:[kw]},$$scope:{ctx:E}}}),kr=new To({props:{anchor:"transformers.PerceiverForOpticalFlow.forward.example",$$slots:{default:[Tw]},$$scope:{ctx:E}}}),zs=new j({}),As=new x({props:{name:"class transformers.PerceiverForMultimodalAutoencoding",anchor:"transformers.PerceiverForMultimodalAutoencoding",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.29.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L1789"}}),Ls=new x({props:{name:"forward",anchor:"transformers.PerceiverForMultimodalAutoencoding.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"subsampled_output_points",val:": typing.Union[typing.Dict[str, torch.Tensor], NoneType] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.29.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.29.1/src/transformers/models/perceiver/modeling_perceiver.py#L1905",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),jr=new Sr({props:{$$slots:{default:[xw]},$$scope:{ctx:E}}}),Cr=new To({props:{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.example",$$slots:{default:[Ew]},$$scope:{ctx:E}}}),{c(){u=t("meta"),T=l(),v=t("h1"),g=t("a"),k=t("span"),_(p.$$.fragment),f=l(),C=t("span"),Ep=a("Perceiver"),Rc=l(),$e=t("h2"),jo=t("a"),ia=t("span"),_(Br.$$.fragment),jp=l(),ca=t("span"),Cp=a("Overview"),Uc=l(),Co=t("p"),Fp=a("The Perceiver IO model was proposed in "),Wr=t("a"),Ip=a(`Perceiver IO: A General Architecture for Structured Inputs &
Outputs`),Mp=a(` by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch,
Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier H\xE9naff, Matthew M.
Botvinick, Andrew Zisserman, Oriol Vinyals, Jo\xE3o Carreira.`),Kc=l(),Fo=t("p"),qp=a("Perceiver IO is a generalization of "),Hr=t("a"),zp=a("Perceiver"),Ap=a(` to handle arbitrary outputs in
addition to arbitrary inputs. The original Perceiver only produced a single classification label. In addition to
classification labels, Perceiver IO can produce (for example) language, optical flow, and multimodal videos with audio.
This is done using the same building blocks as the original Perceiver. The computational complexity of Perceiver IO is
linear in the input and output size and the bulk of the processing occurs in the latent space, allowing us to process
inputs and outputs that are much larger than can be handled by standard Transformers. This means, for example,
Perceiver IO can do BERT-style masked language modeling directly using bytes instead of tokenized inputs.`),Gc=l(),Us=t("p"),Dp=a("The abstract from the paper is the following:"),Jc=l(),Ks=t("p"),la=t("em"),Op=a(`The recently-proposed Perceiver model obtains good results on several domains (images, audio, multimodal, point
clouds) while scaling linearly in compute and memory with the input size. While the Perceiver supports many kinds of
inputs, it can only produce very simple outputs such as class scores. Perceiver IO overcomes this limitation without
sacrificing the original\u2019s appealing properties by learning to flexibly query the model\u2019s latent space to produce
outputs of arbitrary size and semantics. Perceiver IO still decouples model depth from data size and still scales
linearly with data size, but now with respect to both input and output sizes. The full Perceiver IO model achieves
strong results on tasks with highly structured output spaces, such as natural language and visual understanding,
StarCraft II, and multi-task and multi-modal domains. As highlights, Perceiver IO matches a Transformer-based BERT
baseline on the GLUE language benchmark without the need for input tokenization and achieves state-of-the-art
performance on Sintel optical flow estimation.`),Xc=l(),Gs=t("p"),Np=a("Here\u2019s a TLDR explaining how Perceiver works:"),Zc=l(),Js=t("p"),Lp=a(`The main problem with the self-attention mechanism of the Transformer is that the time and memory requirements scale
quadratically with the sequence length. Hence, models like BERT and RoBERTa are limited to a max sequence length of 512
tokens. Perceiver aims to solve this issue by, instead of performing self-attention on the inputs, perform it on a set
of latent variables, and only use the inputs for cross-attention. In this way, the time and memory requirements don\u2019t
depend on the length of the inputs anymore, as one uses a fixed amount of latent variables, like 256 or 512. These are
randomly initialized, after which they are trained end-to-end using backpropagation.`),Yc=l(),D=t("p"),Sp=a("Internally, "),Xs=t("a"),Bp=a("PerceiverModel"),Wp=a(" will create the latents, which is a tensor of shape "),da=t("code"),Hp=a("(batch_size, num_latents, d_latents)"),Vp=a(". One must provide "),pa=t("code"),Rp=a("inputs"),Up=a(` (which could be text, images, audio, you name it!) to the model, which it will
use to perform cross-attention with the latents. The output of the Perceiver encoder is a tensor of the same shape. One
can then, similar to BERT, convert the last hidden states of the latents to classification logits by averaging along
the sequence dimension, and placing a linear layer on top of that to project the `),ma=t("code"),Kp=a("d_latents"),Gp=a(" to "),ha=t("code"),Jp=a("num_labels"),Xp=a("."),Qc=l(),Zs=t("p"),Zp=a(`This was the idea of the original Perceiver paper. However, it could only output classification logits. In a follow-up
work, PerceiverIO, they generalized it to let the model also produce outputs of arbitrary size. How, you might ask? The
idea is actually relatively simple: one defines outputs of an arbitrary size, and then applies cross-attention with the
last hidden states of the latents, using the outputs as queries, and the latents as keys and values.`),el=l(),I=t("p"),Yp=a(`So let\u2019s say one wants to perform masked language modeling (BERT-style) with the Perceiver. As the Perceiver\u2019s input
length will not have an impact on the computation time of the self-attention layers, one can provide raw bytes,
providing `),ua=t("code"),Qp=a("inputs"),em=a(` of length 2048 to the model. If one now masks out certain of these 2048 tokens, one can define the
`),fa=t("code"),om=a("outputs"),rm=a(" as being of shape: "),ga=t("code"),tm=a("(batch_size, 2048, 768)"),sm=a(`. Next, one performs cross-attention with the final hidden states
of the latents to update the `),va=t("code"),nm=a("outputs"),am=a(" tensor. After cross-attention, one still has a tensor of shape "),_a=t("code"),im=a("(batch_size, 2048, 768)"),cm=a(`. One can then place a regular language modeling head on top, to project the last dimension to the
vocabulary size of the model, i.e. creating logits of shape `),Pa=t("code"),lm=a("(batch_size, 2048, 262)"),dm=a(` (as Perceiver uses a vocabulary
size of 262 byte IDs).`),ol=l(),Io=t("img"),rl=l(),Vr=t("small"),pm=a("Perceiver IO architecture. Taken from the "),Ys=t("a"),mm=a("original paper"),tl=l(),ve=t("p"),hm=a("This model was contributed by "),Rr=t("a"),um=a("nielsr"),fm=a(`. The original code can be found
`),Ur=t("a"),gm=a("here"),vm=a("."),sl=l(),Qs=t("p"),_m=a("Tips:"),nl=l(),Mo=t("ul"),Kr=t("li"),Pm=a("The quickest way to get started with the Perceiver is by checking the "),Gr=t("a"),bm=a(`tutorial
notebooks`),wm=a("."),ym=l(),Jr=t("li"),$m=a("Refer to the "),Xr=t("a"),km=a("blog post"),Tm=a(` if you want to fully understand how the model works and
is implemented in the library. Note that the models available in the library only showcase some examples of what you can do
with the Perceiver. There are many more use cases, including question answering, named-entity recognition, object detection,
audio classification, video classification, etc.`),al=l(),Zr=t("p"),ba=t("strong"),xm=a("Note"),Em=a(":"),il=l(),en=t("ul"),_e=t("li"),jm=a("Perceiver does "),wa=t("strong"),Cm=a("not"),Fm=a(" work with "),ya=t("code"),Im=a("torch.nn.DataParallel"),Mm=a(" due to a bug in PyTorch, see "),Yr=t("a"),qm=a("issue #36035"),cl=l(),ke=t("h2"),qo=t("a"),$a=t("span"),_(Qr.$$.fragment),zm=l(),ka=t("span"),Am=a("Documentation resources"),ll=l(),Pe=t("ul"),Ta=t("li"),on=t("a"),Dm=a("Text classification task guide"),Om=l(),xa=t("li"),rn=t("a"),Nm=a("Masked language modeling task guide"),Lm=l(),Ea=t("li"),tn=t("a"),Sm=a("Image classification task guide"),dl=l(),Te=t("h2"),zo=t("a"),ja=t("span"),_(et.$$.fragment),Bm=l(),Ca=t("span"),Wm=a("Perceiver specific outputs"),pl=l(),xe=t("div"),_(ot.$$.fragment),Hm=l(),Fa=t("p"),Vm=a("Base class for Perceiver base model\u2019s outputs, with potential hidden states, attentions and cross-attentions."),ml=l(),Ee=t("div"),_(rt.$$.fragment),Rm=l(),Ia=t("p"),Um=a("Base class for Perceiver decoder outputs, with potential cross-attentions."),hl=l(),je=t("div"),_(tt.$$.fragment),Km=l(),Ma=t("p"),Gm=a("Base class for Perceiver\u2019s masked language model outputs."),ul=l(),Ce=t("div"),_(st.$$.fragment),Jm=l(),qa=t("p"),Xm=a(`Base class for Perceiver\u2019s outputs of sequence/image classification models, optical flow and multimodal
autoencoding.`),fl=l(),Fe=t("h2"),Ao=t("a"),za=t("span"),_(nt.$$.fragment),Zm=l(),Aa=t("span"),Ym=a("PerceiverConfig"),gl=l(),H=t("div"),_(at.$$.fragment),Qm=l(),Ie=t("p"),eh=a("This is the configuration class to store the configuration of a "),sn=t("a"),oh=a("PerceiverModel"),rh=a(`. It is used to instantiate an
Perceiver model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Perceiver
`),it=t("a"),th=a("deepmind/language-perceiver"),sh=a(" architecture."),nh=l(),Me=t("p"),ah=a("Configuration objects inherit from "),nn=t("a"),ih=a("PretrainedConfig"),ch=a(` and can be used to control the model outputs. Read the
documentation from `),an=t("a"),lh=a("PretrainedConfig"),dh=a(" for more information."),ph=l(),_(Do.$$.fragment),vl=l(),qe=t("h2"),Oo=t("a"),Da=t("span"),_(ct.$$.fragment),mh=l(),Oa=t("span"),hh=a("PerceiverTokenizer"),_l=l(),V=t("div"),_(lt.$$.fragment),uh=l(),Na=t("p"),fh=a("Construct a Perceiver tokenizer. The Perceiver simply uses raw bytes utf-8 encoding."),gh=l(),dt=t("p"),vh=a("This tokenizer inherits from "),cn=t("a"),_h=a("PreTrainedTokenizer"),Ph=a(` which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`),bh=l(),No=t("div"),_(pt.$$.fragment),wh=l(),La=t("p"),yh=a(`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`),Pl=l(),ze=t("h2"),Lo=t("a"),Sa=t("span"),_(mt.$$.fragment),$h=l(),Ba=t("span"),kh=a("PerceiverFeatureExtractor"),bl=l(),Ae=t("div"),_(ht.$$.fragment),Th=l(),So=t("div"),_(ut.$$.fragment),xh=l(),Wa=t("p"),Eh=a("Preprocess an image or a batch of images."),wl=l(),De=t("h2"),Bo=t("a"),Ha=t("span"),_(ft.$$.fragment),jh=l(),Va=t("span"),Ch=a("PerceiverImageProcessor"),yl=l(),ne=t("div"),_(gt.$$.fragment),Fh=l(),Ra=t("p"),Ih=a("Constructs a Perceiver image processor."),Mh=l(),Wo=t("div"),_(vt.$$.fragment),qh=l(),Ua=t("p"),zh=a("Preprocess an image or batch of images."),$l=l(),Oe=t("h2"),Ho=t("a"),Ka=t("span"),_(_t.$$.fragment),Ah=l(),Ga=t("span"),Dh=a("PerceiverTextPreprocessor"),kl=l(),ae=t("div"),_(Pt.$$.fragment),Oh=l(),bt=t("p"),Nh=a("Text preprocessing for Perceiver Encoder. Can be used to embed "),Ja=t("code"),Lh=a("inputs"),Sh=a(" and add positional encodings."),Bh=l(),wt=t("p"),Wh=a("The dimensionality of the embeddings is determined by the "),Xa=t("code"),Hh=a("d_model"),Vh=a(" attribute of the configuration."),Tl=l(),Ne=t("h2"),Vo=t("a"),Za=t("span"),_(yt.$$.fragment),Rh=l(),Ya=t("span"),Uh=a("PerceiverImagePreprocessor"),xl=l(),ie=t("div"),_($t.$$.fragment),Kh=l(),Qa=t("p"),Gh=a("Image preprocessing for Perceiver Encoder."),Jh=l(),R=t("p"),Xh=a("Note: the "),ei=t("em"),Zh=a("out_channels"),Yh=a(" argument refers to the output channels of a convolutional layer, if "),oi=t("em"),Qh=a("prep_type"),eu=a(` is set to
\u201Cconv1x1\u201D or \u201Cconv\u201D. If one adds absolute position embeddings, one must make sure the `),ri=t("em"),ou=a("num_channels"),ru=a(` of the
position encoding kwargs are set equal to the `),ti=t("em"),tu=a("out_channels"),su=a("."),El=l(),Le=t("h2"),Ro=t("a"),si=t("span"),_(kt.$$.fragment),nu=l(),ni=t("span"),au=a("PerceiverOneHotPreprocessor"),jl=l(),Se=t("div"),_(Tt.$$.fragment),iu=l(),ai=t("p"),cu=a("One-hot preprocessor for Perceiver Encoder. Can be used to add a dummy index dimension to the input."),Cl=l(),Be=t("h2"),Uo=t("a"),ii=t("span"),_(xt.$$.fragment),lu=l(),ci=t("span"),du=a("PerceiverAudioPreprocessor"),Fl=l(),We=t("div"),_(Et.$$.fragment),pu=l(),li=t("p"),mu=a("Audio preprocessing for Perceiver Encoder."),Il=l(),He=t("h2"),Ko=t("a"),di=t("span"),_(jt.$$.fragment),hu=l(),pi=t("span"),uu=a("PerceiverMultimodalPreprocessor"),Ml=l(),ce=t("div"),_(Ct.$$.fragment),fu=l(),mi=t("p"),gu=a("Multimodal preprocessing for Perceiver Encoder."),vu=l(),hi=t("p"),_u=a(`Inputs for each modality are preprocessed, then padded with trainable position embeddings to have the same number
of channels.`),ql=l(),Ve=t("h2"),Go=t("a"),ui=t("span"),_(Ft.$$.fragment),Pu=l(),fi=t("span"),bu=a("PerceiverProjectionDecoder"),zl=l(),Re=t("div"),_(It.$$.fragment),wu=l(),gi=t("p"),yu=a("Baseline projection decoder (no cross-attention)."),Al=l(),Ue=t("h2"),Jo=t("a"),vi=t("span"),_(Mt.$$.fragment),$u=l(),_i=t("span"),ku=a("PerceiverBasicDecoder"),Dl=l(),le=t("div"),_(qt.$$.fragment),Tu=l(),Pi=t("p"),xu=a(`Cross-attention-based decoder. This class can be used to decode the final hidden states of the latents using a
cross-attention operation, in which the latents produce keys and values.`),Eu=l(),bi=t("p"),ju=a("The shape of the output of this class depends on how one defines the output queries (also called decoder queries)."),Ol=l(),Ke=t("h2"),Xo=t("a"),wi=t("span"),_(zt.$$.fragment),Cu=l(),yi=t("span"),Fu=a("PerceiverClassificationDecoder"),Nl=l(),Ge=t("div"),_(At.$$.fragment),Iu=l(),Dt=t("p"),Mu=a("Cross-attention based classification decoder. Light-weight wrapper of "),$i=t("code"),qu=a("PerceiverBasicDecoder"),zu=a(` for logit output.
Will turn the output of the Perceiver encoder which is of shape (batch_size, num_latents, d_latents) to a tensor of
shape (batch_size, num_labels). The queries are of shape (batch_size, 1, num_labels).`),Ll=l(),Je=t("h2"),Zo=t("a"),ki=t("span"),_(Ot.$$.fragment),Au=l(),Ti=t("span"),Du=a("PerceiverOpticalFlowDecoder"),Sl=l(),Xe=t("div"),_(Nt.$$.fragment),Ou=l(),xi=t("p"),Nu=a("Cross-attention based optical flow decoder."),Bl=l(),Ze=t("h2"),Yo=t("a"),Ei=t("span"),_(Lt.$$.fragment),Lu=l(),ji=t("span"),Su=a("PerceiverBasicVideoAutoencodingDecoder"),Wl=l(),Ye=t("div"),_(St.$$.fragment),Bu=l(),Bt=t("p"),Wu=a("Cross-attention based video-autoencoding decoder. Light-weight wrapper of ["),Ci=t("em"),Hu=a("PerceiverBasicDecoder"),Vu=a(`] with video
reshaping logic.`),Hl=l(),Qe=t("h2"),Qo=t("a"),Fi=t("span"),_(Wt.$$.fragment),Ru=l(),Ii=t("span"),Uu=a("PerceiverMultimodalDecoder"),Vl=l(),de=t("div"),_(Ht.$$.fragment),Ku=l(),Vt=t("p"),Gu=a("Multimodal decoding by composing uni-modal decoders. The "),Mi=t("em"),Ju=a("modalities"),Xu=a(` argument of the constructor is a dictionary
mapping modality name to the decoder of that modality. That decoder will be used to construct queries for that
modality. Modality-specific queries are padded with trainable modality-specific parameters, after which they are
concatenated along the time dimension.`),Zu=l(),qi=t("p"),Yu=a("Next, there is a shared cross attention operation across all modalities."),Rl=l(),eo=t("h2"),er=t("a"),zi=t("span"),_(Rt.$$.fragment),Qu=l(),Ai=t("span"),ef=a("PerceiverProjectionPostprocessor"),Ul=l(),oo=t("div"),_(Ut.$$.fragment),of=l(),Di=t("p"),rf=a(`Projection postprocessing for Perceiver. Can be used to project the channels of the decoder output to a lower
dimension.`),Kl=l(),ro=t("h2"),or=t("a"),Oi=t("span"),_(Kt.$$.fragment),tf=l(),Ni=t("span"),sf=a("PerceiverAudioPostprocessor"),Gl=l(),to=t("div"),_(Gt.$$.fragment),nf=l(),Li=t("p"),af=a("Audio postprocessing for Perceiver. Can be used to convert the decoder output to audio features."),Jl=l(),so=t("h2"),rr=t("a"),Si=t("span"),_(Jt.$$.fragment),cf=l(),Bi=t("span"),lf=a("PerceiverClassificationPostprocessor"),Xl=l(),no=t("div"),_(Xt.$$.fragment),df=l(),Wi=t("p"),pf=a("Classification postprocessing for Perceiver. Can be used to convert the decoder output to classification logits."),Zl=l(),ao=t("h2"),tr=t("a"),Hi=t("span"),_(Zt.$$.fragment),mf=l(),Vi=t("span"),hf=a("PerceiverMultimodalPostprocessor"),Yl=l(),io=t("div"),_(Yt.$$.fragment),uf=l(),Ri=t("p"),ff=a(`Multimodal postprocessing for Perceiver. Can be used to combine modality-specific postprocessors into a single
postprocessor.`),Ql=l(),co=t("h2"),sr=t("a"),Ui=t("span"),_(Qt.$$.fragment),gf=l(),Ki=t("span"),vf=a("PerceiverModel"),ed=l(),pe=t("div"),_(es.$$.fragment),_f=l(),os=t("p"),Pf=a(`The Perceiver: a scalable, fully attentional architecture.
This model is a PyTorch `),rs=t("a"),bf=a("torch.nn.Module"),wf=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),yf=l(),U=t("div"),_(ts.$$.fragment),$f=l(),lo=t("p"),kf=a("The "),ln=t("a"),Tf=a("PerceiverModel"),xf=a(" forward method, overrides the "),Gi=t("code"),Ef=a("__call__"),jf=a(" special method."),Cf=l(),_(nr.$$.fragment),Ff=l(),_(ar.$$.fragment),od=l(),po=t("h2"),ir=t("a"),Ji=t("span"),_(ss.$$.fragment),If=l(),Xi=t("span"),Mf=a("PerceiverForMaskedLM"),rd=l(),me=t("div"),_(ns.$$.fragment),qf=l(),as=t("p"),zf=a(`Example use of Perceiver for masked language modeling.
This model is a PyTorch `),is=t("a"),Af=a("torch.nn.Module"),Df=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Of=l(),K=t("div"),_(cs.$$.fragment),Nf=l(),mo=t("p"),Lf=a("The "),dn=t("a"),Sf=a("PerceiverForMaskedLM"),Bf=a(" forward method, overrides the "),Zi=t("code"),Wf=a("__call__"),Hf=a(" special method."),Vf=l(),_(cr.$$.fragment),Rf=l(),_(lr.$$.fragment),td=l(),ho=t("h2"),dr=t("a"),Yi=t("span"),_(ls.$$.fragment),Uf=l(),Qi=t("span"),Kf=a("PerceiverForSequenceClassification"),sd=l(),he=t("div"),_(ds.$$.fragment),Gf=l(),ps=t("p"),Jf=a(`Example use of Perceiver for text classification.
This model is a PyTorch `),ms=t("a"),Xf=a("torch.nn.Module"),Zf=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Yf=l(),G=t("div"),_(hs.$$.fragment),Qf=l(),uo=t("p"),eg=a("The "),pn=t("a"),og=a("PerceiverForSequenceClassification"),rg=a(" forward method, overrides the "),ec=t("code"),tg=a("__call__"),sg=a(" special method."),ng=l(),_(pr.$$.fragment),ag=l(),_(mr.$$.fragment),nd=l(),fo=t("h2"),hr=t("a"),oc=t("span"),_(us.$$.fragment),ig=l(),rc=t("span"),cg=a("PerceiverForImageClassificationLearned"),ad=l(),q=t("div"),_(fs.$$.fragment),lg=l(),tc=t("p"),dg=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),pg=l(),sc=t("p"),mg=a(`This model uses learned position embeddings. In other words, this model is not given any privileged information about
the structure of images. As shown in the paper, this model can achieve a top-1 accuracy of 72.7 on ImageNet.`),hg=l(),L=t("p"),mn=t("a"),ug=a("PerceiverForImageClassificationLearned"),fg=a(" uses "),hn=t("a"),gg=a("PerceiverImagePreprocessor"),vg=a(`
(with `),nc=t("code"),_g=a('prep_type="conv1x1"'),Pg=a(`) to preprocess the input images, and
`),un=t("a"),bg=a("PerceiverClassificationDecoder"),wg=a(` to decode the latent representation of
`),fn=t("a"),yg=a("PerceiverModel"),$g=a(" into classification logits."),kg=l(),gs=t("p"),Tg=a("This model is a PyTorch "),vs=t("a"),xg=a("torch.nn.Module"),Eg=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),jg=l(),J=t("div"),_(_s.$$.fragment),Cg=l(),go=t("p"),Fg=a("The "),gn=t("a"),Ig=a("PerceiverForImageClassificationLearned"),Mg=a(" forward method, overrides the "),ac=t("code"),qg=a("__call__"),zg=a(" special method."),Ag=l(),_(ur.$$.fragment),Dg=l(),_(fr.$$.fragment),id=l(),vo=t("h2"),gr=t("a"),ic=t("span"),_(Ps.$$.fragment),Og=l(),cc=t("span"),Ng=a("PerceiverForImageClassificationFourier"),cd=l(),z=t("div"),_(bs.$$.fragment),Lg=l(),lc=t("p"),Sg=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),Bg=l(),dc=t("p"),Wg=a(`This model uses fixed 2D Fourier position embeddings. As shown in the paper, this model can achieve a top-1 accuracy of
79.0 on ImageNet, and 84.5 when pre-trained on a large-scale dataset (i.e. JFT).`),Hg=l(),S=t("p"),vn=t("a"),Vg=a("PerceiverForImageClassificationLearned"),Rg=a(" uses "),_n=t("a"),Ug=a("PerceiverImagePreprocessor"),Kg=a(`
(with `),pc=t("code"),Gg=a('prep_type="pixels"'),Jg=a(`) to preprocess the input images, and
`),Pn=t("a"),Xg=a("PerceiverClassificationDecoder"),Zg=a(` to decode the latent representation of
`),bn=t("a"),Yg=a("PerceiverModel"),Qg=a(" into classification logits."),ev=l(),ws=t("p"),ov=a("This model is a PyTorch "),ys=t("a"),rv=a("torch.nn.Module"),tv=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),sv=l(),X=t("div"),_($s.$$.fragment),nv=l(),_o=t("p"),av=a("The "),wn=t("a"),iv=a("PerceiverForImageClassificationFourier"),cv=a(" forward method, overrides the "),mc=t("code"),lv=a("__call__"),dv=a(" special method."),pv=l(),_(vr.$$.fragment),mv=l(),_(_r.$$.fragment),ld=l(),Po=t("h2"),Pr=t("a"),hc=t("span"),_(ks.$$.fragment),hv=l(),uc=t("span"),uv=a("PerceiverForImageClassificationConvProcessing"),dd=l(),A=t("div"),_(Ts.$$.fragment),fv=l(),fc=t("p"),gv=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),vv=l(),gc=t("p"),_v=a(`This model uses a 2D conv+maxpool preprocessing network. As shown in the paper, this model can achieve a top-1 accuracy
of 82.1 on ImageNet.`),Pv=l(),B=t("p"),yn=t("a"),bv=a("PerceiverForImageClassificationLearned"),wv=a(" uses "),$n=t("a"),yv=a("PerceiverImagePreprocessor"),$v=a(`
(with `),vc=t("code"),kv=a('prep_type="conv"'),Tv=a(`) to preprocess the input images, and
`),kn=t("a"),xv=a("PerceiverClassificationDecoder"),Ev=a(` to decode the latent representation of
`),Tn=t("a"),jv=a("PerceiverModel"),Cv=a(" into classification logits."),Fv=l(),xs=t("p"),Iv=a("This model is a PyTorch "),Es=t("a"),Mv=a("torch.nn.Module"),qv=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),zv=l(),Z=t("div"),_(js.$$.fragment),Av=l(),bo=t("p"),Dv=a("The "),xn=t("a"),Ov=a("PerceiverForImageClassificationConvProcessing"),Nv=a(" forward method, overrides the "),_c=t("code"),Lv=a("__call__"),Sv=a(" special method."),Bv=l(),_(br.$$.fragment),Wv=l(),_(wr.$$.fragment),pd=l(),wo=t("h2"),yr=t("a"),Pc=t("span"),_(Cs.$$.fragment),Hv=l(),bc=t("span"),Vv=a("PerceiverForOpticalFlow"),md=l(),O=t("div"),_(Fs.$$.fragment),Rv=l(),N=t("p"),Uv=a("Example use of Perceiver for optical flow, for tasks such as Sintel and KITTI. "),En=t("a"),Kv=a("PerceiverForOpticalFlow"),Gv=a(` uses
`),jn=t("a"),Jv=a("PerceiverImagePreprocessor"),Xv=a(" (with "),wc=t("em"),Zv=a("prep_type=\u201Cpatches\u201D"),Yv=a(`) to preprocess the
input images, and `),Cn=t("a"),Qv=a("PerceiverOpticalFlowDecoder"),e_=a(` to decode the latent
representation of `),Fn=t("a"),o_=a("PerceiverModel"),r_=a("."),t_=l(),yc=t("p"),s_=a(`As input, one concatenates 2 subsequent frames along the channel dimension and extract a 3 x 3 patch around each pixel
(leading to 3 x 3 x 3 x 2 = 54 values for each pixel). Fixed Fourier position encodings are used to encode the position
of each pixel in the patch. Next, one applies the Perceiver encoder. To decode, one queries the latent representation
using the same encoding used for the input.`),n_=l(),Is=t("p"),a_=a("This model is a PyTorch "),Ms=t("a"),i_=a("torch.nn.Module"),c_=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),l_=l(),Y=t("div"),_(qs.$$.fragment),d_=l(),yo=t("p"),p_=a("The "),In=t("a"),m_=a("PerceiverForOpticalFlow"),h_=a(" forward method, overrides the "),$c=t("code"),u_=a("__call__"),f_=a(" special method."),g_=l(),_($r.$$.fragment),v_=l(),_(kr.$$.fragment),hd=l(),$o=t("h2"),Tr=t("a"),kc=t("span"),_(zs.$$.fragment),__=l(),Tc=t("span"),P_=a("PerceiverForMultimodalAutoencoding"),ud=l(),F=t("div"),_(As.$$.fragment),b_=l(),xc=t("p"),w_=a("Example use of Perceiver for multimodal (video) autoencoding, for tasks such as Kinetics-700."),y_=l(),xr=t("p"),Mn=t("a"),$_=a("PerceiverForMultimodalAutoencoding"),k_=a(" uses "),qn=t("a"),T_=a("PerceiverMultimodalPreprocessor"),x_=a(` to
preprocess the 3 modalities: images, audio and class labels. This preprocessor uses modality-specific preprocessors to
preprocess every modality separately, after which they are concatenated. Trainable position embeddings are used to pad
each modality to the same number of channels to make concatenation along the time dimension possible. Next, one applies
the Perceiver encoder.`),E_=l(),be=t("p"),zn=t("a"),j_=a("PerceiverMultimodalDecoder"),C_=a(` is used to decode the latent representation of
`),An=t("a"),F_=a("PerceiverModel"),I_=a(`. This decoder uses each modality-specific decoder to construct queries. The decoder queries are
created based on the inputs after preprocessing. However, autoencoding an entire video in a single forward pass is
computationally infeasible, hence one only uses parts of the decoder queries to do cross-attention with the latent
representation. This is determined by the subsampled indices for each modality, which can be provided as additional
input to the forward pass of `),Dn=t("a"),M_=a("PerceiverForMultimodalAutoencoding"),q_=a("."),z_=l(),Er=t("p"),On=t("a"),A_=a("PerceiverMultimodalDecoder"),D_=a(` also pads the decoder queries of the different
modalities to the same number of channels, in order to concatenate them along the time dimension. Next, cross-attention
is performed with the latent representation of `),Nn=t("a"),O_=a("PerceiverModel"),N_=a("."),L_=l(),Ds=t("p"),S_=a("Finally, "),Ec=t("code"),B_=a("~models.perceiver.modeling_perceiver.PerceiverMultiModalPostprocessor"),W_=a(` is used to turn this tensor into an
actual video. It first splits up the output into the different modalities, and then applies the respective
postprocessor for each modality.`),H_=l(),jc=t("p"),V_=a(`Note that, by masking the classification label during evaluation (i.e. simply providing a tensor of zeros for the
\u201Clabel\u201D modality), this auto-encoding model becomes a Kinetics 700 video classifier.`),R_=l(),Os=t("p"),U_=a("This model is a PyTorch "),Ns=t("a"),K_=a("torch.nn.Module"),G_=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),J_=l(),Q=t("div"),_(Ls.$$.fragment),X_=l(),ko=t("p"),Z_=a("The "),Ln=t("a"),Y_=a("PerceiverForMultimodalAutoencoding"),Q_=a(" forward method, overrides the "),Cc=t("code"),eP=a("__call__"),oP=a(" special method."),rP=l(),_(jr.$$.fragment),tP=l(),_(Cr.$$.fragment),this.h()},l(o){const m=cw('[data-svelte="svelte-1phssyn"]',document.head);u=s(m,"META",{name:!0,content:!0}),m.forEach(r),T=d(o),v=s(o,"H1",{class:!0});var Ss=n(v);g=s(Ss,"A",{id:!0,class:!0,href:!0});var Fc=n(g);k=s(Fc,"SPAN",{});var Ic=n(k);P(p.$$.fragment,Ic),Ic.forEach(r),Fc.forEach(r),f=d(Ss),C=s(Ss,"SPAN",{});var Mc=n(C);Ep=i(Mc,"Perceiver"),Mc.forEach(r),Ss.forEach(r),Rc=d(o),$e=s(o,"H2",{class:!0});var Bs=n($e);jo=s(Bs,"A",{id:!0,class:!0,href:!0});var qc=n(jo);ia=s(qc,"SPAN",{});var zc=n(ia);P(Br.$$.fragment,zc),zc.forEach(r),qc.forEach(r),jp=d(Bs),ca=s(Bs,"SPAN",{});var Ac=n(ca);Cp=i(Ac,"Overview"),Ac.forEach(r),Bs.forEach(r),Uc=d(o),Co=s(o,"P",{});var Ws=n(Co);Fp=i(Ws,"The Perceiver IO model was proposed in "),Wr=s(Ws,"A",{href:!0,rel:!0});var Dc=n(Wr);Ip=i(Dc,`Perceiver IO: A General Architecture for Structured Inputs &
Outputs`),Dc.forEach(r),Mp=i(Ws,` by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch,
Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier H\xE9naff, Matthew M.
Botvinick, Andrew Zisserman, Oriol Vinyals, Jo\xE3o Carreira.`),Ws.forEach(r),Kc=d(o),Fo=s(o,"P",{});var Hs=n(Fo);qp=i(Hs,"Perceiver IO is a generalization of "),Hr=s(Hs,"A",{href:!0,rel:!0});var Oc=n(Hr);zp=i(Oc,"Perceiver"),Oc.forEach(r),Ap=i(Hs,` to handle arbitrary outputs in
addition to arbitrary inputs. The original Perceiver only produced a single classification label. In addition to
classification labels, Perceiver IO can produce (for example) language, optical flow, and multimodal videos with audio.
This is done using the same building blocks as the original Perceiver. The computational complexity of Perceiver IO is
linear in the input and output size and the bulk of the processing occurs in the latent space, allowing us to process
inputs and outputs that are much larger than can be handled by standard Transformers. This means, for example,
Perceiver IO can do BERT-style masked language modeling directly using bytes instead of tokenized inputs.`),Hs.forEach(r),Gc=d(o),Us=s(o,"P",{});var Nc=n(Us);Dp=i(Nc,"The abstract from the paper is the following:"),Nc.forEach(r),Jc=d(o),Ks=s(o,"P",{});var Lc=n(Ks);la=s(Lc,"EM",{});var Sc=n(la);Op=i(Sc,`The recently-proposed Perceiver model obtains good results on several domains (images, audio, multimodal, point
clouds) while scaling linearly in compute and memory with the input size. While the Perceiver supports many kinds of
inputs, it can only produce very simple outputs such as class scores. Perceiver IO overcomes this limitation without
sacrificing the original\u2019s appealing properties by learning to flexibly query the model\u2019s latent space to produce
outputs of arbitrary size and semantics. Perceiver IO still decouples model depth from data size and still scales
linearly with data size, but now with respect to both input and output sizes. The full Perceiver IO model achieves
strong results on tasks with highly structured output spaces, such as natural language and visual understanding,
StarCraft II, and multi-task and multi-modal domains. As highlights, Perceiver IO matches a Transformer-based BERT
baseline on the GLUE language benchmark without the need for input tokenization and achieves state-of-the-art
performance on Sintel optical flow estimation.`),Sc.forEach(r),Lc.forEach(r),Xc=d(o),Gs=s(o,"P",{});var Bc=n(Gs);Np=i(Bc,"Here\u2019s a TLDR explaining how Perceiver works:"),Bc.forEach(r),Zc=d(o),Js=s(o,"P",{});var Wc=n(Js);Lp=i(Wc,`The main problem with the self-attention mechanism of the Transformer is that the time and memory requirements scale
quadratically with the sequence length. Hence, models like BERT and RoBERTa are limited to a max sequence length of 512
tokens. Perceiver aims to solve this issue by, instead of performing self-attention on the inputs, perform it on a set
of latent variables, and only use the inputs for cross-attention. In this way, the time and memory requirements don\u2019t
depend on the length of the inputs anymore, as one uses a fixed amount of latent variables, like 256 or 512. These are
randomly initialized, after which they are trained end-to-end using backpropagation.`),Wc.forEach(r),Yc=d(o),D=s(o,"P",{});var ee=n(D);Sp=i(ee,"Internally, "),Xs=s(ee,"A",{href:!0});var iP=n(Xs);Bp=i(iP,"PerceiverModel"),iP.forEach(r),Wp=i(ee," will create the latents, which is a tensor of shape "),da=s(ee,"CODE",{});var cP=n(da);Hp=i(cP,"(batch_size, num_latents, d_latents)"),cP.forEach(r),Vp=i(ee,". One must provide "),pa=s(ee,"CODE",{});var lP=n(pa);Rp=i(lP,"inputs"),lP.forEach(r),Up=i(ee,` (which could be text, images, audio, you name it!) to the model, which it will
use to perform cross-attention with the latents. The output of the Perceiver encoder is a tensor of the same shape. One
can then, similar to BERT, convert the last hidden states of the latents to classification logits by averaging along
the sequence dimension, and placing a linear layer on top of that to project the `),ma=s(ee,"CODE",{});var dP=n(ma);Kp=i(dP,"d_latents"),dP.forEach(r),Gp=i(ee," to "),ha=s(ee,"CODE",{});var pP=n(ha);Jp=i(pP,"num_labels"),pP.forEach(r),Xp=i(ee,"."),ee.forEach(r),Qc=d(o),Zs=s(o,"P",{});var mP=n(Zs);Zp=i(mP,`This was the idea of the original Perceiver paper. However, it could only output classification logits. In a follow-up
work, PerceiverIO, they generalized it to let the model also produce outputs of arbitrary size. How, you might ask? The
idea is actually relatively simple: one defines outputs of an arbitrary size, and then applies cross-attention with the
last hidden states of the latents, using the outputs as queries, and the latents as keys and values.`),mP.forEach(r),el=d(o),I=s(o,"P",{});var W=n(I);Yp=i(W,`So let\u2019s say one wants to perform masked language modeling (BERT-style) with the Perceiver. As the Perceiver\u2019s input
length will not have an impact on the computation time of the self-attention layers, one can provide raw bytes,
providing `),ua=s(W,"CODE",{});var hP=n(ua);Qp=i(hP,"inputs"),hP.forEach(r),em=i(W,` of length 2048 to the model. If one now masks out certain of these 2048 tokens, one can define the
`),fa=s(W,"CODE",{});var uP=n(fa);om=i(uP,"outputs"),uP.forEach(r),rm=i(W," as being of shape: "),ga=s(W,"CODE",{});var fP=n(ga);tm=i(fP,"(batch_size, 2048, 768)"),fP.forEach(r),sm=i(W,`. Next, one performs cross-attention with the final hidden states
of the latents to update the `),va=s(W,"CODE",{});var gP=n(va);nm=i(gP,"outputs"),gP.forEach(r),am=i(W," tensor. After cross-attention, one still has a tensor of shape "),_a=s(W,"CODE",{});var vP=n(_a);im=i(vP,"(batch_size, 2048, 768)"),vP.forEach(r),cm=i(W,`. One can then place a regular language modeling head on top, to project the last dimension to the
vocabulary size of the model, i.e. creating logits of shape `),Pa=s(W,"CODE",{});var _P=n(Pa);lm=i(_P,"(batch_size, 2048, 262)"),_P.forEach(r),dm=i(W,` (as Perceiver uses a vocabulary
size of 262 byte IDs).`),W.forEach(r),ol=d(o),Io=s(o,"IMG",{src:!0,alt:!0,width:!0}),rl=d(o),Vr=s(o,"SMALL",{});var sP=n(Vr);pm=i(sP,"Perceiver IO architecture. Taken from the "),Ys=s(sP,"A",{href:!0});var PP=n(Ys);mm=i(PP,"original paper"),PP.forEach(r),sP.forEach(r),tl=d(o),ve=s(o,"P",{});var Sn=n(ve);hm=i(Sn,"This model was contributed by "),Rr=s(Sn,"A",{href:!0,rel:!0});var bP=n(Rr);um=i(bP,"nielsr"),bP.forEach(r),fm=i(Sn,`. The original code can be found
`),Ur=s(Sn,"A",{href:!0,rel:!0});var wP=n(Ur);gm=i(wP,"here"),wP.forEach(r),vm=i(Sn,"."),Sn.forEach(r),sl=d(o),Qs=s(o,"P",{});var yP=n(Qs);_m=i(yP,"Tips:"),yP.forEach(r),nl=d(o),Mo=s(o,"UL",{});var gd=n(Mo);Kr=s(gd,"LI",{});var vd=n(Kr);Pm=i(vd,"The quickest way to get started with the Perceiver is by checking the "),Gr=s(vd,"A",{href:!0,rel:!0});var $P=n(Gr);bm=i($P,`tutorial
notebooks`),$P.forEach(r),wm=i(vd,"."),vd.forEach(r),ym=d(gd),Jr=s(gd,"LI",{});var _d=n(Jr);$m=i(_d,"Refer to the "),Xr=s(_d,"A",{href:!0,rel:!0});var kP=n(Xr);km=i(kP,"blog post"),kP.forEach(r),Tm=i(_d,` if you want to fully understand how the model works and
is implemented in the library. Note that the models available in the library only showcase some examples of what you can do
with the Perceiver. There are many more use cases, including question answering, named-entity recognition, object detection,
audio classification, video classification, etc.`),_d.forEach(r),gd.forEach(r),al=d(o),Zr=s(o,"P",{});var nP=n(Zr);ba=s(nP,"STRONG",{});var TP=n(ba);xm=i(TP,"Note"),TP.forEach(r),Em=i(nP,":"),nP.forEach(r),il=d(o),en=s(o,"UL",{});var xP=n(en);_e=s(xP,"LI",{});var Vs=n(_e);jm=i(Vs,"Perceiver does "),wa=s(Vs,"STRONG",{});var EP=n(wa);Cm=i(EP,"not"),EP.forEach(r),Fm=i(Vs," work with "),ya=s(Vs,"CODE",{});var jP=n(ya);Im=i(jP,"torch.nn.DataParallel"),jP.forEach(r),Mm=i(Vs," due to a bug in PyTorch, see "),Yr=s(Vs,"A",{href:!0,rel:!0});var CP=n(Yr);qm=i(CP,"issue #36035"),CP.forEach(r),Vs.forEach(r),xP.forEach(r),cl=d(o),ke=s(o,"H2",{class:!0});var Pd=n(ke);qo=s(Pd,"A",{id:!0,class:!0,href:!0});var FP=n(qo);$a=s(FP,"SPAN",{});var IP=n($a);P(Qr.$$.fragment,IP),IP.forEach(r),FP.forEach(r),zm=d(Pd),ka=s(Pd,"SPAN",{});var MP=n(ka);Am=i(MP,"Documentation resources"),MP.forEach(r),Pd.forEach(r),ll=d(o),Pe=s(o,"UL",{});var Bn=n(Pe);Ta=s(Bn,"LI",{});var qP=n(Ta);on=s(qP,"A",{href:!0});var zP=n(on);Dm=i(zP,"Text classification task guide"),zP.forEach(r),qP.forEach(r),Om=d(Bn),xa=s(Bn,"LI",{});var AP=n(xa);rn=s(AP,"A",{href:!0});var DP=n(rn);Nm=i(DP,"Masked language modeling task guide"),DP.forEach(r),AP.forEach(r),Lm=d(Bn),Ea=s(Bn,"LI",{});var OP=n(Ea);tn=s(OP,"A",{href:!0});var NP=n(tn);Sm=i(NP,"Image classification task guide"),NP.forEach(r),OP.forEach(r),Bn.forEach(r),dl=d(o),Te=s(o,"H2",{class:!0});var bd=n(Te);zo=s(bd,"A",{id:!0,class:!0,href:!0});var LP=n(zo);ja=s(LP,"SPAN",{});var SP=n(ja);P(et.$$.fragment,SP),SP.forEach(r),LP.forEach(r),Bm=d(bd),Ca=s(bd,"SPAN",{});var BP=n(Ca);Wm=i(BP,"Perceiver specific outputs"),BP.forEach(r),bd.forEach(r),pl=d(o),xe=s(o,"DIV",{class:!0});var wd=n(xe);P(ot.$$.fragment,wd),Hm=d(wd),Fa=s(wd,"P",{});var WP=n(Fa);Vm=i(WP,"Base class for Perceiver base model\u2019s outputs, with potential hidden states, attentions and cross-attentions."),WP.forEach(r),wd.forEach(r),ml=d(o),Ee=s(o,"DIV",{class:!0});var yd=n(Ee);P(rt.$$.fragment,yd),Rm=d(yd),Ia=s(yd,"P",{});var HP=n(Ia);Um=i(HP,"Base class for Perceiver decoder outputs, with potential cross-attentions."),HP.forEach(r),yd.forEach(r),hl=d(o),je=s(o,"DIV",{class:!0});var $d=n(je);P(tt.$$.fragment,$d),Km=d($d),Ma=s($d,"P",{});var VP=n(Ma);Gm=i(VP,"Base class for Perceiver\u2019s masked language model outputs."),VP.forEach(r),$d.forEach(r),ul=d(o),Ce=s(o,"DIV",{class:!0});var kd=n(Ce);P(st.$$.fragment,kd),Jm=d(kd),qa=s(kd,"P",{});var RP=n(qa);Xm=i(RP,`Base class for Perceiver\u2019s outputs of sequence/image classification models, optical flow and multimodal
autoencoding.`),RP.forEach(r),kd.forEach(r),fl=d(o),Fe=s(o,"H2",{class:!0});var Td=n(Fe);Ao=s(Td,"A",{id:!0,class:!0,href:!0});var UP=n(Ao);za=s(UP,"SPAN",{});var KP=n(za);P(nt.$$.fragment,KP),KP.forEach(r),UP.forEach(r),Zm=d(Td),Aa=s(Td,"SPAN",{});var GP=n(Aa);Ym=i(GP,"PerceiverConfig"),GP.forEach(r),Td.forEach(r),gl=d(o),H=s(o,"DIV",{class:!0});var Fr=n(H);P(at.$$.fragment,Fr),Qm=d(Fr),Ie=s(Fr,"P",{});var Wn=n(Ie);eh=i(Wn,"This is the configuration class to store the configuration of a "),sn=s(Wn,"A",{href:!0});var JP=n(sn);oh=i(JP,"PerceiverModel"),JP.forEach(r),rh=i(Wn,`. It is used to instantiate an
Perceiver model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Perceiver
`),it=s(Wn,"A",{href:!0,rel:!0});var XP=n(it);th=i(XP,"deepmind/language-perceiver"),XP.forEach(r),sh=i(Wn," architecture."),Wn.forEach(r),nh=d(Fr),Me=s(Fr,"P",{});var Hn=n(Me);ah=i(Hn,"Configuration objects inherit from "),nn=s(Hn,"A",{href:!0});var ZP=n(nn);ih=i(ZP,"PretrainedConfig"),ZP.forEach(r),ch=i(Hn,` and can be used to control the model outputs. Read the
documentation from `),an=s(Hn,"A",{href:!0});var YP=n(an);lh=i(YP,"PretrainedConfig"),YP.forEach(r),dh=i(Hn," for more information."),Hn.forEach(r),ph=d(Fr),P(Do.$$.fragment,Fr),Fr.forEach(r),vl=d(o),qe=s(o,"H2",{class:!0});var xd=n(qe);Oo=s(xd,"A",{id:!0,class:!0,href:!0});var QP=n(Oo);Da=s(QP,"SPAN",{});var eb=n(Da);P(ct.$$.fragment,eb),eb.forEach(r),QP.forEach(r),mh=d(xd),Oa=s(xd,"SPAN",{});var ob=n(Oa);hh=i(ob,"PerceiverTokenizer"),ob.forEach(r),xd.forEach(r),_l=d(o),V=s(o,"DIV",{class:!0});var Ir=n(V);P(lt.$$.fragment,Ir),uh=d(Ir),Na=s(Ir,"P",{});var rb=n(Na);fh=i(rb,"Construct a Perceiver tokenizer. The Perceiver simply uses raw bytes utf-8 encoding."),rb.forEach(r),gh=d(Ir),dt=s(Ir,"P",{});var Ed=n(dt);vh=i(Ed,"This tokenizer inherits from "),cn=s(Ed,"A",{href:!0});var tb=n(cn);_h=i(tb,"PreTrainedTokenizer"),tb.forEach(r),Ph=i(Ed,` which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`),Ed.forEach(r),bh=d(Ir),No=s(Ir,"DIV",{class:!0});var jd=n(No);P(pt.$$.fragment,jd),wh=d(jd),La=s(jd,"P",{});var sb=n(La);yh=i(sb,`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`),sb.forEach(r),jd.forEach(r),Ir.forEach(r),Pl=d(o),ze=s(o,"H2",{class:!0});var Cd=n(ze);Lo=s(Cd,"A",{id:!0,class:!0,href:!0});var nb=n(Lo);Sa=s(nb,"SPAN",{});var ab=n(Sa);P(mt.$$.fragment,ab),ab.forEach(r),nb.forEach(r),$h=d(Cd),Ba=s(Cd,"SPAN",{});var ib=n(Ba);kh=i(ib,"PerceiverFeatureExtractor"),ib.forEach(r),Cd.forEach(r),bl=d(o),Ae=s(o,"DIV",{class:!0});var Fd=n(Ae);P(ht.$$.fragment,Fd),Th=d(Fd),So=s(Fd,"DIV",{class:!0});var Id=n(So);P(ut.$$.fragment,Id),xh=d(Id),Wa=s(Id,"P",{});var cb=n(Wa);Eh=i(cb,"Preprocess an image or a batch of images."),cb.forEach(r),Id.forEach(r),Fd.forEach(r),wl=d(o),De=s(o,"H2",{class:!0});var Md=n(De);Bo=s(Md,"A",{id:!0,class:!0,href:!0});var lb=n(Bo);Ha=s(lb,"SPAN",{});var db=n(Ha);P(ft.$$.fragment,db),db.forEach(r),lb.forEach(r),jh=d(Md),Va=s(Md,"SPAN",{});var pb=n(Va);Ch=i(pb,"PerceiverImageProcessor"),pb.forEach(r),Md.forEach(r),yl=d(o),ne=s(o,"DIV",{class:!0});var Vn=n(ne);P(gt.$$.fragment,Vn),Fh=d(Vn),Ra=s(Vn,"P",{});var mb=n(Ra);Ih=i(mb,"Constructs a Perceiver image processor."),mb.forEach(r),Mh=d(Vn),Wo=s(Vn,"DIV",{class:!0});var qd=n(Wo);P(vt.$$.fragment,qd),qh=d(qd),Ua=s(qd,"P",{});var hb=n(Ua);zh=i(hb,"Preprocess an image or batch of images."),hb.forEach(r),qd.forEach(r),Vn.forEach(r),$l=d(o),Oe=s(o,"H2",{class:!0});var zd=n(Oe);Ho=s(zd,"A",{id:!0,class:!0,href:!0});var ub=n(Ho);Ka=s(ub,"SPAN",{});var fb=n(Ka);P(_t.$$.fragment,fb),fb.forEach(r),ub.forEach(r),Ah=d(zd),Ga=s(zd,"SPAN",{});var gb=n(Ga);Dh=i(gb,"PerceiverTextPreprocessor"),gb.forEach(r),zd.forEach(r),kl=d(o),ae=s(o,"DIV",{class:!0});var Rn=n(ae);P(Pt.$$.fragment,Rn),Oh=d(Rn),bt=s(Rn,"P",{});var Ad=n(bt);Nh=i(Ad,"Text preprocessing for Perceiver Encoder. Can be used to embed "),Ja=s(Ad,"CODE",{});var vb=n(Ja);Lh=i(vb,"inputs"),vb.forEach(r),Sh=i(Ad," and add positional encodings."),Ad.forEach(r),Bh=d(Rn),wt=s(Rn,"P",{});var Dd=n(wt);Wh=i(Dd,"The dimensionality of the embeddings is determined by the "),Xa=s(Dd,"CODE",{});var _b=n(Xa);Hh=i(_b,"d_model"),_b.forEach(r),Vh=i(Dd," attribute of the configuration."),Dd.forEach(r),Rn.forEach(r),Tl=d(o),Ne=s(o,"H2",{class:!0});var Od=n(Ne);Vo=s(Od,"A",{id:!0,class:!0,href:!0});var Pb=n(Vo);Za=s(Pb,"SPAN",{});var bb=n(Za);P(yt.$$.fragment,bb),bb.forEach(r),Pb.forEach(r),Rh=d(Od),Ya=s(Od,"SPAN",{});var wb=n(Ya);Uh=i(wb,"PerceiverImagePreprocessor"),wb.forEach(r),Od.forEach(r),xl=d(o),ie=s(o,"DIV",{class:!0});var Un=n(ie);P($t.$$.fragment,Un),Kh=d(Un),Qa=s(Un,"P",{});var yb=n(Qa);Gh=i(yb,"Image preprocessing for Perceiver Encoder."),yb.forEach(r),Jh=d(Un),R=s(Un,"P",{});var we=n(R);Xh=i(we,"Note: the "),ei=s(we,"EM",{});var $b=n(ei);Zh=i($b,"out_channels"),$b.forEach(r),Yh=i(we," argument refers to the output channels of a convolutional layer, if "),oi=s(we,"EM",{});var kb=n(oi);Qh=i(kb,"prep_type"),kb.forEach(r),eu=i(we,` is set to
\u201Cconv1x1\u201D or \u201Cconv\u201D. If one adds absolute position embeddings, one must make sure the `),ri=s(we,"EM",{});var Tb=n(ri);ou=i(Tb,"num_channels"),Tb.forEach(r),ru=i(we,` of the
position encoding kwargs are set equal to the `),ti=s(we,"EM",{});var xb=n(ti);tu=i(xb,"out_channels"),xb.forEach(r),su=i(we,"."),we.forEach(r),Un.forEach(r),El=d(o),Le=s(o,"H2",{class:!0});var Nd=n(Le);Ro=s(Nd,"A",{id:!0,class:!0,href:!0});var Eb=n(Ro);si=s(Eb,"SPAN",{});var jb=n(si);P(kt.$$.fragment,jb),jb.forEach(r),Eb.forEach(r),nu=d(Nd),ni=s(Nd,"SPAN",{});var Cb=n(ni);au=i(Cb,"PerceiverOneHotPreprocessor"),Cb.forEach(r),Nd.forEach(r),jl=d(o),Se=s(o,"DIV",{class:!0});var Ld=n(Se);P(Tt.$$.fragment,Ld),iu=d(Ld),ai=s(Ld,"P",{});var Fb=n(ai);cu=i(Fb,"One-hot preprocessor for Perceiver Encoder. Can be used to add a dummy index dimension to the input."),Fb.forEach(r),Ld.forEach(r),Cl=d(o),Be=s(o,"H2",{class:!0});var Sd=n(Be);Uo=s(Sd,"A",{id:!0,class:!0,href:!0});var Ib=n(Uo);ii=s(Ib,"SPAN",{});var Mb=n(ii);P(xt.$$.fragment,Mb),Mb.forEach(r),Ib.forEach(r),lu=d(Sd),ci=s(Sd,"SPAN",{});var qb=n(ci);du=i(qb,"PerceiverAudioPreprocessor"),qb.forEach(r),Sd.forEach(r),Fl=d(o),We=s(o,"DIV",{class:!0});var Bd=n(We);P(Et.$$.fragment,Bd),pu=d(Bd),li=s(Bd,"P",{});var zb=n(li);mu=i(zb,"Audio preprocessing for Perceiver Encoder."),zb.forEach(r),Bd.forEach(r),Il=d(o),He=s(o,"H2",{class:!0});var Wd=n(He);Ko=s(Wd,"A",{id:!0,class:!0,href:!0});var Ab=n(Ko);di=s(Ab,"SPAN",{});var Db=n(di);P(jt.$$.fragment,Db),Db.forEach(r),Ab.forEach(r),hu=d(Wd),pi=s(Wd,"SPAN",{});var Ob=n(pi);uu=i(Ob,"PerceiverMultimodalPreprocessor"),Ob.forEach(r),Wd.forEach(r),Ml=d(o),ce=s(o,"DIV",{class:!0});var Kn=n(ce);P(Ct.$$.fragment,Kn),fu=d(Kn),mi=s(Kn,"P",{});var Nb=n(mi);gu=i(Nb,"Multimodal preprocessing for Perceiver Encoder."),Nb.forEach(r),vu=d(Kn),hi=s(Kn,"P",{});var Lb=n(hi);_u=i(Lb,`Inputs for each modality are preprocessed, then padded with trainable position embeddings to have the same number
of channels.`),Lb.forEach(r),Kn.forEach(r),ql=d(o),Ve=s(o,"H2",{class:!0});var Hd=n(Ve);Go=s(Hd,"A",{id:!0,class:!0,href:!0});var Sb=n(Go);ui=s(Sb,"SPAN",{});var Bb=n(ui);P(Ft.$$.fragment,Bb),Bb.forEach(r),Sb.forEach(r),Pu=d(Hd),fi=s(Hd,"SPAN",{});var Wb=n(fi);bu=i(Wb,"PerceiverProjectionDecoder"),Wb.forEach(r),Hd.forEach(r),zl=d(o),Re=s(o,"DIV",{class:!0});var Vd=n(Re);P(It.$$.fragment,Vd),wu=d(Vd),gi=s(Vd,"P",{});var Hb=n(gi);yu=i(Hb,"Baseline projection decoder (no cross-attention)."),Hb.forEach(r),Vd.forEach(r),Al=d(o),Ue=s(o,"H2",{class:!0});var Rd=n(Ue);Jo=s(Rd,"A",{id:!0,class:!0,href:!0});var Vb=n(Jo);vi=s(Vb,"SPAN",{});var Rb=n(vi);P(Mt.$$.fragment,Rb),Rb.forEach(r),Vb.forEach(r),$u=d(Rd),_i=s(Rd,"SPAN",{});var Ub=n(_i);ku=i(Ub,"PerceiverBasicDecoder"),Ub.forEach(r),Rd.forEach(r),Dl=d(o),le=s(o,"DIV",{class:!0});var Gn=n(le);P(qt.$$.fragment,Gn),Tu=d(Gn),Pi=s(Gn,"P",{});var Kb=n(Pi);xu=i(Kb,`Cross-attention-based decoder. This class can be used to decode the final hidden states of the latents using a
cross-attention operation, in which the latents produce keys and values.`),Kb.forEach(r),Eu=d(Gn),bi=s(Gn,"P",{});var Gb=n(bi);ju=i(Gb,"The shape of the output of this class depends on how one defines the output queries (also called decoder queries)."),Gb.forEach(r),Gn.forEach(r),Ol=d(o),Ke=s(o,"H2",{class:!0});var Ud=n(Ke);Xo=s(Ud,"A",{id:!0,class:!0,href:!0});var Jb=n(Xo);wi=s(Jb,"SPAN",{});var Xb=n(wi);P(zt.$$.fragment,Xb),Xb.forEach(r),Jb.forEach(r),Cu=d(Ud),yi=s(Ud,"SPAN",{});var Zb=n(yi);Fu=i(Zb,"PerceiverClassificationDecoder"),Zb.forEach(r),Ud.forEach(r),Nl=d(o),Ge=s(o,"DIV",{class:!0});var Kd=n(Ge);P(At.$$.fragment,Kd),Iu=d(Kd),Dt=s(Kd,"P",{});var Gd=n(Dt);Mu=i(Gd,"Cross-attention based classification decoder. Light-weight wrapper of "),$i=s(Gd,"CODE",{});var Yb=n($i);qu=i(Yb,"PerceiverBasicDecoder"),Yb.forEach(r),zu=i(Gd,` for logit output.
Will turn the output of the Perceiver encoder which is of shape (batch_size, num_latents, d_latents) to a tensor of
shape (batch_size, num_labels). The queries are of shape (batch_size, 1, num_labels).`),Gd.forEach(r),Kd.forEach(r),Ll=d(o),Je=s(o,"H2",{class:!0});var Jd=n(Je);Zo=s(Jd,"A",{id:!0,class:!0,href:!0});var Qb=n(Zo);ki=s(Qb,"SPAN",{});var e1=n(ki);P(Ot.$$.fragment,e1),e1.forEach(r),Qb.forEach(r),Au=d(Jd),Ti=s(Jd,"SPAN",{});var o1=n(Ti);Du=i(o1,"PerceiverOpticalFlowDecoder"),o1.forEach(r),Jd.forEach(r),Sl=d(o),Xe=s(o,"DIV",{class:!0});var Xd=n(Xe);P(Nt.$$.fragment,Xd),Ou=d(Xd),xi=s(Xd,"P",{});var r1=n(xi);Nu=i(r1,"Cross-attention based optical flow decoder."),r1.forEach(r),Xd.forEach(r),Bl=d(o),Ze=s(o,"H2",{class:!0});var Zd=n(Ze);Yo=s(Zd,"A",{id:!0,class:!0,href:!0});var t1=n(Yo);Ei=s(t1,"SPAN",{});var s1=n(Ei);P(Lt.$$.fragment,s1),s1.forEach(r),t1.forEach(r),Lu=d(Zd),ji=s(Zd,"SPAN",{});var n1=n(ji);Su=i(n1,"PerceiverBasicVideoAutoencodingDecoder"),n1.forEach(r),Zd.forEach(r),Wl=d(o),Ye=s(o,"DIV",{class:!0});var Yd=n(Ye);P(St.$$.fragment,Yd),Bu=d(Yd),Bt=s(Yd,"P",{});var Qd=n(Bt);Wu=i(Qd,"Cross-attention based video-autoencoding decoder. Light-weight wrapper of ["),Ci=s(Qd,"EM",{});var a1=n(Ci);Hu=i(a1,"PerceiverBasicDecoder"),a1.forEach(r),Vu=i(Qd,`] with video
reshaping logic.`),Qd.forEach(r),Yd.forEach(r),Hl=d(o),Qe=s(o,"H2",{class:!0});var ep=n(Qe);Qo=s(ep,"A",{id:!0,class:!0,href:!0});var i1=n(Qo);Fi=s(i1,"SPAN",{});var c1=n(Fi);P(Wt.$$.fragment,c1),c1.forEach(r),i1.forEach(r),Ru=d(ep),Ii=s(ep,"SPAN",{});var l1=n(Ii);Uu=i(l1,"PerceiverMultimodalDecoder"),l1.forEach(r),ep.forEach(r),Vl=d(o),de=s(o,"DIV",{class:!0});var Jn=n(de);P(Ht.$$.fragment,Jn),Ku=d(Jn),Vt=s(Jn,"P",{});var op=n(Vt);Gu=i(op,"Multimodal decoding by composing uni-modal decoders. The "),Mi=s(op,"EM",{});var d1=n(Mi);Ju=i(d1,"modalities"),d1.forEach(r),Xu=i(op,` argument of the constructor is a dictionary
mapping modality name to the decoder of that modality. That decoder will be used to construct queries for that
modality. Modality-specific queries are padded with trainable modality-specific parameters, after which they are
concatenated along the time dimension.`),op.forEach(r),Zu=d(Jn),qi=s(Jn,"P",{});var p1=n(qi);Yu=i(p1,"Next, there is a shared cross attention operation across all modalities."),p1.forEach(r),Jn.forEach(r),Rl=d(o),eo=s(o,"H2",{class:!0});var rp=n(eo);er=s(rp,"A",{id:!0,class:!0,href:!0});var m1=n(er);zi=s(m1,"SPAN",{});var h1=n(zi);P(Rt.$$.fragment,h1),h1.forEach(r),m1.forEach(r),Qu=d(rp),Ai=s(rp,"SPAN",{});var u1=n(Ai);ef=i(u1,"PerceiverProjectionPostprocessor"),u1.forEach(r),rp.forEach(r),Ul=d(o),oo=s(o,"DIV",{class:!0});var tp=n(oo);P(Ut.$$.fragment,tp),of=d(tp),Di=s(tp,"P",{});var f1=n(Di);rf=i(f1,`Projection postprocessing for Perceiver. Can be used to project the channels of the decoder output to a lower
dimension.`),f1.forEach(r),tp.forEach(r),Kl=d(o),ro=s(o,"H2",{class:!0});var sp=n(ro);or=s(sp,"A",{id:!0,class:!0,href:!0});var g1=n(or);Oi=s(g1,"SPAN",{});var v1=n(Oi);P(Kt.$$.fragment,v1),v1.forEach(r),g1.forEach(r),tf=d(sp),Ni=s(sp,"SPAN",{});var _1=n(Ni);sf=i(_1,"PerceiverAudioPostprocessor"),_1.forEach(r),sp.forEach(r),Gl=d(o),to=s(o,"DIV",{class:!0});var np=n(to);P(Gt.$$.fragment,np),nf=d(np),Li=s(np,"P",{});var P1=n(Li);af=i(P1,"Audio postprocessing for Perceiver. Can be used to convert the decoder output to audio features."),P1.forEach(r),np.forEach(r),Jl=d(o),so=s(o,"H2",{class:!0});var ap=n(so);rr=s(ap,"A",{id:!0,class:!0,href:!0});var b1=n(rr);Si=s(b1,"SPAN",{});var w1=n(Si);P(Jt.$$.fragment,w1),w1.forEach(r),b1.forEach(r),cf=d(ap),Bi=s(ap,"SPAN",{});var y1=n(Bi);lf=i(y1,"PerceiverClassificationPostprocessor"),y1.forEach(r),ap.forEach(r),Xl=d(o),no=s(o,"DIV",{class:!0});var ip=n(no);P(Xt.$$.fragment,ip),df=d(ip),Wi=s(ip,"P",{});var $1=n(Wi);pf=i($1,"Classification postprocessing for Perceiver. Can be used to convert the decoder output to classification logits."),$1.forEach(r),ip.forEach(r),Zl=d(o),ao=s(o,"H2",{class:!0});var cp=n(ao);tr=s(cp,"A",{id:!0,class:!0,href:!0});var k1=n(tr);Hi=s(k1,"SPAN",{});var T1=n(Hi);P(Zt.$$.fragment,T1),T1.forEach(r),k1.forEach(r),mf=d(cp),Vi=s(cp,"SPAN",{});var x1=n(Vi);hf=i(x1,"PerceiverMultimodalPostprocessor"),x1.forEach(r),cp.forEach(r),Yl=d(o),io=s(o,"DIV",{class:!0});var lp=n(io);P(Yt.$$.fragment,lp),uf=d(lp),Ri=s(lp,"P",{});var E1=n(Ri);ff=i(E1,`Multimodal postprocessing for Perceiver. Can be used to combine modality-specific postprocessors into a single
postprocessor.`),E1.forEach(r),lp.forEach(r),Ql=d(o),co=s(o,"H2",{class:!0});var dp=n(co);sr=s(dp,"A",{id:!0,class:!0,href:!0});var j1=n(sr);Ui=s(j1,"SPAN",{});var C1=n(Ui);P(Qt.$$.fragment,C1),C1.forEach(r),j1.forEach(r),gf=d(dp),Ki=s(dp,"SPAN",{});var F1=n(Ki);vf=i(F1,"PerceiverModel"),F1.forEach(r),dp.forEach(r),ed=d(o),pe=s(o,"DIV",{class:!0});var Xn=n(pe);P(es.$$.fragment,Xn),_f=d(Xn),os=s(Xn,"P",{});var pp=n(os);Pf=i(pp,`The Perceiver: a scalable, fully attentional architecture.
This model is a PyTorch `),rs=s(pp,"A",{href:!0,rel:!0});var I1=n(rs);bf=i(I1,"torch.nn.Module"),I1.forEach(r),wf=i(pp,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),pp.forEach(r),yf=d(Xn),U=s(Xn,"DIV",{class:!0});var Mr=n(U);P(ts.$$.fragment,Mr),$f=d(Mr),lo=s(Mr,"P",{});var Zn=n(lo);kf=i(Zn,"The "),ln=s(Zn,"A",{href:!0});var M1=n(ln);Tf=i(M1,"PerceiverModel"),M1.forEach(r),xf=i(Zn," forward method, overrides the "),Gi=s(Zn,"CODE",{});var q1=n(Gi);Ef=i(q1,"__call__"),q1.forEach(r),jf=i(Zn," special method."),Zn.forEach(r),Cf=d(Mr),P(nr.$$.fragment,Mr),Ff=d(Mr),P(ar.$$.fragment,Mr),Mr.forEach(r),Xn.forEach(r),od=d(o),po=s(o,"H2",{class:!0});var mp=n(po);ir=s(mp,"A",{id:!0,class:!0,href:!0});var z1=n(ir);Ji=s(z1,"SPAN",{});var A1=n(Ji);P(ss.$$.fragment,A1),A1.forEach(r),z1.forEach(r),If=d(mp),Xi=s(mp,"SPAN",{});var D1=n(Xi);Mf=i(D1,"PerceiverForMaskedLM"),D1.forEach(r),mp.forEach(r),rd=d(o),me=s(o,"DIV",{class:!0});var Yn=n(me);P(ns.$$.fragment,Yn),qf=d(Yn),as=s(Yn,"P",{});var hp=n(as);zf=i(hp,`Example use of Perceiver for masked language modeling.
This model is a PyTorch `),is=s(hp,"A",{href:!0,rel:!0});var O1=n(is);Af=i(O1,"torch.nn.Module"),O1.forEach(r),Df=i(hp,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),hp.forEach(r),Of=d(Yn),K=s(Yn,"DIV",{class:!0});var qr=n(K);P(cs.$$.fragment,qr),Nf=d(qr),mo=s(qr,"P",{});var Qn=n(mo);Lf=i(Qn,"The "),dn=s(Qn,"A",{href:!0});var N1=n(dn);Sf=i(N1,"PerceiverForMaskedLM"),N1.forEach(r),Bf=i(Qn," forward method, overrides the "),Zi=s(Qn,"CODE",{});var L1=n(Zi);Wf=i(L1,"__call__"),L1.forEach(r),Hf=i(Qn," special method."),Qn.forEach(r),Vf=d(qr),P(cr.$$.fragment,qr),Rf=d(qr),P(lr.$$.fragment,qr),qr.forEach(r),Yn.forEach(r),td=d(o),ho=s(o,"H2",{class:!0});var up=n(ho);dr=s(up,"A",{id:!0,class:!0,href:!0});var S1=n(dr);Yi=s(S1,"SPAN",{});var B1=n(Yi);P(ls.$$.fragment,B1),B1.forEach(r),S1.forEach(r),Uf=d(up),Qi=s(up,"SPAN",{});var W1=n(Qi);Kf=i(W1,"PerceiverForSequenceClassification"),W1.forEach(r),up.forEach(r),sd=d(o),he=s(o,"DIV",{class:!0});var ea=n(he);P(ds.$$.fragment,ea),Gf=d(ea),ps=s(ea,"P",{});var fp=n(ps);Jf=i(fp,`Example use of Perceiver for text classification.
This model is a PyTorch `),ms=s(fp,"A",{href:!0,rel:!0});var H1=n(ms);Xf=i(H1,"torch.nn.Module"),H1.forEach(r),Zf=i(fp,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),fp.forEach(r),Yf=d(ea),G=s(ea,"DIV",{class:!0});var zr=n(G);P(hs.$$.fragment,zr),Qf=d(zr),uo=s(zr,"P",{});var oa=n(uo);eg=i(oa,"The "),pn=s(oa,"A",{href:!0});var V1=n(pn);og=i(V1,"PerceiverForSequenceClassification"),V1.forEach(r),rg=i(oa," forward method, overrides the "),ec=s(oa,"CODE",{});var R1=n(ec);tg=i(R1,"__call__"),R1.forEach(r),sg=i(oa," special method."),oa.forEach(r),ng=d(zr),P(pr.$$.fragment,zr),ag=d(zr),P(mr.$$.fragment,zr),zr.forEach(r),ea.forEach(r),nd=d(o),fo=s(o,"H2",{class:!0});var gp=n(fo);hr=s(gp,"A",{id:!0,class:!0,href:!0});var U1=n(hr);oc=s(U1,"SPAN",{});var K1=n(oc);P(us.$$.fragment,K1),K1.forEach(r),U1.forEach(r),ig=d(gp),rc=s(gp,"SPAN",{});var G1=n(rc);cg=i(G1,"PerceiverForImageClassificationLearned"),G1.forEach(r),gp.forEach(r),ad=d(o),q=s(o,"DIV",{class:!0});var oe=n(q);P(fs.$$.fragment,oe),lg=d(oe),tc=s(oe,"P",{});var J1=n(tc);dg=i(J1,"Example use of Perceiver for image classification, for tasks such as ImageNet."),J1.forEach(r),pg=d(oe),sc=s(oe,"P",{});var X1=n(sc);mg=i(X1,`This model uses learned position embeddings. In other words, this model is not given any privileged information about
the structure of images. As shown in the paper, this model can achieve a top-1 accuracy of 72.7 on ImageNet.`),X1.forEach(r),hg=d(oe),L=s(oe,"P",{});var ue=n(L);mn=s(ue,"A",{href:!0});var Z1=n(mn);ug=i(Z1,"PerceiverForImageClassificationLearned"),Z1.forEach(r),fg=i(ue," uses "),hn=s(ue,"A",{href:!0});var Y1=n(hn);gg=i(Y1,"PerceiverImagePreprocessor"),Y1.forEach(r),vg=i(ue,`
(with `),nc=s(ue,"CODE",{});var Q1=n(nc);_g=i(Q1,'prep_type="conv1x1"'),Q1.forEach(r),Pg=i(ue,`) to preprocess the input images, and
`),un=s(ue,"A",{href:!0});var e2=n(un);bg=i(e2,"PerceiverClassificationDecoder"),e2.forEach(r),wg=i(ue,` to decode the latent representation of
`),fn=s(ue,"A",{href:!0});var o2=n(fn);yg=i(o2,"PerceiverModel"),o2.forEach(r),$g=i(ue," into classification logits."),ue.forEach(r),kg=d(oe),gs=s(oe,"P",{});var vp=n(gs);Tg=i(vp,"This model is a PyTorch "),vs=s(vp,"A",{href:!0,rel:!0});var r2=n(vs);xg=i(r2,"torch.nn.Module"),r2.forEach(r),Eg=i(vp,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),vp.forEach(r),jg=d(oe),J=s(oe,"DIV",{class:!0});var Ar=n(J);P(_s.$$.fragment,Ar),Cg=d(Ar),go=s(Ar,"P",{});var ra=n(go);Fg=i(ra,"The "),gn=s(ra,"A",{href:!0});var t2=n(gn);Ig=i(t2,"PerceiverForImageClassificationLearned"),t2.forEach(r),Mg=i(ra," forward method, overrides the "),ac=s(ra,"CODE",{});var s2=n(ac);qg=i(s2,"__call__"),s2.forEach(r),zg=i(ra," special method."),ra.forEach(r),Ag=d(Ar),P(ur.$$.fragment,Ar),Dg=d(Ar),P(fr.$$.fragment,Ar),Ar.forEach(r),oe.forEach(r),id=d(o),vo=s(o,"H2",{class:!0});var _p=n(vo);gr=s(_p,"A",{id:!0,class:!0,href:!0});var n2=n(gr);ic=s(n2,"SPAN",{});var a2=n(ic);P(Ps.$$.fragment,a2),a2.forEach(r),n2.forEach(r),Og=d(_p),cc=s(_p,"SPAN",{});var i2=n(cc);Ng=i(i2,"PerceiverForImageClassificationFourier"),i2.forEach(r),_p.forEach(r),cd=d(o),z=s(o,"DIV",{class:!0});var re=n(z);P(bs.$$.fragment,re),Lg=d(re),lc=s(re,"P",{});var c2=n(lc);Sg=i(c2,"Example use of Perceiver for image classification, for tasks such as ImageNet."),c2.forEach(r),Bg=d(re),dc=s(re,"P",{});var l2=n(dc);Wg=i(l2,`This model uses fixed 2D Fourier position embeddings. As shown in the paper, this model can achieve a top-1 accuracy of
79.0 on ImageNet, and 84.5 when pre-trained on a large-scale dataset (i.e. JFT).`),l2.forEach(r),Hg=d(re),S=s(re,"P",{});var fe=n(S);vn=s(fe,"A",{href:!0});var d2=n(vn);Vg=i(d2,"PerceiverForImageClassificationLearned"),d2.forEach(r),Rg=i(fe," uses "),_n=s(fe,"A",{href:!0});var p2=n(_n);Ug=i(p2,"PerceiverImagePreprocessor"),p2.forEach(r),Kg=i(fe,`
(with `),pc=s(fe,"CODE",{});var m2=n(pc);Gg=i(m2,'prep_type="pixels"'),m2.forEach(r),Jg=i(fe,`) to preprocess the input images, and
`),Pn=s(fe,"A",{href:!0});var h2=n(Pn);Xg=i(h2,"PerceiverClassificationDecoder"),h2.forEach(r),Zg=i(fe,` to decode the latent representation of
`),bn=s(fe,"A",{href:!0});var u2=n(bn);Yg=i(u2,"PerceiverModel"),u2.forEach(r),Qg=i(fe," into classification logits."),fe.forEach(r),ev=d(re),ws=s(re,"P",{});var Pp=n(ws);ov=i(Pp,"This model is a PyTorch "),ys=s(Pp,"A",{href:!0,rel:!0});var f2=n(ys);rv=i(f2,"torch.nn.Module"),f2.forEach(r),tv=i(Pp,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Pp.forEach(r),sv=d(re),X=s(re,"DIV",{class:!0});var Dr=n(X);P($s.$$.fragment,Dr),nv=d(Dr),_o=s(Dr,"P",{});var ta=n(_o);av=i(ta,"The "),wn=s(ta,"A",{href:!0});var g2=n(wn);iv=i(g2,"PerceiverForImageClassificationFourier"),g2.forEach(r),cv=i(ta," forward method, overrides the "),mc=s(ta,"CODE",{});var v2=n(mc);lv=i(v2,"__call__"),v2.forEach(r),dv=i(ta," special method."),ta.forEach(r),pv=d(Dr),P(vr.$$.fragment,Dr),mv=d(Dr),P(_r.$$.fragment,Dr),Dr.forEach(r),re.forEach(r),ld=d(o),Po=s(o,"H2",{class:!0});var bp=n(Po);Pr=s(bp,"A",{id:!0,class:!0,href:!0});var _2=n(Pr);hc=s(_2,"SPAN",{});var P2=n(hc);P(ks.$$.fragment,P2),P2.forEach(r),_2.forEach(r),hv=d(bp),uc=s(bp,"SPAN",{});var b2=n(uc);uv=i(b2,"PerceiverForImageClassificationConvProcessing"),b2.forEach(r),bp.forEach(r),dd=d(o),A=s(o,"DIV",{class:!0});var te=n(A);P(Ts.$$.fragment,te),fv=d(te),fc=s(te,"P",{});var w2=n(fc);gv=i(w2,"Example use of Perceiver for image classification, for tasks such as ImageNet."),w2.forEach(r),vv=d(te),gc=s(te,"P",{});var y2=n(gc);_v=i(y2,`This model uses a 2D conv+maxpool preprocessing network. As shown in the paper, this model can achieve a top-1 accuracy
of 82.1 on ImageNet.`),y2.forEach(r),Pv=d(te),B=s(te,"P",{});var ge=n(B);yn=s(ge,"A",{href:!0});var $2=n(yn);bv=i($2,"PerceiverForImageClassificationLearned"),$2.forEach(r),wv=i(ge," uses "),$n=s(ge,"A",{href:!0});var k2=n($n);yv=i(k2,"PerceiverImagePreprocessor"),k2.forEach(r),$v=i(ge,`
(with `),vc=s(ge,"CODE",{});var T2=n(vc);kv=i(T2,'prep_type="conv"'),T2.forEach(r),Tv=i(ge,`) to preprocess the input images, and
`),kn=s(ge,"A",{href:!0});var x2=n(kn);xv=i(x2,"PerceiverClassificationDecoder"),x2.forEach(r),Ev=i(ge,` to decode the latent representation of
`),Tn=s(ge,"A",{href:!0});var E2=n(Tn);jv=i(E2,"PerceiverModel"),E2.forEach(r),Cv=i(ge," into classification logits."),ge.forEach(r),Fv=d(te),xs=s(te,"P",{});var wp=n(xs);Iv=i(wp,"This model is a PyTorch "),Es=s(wp,"A",{href:!0,rel:!0});var j2=n(Es);Mv=i(j2,"torch.nn.Module"),j2.forEach(r),qv=i(wp,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),wp.forEach(r),zv=d(te),Z=s(te,"DIV",{class:!0});var Or=n(Z);P(js.$$.fragment,Or),Av=d(Or),bo=s(Or,"P",{});var sa=n(bo);Dv=i(sa,"The "),xn=s(sa,"A",{href:!0});var C2=n(xn);Ov=i(C2,"PerceiverForImageClassificationConvProcessing"),C2.forEach(r),Nv=i(sa," forward method, overrides the "),_c=s(sa,"CODE",{});var F2=n(_c);Lv=i(F2,"__call__"),F2.forEach(r),Sv=i(sa," special method."),sa.forEach(r),Bv=d(Or),P(br.$$.fragment,Or),Wv=d(Or),P(wr.$$.fragment,Or),Or.forEach(r),te.forEach(r),pd=d(o),wo=s(o,"H2",{class:!0});var yp=n(wo);yr=s(yp,"A",{id:!0,class:!0,href:!0});var I2=n(yr);Pc=s(I2,"SPAN",{});var M2=n(Pc);P(Cs.$$.fragment,M2),M2.forEach(r),I2.forEach(r),Hv=d(yp),bc=s(yp,"SPAN",{});var q2=n(bc);Vv=i(q2,"PerceiverForOpticalFlow"),q2.forEach(r),yp.forEach(r),md=d(o),O=s(o,"DIV",{class:!0});var ye=n(O);P(Fs.$$.fragment,ye),Rv=d(ye),N=s(ye,"P",{});var se=n(N);Uv=i(se,"Example use of Perceiver for optical flow, for tasks such as Sintel and KITTI. "),En=s(se,"A",{href:!0});var z2=n(En);Kv=i(z2,"PerceiverForOpticalFlow"),z2.forEach(r),Gv=i(se,` uses
`),jn=s(se,"A",{href:!0});var A2=n(jn);Jv=i(A2,"PerceiverImagePreprocessor"),A2.forEach(r),Xv=i(se," (with "),wc=s(se,"EM",{});var D2=n(wc);Zv=i(D2,"prep_type=\u201Cpatches\u201D"),D2.forEach(r),Yv=i(se,`) to preprocess the
input images, and `),Cn=s(se,"A",{href:!0});var O2=n(Cn);Qv=i(O2,"PerceiverOpticalFlowDecoder"),O2.forEach(r),e_=i(se,` to decode the latent
representation of `),Fn=s(se,"A",{href:!0});var N2=n(Fn);o_=i(N2,"PerceiverModel"),N2.forEach(r),r_=i(se,"."),se.forEach(r),t_=d(ye),yc=s(ye,"P",{});var L2=n(yc);s_=i(L2,`As input, one concatenates 2 subsequent frames along the channel dimension and extract a 3 x 3 patch around each pixel
(leading to 3 x 3 x 3 x 2 = 54 values for each pixel). Fixed Fourier position encodings are used to encode the position
of each pixel in the patch. Next, one applies the Perceiver encoder. To decode, one queries the latent representation
using the same encoding used for the input.`),L2.forEach(r),n_=d(ye),Is=s(ye,"P",{});var $p=n(Is);a_=i($p,"This model is a PyTorch "),Ms=s($p,"A",{href:!0,rel:!0});var S2=n(Ms);i_=i(S2,"torch.nn.Module"),S2.forEach(r),c_=i($p,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),$p.forEach(r),l_=d(ye),Y=s(ye,"DIV",{class:!0});var Nr=n(Y);P(qs.$$.fragment,Nr),d_=d(Nr),yo=s(Nr,"P",{});var na=n(yo);p_=i(na,"The "),In=s(na,"A",{href:!0});var B2=n(In);m_=i(B2,"PerceiverForOpticalFlow"),B2.forEach(r),h_=i(na," forward method, overrides the "),$c=s(na,"CODE",{});var W2=n($c);u_=i(W2,"__call__"),W2.forEach(r),f_=i(na," special method."),na.forEach(r),g_=d(Nr),P($r.$$.fragment,Nr),v_=d(Nr),P(kr.$$.fragment,Nr),Nr.forEach(r),ye.forEach(r),hd=d(o),$o=s(o,"H2",{class:!0});var kp=n($o);Tr=s(kp,"A",{id:!0,class:!0,href:!0});var H2=n(Tr);kc=s(H2,"SPAN",{});var V2=n(kc);P(zs.$$.fragment,V2),V2.forEach(r),H2.forEach(r),__=d(kp),Tc=s(kp,"SPAN",{});var R2=n(Tc);P_=i(R2,"PerceiverForMultimodalAutoencoding"),R2.forEach(r),kp.forEach(r),ud=d(o),F=s(o,"DIV",{class:!0});var M=n(F);P(As.$$.fragment,M),b_=d(M),xc=s(M,"P",{});var U2=n(xc);w_=i(U2,"Example use of Perceiver for multimodal (video) autoencoding, for tasks such as Kinetics-700."),U2.forEach(r),y_=d(M),xr=s(M,"P",{});var Hc=n(xr);Mn=s(Hc,"A",{href:!0});var K2=n(Mn);$_=i(K2,"PerceiverForMultimodalAutoencoding"),K2.forEach(r),k_=i(Hc," uses "),qn=s(Hc,"A",{href:!0});var G2=n(qn);T_=i(G2,"PerceiverMultimodalPreprocessor"),G2.forEach(r),x_=i(Hc,` to
preprocess the 3 modalities: images, audio and class labels. This preprocessor uses modality-specific preprocessors to
preprocess every modality separately, after which they are concatenated. Trainable position embeddings are used to pad
each modality to the same number of channels to make concatenation along the time dimension possible. Next, one applies
the Perceiver encoder.`),Hc.forEach(r),E_=d(M),be=s(M,"P",{});var Rs=n(be);zn=s(Rs,"A",{href:!0});var J2=n(zn);j_=i(J2,"PerceiverMultimodalDecoder"),J2.forEach(r),C_=i(Rs,` is used to decode the latent representation of
`),An=s(Rs,"A",{href:!0});var X2=n(An);F_=i(X2,"PerceiverModel"),X2.forEach(r),I_=i(Rs,`. This decoder uses each modality-specific decoder to construct queries. The decoder queries are
created based on the inputs after preprocessing. However, autoencoding an entire video in a single forward pass is
computationally infeasible, hence one only uses parts of the decoder queries to do cross-attention with the latent
representation. This is determined by the subsampled indices for each modality, which can be provided as additional
input to the forward pass of `),Dn=s(Rs,"A",{href:!0});var Z2=n(Dn);M_=i(Z2,"PerceiverForMultimodalAutoencoding"),Z2.forEach(r),q_=i(Rs,"."),Rs.forEach(r),z_=d(M),Er=s(M,"P",{});var Vc=n(Er);On=s(Vc,"A",{href:!0});var Y2=n(On);A_=i(Y2,"PerceiverMultimodalDecoder"),Y2.forEach(r),D_=i(Vc,` also pads the decoder queries of the different
modalities to the same number of channels, in order to concatenate them along the time dimension. Next, cross-attention
is performed with the latent representation of `),Nn=s(Vc,"A",{href:!0});var Q2=n(Nn);O_=i(Q2,"PerceiverModel"),Q2.forEach(r),N_=i(Vc,"."),Vc.forEach(r),L_=d(M),Ds=s(M,"P",{});var Tp=n(Ds);S_=i(Tp,"Finally, "),Ec=s(Tp,"CODE",{});var ew=n(Ec);B_=i(ew,"~models.perceiver.modeling_perceiver.PerceiverMultiModalPostprocessor"),ew.forEach(r),W_=i(Tp,` is used to turn this tensor into an
actual video. It first splits up the output into the different modalities, and then applies the respective
postprocessor for each modality.`),Tp.forEach(r),H_=d(M),jc=s(M,"P",{});var ow=n(jc);V_=i(ow,`Note that, by masking the classification label during evaluation (i.e. simply providing a tensor of zeros for the
\u201Clabel\u201D modality), this auto-encoding model becomes a Kinetics 700 video classifier.`),ow.forEach(r),R_=d(M),Os=s(M,"P",{});var xp=n(Os);U_=i(xp,"This model is a PyTorch "),Ns=s(xp,"A",{href:!0,rel:!0});var rw=n(Ns);K_=i(rw,"torch.nn.Module"),rw.forEach(r),G_=i(xp,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),xp.forEach(r),J_=d(M),Q=s(M,"DIV",{class:!0});var Lr=n(Q);P(Ls.$$.fragment,Lr),X_=d(Lr),ko=s(Lr,"P",{});var aa=n(ko);Z_=i(aa,"The "),Ln=s(aa,"A",{href:!0});var tw=n(Ln);Y_=i(tw,"PerceiverForMultimodalAutoencoding"),tw.forEach(r),Q_=i(aa," forward method, overrides the "),Cc=s(aa,"CODE",{});var sw=n(Cc);eP=i(sw,"__call__"),sw.forEach(r),oP=i(aa," special method."),aa.forEach(r),rP=d(Lr),P(jr.$$.fragment,Lr),tP=d(Lr),P(Cr.$$.fragment,Lr),Lr.forEach(r),M.forEach(r),this.h()},h(){c(u,"name","hf:doc:metadata"),c(u,"content",JSON.stringify(Cw)),c(g,"id","perceiver"),c(g,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(g,"href","#perceiver"),c(v,"class","relative group"),c(jo,"id","overview"),c(jo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(jo,"href","#overview"),c($e,"class","relative group"),c(Wr,"href","https://arxiv.org/abs/2107.14795"),c(Wr,"rel","nofollow"),c(Hr,"href","https://arxiv.org/abs/2103.03206"),c(Hr,"rel","nofollow"),c(Xs,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverModel"),lw(Io.src,aP="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/perceiver_architecture.jpg")||c(Io,"src",aP),c(Io,"alt","drawing"),c(Io,"width","600"),c(Ys,"href","https://arxiv.org/abs/2105.15203"),c(Rr,"href","https://huggingface.co/nielsr"),c(Rr,"rel","nofollow"),c(Ur,"href","https://github.com/deepmind/deepmind-research/tree/master/perceiver"),c(Ur,"rel","nofollow"),c(Gr,"href","https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Perceiver"),c(Gr,"rel","nofollow"),c(Xr,"href","https://huggingface.co/blog/perceiver"),c(Xr,"rel","nofollow"),c(Yr,"href","https://github.com/pytorch/pytorch/issues/36035"),c(Yr,"rel","nofollow"),c(qo,"id","documentation-resources"),c(qo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(qo,"href","#documentation-resources"),c(ke,"class","relative group"),c(on,"href","../tasks/sequence_classification"),c(rn,"href","../tasks/masked_language_modeling"),c(tn,"href","../tasks/image_classification"),c(zo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"),c(zo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(zo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"),c(Te,"class","relative group"),c(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ao,"id","transformers.PerceiverConfig"),c(Ao,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ao,"href","#transformers.PerceiverConfig"),c(Fe,"class","relative group"),c(sn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(it,"href","https://huggingface.co/deepmind/language-perceiver"),c(it,"rel","nofollow"),c(nn,"href","/docs/transformers/v4.29.1/en/main_classes/configuration#transformers.PretrainedConfig"),c(an,"href","/docs/transformers/v4.29.1/en/main_classes/configuration#transformers.PretrainedConfig"),c(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Oo,"id","transformers.PerceiverTokenizer"),c(Oo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Oo,"href","#transformers.PerceiverTokenizer"),c(qe,"class","relative group"),c(cn,"href","/docs/transformers/v4.29.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer"),c(No,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Lo,"id","transformers.PerceiverFeatureExtractor"),c(Lo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Lo,"href","#transformers.PerceiverFeatureExtractor"),c(ze,"class","relative group"),c(So,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Bo,"id","transformers.PerceiverImageProcessor"),c(Bo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Bo,"href","#transformers.PerceiverImageProcessor"),c(De,"class","relative group"),c(Wo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ho,"id","transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor"),c(Ho,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ho,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor"),c(Oe,"class","relative group"),c(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Vo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(Vo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Vo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(Ne,"class","relative group"),c(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ro,"id","transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor"),c(Ro,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ro,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor"),c(Le,"class","relative group"),c(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Uo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor"),c(Uo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Uo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor"),c(Be,"class","relative group"),c(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ko,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(Ko,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ko,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(He,"class","relative group"),c(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Go,"id","transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder"),c(Go,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Go,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder"),c(Ve,"class","relative group"),c(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Jo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder"),c(Jo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Jo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder"),c(Ue,"class","relative group"),c(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Xo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(Xo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Xo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(Ke,"class","relative group"),c(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Zo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c(Zo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Zo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c(Je,"class","relative group"),c(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Yo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder"),c(Yo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Yo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder"),c(Ze,"class","relative group"),c(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Qo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Qo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Qo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Qe,"class","relative group"),c(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(er,"id","transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor"),c(er,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(er,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor"),c(eo,"class","relative group"),c(oo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(or,"id","transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor"),c(or,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(or,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor"),c(ro,"class","relative group"),c(to,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(rr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor"),c(rr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(rr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor"),c(so,"class","relative group"),c(no,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(tr,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor"),c(tr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(tr,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor"),c(ao,"class","relative group"),c(io,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(sr,"id","transformers.PerceiverModel"),c(sr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(sr,"href","#transformers.PerceiverModel"),c(co,"class","relative group"),c(rs,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(rs,"rel","nofollow"),c(ln,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ir,"id","transformers.PerceiverForMaskedLM"),c(ir,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(ir,"href","#transformers.PerceiverForMaskedLM"),c(po,"class","relative group"),c(is,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(is,"rel","nofollow"),c(dn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForMaskedLM"),c(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(dr,"id","transformers.PerceiverForSequenceClassification"),c(dr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(dr,"href","#transformers.PerceiverForSequenceClassification"),c(ho,"class","relative group"),c(ms,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(ms,"rel","nofollow"),c(pn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForSequenceClassification"),c(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(hr,"id","transformers.PerceiverForImageClassificationLearned"),c(hr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(hr,"href","#transformers.PerceiverForImageClassificationLearned"),c(fo,"class","relative group"),c(mn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(hn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(un,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(fn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(vs,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(vs,"rel","nofollow"),c(gn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(gr,"id","transformers.PerceiverForImageClassificationFourier"),c(gr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(gr,"href","#transformers.PerceiverForImageClassificationFourier"),c(vo,"class","relative group"),c(vn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(_n,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(Pn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(bn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(ys,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(ys,"rel","nofollow"),c(wn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationFourier"),c(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Pr,"id","transformers.PerceiverForImageClassificationConvProcessing"),c(Pr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Pr,"href","#transformers.PerceiverForImageClassificationConvProcessing"),c(Po,"class","relative group"),c(yn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c($n,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(kn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(Tn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(Es,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(Es,"rel","nofollow"),c(xn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationConvProcessing"),c(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(yr,"id","transformers.PerceiverForOpticalFlow"),c(yr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(yr,"href","#transformers.PerceiverForOpticalFlow"),c(wo,"class","relative group"),c(En,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow"),c(jn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(Cn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c(Fn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(Ms,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(Ms,"rel","nofollow"),c(In,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow"),c(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Tr,"id","transformers.PerceiverForMultimodalAutoencoding"),c(Tr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Tr,"href","#transformers.PerceiverForMultimodalAutoencoding"),c($o,"class","relative group"),c(Mn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c(qn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(zn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(An,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(Dn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c(On,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Nn,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(Ns,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(Ns,"rel","nofollow"),c(Ln,"href","/docs/transformers/v4.29.1/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(o,m){e(document.head,u),h(o,T,m),h(o,v,m),e(v,g),e(g,k),b(p,k,null),e(v,f),e(v,C),e(C,Ep),h(o,Rc,m),h(o,$e,m),e($e,jo),e(jo,ia),b(Br,ia,null),e($e,jp),e($e,ca),e(ca,Cp),h(o,Uc,m),h(o,Co,m),e(Co,Fp),e(Co,Wr),e(Wr,Ip),e(Co,Mp),h(o,Kc,m),h(o,Fo,m),e(Fo,qp),e(Fo,Hr),e(Hr,zp),e(Fo,Ap),h(o,Gc,m),h(o,Us,m),e(Us,Dp),h(o,Jc,m),h(o,Ks,m),e(Ks,la),e(la,Op),h(o,Xc,m),h(o,Gs,m),e(Gs,Np),h(o,Zc,m),h(o,Js,m),e(Js,Lp),h(o,Yc,m),h(o,D,m),e(D,Sp),e(D,Xs),e(Xs,Bp),e(D,Wp),e(D,da),e(da,Hp),e(D,Vp),e(D,pa),e(pa,Rp),e(D,Up),e(D,ma),e(ma,Kp),e(D,Gp),e(D,ha),e(ha,Jp),e(D,Xp),h(o,Qc,m),h(o,Zs,m),e(Zs,Zp),h(o,el,m),h(o,I,m),e(I,Yp),e(I,ua),e(ua,Qp),e(I,em),e(I,fa),e(fa,om),e(I,rm),e(I,ga),e(ga,tm),e(I,sm),e(I,va),e(va,nm),e(I,am),e(I,_a),e(_a,im),e(I,cm),e(I,Pa),e(Pa,lm),e(I,dm),h(o,ol,m),h(o,Io,m),h(o,rl,m),h(o,Vr,m),e(Vr,pm),e(Vr,Ys),e(Ys,mm),h(o,tl,m),h(o,ve,m),e(ve,hm),e(ve,Rr),e(Rr,um),e(ve,fm),e(ve,Ur),e(Ur,gm),e(ve,vm),h(o,sl,m),h(o,Qs,m),e(Qs,_m),h(o,nl,m),h(o,Mo,m),e(Mo,Kr),e(Kr,Pm),e(Kr,Gr),e(Gr,bm),e(Kr,wm),e(Mo,ym),e(Mo,Jr),e(Jr,$m),e(Jr,Xr),e(Xr,km),e(Jr,Tm),h(o,al,m),h(o,Zr,m),e(Zr,ba),e(ba,xm),e(Zr,Em),h(o,il,m),h(o,en,m),e(en,_e),e(_e,jm),e(_e,wa),e(wa,Cm),e(_e,Fm),e(_e,ya),e(ya,Im),e(_e,Mm),e(_e,Yr),e(Yr,qm),h(o,cl,m),h(o,ke,m),e(ke,qo),e(qo,$a),b(Qr,$a,null),e(ke,zm),e(ke,ka),e(ka,Am),h(o,ll,m),h(o,Pe,m),e(Pe,Ta),e(Ta,on),e(on,Dm),e(Pe,Om),e(Pe,xa),e(xa,rn),e(rn,Nm),e(Pe,Lm),e(Pe,Ea),e(Ea,tn),e(tn,Sm),h(o,dl,m),h(o,Te,m),e(Te,zo),e(zo,ja),b(et,ja,null),e(Te,Bm),e(Te,Ca),e(Ca,Wm),h(o,pl,m),h(o,xe,m),b(ot,xe,null),e(xe,Hm),e(xe,Fa),e(Fa,Vm),h(o,ml,m),h(o,Ee,m),b(rt,Ee,null),e(Ee,Rm),e(Ee,Ia),e(Ia,Um),h(o,hl,m),h(o,je,m),b(tt,je,null),e(je,Km),e(je,Ma),e(Ma,Gm),h(o,ul,m),h(o,Ce,m),b(st,Ce,null),e(Ce,Jm),e(Ce,qa),e(qa,Xm),h(o,fl,m),h(o,Fe,m),e(Fe,Ao),e(Ao,za),b(nt,za,null),e(Fe,Zm),e(Fe,Aa),e(Aa,Ym),h(o,gl,m),h(o,H,m),b(at,H,null),e(H,Qm),e(H,Ie),e(Ie,eh),e(Ie,sn),e(sn,oh),e(Ie,rh),e(Ie,it),e(it,th),e(Ie,sh),e(H,nh),e(H,Me),e(Me,ah),e(Me,nn),e(nn,ih),e(Me,ch),e(Me,an),e(an,lh),e(Me,dh),e(H,ph),b(Do,H,null),h(o,vl,m),h(o,qe,m),e(qe,Oo),e(Oo,Da),b(ct,Da,null),e(qe,mh),e(qe,Oa),e(Oa,hh),h(o,_l,m),h(o,V,m),b(lt,V,null),e(V,uh),e(V,Na),e(Na,fh),e(V,gh),e(V,dt),e(dt,vh),e(dt,cn),e(cn,_h),e(dt,Ph),e(V,bh),e(V,No),b(pt,No,null),e(No,wh),e(No,La),e(La,yh),h(o,Pl,m),h(o,ze,m),e(ze,Lo),e(Lo,Sa),b(mt,Sa,null),e(ze,$h),e(ze,Ba),e(Ba,kh),h(o,bl,m),h(o,Ae,m),b(ht,Ae,null),e(Ae,Th),e(Ae,So),b(ut,So,null),e(So,xh),e(So,Wa),e(Wa,Eh),h(o,wl,m),h(o,De,m),e(De,Bo),e(Bo,Ha),b(ft,Ha,null),e(De,jh),e(De,Va),e(Va,Ch),h(o,yl,m),h(o,ne,m),b(gt,ne,null),e(ne,Fh),e(ne,Ra),e(Ra,Ih),e(ne,Mh),e(ne,Wo),b(vt,Wo,null),e(Wo,qh),e(Wo,Ua),e(Ua,zh),h(o,$l,m),h(o,Oe,m),e(Oe,Ho),e(Ho,Ka),b(_t,Ka,null),e(Oe,Ah),e(Oe,Ga),e(Ga,Dh),h(o,kl,m),h(o,ae,m),b(Pt,ae,null),e(ae,Oh),e(ae,bt),e(bt,Nh),e(bt,Ja),e(Ja,Lh),e(bt,Sh),e(ae,Bh),e(ae,wt),e(wt,Wh),e(wt,Xa),e(Xa,Hh),e(wt,Vh),h(o,Tl,m),h(o,Ne,m),e(Ne,Vo),e(Vo,Za),b(yt,Za,null),e(Ne,Rh),e(Ne,Ya),e(Ya,Uh),h(o,xl,m),h(o,ie,m),b($t,ie,null),e(ie,Kh),e(ie,Qa),e(Qa,Gh),e(ie,Jh),e(ie,R),e(R,Xh),e(R,ei),e(ei,Zh),e(R,Yh),e(R,oi),e(oi,Qh),e(R,eu),e(R,ri),e(ri,ou),e(R,ru),e(R,ti),e(ti,tu),e(R,su),h(o,El,m),h(o,Le,m),e(Le,Ro),e(Ro,si),b(kt,si,null),e(Le,nu),e(Le,ni),e(ni,au),h(o,jl,m),h(o,Se,m),b(Tt,Se,null),e(Se,iu),e(Se,ai),e(ai,cu),h(o,Cl,m),h(o,Be,m),e(Be,Uo),e(Uo,ii),b(xt,ii,null),e(Be,lu),e(Be,ci),e(ci,du),h(o,Fl,m),h(o,We,m),b(Et,We,null),e(We,pu),e(We,li),e(li,mu),h(o,Il,m),h(o,He,m),e(He,Ko),e(Ko,di),b(jt,di,null),e(He,hu),e(He,pi),e(pi,uu),h(o,Ml,m),h(o,ce,m),b(Ct,ce,null),e(ce,fu),e(ce,mi),e(mi,gu),e(ce,vu),e(ce,hi),e(hi,_u),h(o,ql,m),h(o,Ve,m),e(Ve,Go),e(Go,ui),b(Ft,ui,null),e(Ve,Pu),e(Ve,fi),e(fi,bu),h(o,zl,m),h(o,Re,m),b(It,Re,null),e(Re,wu),e(Re,gi),e(gi,yu),h(o,Al,m),h(o,Ue,m),e(Ue,Jo),e(Jo,vi),b(Mt,vi,null),e(Ue,$u),e(Ue,_i),e(_i,ku),h(o,Dl,m),h(o,le,m),b(qt,le,null),e(le,Tu),e(le,Pi),e(Pi,xu),e(le,Eu),e(le,bi),e(bi,ju),h(o,Ol,m),h(o,Ke,m),e(Ke,Xo),e(Xo,wi),b(zt,wi,null),e(Ke,Cu),e(Ke,yi),e(yi,Fu),h(o,Nl,m),h(o,Ge,m),b(At,Ge,null),e(Ge,Iu),e(Ge,Dt),e(Dt,Mu),e(Dt,$i),e($i,qu),e(Dt,zu),h(o,Ll,m),h(o,Je,m),e(Je,Zo),e(Zo,ki),b(Ot,ki,null),e(Je,Au),e(Je,Ti),e(Ti,Du),h(o,Sl,m),h(o,Xe,m),b(Nt,Xe,null),e(Xe,Ou),e(Xe,xi),e(xi,Nu),h(o,Bl,m),h(o,Ze,m),e(Ze,Yo),e(Yo,Ei),b(Lt,Ei,null),e(Ze,Lu),e(Ze,ji),e(ji,Su),h(o,Wl,m),h(o,Ye,m),b(St,Ye,null),e(Ye,Bu),e(Ye,Bt),e(Bt,Wu),e(Bt,Ci),e(Ci,Hu),e(Bt,Vu),h(o,Hl,m),h(o,Qe,m),e(Qe,Qo),e(Qo,Fi),b(Wt,Fi,null),e(Qe,Ru),e(Qe,Ii),e(Ii,Uu),h(o,Vl,m),h(o,de,m),b(Ht,de,null),e(de,Ku),e(de,Vt),e(Vt,Gu),e(Vt,Mi),e(Mi,Ju),e(Vt,Xu),e(de,Zu),e(de,qi),e(qi,Yu),h(o,Rl,m),h(o,eo,m),e(eo,er),e(er,zi),b(Rt,zi,null),e(eo,Qu),e(eo,Ai),e(Ai,ef),h(o,Ul,m),h(o,oo,m),b(Ut,oo,null),e(oo,of),e(oo,Di),e(Di,rf),h(o,Kl,m),h(o,ro,m),e(ro,or),e(or,Oi),b(Kt,Oi,null),e(ro,tf),e(ro,Ni),e(Ni,sf),h(o,Gl,m),h(o,to,m),b(Gt,to,null),e(to,nf),e(to,Li),e(Li,af),h(o,Jl,m),h(o,so,m),e(so,rr),e(rr,Si),b(Jt,Si,null),e(so,cf),e(so,Bi),e(Bi,lf),h(o,Xl,m),h(o,no,m),b(Xt,no,null),e(no,df),e(no,Wi),e(Wi,pf),h(o,Zl,m),h(o,ao,m),e(ao,tr),e(tr,Hi),b(Zt,Hi,null),e(ao,mf),e(ao,Vi),e(Vi,hf),h(o,Yl,m),h(o,io,m),b(Yt,io,null),e(io,uf),e(io,Ri),e(Ri,ff),h(o,Ql,m),h(o,co,m),e(co,sr),e(sr,Ui),b(Qt,Ui,null),e(co,gf),e(co,Ki),e(Ki,vf),h(o,ed,m),h(o,pe,m),b(es,pe,null),e(pe,_f),e(pe,os),e(os,Pf),e(os,rs),e(rs,bf),e(os,wf),e(pe,yf),e(pe,U),b(ts,U,null),e(U,$f),e(U,lo),e(lo,kf),e(lo,ln),e(ln,Tf),e(lo,xf),e(lo,Gi),e(Gi,Ef),e(lo,jf),e(U,Cf),b(nr,U,null),e(U,Ff),b(ar,U,null),h(o,od,m),h(o,po,m),e(po,ir),e(ir,Ji),b(ss,Ji,null),e(po,If),e(po,Xi),e(Xi,Mf),h(o,rd,m),h(o,me,m),b(ns,me,null),e(me,qf),e(me,as),e(as,zf),e(as,is),e(is,Af),e(as,Df),e(me,Of),e(me,K),b(cs,K,null),e(K,Nf),e(K,mo),e(mo,Lf),e(mo,dn),e(dn,Sf),e(mo,Bf),e(mo,Zi),e(Zi,Wf),e(mo,Hf),e(K,Vf),b(cr,K,null),e(K,Rf),b(lr,K,null),h(o,td,m),h(o,ho,m),e(ho,dr),e(dr,Yi),b(ls,Yi,null),e(ho,Uf),e(ho,Qi),e(Qi,Kf),h(o,sd,m),h(o,he,m),b(ds,he,null),e(he,Gf),e(he,ps),e(ps,Jf),e(ps,ms),e(ms,Xf),e(ps,Zf),e(he,Yf),e(he,G),b(hs,G,null),e(G,Qf),e(G,uo),e(uo,eg),e(uo,pn),e(pn,og),e(uo,rg),e(uo,ec),e(ec,tg),e(uo,sg),e(G,ng),b(pr,G,null),e(G,ag),b(mr,G,null),h(o,nd,m),h(o,fo,m),e(fo,hr),e(hr,oc),b(us,oc,null),e(fo,ig),e(fo,rc),e(rc,cg),h(o,ad,m),h(o,q,m),b(fs,q,null),e(q,lg),e(q,tc),e(tc,dg),e(q,pg),e(q,sc),e(sc,mg),e(q,hg),e(q,L),e(L,mn),e(mn,ug),e(L,fg),e(L,hn),e(hn,gg),e(L,vg),e(L,nc),e(nc,_g),e(L,Pg),e(L,un),e(un,bg),e(L,wg),e(L,fn),e(fn,yg),e(L,$g),e(q,kg),e(q,gs),e(gs,Tg),e(gs,vs),e(vs,xg),e(gs,Eg),e(q,jg),e(q,J),b(_s,J,null),e(J,Cg),e(J,go),e(go,Fg),e(go,gn),e(gn,Ig),e(go,Mg),e(go,ac),e(ac,qg),e(go,zg),e(J,Ag),b(ur,J,null),e(J,Dg),b(fr,J,null),h(o,id,m),h(o,vo,m),e(vo,gr),e(gr,ic),b(Ps,ic,null),e(vo,Og),e(vo,cc),e(cc,Ng),h(o,cd,m),h(o,z,m),b(bs,z,null),e(z,Lg),e(z,lc),e(lc,Sg),e(z,Bg),e(z,dc),e(dc,Wg),e(z,Hg),e(z,S),e(S,vn),e(vn,Vg),e(S,Rg),e(S,_n),e(_n,Ug),e(S,Kg),e(S,pc),e(pc,Gg),e(S,Jg),e(S,Pn),e(Pn,Xg),e(S,Zg),e(S,bn),e(bn,Yg),e(S,Qg),e(z,ev),e(z,ws),e(ws,ov),e(ws,ys),e(ys,rv),e(ws,tv),e(z,sv),e(z,X),b($s,X,null),e(X,nv),e(X,_o),e(_o,av),e(_o,wn),e(wn,iv),e(_o,cv),e(_o,mc),e(mc,lv),e(_o,dv),e(X,pv),b(vr,X,null),e(X,mv),b(_r,X,null),h(o,ld,m),h(o,Po,m),e(Po,Pr),e(Pr,hc),b(ks,hc,null),e(Po,hv),e(Po,uc),e(uc,uv),h(o,dd,m),h(o,A,m),b(Ts,A,null),e(A,fv),e(A,fc),e(fc,gv),e(A,vv),e(A,gc),e(gc,_v),e(A,Pv),e(A,B),e(B,yn),e(yn,bv),e(B,wv),e(B,$n),e($n,yv),e(B,$v),e(B,vc),e(vc,kv),e(B,Tv),e(B,kn),e(kn,xv),e(B,Ev),e(B,Tn),e(Tn,jv),e(B,Cv),e(A,Fv),e(A,xs),e(xs,Iv),e(xs,Es),e(Es,Mv),e(xs,qv),e(A,zv),e(A,Z),b(js,Z,null),e(Z,Av),e(Z,bo),e(bo,Dv),e(bo,xn),e(xn,Ov),e(bo,Nv),e(bo,_c),e(_c,Lv),e(bo,Sv),e(Z,Bv),b(br,Z,null),e(Z,Wv),b(wr,Z,null),h(o,pd,m),h(o,wo,m),e(wo,yr),e(yr,Pc),b(Cs,Pc,null),e(wo,Hv),e(wo,bc),e(bc,Vv),h(o,md,m),h(o,O,m),b(Fs,O,null),e(O,Rv),e(O,N),e(N,Uv),e(N,En),e(En,Kv),e(N,Gv),e(N,jn),e(jn,Jv),e(N,Xv),e(N,wc),e(wc,Zv),e(N,Yv),e(N,Cn),e(Cn,Qv),e(N,e_),e(N,Fn),e(Fn,o_),e(N,r_),e(O,t_),e(O,yc),e(yc,s_),e(O,n_),e(O,Is),e(Is,a_),e(Is,Ms),e(Ms,i_),e(Is,c_),e(O,l_),e(O,Y),b(qs,Y,null),e(Y,d_),e(Y,yo),e(yo,p_),e(yo,In),e(In,m_),e(yo,h_),e(yo,$c),e($c,u_),e(yo,f_),e(Y,g_),b($r,Y,null),e(Y,v_),b(kr,Y,null),h(o,hd,m),h(o,$o,m),e($o,Tr),e(Tr,kc),b(zs,kc,null),e($o,__),e($o,Tc),e(Tc,P_),h(o,ud,m),h(o,F,m),b(As,F,null),e(F,b_),e(F,xc),e(xc,w_),e(F,y_),e(F,xr),e(xr,Mn),e(Mn,$_),e(xr,k_),e(xr,qn),e(qn,T_),e(xr,x_),e(F,E_),e(F,be),e(be,zn),e(zn,j_),e(be,C_),e(be,An),e(An,F_),e(be,I_),e(be,Dn),e(Dn,M_),e(be,q_),e(F,z_),e(F,Er),e(Er,On),e(On,A_),e(Er,D_),e(Er,Nn),e(Nn,O_),e(Er,N_),e(F,L_),e(F,Ds),e(Ds,S_),e(Ds,Ec),e(Ec,B_),e(Ds,W_),e(F,H_),e(F,jc),e(jc,V_),e(F,R_),e(F,Os),e(Os,U_),e(Os,Ns),e(Ns,K_),e(Os,G_),e(F,J_),e(F,Q),b(Ls,Q,null),e(Q,X_),e(Q,ko),e(ko,Z_),e(ko,Ln),e(Ln,Y_),e(ko,Q_),e(ko,Cc),e(Cc,eP),e(ko,oP),e(Q,rP),b(jr,Q,null),e(Q,tP),b(Cr,Q,null),fd=!0},p(o,[m]){const Ss={};m&2&&(Ss.$$scope={dirty:m,ctx:o}),Do.$set(Ss);const Fc={};m&2&&(Fc.$$scope={dirty:m,ctx:o}),nr.$set(Fc);const Ic={};m&2&&(Ic.$$scope={dirty:m,ctx:o}),ar.$set(Ic);const Mc={};m&2&&(Mc.$$scope={dirty:m,ctx:o}),cr.$set(Mc);const Bs={};m&2&&(Bs.$$scope={dirty:m,ctx:o}),lr.$set(Bs);const qc={};m&2&&(qc.$$scope={dirty:m,ctx:o}),pr.$set(qc);const zc={};m&2&&(zc.$$scope={dirty:m,ctx:o}),mr.$set(zc);const Ac={};m&2&&(Ac.$$scope={dirty:m,ctx:o}),ur.$set(Ac);const Ws={};m&2&&(Ws.$$scope={dirty:m,ctx:o}),fr.$set(Ws);const Dc={};m&2&&(Dc.$$scope={dirty:m,ctx:o}),vr.$set(Dc);const Hs={};m&2&&(Hs.$$scope={dirty:m,ctx:o}),_r.$set(Hs);const Oc={};m&2&&(Oc.$$scope={dirty:m,ctx:o}),br.$set(Oc);const Nc={};m&2&&(Nc.$$scope={dirty:m,ctx:o}),wr.$set(Nc);const Lc={};m&2&&(Lc.$$scope={dirty:m,ctx:o}),$r.$set(Lc);const Sc={};m&2&&(Sc.$$scope={dirty:m,ctx:o}),kr.$set(Sc);const Bc={};m&2&&(Bc.$$scope={dirty:m,ctx:o}),jr.$set(Bc);const Wc={};m&2&&(Wc.$$scope={dirty:m,ctx:o}),Cr.$set(Wc)},i(o){fd||(w(p.$$.fragment,o),w(Br.$$.fragment,o),w(Qr.$$.fragment,o),w(et.$$.fragment,o),w(ot.$$.fragment,o),w(rt.$$.fragment,o),w(tt.$$.fragment,o),w(st.$$.fragment,o),w(nt.$$.fragment,o),w(at.$$.fragment,o),w(Do.$$.fragment,o),w(ct.$$.fragment,o),w(lt.$$.fragment,o),w(pt.$$.fragment,o),w(mt.$$.fragment,o),w(ht.$$.fragment,o),w(ut.$$.fragment,o),w(ft.$$.fragment,o),w(gt.$$.fragment,o),w(vt.$$.fragment,o),w(_t.$$.fragment,o),w(Pt.$$.fragment,o),w(yt.$$.fragment,o),w($t.$$.fragment,o),w(kt.$$.fragment,o),w(Tt.$$.fragment,o),w(xt.$$.fragment,o),w(Et.$$.fragment,o),w(jt.$$.fragment,o),w(Ct.$$.fragment,o),w(Ft.$$.fragment,o),w(It.$$.fragment,o),w(Mt.$$.fragment,o),w(qt.$$.fragment,o),w(zt.$$.fragment,o),w(At.$$.fragment,o),w(Ot.$$.fragment,o),w(Nt.$$.fragment,o),w(Lt.$$.fragment,o),w(St.$$.fragment,o),w(Wt.$$.fragment,o),w(Ht.$$.fragment,o),w(Rt.$$.fragment,o),w(Ut.$$.fragment,o),w(Kt.$$.fragment,o),w(Gt.$$.fragment,o),w(Jt.$$.fragment,o),w(Xt.$$.fragment,o),w(Zt.$$.fragment,o),w(Yt.$$.fragment,o),w(Qt.$$.fragment,o),w(es.$$.fragment,o),w(ts.$$.fragment,o),w(nr.$$.fragment,o),w(ar.$$.fragment,o),w(ss.$$.fragment,o),w(ns.$$.fragment,o),w(cs.$$.fragment,o),w(cr.$$.fragment,o),w(lr.$$.fragment,o),w(ls.$$.fragment,o),w(ds.$$.fragment,o),w(hs.$$.fragment,o),w(pr.$$.fragment,o),w(mr.$$.fragment,o),w(us.$$.fragment,o),w(fs.$$.fragment,o),w(_s.$$.fragment,o),w(ur.$$.fragment,o),w(fr.$$.fragment,o),w(Ps.$$.fragment,o),w(bs.$$.fragment,o),w($s.$$.fragment,o),w(vr.$$.fragment,o),w(_r.$$.fragment,o),w(ks.$$.fragment,o),w(Ts.$$.fragment,o),w(js.$$.fragment,o),w(br.$$.fragment,o),w(wr.$$.fragment,o),w(Cs.$$.fragment,o),w(Fs.$$.fragment,o),w(qs.$$.fragment,o),w($r.$$.fragment,o),w(kr.$$.fragment,o),w(zs.$$.fragment,o),w(As.$$.fragment,o),w(Ls.$$.fragment,o),w(jr.$$.fragment,o),w(Cr.$$.fragment,o),fd=!0)},o(o){y(p.$$.fragment,o),y(Br.$$.fragment,o),y(Qr.$$.fragment,o),y(et.$$.fragment,o),y(ot.$$.fragment,o),y(rt.$$.fragment,o),y(tt.$$.fragment,o),y(st.$$.fragment,o),y(nt.$$.fragment,o),y(at.$$.fragment,o),y(Do.$$.fragment,o),y(ct.$$.fragment,o),y(lt.$$.fragment,o),y(pt.$$.fragment,o),y(mt.$$.fragment,o),y(ht.$$.fragment,o),y(ut.$$.fragment,o),y(ft.$$.fragment,o),y(gt.$$.fragment,o),y(vt.$$.fragment,o),y(_t.$$.fragment,o),y(Pt.$$.fragment,o),y(yt.$$.fragment,o),y($t.$$.fragment,o),y(kt.$$.fragment,o),y(Tt.$$.fragment,o),y(xt.$$.fragment,o),y(Et.$$.fragment,o),y(jt.$$.fragment,o),y(Ct.$$.fragment,o),y(Ft.$$.fragment,o),y(It.$$.fragment,o),y(Mt.$$.fragment,o),y(qt.$$.fragment,o),y(zt.$$.fragment,o),y(At.$$.fragment,o),y(Ot.$$.fragment,o),y(Nt.$$.fragment,o),y(Lt.$$.fragment,o),y(St.$$.fragment,o),y(Wt.$$.fragment,o),y(Ht.$$.fragment,o),y(Rt.$$.fragment,o),y(Ut.$$.fragment,o),y(Kt.$$.fragment,o),y(Gt.$$.fragment,o),y(Jt.$$.fragment,o),y(Xt.$$.fragment,o),y(Zt.$$.fragment,o),y(Yt.$$.fragment,o),y(Qt.$$.fragment,o),y(es.$$.fragment,o),y(ts.$$.fragment,o),y(nr.$$.fragment,o),y(ar.$$.fragment,o),y(ss.$$.fragment,o),y(ns.$$.fragment,o),y(cs.$$.fragment,o),y(cr.$$.fragment,o),y(lr.$$.fragment,o),y(ls.$$.fragment,o),y(ds.$$.fragment,o),y(hs.$$.fragment,o),y(pr.$$.fragment,o),y(mr.$$.fragment,o),y(us.$$.fragment,o),y(fs.$$.fragment,o),y(_s.$$.fragment,o),y(ur.$$.fragment,o),y(fr.$$.fragment,o),y(Ps.$$.fragment,o),y(bs.$$.fragment,o),y($s.$$.fragment,o),y(vr.$$.fragment,o),y(_r.$$.fragment,o),y(ks.$$.fragment,o),y(Ts.$$.fragment,o),y(js.$$.fragment,o),y(br.$$.fragment,o),y(wr.$$.fragment,o),y(Cs.$$.fragment,o),y(Fs.$$.fragment,o),y(qs.$$.fragment,o),y($r.$$.fragment,o),y(kr.$$.fragment,o),y(zs.$$.fragment,o),y(As.$$.fragment,o),y(Ls.$$.fragment,o),y(jr.$$.fragment,o),y(Cr.$$.fragment,o),fd=!1},d(o){r(u),o&&r(T),o&&r(v),$(p),o&&r(Rc),o&&r($e),$(Br),o&&r(Uc),o&&r(Co),o&&r(Kc),o&&r(Fo),o&&r(Gc),o&&r(Us),o&&r(Jc),o&&r(Ks),o&&r(Xc),o&&r(Gs),o&&r(Zc),o&&r(Js),o&&r(Yc),o&&r(D),o&&r(Qc),o&&r(Zs),o&&r(el),o&&r(I),o&&r(ol),o&&r(Io),o&&r(rl),o&&r(Vr),o&&r(tl),o&&r(ve),o&&r(sl),o&&r(Qs),o&&r(nl),o&&r(Mo),o&&r(al),o&&r(Zr),o&&r(il),o&&r(en),o&&r(cl),o&&r(ke),$(Qr),o&&r(ll),o&&r(Pe),o&&r(dl),o&&r(Te),$(et),o&&r(pl),o&&r(xe),$(ot),o&&r(ml),o&&r(Ee),$(rt),o&&r(hl),o&&r(je),$(tt),o&&r(ul),o&&r(Ce),$(st),o&&r(fl),o&&r(Fe),$(nt),o&&r(gl),o&&r(H),$(at),$(Do),o&&r(vl),o&&r(qe),$(ct),o&&r(_l),o&&r(V),$(lt),$(pt),o&&r(Pl),o&&r(ze),$(mt),o&&r(bl),o&&r(Ae),$(ht),$(ut),o&&r(wl),o&&r(De),$(ft),o&&r(yl),o&&r(ne),$(gt),$(vt),o&&r($l),o&&r(Oe),$(_t),o&&r(kl),o&&r(ae),$(Pt),o&&r(Tl),o&&r(Ne),$(yt),o&&r(xl),o&&r(ie),$($t),o&&r(El),o&&r(Le),$(kt),o&&r(jl),o&&r(Se),$(Tt),o&&r(Cl),o&&r(Be),$(xt),o&&r(Fl),o&&r(We),$(Et),o&&r(Il),o&&r(He),$(jt),o&&r(Ml),o&&r(ce),$(Ct),o&&r(ql),o&&r(Ve),$(Ft),o&&r(zl),o&&r(Re),$(It),o&&r(Al),o&&r(Ue),$(Mt),o&&r(Dl),o&&r(le),$(qt),o&&r(Ol),o&&r(Ke),$(zt),o&&r(Nl),o&&r(Ge),$(At),o&&r(Ll),o&&r(Je),$(Ot),o&&r(Sl),o&&r(Xe),$(Nt),o&&r(Bl),o&&r(Ze),$(Lt),o&&r(Wl),o&&r(Ye),$(St),o&&r(Hl),o&&r(Qe),$(Wt),o&&r(Vl),o&&r(de),$(Ht),o&&r(Rl),o&&r(eo),$(Rt),o&&r(Ul),o&&r(oo),$(Ut),o&&r(Kl),o&&r(ro),$(Kt),o&&r(Gl),o&&r(to),$(Gt),o&&r(Jl),o&&r(so),$(Jt),o&&r(Xl),o&&r(no),$(Xt),o&&r(Zl),o&&r(ao),$(Zt),o&&r(Yl),o&&r(io),$(Yt),o&&r(Ql),o&&r(co),$(Qt),o&&r(ed),o&&r(pe),$(es),$(ts),$(nr),$(ar),o&&r(od),o&&r(po),$(ss),o&&r(rd),o&&r(me),$(ns),$(cs),$(cr),$(lr),o&&r(td),o&&r(ho),$(ls),o&&r(sd),o&&r(he),$(ds),$(hs),$(pr),$(mr),o&&r(nd),o&&r(fo),$(us),o&&r(ad),o&&r(q),$(fs),$(_s),$(ur),$(fr),o&&r(id),o&&r(vo),$(Ps),o&&r(cd),o&&r(z),$(bs),$($s),$(vr),$(_r),o&&r(ld),o&&r(Po),$(ks),o&&r(dd),o&&r(A),$(Ts),$(js),$(br),$(wr),o&&r(pd),o&&r(wo),$(Cs),o&&r(md),o&&r(O),$(Fs),$(qs),$($r),$(kr),o&&r(hd),o&&r($o),$(zs),o&&r(ud),o&&r(F),$(As),$(Ls),$(jr),$(Cr)}}}const Cw={local:"perceiver",sections:[{local:"overview",title:"Overview"},{local:"documentation-resources",title:"Documentation resources"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",title:"Perceiver specific outputs"},{local:"transformers.PerceiverConfig",title:"PerceiverConfig"},{local:"transformers.PerceiverTokenizer",title:"PerceiverTokenizer"},{local:"transformers.PerceiverFeatureExtractor",title:"PerceiverFeatureExtractor"},{local:"transformers.PerceiverImageProcessor",title:"PerceiverImageProcessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",title:"PerceiverTextPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",title:"PerceiverImagePreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",title:"PerceiverOneHotPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",title:"PerceiverAudioPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",title:"PerceiverMultimodalPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",title:"PerceiverProjectionDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",title:"PerceiverBasicDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",title:"PerceiverClassificationDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",title:"PerceiverOpticalFlowDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",title:"PerceiverBasicVideoAutoencodingDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",title:"PerceiverMultimodalDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",title:"PerceiverProjectionPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",title:"PerceiverAudioPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",title:"PerceiverClassificationPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",title:"PerceiverMultimodalPostprocessor"},{local:"transformers.PerceiverModel",title:"PerceiverModel"},{local:"transformers.PerceiverForMaskedLM",title:"PerceiverForMaskedLM"},{local:"transformers.PerceiverForSequenceClassification",title:"PerceiverForSequenceClassification"},{local:"transformers.PerceiverForImageClassificationLearned",title:"PerceiverForImageClassificationLearned"},{local:"transformers.PerceiverForImageClassificationFourier",title:"PerceiverForImageClassificationFourier"},{local:"transformers.PerceiverForImageClassificationConvProcessing",title:"PerceiverForImageClassificationConvProcessing"},{local:"transformers.PerceiverForOpticalFlow",title:"PerceiverForOpticalFlow"},{local:"transformers.PerceiverForMultimodalAutoencoding",title:"PerceiverForMultimodalAutoencoding"}],title:"Perceiver"};function Fw(E){return dw(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ow extends nw{constructor(u){super();aw(this,u,Fw,jw,iw,{})}}export{Ow as default,Cw as metadata};
