import{s as Is,n as Fs,o as Ws}from"../chunks/scheduler.9bc65507.js";import{S as $s,i as Ns,g as p,s as a,r as m,A as Zs,h as i,f as l,c as n,j as Bs,u as o,x as M,k as w,y as Qs,a as t,v as r,d as y,t as c,w as U}from"../chunks/index.707bf1b6.js";import{C as h}from"../chunks/CodeBlock.54a9f38d.js";import{H as me}from"../chunks/Heading.342b1fa6.js";function Es(ls){let u,oe,ie,re,f,ye,C,ts=`Mask generation is the task of generating semantically meaningful masks for an image.
This task is very similar to <a href="semantic_segmentation">image segmentation</a>, but many differences exist. Image segmentation models are trained on labeled datasets and are limited to the classes they have seen during training; they return a set of masks and corresponding classes, given an image.`,ce,k,as="Mask generation models are trained on large amounts of data and operate in two modes.",Ue,x,ns=`<li>Prompting mode: In this mode, the model takes in an image and a prompt, where a prompt can be a 2D point location (XY coordinates) in the image within an object or a bounding box surrounding an object. In prompting mode, the model only returns the mask over the object
that the prompt is pointing out.</li> <li>Segment Everything mode: In segment everything, given an image, the model generates every mask in the image. To do so, a grid of points is generated and overlaid on the image for inference.</li>`,he,v,ps='Mask generation task is supported by <a href="model_doc/sam">Segment Anything Model (SAM)</a>. It’s a powerful model that consists of a Vision Transformer-based image encoder, a prompt encoder, and a two-way transformer mask decoder. Images and prompts are encoded, and the decoder takes these embeddings and generates valid masks.',ue,J,is='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sam.png" alt="SAM Architecture"/>',Je,B,Ms=`SAM serves as a powerful foundation model for segmentation as it has large data coverage. It is trained on
<a href="https://ai.meta.com/datasets/segment-anything/" rel="nofollow">SA-1B</a>, a dataset with 1 million images and 1.1 billion masks.`,de,I,ms="In this guide, you will learn how to:",je,F,os="<li>Infer in segment everything mode with batching,</li> <li>Infer in point prompting mode,</li> <li>Infer in box prompting mode.</li>",Te,W,rs="First, let’s install <code>transformers</code>:",be,$,ge,N,we,Z,ys="The easiest way to infer mask generation models is to use the <code>mask-generation</code> pipeline.",fe,Q,Ce,E,cs="Let’s see the image.",ke,A,xe,d,Us='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg" alt="Example Image"/>',ve,G,hs="Let’s segment everything. <code>points-per-batch</code> enables parallel inference of points in segment everything mode. This enables faster inference, but consumes more memory. Moreover, SAM only enables batching over points and not the images. <code>pred_iou_thresh</code> is the IoU confidence threshold where only the masks above that certain threshold are returned.",Be,z,Ie,H,us="The <code>masks</code> looks like the following:",Fe,R,We,Y,Js="We can visualize them like this:",$e,_,Ne,V,ds="Below is the original image in grayscale with colorful maps overlaid. Very impressive.",Ze,j,js='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee_segmented.png" alt="Visualized"/>',Qe,S,Ee,X,Ae,L,Ts=`You can also use the model without the pipeline. To do so, initialize the model and
the processor.`,Ge,D,ze,q,bs=`To do point prompting, pass the input point to the processor, then take the processor output
and pass it to the model for inference. To post-process the model output, pass the outputs and
<code>original_sizes</code> and <code>reshaped_input_sizes</code> we take from the processor’s initial output. We need to pass these
since the processor resizes the image, and the output needs to be extrapolated.`,He,K,Re,P,gs="We can visualize the three masks in the <code>masks</code> output.",Ye,O,_e,T,ws='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/masks.png" alt="Visualized"/>',Ve,ee,Se,se,fs=`You can also do box prompting in a similar fashion to point prompting. You can simply pass the input box in the format of a list
<code>[x_min, y_min, x_max, y_max]</code> format along with the image to the <code>processor</code>. Take the processor output and directly pass it
to the model, then post-process the output again.`,Xe,le,Le,te,Cs="You can visualize the bounding box around the bee as shown below.",De,ae,qe,b,ks='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/bbox.png" alt="Visualized Bbox"/>',Ke,ne,xs="You can see the inference output below.",Pe,pe,Oe,g,vs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/box_inference.png" alt="Visualized Inference"/>',es,Me,ss;return f=new me({props:{title:"Mask Generation",local:"mask-generation",headingTag:"h1"}}),$=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),N=new me({props:{title:"Mask Generation Pipeline",local:"mask-generation-pipeline",headingTag:"h2"}}),Q=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmZhY2Vib29rJTJGc2FtLXZpdC1iYXNlJTIyJTBBbWFza19nZW5lcmF0b3IlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRGNoZWNrcG9pbnQlMkMlMjB0YXNrJTNEJTIybWFzay1nZW5lcmF0aW9uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_generator = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;mask-generation&quot;</span>)`,wrap:!1}}),A=new h({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1nX3VybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdykuY29udmVydCglMjJSR0IlMjIp",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(img_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)`,wrap:!1}}),z=new h({props:{code:"bWFza3MlMjAlM0QlMjBtYXNrX2dlbmVyYXRvcihpbWFnZSUyQyUyMHBvaW50c19wZXJfYmF0Y2glM0QxMjglMkMlMjBwcmVkX2lvdV90aHJlc2glM0QwLjg4KQ==",highlighted:'masks = mask_generator(image, points_per_batch=<span class="hljs-number">128</span>, pred_iou_thresh=<span class="hljs-number">0.88</span>)',wrap:!1}}),R=new h({props:{code:"JTdCJ21hc2tzJyUzQSUyMCU1QmFycmF5KCU1QiU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMCUyMFRydWUlMkMlMjAlMjBUcnVlJTJDJTIwJTIwVHJ1ZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMCUyMFRydWUlMkMlMjAlMjBUcnVlJTJDJTIwJTIwVHJ1ZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMCUyMFRydWUlMkMlMjAlMjBUcnVlJTJDJTIwJTIwVHJ1ZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSU1RCU1RCklMkMlMEElMjAlMjBhcnJheSglNUIlNUJGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAuLi4lMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAuLi4lMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAuLi4lMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEEnc2NvcmVzJyUzQSUyMHRlbnNvciglNUIwLjk5NzIlMkMlMjAwLjk5MTclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElN0Q=",highlighted:`{<span class="hljs-string">&#x27;masks&#x27;</span>: [array([[False, False, False, ...,  True,  True,  True],
         [False, False, False, ...,  True,  True,  True],
         [False, False, False, ...,  True,  True,  True],
         ...,
         [False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False]]),
  array([[False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False],
         ...,
<span class="hljs-string">&#x27;scores&#x27;</span>: tensor([0.9972, 0.9917,
        ...,
}`,wrap:!1}}),_=new h({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5pbXNob3coaW1hZ2UlMkMlMjBjbWFwJTNEJ2dyYXknKSUwQSUwQWZvciUyMGklMkMlMjBtYXNrJTIwaW4lMjBlbnVtZXJhdGUobWFza3MlNUIlMjJtYXNrcyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjBwbHQuaW1zaG93KG1hc2slMkMlMjBjbWFwJTNEJ3ZpcmlkaXMnJTJDJTIwYWxwaGElM0QwLjElMkMlMjB2bWluJTNEMCUyQyUyMHZtYXglM0QxKSUwQSUwQXBsdC5heGlzKCdvZmYnKSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.imshow(image, cmap=<span class="hljs-string">&#x27;gray&#x27;</span>)

<span class="hljs-keyword">for</span> i, mask <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(masks[<span class="hljs-string">&quot;masks&quot;</span>]):
    plt.imshow(mask, cmap=<span class="hljs-string">&#x27;viridis&#x27;</span>, alpha=<span class="hljs-number">0.1</span>, vmin=<span class="hljs-number">0</span>, vmax=<span class="hljs-number">1</span>)

plt.axis(<span class="hljs-string">&#x27;off&#x27;</span>)
plt.show()`,wrap:!1}}),S=new me({props:{title:"Model Inference",local:"model-inference",headingTag:"h2"}}),X=new me({props:{title:"Point Prompting",local:"point-prompting",headingTag:"h3"}}),D=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNhbU1vZGVsJTJDJTIwU2FtUHJvY2Vzc29yJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCdjdWRhJyUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAnY3B1JyklMEElMEFtb2RlbCUyMCUzRCUyMFNhbU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnNhbS12aXQtYmFzZSUyMikudG8oZGV2aWNlKSUwQXByb2Nlc3NvciUyMCUzRCUyMFNhbVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZzYW0tdml0LWJhc2UlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SamModel, SamProcessor

device = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)

model = SamModel.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>).to(device)
processor = SamProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>)`,wrap:!1}}),K=new h({props:{code:"aW5wdXRfcG9pbnRzJTIwJTNEJTIwJTVCJTVCJTVCMjU5MiUyQyUyMDE3MjglNUQlNUQlNUQlMjAlMjMlMjBwb2ludCUyMGxvY2F0aW9uJTIwb2YlMjB0aGUlMjBiZWUlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjBpbnB1dF9wb2ludHMlM0RpbnB1dF9wb2ludHMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFtYXNrcyUyMCUzRCUyMHByb2Nlc3Nvci5pbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX21hc2tzKG91dHB1dHMucHJlZF9tYXNrcy5jcHUoKSUyQyUyMGlucHV0cyU1QiUyMm9yaWdpbmFsX3NpemVzJTIyJTVELmNwdSgpJTJDJTIwaW5wdXRzJTVCJTIycmVzaGFwZWRfaW5wdXRfc2l6ZXMlMjIlNUQuY3B1KCkp",highlighted:`input_points = [[[<span class="hljs-number">2592</span>, <span class="hljs-number">1728</span>]]] <span class="hljs-comment"># point location of the bee</span>

inputs = processor(image, input_points=input_points, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)
masks = processor.image_processor.post_process_masks(outputs.pred_masks.cpu(), inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>].cpu(), inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>].cpu())`,wrap:!1}}),O=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBtYXRwbG90bGliLnB5cGxvdCUyMGFzJTIwcGx0JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZmlnJTJDJTIwYXhlcyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwNCUyQyUyMGZpZ3NpemUlM0QoMTUlMkMlMjA1KSklMEElMEFheGVzJTVCMCU1RC5pbXNob3coaW1hZ2UpJTBBYXhlcyU1QjAlNUQuc2V0X3RpdGxlKCdPcmlnaW5hbCUyMEltYWdlJyklMEFtYXNrX2xpc3QlMjAlM0QlMjAlNUJtYXNrcyU1QjAlNUQlNUIwJTVEJTVCMCU1RC5udW1weSgpJTJDJTIwbWFza3MlNUIwJTVEJTVCMCU1RCU1QjElNUQubnVtcHkoKSUyQyUyMG1hc2tzJTVCMCU1RCU1QjAlNUQlNUIyJTVELm51bXB5KCklNUQlMEElMEFmb3IlMjBpJTJDJTIwbWFzayUyMGluJTIwZW51bWVyYXRlKG1hc2tfbGlzdCUyQyUyMHN0YXJ0JTNEMSklM0ElMEElMjAlMjAlMjAlMjBvdmVybGF5ZWRfaW1hZ2UlMjAlM0QlMjBucC5hcnJheShpbWFnZSkuY29weSgpJTBBJTBBJTIwJTIwJTIwJTIwb3ZlcmxheWVkX2ltYWdlJTVCJTNBJTJDJTNBJTJDMCU1RCUyMCUzRCUyMG5wLndoZXJlKG1hc2slMjAlM0QlM0QlMjAxJTJDJTIwMjU1JTJDJTIwb3ZlcmxheWVkX2ltYWdlJTVCJTNBJTJDJTNBJTJDMCU1RCklMEElMjAlMjAlMjAlMjBvdmVybGF5ZWRfaW1hZ2UlNUIlM0ElMkMlM0ElMkMxJTVEJTIwJTNEJTIwbnAud2hlcmUobWFzayUyMCUzRCUzRCUyMDElMkMlMjAwJTJDJTIwb3ZlcmxheWVkX2ltYWdlJTVCJTNBJTJDJTNBJTJDMSU1RCklMEElMjAlMjAlMjAlMjBvdmVybGF5ZWRfaW1hZ2UlNUIlM0ElMkMlM0ElMkMyJTVEJTIwJTNEJTIwbnAud2hlcmUobWFzayUyMCUzRCUzRCUyMDElMkMlMjAwJTJDJTIwb3ZlcmxheWVkX2ltYWdlJTVCJTNBJTJDJTNBJTJDMiU1RCklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBheGVzJTVCaSU1RC5pbXNob3cob3ZlcmxheWVkX2ltYWdlKSUwQSUyMCUyMCUyMCUyMGF4ZXMlNUJpJTVELnNldF90aXRsZShmJ01hc2slMjAlN0JpJTdEJyklMEFmb3IlMjBheCUyMGluJTIwYXhlcyUzQSUwQSUyMCUyMCUyMCUyMGF4LmF4aXMoJ29mZicpJTBBJTBBcGx0LnNob3coKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

fig, axes = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">5</span>))

axes[<span class="hljs-number">0</span>].imshow(image)
axes[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&#x27;Original Image&#x27;</span>)
mask_list = [masks[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">0</span>].numpy(), masks[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">1</span>].numpy(), masks[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">2</span>].numpy()]

<span class="hljs-keyword">for</span> i, mask <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(mask_list, start=<span class="hljs-number">1</span>):
    overlayed_image = np.array(image).copy()

    overlayed_image[:,:,<span class="hljs-number">0</span>] = np.where(mask == <span class="hljs-number">1</span>, <span class="hljs-number">255</span>, overlayed_image[:,:,<span class="hljs-number">0</span>])
    overlayed_image[:,:,<span class="hljs-number">1</span>] = np.where(mask == <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, overlayed_image[:,:,<span class="hljs-number">1</span>])
    overlayed_image[:,:,<span class="hljs-number">2</span>] = np.where(mask == <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, overlayed_image[:,:,<span class="hljs-number">2</span>])
    
    axes[i].imshow(overlayed_image)
    axes[i].set_title(<span class="hljs-string">f&#x27;Mask <span class="hljs-subst">{i}</span>&#x27;</span>)
<span class="hljs-keyword">for</span> ax <span class="hljs-keyword">in</span> axes:
    ax.axis(<span class="hljs-string">&#x27;off&#x27;</span>)

plt.show()`,wrap:!1}}),ee=new me({props:{title:"Box Prompting",local:"box-prompting",headingTag:"h3"}}),le=new h({props:{code:"JTIzJTIwYm91bmRpbmclMjBib3glMjBhcm91bmQlMjB0aGUlMjBiZWUlMEFib3glMjAlM0QlMjAlNUIyMzUwJTJDJTIwMTYwMCUyQyUyMDI4NTAlMkMlMjAyMTAwJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfYm94ZXMlM0QlNUIlNUIlNUJib3glNUQlNUQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBJTIwJTIwJTIwJTIwKS50byglMjJjdWRhJTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbWFzayUyMCUzRCUyMHByb2Nlc3Nvci5pbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX21hc2tzKCUwQSUyMCUyMCUyMCUyMG91dHB1dHMucHJlZF9tYXNrcy5jcHUoKSUyQyUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm9yaWdpbmFsX3NpemVzJTIyJTVELmNwdSgpJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTVCJTIycmVzaGFwZWRfaW5wdXRfc2l6ZXMlMjIlNUQuY3B1KCklMEEpJTVCMCU1RCU1QjAlNUQlNUIwJTVELm51bXB5KCk=",highlighted:`<span class="hljs-comment"># bounding box around the bee</span>
box = [<span class="hljs-number">2350</span>, <span class="hljs-number">1600</span>, <span class="hljs-number">2850</span>, <span class="hljs-number">2100</span>]

inputs = processor(
        image,
        input_boxes=[[[box]]],
        return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
    ).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)

mask = processor.image_processor.post_process_masks(
    outputs.pred_masks.cpu(),
    inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>].cpu(),
    inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>].cpu()
)[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">0</span>].numpy()`,wrap:!1}}),ae=new h({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5wYXRjaGVzJTIwYXMlMjBwYXRjaGVzJTBBJTBBZmlnJTJDJTIwYXglMjAlM0QlMjBwbHQuc3VicGxvdHMoKSUwQWF4Lmltc2hvdyhpbWFnZSklMEElMEFyZWN0YW5nbGUlMjAlM0QlMjBwYXRjaGVzLlJlY3RhbmdsZSgoMjM1MCUyQyUyMDE2MDAlMkMlMjA1MDAlMkMlMjA1MDAlMkMlMjBsaW5ld2lkdGglM0QyJTJDJTIwZWRnZWNvbG9yJTNEJ3InJTJDJTIwZmFjZWNvbG9yJTNEJ25vbmUnKSUwQWF4LmFkZF9wYXRjaChyZWN0YW5nbGUpJTBBYXguYXhpcyglMjJvZmYlMjIpJTBBcGx0LnNob3coKQ==",highlighted:`<span class="hljs-keyword">import</span> matplotlib.patches <span class="hljs-keyword">as</span> patches

fig, ax = plt.subplots()
ax.imshow(image)

rectangle = patches.Rectangle((<span class="hljs-number">2350</span>, <span class="hljs-number">1600</span>, <span class="hljs-number">500</span>, <span class="hljs-number">500</span>, linewidth=<span class="hljs-number">2</span>, edgecolor=<span class="hljs-string">&#x27;r&#x27;</span>, facecolor=<span class="hljs-string">&#x27;none&#x27;</span>)
ax.add_patch(rectangle)
ax.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.show()`,wrap:!1}}),pe=new h({props:{code:"ZmlnJTJDJTIwYXglMjAlM0QlMjBwbHQuc3VicGxvdHMoKSUwQWF4Lmltc2hvdyhpbWFnZSklMEFheC5pbXNob3cobWFzayUyQyUyMGNtYXAlM0QndmlyaWRpcyclMkMlMjBhbHBoYSUzRDAuNCklMEElMEFheC5heGlzKCUyMm9mZiUyMiklMEFwbHQuc2hvdygp",highlighted:`fig, ax = plt.subplots()
ax.imshow(image)
ax.imshow(mask, cmap=<span class="hljs-string">&#x27;viridis&#x27;</span>, alpha=<span class="hljs-number">0.4</span>)

ax.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.show()`,wrap:!1}}),{c(){u=p("meta"),oe=a(),ie=p("p"),re=a(),m(f.$$.fragment),ye=a(),C=p("p"),C.innerHTML=ts,ce=a(),k=p("p"),k.textContent=as,Ue=a(),x=p("ul"),x.innerHTML=ns,he=a(),v=p("p"),v.innerHTML=ps,ue=a(),J=p("div"),J.innerHTML=is,Je=a(),B=p("p"),B.innerHTML=Ms,de=a(),I=p("p"),I.textContent=ms,je=a(),F=p("ul"),F.innerHTML=os,Te=a(),W=p("p"),W.innerHTML=rs,be=a(),m($.$$.fragment),ge=a(),m(N.$$.fragment),we=a(),Z=p("p"),Z.innerHTML=ys,fe=a(),m(Q.$$.fragment),Ce=a(),E=p("p"),E.textContent=cs,ke=a(),m(A.$$.fragment),xe=a(),d=p("div"),d.innerHTML=Us,ve=a(),G=p("p"),G.innerHTML=hs,Be=a(),m(z.$$.fragment),Ie=a(),H=p("p"),H.innerHTML=us,Fe=a(),m(R.$$.fragment),We=a(),Y=p("p"),Y.textContent=Js,$e=a(),m(_.$$.fragment),Ne=a(),V=p("p"),V.textContent=ds,Ze=a(),j=p("div"),j.innerHTML=js,Qe=a(),m(S.$$.fragment),Ee=a(),m(X.$$.fragment),Ae=a(),L=p("p"),L.textContent=Ts,Ge=a(),m(D.$$.fragment),ze=a(),q=p("p"),q.innerHTML=bs,He=a(),m(K.$$.fragment),Re=a(),P=p("p"),P.innerHTML=gs,Ye=a(),m(O.$$.fragment),_e=a(),T=p("div"),T.innerHTML=ws,Ve=a(),m(ee.$$.fragment),Se=a(),se=p("p"),se.innerHTML=fs,Xe=a(),m(le.$$.fragment),Le=a(),te=p("p"),te.textContent=Cs,De=a(),m(ae.$$.fragment),qe=a(),b=p("div"),b.innerHTML=ks,Ke=a(),ne=p("p"),ne.textContent=xs,Pe=a(),m(pe.$$.fragment),Oe=a(),g=p("div"),g.innerHTML=vs,es=a(),Me=p("p"),this.h()},l(e){const s=Zs("svelte-u9bgzb",document.head);u=i(s,"META",{name:!0,content:!0}),s.forEach(l),oe=n(e),ie=i(e,"P",{}),Bs(ie).forEach(l),re=n(e),o(f.$$.fragment,e),ye=n(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-11gpkf1"&&(C.innerHTML=ts),ce=n(e),k=i(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1efgayb"&&(k.textContent=as),Ue=n(e),x=i(e,"UL",{"data-svelte-h":!0}),M(x)!=="svelte-110gnfy"&&(x.innerHTML=ns),he=n(e),v=i(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-grokwa"&&(v.innerHTML=ps),ue=n(e),J=i(e,"DIV",{class:!0,"data-svelte-h":!0}),M(J)!=="svelte-18bgtyc"&&(J.innerHTML=is),Je=n(e),B=i(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-siwu7f"&&(B.innerHTML=Ms),de=n(e),I=i(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1xy9go1"&&(I.textContent=ms),je=n(e),F=i(e,"UL",{"data-svelte-h":!0}),M(F)!=="svelte-1xdcdcm"&&(F.innerHTML=os),Te=n(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1qvzz2d"&&(W.innerHTML=rs),be=n(e),o($.$$.fragment,e),ge=n(e),o(N.$$.fragment,e),we=n(e),Z=i(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-hy99c4"&&(Z.innerHTML=ys),fe=n(e),o(Q.$$.fragment,e),Ce=n(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-13rxk6q"&&(E.textContent=cs),ke=n(e),o(A.$$.fragment,e),xe=n(e),d=i(e,"DIV",{class:!0,"data-svelte-h":!0}),M(d)!=="svelte-5ac7qo"&&(d.innerHTML=Us),ve=n(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-xsc4t1"&&(G.innerHTML=hs),Be=n(e),o(z.$$.fragment,e),Ie=n(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-rg5py"&&(H.innerHTML=us),Fe=n(e),o(R.$$.fragment,e),We=n(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1kbs52p"&&(Y.textContent=Js),$e=n(e),o(_.$$.fragment,e),Ne=n(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-b8wd3m"&&(V.textContent=ds),Ze=n(e),j=i(e,"DIV",{class:!0,"data-svelte-h":!0}),M(j)!=="svelte-1xv3qg"&&(j.innerHTML=js),Qe=n(e),o(S.$$.fragment,e),Ee=n(e),o(X.$$.fragment,e),Ae=n(e),L=i(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-kmstl8"&&(L.textContent=Ts),Ge=n(e),o(D.$$.fragment,e),ze=n(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-kaodbx"&&(q.innerHTML=bs),He=n(e),o(K.$$.fragment,e),Re=n(e),P=i(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-zoqnl5"&&(P.innerHTML=gs),Ye=n(e),o(O.$$.fragment,e),_e=n(e),T=i(e,"DIV",{class:!0,"data-svelte-h":!0}),M(T)!=="svelte-od5m1y"&&(T.innerHTML=ws),Ve=n(e),o(ee.$$.fragment,e),Se=n(e),se=i(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1hby767"&&(se.innerHTML=fs),Xe=n(e),o(le.$$.fragment,e),Le=n(e),te=i(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-n8en77"&&(te.textContent=Cs),De=n(e),o(ae.$$.fragment,e),qe=n(e),b=i(e,"DIV",{class:!0,"data-svelte-h":!0}),M(b)!=="svelte-12t8f97"&&(b.innerHTML=ks),Ke=n(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-mexiag"&&(ne.textContent=xs),Pe=n(e),o(pe.$$.fragment,e),Oe=n(e),g=i(e,"DIV",{class:!0,"data-svelte-h":!0}),M(g)!=="svelte-1inger9"&&(g.innerHTML=vs),es=n(e),Me=i(e,"P",{}),Bs(Me).forEach(l),this.h()},h(){w(u,"name","hf:doc:metadata"),w(u,"content",As),w(J,"class","flex justify-center"),w(d,"class","flex justify-center"),w(j,"class","flex justify-center"),w(T,"class","flex justify-center"),w(b,"class","flex justify-center"),w(g,"class","flex justify-center")},m(e,s){Qs(document.head,u),t(e,oe,s),t(e,ie,s),t(e,re,s),r(f,e,s),t(e,ye,s),t(e,C,s),t(e,ce,s),t(e,k,s),t(e,Ue,s),t(e,x,s),t(e,he,s),t(e,v,s),t(e,ue,s),t(e,J,s),t(e,Je,s),t(e,B,s),t(e,de,s),t(e,I,s),t(e,je,s),t(e,F,s),t(e,Te,s),t(e,W,s),t(e,be,s),r($,e,s),t(e,ge,s),r(N,e,s),t(e,we,s),t(e,Z,s),t(e,fe,s),r(Q,e,s),t(e,Ce,s),t(e,E,s),t(e,ke,s),r(A,e,s),t(e,xe,s),t(e,d,s),t(e,ve,s),t(e,G,s),t(e,Be,s),r(z,e,s),t(e,Ie,s),t(e,H,s),t(e,Fe,s),r(R,e,s),t(e,We,s),t(e,Y,s),t(e,$e,s),r(_,e,s),t(e,Ne,s),t(e,V,s),t(e,Ze,s),t(e,j,s),t(e,Qe,s),r(S,e,s),t(e,Ee,s),r(X,e,s),t(e,Ae,s),t(e,L,s),t(e,Ge,s),r(D,e,s),t(e,ze,s),t(e,q,s),t(e,He,s),r(K,e,s),t(e,Re,s),t(e,P,s),t(e,Ye,s),r(O,e,s),t(e,_e,s),t(e,T,s),t(e,Ve,s),r(ee,e,s),t(e,Se,s),t(e,se,s),t(e,Xe,s),r(le,e,s),t(e,Le,s),t(e,te,s),t(e,De,s),r(ae,e,s),t(e,qe,s),t(e,b,s),t(e,Ke,s),t(e,ne,s),t(e,Pe,s),r(pe,e,s),t(e,Oe,s),t(e,g,s),t(e,es,s),t(e,Me,s),ss=!0},p:Fs,i(e){ss||(y(f.$$.fragment,e),y($.$$.fragment,e),y(N.$$.fragment,e),y(Q.$$.fragment,e),y(A.$$.fragment,e),y(z.$$.fragment,e),y(R.$$.fragment,e),y(_.$$.fragment,e),y(S.$$.fragment,e),y(X.$$.fragment,e),y(D.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(ae.$$.fragment,e),y(pe.$$.fragment,e),ss=!0)},o(e){c(f.$$.fragment,e),c($.$$.fragment,e),c(N.$$.fragment,e),c(Q.$$.fragment,e),c(A.$$.fragment,e),c(z.$$.fragment,e),c(R.$$.fragment,e),c(_.$$.fragment,e),c(S.$$.fragment,e),c(X.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),ss=!1},d(e){e&&(l(oe),l(ie),l(re),l(ye),l(C),l(ce),l(k),l(Ue),l(x),l(he),l(v),l(ue),l(J),l(Je),l(B),l(de),l(I),l(je),l(F),l(Te),l(W),l(be),l(ge),l(we),l(Z),l(fe),l(Ce),l(E),l(ke),l(xe),l(d),l(ve),l(G),l(Be),l(Ie),l(H),l(Fe),l(We),l(Y),l($e),l(Ne),l(V),l(Ze),l(j),l(Qe),l(Ee),l(Ae),l(L),l(Ge),l(ze),l(q),l(He),l(Re),l(P),l(Ye),l(_e),l(T),l(Ve),l(Se),l(se),l(Xe),l(Le),l(te),l(De),l(qe),l(b),l(Ke),l(ne),l(Pe),l(Oe),l(g),l(es),l(Me)),l(u),U(f,e),U($,e),U(N,e),U(Q,e),U(A,e),U(z,e),U(R,e),U(_,e),U(S,e),U(X,e),U(D,e),U(K,e),U(O,e),U(ee,e),U(le,e),U(ae,e),U(pe,e)}}}const As='{"title":"Mask Generation","local":"mask-generation","sections":[{"title":"Mask Generation Pipeline","local":"mask-generation-pipeline","sections":[],"depth":2},{"title":"Model Inference","local":"model-inference","sections":[{"title":"Point Prompting","local":"point-prompting","sections":[],"depth":3},{"title":"Box Prompting","local":"box-prompting","sections":[],"depth":3}],"depth":2}],"depth":1}';function Gs(ls){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends $s{constructor(u){super(),Ns(this,u,Gs,Es,Is,{})}}export{_s as component};
