import{s as ua,n as Ja,o as Ta}from"../chunks/scheduler.9bc65507.js";import{S as wa,i as Ua,g as l,s as r,u as y,m as ja,A as da,h as n,f as a,c as p,j as c,v as m,y as h,n as fa,k as i,o,a as t,w as M,d as u,t as J,x as T}from"../chunks/index.78c82d43.js";import{I as Vs}from"../chunks/IconCopyLink.bedaa44d.js";import{C as _}from"../chunks/CodeBlock.48618ec2.js";function Ia(Rs){let w,is,es,os,U,I,ts,v,Hs,K,Fs="Hyperparameter Search using Trainer API",hs,$,Gs='🤗 Transformers provides a <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> class optimized for training 🤗 Transformers models, making it easier to start training without manually writing your own training loop. The <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> provides API for hyperparameter search. This doc shows how to enable it in example.',cs,j,C,ls,q,Ss,O,zs="Hyperparameter Search backend",ys,k,Es=`<a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> supports four hyperparameter search backends currently:
<a href="https://optuna.org/" rel="nofollow">optuna</a>, <a href="https://sigopt.com/" rel="nofollow">sigopt</a>, <a href="https://docs.ray.io/en/latest/tune/index.html" rel="nofollow">raytune</a> and <a href="https://wandb.ai/site/sweeps" rel="nofollow">wandb</a>.`,ms,X,Ds="you should install them before using them as the hyperparameter search backend",Ms,x,us,d,b,ns,W,Ns,ss,Ps="How to enable Hyperparameter search in example",Js,Z,Ls="Define the hyperparameter search space, different backends need different format.",Ts,A,Ks='For sigopt, see sigopt <a href="https://docs.sigopt.com/ai-module-api-references/api_reference/objects/object_parameter" rel="nofollow">object_parameter</a>, it’s like following:',ws,B,Us,Y,Os='For optuna, see optuna <a href="https://optuna.readthedocs.io/en/stable/tutorial/10_key_features/002_configurations.html#sphx-glr-tutorial-10-key-features-002-configurations-py" rel="nofollow">object_parameter</a>, it’s like following:',js,V,ds,H,sa='For raytune, see raytune <a href="https://docs.ray.io/en/latest/tune/api/search_space.html" rel="nofollow">object_parameter</a>, it’s like following:',fs,S,Is,N,aa='For wandb, see wandb <a href="https://docs.wandb.ai/guides/sweeps/configuration" rel="nofollow">object_parameter</a>, it’s like following:',Cs,Q,bs,R,ea='Define a <code>model_init</code> function and pass it to the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a>, as an example:',gs,F,_s,G,ta='Create a <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> with your <code>model_init</code> function, training arguments, training and test datasets, and evaluation function:',vs,z,$s,E,la="Call hyperparameter search, get the best trial parameters, backend could be <code>&quot;optuna&quot;</code>/<code>&quot;sigopt&quot;</code>/<code>&quot;wandb&quot;</code>/<code>&quot;ray&quot;</code>. direction can be<code>&quot;minimize&quot;</code> or <code>&quot;maximize&quot;</code>, which indicates whether to optimize greater or lower objective.",qs,D,na="You could define your own compute_objective function, if not defined, the default compute_objective will be called, and the sum of eval metric like f1 is returned as objective value.",ks,P,Xs,f,g,rs,L,Qs,as,ra="Hyperparameter search For DDP finetune",xs,ps,Ws;return v=new Vs({}),q=new Vs({}),x=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdHVuYSUyRnNpZ29wdCUyRndhbmRiJTJGcmF5JTVCdHVuZSU1RCUyMA==",highlighted:"pip install optuna/sigopt/wandb/ray[tune] "}}),W=new Vs({}),B=new _({props:{code:"ZGVmJTIwc2lnb3B0X2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMmJvdW5kcyUyMiUzQSUyMCU3QiUyMm1pbiUyMiUzQSUyMDFlLTYlMkMlMjAlMjJtYXglMjIlM0ElMjAxZS00JTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlMkMlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZG91YmxlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY2F0ZWdvcmljYWxfdmFsdWVzJTIyJTNBJTIwJTVCJTIyMTYlMjIlMkMlMjAlMjIzMiUyMiUyQyUyMCUyMjY0JTIyJTJDJTIwJTIyMTI4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMnBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJjYXRlZ29yaWNhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sigopt_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;bounds&quot;</span>: {<span class="hljs-string">&quot;min&quot;</span>: <span class="hljs-number">1e-6</span>, <span class="hljs-string">&quot;max&quot;</span>: <span class="hljs-number">1e-4</span>}, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;double&quot;</span>},
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;categorical_values&quot;</span>: [<span class="hljs-string">&quot;16&quot;</span>, <span class="hljs-string">&quot;32&quot;</span>, <span class="hljs-string">&quot;64&quot;</span>, <span class="hljs-string">&quot;128&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;categorical&quot;</span>,
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ]`}}),V=new _({props:{code:"ZGVmJTIwb3B0dW5hX2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjB0cmlhbC5zdWdnZXN0X2Zsb2F0KCUyMmxlYXJuaW5nX3JhdGUlMjIlMkMlMjAxZS02JTJDJTIwMWUtNCUyQyUyMGxvZyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9jYXRlZ29yaWNhbCglMjJwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjIlMkMlMjAlNUIxNiUyQyUyMDMyJTJDJTIwNjQlMkMlMjAxMjglNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">optuna_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;learning_rate&quot;</span>: trial.suggest_float(<span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>, log=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: trial.suggest_categorical(<span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>, [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]),
<span class="hljs-meta">... </span>    }`}}),S=new _({props:{code:"ZGVmJTIwcmF5X2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjB0dW5lLmxvZ3VuaWZvcm0oMWUtNiUyQyUyMDFlLTQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwdHVuZS5jaG9pY2UoJTVCMTYlMkMlMjAzMiUyQyUyMDY0JTJDJTIwMTI4JTVEKSUyQyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">ray_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;learning_rate&quot;</span>: tune.loguniform(<span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: tune.choice([<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]),
<span class="hljs-meta">... </span>    }`}}),Q=new _({props:{code:"ZGVmJTIwd2FuZGJfaHBfc3BhY2UodHJpYWwpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0aG9kJTIyJTNBJTIwJTIycmFuZG9tJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljJTIyJTNBJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMm9iamVjdGl2ZSUyMiUyQyUyMCUyMmdvYWwlMjIlM0ElMjAlMjJtaW5pbWl6ZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWFybmluZ19yYXRlJTIyJTNBJTIwJTdCJTIyZGlzdHJpYnV0aW9uJTIyJTNBJTIwJTIydW5pZm9ybSUyMiUyQyUyMCUyMm1pbiUyMiUzQSUyMDFlLTYlMkMlMjAlMjJtYXglMjIlM0ElMjAxZS00JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwJTdCJTIydmFsdWVzJTIyJTNBJTIwJTVCMTYlMkMlMjAzMiUyQyUyMDY0JTJDJTIwMTI4JTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">wandb_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;method&quot;</span>: <span class="hljs-string">&quot;random&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;metric&quot;</span>: {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;objective&quot;</span>, <span class="hljs-string">&quot;goal&quot;</span>: <span class="hljs-string">&quot;minimize&quot;</span>},
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;learning_rate&quot;</span>: {<span class="hljs-string">&quot;distribution&quot;</span>: <span class="hljs-string">&quot;uniform&quot;</span>, <span class="hljs-string">&quot;min&quot;</span>: <span class="hljs-number">1e-6</span>, <span class="hljs-string">&quot;max&quot;</span>: <span class="hljs-number">1e-4</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: {<span class="hljs-string">&quot;values&quot;</span>: [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    }`}}),F=new _({props:{code:"ZGVmJTIwbW9kZWxfaW5pdCh0cmlhbCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9hcmdzLm1vZGVsX25hbWVfb3JfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZyb21fdGYlM0Rib29sKCUyMi5ja3B0JTIyJTIwaW4lMjBtb2RlbF9hcmdzLm1vZGVsX25hbWVfb3JfcGF0aCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWclM0Rjb25maWclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWNoZV9kaXIlM0Rtb2RlbF9hcmdzLmNhY2hlX2RpciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldmlzaW9uJTNEbW9kZWxfYXJncy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUyMGlmJTIwbW9kZWxfYXJncy51c2VfYXV0aF90b2tlbiUyMGVsc2UlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">model_init</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> AutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>        model_args.model_name_or_path,
<span class="hljs-meta">... </span>        from_tf=<span class="hljs-built_in">bool</span>(<span class="hljs-string">&quot;.ckpt&quot;</span> <span class="hljs-keyword">in</span> model_args.model_name_or_path),
<span class="hljs-meta">... </span>        config=config,
<span class="hljs-meta">... </span>        cache_dir=model_args.cache_dir,
<span class="hljs-meta">... </span>        revision=model_args.model_revision,
<span class="hljs-meta">... </span>        use_auth_token=<span class="hljs-literal">True</span> <span class="hljs-keyword">if</span> model_args.use_auth_token <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    )`}}),z=new _({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEc21hbGxfdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHNtYWxsX2V2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2luaXQlM0Rtb2RlbF9pbml0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=<span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=small_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=small_eval_dataset,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>    tokenizer=tokenizer,
<span class="hljs-meta">... </span>    model_init=model_init,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>)`}}),P=new _({props:{code:"YmVzdF90cmlhbCUyMCUzRCUyMHRyYWluZXIuaHlwZXJwYXJhbWV0ZXJfc2VhcmNoKCUwQSUyMCUyMCUyMCUyMGRpcmVjdGlvbiUzRCUyMm1heGltaXplJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmFja2VuZCUzRCUyMm9wdHVuYSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhwX3NwYWNlJTNEb3B0dW5hX2hwX3NwYWNlJTJDJTBBJTIwJTIwJTIwJTIwbl90cmlhbHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfb2JqZWN0aXZlJTNEY29tcHV0ZV9vYmplY3RpdmUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>best_trial = trainer.hyperparameter_search(
<span class="hljs-meta">... </span>    direction=<span class="hljs-string">&quot;maximize&quot;</span>,
<span class="hljs-meta">... </span>    backend=<span class="hljs-string">&quot;optuna&quot;</span>,
<span class="hljs-meta">... </span>    hp_space=optuna_hp_space,
<span class="hljs-meta">... </span>    n_trials=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    compute_objective=compute_objective,
<span class="hljs-meta">... </span>)`}}),L=new Vs({}),{c(){w=l("meta"),is=r(),es=l("p"),os=r(),U=l("h1"),I=l("a"),ts=l("span"),y(v.$$.fragment),Hs=r(),K=l("span"),K.textContent=Fs,hs=r(),$=l("p"),$.innerHTML=Gs,cs=r(),j=l("h2"),C=l("a"),ls=l("span"),y(q.$$.fragment),Ss=r(),O=l("span"),O.textContent=zs,ys=r(),k=l("p"),k.innerHTML=Es,ms=r(),X=l("p"),X.textContent=Ds,Ms=r(),y(x.$$.fragment),us=r(),d=l("h2"),b=l("a"),ns=l("span"),y(W.$$.fragment),Ns=r(),ss=l("span"),ss.textContent=Ps,Js=r(),Z=l("p"),Z.textContent=Ls,Ts=r(),A=l("p"),A.innerHTML=Ks,ws=r(),y(B.$$.fragment),Us=r(),Y=l("p"),Y.innerHTML=Os,js=r(),y(V.$$.fragment),ds=r(),H=l("p"),H.innerHTML=sa,fs=r(),y(S.$$.fragment),Is=r(),N=l("p"),N.innerHTML=aa,Cs=r(),y(Q.$$.fragment),bs=r(),R=l("p"),R.innerHTML=ea,gs=r(),y(F.$$.fragment),_s=r(),G=l("p"),G.innerHTML=ta,vs=r(),y(z.$$.fragment),$s=r(),E=l("p"),E.innerHTML=la,qs=r(),D=l("p"),D.textContent=na,ks=r(),y(P.$$.fragment),Xs=r(),f=l("h2"),g=l("a"),rs=l("span"),y(L.$$.fragment),Qs=r(),as=l("span"),as.textContent=ra,xs=ja(`

Currently, Hyperparameter search for DDP is enabled for optuna and sigopt. Only the rank-zero process will generate the search trial and pass the argument to other ranks.

`),ps=l("p"),this.h()},l(s){const e=da("svelte-1phssyn",document.head);w=n(e,"META",{name:!0,content:!0}),e.forEach(a),is=p(s),es=n(s,"P",{}),c(es).forEach(a),os=p(s),U=n(s,"H1",{class:!0});var Zs=c(U);I=n(Zs,"A",{id:!0,class:!0,href:!0});var pa=c(I);ts=n(pa,"SPAN",{});var ia=c(ts);m(v.$$.fragment,ia),ia.forEach(a),pa.forEach(a),Hs=p(Zs),K=n(Zs,"SPAN",{"data-svelte-h":!0}),h(K)!=="svelte-lwg3h1"&&(K.textContent=Fs),Zs.forEach(a),hs=p(s),$=n(s,"P",{"data-svelte-h":!0}),h($)!=="svelte-1e2cumw"&&($.innerHTML=Gs),cs=p(s),j=n(s,"H2",{class:!0});var As=c(j);C=n(As,"A",{id:!0,class:!0,href:!0});var oa=c(C);ls=n(oa,"SPAN",{});var ha=c(ls);m(q.$$.fragment,ha),ha.forEach(a),oa.forEach(a),Ss=p(As),O=n(As,"SPAN",{"data-svelte-h":!0}),h(O)!=="svelte-4ugnks"&&(O.textContent=zs),As.forEach(a),ys=p(s),k=n(s,"P",{"data-svelte-h":!0}),h(k)!=="svelte-o78eb6"&&(k.innerHTML=Es),ms=p(s),X=n(s,"P",{"data-svelte-h":!0}),h(X)!=="svelte-ttiwiu"&&(X.textContent=Ds),Ms=p(s),m(x.$$.fragment,s),us=p(s),d=n(s,"H2",{class:!0});var Bs=c(d);b=n(Bs,"A",{id:!0,class:!0,href:!0});var ca=c(b);ns=n(ca,"SPAN",{});var ya=c(ns);m(W.$$.fragment,ya),ya.forEach(a),ca.forEach(a),Ns=p(Bs),ss=n(Bs,"SPAN",{"data-svelte-h":!0}),h(ss)!=="svelte-1ftd6u7"&&(ss.textContent=Ps),Bs.forEach(a),Js=p(s),Z=n(s,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-1jwax0f"&&(Z.textContent=Ls),Ts=p(s),A=n(s,"P",{"data-svelte-h":!0}),h(A)!=="svelte-dng8fq"&&(A.innerHTML=Ks),ws=p(s),m(B.$$.fragment,s),Us=p(s),Y=n(s,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-1o2m9k6"&&(Y.innerHTML=Os),js=p(s),m(V.$$.fragment,s),ds=p(s),H=n(s,"P",{"data-svelte-h":!0}),h(H)!=="svelte-1fs958e"&&(H.innerHTML=sa),fs=p(s),m(S.$$.fragment,s),Is=p(s),N=n(s,"P",{"data-svelte-h":!0}),h(N)!=="svelte-uzyw2c"&&(N.innerHTML=aa),Cs=p(s),m(Q.$$.fragment,s),bs=p(s),R=n(s,"P",{"data-svelte-h":!0}),h(R)!=="svelte-r8tyk5"&&(R.innerHTML=ea),gs=p(s),m(F.$$.fragment,s),_s=p(s),G=n(s,"P",{"data-svelte-h":!0}),h(G)!=="svelte-u8jkao"&&(G.innerHTML=ta),vs=p(s),m(z.$$.fragment,s),$s=p(s),E=n(s,"P",{"data-svelte-h":!0}),h(E)!=="svelte-rd47zq"&&(E.innerHTML=la),qs=p(s),D=n(s,"P",{"data-svelte-h":!0}),h(D)!=="svelte-v9khww"&&(D.textContent=na),ks=p(s),m(P.$$.fragment,s),Xs=p(s),f=n(s,"H2",{class:!0});var Ys=c(f);g=n(Ys,"A",{id:!0,class:!0,href:!0});var ma=c(g);rs=n(ma,"SPAN",{});var Ma=c(rs);m(L.$$.fragment,Ma),Ma.forEach(a),ma.forEach(a),Qs=p(Ys),as=n(Ys,"SPAN",{"data-svelte-h":!0}),h(as)!=="svelte-isw2d7"&&(as.textContent=ra),Ys.forEach(a),xs=fa(s,`

Currently, Hyperparameter search for DDP is enabled for optuna and sigopt. Only the rank-zero process will generate the search trial and pass the argument to other ranks.

`),ps=n(s,"P",{}),c(ps).forEach(a),this.h()},h(){i(w,"name","hf:doc:metadata"),i(w,"content",JSON.stringify(Ca)),i(I,"id","hyperparameter-search-using-trainer-api"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#hyperparameter-search-using-trainer-api"),i(U,"class","relative group"),i(C,"id","hyperparameter-search-backend"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#hyperparameter-search-backend"),i(j,"class","relative group"),i(b,"id","how-to-enable-hyperparameter-search-in-example"),i(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(b,"href","#how-to-enable-hyperparameter-search-in-example"),i(d,"class","relative group"),i(g,"id","hyperparameter-search-for-ddp-finetune"),i(g,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(g,"href","#hyperparameter-search-for-ddp-finetune"),i(f,"class","relative group")},m(s,e){o(document.head,w),t(s,is,e),t(s,es,e),t(s,os,e),t(s,U,e),o(U,I),o(I,ts),M(v,ts,null),o(U,Hs),o(U,K),t(s,hs,e),t(s,$,e),t(s,cs,e),t(s,j,e),o(j,C),o(C,ls),M(q,ls,null),o(j,Ss),o(j,O),t(s,ys,e),t(s,k,e),t(s,ms,e),t(s,X,e),t(s,Ms,e),M(x,s,e),t(s,us,e),t(s,d,e),o(d,b),o(b,ns),M(W,ns,null),o(d,Ns),o(d,ss),t(s,Js,e),t(s,Z,e),t(s,Ts,e),t(s,A,e),t(s,ws,e),M(B,s,e),t(s,Us,e),t(s,Y,e),t(s,js,e),M(V,s,e),t(s,ds,e),t(s,H,e),t(s,fs,e),M(S,s,e),t(s,Is,e),t(s,N,e),t(s,Cs,e),M(Q,s,e),t(s,bs,e),t(s,R,e),t(s,gs,e),M(F,s,e),t(s,_s,e),t(s,G,e),t(s,vs,e),M(z,s,e),t(s,$s,e),t(s,E,e),t(s,qs,e),t(s,D,e),t(s,ks,e),M(P,s,e),t(s,Xs,e),t(s,f,e),o(f,g),o(g,rs),M(L,rs,null),o(f,Qs),o(f,as),t(s,xs,e),t(s,ps,e),Ws=!0},p:Ja,i(s){Ws||(u(v.$$.fragment,s),u(q.$$.fragment,s),u(x.$$.fragment,s),u(W.$$.fragment,s),u(B.$$.fragment,s),u(V.$$.fragment,s),u(S.$$.fragment,s),u(Q.$$.fragment,s),u(F.$$.fragment,s),u(z.$$.fragment,s),u(P.$$.fragment,s),u(L.$$.fragment,s),Ws=!0)},o(s){J(v.$$.fragment,s),J(q.$$.fragment,s),J(x.$$.fragment,s),J(W.$$.fragment,s),J(B.$$.fragment,s),J(V.$$.fragment,s),J(S.$$.fragment,s),J(Q.$$.fragment,s),J(F.$$.fragment,s),J(z.$$.fragment,s),J(P.$$.fragment,s),J(L.$$.fragment,s),Ws=!1},d(s){s&&(a(is),a(es),a(os),a(U),a(hs),a($),a(cs),a(j),a(ys),a(k),a(ms),a(X),a(Ms),a(us),a(d),a(Js),a(Z),a(Ts),a(A),a(ws),a(Us),a(Y),a(js),a(ds),a(H),a(fs),a(Is),a(N),a(Cs),a(bs),a(R),a(gs),a(_s),a(G),a(vs),a($s),a(E),a(qs),a(D),a(ks),a(Xs),a(f),a(xs),a(ps)),a(w),T(v),T(q),T(x,s),T(W),T(B,s),T(V,s),T(S,s),T(Q,s),T(F,s),T(z,s),T(P,s),T(L)}}}const Ca={local:"hyperparameter-search-using-trainer-api",sections:[{local:"hyperparameter-search-backend",title:"Hyperparameter Search backend"},{local:"how-to-enable-hyperparameter-search-in-example",title:"How to enable Hyperparameter search in example"},{local:"hyperparameter-search-for-ddp-finetune",title:"Hyperparameter search For DDP finetune"}],title:"Hyperparameter Search using Trainer API"};function ba(Rs){return Ta(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qa extends wa{constructor(w){super(),Ua(this,w,ba,Ia,ua,{})}}export{qa as component};
