import{s as Dt,f as Kt,o as Pt,n as W}from"../chunks/scheduler.bdbef820.js";import{S as Ot,i as el,g as d,s as J,r as u,A as tl,h as U,f as s,c,j as ut,u as h,x as y,k as ke,y as ll,a as n,v as f,d as w,t as b,w as j}from"../chunks/index.33f81d56.js";import{T as N}from"../chunks/Tip.34194030.js";import{C as X}from"../chunks/CodeBlock.362b34a4.js";import{H as P,E as sl}from"../chunks/EditOnGithub.a9246e21.js";import{H as ht,a as Ge}from"../chunks/HfOption.6b792247.js";function al(V){let t,r='Hugging Face는 LLM을 추론에 최적화하여 배포하고 서비스하는 데 전념하는 라이브러리인 <a href="https://hf.co/docs/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a>을 제공합니다. 이 라이브러리는 처리량 증가를 위한 지속적인 배칭과 다중 GPU 추론을 위한 텐서 병렬화와 같은 Transformers에 포함되지 않은 배포 지향 최적화 기능을 포함합니다.';return{c(){t=d("p"),t.innerHTML=r},l(l){t=U(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-9ielvc"&&(t.innerHTML=r)},m(l,o){n(l,t,o)},p:W,d(l){l&&s(t)}}}function nl(V){let t,r='현재 <a href="./model_doc/llama2">Llama</a> 및 몇 가지 다른 모델만 정적 kv-cache와 <code>torch.compile</code>을 지원합니다. 실시간 모델 호환성 목록은 <a href="https://github.com/huggingface/transformers/issues/28981" rel="nofollow">이 이슈</a>를 확인하십시오.';return{c(){t=d("p"),t.innerHTML=r},l(l){t=U(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-1oypbst"&&(t.innerHTML=r)},m(l,o){n(l,t,o)},p:W,d(l){l&&s(t)}}}function ol(V){let t,r='<code>torch.compile</code>을 사용할 때 어떤 전략을 사용하든, LLM 입력을 제한된 값 세트로 왼쪽에 패딩하면 모양과 관련된 재컴파일을 피할 수 있습니다. <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizer.__call__.pad_to_multiple_of" rel="nofollow"><code>pad_to_multiple_of</code> tokenizer flag</a>가 유용할 것입니다!';return{c(){t=d("p"),t.innerHTML=r},l(l){t=U(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-1y0azda"&&(t.innerHTML=r)},m(l,o){n(l,t,o)},p:W,d(l){l&&s(t)}}}function pl(V){let t,r='다중 턴 대화와 같은 정적 캐시의 고급 사용을 위해서는, 캐시 객체를 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 외부에서 인스턴스화하고 조작하는 것을 권장합니다. 고급 사용법 탭을 참조하세요.';return{c(){t=d("p"),t.innerHTML=r},l(l){t=U(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-ycigin"&&(t.innerHTML=r)},m(l,o){n(l,t,o)},p:W,d(l){l&&s(t)}}}function il(V){let t,r='이 예제에서는 <a href="https://hf.co/google/gemma-2b" rel="nofollow">Gemma</a> 모델을 사용해 보겠습니다. 필요한 작업은 다음과 같습니다:',l,o,p="<li>모델의 <code>generation_config</code> 속성에 접근하여 <code>cache_implementation</code>을 “static”으로 설정합니다;</li> <li>모델의 <code>forward</code> 패스를 정적 kv-cache와 함께 컴파일하기 위해 <code>torch.compile</code>을 호출합니다.</li>",i,T,Z="이렇게 하면 끝입니다!",$,C,_,I,G="<code>generate</code> 함수는 내부적으로 동일한 캐시 객체를 재사용하려고 시도하며, 이를 통해 각 호출 시 재컴파일의 필요성을 제거합니다. 재컴파일을 피하는 것은 <code>torch.compile</code>의 성능을 최대한 활용하는 데 매우 중요하며, 다음 사항에 유의해야 합니다:",Q,R,g="<li>배치 크기가 변경되거나 호출 간 최대 출력 길이가 증가하면 캐시를 다시 초기화해야 하며, 이로 인해 새로 컴파일을 해야 합니다;</li> <li>컴파일된 함수의 첫 몇 번의 호출은 함수가 컴파일되는 동안 더 느립니다.</li>",F,B,v;return C=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwJUVBJUI4JUI0JTIwJUVBJUIyJUJEJUVBJUIzJUEwJTIwJUVCJUE5JTk0JUVDJThCJTlDJUVDJUE3JTgwJUVCJUE1JUJDJTIwJUVCJUIwJUE5JUVDJUE3JTgwJUVEJTk1JTk4JUVBJUI4JUIwJTIwJUVDJTlDJTg0JUVEJTk1JUI0JTIwJUVDJTg0JUE0JUVDJUEwJTk1JTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuY2FjaGVfaW1wbGVtZW50YXRpb24lMjAlM0QlMjAlMjJzdGF0aWMlMjIlMEElMEFtb2RlbC5mb3J3YXJkJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbC5mb3J3YXJkJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUInVGhlJTIwdGhlb3J5JTIwb2YlMjBzcGVjaWFsJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMDEuJTIwVGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudCUyMGluJTIwYWxsJTIwaW5lcnRpYWwlMjByZWZlcmVuY2UnJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># 긴 경고 메시지를 방지하기 위해 설정 :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generation_config.cache_implementation = <span class="hljs-string">&quot;static&quot;</span>

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),B=new N({props:{warning:!0,$$slots:{default:[pl]},$$scope:{ctx:V}}}),{c(){t=d("p"),t.innerHTML=r,l=J(),o=d("ol"),o.innerHTML=p,i=J(),T=d("p"),T.textContent=Z,$=J(),u(C.$$.fragment),_=J(),I=d("p"),I.innerHTML=G,Q=J(),R=d("ol"),R.innerHTML=g,F=J(),u(B.$$.fragment)},l(m){t=U(m,"P",{"data-svelte-h":!0}),y(t)!=="svelte-zgi424"&&(t.innerHTML=r),l=c(m),o=U(m,"OL",{"data-svelte-h":!0}),y(o)!=="svelte-1eyfj2k"&&(o.innerHTML=p),i=c(m),T=U(m,"P",{"data-svelte-h":!0}),y(T)!=="svelte-1li9iek"&&(T.textContent=Z),$=c(m),h(C.$$.fragment,m),_=c(m),I=U(m,"P",{"data-svelte-h":!0}),y(I)!=="svelte-13n4tf3"&&(I.innerHTML=G),Q=c(m),R=U(m,"OL",{"data-svelte-h":!0}),y(R)!=="svelte-1b9xyp9"&&(R.innerHTML=g),F=c(m),h(B.$$.fragment,m)},m(m,M){n(m,t,M),n(m,l,M),n(m,o,M),n(m,i,M),n(m,T,M),n(m,$,M),f(C,m,M),n(m,_,M),n(m,I,M),n(m,Q,M),n(m,R,M),n(m,F,M),f(B,m,M),v=!0},p(m,M){const k={};M&2&&(k.$$scope={dirty:M,ctx:m}),B.$set(k)},i(m){v||(w(C.$$.fragment,m),w(B.$$.fragment,m),v=!0)},o(m){b(C.$$.fragment,m),b(B.$$.fragment,m),v=!1},d(m){m&&(s(t),s(l),s(o),s(i),s(T),s($),s(_),s(I),s(Q),s(R),s(F)),j(C,m),j(B,m)}}}function rl(V){let t,r='동일한 <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.StaticCache">StaticCache</a> 객체를 새로운 프롬프트에 사용하려면, 호출 간에 <code>.reset()</code> 메서드를 사용하여 그 내용을 초기화하는 것이 좋습니다.';return{c(){t=d("p"),t.innerHTML=r},l(l){t=U(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-3i24c8"&&(t.innerHTML=r)},m(l,o){n(l,t,o)},p:W,d(l){l&&s(t)}}}function Jl(V){let t,r='<a href="/docs/transformers/main/ko/internal/generation_utils#transformers.StaticCache">StaticCache</a> 객체는 <code>past_key_values</code> 인수로 모델의 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 함수에 전달할 수 있습니다. 이 객체는 캐시 내용을 유지하므로, 동적 캐시를 사용하는 것처럼 새로운 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 호출에 이를 전달하여 생성을 계속할 수 있습니다.',l,o,p,i,T,Z,$='더 깊이 들어가고 싶다면, <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.StaticCache">StaticCache</a> 객체를 모델의 <code>forward</code> 패스에 동일한 <code>past_key_values</code> 인수로 전달할 수도 있습니다. 이 전략을 사용하면, 현재 토큰과 이전에 생성된 토큰의 위치 및 캐시 위치를 바탕으로 다음 토큰을 디코딩하는 자체 함수를 작성할 수 있습니다.',C,_,I,G,Q="<code>StaticCache</code> 메서드를 사용하여 정적 kv-cache와 <code>torch.compile</code>을 활성화하려면 몇 가지 중요한 작업을 수행해야 합니다:",R,g,F='<li>추론에 모델을 사용하기 전에 <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.StaticCache">StaticCache</a> 인스턴스를 초기화합니다. 여기서 최대 배치 크기와 시퀀스 길이와 같은 매개변수를 설정할 수 있습니다.</li> <li>정적 kv-cache와 함께 순전파를 컴파일하기 위해 모델에 <code>torch.compile</code>을 호출합니다.</li> <li><a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.backends.cuda.sdp_kernel</a> 컨텍스트 관리자에서 <code>enable_math=True</code>를 설정하여 네이티브 PyTorch C++ 구현된 스케일된 점곱 어텐션(scaled dot product attention)을 활성화하여 추론 속도를 더욱 높입니다.</li>',B,v,m;return o=new X({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, StaticCache
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># 긴 경고 메시지를 방지하기 위해 설정 :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt_length = input_ids.input_ids.shape[<span class="hljs-number">1</span>]
model.generation_config.max_new_tokens = <span class="hljs-number">16</span>

past_key_values = StaticCache(
    config=model.config,
    batch_size=<span class="hljs-number">1</span>,
    <span class="hljs-comment"># 캐시를 재사용할 계획이 있는 경우, 모든 경우에 충분한 캐시 길이를 설정해야 합니다</span>
    max_cache_len=prompt_length+(model.generation_config.max_new_tokens*<span class="hljs-number">2</span>),
    device=model.device,
    dtype=model.dtype
)
outputs = model.generate(**input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2&#x27;</span>]

<span class="hljs-comment"># 생성된 텍스트와 동일한 캐시 객체를 전달하여, 중단한 곳에서 생성을 계속합니다. </span>
<span class="hljs-comment"># 다중 턴 대화의 경우, 생성된 텍스트에 새로운 사용자 입력을 추가할 수 있습니다.</span>
new_input_ids = outputs
outputs = model.generate(new_input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2. The speed of light is constant in all inertial reference frames. 3.&#x27;</span>]`,wrap:!1}}),i=new N({props:{warning:!1,$$slots:{default:[rl]},$$scope:{ctx:V}}}),_=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hVG9rZW5pemVyJTJDJTIwTGxhbWFGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTJDJTIwbG9nZ2luZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMudGVzdGluZ191dGlscyUyMGltcG9ydCUyMENhcHR1cmVMb2dnZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJTaW1wbHklMjBwdXQlMkMlMjB0aGUlMjB0aGVvcnklMjBvZiUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjB0aGF0JTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyTXklMjBmYXZvcml0ZSUyMGFsbCUyMHRpbWUlMjBmYXZvcml0ZSUyMGNvbmRpbWVudCUyMGlzJTIwa2V0Y2h1cC4lMjIlMkMlMEElNUQlMEElMEFOVU1fVE9LRU5TX1RPX0dFTkVSQVRFJTIwJTNEJTIwNDAlMEF0b3JjaF9kZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwTGxhbWFUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWhmJTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMnJpZ2h0JTIyKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItaGYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyc2VxdWVudGlhbCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSkudG8obW9kZWwuZGV2aWNlKSUwQSUwQWRlZiUyMGRlY29kZV9vbmVfdG9rZW5zKG1vZGVsJTJDJTIwY3VyX3Rva2VuJTJDJTIwaW5wdXRfcG9zJTJDJTIwY2FjaGVfcG9zaXRpb24lMkMlMjBwYXN0X2tleV92YWx1ZXMpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3VyX3Rva2VuJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zaXRpb25faWRzJTNEaW5wdXRfcG9zJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FjaGVfcG9zaXRpb24lM0RjYWNoZV9wb3NpdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybl9kaWN0JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2VfY2FjaGUlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKSU1QjAlNUQlMEElMjAlMjAlMjAlMjBuZXdfdG9rZW4lMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTVCJTNBJTJDJTIwLTElNUQlMkMlMjBkaW0lM0QtMSklNUIlM0ElMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbmV3X3Rva2Vu",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaTokenizer, LlamaForCausalLM, StaticCache, logging
<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> CaptureLogger
<span class="hljs-keyword">import</span> torch

prompts = [
    <span class="hljs-string">&quot;Simply put, the theory of relativity states that &quot;</span>,
    <span class="hljs-string">&quot;My favorite all time favorite condiment is ketchup.&quot;</span>,
]

NUM_TOKENS_TO_GENERATE = <span class="hljs-number">40</span>
torch_device = <span class="hljs-string">&quot;cuda&quot;</span>

tokenizer = LlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>, padding_side=<span class="hljs-string">&quot;right&quot;</span>)
model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, device_map=<span class="hljs-string">&quot;sequential&quot;</span>)
inputs = tokenizer(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>).to(model.device)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_one_tokens</span>(<span class="hljs-params">model, cur_token, input_pos, cache_position, past_key_values</span>):
    logits = model(
        cur_token,
        position_ids=input_pos,
        cache_position=cache_position,
        past_key_values=past_key_values,
        return_dict=<span class="hljs-literal">False</span>,
        use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    new_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">return</span> new_token`,wrap:!1}}),v=new X({props:{code:"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",highlighted:`batch_size, seq_length = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape
<span class="hljs-keyword">with</span> torch.no_grad():
    past_key_values = StaticCache(
        config=model.config, max_batch_size=<span class="hljs-number">2</span>, max_cache_len=<span class="hljs-number">4096</span>, device=torch_device, dtype=model.dtype
    )
    cache_position = torch.arange(seq_length, device=torch_device)
    generated_ids = torch.zeros(
        batch_size, seq_length + NUM_TOKENS_TO_GENERATE + <span class="hljs-number">1</span>, dtype=torch.<span class="hljs-built_in">int</span>, device=torch_device
    )
    generated_ids[:, cache_position] = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(torch_device).to(torch.<span class="hljs-built_in">int</span>)

    logits = model(
        **inputs, cache_position=cache_position, past_key_values=past_key_values,return_dict=<span class="hljs-literal">False</span>, use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    next_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    generated_ids[:, seq_length] = next_token[:, <span class="hljs-number">0</span>]

    decode_one_tokens = torch.<span class="hljs-built_in">compile</span>(decode_one_tokens, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    cache_position = torch.tensor([seq_length + <span class="hljs-number">1</span>], device=torch_device)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, NUM_TOKENS_TO_GENERATE):
        <span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>, enable_math=<span class="hljs-literal">True</span>):
            next_token = decode_one_tokens(model, next_token.clone(), <span class="hljs-literal">None</span>, cache_position, past_key_values)
            generated_ids[:, cache_position] = next_token.<span class="hljs-built_in">int</span>()
        cache_position += <span class="hljs-number">1</span>

text = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
text
[<span class="hljs-string">&#x27;Simply put, the theory of relativity states that 1) the speed of light is constant, 2) the speed of light is the same for all observers, and 3) the laws of physics are the same for all observers.&#x27;</span>,
 <span class="hljs-string">&#x27;My favorite all time favorite condiment is ketchup. I love it on everything. I love it on my eggs, my fries, my chicken, my burgers, my hot dogs, my sandwiches, my salads, my p&#x27;</span>]`,wrap:!1}}),{c(){t=d("p"),t.innerHTML=r,l=J(),u(o.$$.fragment),p=J(),u(i.$$.fragment),T=J(),Z=d("p"),Z.innerHTML=$,C=J(),u(_.$$.fragment),I=J(),G=d("p"),G.innerHTML=Q,R=J(),g=d("ol"),g.innerHTML=F,B=J(),u(v.$$.fragment)},l(M){t=U(M,"P",{"data-svelte-h":!0}),y(t)!=="svelte-1dmwvmx"&&(t.innerHTML=r),l=c(M),h(o.$$.fragment,M),p=c(M),h(i.$$.fragment,M),T=c(M),Z=U(M,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-6zphge"&&(Z.innerHTML=$),C=c(M),h(_.$$.fragment,M),I=c(M),G=U(M,"P",{"data-svelte-h":!0}),y(G)!=="svelte-1tznqst"&&(G.innerHTML=Q),R=c(M),g=U(M,"OL",{"data-svelte-h":!0}),y(g)!=="svelte-5jrift"&&(g.innerHTML=F),B=c(M),h(v.$$.fragment,M)},m(M,k){n(M,t,k),n(M,l,k),f(o,M,k),n(M,p,k),f(i,M,k),n(M,T,k),n(M,Z,k),n(M,C,k),f(_,M,k),n(M,I,k),n(M,G,k),n(M,R,k),n(M,g,k),n(M,B,k),f(v,M,k),m=!0},p(M,k){const E={};k&2&&(E.$$scope={dirty:k,ctx:M}),i.$set(E)},i(M){m||(w(o.$$.fragment,M),w(i.$$.fragment,M),w(_.$$.fragment,M),w(v.$$.fragment,M),m=!0)},o(M){b(o.$$.fragment,M),b(i.$$.fragment,M),b(_.$$.fragment,M),b(v.$$.fragment,M),m=!1},d(M){M&&(s(t),s(l),s(p),s(T),s(Z),s(C),s(I),s(G),s(R),s(g),s(B)),j(o,M),j(i,M),j(_,M),j(v,M)}}}function cl(V){let t,r="전체 <code>generate</code> 함수를 컴파일하는 것은 코드 측면에서 기본 사용법보다 더 간단합니다. <code>generate</code> 함수에 대해 <code>torch.compile</code>을 호출하여 전체 함수를 컴파일하면 됩니다. 정적 캐시의 사용을 지정할 필요는 없습니다. 정적 캐시는 호환되지만, 벤치마크에서는 동적 캐시(기본 설정)가 더 빠른 것으로 나타났습니다.",l,o,p,i,T="이 방법을 통해 모델의 forward 패스뿐만 아니라, 입력 준비, logit 처리기 작업 등을 포함한 모든 것을 컴파일합니다. 기본 사용 예제에 비해 <code>generate</code> 호출이 약간 더 빠를 수 있으며, 컴파일된 그래프는 더 특이한 하드웨어 장치나 사용 사례에 적합할 수 있습니다. 그러나 이 접근 방식을 사용하는 데는 몇 가지 큰 단점이 있습니다:",Z,$,C="<li>컴파일 속도가 훨씬 느립니다;</li> <li><code>generate</code>의 모든 매개변수 설정은 <code>generation_config</code>를 통해서만 가능합니다;</li> <li>많은 경고와 예외가 억제됩니다. — 먼저 컴파일 되지 않은 형태로 테스트하는 것을 권장합니다;</li> <li>현재 작업 중이지만 기능 제한이 심합니다(예: 작성 시점에서는 EOS 토큰이 선택되어도 생성이 중단되지 않습니다).</li>",_;return o=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwJUVBJUI4JUI0JTIwJUVBJUIyJUJEJUVBJUIzJUEwJTIwJUVCJUE5JTk0JUVDJThCJTlDJUVDJUE3JTgwJUVCJUE1JUJDJTIwJUVCJUIwJUE5JUVDJUE3JTgwJUVEJTk1JTk4JUVBJUI4JUIwJTIwJUVDJTlDJTg0JUVEJTk1JUI0JTIwJUVDJTg0JUE0JUVDJUEwJTk1JTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsLmdlbmVyYXRlJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUInVGhlJTIwdGhlb3J5JTIwb2YlMjBzcGVjaWFsJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMDEuJTIwVGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudCUyMGluJTIwYWxsJTIwaW5lcnRpYWwlMjByZWZlcmVuY2UnJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># 긴 경고 메시지를 방지하기 위해 설정 :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generate = torch.<span class="hljs-built_in">compile</span>(model.generate, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),{c(){t=d("p"),t.innerHTML=r,l=J(),u(o.$$.fragment),p=J(),i=d("p"),i.innerHTML=T,Z=J(),$=d("ol"),$.innerHTML=C},l(I){t=U(I,"P",{"data-svelte-h":!0}),y(t)!=="svelte-gsicdl"&&(t.innerHTML=r),l=c(I),h(o.$$.fragment,I),p=c(I),i=U(I,"P",{"data-svelte-h":!0}),y(i)!=="svelte-q1zvmc"&&(i.innerHTML=T),Z=c(I),$=U(I,"OL",{"data-svelte-h":!0}),y($)!=="svelte-1h1n9r2"&&($.innerHTML=C)},m(I,G){n(I,t,G),n(I,l,G),f(o,I,G),n(I,p,G),n(I,i,G),n(I,Z,G),n(I,$,G),_=!0},p:W,i(I){_||(w(o.$$.fragment,I),_=!0)},o(I){b(o.$$.fragment,I),_=!1},d(I){I&&(s(t),s(l),s(p),s(i),s(Z),s($)),j(o,I)}}}function Ml(V){let t,r,l,o,p,i;return t=new Ge({props:{id:"static-kv",option:"basic usage: generation_config",$$slots:{default:[il]},$$scope:{ctx:V}}}),l=new Ge({props:{id:"static-kv",option:"advanced usage: control Static Cache",$$slots:{default:[Jl]},$$scope:{ctx:V}}}),p=new Ge({props:{id:"static-kv",option:"advanced usage: end-to-end generate compilation",$$slots:{default:[cl]},$$scope:{ctx:V}}}),{c(){u(t.$$.fragment),r=J(),u(l.$$.fragment),o=J(),u(p.$$.fragment)},l(T){h(t.$$.fragment,T),r=c(T),h(l.$$.fragment,T),o=c(T),h(p.$$.fragment,T)},m(T,Z){f(t,T,Z),n(T,r,Z),f(l,T,Z),n(T,o,Z),f(p,T,Z),i=!0},p(T,Z){const $={};Z&2&&($.$$scope={dirty:Z,ctx:T}),t.$set($);const C={};Z&2&&(C.$$scope={dirty:Z,ctx:T}),l.$set(C);const _={};Z&2&&(_.$$scope={dirty:Z,ctx:T}),p.$set(_)},i(T){i||(w(t.$$.fragment,T),w(l.$$.fragment,T),w(p.$$.fragment,T),i=!0)},o(T){b(t.$$.fragment,T),b(l.$$.fragment,T),b(p.$$.fragment,T),i=!1},d(T){T&&(s(r),s(o)),j(t,T),j(l,T),j(p,T)}}}function Tl(V){let t,r='보다 심층적인 설명을 원한다면, <a href="https://hf.co/blog/assisted-generation" rel="nofollow">Assisted Generation: a new direction toward low-latency text generation</a> 블로그 게시물을 확인하십시오!';return{c(){t=d("p"),t.innerHTML=r},l(l){t=U(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-144tzha"&&(t.innerHTML=r)},m(l,o){n(l,t,o)},p:W,d(l){l&&s(t)}}}function ml(V){let t,r="추정 디코딩은 탐욕 검색과 샘플링 디코딩 전략에서만 지원되며, 배치 입력을 지원하지 않습니다.";return{c(){t=d("p"),t.textContent=r},l(l){t=U(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11g2hie"&&(t.textContent=r)},m(l,o){n(l,t,o)},p:W,d(l){l&&s(t)}}}function dl(V){let t,r;return t=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGFzc2lzdGFudF9tb2RlbCUzRGFzc2lzdGFudF9tb2RlbCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElNUIlMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIwdGhhdCUyMHRoZSUyMHNwZWVkJTIwb2YlMjBsaWdodCUyMGlzJTIwY29uc3RhbnQuJTIwJTIwJTIwJTIwJTIyJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model)
tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that the speed of light is constant.    &quot;</span>]`,wrap:!1}}),{c(){u(t.$$.fragment)},l(l){h(t.$$.fragment,l)},m(l,o){f(t,l,o),r=!0},p:W,i(l){r||(w(t.$$.fragment,l),r=!0)},o(l){b(t.$$.fragment,l),r=!1},d(l){j(t,l)}}}function Ul(V){let t,r='추정 샘플링 디코딩(speculative sampling decoding)을 위해, 보조 모델 외에도 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 메서드에 <code>do_sample</code> 및 <code>temperature</code> 매개변수를 추가하십시오.',l,o,p;return o=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGFzc2lzdGFudF9tb2RlbCUzRGFzc2lzdGFudF9tb2RlbCUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0ZW1wZXJhdHVyZSUzRDAuNyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJTIyRWluc3RlaW4ncyUyMHRoZW9yeSUyMG9mJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMHRoYXQlMjBtb3Rpb24lMjBpbiUyMHRoZSUyMHVuaXZlcnNlJTIwaXMlMjBub3QlMjBhJTIwc3RyYWlnaHQlMjBsaW5lLiU1Q24lMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that motion in the universe is not a straight line.\\n&quot;</span>]`,wrap:!1}}),{c(){t=d("p"),t.innerHTML=r,l=J(),u(o.$$.fragment)},l(i){t=U(i,"P",{"data-svelte-h":!0}),y(t)!=="svelte-dueo05"&&(t.innerHTML=r),l=c(i),h(o.$$.fragment,i)},m(i,T){n(i,t,T),n(i,l,T),f(o,i,T),p=!0},p:W,i(i){p||(w(o.$$.fragment,i),p=!0)},o(i){b(o.$$.fragment,i),p=!1},d(i){i&&(s(t),s(l)),j(o,i)}}}function yl(V){let t,r,l,o;return t=new Ge({props:{id:"spec-decoding",option:"greedy search",$$slots:{default:[dl]},$$scope:{ctx:V}}}),l=new Ge({props:{id:"spec-decoding",option:"sampling",$$slots:{default:[Ul]},$$scope:{ctx:V}}}),{c(){u(t.$$.fragment),r=J(),u(l.$$.fragment)},l(p){h(t.$$.fragment,p),r=c(p),h(l.$$.fragment,p)},m(p,i){f(t,p,i),n(p,r,i),f(l,p,i),o=!0},p(p,i){const T={};i&2&&(T.$$scope={dirty:i,ctx:p}),t.$set(T);const Z={};i&2&&(Z.$$scope={dirty:i,ctx:p}),l.$set(Z)},i(p){o||(w(t.$$.fragment,p),w(l.$$.fragment,p),o=!0)},o(p){b(t.$$.fragment,p),b(l.$$.fragment,p),o=!1},d(p){p&&s(r),j(t,p),j(l,p)}}}function ul(V){let t,r;return t=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHByb21wdF9sb29rdXBfbnVtX3Rva2VucyUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSU1QidUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIwdGhhdCUyMGVudHJvcHklMjBpbmNyZWFzZXMlMjB3aXRoJTIwdGVtcGVyYXR1cmUuJTIwJTIwJTIwJTIwJTIwJTIwJyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The second law of thermodynamics states that entropy increases with temperature.      &#x27;</span>]`,wrap:!1}}),{c(){u(t.$$.fragment)},l(l){h(t.$$.fragment,l)},m(l,o){f(t,l,o),r=!0},p:W,i(l){r||(w(t.$$.fragment,l),r=!0)},o(l){b(t.$$.fragment,l),r=!1},d(l){j(t,l)}}}function hl(V){let t,r='샘플링과 함께 프롬프트 조회 디코딩을 사용하려면, <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 메서드에 <code>do_sample</code> 및 <code>temperature</code> 매개변수를 추가하십시오.',l,o,p;return o=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBwcm9tcHRfbG9va3VwX251bV90b2tlbnMlM0QzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRlbXBlcmF0dXJlJTNEMC43KSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUIlMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIwdGhhdCUyMGVuZXJneSUyMGNhbm5vdCUyMGJlJTIwY3JlYXRlZCUyMG5vciUyMGRlc3Ryb3llZC4lMjBJdCdzJTIwbm90JTIwYSUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;The second law of thermodynamics states that energy cannot be created nor destroyed. It&#x27;s not a&quot;</span>]`,wrap:!1}}),{c(){t=d("p"),t.innerHTML=r,l=J(),u(o.$$.fragment)},l(i){t=U(i,"P",{"data-svelte-h":!0}),y(t)!=="svelte-1q3v49f"&&(t.innerHTML=r),l=c(i),h(o.$$.fragment,i)},m(i,T){n(i,t,T),n(i,l,T),f(o,i,T),p=!0},p:W,i(i){p||(w(o.$$.fragment,i),p=!0)},o(i){b(o.$$.fragment,i),p=!1},d(i){i&&(s(t),s(l)),j(o,i)}}}function fl(V){let t,r,l,o;return t=new Ge({props:{id:"pld",option:"greedy decoding",$$slots:{default:[ul]},$$scope:{ctx:V}}}),l=new Ge({props:{id:"pld",option:"sampling",$$slots:{default:[hl]},$$scope:{ctx:V}}}),{c(){u(t.$$.fragment),r=J(),u(l.$$.fragment)},l(p){h(t.$$.fragment,p),r=c(p),h(l.$$.fragment,p)},m(p,i){f(t,p,i),n(p,r,i),f(l,p,i),o=!0},p(p,i){const T={};i&2&&(T.$$scope={dirty:i,ctx:p}),t.$set(T);const Z={};i&2&&(Z.$$scope={dirty:i,ctx:p}),l.$set(Z)},i(p){o||(w(t.$$.fragment,p),w(l.$$.fragment,p),o=!0)},o(p){b(t.$$.fragment,p),b(l.$$.fragment,p),o=!1},d(p){p&&s(r),j(t,p),j(l,p)}}}function wl(V){let t,r="SDPA는 최신 PyTorch 버전이 설치되어 있으면 FlashAttention-2도 지원합니다.";return{c(){t=d("p"),t.textContent=r},l(l){t=U(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-1yx0a1x"&&(t.textContent=r)},m(l,o){n(l,t,o)},p:W,d(l){l&&s(t)}}}function bl(V){let t,r='다양한 양자화 라이브러리(자세한 내용은 <a href="./quantization">Quantization</a> 가이드를 참조하십시오)가 있습니다. 여기에는 Quanto, AQLM, VPTQ, AWQ 및 AutoGPTQ가 포함됩니다. 사용 사례에 가장 잘 맞는 라이브러리를 사용해 보십시오. 또한 AutoGPTQ와 bitsandbytes를 비교하는 <a href="https://hf.co/blog/overview-quantization-transformers" rel="nofollow">Overview of natively supported quantization schemes in 🤗 Transformers</a> 블로그 게시물을 읽어보는 것을 추천합니다.';return{c(){t=d("p"),t.innerHTML=r},l(l){t=U(l,"P",{"data-svelte-h":!0}),y(t)!=="svelte-2xoxfl"&&(t.innerHTML=r)},m(l,o){n(l,t,o)},p:W,d(l){l&&s(t)}}}function jl(V){let t,r,l,o,p,i,T,Z="대규모 언어 모델(LLM)은 채팅 및 코드 완성 모델과 같은 텍스트 생성 응용 프로그램을 한 단계 끌어올리며, 높은 수준의 이해력과 유창함을 보여주는 텍스트를 생성합니다. 그러나 LLM을 강력하게 만드는 요소인 그들의 크기는 동시에 추론 과정에서 도전 과제가 되기도 합니다.",$,C,_="기본적인 추론은 느립니다, 왜냐하면 LLM이 다음 토큰을 생성하기 위해 반복적으로 호출되어야 하기 때문입니다. 생성이 진행됨에 따라 입력 시퀀스가 길어져 처리 시간이 점점 길어집니다. 또한, LLM은 수십억 개의 매개변수를 가지고 있어 모든 가중치를 메모리에 저장하고 처리하는 데 어려움이 있습니다.",I,G,Q="이 가이드는 LLM 추론을 가속하기 위해 Transformers에서 사용할 수 있는 최적화 기술을 사용하는 방법을 보여줍니다.",R,g,F,B,v,m,M="디코딩 중에 LLM은 각 입력 토큰에 대한 key-value(kv) 값을 계산합니다. LLM은 자기회귀(autoregressive)이기 때문에 생성된 출력이 현재 입력의 일부가 되어 매번 동일한 kv 값을 계산합니다. 이는 매번 동일한 kv 값을 다시 계산하기 때문에 효율적이지 않습니다.",k,E,ft='이를 최적화하기 위해, 이전 키(key)와 값(value)을 재계산하지 않고 저장하는 kv-cache를 사용할 수 있습니다. 그러나 kv-cache는 각 생성 단계에서 증가하며 동적이기 때문에 PyTorch 코드를 빠르고 최적화된 커널로 통합하는 강력한 최적화 도구인 <a href="./perf_torch_compile"><code>torch.compile</code></a>을 사용하는 데 제약이 있습니다.',_e,O,wt="<em>정적 kv-cache</em>는 최댓값을 미리 할당하여 이 문제를 해결하여 <code>torch.compile</code>과 결합할 수 있게 합니다. 이를 통해 최대 4배의 속도 향상이 가능합니다. 속도 향상은 모델 크기(더 큰 모델은 속도 향상이 적음)와 하드웨어에 따라 다를 수 있습니다.",Be,H,ge,ee,bt="작업의 복잡성에 따라 세 가지 방식의 정적 kv-cache 사용 방법이 있습니다:",Re,te,jt="<li>기본 사용법: <code>generation_config</code>에서 플래그를 설정하기만 하면 됩니다(권장);</li> <li>고급 사용법: 여러 번의 생성이나 맞춤형 생성 루프를 위해 캐시 객체를 처리합니다;</li> <li>고급 사용법: 단일 그래프가 필요한 경우, 전체 <code>generate</code> 함수를 하나의 그래프로 컴파일합니다.</li>",ve,le,Vt="올바른 탭을 선택하여 각 방법에 대한 추가 지침을 확인하세요.",We,Y,Xe,S,Fe,se,Qe,x,Ee,ae,It="자기 회귀의 또 다른 문제는 각 입력 토큰에 대해 순전파 중에 모델 가중치를 매번 로드해야 한다는 점입니다. 이는 수십억 개의 매개변수를 가진 LLM에는 느리고 번거롭습니다. 추정 디코딩(speculative decoding)은 더 작고 빠른 보조 모델을 사용하여 후보 토큰을 생성하고, 이를 큰 LLM이 단일 순전파에서 검증하여 이 속도 저하를 완화합니다. 검증된 토큰이 정확하다면, LLM은 본래 자체적으로 생성하는 것처럼 토큰을 얻을 수 있습니다. 전방 패스가 동일한 출력을 보장하기 때문에 정확도 저하가 없습니다.",ze,ne,Zt="가장 큰 속도 향상을 얻기 위해, 보조 모델은 빠르게 토큰을 생성할 수 있도록 LLM보다 훨씬 작아야 합니다. 보조 모델과 LLM 모델은 토큰을 다시 인코딩하고 디코딩하지 않도록 동일한 토크나이저를 공유해야 합니다.",Ne,L,He,oe,Ct='보조 모델을 로드하고 이를 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 메서드에 전달하여 추정 디코딩을 활성화하십시오.',Ye,A,Se,pe,xe,ie,Gt="프롬프트 조회 디코딩은 탐욕 검색과 샘플링과도 호환되는 추정 디코딩의 변형입니다. 프롬프트 조회는 요약과 같은 입력 기반 작업에 특히 잘 작동합니다. 여기서는 프롬프트와 출력 간에 종종 겹치는 단어가 있습니다. 이러한 겹치는 n-그램이 LLM 후보 토큰으로 사용됩니다.",Le,re,kt='프롬프트 조회 디코딩을 활성화하려면 <code>prompt_lookup_num_tokens</code> 매개변수에 겹치는 토큰 수를 지정하십시오. 그런 다음 이 매개변수를 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 메서드에 전달할 수 있습니다.',Ae,q,qe,Je,De,ce,$t="트랜스포머 모델의 알려진 문제는 셀프 어텐션 메커니즘이 입력 토큰 수와 함께 계산 및 메모리가 제곱으로 증가한다는 것입니다. 이 제한은 훨씬 더 긴 시퀀스를 처리하는 LLM에서는 더욱 커집니다. 이를 해결하기 위해 FlashAttention2 또는 PyTorch의 스케일된 점곱 어텐션을 사용해 보십시오. 이들은 더 메모리 효율적인 어텐션 구현으로 추론을 가속화할 수 있습니다.",Ke,Me,Pe,Te,_t='FlashAttention과 <a href="./perf_infer_gpu_one#flashattention-2">FlashAttention-2</a>는 어텐션 계산을 더 작은 청크로 나누고 중간 읽기/쓰기 작업을 줄여 추론 속도를 높입니다. FlashAttention-2는 원래 FlashAttention 알고리즘을 개선하여 시퀀스 길이 차원에서도 병렬 처리를 수행하고 하드웨어에서 작업을 더 잘 분할하여 동기화 및 통신 오버헤드를 줄입니다.',Oe,me,Bt='FlashAttention-2를 사용하려면 <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> 메서드에서 <code>attn_implementation=&quot;flash_attention_2&quot;</code>를 설정하십시오.',et,de,tt,Ue,lt,ye,gt="스케일된 점곱 어텐션(SDPA)는 PyTorch 2.0에서 자동으로 활성화되며, FlashAttention, xFormers, PyTorch의 C++ 구현을 지원합니다. SDPA는 CUDA 백엔드를 사용하는 경우 가장 성능이 좋은 어텐션 알고리즘을 선택합니다. 다른 백엔드에서는 SDPA가 PyTorch C++ 구현으로 기본 설정됩니다.",st,D,at,ue,Rt='세 가지 어텐션 알고리즘 중 하나를 명시적으로 활성화하거나 비활성화하려면 <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.backends.cuda.sdp_kernel</a> 컨텍스트 관리자를 사용하십시오. 예를 들어 FlashAttention을 활성화하려면 <code>enable_flash=True</code>로 설정하십시오.',nt,he,ot,fe,pt,we,vt="양자화는 LLM 가중치를 더 낮은 정밀도로 저장하여 크기를 줄입니다. 이는 메모리 사용량을 줄이며 GPU 메모리에 제약이 있는 경우 추론을 위해 LLM을 로드하는 것을 더 용이하게 합니다. GPU가 충분하다면, 모델을 양자화할 필요는 없습니다. 추가적인 양자화 및 양자화 해제 단계로 인해 약간의 지연이 발생할 수 있기 때문입니다(AWQ 및 융합 AWQ 모듈 제외).",it,K,rt,be,Wt='아래의 모델 메모리 계산기를 사용하여 모델을 로드하는 데 필요한 메모리를 추정하고 비교해 보십시오. 예를 들어 <a href="https://huggingface.co/mistralai/Mistral-7B-v0.1" rel="nofollow">Mistral-7B-v0.1</a>를 로드하는 데 필요한 메모리를 추정해 보십시오.',Jt,z,Xt,ct,je,Ft='Mistral-7B-v0.1을 반정밀도로 로드하려면 <a href="/docs/transformers/main/ko/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> 메서드에서 <code>torch_dtype</code> 매개변수를 <code>torch.bfloat16</code>으로 설정하십시오. 이 경우 13.74GB의 메모리가 필요합니다.',Mt,Ve,Tt,Ie,Qt='추론을 위해 양자화된 모델(8비트 또는 4비트)을 로드하려면 <a href="https://hf.co/docs/bitsandbytes" rel="nofollow">bitsandbytes</a>를 사용하고 <code>load_in_4bit</code> 또는 <code>load_in_8bit</code> 매개변수를 <code>True</code>로 설정하십시오. 모델을 8비트로 로드하는 데는 6.87GB의 메모리만 필요합니다.',mt,Ze,dt,Ce,Ut,$e,yt;return p=new P({props:{title:"LLM 추론 최적화",local:"llm-inference-optimization",headingTag:"h1"}}),g=new N({props:{warning:!1,$$slots:{default:[al]},$$scope:{ctx:V}}}),B=new P({props:{title:"정적 kv-cache와 torch.compile",local:"static-kv-cache-and-torchcompile",headingTag:"h2"}}),H=new N({props:{warning:!0,$$slots:{default:[nl]},$$scope:{ctx:V}}}),Y=new N({props:{warning:!1,$$slots:{default:[ol]},$$scope:{ctx:V}}}),S=new ht({props:{id:"static-kv",options:["basic usage: generation_config","advanced usage: control Static Cache","advanced usage: end-to-end generate compilation"],$$slots:{default:[Ml]},$$scope:{ctx:V}}}),se=new P({props:{title:"추정 디코딩",local:"speculative-decoding",headingTag:"h2"}}),x=new N({props:{warning:!1,$$slots:{default:[Tl]},$$scope:{ctx:V}}}),L=new N({props:{warning:!0,$$slots:{default:[ml]},$$scope:{ctx:V}}}),A=new ht({props:{id:"spec-decoding",options:["greedy search","sampling"],$$slots:{default:[yl]},$$scope:{ctx:V}}}),pe=new P({props:{title:"프롬프트 조회 디코딩",local:"prompt-lookup-decoding",headingTag:"h3"}}),q=new ht({props:{id:"pld",options:["greedy decoding","sampling"],$$slots:{default:[fl]},$$scope:{ctx:V}}}),Je=new P({props:{title:"어텐션 최적화",local:"attention-optimizations",headingTag:"h2"}}),Me=new P({props:{title:"FlashAttention-2",local:"flashattention-2",headingTag:"h3"}}),de=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.bfloat16,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)`,wrap:!1}}),Ue=new P({props:{title:"PyTorch 스케일된 점곱 어텐션(scaled dot product attention)",local:"pytorch-scaled-dot-product-attention",headingTag:"h3"}}),D=new N({props:{warning:!1,$$slots:{default:[wl]},$$scope:{ctx:V}}}),he=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZnZW1tYS0yYiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    torch_dtype=torch.bfloat16,
)

<span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">True</span>, enable_math=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>):
    outputs = model.generate(**inputs)`,wrap:!1}}),fe=new P({props:{title:"양자화",local:"quantization",headingTag:"h2"}}),K=new N({props:{warning:!1,$$slots:{default:[bl]},$$scope:{ctx:V}}}),Ve=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)`,wrap:!1}}),Ze=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">import</span> torch

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=quant_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Ce=new sl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/llm_optims.md"}}),{c(){t=d("meta"),r=J(),l=d("p"),o=J(),u(p.$$.fragment),i=J(),T=d("p"),T.textContent=Z,$=J(),C=d("p"),C.textContent=_,I=J(),G=d("p"),G.textContent=Q,R=J(),u(g.$$.fragment),F=J(),u(B.$$.fragment),v=J(),m=d("p"),m.textContent=M,k=J(),E=d("p"),E.innerHTML=ft,_e=J(),O=d("p"),O.innerHTML=wt,Be=J(),u(H.$$.fragment),ge=J(),ee=d("p"),ee.textContent=bt,Re=J(),te=d("ol"),te.innerHTML=jt,ve=J(),le=d("p"),le.textContent=Vt,We=J(),u(Y.$$.fragment),Xe=J(),u(S.$$.fragment),Fe=J(),u(se.$$.fragment),Qe=J(),u(x.$$.fragment),Ee=J(),ae=d("p"),ae.textContent=It,ze=J(),ne=d("p"),ne.textContent=Zt,Ne=J(),u(L.$$.fragment),He=J(),oe=d("p"),oe.innerHTML=Ct,Ye=J(),u(A.$$.fragment),Se=J(),u(pe.$$.fragment),xe=J(),ie=d("p"),ie.textContent=Gt,Le=J(),re=d("p"),re.innerHTML=kt,Ae=J(),u(q.$$.fragment),qe=J(),u(Je.$$.fragment),De=J(),ce=d("p"),ce.textContent=$t,Ke=J(),u(Me.$$.fragment),Pe=J(),Te=d("p"),Te.innerHTML=_t,Oe=J(),me=d("p"),me.innerHTML=Bt,et=J(),u(de.$$.fragment),tt=J(),u(Ue.$$.fragment),lt=J(),ye=d("p"),ye.textContent=gt,st=J(),u(D.$$.fragment),at=J(),ue=d("p"),ue.innerHTML=Rt,nt=J(),u(he.$$.fragment),ot=J(),u(fe.$$.fragment),pt=J(),we=d("p"),we.textContent=vt,it=J(),u(K.$$.fragment),rt=J(),be=d("p"),be.innerHTML=Wt,Jt=J(),z=d("iframe"),ct=J(),je=d("p"),je.innerHTML=Ft,Mt=J(),u(Ve.$$.fragment),Tt=J(),Ie=d("p"),Ie.innerHTML=Qt,mt=J(),u(Ze.$$.fragment),dt=J(),u(Ce.$$.fragment),Ut=J(),$e=d("p"),this.h()},l(e){const a=tl("svelte-u9bgzb",document.head);t=U(a,"META",{name:!0,content:!0}),a.forEach(s),r=c(e),l=U(e,"P",{}),ut(l).forEach(s),o=c(e),h(p.$$.fragment,e),i=c(e),T=U(e,"P",{"data-svelte-h":!0}),y(T)!=="svelte-ikijop"&&(T.textContent=Z),$=c(e),C=U(e,"P",{"data-svelte-h":!0}),y(C)!=="svelte-lgr6n0"&&(C.textContent=_),I=c(e),G=U(e,"P",{"data-svelte-h":!0}),y(G)!=="svelte-18buelc"&&(G.textContent=Q),R=c(e),h(g.$$.fragment,e),F=c(e),h(B.$$.fragment,e),v=c(e),m=U(e,"P",{"data-svelte-h":!0}),y(m)!=="svelte-1fmnpkw"&&(m.textContent=M),k=c(e),E=U(e,"P",{"data-svelte-h":!0}),y(E)!=="svelte-14rruly"&&(E.innerHTML=ft),_e=c(e),O=U(e,"P",{"data-svelte-h":!0}),y(O)!=="svelte-1s0aiak"&&(O.innerHTML=wt),Be=c(e),h(H.$$.fragment,e),ge=c(e),ee=U(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-608bjv"&&(ee.textContent=bt),Re=c(e),te=U(e,"OL",{"data-svelte-h":!0}),y(te)!=="svelte-1jphkc4"&&(te.innerHTML=jt),ve=c(e),le=U(e,"P",{"data-svelte-h":!0}),y(le)!=="svelte-alzl50"&&(le.textContent=Vt),We=c(e),h(Y.$$.fragment,e),Xe=c(e),h(S.$$.fragment,e),Fe=c(e),h(se.$$.fragment,e),Qe=c(e),h(x.$$.fragment,e),Ee=c(e),ae=U(e,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-xfh61h"&&(ae.textContent=It),ze=c(e),ne=U(e,"P",{"data-svelte-h":!0}),y(ne)!=="svelte-q0jd9k"&&(ne.textContent=Zt),Ne=c(e),h(L.$$.fragment,e),He=c(e),oe=U(e,"P",{"data-svelte-h":!0}),y(oe)!=="svelte-xru2io"&&(oe.innerHTML=Ct),Ye=c(e),h(A.$$.fragment,e),Se=c(e),h(pe.$$.fragment,e),xe=c(e),ie=U(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-2e74to"&&(ie.textContent=Gt),Le=c(e),re=U(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-1lcp9y"&&(re.innerHTML=kt),Ae=c(e),h(q.$$.fragment,e),qe=c(e),h(Je.$$.fragment,e),De=c(e),ce=U(e,"P",{"data-svelte-h":!0}),y(ce)!=="svelte-dg6lyb"&&(ce.textContent=$t),Ke=c(e),h(Me.$$.fragment,e),Pe=c(e),Te=U(e,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-1wj8lzh"&&(Te.innerHTML=_t),Oe=c(e),me=U(e,"P",{"data-svelte-h":!0}),y(me)!=="svelte-9peo57"&&(me.innerHTML=Bt),et=c(e),h(de.$$.fragment,e),tt=c(e),h(Ue.$$.fragment,e),lt=c(e),ye=U(e,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-1pkp4tn"&&(ye.textContent=gt),st=c(e),h(D.$$.fragment,e),at=c(e),ue=U(e,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-1m2wes8"&&(ue.innerHTML=Rt),nt=c(e),h(he.$$.fragment,e),ot=c(e),h(fe.$$.fragment,e),pt=c(e),we=U(e,"P",{"data-svelte-h":!0}),y(we)!=="svelte-1nlhjc4"&&(we.textContent=vt),it=c(e),h(K.$$.fragment,e),rt=c(e),be=U(e,"P",{"data-svelte-h":!0}),y(be)!=="svelte-hdeqf"&&(be.innerHTML=Wt),Jt=c(e),z=U(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),ut(z).forEach(s),ct=c(e),je=U(e,"P",{"data-svelte-h":!0}),y(je)!=="svelte-1ubbh59"&&(je.innerHTML=Ft),Mt=c(e),h(Ve.$$.fragment,e),Tt=c(e),Ie=U(e,"P",{"data-svelte-h":!0}),y(Ie)!=="svelte-11tku4g"&&(Ie.innerHTML=Qt),mt=c(e),h(Ze.$$.fragment,e),dt=c(e),h(Ce.$$.fragment,e),Ut=c(e),$e=U(e,"P",{}),ut($e).forEach(s),this.h()},h(){ke(t,"name","hf:doc:metadata"),ke(t,"content",Vl),Kt(z.src,Xt="https://hf-accelerate-model-memory-usage.hf.space")||ke(z,"src",Xt),ke(z,"frameborder","0"),ke(z,"width","850"),ke(z,"height","450")},m(e,a){ll(document.head,t),n(e,r,a),n(e,l,a),n(e,o,a),f(p,e,a),n(e,i,a),n(e,T,a),n(e,$,a),n(e,C,a),n(e,I,a),n(e,G,a),n(e,R,a),f(g,e,a),n(e,F,a),f(B,e,a),n(e,v,a),n(e,m,a),n(e,k,a),n(e,E,a),n(e,_e,a),n(e,O,a),n(e,Be,a),f(H,e,a),n(e,ge,a),n(e,ee,a),n(e,Re,a),n(e,te,a),n(e,ve,a),n(e,le,a),n(e,We,a),f(Y,e,a),n(e,Xe,a),f(S,e,a),n(e,Fe,a),f(se,e,a),n(e,Qe,a),f(x,e,a),n(e,Ee,a),n(e,ae,a),n(e,ze,a),n(e,ne,a),n(e,Ne,a),f(L,e,a),n(e,He,a),n(e,oe,a),n(e,Ye,a),f(A,e,a),n(e,Se,a),f(pe,e,a),n(e,xe,a),n(e,ie,a),n(e,Le,a),n(e,re,a),n(e,Ae,a),f(q,e,a),n(e,qe,a),f(Je,e,a),n(e,De,a),n(e,ce,a),n(e,Ke,a),f(Me,e,a),n(e,Pe,a),n(e,Te,a),n(e,Oe,a),n(e,me,a),n(e,et,a),f(de,e,a),n(e,tt,a),f(Ue,e,a),n(e,lt,a),n(e,ye,a),n(e,st,a),f(D,e,a),n(e,at,a),n(e,ue,a),n(e,nt,a),f(he,e,a),n(e,ot,a),f(fe,e,a),n(e,pt,a),n(e,we,a),n(e,it,a),f(K,e,a),n(e,rt,a),n(e,be,a),n(e,Jt,a),n(e,z,a),n(e,ct,a),n(e,je,a),n(e,Mt,a),f(Ve,e,a),n(e,Tt,a),n(e,Ie,a),n(e,mt,a),f(Ze,e,a),n(e,dt,a),f(Ce,e,a),n(e,Ut,a),n(e,$e,a),yt=!0},p(e,[a]){const Et={};a&2&&(Et.$$scope={dirty:a,ctx:e}),g.$set(Et);const zt={};a&2&&(zt.$$scope={dirty:a,ctx:e}),H.$set(zt);const Nt={};a&2&&(Nt.$$scope={dirty:a,ctx:e}),Y.$set(Nt);const Ht={};a&2&&(Ht.$$scope={dirty:a,ctx:e}),S.$set(Ht);const Yt={};a&2&&(Yt.$$scope={dirty:a,ctx:e}),x.$set(Yt);const St={};a&2&&(St.$$scope={dirty:a,ctx:e}),L.$set(St);const xt={};a&2&&(xt.$$scope={dirty:a,ctx:e}),A.$set(xt);const Lt={};a&2&&(Lt.$$scope={dirty:a,ctx:e}),q.$set(Lt);const At={};a&2&&(At.$$scope={dirty:a,ctx:e}),D.$set(At);const qt={};a&2&&(qt.$$scope={dirty:a,ctx:e}),K.$set(qt)},i(e){yt||(w(p.$$.fragment,e),w(g.$$.fragment,e),w(B.$$.fragment,e),w(H.$$.fragment,e),w(Y.$$.fragment,e),w(S.$$.fragment,e),w(se.$$.fragment,e),w(x.$$.fragment,e),w(L.$$.fragment,e),w(A.$$.fragment,e),w(pe.$$.fragment,e),w(q.$$.fragment,e),w(Je.$$.fragment,e),w(Me.$$.fragment,e),w(de.$$.fragment,e),w(Ue.$$.fragment,e),w(D.$$.fragment,e),w(he.$$.fragment,e),w(fe.$$.fragment,e),w(K.$$.fragment,e),w(Ve.$$.fragment,e),w(Ze.$$.fragment,e),w(Ce.$$.fragment,e),yt=!0)},o(e){b(p.$$.fragment,e),b(g.$$.fragment,e),b(B.$$.fragment,e),b(H.$$.fragment,e),b(Y.$$.fragment,e),b(S.$$.fragment,e),b(se.$$.fragment,e),b(x.$$.fragment,e),b(L.$$.fragment,e),b(A.$$.fragment,e),b(pe.$$.fragment,e),b(q.$$.fragment,e),b(Je.$$.fragment,e),b(Me.$$.fragment,e),b(de.$$.fragment,e),b(Ue.$$.fragment,e),b(D.$$.fragment,e),b(he.$$.fragment,e),b(fe.$$.fragment,e),b(K.$$.fragment,e),b(Ve.$$.fragment,e),b(Ze.$$.fragment,e),b(Ce.$$.fragment,e),yt=!1},d(e){e&&(s(r),s(l),s(o),s(i),s(T),s($),s(C),s(I),s(G),s(R),s(F),s(v),s(m),s(k),s(E),s(_e),s(O),s(Be),s(ge),s(ee),s(Re),s(te),s(ve),s(le),s(We),s(Xe),s(Fe),s(Qe),s(Ee),s(ae),s(ze),s(ne),s(Ne),s(He),s(oe),s(Ye),s(Se),s(xe),s(ie),s(Le),s(re),s(Ae),s(qe),s(De),s(ce),s(Ke),s(Pe),s(Te),s(Oe),s(me),s(et),s(tt),s(lt),s(ye),s(st),s(at),s(ue),s(nt),s(ot),s(pt),s(we),s(it),s(rt),s(be),s(Jt),s(z),s(ct),s(je),s(Mt),s(Tt),s(Ie),s(mt),s(dt),s(Ut),s($e)),s(t),j(p,e),j(g,e),j(B,e),j(H,e),j(Y,e),j(S,e),j(se,e),j(x,e),j(L,e),j(A,e),j(pe,e),j(q,e),j(Je,e),j(Me,e),j(de,e),j(Ue,e),j(D,e),j(he,e),j(fe,e),j(K,e),j(Ve,e),j(Ze,e),j(Ce,e)}}}const Vl='{"title":"LLM 추론 최적화","local":"llm-inference-optimization","sections":[{"title":"정적 kv-cache와 torch.compile","local":"static-kv-cache-and-torchcompile","sections":[],"depth":2},{"title":"추정 디코딩","local":"speculative-decoding","sections":[{"title":"프롬프트 조회 디코딩","local":"prompt-lookup-decoding","sections":[],"depth":3}],"depth":2},{"title":"어텐션 최적화","local":"attention-optimizations","sections":[{"title":"FlashAttention-2","local":"flashattention-2","sections":[],"depth":3},{"title":"PyTorch 스케일된 점곱 어텐션(scaled dot product attention)","local":"pytorch-scaled-dot-product-attention","sections":[],"depth":3}],"depth":2},{"title":"양자화","local":"quantization","sections":[],"depth":2}],"depth":1}';function Il(V){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bl extends Ot{constructor(t){super(),el(this,t,Il,jl,Dt,{})}}export{Bl as component};
