import{s as Ct,n as Wt,o as Bt}from"../chunks/scheduler.85c25b89.js";import{S as Nt,i as vt,g as p,s as a,r as i,A as xt,h as m,f as e,c as n,j as kt,u as o,x as j,k as It,y as Et,a as l,v as r,d as c,t as h,w as M}from"../chunks/index.c9837788.js";import{C as Q}from"../chunks/CodeBlock.52fa569e.js";import{H as R,E as Gt}from"../chunks/EditOnGithub.b65eee75.js";function Vt(gt){let g,Y,X,H,d,S,w,dt='<strong>VoVNet</strong> is a convolutional neural network that seeks to make <a href="https://paperswithcode.com/method/densenet" rel="nofollow">DenseNet</a> more efficient by concatenating all features only once in the last feature map, which makes input size constant and enables enlarging new output channel.',z,J,wt='Read about <a href="https://paperswithcode.com/method/one-shot-aggregation" rel="nofollow">one-shot aggregation here</a>.',F,y,L,u,Jt="To load a pretrained model:",D,T,P,b,yt="To load and preprocess the image:",q,f,K,U,ut="To get the model predictions:",O,Z,tt,$,Tt="To get the top-5 predictions class names:",st,k,et,I,bt="Replace the model name with the variant you want to use, e.g. <code>ese_vovnet19b_dw</code>. You can find the IDs in the model summaries at the top of this page.",lt,C,ft='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,W,nt,B,Ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,N,mt,v,Zt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,x,ot,E,$t='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,G,ct,V,ht,_,Mt,A,jt;return d=new R({props:{title:"ESE-VoVNet",local:"ese-vovnet",headingTag:"h1"}}),y=new R({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2VzZV92b3ZuZXQxOWJfZHcnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ese_vovnet19b_dw&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),Z=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new R({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZXNlX3Zvdm5ldDE5Yl9kdyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ese_vovnet19b_dw&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new R({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),G=new R({props:{title:"Citation",local:"citation",headingTag:"h2"}}),V=new Q({props:{code:"JTQwbWlzYyU3QmxlZTIwMTllbmVyZ3klMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkFuJTIwRW5lcmd5JTIwYW5kJTIwR1BVLUNvbXB1dGF0aW9uJTIwRWZmaWNpZW50JTIwQmFja2JvbmUlMjBOZXR3b3JrJTIwZm9yJTIwUmVhbC1UaW1lJTIwT2JqZWN0JTIwRGV0ZWN0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCWW91bmd3YW4lMjBMZWUlMjBhbmQlMjBKb29uZy13b24lMjBId2FuZyUyMGFuZCUyMFNhbmdyb2slMjBMZWUlMjBhbmQlMjBZdXNlb2slMjBCYWUlMjBhbmQlMjBKb25neW91bCUyMFBhcmslN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE5MDQuMDk3MzAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{lee2019energy,
      title={An Energy <span class="hljs-keyword">and </span>GPU-Computation Efficient <span class="hljs-keyword">Backbone </span>Network for Real-Time Object Detection}, 
      author={Youngwan Lee <span class="hljs-keyword">and </span><span class="hljs-keyword">Joong-won </span>Hwang <span class="hljs-keyword">and </span>Sangrok Lee <span class="hljs-keyword">and </span>Yuseok <span class="hljs-keyword">Bae </span><span class="hljs-keyword">and </span><span class="hljs-keyword">Jongyoul </span>Park},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1904</span>.<span class="hljs-number">09730</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),_=new Gt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/ese-vovnet.mdx"}}),{c(){g=p("meta"),Y=a(),X=p("p"),H=a(),i(d.$$.fragment),S=a(),w=p("p"),w.innerHTML=dt,z=a(),J=p("p"),J.innerHTML=wt,F=a(),i(y.$$.fragment),L=a(),u=p("p"),u.textContent=Jt,D=a(),i(T.$$.fragment),P=a(),b=p("p"),b.textContent=yt,q=a(),i(f.$$.fragment),K=a(),U=p("p"),U.textContent=ut,O=a(),i(Z.$$.fragment),tt=a(),$=p("p"),$.textContent=Tt,st=a(),i(k.$$.fragment),et=a(),I=p("p"),I.innerHTML=bt,lt=a(),C=p("p"),C.innerHTML=ft,at=a(),i(W.$$.fragment),nt=a(),B=p("p"),B.textContent=Ut,pt=a(),i(N.$$.fragment),mt=a(),v=p("p"),v.innerHTML=Zt,it=a(),i(x.$$.fragment),ot=a(),E=p("p"),E.innerHTML=$t,rt=a(),i(G.$$.fragment),ct=a(),i(V.$$.fragment),ht=a(),i(_.$$.fragment),Mt=a(),A=p("p"),this.h()},l(t){const s=xt("svelte-u9bgzb",document.head);g=m(s,"META",{name:!0,content:!0}),s.forEach(e),Y=n(t),X=m(t,"P",{}),kt(X).forEach(e),H=n(t),o(d.$$.fragment,t),S=n(t),w=m(t,"P",{"data-svelte-h":!0}),j(w)!=="svelte-13oc2jm"&&(w.innerHTML=dt),z=n(t),J=m(t,"P",{"data-svelte-h":!0}),j(J)!=="svelte-1ajn3h8"&&(J.innerHTML=wt),F=n(t),o(y.$$.fragment,t),L=n(t),u=m(t,"P",{"data-svelte-h":!0}),j(u)!=="svelte-18ywhxh"&&(u.textContent=Jt),D=n(t),o(T.$$.fragment,t),P=n(t),b=m(t,"P",{"data-svelte-h":!0}),j(b)!=="svelte-1c2ipa8"&&(b.textContent=yt),q=n(t),o(f.$$.fragment,t),K=n(t),U=m(t,"P",{"data-svelte-h":!0}),j(U)!=="svelte-1n9qsq1"&&(U.textContent=ut),O=n(t),o(Z.$$.fragment,t),tt=n(t),$=m(t,"P",{"data-svelte-h":!0}),j($)!=="svelte-19cnvx1"&&($.textContent=Tt),st=n(t),o(k.$$.fragment,t),et=n(t),I=m(t,"P",{"data-svelte-h":!0}),j(I)!=="svelte-yryjra"&&(I.innerHTML=bt),lt=n(t),C=m(t,"P",{"data-svelte-h":!0}),j(C)!=="svelte-1wmi3ea"&&(C.innerHTML=ft),at=n(t),o(W.$$.fragment,t),nt=n(t),B=m(t,"P",{"data-svelte-h":!0}),j(B)!=="svelte-9sr7nh"&&(B.textContent=Ut),pt=n(t),o(N.$$.fragment,t),mt=n(t),v=m(t,"P",{"data-svelte-h":!0}),j(v)!=="svelte-1kguc51"&&(v.innerHTML=Zt),it=n(t),o(x.$$.fragment,t),ot=n(t),E=m(t,"P",{"data-svelte-h":!0}),j(E)!=="svelte-xtxxu6"&&(E.innerHTML=$t),rt=n(t),o(G.$$.fragment,t),ct=n(t),o(V.$$.fragment,t),ht=n(t),o(_.$$.fragment,t),Mt=n(t),A=m(t,"P",{}),kt(A).forEach(e),this.h()},h(){It(g,"name","hf:doc:metadata"),It(g,"content",_t)},m(t,s){Et(document.head,g),l(t,Y,s),l(t,X,s),l(t,H,s),r(d,t,s),l(t,S,s),l(t,w,s),l(t,z,s),l(t,J,s),l(t,F,s),r(y,t,s),l(t,L,s),l(t,u,s),l(t,D,s),r(T,t,s),l(t,P,s),l(t,b,s),l(t,q,s),r(f,t,s),l(t,K,s),l(t,U,s),l(t,O,s),r(Z,t,s),l(t,tt,s),l(t,$,s),l(t,st,s),r(k,t,s),l(t,et,s),l(t,I,s),l(t,lt,s),l(t,C,s),l(t,at,s),r(W,t,s),l(t,nt,s),l(t,B,s),l(t,pt,s),r(N,t,s),l(t,mt,s),l(t,v,s),l(t,it,s),r(x,t,s),l(t,ot,s),l(t,E,s),l(t,rt,s),r(G,t,s),l(t,ct,s),r(V,t,s),l(t,ht,s),r(_,t,s),l(t,Mt,s),l(t,A,s),jt=!0},p:Wt,i(t){jt||(c(d.$$.fragment,t),c(y.$$.fragment,t),c(T.$$.fragment,t),c(f.$$.fragment,t),c(Z.$$.fragment,t),c(k.$$.fragment,t),c(W.$$.fragment,t),c(N.$$.fragment,t),c(x.$$.fragment,t),c(G.$$.fragment,t),c(V.$$.fragment,t),c(_.$$.fragment,t),jt=!0)},o(t){h(d.$$.fragment,t),h(y.$$.fragment,t),h(T.$$.fragment,t),h(f.$$.fragment,t),h(Z.$$.fragment,t),h(k.$$.fragment,t),h(W.$$.fragment,t),h(N.$$.fragment,t),h(x.$$.fragment,t),h(G.$$.fragment,t),h(V.$$.fragment,t),h(_.$$.fragment,t),jt=!1},d(t){t&&(e(Y),e(X),e(H),e(S),e(w),e(z),e(J),e(F),e(L),e(u),e(D),e(P),e(b),e(q),e(K),e(U),e(O),e(tt),e($),e(st),e(et),e(I),e(lt),e(C),e(at),e(nt),e(B),e(pt),e(mt),e(v),e(it),e(ot),e(E),e(rt),e(ct),e(ht),e(Mt),e(A)),e(g),M(d,t),M(y,t),M(T,t),M(f,t),M(Z,t),M(k,t),M(W,t),M(N,t),M(x,t),M(G,t),M(V,t),M(_,t)}}}const _t='{"title":"ESE-VoVNet","local":"ese-vovnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qt(gt){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends Nt{constructor(g){super(),vt(this,g,Qt,Vt,Ct,{})}}export{Ht as component};
