import{s as Gt,n as vt,o as Qt}from"../chunks/scheduler.85c25b89.js";import{S as Vt,i as _t,g as i,s as l,r as o,A as Rt,h as p,f as a,c as n,j as Nt,u as c,x as m,k as Et,y as Xt,a as s,v as r,d as h,t as M,w as d}from"../chunks/index.c9bcf812.js";import{C as X}from"../chunks/CodeBlock.94efc595.js";import{H as z}from"../chunks/Heading.3c6e5b17.js";function Ft(jt){let g,A,F,H,J,S,w,Tt="<strong>EfficientNet</strong> is a convolutional neural network architecture and scaling method that uniformly scales all dimensions of depth/width/resolution using a <em>compound coefficient</em>. Unlike conventional practice that arbitrary scales  these factors, the EfficientNet scaling method uniformly scales network width, depth, and resolution with a set of fixed scaling coefficients. For example, if we want to use $2^N$ times more computational resources, then we can simply increase the network depth by $\\alpha ^ N$,  width by $\\beta ^ N$, and image size by $\\gamma ^ N$, where $\\alpha, \\beta, \\gamma$ are constant coefficients determined by a small grid search on the original small model. EfficientNet uses a compound coefficient $\\phi$ to uniformly scales network width, depth, and resolution in a  principled way.",L,y,ut="The compound scaling method is justified by the intuition that if the input image is bigger, then the network needs more layers to increase the receptive field and more channels to capture more fine-grained patterns on the bigger image.",D,j,ft='The base EfficientNet-B0 network is based on the inverted bottleneck residual blocks of <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetV2</a>, in addition to <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a>.',P,T,bt="This collection consists of pruned EfficientNet models.",q,u,K,f,Ut="To load a pretrained model:",O,b,tt,U,It="To load and preprocess the image:",et,I,at,C,Ct="To get the model predictions:",st,$,lt,k,$t="To get the top-5 predictions class names:",nt,x,it,Z,kt="Replace the model name with the variant you want to use, e.g. <code>efficientnet_b1_pruned</code>. You can find the IDs in the model summaries at the top of this page.",pt,W,xt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',mt,B,ot,N,Zt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ct,E,rt,G,Wt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ht,v,Mt,Q,Bt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',dt,V,gt,_,Jt,R,wt,Y,yt;return J=new z({props:{title:"EfficientNet (Knapsack Pruned)",local:"efficientnet-knapsack-pruned",headingTag:"h1"}}),u=new z({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),b=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2VmZmljaWVudG5ldF9iMV9wcnVuZWQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;efficientnet_b1_pruned&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),I=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new z({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),E=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZWZmaWNpZW50bmV0X2IxX3BydW5lZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;efficientnet_b1_pruned&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),v=new z({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),V=new z({props:{title:"Citation",local:"citation",headingTag:"h2"}}),_=new X({props:{code:"JTQwbWlzYyU3QnRhbjIwMjBlZmZpY2llbnRuZXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkVmZmljaWVudE5ldCUzQSUyMFJldGhpbmtpbmclMjBNb2RlbCUyMFNjYWxpbmclMjBmb3IlMjBDb252b2x1dGlvbmFsJTIwTmV1cmFsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JNaW5neGluZyUyMFRhbiUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA1LjExOTQ2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuTEclN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2020efficientnet,
      title={EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1905.11946}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.LG}</span><span class="language-xml">
}</span>`,wrap:!1}}),R=new X({props:{code:"JTQwbWlzYyU3QmFmbGFsbzIwMjBrbmFwc2FjayUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCS25hcHNhY2slMjBQcnVuaW5nJTIwd2l0aCUyMElubmVyJTIwRGlzdGlsbGF0aW9uJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCWW9uYXRoYW4lMjBBZmxhbG8lMjBhbmQlMjBBc2FmJTIwTm95JTIwYW5kJTIwTWluZyUyMExpbiUyMGFuZCUyMEl0YW1hciUyMEZyaWVkbWFuJTIwYW5kJTIwTGloaSUyMFplbG5payU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMjAwMi4wODI1OCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkxHJTdEJTBBJTdE",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{aflalo2020knapsack,
      title={Knapsack Pruning with Inner Distillation}</span><span class="language-xml">,
      author=</span><span class="hljs-template-variable">{Yonathan Aflalo and Asaf Noy and Ming Lin and Itamar Friedman and Lihi Zelnik}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2002.08258}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.LG}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){g=i("meta"),A=l(),F=i("p"),H=l(),o(J.$$.fragment),S=l(),w=i("p"),w.innerHTML=Tt,L=l(),y=i("p"),y.textContent=ut,D=l(),j=i("p"),j.innerHTML=ft,P=l(),T=i("p"),T.textContent=bt,q=l(),o(u.$$.fragment),K=l(),f=i("p"),f.textContent=Ut,O=l(),o(b.$$.fragment),tt=l(),U=i("p"),U.textContent=It,et=l(),o(I.$$.fragment),at=l(),C=i("p"),C.textContent=Ct,st=l(),o($.$$.fragment),lt=l(),k=i("p"),k.textContent=$t,nt=l(),o(x.$$.fragment),it=l(),Z=i("p"),Z.innerHTML=kt,pt=l(),W=i("p"),W.innerHTML=xt,mt=l(),o(B.$$.fragment),ot=l(),N=i("p"),N.textContent=Zt,ct=l(),o(E.$$.fragment),rt=l(),G=i("p"),G.innerHTML=Wt,ht=l(),o(v.$$.fragment),Mt=l(),Q=i("p"),Q.innerHTML=Bt,dt=l(),o(V.$$.fragment),gt=l(),o(_.$$.fragment),Jt=l(),o(R.$$.fragment),wt=l(),Y=i("p"),this.h()},l(t){const e=Rt("svelte-u9bgzb",document.head);g=p(e,"META",{name:!0,content:!0}),e.forEach(a),A=n(t),F=p(t,"P",{}),Nt(F).forEach(a),H=n(t),c(J.$$.fragment,t),S=n(t),w=p(t,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1bwkfja"&&(w.innerHTML=Tt),L=n(t),y=p(t,"P",{"data-svelte-h":!0}),m(y)!=="svelte-5z334a"&&(y.textContent=ut),D=n(t),j=p(t,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1j8z7ka"&&(j.innerHTML=ft),P=n(t),T=p(t,"P",{"data-svelte-h":!0}),m(T)!=="svelte-3a4dpz"&&(T.textContent=bt),q=n(t),c(u.$$.fragment,t),K=n(t),f=p(t,"P",{"data-svelte-h":!0}),m(f)!=="svelte-18ywhxh"&&(f.textContent=Ut),O=n(t),c(b.$$.fragment,t),tt=n(t),U=p(t,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1c2ipa8"&&(U.textContent=It),et=n(t),c(I.$$.fragment,t),at=n(t),C=p(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1n9qsq1"&&(C.textContent=Ct),st=n(t),c($.$$.fragment,t),lt=n(t),k=p(t,"P",{"data-svelte-h":!0}),m(k)!=="svelte-19cnvx1"&&(k.textContent=$t),nt=n(t),c(x.$$.fragment,t),it=n(t),Z=p(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-9pmk5h"&&(Z.innerHTML=kt),pt=n(t),W=p(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1wmi3ea"&&(W.innerHTML=xt),mt=n(t),c(B.$$.fragment,t),ot=n(t),N=p(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-9sr7nh"&&(N.textContent=Zt),ct=n(t),c(E.$$.fragment,t),rt=n(t),G=p(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1kguc51"&&(G.innerHTML=Wt),ht=n(t),c(v.$$.fragment,t),Mt=n(t),Q=p(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1n0coha"&&(Q.innerHTML=Bt),dt=n(t),c(V.$$.fragment,t),gt=n(t),c(_.$$.fragment,t),Jt=n(t),c(R.$$.fragment,t),wt=n(t),Y=p(t,"P",{}),Nt(Y).forEach(a),this.h()},h(){Et(g,"name","hf:doc:metadata"),Et(g,"content",Yt)},m(t,e){Xt(document.head,g),s(t,A,e),s(t,F,e),s(t,H,e),r(J,t,e),s(t,S,e),s(t,w,e),s(t,L,e),s(t,y,e),s(t,D,e),s(t,j,e),s(t,P,e),s(t,T,e),s(t,q,e),r(u,t,e),s(t,K,e),s(t,f,e),s(t,O,e),r(b,t,e),s(t,tt,e),s(t,U,e),s(t,et,e),r(I,t,e),s(t,at,e),s(t,C,e),s(t,st,e),r($,t,e),s(t,lt,e),s(t,k,e),s(t,nt,e),r(x,t,e),s(t,it,e),s(t,Z,e),s(t,pt,e),s(t,W,e),s(t,mt,e),r(B,t,e),s(t,ot,e),s(t,N,e),s(t,ct,e),r(E,t,e),s(t,rt,e),s(t,G,e),s(t,ht,e),r(v,t,e),s(t,Mt,e),s(t,Q,e),s(t,dt,e),r(V,t,e),s(t,gt,e),r(_,t,e),s(t,Jt,e),r(R,t,e),s(t,wt,e),s(t,Y,e),yt=!0},p:vt,i(t){yt||(h(J.$$.fragment,t),h(u.$$.fragment,t),h(b.$$.fragment,t),h(I.$$.fragment,t),h($.$$.fragment,t),h(x.$$.fragment,t),h(B.$$.fragment,t),h(E.$$.fragment,t),h(v.$$.fragment,t),h(V.$$.fragment,t),h(_.$$.fragment,t),h(R.$$.fragment,t),yt=!0)},o(t){M(J.$$.fragment,t),M(u.$$.fragment,t),M(b.$$.fragment,t),M(I.$$.fragment,t),M($.$$.fragment,t),M(x.$$.fragment,t),M(B.$$.fragment,t),M(E.$$.fragment,t),M(v.$$.fragment,t),M(V.$$.fragment,t),M(_.$$.fragment,t),M(R.$$.fragment,t),yt=!1},d(t){t&&(a(A),a(F),a(H),a(S),a(w),a(L),a(y),a(D),a(j),a(P),a(T),a(q),a(K),a(f),a(O),a(tt),a(U),a(et),a(at),a(C),a(st),a(lt),a(k),a(nt),a(it),a(Z),a(pt),a(W),a(mt),a(ot),a(N),a(ct),a(rt),a(G),a(ht),a(Mt),a(Q),a(dt),a(gt),a(Jt),a(wt),a(Y)),a(g),d(J,t),d(u,t),d(b,t),d(I,t),d($,t),d(x,t),d(B,t),d(E,t),d(v,t),d(V,t),d(_,t),d(R,t)}}}const Yt='{"title":"EfficientNet (Knapsack Pruned)","local":"efficientnet-knapsack-pruned","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function zt(jt){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends Vt{constructor(g){super(),_t(this,g,zt,Ft,Gt,{})}}export{Dt as component};
