# @huggingface/hub

## Classes

- [HubApiError](classes/HubApiError)
- [InvalidApiResponseFormatError](classes/InvalidApiResponseFormatError)
- [\_\_internal\_XetBlob](classes/_internal_XetBlob)

## Interfaces

- [AuthInfo](interfaces/AuthInfo)
- [CachedFileInfo](interfaces/CachedFileInfo)
- [CachedRepoInfo](interfaces/CachedRepoInfo)
- [CachedRevisionInfo](interfaces/CachedRevisionInfo)
- [CommitData](interfaces/CommitData)
- [CommitDeletedEntry](interfaces/CommitDeletedEntry)
- [CommitEditFile](interfaces/CommitEditFile)
- [CommitFile](interfaces/CommitFile)
- [CommitInfo](interfaces/CommitInfo)
- [CommitOutput](interfaces/CommitOutput)
- [Credentials](interfaces/Credentials)
- [DatasetEntry](interfaces/DatasetEntry)
- [FileDownloadInfoOutput](interfaces/FileDownloadInfoOutput)
- [HFCacheInfo](interfaces/HFCacheInfo)
- [LfsPathInfo](interfaces/LfsPathInfo)
- [ListFileEntry](interfaces/ListFileEntry)
- [ModelConfig](interfaces/ModelConfig)
- [ModelEntry](interfaces/ModelEntry)
- [OAuthResult](interfaces/OAuthResult)
- [PathInfo](interfaces/PathInfo)
- [QuantizationConfig](interfaces/QuantizationConfig)
- [RepoId](interfaces/RepoId)
- [SafetensorsIndexJson](interfaces/SafetensorsIndexJson)
- [SafetensorsShardFileInfo](interfaces/SafetensorsShardFileInfo)
- [SecurityFileStatus](interfaces/SecurityFileStatus)
- [SpaceEntry](interfaces/SpaceEntry)
- [SpaceResourceConfig](interfaces/SpaceResourceConfig)
- [SpaceResourceRequirement](interfaces/SpaceResourceRequirement)
- [SpaceRuntime](interfaces/SpaceRuntime)
- [TensorInfo](interfaces/TensorInfo)
- [UserInfo](interfaces/UserInfo)
- [WhoAmIApp](interfaces/WhoAmIApp)
- [WhoAmIOrg](interfaces/WhoAmIOrg)
- [WhoAmIUser](interfaces/WhoAmIUser)
- [XetFileInfo](interfaces/XetFileInfo)

## Type Aliases

### AccessToken

Ƭ **AccessToken**: `string`

Actually `hf_${string}`, but for convenience, using the string type

#### Defined in[[accesstoken.defined-in]]

[packages/hub/src/types/public.ts:15](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/types/public.ts#L15)

___

### AccessTokenRole

Ƭ **AccessTokenRole**: ``"admin"`` \| ``"write"`` \| ``"contributor"`` \| ``"read"``

#### Defined in[[accesstokenrole.defined-in]]

[packages/hub/src/types/public.ts:70](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/types/public.ts#L70)

___

### AuthType

Ƭ **AuthType**: ``"access_token"`` \| ``"app_token"`` \| ``"app_token_as_user"``

#### Defined in[[authtype.defined-in]]

[packages/hub/src/types/public.ts:72](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/types/public.ts#L72)

___

### CommitOperation

Ƭ **CommitOperation**: [`CommitDeletedEntry`](interfaces/CommitDeletedEntry) \| [`CommitFile`](interfaces/CommitFile) \| [`CommitEditFile`](interfaces/CommitEditFile)

#### Defined in[[commitoperation.defined-in]]

[packages/hub/src/lib/commit.ts:87](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/commit.ts#L87)

___

### CommitParams

Ƭ **CommitParams**: \{ `abortSignal?`: `AbortSignal` ; `branch?`: `string` ; `description?`: `string` ; `fetch?`: typeof [`__type`](classes/_internal_XetBlob#__type) ; `hubUrl?`: `string` ; `isPullRequest?`: `boolean` ; `maxFolderDepth?`: `number` ; `operations`: [`CommitOperation`](modules#commitoperation)[] ; `parentCommit?`: `string` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `title`: `string` ; `useWebWorkers?`: `boolean` \| \{ `minSize?`: `number` ; `poolSize?`: `number`  } ; `useXet?`: `boolean`  } & `Partial`\<`CredentialsParams`\>

#### Defined in[[commitparams.defined-in]]

[packages/hub/src/lib/commit.ts:90](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/commit.ts#L90)

___

### CommitProgressEvent

Ƭ **CommitProgressEvent**: \{ `event`: ``"phase"`` ; `phase`: ``"preuploading"`` \| ``"uploadingLargeFiles"`` \| ``"committing"``  } \| \{ `event`: ``"fileProgress"`` ; `path`: `string` ; `progress`: `number` ; `state`: ``"hashing"`` \| ``"uploading"``  }

#### Defined in[[commitprogressevent.defined-in]]

[packages/hub/src/lib/commit.ts:146](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/commit.ts#L146)

___

### ContentSource

Ƭ **ContentSource**: `Blob` \| `URL`

#### Defined in[[contentsource.defined-in]]

[packages/hub/src/lib/commit.ts:38](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/commit.ts#L38)

___

### Dtype

Ƭ **Dtype**: ``"F64"`` \| ``"F32"`` \| ``"F16"`` \| ``"F8_E4M3"`` \| ``"F8_E5M2"`` \| ``"E8M0"`` \| ``"F6_E3M2"`` \| ``"F6_E2M3"`` \| ``"F4"`` \| ``"FP4"`` \| ``"BF16"`` \| ``"I64"`` \| ``"I32"`` \| ``"I16"`` \| ``"I8"`` \| ``"U16"`` \| ``"U8"`` \| ``"UE8"`` \| ``"BOOL"``

#### Defined in[[dtype.defined-in]]

[packages/hub/src/lib/parse-safetensors-metadata.ts:46](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/parse-safetensors-metadata.ts#L46)

___

### PipelineType

Ƭ **PipelineType**: keyof typeof `PIPELINE_DATA`

#### Defined in[[pipelinetype.defined-in]]

packages/tasks/dist/commonjs/pipelines.d.ts:372

___

### RepoDesignation

Ƭ **RepoDesignation**: [`RepoId`](interfaces/RepoId) \| [`RepoFullName`](modules#repofullname)

#### Defined in[[repodesignation.defined-in]]

[packages/hub/src/types/public.ts:12](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/types/public.ts#L12)

___

### RepoFullName

Ƭ **RepoFullName**: `string` \| \`spaces/$\{string}\` \| \`datasets/$\{string}\`

#### Defined in[[repofullname.defined-in]]

[packages/hub/src/types/public.ts:10](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/types/public.ts#L10)

___

### RepoType

Ƭ **RepoType**: ``"space"`` \| ``"dataset"`` \| ``"model"``

#### Defined in[[repotype.defined-in]]

[packages/hub/src/types/public.ts:3](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/types/public.ts#L3)

___

### SafetensorsFileHeader

Ƭ **SafetensorsFileHeader**: `Record`\<[`TensorName`](modules#tensorname), [`TensorInfo`](interfaces/TensorInfo)\> & \{ `__metadata__`: \{ `total_parameters?`: `string` \| `number`  } & `Record`\<`string`, `string`\>  }

#### Defined in[[safetensorsfileheader.defined-in]]

[packages/hub/src/lib/parse-safetensors-metadata.ts:73](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/parse-safetensors-metadata.ts#L73)

___

### SafetensorsParseFromRepo

Ƭ **SafetensorsParseFromRepo**: \{ `header`: [`SafetensorsFileHeader`](modules#safetensorsfileheader) ; `parameterCount?`: `Partial`\<`Record`\<[`Dtype`](modules#dtype), `number`\>\> ; `parameterTotal?`: `number` ; `sharded`: ``false``  } \| \{ `headers`: [`SafetensorsShardedHeaders`](modules#safetensorsshardedheaders) ; `index`: [`SafetensorsIndexJson`](interfaces/SafetensorsIndexJson) ; `parameterCount?`: `Partial`\<`Record`\<[`Dtype`](modules#dtype), `number`\>\> ; `parameterTotal?`: `number` ; `sharded`: ``true``  }

#### Defined in[[safetensorsparsefromrepo.defined-in]]

[packages/hub/src/lib/parse-safetensors-metadata.ts:87](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/parse-safetensors-metadata.ts#L87)

___

### SafetensorsShardedHeaders

Ƭ **SafetensorsShardedHeaders**: `Record`\<`FileName`, [`SafetensorsFileHeader`](modules#safetensorsfileheader)\>

#### Defined in[[safetensorsshardedheaders.defined-in]]

[packages/hub/src/lib/parse-safetensors-metadata.ts:85](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/parse-safetensors-metadata.ts#L85)

___

### SpaceHardwareFlavor

Ƭ **SpaceHardwareFlavor**: ``"cpu-basic"`` \| ``"cpu-upgrade"`` \| ``"t4-small"`` \| ``"t4-medium"`` \| ``"l4x1"`` \| ``"l4x4"`` \| ``"a10g-small"`` \| ``"a10g-large"`` \| ``"a10g-largex2"`` \| ``"a10g-largex4"`` \| ``"a100-large"`` \| ``"v5e-1x1"`` \| ``"v5e-2x2"`` \| ``"v5e-2x4"``

#### Defined in[[spacehardwareflavor.defined-in]]

[packages/hub/src/types/public.ts:40](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/types/public.ts#L40)

___

### SpaceSdk

Ƭ **SpaceSdk**: ``"streamlit"`` \| ``"gradio"`` \| ``"docker"`` \| ``"static"``

#### Defined in[[spacesdk.defined-in]]

[packages/hub/src/types/public.ts:56](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/types/public.ts#L56)

___

### SpaceStage

Ƭ **SpaceStage**: ``"NO_APP_FILE"`` \| ``"CONFIG_ERROR"`` \| ``"BUILDING"`` \| ``"BUILD_ERROR"`` \| ``"RUNNING"`` \| ``"RUNNING_BUILDING"`` \| ``"RUNTIME_ERROR"`` \| ``"DELETING"`` \| ``"PAUSED"`` \| ``"SLEEPING"``

#### Defined in[[spacestage.defined-in]]

[packages/hub/src/types/public.ts:58](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/types/public.ts#L58)

___

### TensorName

Ƭ **TensorName**: `string`

#### Defined in[[tensorname.defined-in]]

[packages/hub/src/lib/parse-safetensors-metadata.ts:45](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/parse-safetensors-metadata.ts#L45)

___

### WhoAmI

Ƭ **WhoAmI**: [`WhoAmIApp`](interfaces/WhoAmIApp) \| [`WhoAmIOrg`](interfaces/WhoAmIOrg) \| [`WhoAmIUser`](interfaces/WhoAmIUser)

#### Defined in[[whoami.defined-in]]

[packages/hub/src/lib/who-am-i.ts:50](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/who-am-i.ts#L50)

## Variables

### DATASET\_EXPANDABLE\_KEYS

• `Const` **DATASET\_EXPANDABLE\_KEYS**: readonly [``"author"``, ``"cardData"``, ``"citation"``, ``"createdAt"``, ``"disabled"``, ``"description"``, ``"downloads"``, ``"downloadsAllTime"``, ``"gated"``, ``"gitalyUid"``, ``"lastModified"``, ``"likes"``, ``"paperswithcode_id"``, ``"private"``, ``"sha"``, ``"tags"``]

#### Defined in[[datasetexpandablekeys.defined-in]]

[packages/hub/src/lib/list-datasets.ts:17](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/list-datasets.ts#L17)

___

### DATASET\_EXPAND\_KEYS

• `Const` **DATASET\_EXPAND\_KEYS**: readonly [``"private"``, ``"downloads"``, ``"gated"``, ``"likes"``, ``"lastModified"``]

#### Defined in[[datasetexpandkeys.defined-in]]

[packages/hub/src/lib/list-datasets.ts:9](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/list-datasets.ts#L9)

___

### DEFAULT\_REVISION

• `Const` **DEFAULT\_REVISION**: ``"main"``

#### Defined in[[defaultrevision.defined-in]]

[packages/hub/src/lib/snapshot-download.ts:12](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/snapshot-download.ts#L12)

___

### HUB\_URL

• `Const` **HUB\_URL**: ``"https://huggingface.co"``

#### Defined in[[huburl.defined-in]]

[packages/hub/src/consts.ts:1](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/consts.ts#L1)

___

### MODEL\_EXPANDABLE\_KEYS

• `Const` **MODEL\_EXPANDABLE\_KEYS**: readonly [``"author"``, ``"cardData"``, ``"config"``, ``"createdAt"``, ``"disabled"``, ``"downloads"``, ``"downloadsAllTime"``, ``"gated"``, ``"gitalyUid"``, ``"inferenceProviderMapping"``, ``"lastModified"``, ``"library_name"``, ``"likes"``, ``"model-index"``, ``"pipeline_tag"``, ``"private"``, ``"safetensors"``, ``"sha"``, ``"spaces"``, ``"tags"``, ``"transformersInfo"``]

#### Defined in[[modelexpandablekeys.defined-in]]

[packages/hub/src/lib/list-models.ts:19](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/list-models.ts#L19)

___

### MODEL\_EXPAND\_KEYS

• `Const` **MODEL\_EXPAND\_KEYS**: readonly [``"pipeline_tag"``, ``"private"``, ``"gated"``, ``"downloads"``, ``"likes"``, ``"lastModified"``]

#### Defined in[[modelexpandkeys.defined-in]]

[packages/hub/src/lib/list-models.ts:10](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/list-models.ts#L10)

___

### REGEX\_COMMIT\_HASH

• `Const` **REGEX\_COMMIT\_HASH**: `RegExp`

#### Defined in[[regexcommithash.defined-in]]

[packages/hub/src/lib/download-file-to-cache-dir.ts:15](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/download-file-to-cache-dir.ts#L15)

___

### REPO\_ID\_SEPARATOR

• `Const` **REPO\_ID\_SEPARATOR**: `string` = `"--"`

#### Defined in[[repoidseparator.defined-in]]

[packages/hub/src/lib/cache-management.ts:25](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/cache-management.ts#L25)

___

### RE\_SAFETENSORS\_FILE

• `Const` **RE\_SAFETENSORS\_FILE**: `RegExp`

#### Defined in[[resafetensorsfile.defined-in]]

[packages/hub/src/lib/parse-safetensors-metadata.ts:14](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/parse-safetensors-metadata.ts#L14)

___

### RE\_SAFETENSORS\_INDEX\_FILE

• `Const` **RE\_SAFETENSORS\_INDEX\_FILE**: `RegExp`

#### Defined in[[resafetensorsindexfile.defined-in]]

[packages/hub/src/lib/parse-safetensors-metadata.ts:15](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/parse-safetensors-metadata.ts#L15)

___

### RE\_SAFETENSORS\_SHARD\_FILE

• `Const` **RE\_SAFETENSORS\_SHARD\_FILE**: `RegExp`

#### Defined in[[resafetensorsshardfile.defined-in]]

[packages/hub/src/lib/parse-safetensors-metadata.ts:16](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/parse-safetensors-metadata.ts#L16)

___

### SAFETENSORS\_FILE

• `Const` **SAFETENSORS\_FILE**: ``"model.safetensors"``

#### Defined in[[safetensorsfile.defined-in]]

[packages/hub/src/lib/parse-safetensors-metadata.ts:10](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/parse-safetensors-metadata.ts#L10)

___

### SAFETENSORS\_INDEX\_FILE

• `Const` **SAFETENSORS\_INDEX\_FILE**: ``"model.safetensors.index.json"``

#### Defined in[[safetensorsindexfile.defined-in]]

[packages/hub/src/lib/parse-safetensors-metadata.ts:11](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/parse-safetensors-metadata.ts#L11)

___

### SPACE\_EXPANDABLE\_KEYS

• `Const` **SPACE\_EXPANDABLE\_KEYS**: readonly [``"author"``, ``"cardData"``, ``"datasets"``, ``"disabled"``, ``"gitalyUid"``, ``"lastModified"``, ``"createdAt"``, ``"likes"``, ``"private"``, ``"runtime"``, ``"sdk"``, ``"sha"``, ``"subdomain"``, ``"tags"``, ``"models"``]

#### Defined in[[spaceexpandablekeys.defined-in]]

[packages/hub/src/lib/list-spaces.ts:15](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/list-spaces.ts#L15)

___

### SPACE\_EXPAND\_KEYS

• `Const` **SPACE\_EXPAND\_KEYS**: readonly [``"sdk"``, ``"likes"``, ``"private"``, ``"lastModified"``]

#### Defined in[[spaceexpandkeys.defined-in]]

[packages/hub/src/lib/list-spaces.ts:9](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/list-spaces.ts#L9)

## Functions

### \_\_internal\_sha256

▸ **__internal_sha256**(`buffer`, `opts?`): `AsyncGenerator`\<`number`, `string`\>

#### Parameters[[internalsha256.parameters]]

| Name | Type |
| :------ | :------ |
| `buffer` | `Blob` |
| `opts?` | `Object` |
| `opts.abortSignal?` | `AbortSignal` |
| `opts.useWebWorker?` | `boolean` \| \{ `minSize?`: `number` ; `poolSize?`: `number`  } |

#### Returns[[internalsha256.returns]]

`AsyncGenerator`\<`number`, `string`\>

hex-encoded sha

**`Yields`**

progress (0-1)

#### Defined in[[internalsha256.defined-in]]

[packages/hub/src/utils/sha256.ts:72](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/utils/sha256.ts#L72)

___

### checkRepoAccess

▸ **checkRepoAccess**(`params`): `Promise`\<`void`\>

Check if we have read access to a repository.

Throw a [HubApiError](classes/HubApiError) error if we don't have access. HubApiError.statusCode will be 401, 403 or 404.

#### Parameters[[checkrepoaccess.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `repo`: [`RepoDesignation`](modules#repodesignation)  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[checkrepoaccess.returns]]

`Promise`\<`void`\>

#### Defined in[[checkrepoaccess.defined-in]]

[packages/hub/src/lib/check-repo-access.ts:13](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/check-repo-access.ts#L13)

___

### commit

▸ **commit**(`params`): `Promise`\<[`CommitOutput`](interfaces/CommitOutput)\>

#### Parameters[[commit.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | [`CommitParams`](modules#commitparams) |

#### Returns[[commit.returns]]

`Promise`\<[`CommitOutput`](interfaces/CommitOutput)\>

#### Defined in[[commit.defined-in]]

[packages/hub/src/lib/commit.ts:707](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/commit.ts#L707)

___

### commitIter

▸ **commitIter**(`params`): `AsyncGenerator`\<[`CommitProgressEvent`](modules#commitprogressevent), [`CommitOutput`](interfaces/CommitOutput)\>

Internal function for now, used by commit.

Can be exposed later to offer fine-tuned progress info

#### Parameters[[commititer.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | [`CommitParams`](modules#commitparams) |

#### Returns[[commititer.returns]]

`AsyncGenerator`\<[`CommitProgressEvent`](modules#commitprogressevent), [`CommitOutput`](interfaces/CommitOutput)\>

#### Defined in[[commititer.defined-in]]

[packages/hub/src/lib/commit.ts:163](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/commit.ts#L163)

___

### countCommits

▸ **countCommits**(`params`): `Promise`\<`number`\>

#### Parameters[[countcommits.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[countcommits.returns]]

`Promise`\<`number`\>

#### Defined in[[countcommits.defined-in]]

[packages/hub/src/lib/count-commits.ts:7](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/count-commits.ts#L7)

___

### createBranch

▸ **createBranch**(`params`): `Promise`\<`void`\>

#### Parameters[[createbranch.parameters]]

| Name | Type | Description |
| :------ | :------ | :------ |
| `params` | `Object` | - |
| `params.accessToken?` | `string` | - |
| `params.branch` | `string` | The name of the branch to create |
| `params.empty?` | `boolean` | Use this to create an empty branch, with no commits. |
| `params.fetch?` | (`input`: `URL` \| `RequestInfo`, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> | [MDN Reference](https://developer.mozilla.org/docs/Web/API/Window/fetch) |
| `params.hubUrl?` | `string` | - |
| `params.overwrite?` | `boolean` | Use this to overwrite the branch if it already exists. If you only specify `overwrite` and no `revision`/`empty`, and the branch already exists, it will be a no-op. |
| `params.repo` | [`RepoDesignation`](modules#repodesignation) | - |
| `params.revision?` | `string` | Revision to create the branch from. Defaults to the default branch. Use empty: true to create an empty branch. |

#### Returns[[createbranch.returns]]

`Promise`\<`void`\>

#### Defined in[[createbranch.defined-in]]

[packages/hub/src/lib/create-branch.ts:6](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/create-branch.ts#L6)

___

### createCollection

▸ **createCollection**(`params`): `Promise`\<\{ `slug`: `string`  }\>

#### Parameters[[createcollection.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `collection`: `ApiCreateCollectionPayload` ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[createcollection.returns]]

`Promise`\<\{ `slug`: `string`  }\>

#### Defined in[[createcollection.defined-in]]

[packages/hub/src/lib/create-collection.ts:7](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/create-collection.ts#L7)

___

### createRepo

▸ **createRepo**(`params`): `Promise`\<\{ `repoUrl`: `string`  }\>

#### Parameters[[createrepo.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `files?`: \{ `content`: `ArrayBuffer` \| `Blob` ; `path`: `string`  }[] ; `hubUrl?`: `string` ; `license?`: `string` ; `private?`: `boolean` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `sdk?`: SpaceSdk \| undefined  } & `CredentialsParams` |

#### Returns[[createrepo.returns]]

`Promise`\<\{ `repoUrl`: `string`  }\>

#### Defined in[[createrepo.defined-in]]

[packages/hub/src/lib/create-repo.ts:9](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/create-repo.ts#L9)

___

### datasetInfo

▸ **datasetInfo**\<`T`\>(`params`): `Promise`\<[`DatasetEntry`](interfaces/DatasetEntry) & `Pick`\<`ApiDatasetInfo`, `T`\>\>

#### Type parameters[[datasetinfo.type-parameters]]

| Name | Type |
| :------ | :------ |
| `T` | extends ``"author"`` \| ``"cardData"`` \| ``"disabled"`` \| ``"gitalyUid"`` \| ``"createdAt"`` \| ``"tags"`` \| ``"paperswithcode_id"`` \| ``"sha"`` \| ``"citation"`` \| ``"description"`` \| ``"downloadsAllTime"`` = `never` |

#### Parameters[[datasetinfo.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `additionalFields?`: `T`[] ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `name`: `string` ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[datasetinfo.returns]]

`Promise`\<[`DatasetEntry`](interfaces/DatasetEntry) & `Pick`\<`ApiDatasetInfo`, `T`\>\>

#### Defined in[[datasetinfo.defined-in]]

[packages/hub/src/lib/dataset-info.ts:9](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/dataset-info.ts#L9)

___

### deleteBranch

▸ **deleteBranch**(`params`): `Promise`\<`void`\>

#### Parameters[[deletebranch.parameters]]

| Name | Type | Description |
| :------ | :------ | :------ |
| `params` | `Object` | - |
| `params.accessToken?` | `string` | - |
| `params.branch` | `string` | The name of the branch to delete |
| `params.fetch?` | (`input`: `URL` \| `RequestInfo`, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> | [MDN Reference](https://developer.mozilla.org/docs/Web/API/Window/fetch) |
| `params.hubUrl?` | `string` | - |
| `params.repo` | [`RepoDesignation`](modules#repodesignation) | - |

#### Returns[[deletebranch.returns]]

`Promise`\<`void`\>

#### Defined in[[deletebranch.defined-in]]

[packages/hub/src/lib/delete-branch.ts:6](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/delete-branch.ts#L6)

___

### deleteCollection

▸ **deleteCollection**(`params`): `Promise`\<`void`\>

#### Parameters[[deletecollection.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `slug`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[deletecollection.returns]]

`Promise`\<`void`\>

#### Defined in[[deletecollection.defined-in]]

[packages/hub/src/lib/delete-collection.ts:6](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/delete-collection.ts#L6)

___

### deleteFile

▸ **deleteFile**(`params`): `Promise`\<[`CommitOutput`](interfaces/CommitOutput)\>

#### Parameters[[deletefile.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `branch?`: `string` ; `commitDescription?`: `string` ; `commitTitle?`: `string` ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `isPullRequest?`: `boolean` ; `parentCommit?`: `string` ; `path`: `string` ; `repo`: [`RepoDesignation`](modules#repodesignation)  } & `CredentialsParams` |

#### Returns[[deletefile.returns]]

`Promise`\<[`CommitOutput`](interfaces/CommitOutput)\>

#### Defined in[[deletefile.defined-in]]

[packages/hub/src/lib/delete-file.ts:5](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/delete-file.ts#L5)

___

### deleteFiles

▸ **deleteFiles**(`params`): `Promise`\<[`CommitOutput`](interfaces/CommitOutput)\>

#### Parameters[[deletefiles.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `branch?`: `string` ; `commitDescription?`: `string` ; `commitTitle?`: `string` ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `isPullRequest?`: `boolean` ; `parentCommit?`: `string` ; `paths`: `string`[] ; `repo`: [`RepoDesignation`](modules#repodesignation)  } & `CredentialsParams` |

#### Returns[[deletefiles.returns]]

`Promise`\<[`CommitOutput`](interfaces/CommitOutput)\>

#### Defined in[[deletefiles.defined-in]]

[packages/hub/src/lib/delete-files.ts:5](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/delete-files.ts#L5)

___

### deleteRepo

▸ **deleteRepo**(`params`): `Promise`\<`void`\>

#### Parameters[[deleterepo.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `repo`: [`RepoDesignation`](modules#repodesignation)  } & `CredentialsParams` |

#### Returns[[deleterepo.returns]]

`Promise`\<`void`\>

#### Defined in[[deleterepo.defined-in]]

[packages/hub/src/lib/delete-repo.ts:7](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/delete-repo.ts#L7)

___

### downloadFile

▸ **downloadFile**(`params`): `Promise`\<`Blob` \| ``null``\>

#### Parameters[[downloadfile.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `downloadInfo?`: [`FileDownloadInfoOutput`](interfaces/FileDownloadInfoOutput) ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `path`: `string` ; `raw?`: `boolean` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `revision?`: `string` ; `xet?`: `boolean`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[downloadfile.returns]]

`Promise`\<`Blob` \| ``null``\>

null when the file doesn't exist

#### Defined in[[downloadfile.defined-in]]

[packages/hub/src/lib/download-file.ts:11](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/download-file.ts#L11)

___

### downloadFileToCacheDir

▸ **downloadFileToCacheDir**(`params`): `Promise`\<`string`\>

Download a given file if it's not already present in the local cache.

#### Parameters[[downloadfiletocachedir.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `cacheDir?`: `string` ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `path`: `string` ; `raw?`: `boolean` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[downloadfiletocachedir.returns]]

`Promise`\<`string`\>

the symlink to the blob object

#### Defined in[[downloadfiletocachedir.defined-in]]

[packages/hub/src/lib/download-file-to-cache-dir.ts:45](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/download-file-to-cache-dir.ts#L45)

___

### fileDownloadInfo

▸ **fileDownloadInfo**(`params`): `Promise`\<[`FileDownloadInfoOutput`](interfaces/FileDownloadInfoOutput) \| ``null``\>

#### Parameters[[filedownloadinfo.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `noContentDisposition?`: `boolean` ; `path`: `string` ; `raw?`: `boolean` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[filedownloadinfo.returns]]

`Promise`\<[`FileDownloadInfoOutput`](interfaces/FileDownloadInfoOutput) \| ``null``\>

null when the file doesn't exist

#### Defined in[[filedownloadinfo.defined-in]]

[packages/hub/src/lib/file-download-info.ts:27](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/file-download-info.ts#L27)

___

### fileExists

▸ **fileExists**(`params`): `Promise`\<`boolean`\>

#### Parameters[[fileexists.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `path`: `string` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[fileexists.returns]]

`Promise`\<`boolean`\>

#### Defined in[[fileexists.defined-in]]

[packages/hub/src/lib/file-exists.ts:7](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/file-exists.ts#L7)

___

### getBlobStat

▸ **getBlobStat**(`blobPath`, `blobStats`): `Promise`\<`Stats`\>

#### Parameters[[getblobstat.parameters]]

| Name | Type |
| :------ | :------ |
| `blobPath` | `string` |
| `blobStats` | `Map`\<`string`, `Stats`\> |

#### Returns[[getblobstat.returns]]

`Promise`\<`Stats`\>

#### Defined in[[getblobstat.defined-in]]

[packages/hub/src/lib/cache-management.ts:244](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/cache-management.ts#L244)

___

### getHFHubCachePath

▸ **getHFHubCachePath**(): `string`

#### Returns[[gethfhubcachepath.returns]]

`string`

#### Defined in[[gethfhubcachepath.defined-in]]

[packages/hub/src/lib/cache-management.ts:19](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/cache-management.ts#L19)

___

### getRepoFolderName

▸ **getRepoFolderName**(`«destructured»`): `string`

#### Parameters[[getrepofoldername.parameters]]

| Name | Type |
| :------ | :------ |
| `«destructured»` | [`RepoId`](interfaces/RepoId) |

#### Returns[[getrepofoldername.returns]]

`string`

#### Defined in[[getrepofoldername.defined-in]]

[packages/hub/src/lib/cache-management.ts:27](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/cache-management.ts#L27)

___

### listCollections

▸ **listCollections**(`params?`): `AsyncGenerator`\<`ApiCollectionInfo`\>

#### Parameters[[listcollections.parameters]]

| Name | Type |
| :------ | :------ |
| `params?` | \{ search?: \{ owner?: string[] \| undefined; item?: string[] \| undefined; q?: string \| undefined; } \| undefined; sort?: "lastModified" \| "trending" \| "upvotes" \| undefined; limit?: number \| undefined; hubUrl?: string \| undefined; fetch?: \{ ...; } \| undefined; } & Partial\<...\> |

#### Returns[[listcollections.returns]]

`AsyncGenerator`\<`ApiCollectionInfo`\>

#### Defined in[[listcollections.defined-in]]

[packages/hub/src/lib/list-collections.ts:12](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/list-collections.ts#L12)

___

### listCommits

▸ **listCommits**(`params`): `AsyncGenerator`\<[`CommitData`](interfaces/CommitData)\>

#### Parameters[[listcommits.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `batchSize?`: `number` ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[listcommits.returns]]

`AsyncGenerator`\<[`CommitData`](interfaces/CommitData)\>

#### Defined in[[listcommits.defined-in]]

[packages/hub/src/lib/list-commits.ts:17](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/list-commits.ts#L17)

___

### listDatasets

▸ **listDatasets**\<`T`\>(`params?`): `AsyncGenerator`\<[`DatasetEntry`](interfaces/DatasetEntry) & `Pick`\<`ApiDatasetInfo`, `T`\>\>

#### Type parameters[[listdatasets.type-parameters]]

| Name | Type |
| :------ | :------ |
| `T` | extends ``"author"`` \| ``"cardData"`` \| ``"disabled"`` \| ``"gitalyUid"`` \| ``"createdAt"`` \| ``"tags"`` \| ``"paperswithcode_id"`` \| ``"sha"`` \| ``"citation"`` \| ``"description"`` \| ``"downloadsAllTime"`` = `never` |

#### Parameters[[listdatasets.parameters]]

| Name | Type |
| :------ | :------ |
| `params?` | \{ search?: \{ query?: string \| undefined; owner?: string \| undefined; tags?: string[] \| undefined; } \| undefined; hubUrl?: string \| undefined; additionalFields?: T[] \| undefined; limit?: number \| undefined; fetch?: \{ ...; } \| undefined; } & Partial\<...\> |

#### Returns[[listdatasets.returns]]

`AsyncGenerator`\<[`DatasetEntry`](interfaces/DatasetEntry) & `Pick`\<`ApiDatasetInfo`, `T`\>\>

#### Defined in[[listdatasets.defined-in]]

[packages/hub/src/lib/list-datasets.ts:47](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/list-datasets.ts#L47)

___

### listFiles

▸ **listFiles**(`params`): `AsyncGenerator`\<[`ListFileEntry`](interfaces/ListFileEntry)\>

List files in a folder. To list ALL files in the directory, call it
with params.recursive set to `true`.

#### Parameters[[listfiles.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `expand?`: `boolean` ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `path?`: `string` ; `recursive?`: `boolean` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[listfiles.returns]]

`AsyncGenerator`\<[`ListFileEntry`](interfaces/ListFileEntry)\>

#### Defined in[[listfiles.defined-in]]

[packages/hub/src/lib/list-files.ts:42](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/list-files.ts#L42)

___

### listModels

▸ **listModels**\<`T`\>(`params?`): `AsyncGenerator`\<[`ModelEntry`](interfaces/ModelEntry) & `Pick`\<`ApiModelInfo`, `T`\>\>

#### Type parameters[[listmodels.type-parameters]]

| Name | Type |
| :------ | :------ |
| `T` | extends ``"spaces"`` \| ``"author"`` \| ``"cardData"`` \| ``"disabled"`` \| ``"gitalyUid"`` \| ``"createdAt"`` \| ``"tags"`` \| ``"sha"`` \| ``"downloadsAllTime"`` \| ``"config"`` \| ``"inferenceProviderMapping"`` \| ``"library_name"`` \| ``"model-index"`` \| ``"safetensors"`` \| ``"transformersInfo"`` = `never` |

#### Parameters[[listmodels.parameters]]

| Name | Type |
| :------ | :------ |
| `params?` | \{ search?: \{ query?: string \| undefined; owner?: string \| undefined; task?: "other" \| "text-classification" \| "token-classification" \| "table-question-answering" \| "question-answering" \| ... 50 more ... \| undefined; tags?: string[] \| undefined; inferenceProviders?: string[] \| undefined; } \| undefined; hubUrl?: strin... |

#### Returns[[listmodels.returns]]

`AsyncGenerator`\<[`ModelEntry`](interfaces/ModelEntry) & `Pick`\<`ApiModelInfo`, `T`\>\>

#### Defined in[[listmodels.defined-in]]

[packages/hub/src/lib/list-models.ts:55](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/list-models.ts#L55)

___

### listSpaces

▸ **listSpaces**\<`T`\>(`params?`): `AsyncGenerator`\<[`SpaceEntry`](interfaces/SpaceEntry) & `Pick`\<`ApiSpaceInfo`, `T`\>\>

#### Type parameters[[listspaces.type-parameters]]

| Name | Type |
| :------ | :------ |
| `T` | extends ``"models"`` \| ``"datasets"`` \| ``"author"`` \| ``"cardData"`` \| ``"disabled"`` \| ``"gitalyUid"`` \| ``"createdAt"`` \| ``"tags"`` \| ``"sha"`` \| ``"subdomain"`` \| ``"runtime"`` = `never` |

#### Parameters[[listspaces.parameters]]

| Name | Type |
| :------ | :------ |
| `params?` | \{ search?: \{ query?: string \| undefined; owner?: string \| undefined; tags?: string[] \| undefined; } \| undefined; hubUrl?: string \| undefined; fetch?: \{ (input: URL \| RequestInfo, init?: RequestInit \| undefined): Promise\<...\>; (input: string \| ... 1 more ... \| Request, init?: RequestInit \| undefined): Promise\<...\>; }... |

#### Returns[[listspaces.returns]]

`AsyncGenerator`\<[`SpaceEntry`](interfaces/SpaceEntry) & `Pick`\<`ApiSpaceInfo`, `T`\>\>

#### Defined in[[listspaces.defined-in]]

[packages/hub/src/lib/list-spaces.ts:44](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/list-spaces.ts#L44)

___

### modelInfo

▸ **modelInfo**\<`T`\>(`params`): `Promise`\<[`ModelEntry`](interfaces/ModelEntry) & `Pick`\<`ApiModelInfo`, `T`\>\>

#### Type parameters[[modelinfo.type-parameters]]

| Name | Type |
| :------ | :------ |
| `T` | extends ``"spaces"`` \| ``"author"`` \| ``"cardData"`` \| ``"disabled"`` \| ``"gitalyUid"`` \| ``"createdAt"`` \| ``"tags"`` \| ``"sha"`` \| ``"downloadsAllTime"`` \| ``"config"`` \| ``"inferenceProviderMapping"`` \| ``"library_name"`` \| ``"model-index"`` \| ``"safetensors"`` \| ``"transformersInfo"`` = `never` |

#### Parameters[[modelinfo.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `additionalFields?`: `T`[] ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `name`: `string` ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[modelinfo.returns]]

`Promise`\<[`ModelEntry`](interfaces/ModelEntry) & `Pick`\<`ApiModelInfo`, `T`\>\>

#### Defined in[[modelinfo.defined-in]]

[packages/hub/src/lib/model-info.ts:10](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/model-info.ts#L10)

___

### oauthHandleRedirect

▸ **oauthHandleRedirect**(`opts?`): `Promise`\<[`OAuthResult`](interfaces/OAuthResult)\>

To call after the OAuth provider redirects back to the app.

There is also a helper function [oauthHandleRedirectIfPresent](modules#oauthhandleredirectifpresent), which will call `oauthHandleRedirect` if the URL contains an oauth code
in the query parameters and return `false` otherwise.

#### Parameters[[oauthhandleredirect.parameters]]

| Name | Type | Description |
| :------ | :------ | :------ |
| `opts?` | `Object` | - |
| `opts.codeVerifier?` | `string` | codeVerifier generated by oauthLoginUrl **`Default`** ```ts localStorage.getItem("huggingface.co:oauth:code_verifier") ``` |
| `opts.hubUrl?` | `string` | The URL of the hub. Defaults to [HUB_URL](modules#hub_url). |
| `opts.nonce?` | `string` | nonce generated by oauthLoginUrl **`Default`** ```ts localStorage.getItem("huggingface.co:oauth:nonce") ``` |
| `opts.redirectedUrl?` | `string` | The URL to analyze. **`Default`** ```ts window.location.href ``` |

#### Returns[[oauthhandleredirect.returns]]

`Promise`\<[`OAuthResult`](interfaces/OAuthResult)\>

#### Defined in[[oauthhandleredirect.defined-in]]

[packages/hub/src/lib/oauth-handle-redirect.ts:123](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/oauth-handle-redirect.ts#L123)

___

### oauthHandleRedirectIfPresent

▸ **oauthHandleRedirectIfPresent**(`opts?`): `Promise`\<[`OAuthResult`](interfaces/OAuthResult) \| ``false``\>

To call after the OAuth provider redirects back to the app.

It returns false if the URL does not contain an oauth code in the query parameters, otherwise
it calls [oauthHandleRedirect](modules#oauthhandleredirect).

Depending on your app, you may want to call [oauthHandleRedirect](modules#oauthhandleredirect) directly instead.

#### Parameters[[oauthhandleredirectifpresent.parameters]]

| Name | Type | Description |
| :------ | :------ | :------ |
| `opts?` | `Object` | - |
| `opts.codeVerifier?` | `string` | codeVerifier generated by oauthLoginUrl **`Default`** ```ts localStorage.getItem("huggingface.co:oauth:code_verifier") ``` |
| `opts.hubUrl?` | `string` | The URL of the hub. Defaults to [HUB_URL](modules#hub_url). |
| `opts.nonce?` | `string` | nonce generated by oauthLoginUrl **`Default`** ```ts localStorage.getItem("huggingface.co:oauth:nonce") ``` |
| `opts.redirectedUrl?` | `string` | The URL to analyze. **`Default`** ```ts window.location.href ``` |

#### Returns[[oauthhandleredirectifpresent.returns]]

`Promise`\<[`OAuthResult`](interfaces/OAuthResult) \| ``false``\>

#### Defined in[[oauthhandleredirectifpresent.defined-in]]

[packages/hub/src/lib/oauth-handle-redirect.ts:293](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/oauth-handle-redirect.ts#L293)

___

### oauthLoginUrl

▸ **oauthLoginUrl**(`opts?`): `Promise`\<`string`\>

Use "Sign in with Hub" to authenticate a user, and get oauth user info / access token.

Returns an url to redirect to. After the user is redirected back to your app, call `oauthHandleRedirect` to get the oauth user info / access token.

When called from inside a static Space with OAuth enabled, it will load the config from the space, otherwise you need to at least specify
the client ID of your OAuth App.

#### Parameters[[oauthloginurl.parameters]]

| Name | Type | Description |
| :------ | :------ | :------ |
| `opts?` | `Object` | - |
| `opts.clientId?` | `string` | OAuth client ID. For static Spaces, you can omit this and it will be loaded from the Space config, as long as `hf_oauth: true` is present in the README.md's metadata. For other Spaces, it is available to the backend in the OAUTH_CLIENT_ID environment variable, as long as `hf_oauth: true` is present in the README.md's metadata. You can also create a Developer Application at https://huggingface.co/settings/connected-applications and use its client ID. |
| `opts.hubUrl?` | `string` | - |
| `opts.localStorage?` | `Object` | If provided, will be filled with the code verifier and nonce used for the OAuth flow, instead of using localStorage. When calling `oauthHandleRedirectIfPresent` or `oauthHandleRedirect` you will need to provide the same values. |
| `opts.localStorage.codeVerifier?` | `string` | - |
| `opts.localStorage.nonce?` | `string` | - |
| `opts.redirectUrl?` | `string` | Redirect URI, defaults to the current URL. For Spaces, any URL within the Space is allowed. For Developer Applications, you can add any URL you want to the list of allowed redirect URIs at https://huggingface.co/settings/connected-applications. |
| `opts.scopes?` | `string` | OAuth scope, a list of space-separated scopes. For static Spaces, you can omit this and it will be loaded from the Space config, as long as `hf_oauth: true` is present in the README.md's metadata. For other Spaces, it is available to the backend in the OAUTH_SCOPES environment variable, as long as `hf_oauth: true` is present in the README.md's metadata. Defaults to "openid profile". You can also create a Developer Application at https://huggingface.co/settings/connected-applications and use its scopes. See https://huggingface.co/docs/hub/oauth for a list of available scopes. |
| `opts.state?` | `string` | State to pass to the OAuth provider, which will be returned in the call to `oauthLogin` after the redirect. |

#### Returns[[oauthloginurl.returns]]

`Promise`\<`string`\>

**`Example`**

```ts
import { oauthLoginUrl, oauthHandleRedirectIfPresent } from "@huggingface/hub";

const oauthResult = await oauthHandleRedirectIfPresent();

if (!oauthResult) {
  // If the user is not logged in, redirect to the login page
  window.location.href = await oauthLoginUrl();
}

// You can use oauthResult.accessToken, oauthResult.accessTokenExpiresAt and oauthResult.userInfo
console.log(oauthResult);
```

(Theoretically, this function could be used to authenticate a user for any OAuth provider supporting PKCE and OpenID Connect by changing `hubUrl`,
but it is currently only tested with the Hugging Face Hub.)

#### Defined in[[oauthloginurl.defined-in]]

[packages/hub/src/lib/oauth-login-url.ts:31](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/oauth-login-url.ts#L31)

___

### parseRepoType

▸ **parseRepoType**(`type`): [`RepoType`](modules#repotype)

#### Parameters[[parserepotype.parameters]]

| Name | Type |
| :------ | :------ |
| `type` | `string` |

#### Returns[[parserepotype.returns]]

[`RepoType`](modules#repotype)

#### Defined in[[parserepotype.defined-in]]

[packages/hub/src/lib/cache-management.ts:254](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/cache-management.ts#L254)

___

### parseSafetensorsMetadata

▸ **parseSafetensorsMetadata**(`params`): `Promise`\<`SetRequired`\<[`SafetensorsParseFromRepo`](modules#safetensorsparsefromrepo), ``"parameterCount"``\>\>

Analyze model.safetensors.index.json or model.safetensors from a model hosted
on Hugging Face using smart range requests to extract its metadata.

#### Parameters[[parsesafetensorsmetadata.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `computeParametersCount`: ``true`` ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `path?`: `string` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[parsesafetensorsmetadata.returns]]

`Promise`\<`SetRequired`\<[`SafetensorsParseFromRepo`](modules#safetensorsparsefromrepo), ``"parameterCount"``\>\>

#### Defined in[[parsesafetensorsmetadata.defined-in]]

[packages/hub/src/lib/parse-safetensors-metadata.ts:231](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/parse-safetensors-metadata.ts#L231)

▸ **parseSafetensorsMetadata**(`params`): `Promise`\<[`SafetensorsParseFromRepo`](modules#safetensorsparsefromrepo)\>

#### Parameters[[parsesafetensorsmetadata.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `computeParametersCount?`: `boolean` ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `path?`: `string` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[parsesafetensorsmetadata.returns]]

`Promise`\<[`SafetensorsParseFromRepo`](modules#safetensorsparsefromrepo)\>

#### Defined in[[parsesafetensorsmetadata.defined-in]]

[packages/hub/src/lib/parse-safetensors-metadata.ts:253](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/parse-safetensors-metadata.ts#L253)

___

### parseSafetensorsShardFilename

▸ **parseSafetensorsShardFilename**(`filename`): [`SafetensorsShardFileInfo`](interfaces/SafetensorsShardFileInfo) \| ``null``

#### Parameters[[parsesafetensorsshardfilename.parameters]]

| Name | Type |
| :------ | :------ |
| `filename` | `string` |

#### Returns[[parsesafetensorsshardfilename.returns]]

[`SafetensorsShardFileInfo`](interfaces/SafetensorsShardFileInfo) \| ``null``

#### Defined in[[parsesafetensorsshardfilename.defined-in]]

[packages/hub/src/lib/parse-safetensors-metadata.ts:24](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/parse-safetensors-metadata.ts#L24)

___

### pathsInfo

▸ **pathsInfo**(`params`): `Promise`\<[`PathInfo`](interfaces/PathInfo) & \{ `lastCommit`: [`CommitInfo`](interfaces/CommitInfo) ; `securityFileStatus`: [`SecurityFileStatus`](interfaces/SecurityFileStatus)  }[]\>

#### Parameters[[pathsinfo.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `expand`: ``true`` ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `paths`: `string`[] ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[pathsinfo.returns]]

`Promise`\<[`PathInfo`](interfaces/PathInfo) & \{ `lastCommit`: [`CommitInfo`](interfaces/CommitInfo) ; `securityFileStatus`: [`SecurityFileStatus`](interfaces/SecurityFileStatus)  }[]\>

#### Defined in[[pathsinfo.defined-in]]

[packages/hub/src/lib/paths-info.ts:37](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/paths-info.ts#L37)

▸ **pathsInfo**(`params`): `Promise`\<[`PathInfo`](interfaces/PathInfo)[]\>

#### Parameters[[pathsinfo.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `expand?`: `boolean` ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `paths`: `string`[] ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[pathsinfo.returns]]

`Promise`\<[`PathInfo`](interfaces/PathInfo)[]\>

#### Defined in[[pathsinfo.defined-in]]

[packages/hub/src/lib/paths-info.ts:50](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/paths-info.ts#L50)

___

### repoExists

▸ **repoExists**(`params`): `Promise`\<`boolean`\>

#### Parameters[[repoexists.parameters]]

| Name | Type | Description |
| :------ | :------ | :------ |
| `params` | `Object` | - |
| `params.accessToken?` | `string` | - |
| `params.fetch?` | (`input`: `URL` \| `RequestInfo`, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> | Custom fetch function to use instead of the default one, for example to use a proxy or edit headers. |
| `params.hubUrl?` | `string` | - |
| `params.repo` | [`RepoDesignation`](modules#repodesignation) | - |
| `params.revision?` | `string` | An optional Git revision id which can be a branch name, a tag, or a commit hash. |

#### Returns[[repoexists.returns]]

`Promise`\<`boolean`\>

#### Defined in[[repoexists.defined-in]]

[packages/hub/src/lib/repo-exists.ts:6](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/repo-exists.ts#L6)

___

### scanCacheDir

▸ **scanCacheDir**(`cacheDir?`): `Promise`\<[`HFCacheInfo`](interfaces/HFCacheInfo)\>

#### Parameters[[scancachedir.parameters]]

| Name | Type | Default value |
| :------ | :------ | :------ |
| `cacheDir` | `undefined` \| `string` | `undefined` |

#### Returns[[scancachedir.returns]]

`Promise`\<[`HFCacheInfo`](interfaces/HFCacheInfo)\>

#### Defined in[[scancachedir.defined-in]]

[packages/hub/src/lib/cache-management.ts:72](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/cache-management.ts#L72)

___

### scanCachedRepo

▸ **scanCachedRepo**(`repoPath`): `Promise`\<[`CachedRepoInfo`](interfaces/CachedRepoInfo)\>

#### Parameters[[scancachedrepo.parameters]]

| Name | Type |
| :------ | :------ |
| `repoPath` | `string` |

#### Returns[[scancachedrepo.returns]]

`Promise`\<[`CachedRepoInfo`](interfaces/CachedRepoInfo)\>

#### Defined in[[scancachedrepo.defined-in]]

[packages/hub/src/lib/cache-management.ts:114](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/cache-management.ts#L114)

___

### scanRefsDir

▸ **scanRefsDir**(`refsPath`, `refsByHash`): `Promise`\<`void`\>

#### Parameters[[scanrefsdir.parameters]]

| Name | Type |
| :------ | :------ |
| `refsPath` | `string` |
| `refsByHash` | `Map`\<`string`, `string`[]\> |

#### Returns[[scanrefsdir.returns]]

`Promise`\<`void`\>

#### Defined in[[scanrefsdir.defined-in]]

[packages/hub/src/lib/cache-management.ts:204](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/cache-management.ts#L204)

___

### scanSnapshotDir

▸ **scanSnapshotDir**(`revisionPath`, `cachedFiles`, `blobStats`): `Promise`\<`void`\>

#### Parameters[[scansnapshotdir.parameters]]

| Name | Type |
| :------ | :------ |
| `revisionPath` | `string` |
| `cachedFiles` | [`CachedFileInfo`](interfaces/CachedFileInfo)[] |
| `blobStats` | `Map`\<`string`, `Stats`\> |

#### Returns[[scansnapshotdir.returns]]

`Promise`\<`void`\>

#### Defined in[[scansnapshotdir.defined-in]]

[packages/hub/src/lib/cache-management.ts:219](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/cache-management.ts#L219)

___

### snapshotDownload

▸ **snapshotDownload**(`params`): `Promise`\<`string`\>

Downloads an entire repository at a given revision in the cache directory [getHFHubCachePath](modules#gethfhubcachepath).
You can list all cached repositories using [scanCachedRepo](modules#scancachedrepo)

#### Parameters[[snapshotdownload.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `cacheDir?`: `string` ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[snapshotdownload.returns]]

`Promise`\<`string`\>

**`Remarks`**

It uses internally [downloadFileToCacheDir](modules#downloadfiletocachedir).

#### Defined in[[snapshotdownload.defined-in]]

[packages/hub/src/lib/snapshot-download.ts:19](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/snapshot-download.ts#L19)

___

### spaceInfo

▸ **spaceInfo**\<`T`\>(`params`): `Promise`\<[`SpaceEntry`](interfaces/SpaceEntry) & `Pick`\<`ApiSpaceInfo`, `T`\>\>

#### Type parameters[[spaceinfo.type-parameters]]

| Name | Type |
| :------ | :------ |
| `T` | extends ``"models"`` \| ``"datasets"`` \| ``"author"`` \| ``"cardData"`` \| ``"disabled"`` \| ``"gitalyUid"`` \| ``"createdAt"`` \| ``"tags"`` \| ``"sha"`` \| ``"subdomain"`` \| ``"runtime"`` = `never` |

#### Parameters[[spaceinfo.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `additionalFields?`: `T`[] ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string` ; `name`: `string` ; `revision?`: `string`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[spaceinfo.returns]]

`Promise`\<[`SpaceEntry`](interfaces/SpaceEntry) & `Pick`\<`ApiSpaceInfo`, `T`\>\>

#### Defined in[[spaceinfo.defined-in]]

[packages/hub/src/lib/space-info.ts:10](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/space-info.ts#L10)

___

### uploadFile

▸ **uploadFile**(`params`): `Promise`\<[`CommitOutput`](interfaces/CommitOutput)\>

#### Parameters[[uploadfile.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `abortSignal?`: `AbortSignal` ; `branch?`: `string` ; `commitDescription?`: `string` ; `commitTitle?`: `string` ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `file`: `URL` \| `File` \| \{ `content`: [`ContentSource`](modules#contentsource) ; `path`: `string`  } ; `hubUrl?`: `string` ; `isPullRequest?`: `boolean` ; `parentCommit?`: `string` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `useWebWorkers?`: `boolean` \| \{ `minSize?`: `number` ; `poolSize?`: `number`  } ; `useXet?`: `boolean`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[uploadfile.returns]]

`Promise`\<[`CommitOutput`](interfaces/CommitOutput)\>

#### Defined in[[uploadfile.defined-in]]

[packages/hub/src/lib/upload-file.ts:5](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/upload-file.ts#L5)

___

### uploadFiles

▸ **uploadFiles**(`params`): `Promise`\<[`CommitOutput`](interfaces/CommitOutput)\>

#### Parameters[[uploadfiles.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `abortSignal?`: `AbortSignal` ; `branch?`: `string` ; `commitDescription?`: `string` ; `commitTitle?`: `string` ; `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `files`: (`URL` \| `File` \| \{ `content`: [`ContentSource`](modules#contentsource) ; `path`: `string`  })[] ; `hubUrl?`: `string` ; `isPullRequest?`: `boolean` ; `maxFolderDepth?`: `number` ; `parentCommit?`: `string` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `useWebWorkers?`: `boolean` \| \{ `minSize?`: `number` ; `poolSize?`: `number`  } ; `useXet?`: `boolean`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[uploadfiles.returns]]

`Promise`\<[`CommitOutput`](interfaces/CommitOutput)\>

#### Defined in[[uploadfiles.defined-in]]

[packages/hub/src/lib/upload-files.ts:5](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/upload-files.ts#L5)

___

### uploadFilesWithProgress

▸ **uploadFilesWithProgress**(`params`): `AsyncGenerator`\<[`CommitProgressEvent`](modules#commitprogressevent), [`CommitOutput`](interfaces/CommitOutput)\>

Uploads with progress

Needs XMLHttpRequest to be available for progress events for uploads
Set useWebWorkers to true in order to have progress events for hashing

#### Parameters[[uploadfileswithprogress.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `abortSignal?`: `AbortSignal` ; `branch?`: `string` ; `commitDescription?`: `string` ; `commitTitle?`: `string` ; `files`: (`URL` \| `File` \| \{ `content`: [`ContentSource`](modules#contentsource) ; `path`: `string`  })[] ; `hubUrl?`: `string` ; `isPullRequest?`: `boolean` ; `maxFolderDepth?`: `number` ; `parentCommit?`: `string` ; `repo`: [`RepoDesignation`](modules#repodesignation) ; `useWebWorkers?`: `boolean` \| \{ `minSize?`: `number` ; `poolSize?`: `number`  } ; `useXet?`: `boolean`  } & `Partial`\<`CredentialsParams`\> |

#### Returns[[uploadfileswithprogress.returns]]

`AsyncGenerator`\<[`CommitProgressEvent`](modules#commitprogressevent), [`CommitOutput`](interfaces/CommitOutput)\>

#### Defined in[[uploadfileswithprogress.defined-in]]

[packages/hub/src/lib/upload-files-with-progress.ts:20](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/upload-files-with-progress.ts#L20)

___

### whoAmI

▸ **whoAmI**(`params`): `Promise`\<[`WhoAmI`](modules#whoami) & \{ `auth`: [`AuthInfo`](interfaces/AuthInfo)  }\>

#### Parameters[[whoami.parameters]]

| Name | Type |
| :------ | :------ |
| `params` | \{ `fetch?`: (`input`: URL \| RequestInfo, `init?`: `RequestInit`) => `Promise`\<`Response`\>(`input`: `string` \| `URL` \| `Request`, `init?`: `RequestInit`) => `Promise`\<`Response`\> ; `hubUrl?`: `string`  } & `CredentialsParams` |

#### Returns[[whoami.returns]]

`Promise`\<[`WhoAmI`](modules#whoami) & \{ `auth`: [`AuthInfo`](interfaces/AuthInfo)  }\>

#### Defined in[[whoami.defined-in]]

[packages/hub/src/lib/who-am-i.ts:61](https://github.com/huggingface/huggingface.js/blob/main/packages/hub/src/lib/who-am-i.ts#L61)


<EditOnGithub source="https://github.com/huggingface/huggingface.js/blob/main/docs/hub/modules.md" />