import{s as yl,n as gl,o as wl}from"../chunks/scheduler.c57aa7ef.js";import{S as Tl,i as Jl,g as o,s as a,r as p,A as $l,h as s,f as l,c as i,j as cl,u as m,x as r,k as bl,y as _l,a as n,v as f,d as u,t as d,w as h}from"../chunks/index.394f8801.js";import{C as M}from"../chunks/CodeBlock.5228ed01.js";import{H as c,E as ql}from"../chunks/EditOnGithub.157fddbf.js";function vl(Fe){let b,Zt,qt,jt,y,Ct,g,Xe="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",Wt,w,Re='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li> <li>quantizing to as low as 2-bit precision with the <a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a> algorithm</li>',zt,T,xe='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',Qt,J,Ee="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",kt,$,Bt,_,Ge='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/v4.49.0/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',Lt,q,Ie="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",Ut,v,Ft,Z,Ae='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/v4.49.0/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',Xt,j,Rt,C,He='Next, you should call the <a href="/docs/peft/v0.15.0/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for training.',xt,W,Et,z,Ve="Now that the quantized model is ready, let’s set up a configuration.",Gt,Q,It,k,Ne='Create a <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',At,B,Ht,L,Ye='Then use the <a href="/docs/peft/v0.15.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/v0.15.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',Vt,U,Nt,F,Pe="You’re all set for training with whichever training method you prefer!",Yt,X,Pt,R,Se='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',St,x,De="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",Dt,E,Kt,G,Ke="QLoRA adds trainable weights to all the linear layers in the transformer architecture. Since the attribute names for these linear layers can vary across architectures, set <code>target_modules</code> to <code>&quot;all-linear&quot;</code> to add LoRA to all the linear layers:",Ot,I,te,A,ee,H,Oe='You can learn more about gptq based <code>[2, 3, 4, 8]</code> bits quantization at <a href="https://github.com/ModelCloud/GPTQModel" rel="nofollow">GPTQModel</a> and the Transformers <a href="https://huggingface.co/docs/transformers/quantization/gptq" rel="nofollow">GPTQ</a> doc. Post-quant training, PEFT can use both <a href="https://github.com/ModelCloud/GPTQModel" rel="nofollow">GPTQModel</a> or <a href="https://github.com/autogptq/autogptq" rel="nofollow">AutoGPTQ</a> libraries, but we recommend GPTQModel because AutoGPTQ will be deprecated in a future release.',le,V,ne,N,ae,Y,tl="Once quantized, you can post-train GPTQ models with PEFT APIs.",ie,P,oe,S,el='Additive Quantization of Language Models (<a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a>) is a Large Language Models compression method. It quantizes multiple weights together and takes advantage of interdependencies between them. AQLM represents groups of 8-16 weights as a sum of multiple vector codes. This allows it to compress models down to as low as 2-bit with considerably low accuracy losses.',se,D,ll='Since the AQLM quantization process is computationally expensive, a use of prequantized models is recommended. A partial list of available models can be found in the official aqlm <a href="https://github.com/Vahe1994/AQLM" rel="nofollow">repository</a>.',re,K,nl="The models support LoRA adapter tuning. To tune the quantized model you’ll need to install the <code>aqlm</code> inference library: <code>pip install aqlm&gt;=1.0.2</code>. Finetuned LoRA adapters shall be saved separately, as merging them with AQLM quantized weights is not possible.",pe,O,me,tt,al='You can refer to the <a href="https://colab.research.google.com/drive/12GTp1FCj5_0SnnNQH18h_2XFh9vS_guX?usp=sharing" rel="nofollow">Google Colab</a> example for an overview of AQLM+LoRA finetuning.',fe,et,ue,lt,il='You can also perform LoRA fine-tuning on EETQ quantized models. <a href="https://github.com/NetEase-FuXi/EETQ" rel="nofollow">EETQ</a> package offers simple and efficient way to perform 8-bit quantization, which is claimed to be faster than the <code>LLM.int8()</code> algorithm. First, make sure that you have a transformers version that is compatible with EETQ (e.g. by installing it from latest pypi or from source).',de,nt,he,at,ol='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/v4.49.0/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',Me,it,ce,ot,sl="and create a <code>LoraConfig</code> and pass it to <code>get_peft_model</code>:",be,st,ye,rt,ge,pt,rl='The models that is quantized using Half-Quadratic Quantization of Large Machine Learning Models (<a href="https://mobiusml.github.io/hqq_blog/" rel="nofollow">HQQ</a>) support LoRA adapter tuning. To tune the quantized model, you’ll need to install the <code>hqq</code> library with: <code>pip install hqq</code>.',we,mt,Te,ft,pl="Or using transformers version that is compatible with HQQ (e.g. by installing it from latest pypi or from source).",Je,ut,$e,dt,_e,ht,ml='PEFT supports models quantized with <a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> (“ao”) for int8 quantization.',qe,Mt,ve,ct,Ze,bt,fl="<li>Use the most recent versions of torchao (&gt;= v0.4.0) and transformers (&gt; 4.42).</li> <li>Only linear layers are currently supported.</li> <li><code>quant_type = &quot;int4_weight_only&quot;</code> is currently not supported.</li> <li><code>NF4</code> is not implemented in transformers as of yet and is thus also not supported.</li> <li>DoRA only works with <code>quant_type = &quot;int8_weight_only&quot;</code> at the moment.</li> <li>There is explicit support for torchao when used with LoRA. However, when torchao quantizes a layer, its class does not change, only the type of the underlying tensor. For this reason, PEFT methods other than LoRA will generally also work with torchao, even if not explicitly supported. Be aware, however, that <strong>merging only works correctly with LoRA and with <code>quant_type = &quot;int8_weight_only&quot;</code></strong>. If you use a different PEFT method or dtype, merging will likely result in an error, and even it doesn’t, the results will still be incorrect.</li>",je,yt,Ce,gt,ul="Besides LoRA, the following PEFT methods also support quantization:",We,wt,dl="<li><strong>VeRA</strong> (supports bitsandbytes quantization)</li> <li><strong>AdaLoRA</strong> (supports both bitsandbytes and GPTQ quantization)</li> <li><strong>(IA)³</strong> (supports bitsandbytes quantization)</li>",ze,Tt,Qe,Jt,hl="If you’re interested in learning more about quantization, the following may be helpful:",ke,$t,Ml='<li>Learn more details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',Be,_t,Le,vt,Ue;return y=new c({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),$=new c({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),v=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),j=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),W=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),Q=new c({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),B=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),U=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),X=new c({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),E=new c({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),I=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),A=new c({props:{title:"GPTQ quantization",local:"gptq-quantization",headingTag:"h2"}}),V=new M({props:{code:"JTIzJTIwZ3B0cW1vZGVsJTIwaW5zdGFsbCUwQXBpcCUyMGluc3RhbGwlMjBncHRxbW9kZWwlMjAtLW5vLWJ1aWxkLWlzb2xhdGlvbg==",highlighted:`<span class="hljs-comment"># gptqmodel install</span>
pip install gptqmodel --no-build-isolation`,wrap:!1}}),N=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEdQVFFDb25maWclMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmZhY2Vib29rJTJGb3B0LTEyNW0lMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFncHRxX2NvbmZpZyUyMCUzRCUyMEdQVFFDb25maWcoYml0cyUzRDQlMkMlMjBncm91cF9zaXplJTNEMTI4JTJDJTIwZGF0YXNldCUzRCUyMndpa2l0ZXh0MiUyMiUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RncHRxX2NvbmZpZyklMEElMEElMjMlMjBzYXZlJTIwcXVhbnRpemVkJTIwbW9kZWwlMEFxdWFudGl6ZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMi4lMkZvcHQtMTI1bS1ncHRxJTIyKSUwQXRva2VuaXplci5zYXZlX3ByZXRyYWluZWQoJTIyLiUyRm9wdC0xMjVtLWdwdHElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, GPTQConfig

model_id = <span class="hljs-string">&quot;facebook/opt-125m&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)

gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, group_size=<span class="hljs-number">128</span>, dataset=<span class="hljs-string">&quot;wikitext2&quot;</span>, tokenizer=tokenizer)

quantized_model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=gptq_config)

<span class="hljs-comment"># save quantized model</span>
quantized_model.save_pretrained(<span class="hljs-string">&quot;./opt-125m-gptq&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;./opt-125m-gptq&quot;</span>)`,wrap:!1}}),P=new c({props:{title:"AQLM quantization",local:"aqlm-quantization",headingTag:"h2"}}),O=new M({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkJsYWNrU2Ftb3JleiUyRk1peHRyYWwtOHg3Yi1BUUxNLTJCaXQtMXgxNi1oZi10ZXN0LWRpc3BhdGNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEEpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;BlackSamorez/Mixtral-8x7b-AQLM-2Bit-1x16-hf-test-dispatch&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>,
)

peft_config = LoraConfig(...)

quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),et=new c({props:{title:"EETQ quantization",local:"eetq-quantization",headingTag:"h2"}}),nt=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwRWV0cUNvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMEVldHFDb25maWcoJTIyaW50OCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> EetqConfig

config = EetqConfig(<span class="hljs-string">&quot;int8&quot;</span>)`,wrap:!1}}),it=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),st=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0Q4JTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0QlNUIlMjJxX3Byb2olMjIlMkMlMjAlMjJrX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlMkMlMjAlMjJvX3Byb2olMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model = get_peft_model(model, config)`,wrap:!1}}),rt=new c({props:{title:"HQQ quantization",local:"hqq-quantization",headingTag:"h2"}}),mt=new M({props:{code:"ZnJvbSUyMGhxcS5lbmdpbmUuaGYlMjBpbXBvcnQlMjBIUVFNb2RlbEZvckNhdXNhbExNJTBBJTBBcXVhbnRpemVkX21vZGVsJTIwJTNEJTIwSFFRTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3F1YW50aXplZChzYXZlX2Rpcl9vcl9oZmh1YiUyQyUyMGRldmljZSUzRCdjdWRhJyklMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoLi4uKSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKHF1YW50aXplZF9tb2RlbCUyQyUyMHBlZnRfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> hqq.engine.hf <span class="hljs-keyword">import</span> HQQModelForCausalLM

quantized_model = HQQModelForCausalLM.from_quantized(save_dir_or_hfhub, device=<span class="hljs-string">&#x27;cuda&#x27;</span>)
peft_config = LoraConfig(...)
quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),ut=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhxcUNvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwSHFxQ29uZmlnKG5iaXRzJTNENCUyQyUyMGdyb3VwX3NpemUlM0Q2NCklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJfb3JfaGZodWIlMkMlMjBkZXZpY2VfbWFwJTNEZGV2aWNlX21hcCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWcpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HqqConfig, AutoModelForCausalLM

quant_config = HqqConfig(nbits=<span class="hljs-number">4</span>, group_size=<span class="hljs-number">64</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(save_dir_or_hfhub, device_map=device_map, quantization_config=quant_config)
peft_config = LoraConfig(...)
quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),dt=new c({props:{title:"torchao (PyTorch Architecture Optimization)",local:"torchao-pytorch-architecture-optimization",headingTag:"h2"}}),Mt=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBUb3JjaEFvQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwVG9yY2hBb0NvbmZpZyhxdWFudF90eXBlJTNEJTIyaW50OF93ZWlnaHRfb25seSUyMiklMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, TorchAoConfig

model_id = ...
quantization_config = TorchAoConfig(quant_type=<span class="hljs-string">&quot;int8_weight_only&quot;</span>)
base_model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=quantization_config)
peft_config = LoraConfig(...)
model = get_peft_model(base_model, peft_config)`,wrap:!1}}),ct=new c({props:{title:"Caveats:",local:"caveats",headingTag:"h3"}}),yt=new c({props:{title:"Other Supported PEFT Methods",local:"other-supported-peft-methods",headingTag:"h2"}}),Tt=new c({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),_t=new ql({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/quantization.md"}}),{c(){b=o("meta"),Zt=a(),qt=o("p"),jt=a(),p(y.$$.fragment),Ct=a(),g=o("p"),g.textContent=Xe,Wt=a(),w=o("ul"),w.innerHTML=Re,zt=a(),T=o("p"),T.innerHTML=xe,Qt=a(),J=o("p"),J.textContent=Ee,kt=a(),p($.$$.fragment),Bt=a(),_=o("p"),_.innerHTML=Ge,Lt=a(),q=o("ul"),q.innerHTML=Ie,Ut=a(),p(v.$$.fragment),Ft=a(),Z=o("p"),Z.innerHTML=Ae,Xt=a(),p(j.$$.fragment),Rt=a(),C=o("p"),C.innerHTML=He,xt=a(),p(W.$$.fragment),Et=a(),z=o("p"),z.textContent=Ve,Gt=a(),p(Q.$$.fragment),It=a(),k=o("p"),k.innerHTML=Ne,At=a(),p(B.$$.fragment),Ht=a(),L=o("p"),L.innerHTML=Ye,Vt=a(),p(U.$$.fragment),Nt=a(),F=o("p"),F.textContent=Pe,Yt=a(),p(X.$$.fragment),Pt=a(),R=o("p"),R.innerHTML=Se,St=a(),x=o("p"),x.innerHTML=De,Dt=a(),p(E.$$.fragment),Kt=a(),G=o("p"),G.innerHTML=Ke,Ot=a(),p(I.$$.fragment),te=a(),p(A.$$.fragment),ee=a(),H=o("p"),H.innerHTML=Oe,le=a(),p(V.$$.fragment),ne=a(),p(N.$$.fragment),ae=a(),Y=o("p"),Y.textContent=tl,ie=a(),p(P.$$.fragment),oe=a(),S=o("p"),S.innerHTML=el,se=a(),D=o("p"),D.innerHTML=ll,re=a(),K=o("p"),K.innerHTML=nl,pe=a(),p(O.$$.fragment),me=a(),tt=o("p"),tt.innerHTML=al,fe=a(),p(et.$$.fragment),ue=a(),lt=o("p"),lt.innerHTML=il,de=a(),p(nt.$$.fragment),he=a(),at=o("p"),at.innerHTML=ol,Me=a(),p(it.$$.fragment),ce=a(),ot=o("p"),ot.innerHTML=sl,be=a(),p(st.$$.fragment),ye=a(),p(rt.$$.fragment),ge=a(),pt=o("p"),pt.innerHTML=rl,we=a(),p(mt.$$.fragment),Te=a(),ft=o("p"),ft.textContent=pl,Je=a(),p(ut.$$.fragment),$e=a(),p(dt.$$.fragment),_e=a(),ht=o("p"),ht.innerHTML=ml,qe=a(),p(Mt.$$.fragment),ve=a(),p(ct.$$.fragment),Ze=a(),bt=o("ul"),bt.innerHTML=fl,je=a(),p(yt.$$.fragment),Ce=a(),gt=o("p"),gt.textContent=ul,We=a(),wt=o("ul"),wt.innerHTML=dl,ze=a(),p(Tt.$$.fragment),Qe=a(),Jt=o("p"),Jt.textContent=hl,ke=a(),$t=o("ul"),$t.innerHTML=Ml,Be=a(),p(_t.$$.fragment),Le=a(),vt=o("p"),this.h()},l(t){const e=$l("svelte-u9bgzb",document.head);b=s(e,"META",{name:!0,content:!0}),e.forEach(l),Zt=i(t),qt=s(t,"P",{}),cl(qt).forEach(l),jt=i(t),m(y.$$.fragment,t),Ct=i(t),g=s(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-famg4s"&&(g.textContent=Xe),Wt=i(t),w=s(t,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-27c91"&&(w.innerHTML=Re),zt=i(t),T=s(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-142xot4"&&(T.innerHTML=xe),Qt=i(t),J=s(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1demhiu"&&(J.textContent=Ee),kt=i(t),m($.$$.fragment,t),Bt=i(t),_=s(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-3xvpza"&&(_.innerHTML=Ge),Lt=i(t),q=s(t,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-hfynw8"&&(q.innerHTML=Ie),Ut=i(t),m(v.$$.fragment,t),Ft=i(t),Z=s(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1ip7t18"&&(Z.innerHTML=Ae),Xt=i(t),m(j.$$.fragment,t),Rt=i(t),C=s(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-9dvv67"&&(C.innerHTML=He),xt=i(t),m(W.$$.fragment,t),Et=i(t),z=s(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-11mx7fc"&&(z.textContent=Ve),Gt=i(t),m(Q.$$.fragment,t),It=i(t),k=s(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-173xial"&&(k.innerHTML=Ne),At=i(t),m(B.$$.fragment,t),Ht=i(t),L=s(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-x4biio"&&(L.innerHTML=Ye),Vt=i(t),m(U.$$.fragment,t),Nt=i(t),F=s(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-xd402n"&&(F.textContent=Pe),Yt=i(t),m(X.$$.fragment,t),Pt=i(t),R=s(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-f32n60"&&(R.innerHTML=Se),St=i(t),x=s(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-7f0aai"&&(x.innerHTML=De),Dt=i(t),m(E.$$.fragment,t),Kt=i(t),G=s(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1c7jiea"&&(G.innerHTML=Ke),Ot=i(t),m(I.$$.fragment,t),te=i(t),m(A.$$.fragment,t),ee=i(t),H=s(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-waooev"&&(H.innerHTML=Oe),le=i(t),m(V.$$.fragment,t),ne=i(t),m(N.$$.fragment,t),ae=i(t),Y=s(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-lqq230"&&(Y.textContent=tl),ie=i(t),m(P.$$.fragment,t),oe=i(t),S=s(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-h7ytse"&&(S.innerHTML=el),se=i(t),D=s(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-120mr43"&&(D.innerHTML=ll),re=i(t),K=s(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-wlm3ol"&&(K.innerHTML=nl),pe=i(t),m(O.$$.fragment,t),me=i(t),tt=s(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1f1bzer"&&(tt.innerHTML=al),fe=i(t),m(et.$$.fragment,t),ue=i(t),lt=s(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-16tz5mo"&&(lt.innerHTML=il),de=i(t),m(nt.$$.fragment,t),he=i(t),at=s(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1ip7t18"&&(at.innerHTML=ol),Me=i(t),m(it.$$.fragment,t),ce=i(t),ot=s(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1wgonl8"&&(ot.innerHTML=sl),be=i(t),m(st.$$.fragment,t),ye=i(t),m(rt.$$.fragment,t),ge=i(t),pt=s(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-17kgu1v"&&(pt.innerHTML=rl),we=i(t),m(mt.$$.fragment,t),Te=i(t),ft=s(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-p9acs7"&&(ft.textContent=pl),Je=i(t),m(ut.$$.fragment,t),$e=i(t),m(dt.$$.fragment,t),_e=i(t),ht=s(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-gynv46"&&(ht.innerHTML=ml),qe=i(t),m(Mt.$$.fragment,t),ve=i(t),m(ct.$$.fragment,t),Ze=i(t),bt=s(t,"UL",{"data-svelte-h":!0}),r(bt)!=="svelte-4si0iy"&&(bt.innerHTML=fl),je=i(t),m(yt.$$.fragment,t),Ce=i(t),gt=s(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-14evo3v"&&(gt.textContent=ul),We=i(t),wt=s(t,"UL",{"data-svelte-h":!0}),r(wt)!=="svelte-ro48c4"&&(wt.innerHTML=dl),ze=i(t),m(Tt.$$.fragment,t),Qe=i(t),Jt=s(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-agdyn7"&&(Jt.textContent=hl),ke=i(t),$t=s(t,"UL",{"data-svelte-h":!0}),r($t)!=="svelte-10zqaf7"&&($t.innerHTML=Ml),Be=i(t),m(_t.$$.fragment,t),Le=i(t),vt=s(t,"P",{}),cl(vt).forEach(l),this.h()},h(){bl(b,"name","hf:doc:metadata"),bl(b,"content",Zl)},m(t,e){_l(document.head,b),n(t,Zt,e),n(t,qt,e),n(t,jt,e),f(y,t,e),n(t,Ct,e),n(t,g,e),n(t,Wt,e),n(t,w,e),n(t,zt,e),n(t,T,e),n(t,Qt,e),n(t,J,e),n(t,kt,e),f($,t,e),n(t,Bt,e),n(t,_,e),n(t,Lt,e),n(t,q,e),n(t,Ut,e),f(v,t,e),n(t,Ft,e),n(t,Z,e),n(t,Xt,e),f(j,t,e),n(t,Rt,e),n(t,C,e),n(t,xt,e),f(W,t,e),n(t,Et,e),n(t,z,e),n(t,Gt,e),f(Q,t,e),n(t,It,e),n(t,k,e),n(t,At,e),f(B,t,e),n(t,Ht,e),n(t,L,e),n(t,Vt,e),f(U,t,e),n(t,Nt,e),n(t,F,e),n(t,Yt,e),f(X,t,e),n(t,Pt,e),n(t,R,e),n(t,St,e),n(t,x,e),n(t,Dt,e),f(E,t,e),n(t,Kt,e),n(t,G,e),n(t,Ot,e),f(I,t,e),n(t,te,e),f(A,t,e),n(t,ee,e),n(t,H,e),n(t,le,e),f(V,t,e),n(t,ne,e),f(N,t,e),n(t,ae,e),n(t,Y,e),n(t,ie,e),f(P,t,e),n(t,oe,e),n(t,S,e),n(t,se,e),n(t,D,e),n(t,re,e),n(t,K,e),n(t,pe,e),f(O,t,e),n(t,me,e),n(t,tt,e),n(t,fe,e),f(et,t,e),n(t,ue,e),n(t,lt,e),n(t,de,e),f(nt,t,e),n(t,he,e),n(t,at,e),n(t,Me,e),f(it,t,e),n(t,ce,e),n(t,ot,e),n(t,be,e),f(st,t,e),n(t,ye,e),f(rt,t,e),n(t,ge,e),n(t,pt,e),n(t,we,e),f(mt,t,e),n(t,Te,e),n(t,ft,e),n(t,Je,e),f(ut,t,e),n(t,$e,e),f(dt,t,e),n(t,_e,e),n(t,ht,e),n(t,qe,e),f(Mt,t,e),n(t,ve,e),f(ct,t,e),n(t,Ze,e),n(t,bt,e),n(t,je,e),f(yt,t,e),n(t,Ce,e),n(t,gt,e),n(t,We,e),n(t,wt,e),n(t,ze,e),f(Tt,t,e),n(t,Qe,e),n(t,Jt,e),n(t,ke,e),n(t,$t,e),n(t,Be,e),f(_t,t,e),n(t,Le,e),n(t,vt,e),Ue=!0},p:gl,i(t){Ue||(u(y.$$.fragment,t),u($.$$.fragment,t),u(v.$$.fragment,t),u(j.$$.fragment,t),u(W.$$.fragment,t),u(Q.$$.fragment,t),u(B.$$.fragment,t),u(U.$$.fragment,t),u(X.$$.fragment,t),u(E.$$.fragment,t),u(I.$$.fragment,t),u(A.$$.fragment,t),u(V.$$.fragment,t),u(N.$$.fragment,t),u(P.$$.fragment,t),u(O.$$.fragment,t),u(et.$$.fragment,t),u(nt.$$.fragment,t),u(it.$$.fragment,t),u(st.$$.fragment,t),u(rt.$$.fragment,t),u(mt.$$.fragment,t),u(ut.$$.fragment,t),u(dt.$$.fragment,t),u(Mt.$$.fragment,t),u(ct.$$.fragment,t),u(yt.$$.fragment,t),u(Tt.$$.fragment,t),u(_t.$$.fragment,t),Ue=!0)},o(t){d(y.$$.fragment,t),d($.$$.fragment,t),d(v.$$.fragment,t),d(j.$$.fragment,t),d(W.$$.fragment,t),d(Q.$$.fragment,t),d(B.$$.fragment,t),d(U.$$.fragment,t),d(X.$$.fragment,t),d(E.$$.fragment,t),d(I.$$.fragment,t),d(A.$$.fragment,t),d(V.$$.fragment,t),d(N.$$.fragment,t),d(P.$$.fragment,t),d(O.$$.fragment,t),d(et.$$.fragment,t),d(nt.$$.fragment,t),d(it.$$.fragment,t),d(st.$$.fragment,t),d(rt.$$.fragment,t),d(mt.$$.fragment,t),d(ut.$$.fragment,t),d(dt.$$.fragment,t),d(Mt.$$.fragment,t),d(ct.$$.fragment,t),d(yt.$$.fragment,t),d(Tt.$$.fragment,t),d(_t.$$.fragment,t),Ue=!1},d(t){t&&(l(Zt),l(qt),l(jt),l(Ct),l(g),l(Wt),l(w),l(zt),l(T),l(Qt),l(J),l(kt),l(Bt),l(_),l(Lt),l(q),l(Ut),l(Ft),l(Z),l(Xt),l(Rt),l(C),l(xt),l(Et),l(z),l(Gt),l(It),l(k),l(At),l(Ht),l(L),l(Vt),l(Nt),l(F),l(Yt),l(Pt),l(R),l(St),l(x),l(Dt),l(Kt),l(G),l(Ot),l(te),l(ee),l(H),l(le),l(ne),l(ae),l(Y),l(ie),l(oe),l(S),l(se),l(D),l(re),l(K),l(pe),l(me),l(tt),l(fe),l(ue),l(lt),l(de),l(he),l(at),l(Me),l(ce),l(ot),l(be),l(ye),l(ge),l(pt),l(we),l(Te),l(ft),l(Je),l($e),l(_e),l(ht),l(qe),l(ve),l(Ze),l(bt),l(je),l(Ce),l(gt),l(We),l(wt),l(ze),l(Qe),l(Jt),l(ke),l($t),l(Be),l(Le),l(vt)),l(b),h(y,t),h($,t),h(v,t),h(j,t),h(W,t),h(Q,t),h(B,t),h(U,t),h(X,t),h(E,t),h(I,t),h(A,t),h(V,t),h(N,t),h(P,t),h(O,t),h(et,t),h(nt,t),h(it,t),h(st,t),h(rt,t),h(mt,t),h(ut,t),h(dt,t),h(Mt,t),h(ct,t),h(yt,t),h(Tt,t),h(_t,t)}}}const Zl='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"GPTQ quantization","local":"gptq-quantization","sections":[],"depth":2},{"title":"AQLM quantization","local":"aqlm-quantization","sections":[],"depth":2},{"title":"EETQ quantization","local":"eetq-quantization","sections":[],"depth":2},{"title":"HQQ quantization","local":"hqq-quantization","sections":[],"depth":2},{"title":"torchao (PyTorch Architecture Optimization)","local":"torchao-pytorch-architecture-optimization","sections":[{"title":"Caveats:","local":"caveats","sections":[],"depth":3}],"depth":2},{"title":"Other Supported PEFT Methods","local":"other-supported-peft-methods","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function jl(Fe){return wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kl extends Tl{constructor(b){super(),Jl(this,b,jl,vl,yl,{})}}export{kl as component};
