import{s as Ge,n as Ie,o as Be}from"../chunks/scheduler.4430a55f.js";import{S as Ce,i as ve,e as p,s as a,c as o,h as We,a as c,d as t,b as n,f as ke,g as r,j as i,k as nl,l as ge,m as s,n as M,t as d,o as m,p as J}from"../chunks/index.250b5259.js";import{C as w}from"../chunks/CodeBlock.3e25c118.js";import{H as Ol,E as Ee}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.39f03929.js";function $e(le){let u,il,pl,ol,b,rl,h,ee='在分布式设置中，您可以使用 🤗 <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> 或 <a href="https://pytorch.org/tutorials/beginner/dist_overview.html" rel="nofollow">PyTorch Distributed</a> 在多个 GPU 上运行推理，这对于并行生成多个提示非常有用。',Ml,U,te="本指南将向您展示如何使用 🤗 Accelerate 和 PyTorch Distributed 进行分布式推理。",dl,Z,ml,_,se='🤗 <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> 是一个旨在简化在分布式设置中训练或运行推理的库。它简化了设置分布式环境的过程，让您可以专注于您的 PyTorch 代码。',Jl,k,ae="首先，创建一个 Python 文件并初始化一个 <code>accelerate.PartialState</code> 来创建分布式环境；您的设置会自动检测，因此您无需明确定义 <code>rank</code> 或 <code>world_size</code>。将 <code>DiffusionPipeline</code> 移动到 <code>distributed_state.device</code> 以为每个进程分配一个 GPU。",wl,G,ne="现在使用 <code>split_between_processes</code> 实用程序作为上下文管理器，自动在进程数之间分发提示。",ul,I,yl,B,pe="使用 <code>--num_processes</code> 参数指定要使用的 GPU 数量，并调用 <code>accelerate launch</code> 来运行脚本：",fl,C,jl,y,ce='<p>参考这个最小示例 <a href="https://gist.github.com/sayakpaul/cfaebd221820d7b43fae638b4dfa01ba" rel="nofollow">脚本</a> 以在多个 GPU 上运行推理。要了解更多信息，请查看 <a href="https://huggingface.co/docs/accelerate/en/usage_guides/distributed_inference#distributed-inference-with-accelerate" rel="nofollow">使用 🤗 Accelerate 进行分布式推理</a> 指南。</p>',Tl,v,bl,W,ie=`PyTorch 支持 <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow"><code>DistributedDataParallel</code></a>，它启用了数据
并行性。`,hl,g,oe="首先，创建一个 Python 文件并导入 <code>torch.distributed</code> 和 <code>torch.multiprocessing</code> 来设置分布式进程组，并为每个 GPU 上的推理生成进程。您还应该初始化一个 <code>DiffusionPipeline</code>：",Ul,E,Zl,$,re='您需要创建一个函数来运行推理；<a href="https://pytorch.org/docs/stable/distributed.html?highlight=init_process_group#torch.distributed.init_process_group" rel="nofollow"><code>init_process_group</code></a> 处理创建一个分布式环境，指定要使用的后端类型、当前进程的 <code>rank</code> 以及参与进程的数量 <code>world_size</code>。如果您在 2 个 GPU 上并行运行推理，那么 <code>world_size</code> 就是 2。',_l,R,Me="将 <code>DiffusionPipeline</code> 移动到 <code>rank</code>，并使用 <code>get_rank</code> 为每个进程分配一个 GPU，其中每个进程处理不同的提示：",kl,X,Gl,N,de='要运行分布式推理，调用 <a href="https://pytorch.org/docs/stable/multiprocessing.html#torch.multiprocessing.spawn" rel="nofollow"><code>mp.spawn</code></a> 在 <code>world_size</code> 定义的 GPU 数量上运行 <code>run_inference</code> 函数：',Il,V,Bl,H,me="完成推理脚本后，使用 <code>--nproc_per_node</code> 参数指定要使用的 GPU 数量，并调用 <code>torchrun</code> 来运行脚本：",Cl,A,vl,f,Je='<p>您可以在 <code>DiffusionPipeline</code> 中使用 <code>device_map</code> 将其模型级组件分布在多个设备上。请参考 <a href="../tutorials/inference_with_big_models#device-placement">设备放置</a> 指南了解更多信息。</p>',Wl,x,gl,z,we='现代扩散系统，如 <a href="../api/pipelines/flux">Flux</a>，非常大且包含多个模型。例如，<a href="https://hf.co/black-forest-labs/FLUX.1-dev" rel="nofollow">Flux.1-Dev</a> 由两个文本编码器 - <a href="https://hf.co/google/t5-v1_1-xxl" rel="nofollow">T5-XXL</a> 和 <a href="https://hf.co/openai/clip-vit-large-patch14" rel="nofollow">CLIP-L</a> - 一个 <a href="../api/models/flux_transformer">扩散变换器</a>，以及一个 <a href="../api/models/autoencoderkl">VAE</a> 组成。对于如此大的模型，在消费级 GPU 上运行推理可能具有挑战性。',El,Q,ue="模型分片是一种技术，当模型无法容纳在单个 GPU 上时，将模型分布在多个 GPU 上。下面的示例假设有两个 16GB GPU 可用于推理。",$l,F,ye="开始使用文本编码器计算文本嵌入。通过设置 <code>device_map=&quot;balanced&quot;</code> 将文本编码器保持在两个GPU上。<code>balanced</code> 策略将模型均匀分布在所有可用GPU上。使用 <code>max_memory</code> 参数为每个GPU上的每个文本编码器分配最大内存量。",Rl,j,fe="<p><strong>仅</strong> 在此步骤加载文本编码器！扩散变换器和VAE在后续步骤中加载以节省内存。</p>",Xl,Y,Nl,S,je="一旦文本嵌入计算完成，从GPU中移除它们以为扩散变换器腾出空间。",Vl,L,Hl,P,Te='接下来加载扩散变换器，它有125亿参数。这次，设置 <code>device_map=&quot;auto&quot;</code> 以自动将模型分布在两个16GB GPU上。<code>auto</code> 策略由 <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> 支持，并作为 <a href="https://hf.co/docs/accelerate/concept_guides/big_model_inference" rel="nofollow">大模型推理</a> 功能的一部分可用。它首先将模型分布在最快的设备（GPU）上，然后在需要时移动到较慢的设备如CPU和硬盘。将模型参数存储在较慢设备上的权衡是推理延迟较慢。',Al,q,xl,T,be="<p>在任何时候，您可以尝试 <code>print(pipeline.hf_device_map)</code> 来查看各种模型如何在设备上分布。这对于跟踪模型的设备放置很有用。您也可以尝试 <code>print(transformer.hf_device_map)</code> 来查看变换器模型如何在设备上分片。</p>",zl,D,he="将变换器模型添加到管道中以进行去噪，但将其他模型级组件如文本编码器和VAE设置为 <code>None</code>，因为您还不需要它们。",Ql,K,Fl,O,Ue="从内存中移除管道和变换器，因为它们不再需要。",Yl,ll,Sl,el,Ze="最后，使用变分自编码器（VAE）将潜在表示解码为图像。VAE通常足够小，可以在单个GPU上加载。",Ll,tl,Pl,sl,_e="通过选择性加载和卸载在特定阶段所需的模型，并将最大模型分片到多个GPU上，可以在消费级GPU上运行大型模型的推理。",ql,al,Dl,cl,Kl;return b=new Ol({props:{title:"分布式推理",local:"分布式推理",headingTag:"h1"}}),Z=new Ol({props:{title:"🤗 Accelerate",local:"-accelerate",headingTag:"h2"}}),I=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBZGlzdHJpYnV0ZWRfc3RhdGUlMjAlM0QlMjBQYXJ0aWFsU3RhdGUoKSUwQXBpcGVsaW5lLnRvKGRpc3RyaWJ1dGVkX3N0YXRlLmRldmljZSklMEElMEF3aXRoJTIwZGlzdHJpYnV0ZWRfc3RhdGUuc3BsaXRfYmV0d2Vlbl9wcm9jZXNzZXMoJTVCJTIyYSUyMGRvZyUyMiUyQyUyMCUyMmElMjBjYXQlMjIlNUQpJTIwYXMlMjBwcm9tcHQlM0ElMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEElMjAlMjAlMjAlMjByZXN1bHQuc2F2ZShmJTIycmVzdWx0XyU3QmRpc3RyaWJ1dGVkX3N0YXRlLnByb2Nlc3NfaW5kZXglN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
distributed_state = PartialState()
pipeline.to(distributed_state.device)

<span class="hljs-keyword">with</span> distributed_state.split_between_processes([<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>]) <span class="hljs-keyword">as</span> prompt:
    result = pipeline(prompt).images[<span class="hljs-number">0</span>]
    result.save(<span class="hljs-string">f&quot;result_<span class="hljs-subst">{distributed_state.process_index}</span>.png&quot;</span>)`,wrap:!1}}),C=new w({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHJ1bl9kaXN0cmlidXRlZC5weSUyMC0tbnVtX3Byb2Nlc3NlcyUzRDI=",highlighted:"accelerate launch run_distributed.py --num_processes=2",wrap:!1}}),v=new Ol({props:{title:"PyTorch Distributed",local:"pytorch-distributed",headingTag:"h2"}}),E=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5kaXN0cmlidXRlZCUyMGFzJTIwZGlzdCUwQWltcG9ydCUyMHRvcmNoLm11bHRpcHJvY2Vzc2luZyUyMGFzJTIwbXAlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzZCUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">import</span> torch.multiprocessing <span class="hljs-keyword">as</span> mp

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

sd = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),X=new w({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShyYW5rJTJDJTIwd29ybGRfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBkaXN0LmluaXRfcHJvY2Vzc19ncm91cCglMjJuY2NsJTIyJTJDJTIwcmFuayUzRHJhbmslMkMlMjB3b3JsZF9zaXplJTNEd29ybGRfc2l6ZSklMEElMEElMjAlMjAlMjAlMjBzZC50byhyYW5rKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guZGlzdHJpYnV0ZWQuZ2V0X3JhbmsoKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlMjJhJTIwZG9nJTIyJTBBJTIwJTIwJTIwJTIwZWxpZiUyMHRvcmNoLmRpc3RyaWJ1dGVkLmdldF9yYW5rKCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMiUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2QocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2Uuc2F2ZShmJTIyLiUyRiU3QidfJy5qb2luKHByb21wdCklN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">rank, world_size</span>):
    dist.init_process_group(<span class="hljs-string">&quot;nccl&quot;</span>, rank=rank, world_size=world_size)

    sd.to(rank)

    <span class="hljs-keyword">if</span> torch.distributed.get_rank() == <span class="hljs-number">0</span>:
        prompt = <span class="hljs-string">&quot;a dog&quot;</span>
    <span class="hljs-keyword">elif</span> torch.distributed.get_rank() == <span class="hljs-number">1</span>:
        prompt = <span class="hljs-string">&quot;a cat&quot;</span>

    image = sd(prompt).images[<span class="hljs-number">0</span>]
    image.save(<span class="hljs-string">f&quot;./<span class="hljs-subst">{<span class="hljs-string">&#x27;_&#x27;</span>.join(prompt)}</span>.png&quot;</span>)`,wrap:!1}}),V=new w({props:{code:"ZGVmJTIwbWFpbigpJTNBJTBBJTIwJTIwJTIwJTIwd29ybGRfc2l6ZSUyMCUzRCUyMDIlMEElMjAlMjAlMjAlMjBtcC5zcGF3bihydW5faW5mZXJlbmNlJTJDJTIwYXJncyUzRCh3b3JsZF9zaXplJTJDKSUyQyUyMG5wcm9jcyUzRHdvcmxkX3NpemUlMkMlMjBqb2luJTNEVHJ1ZSklMEElMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBtYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    world_size = <span class="hljs-number">2</span>
    mp.spawn(run_inference, args=(world_size,), nprocs=world_size, join=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),A=new w({props:{code:"dG9yY2hydW4lMjBydW5fZGlzdHJpYnV0ZWQucHklMjAtLW5wcm9jX3Blcl9ub2RlJTNEMg==",highlighted:"torchrun run_distributed.py --nproc_per_node=2",wrap:!1}}),x=new Ol({props:{title:"模型分片",local:"模型分片",headingTag:"h2"}}),Y=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwZG9nJTIwd2l0aCUyMGNhdC1saWtlJTIwbG9vayUyMiUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRmx1eFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjB2YWUlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X21lbW9yeSUzRCU3QjAlM0ElMjAlMjIxNkdCJTIyJTJDJTIwMSUzQSUyMCUyMjE2R0IlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJFbmNvZGluZyUyMHByb21wdHMuJTIyKSUwQSUyMCUyMCUyMCUyMHByb21wdF9lbWJlZHMlMkMlMjBwb29sZWRfcHJvbXB0X2VtYmVkcyUyQyUyMHRleHRfaWRzJTIwJTNEJTIwcGlwZWxpbmUuZW5jb2RlX3Byb21wdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMjBwcm9tcHRfMiUzRE5vbmUlMkMlMjBtYXhfc2VxdWVuY2VfbGVuZ3RoJTNENTEyJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline
<span class="hljs-keyword">import</span> torch

prompt = <span class="hljs-string">&quot;a photo of a dog with cat-like look&quot;</span>

pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=<span class="hljs-literal">None</span>,
    vae=<span class="hljs-literal">None</span>,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
    max_memory={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;16GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;16GB&quot;</span>},
    torch_dtype=torch.bfloat16
)
<span class="hljs-keyword">with</span> torch.no_grad():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Encoding prompts.&quot;</span>)
    prompt_embeds, pooled_prompt_embeds, text_ids = pipeline.encode_prompt(
        prompt=prompt, prompt_2=<span class="hljs-literal">None</span>, max_sequence_length=<span class="hljs-number">512</span>
    )`,wrap:!1}}),L=new w({props:{code:"aW1wb3J0JTIwZ2MlMjAlMEElMEFkZWYlMjBmbHVzaCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2MuY29sbGVjdCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5lbXB0eV9jYWNoZSgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5yZXNldF9tYXhfbWVtb3J5X2FsbG9jYXRlZCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5yZXNldF9wZWFrX21lbW9yeV9zdGF0cygpJTBBJTBBZGVsJTIwcGlwZWxpbmUudGV4dF9lbmNvZGVyJTBBZGVsJTIwcGlwZWxpbmUudGV4dF9lbmNvZGVyXzIlMEFkZWwlMjBwaXBlbGluZS50b2tlbml6ZXIlMEFkZWwlMjBwaXBlbGluZS50b2tlbml6ZXJfMiUwQWRlbCUyMHBpcGVsaW5lJTBBJTBBZmx1c2goKQ==",highlighted:`<span class="hljs-keyword">import</span> gc 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
    gc.collect()
    torch.cuda.empty_cache()
    torch.cuda.reset_max_memory_allocated()
    torch.cuda.reset_peak_memory_stats()

<span class="hljs-keyword">del</span> pipeline.text_encoder
<span class="hljs-keyword">del</span> pipeline.text_encoder_2
<span class="hljs-keyword">del</span> pipeline.tokenizer
<span class="hljs-keyword">del</span> pipeline.tokenizer_2
<span class="hljs-keyword">del</span> pipeline

flush()`,wrap:!1}}),q=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTIwJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">import</span> torch 

transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, 
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16
)`,wrap:!1}}),K=new w({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXJfMiUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyXzIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdmFlJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQXByaW50KCUyMlJ1bm5pbmclMjBkZW5vaXNpbmcuJTIyKSUwQWhlaWdodCUyQyUyMHdpZHRoJTIwJTNEJTIwNzY4JTJDJTIwMTM2MCUwQWxhdGVudHMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMEFwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUwQXBvb2xlZF9wcm9tcHRfZW1iZWRzJTNEcG9vbGVkX3Byb21wdF9lbWJlZHMlMkMlMEFudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEFndWlkYW5jZV9zY2FsZSUzRDMuNSUyQyUwQWhlaWdodCUzRGhlaWdodCUyQyUwQXdpZHRoJTNEd2lkdGglMkMlMEFvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2Vz",highlighted:`pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    text_encoder=<span class="hljs-literal">None</span>,
    text_encoder_2=<span class="hljs-literal">None</span>,
    tokenizer=<span class="hljs-literal">None</span>,
    tokenizer_2=<span class="hljs-literal">None</span>,
    vae=<span class="hljs-literal">None</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Running denoising.&quot;</span>)
height, width = <span class="hljs-number">768</span>, <span class="hljs-number">1360</span>
latents = pipeline(
   
     
prompt_embeds=prompt_embeds,
pooled_prompt_embeds=pooled_prompt_embeds,
num_inference_steps=<span class="hljs-number">50</span>,
guidance_scale=<span class="hljs-number">3.5</span>,
height=height,
width=width,
output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images`,wrap:!1}}),ll=new w({props:{code:"ZGVsJTIwcGlwZWxpbmUudHJhbnNmb3JtZXIlMEFkZWwlMjBwaXBlbGluZSUwQSUwQWZsdXNoKCk=",highlighted:`<span class="hljs-keyword">del</span> pipeline.transformer
<span class="hljs-keyword">del</span> pipeline

flush()`,wrap:!1}}),tl=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0wlMEFmcm9tJTIwZGlmZnVzZXJzLmltYWdlX3Byb2Nlc3NvciUyMGltcG9ydCUyMFZhZUltYWdlUHJvY2Vzc29yJTBBaW1wb3J0JTIwdG9yY2glMjAlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZChja3B0X2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydmFlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEF2YWVfc2NhbGVfZmFjdG9yJTIwJTNEJTIwMiUyMCoqJTIwKGxlbih2YWUuY29uZmlnLmJsb2NrX291dF9jaGFubmVscyklMjAtJTIwMSklMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBWYWVJbWFnZVByb2Nlc3Nvcih2YWVfc2NhbGVfZmFjdG9yJTNEdmFlX3NjYWxlX2ZhY3RvciklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJUU4JUJGJTkwJUU4JUExJThDJUU4JUE3JUEzJUU3JUEwJTgxJUU0JUI4JUFEJUUzJTgwJTgyJTIyKSUwQSUyMCUyMCUyMCUyMGxhdGVudHMlMjAlM0QlMjBGbHV4UGlwZWxpbmUuX3VucGFja19sYXRlbnRzKGxhdGVudHMlMkMlMjBoZWlnaHQlMkMlMjB3aWR0aCUyQyUyMHZhZV9zY2FsZV9mYWN0b3IpJTBBJTIwJTIwJTIwJTIwbGF0ZW50cyUyMCUzRCUyMChsYXRlbnRzJTIwJTJGJTIwdmFlLmNvbmZpZy5zY2FsaW5nX2ZhY3RvciklMjAlMkIlMjB2YWUuY29uZmlnLnNoaWZ0X2ZhY3RvciUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwdmFlLmRlY29kZShsYXRlbnRzJTJDJTIwcmV0dXJuX2RpY3QlM0RGYWxzZSklNUIwJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdHByb2Nlc3MoaW1hZ2UlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMnBpbCUyMiklMEElMjAlMjAlMjAlMjBpbWFnZSU1QjAlNUQuc2F2ZSglMjJzcGxpdF90cmFuc2Zvcm1lci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.image_processor <span class="hljs-keyword">import</span> VaeImageProcessor
<span class="hljs-keyword">import</span> torch 

vae = AutoencoderKL.from_pretrained(ckpt_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
vae_scale_factor = <span class="hljs-number">2</span> ** (<span class="hljs-built_in">len</span>(vae.config.block_out_channels) - <span class="hljs-number">1</span>)
image_processor = VaeImageProcessor(vae_scale_factor=vae_scale_factor)

<span class="hljs-keyword">with</span> torch.no_grad():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;运行解码中。&quot;</span>)
    latents = FluxPipeline._unpack_latents(latents, height, width, vae_scale_factor)
    latents = (latents / vae.config.scaling_factor) + vae.config.shift_factor

    image = vae.decode(latents, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
    image = image_processor.postprocess(image, output_type=<span class="hljs-string">&quot;pil&quot;</span>)
    image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;split_transformer.png&quot;</span>)`,wrap:!1}}),al=new Ee({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/zh/training/distributed_inference.md"}}),{c(){u=p("meta"),il=a(),pl=p("p"),ol=a(),o(b.$$.fragment),rl=a(),h=p("p"),h.innerHTML=ee,Ml=a(),U=p("p"),U.textContent=te,dl=a(),o(Z.$$.fragment),ml=a(),_=p("p"),_.innerHTML=se,Jl=a(),k=p("p"),k.innerHTML=ae,wl=a(),G=p("p"),G.innerHTML=ne,ul=a(),o(I.$$.fragment),yl=a(),B=p("p"),B.innerHTML=pe,fl=a(),o(C.$$.fragment),jl=a(),y=p("blockquote"),y.innerHTML=ce,Tl=a(),o(v.$$.fragment),bl=a(),W=p("p"),W.innerHTML=ie,hl=a(),g=p("p"),g.innerHTML=oe,Ul=a(),o(E.$$.fragment),Zl=a(),$=p("p"),$.innerHTML=re,_l=a(),R=p("p"),R.innerHTML=Me,kl=a(),o(X.$$.fragment),Gl=a(),N=p("p"),N.innerHTML=de,Il=a(),o(V.$$.fragment),Bl=a(),H=p("p"),H.innerHTML=me,Cl=a(),o(A.$$.fragment),vl=a(),f=p("blockquote"),f.innerHTML=Je,Wl=a(),o(x.$$.fragment),gl=a(),z=p("p"),z.innerHTML=we,El=a(),Q=p("p"),Q.textContent=ue,$l=a(),F=p("p"),F.innerHTML=ye,Rl=a(),j=p("blockquote"),j.innerHTML=fe,Xl=a(),o(Y.$$.fragment),Nl=a(),S=p("p"),S.textContent=je,Vl=a(),o(L.$$.fragment),Hl=a(),P=p("p"),P.innerHTML=Te,Al=a(),o(q.$$.fragment),xl=a(),T=p("blockquote"),T.innerHTML=be,zl=a(),D=p("p"),D.innerHTML=he,Ql=a(),o(K.$$.fragment),Fl=a(),O=p("p"),O.textContent=Ue,Yl=a(),o(ll.$$.fragment),Sl=a(),el=p("p"),el.textContent=Ze,Ll=a(),o(tl.$$.fragment),Pl=a(),sl=p("p"),sl.textContent=_e,ql=a(),o(al.$$.fragment),Dl=a(),cl=p("p"),this.h()},l(l){const e=We("svelte-u9bgzb",document.head);u=c(e,"META",{name:!0,content:!0}),e.forEach(t),il=n(l),pl=c(l,"P",{}),ke(pl).forEach(t),ol=n(l),r(b.$$.fragment,l),rl=n(l),h=c(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-164t5yx"&&(h.innerHTML=ee),Ml=n(l),U=c(l,"P",{"data-svelte-h":!0}),i(U)!=="svelte-qajcxl"&&(U.textContent=te),dl=n(l),r(Z.$$.fragment,l),ml=n(l),_=c(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-10vyc10"&&(_.innerHTML=se),Jl=n(l),k=c(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-k495sb"&&(k.innerHTML=ae),wl=n(l),G=c(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1224dwq"&&(G.innerHTML=ne),ul=n(l),r(I.$$.fragment,l),yl=n(l),B=c(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1eq5z11"&&(B.innerHTML=pe),fl=n(l),r(C.$$.fragment,l),jl=n(l),y=c(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(y)!=="svelte-87d30k"&&(y.innerHTML=ce),Tl=n(l),r(v.$$.fragment,l),bl=n(l),W=c(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-7gn49b"&&(W.innerHTML=ie),hl=n(l),g=c(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1vhpcpe"&&(g.innerHTML=oe),Ul=n(l),r(E.$$.fragment,l),Zl=n(l),$=c(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-109hrfe"&&($.innerHTML=re),_l=n(l),R=c(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1qcsr3i"&&(R.innerHTML=Me),kl=n(l),r(X.$$.fragment,l),Gl=n(l),N=c(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1yf0k86"&&(N.innerHTML=de),Il=n(l),r(V.$$.fragment,l),Bl=n(l),H=c(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1ebzc0p"&&(H.innerHTML=me),Cl=n(l),r(A.$$.fragment,l),vl=n(l),f=c(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(f)!=="svelte-zkfe1n"&&(f.innerHTML=Je),Wl=n(l),r(x.$$.fragment,l),gl=n(l),z=c(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-yu6o1n"&&(z.innerHTML=we),El=n(l),Q=c(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1wtcutz"&&(Q.textContent=ue),$l=n(l),F=c(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-vjsvbo"&&(F.innerHTML=ye),Rl=n(l),j=c(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(j)!=="svelte-zyi0qz"&&(j.innerHTML=fe),Xl=n(l),r(Y.$$.fragment,l),Nl=n(l),S=c(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-101ikwk"&&(S.textContent=je),Vl=n(l),r(L.$$.fragment,l),Hl=n(l),P=c(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-i97tc3"&&(P.innerHTML=Te),Al=n(l),r(q.$$.fragment,l),xl=n(l),T=c(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(T)!=="svelte-1l0lzn4"&&(T.innerHTML=be),zl=n(l),D=c(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1lgsyuc"&&(D.innerHTML=he),Ql=n(l),r(K.$$.fragment,l),Fl=n(l),O=c(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-x0nor"&&(O.textContent=Ue),Yl=n(l),r(ll.$$.fragment,l),Sl=n(l),el=c(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-1v7ewyt"&&(el.textContent=Ze),Ll=n(l),r(tl.$$.fragment,l),Pl=n(l),sl=c(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-19rooo6"&&(sl.textContent=_e),ql=n(l),r(al.$$.fragment,l),Dl=n(l),cl=c(l,"P",{}),ke(cl).forEach(t),this.h()},h(){nl(u,"name","hf:doc:metadata"),nl(u,"content",Re),nl(y,"class","tip"),nl(f,"class","tip"),nl(j,"class","tip"),nl(T,"class","tip")},m(l,e){ge(document.head,u),s(l,il,e),s(l,pl,e),s(l,ol,e),M(b,l,e),s(l,rl,e),s(l,h,e),s(l,Ml,e),s(l,U,e),s(l,dl,e),M(Z,l,e),s(l,ml,e),s(l,_,e),s(l,Jl,e),s(l,k,e),s(l,wl,e),s(l,G,e),s(l,ul,e),M(I,l,e),s(l,yl,e),s(l,B,e),s(l,fl,e),M(C,l,e),s(l,jl,e),s(l,y,e),s(l,Tl,e),M(v,l,e),s(l,bl,e),s(l,W,e),s(l,hl,e),s(l,g,e),s(l,Ul,e),M(E,l,e),s(l,Zl,e),s(l,$,e),s(l,_l,e),s(l,R,e),s(l,kl,e),M(X,l,e),s(l,Gl,e),s(l,N,e),s(l,Il,e),M(V,l,e),s(l,Bl,e),s(l,H,e),s(l,Cl,e),M(A,l,e),s(l,vl,e),s(l,f,e),s(l,Wl,e),M(x,l,e),s(l,gl,e),s(l,z,e),s(l,El,e),s(l,Q,e),s(l,$l,e),s(l,F,e),s(l,Rl,e),s(l,j,e),s(l,Xl,e),M(Y,l,e),s(l,Nl,e),s(l,S,e),s(l,Vl,e),M(L,l,e),s(l,Hl,e),s(l,P,e),s(l,Al,e),M(q,l,e),s(l,xl,e),s(l,T,e),s(l,zl,e),s(l,D,e),s(l,Ql,e),M(K,l,e),s(l,Fl,e),s(l,O,e),s(l,Yl,e),M(ll,l,e),s(l,Sl,e),s(l,el,e),s(l,Ll,e),M(tl,l,e),s(l,Pl,e),s(l,sl,e),s(l,ql,e),M(al,l,e),s(l,Dl,e),s(l,cl,e),Kl=!0},p:Ie,i(l){Kl||(d(b.$$.fragment,l),d(Z.$$.fragment,l),d(I.$$.fragment,l),d(C.$$.fragment,l),d(v.$$.fragment,l),d(E.$$.fragment,l),d(X.$$.fragment,l),d(V.$$.fragment,l),d(A.$$.fragment,l),d(x.$$.fragment,l),d(Y.$$.fragment,l),d(L.$$.fragment,l),d(q.$$.fragment,l),d(K.$$.fragment,l),d(ll.$$.fragment,l),d(tl.$$.fragment,l),d(al.$$.fragment,l),Kl=!0)},o(l){m(b.$$.fragment,l),m(Z.$$.fragment,l),m(I.$$.fragment,l),m(C.$$.fragment,l),m(v.$$.fragment,l),m(E.$$.fragment,l),m(X.$$.fragment,l),m(V.$$.fragment,l),m(A.$$.fragment,l),m(x.$$.fragment,l),m(Y.$$.fragment,l),m(L.$$.fragment,l),m(q.$$.fragment,l),m(K.$$.fragment,l),m(ll.$$.fragment,l),m(tl.$$.fragment,l),m(al.$$.fragment,l),Kl=!1},d(l){l&&(t(il),t(pl),t(ol),t(rl),t(h),t(Ml),t(U),t(dl),t(ml),t(_),t(Jl),t(k),t(wl),t(G),t(ul),t(yl),t(B),t(fl),t(jl),t(y),t(Tl),t(bl),t(W),t(hl),t(g),t(Ul),t(Zl),t($),t(_l),t(R),t(kl),t(Gl),t(N),t(Il),t(Bl),t(H),t(Cl),t(vl),t(f),t(Wl),t(gl),t(z),t(El),t(Q),t($l),t(F),t(Rl),t(j),t(Xl),t(Nl),t(S),t(Vl),t(Hl),t(P),t(Al),t(xl),t(T),t(zl),t(D),t(Ql),t(Fl),t(O),t(Yl),t(Sl),t(el),t(Ll),t(Pl),t(sl),t(ql),t(Dl),t(cl)),t(u),J(b,l),J(Z,l),J(I,l),J(C,l),J(v,l),J(E,l),J(X,l),J(V,l),J(A,l),J(x,l),J(Y,l),J(L,l),J(q,l),J(K,l),J(ll,l),J(tl,l),J(al,l)}}}const Re='{"title":"分布式推理","local":"分布式推理","sections":[{"title":"🤗 Accelerate","local":"-accelerate","sections":[],"depth":2},{"title":"PyTorch Distributed","local":"pytorch-distributed","sections":[],"depth":2},{"title":"模型分片","local":"模型分片","sections":[],"depth":2}],"depth":1}';function Xe(le){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xe extends Ce{constructor(u){super(),ve(this,u,Xe,$e,Ge,{})}}export{xe as component};
