import{s as Lt,n as Nt,o as St}from"../chunks/scheduler.4430a55f.js";import{S as Qt,i as Ft,e as a,s as i,c,h as Yt,a as p,d as t,b as n,f as zt,g as m,j as r,k as y,l as Dt,m as s,n as o,t as f,o as M,p as u}from"../chunks/index.250b5259.js";import{C as d}from"../chunks/CodeBlock.3e25c118.js";import{D as Et}from"../chunks/DocNotebookDropdown.53683b60.js";import{H as $,E as Pt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.39f03929.js";function At(Kl){let b,Ie,Ce,Be,v,Re,W,Xe,_,Ol="让 <code>DiffusionPipeline</code> 生成特定风格或包含你所想要的内容的图像可能会有些棘手。 通常情况下，你需要多次运行 <code>DiffusionPipeline</code> 才能得到满意的图像。但是从无到有生成图像是一个计算密集的过程，特别是如果你要一遍又一遍地进行推理运算。",xe,V,et="这就是为什么从pipeline中获得最高的 <em>computational</em> (speed) 和 <em>memory</em> (GPU RAM) 非常重要 ，以减少推理周期之间的时间，从而使迭代速度更快。",ze,k,lt="本教程将指导您如何通过 <code>DiffusionPipeline</code>  更快、更好地生成图像。",Le,C,tt='首先，加载 <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a> 模型:',Ne,H,Se,I,st="本教程将使用的提示词是 <code>portrait photo of a old warrior chief</code> ，但是你可以随心所欲的想象和构造自己的提示词：",Qe,B,Fe,R,Ye,h,it='<p>💡 如果你没有 GPU, 你可以从像 <a href="https://colab.research.google.com/" rel="nofollow">Colab</a> 这样的 GPU 提供商获取免费的 GPU !</p>',De,X,nt="加速推理的最简单方法之一是将 pipeline 放在 GPU 上 ，就像使用任何 PyTorch 模块一样：",Ee,x,Pe,z,at='为了确保您可以使用相同的图像并对其进行改进，使用 <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>Generator</code></a> 方法，然后设置一个随机数种子 以确保其 <a href="./using-diffusers/reusing_seeds">复现性</a>:',Ae,L,qe,N,pt="现在，你可以生成一个图像：",Ke,S,Oe,J,rt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_1.png"/>',el,Q,ct="在 T4 GPU 上，这个过程大概要30秒（如果你的 GPU 比 T4 好，可能会更快）。在默认情况下，<code>DiffusionPipeline</code> 使用完整的 <code>float32</code> 精度进行 50 步推理。你可以通过降低精度（如 <code>float16</code> ）或者减少推理步数来加速整个过程",ll,F,mt="让我们把模型的精度降低至 <code>float16</code> ，然后生成一张图像：",tl,Y,sl,w,ot='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_2.png"/>',il,D,ft="这一次，生成图像只花了约 11 秒，比之前快了近 3 倍！",nl,T,Mt="<p>💡 我们强烈建议把 pipeline 精度降低至 <code>float16</code> , 到目前为止, 我们很少看到输出质量有任何下降。</p>",al,E,ut="另一个选择是减少推理步数。 你可以选择一个更高效的调度器 (<em>scheduler</em>) 可以减少推理步数同时保证输出质量。您可以在 [DiffusionPipeline] 中通过调用compatibles方法找到与当前模型兼容的调度器 (<em>scheduler</em>)。",pl,P,rl,A,dt="Stable Diffusion 模型默认使用的是 <code>PNDMScheduler</code> ，通常要大概50步推理, 但是像 <code>DPMSolverMultistepScheduler</code> 这样更高效的调度器只要大概 20 或 25 步推理. 使用 <code>ConfigMixin.from_config()</code> 方法加载新的调度器:",cl,q,ml,K,yt="现在将 <code>num_inference_steps</code> 设置为 20:",ol,O,fl,U,bt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_3.png"/>',Ml,ee,ht="太棒了！你成功把推理时间缩短到 4 秒！⚡️",ul,le,dl,te,Jt="改善 pipeline 性能的另一个关键是减少内存的使用量，这间接意味着速度更快，因为你经常试图最大化每秒生成的图像数量。要想知道你一次可以生成多少张图片，最简单的方法是尝试不同的batch size，直到出现<code>OutOfMemoryError</code> (OOM)。",yl,se,wt="创建一个函数，为每一批要生成的图像分配提示词和 <code>Generators</code> 。请务必为每个<code>Generator</code> 分配一个种子，以便于复现良好的结果。",bl,ie,hl,ne,Tt="设置 <code>batch_size=4</code> ，然后看一看我们消耗了多少内存:",Jl,ae,wl,pe,Ut="除非你有一个更大内存的GPU, 否则上述代码会返回 <code>OOM</code> 错误! 大部分内存被 cross-attention 层使用。按顺序运行可以节省大量内存，而不是在批处理中进行。你可以为 pipeline 配置 <code>enable_attention_slicing()</code> 函数:",Tl,re,Ul,ce,Zt="现在尝试把 <code>batch_size</code> 增加到 8!",Zl,me,gl,Z,gt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_5.png"/>',Gl,oe,Gt="以前你不能一批生成 4 张图片，而现在你可以在一张图片里面生成八张图片而只需要大概3.5秒！这可能是 T4 GPU 在不牺牲质量的情况运行速度最快的一种方法。",jl,fe,$l,Me,jt="在最后两节中, 你要学习如何通过 <code>fp16</code> 来优化 pipeline 的速度, 通过使用性能更高的调度器来减少推理步数, 使用注意力切片（<em>enabling attention slicing</em>）方法来节省内存。现在，你将关注的是如何提高图像的质量。",vl,ue,Wl,de,$t='有个显而易见的方法是使用更好的 checkpoints。 Stable Diffusion 模型是一个很好的起点, 自正式发布以来，还发布了几个改进版本。然而, 使用更新的版本并不意味着你会得到更好的结果。你仍然需要尝试不同的 checkpoints ，并做一些研究 (例如使用 <a href="https://minimaxir.com/2022/11/stable-diffusion-negative-prompt/" rel="nofollow">negative prompts</a>) 来获得更好的结果。',_l,ye,vt='随着该领域的发展, 有越来越多经过微调的高质量的 checkpoints 用来生成不一样的风格. 在 <a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">Hub</a> 和 <a href="https://huggingface.co/spaces/huggingface-projects/diffusers-gallery" rel="nofollow">Diffusers Gallery</a> 寻找你感兴趣的一种!',Vl,be,kl,he,Wt='也可以尝试用新版本替换当前 pipeline 组件。让我们加载最新的 <a href="https://huggingface.co/stabilityai/stable-diffusion-2-1/tree/main/vae" rel="nofollow">autodecoder</a> 从 Stability AI 加载到 pipeline, 并生成一些图像:',Cl,Je,Hl,g,_t='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_6.png"/>',Il,we,Bl,Te,Vt="用于生成图像的文本非常重要, 因此被称为 <em>提示词工程</em>。 在设计提示词工程应注意如下事项:",Rl,Ue,kt="<li>我想生成的图像或类似图像如何存储在互联网上？</li> <li>我可以提供哪些额外的细节来引导模型朝着我想要的风格生成？</li>",Xl,Ze,Ct="考虑到这一点，让我们改进提示词，以包含颜色和更高质量的细节：",xl,ge,zl,Ge,Ht="使用新的提示词生成一批图像:",Ll,je,Nl,G,It='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_7.png"/>',Sl,$e,Bt="非常的令人印象深刻! Let’s tweak the second image - 把 <code>Generator</code> 的种子设置为 <code>1</code> - 添加一些关于年龄的主题文本:",Ql,ve,Fl,j,Rt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_8.png"/>',Yl,We,Dl,_e,Xt="在本教程中, 您学习了如何优化<code>DiffusionPipeline</code>以提高计算和内存效率，以及提高生成输出的质量. 如果你有兴趣让你的 pipeline 更快, 可以看一看以下资源:",El,Ve,xt='<li>学习 <a href="./optimization/torch2.0">PyTorch 2.0</a> 和 <a href="https://pytorch.org/docs/stable/generated/torch.compile.html" rel="nofollow"><code>torch.compile</code></a> 可以让推理速度提高 5 - 300% . 在 A100 GPU 上, 推理速度可以提高 50% !</li> <li>如果你没法用 PyTorch 2, 我们建议你安装 <a href="./optimization/xformers">xFormers</a>。它的内存高效注意力机制（<em>memory-efficient attention mechanism</em>）与PyTorch 1.13.1配合使用，速度更快，内存消耗更少。</li> <li>其他的优化技术, 如：模型卸载（<em>model offloading</em>）, 包含在 <a href="./optimization/fp16">这份指南</a>.</li>',Pl,ke,Al,He,ql;return v=new $({props:{title:"有效且高效的扩散",local:"有效且高效的扩散",headingTag:"h1"}}),W=new Et({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/zh/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/zh/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/zh/tensorflow/stable_diffusion.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/zh/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/zh/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/zh/tensorflow/stable_diffusion.ipynb"}]}}),H=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),B=new d({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIycG9ydHJhaXQlMjBwaG90byUyMG9mJTIwYSUyMG9sZCUyMHdhcnJpb3IlMjBjaGllZiUyMg==",highlighted:'prompt = <span class="hljs-string">&quot;portrait photo of a old warrior chief&quot;</span>',wrap:!1}}),R=new $({props:{title:"速度",local:"速度",headingTag:"h2"}}),x=new d({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKQ==",highlighted:'pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),L=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCk=",highlighted:`<span class="hljs-keyword">import</span> torch

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)`,wrap:!1}}),S=new d({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Y=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),P=new d({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbXBhdGlibGVzJTBBJTVCJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19sbXNfZGlzY3JldGUuTE1TRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3VuaXBjX211bHRpc3RlcC5VbmlQQ011bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfa19kcG1fMl9kaXNjcmV0ZS5LRFBNMkRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kZWlzX211bHRpc3RlcC5ERUlTTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9kaXNjcmV0ZS5FdWxlckRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfbXVsdGlzdGVwLkRQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRwbS5ERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfc2luZ2xlc3RlcC5EUE1Tb2x2ZXJTaW5nbGVzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19rX2RwbV8yX2FuY2VzdHJhbF9kaXNjcmV0ZS5LRFBNMkFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19oZXVuX2Rpc2NyZXRlLkhldW5EaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfcG5kbS5QTkRNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9hbmNlc3RyYWxfZGlzY3JldGUuRXVsZXJBbmNlc3RyYWxEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRpbS5ERElNU2NoZWR1bGVyJTJDJTBBJTVE",highlighted:`pipeline.scheduler.compatibles
[
    diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler,
    diffusers.schedulers.scheduling_unipc_multistep.UniPCMultistepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_discrete.KDPM2DiscreteScheduler,
    diffusers.schedulers.scheduling_deis_multistep.DEISMultistepScheduler,
    diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler,
    diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler,
    diffusers.schedulers.scheduling_ddpm.DDPMScheduler,
    diffusers.schedulers.scheduling_dpmsolver_singlestep.DPMSolverSinglestepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_ancestral_discrete.KDPM2AncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_heun_discrete.HeunDiscreteScheduler,
    diffusers.schedulers.scheduling_pndm.PNDMScheduler,
    diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_ddim.DDIMScheduler,
]`,wrap:!1}}),q=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),O=new d({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),le=new $({props:{title:"内存",local:"内存",headingTag:"h2"}}),ie=new d({props:{code:"ZGVmJTIwZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNEMSklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlMjAlM0QlMjAlNUJ0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoaSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShiYXRjaF9zaXplKSU1RCUwQSUyMCUyMCUyMCUyMHByb21wdHMlMjAlM0QlMjBiYXRjaF9zaXplJTIwKiUyMCU1QnByb21wdCU1RCUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyMCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnByb21wdCUyMiUzQSUyMHByb21wdHMlMkMlMjAlMjJnZW5lcmF0b3IlMjIlM0ElMjBnZW5lcmF0b3IlMkMlMjAlMjJudW1faW5mZXJlbmNlX3N0ZXBzJTIyJTNBJTIwbnVtX2luZmVyZW5jZV9zdGVwcyU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_inputs</span>(<span class="hljs-params">batch_size=<span class="hljs-number">1</span></span>):
    generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(i) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size)]
    prompts = batch_size * [prompt]
    num_inference_steps = <span class="hljs-number">20</span>

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;prompt&quot;</span>: prompts, <span class="hljs-string">&quot;generator&quot;</span>: generator, <span class="hljs-string">&quot;num_inference_steps&quot;</span>: num_inference_steps}`,wrap:!1}}),ae=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCoqZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNENCkpLmltYWdlcyUwQW1ha2VfaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjAyJTJDJTIwMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

images = pipeline(**get_inputs(batch_size=<span class="hljs-number">4</span>)).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),re=new d({props:{code:"cGlwZWxpbmUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCk=",highlighted:"pipeline.enable_attention_slicing()",wrap:!1}}),me=new d({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),fe=new $({props:{title:"质量",local:"质量",headingTag:"h2"}}),ue=new $({props:{title:"更好的 checkpoints",local:"更好的-checkpoints",headingTag:"h3"}}),be=new $({props:{title:"更好的 pipeline 组件",local:"更好的-pipeline-组件",headingTag:"h3"}}),Je=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0wlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkLXZhZS1mdC1tc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUudmFlJTIwJTNEJTIwdmFlJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.vae = vae
images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),we=new $({props:{title:"更好的提示词工程",local:"更好的提示词工程",headingTag:"h3"}}),ge=new d({props:{code:"cHJvbXB0JTIwJTJCJTNEJTIwJTIyJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMiUwQXByb21wdCUyMCUyQiUzRCUyMCUyMiUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMg==",highlighted:`prompt += <span class="hljs-string">&quot;, tribal panther make up, blue on red, side profile, looking away, serious eyes&quot;</span>
prompt += <span class="hljs-string">&quot; 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>`,wrap:!1}}),je=new d({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),ve=new d({props:{code:"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",highlighted:`prompts = [
    <span class="hljs-string">&quot;portrait photo of the oldest warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a old warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a young warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
]

generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(prompts))]
images = pipeline(prompt=prompts, generator=generator, num_inference_steps=<span class="hljs-number">25</span>).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),We=new $({props:{title:"最后",local:"最后",headingTag:"h2"}}),ke=new Pt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/zh/stable_diffusion.md"}}),{c(){b=a("meta"),Ie=i(),Ce=a("p"),Be=i(),c(v.$$.fragment),Re=i(),c(W.$$.fragment),Xe=i(),_=a("p"),_.innerHTML=Ol,xe=i(),V=a("p"),V.innerHTML=et,ze=i(),k=a("p"),k.innerHTML=lt,Le=i(),C=a("p"),C.innerHTML=tt,Ne=i(),c(H.$$.fragment),Se=i(),I=a("p"),I.innerHTML=st,Qe=i(),c(B.$$.fragment),Fe=i(),c(R.$$.fragment),Ye=i(),h=a("blockquote"),h.innerHTML=it,De=i(),X=a("p"),X.textContent=nt,Ee=i(),c(x.$$.fragment),Pe=i(),z=a("p"),z.innerHTML=at,Ae=i(),c(L.$$.fragment),qe=i(),N=a("p"),N.textContent=pt,Ke=i(),c(S.$$.fragment),Oe=i(),J=a("div"),J.innerHTML=rt,el=i(),Q=a("p"),Q.innerHTML=ct,ll=i(),F=a("p"),F.innerHTML=mt,tl=i(),c(Y.$$.fragment),sl=i(),w=a("div"),w.innerHTML=ot,il=i(),D=a("p"),D.textContent=ft,nl=i(),T=a("blockquote"),T.innerHTML=Mt,al=i(),E=a("p"),E.innerHTML=ut,pl=i(),c(P.$$.fragment),rl=i(),A=a("p"),A.innerHTML=dt,cl=i(),c(q.$$.fragment),ml=i(),K=a("p"),K.innerHTML=yt,ol=i(),c(O.$$.fragment),fl=i(),U=a("div"),U.innerHTML=bt,Ml=i(),ee=a("p"),ee.textContent=ht,ul=i(),c(le.$$.fragment),dl=i(),te=a("p"),te.innerHTML=Jt,yl=i(),se=a("p"),se.innerHTML=wt,bl=i(),c(ie.$$.fragment),hl=i(),ne=a("p"),ne.innerHTML=Tt,Jl=i(),c(ae.$$.fragment),wl=i(),pe=a("p"),pe.innerHTML=Ut,Tl=i(),c(re.$$.fragment),Ul=i(),ce=a("p"),ce.innerHTML=Zt,Zl=i(),c(me.$$.fragment),gl=i(),Z=a("div"),Z.innerHTML=gt,Gl=i(),oe=a("p"),oe.textContent=Gt,jl=i(),c(fe.$$.fragment),$l=i(),Me=a("p"),Me.innerHTML=jt,vl=i(),c(ue.$$.fragment),Wl=i(),de=a("p"),de.innerHTML=$t,_l=i(),ye=a("p"),ye.innerHTML=vt,Vl=i(),c(be.$$.fragment),kl=i(),he=a("p"),he.innerHTML=Wt,Cl=i(),c(Je.$$.fragment),Hl=i(),g=a("div"),g.innerHTML=_t,Il=i(),c(we.$$.fragment),Bl=i(),Te=a("p"),Te.innerHTML=Vt,Rl=i(),Ue=a("ul"),Ue.innerHTML=kt,Xl=i(),Ze=a("p"),Ze.textContent=Ct,xl=i(),c(ge.$$.fragment),zl=i(),Ge=a("p"),Ge.textContent=Ht,Ll=i(),c(je.$$.fragment),Nl=i(),G=a("div"),G.innerHTML=It,Sl=i(),$e=a("p"),$e.innerHTML=Bt,Ql=i(),c(ve.$$.fragment),Fl=i(),j=a("div"),j.innerHTML=Rt,Yl=i(),c(We.$$.fragment),Dl=i(),_e=a("p"),_e.innerHTML=Xt,El=i(),Ve=a("ul"),Ve.innerHTML=xt,Pl=i(),c(ke.$$.fragment),Al=i(),He=a("p"),this.h()},l(e){const l=Yt("svelte-u9bgzb",document.head);b=p(l,"META",{name:!0,content:!0}),l.forEach(t),Ie=n(e),Ce=p(e,"P",{}),zt(Ce).forEach(t),Be=n(e),m(v.$$.fragment,e),Re=n(e),m(W.$$.fragment,e),Xe=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1v0o1kl"&&(_.innerHTML=Ol),xe=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-leukn8"&&(V.innerHTML=et),ze=n(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-8fx6wg"&&(k.innerHTML=lt),Le=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-t3ajyn"&&(C.innerHTML=tt),Ne=n(e),m(H.$$.fragment,e),Se=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-tpz466"&&(I.innerHTML=st),Qe=n(e),m(B.$$.fragment,e),Fe=n(e),m(R.$$.fragment,e),Ye=n(e),h=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-dhfwfj"&&(h.innerHTML=it),De=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-140tryr"&&(X.textContent=nt),Ee=n(e),m(x.$$.fragment,e),Pe=n(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1y2bzt"&&(z.innerHTML=at),Ae=n(e),m(L.$$.fragment,e),qe=n(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-4x6dr0"&&(N.textContent=pt),Ke=n(e),m(S.$$.fragment,e),Oe=n(e),J=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1of5nwm"&&(J.innerHTML=rt),el=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-dxn1az"&&(Q.innerHTML=ct),ll=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-qtbizy"&&(F.innerHTML=mt),tl=n(e),m(Y.$$.fragment,e),sl=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1why3l7"&&(w.innerHTML=ot),il=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-pogsc6"&&(D.textContent=ft),nl=n(e),T=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1tdgn79"&&(T.innerHTML=Mt),al=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1b7m8op"&&(E.innerHTML=ut),pl=n(e),m(P.$$.fragment,e),rl=n(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-ug0tja"&&(A.innerHTML=dt),cl=n(e),m(q.$$.fragment,e),ml=n(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1hxt66h"&&(K.innerHTML=yt),ol=n(e),m(O.$$.fragment,e),fl=n(e),U=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-19w49w4"&&(U.innerHTML=bt),Ml=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-uzam9p"&&(ee.textContent=ht),ul=n(e),m(le.$$.fragment,e),dl=n(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-13ch8y2"&&(te.innerHTML=Jt),yl=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-cfkbaa"&&(se.innerHTML=wt),bl=n(e),m(ie.$$.fragment,e),hl=n(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-15a7i1a"&&(ne.innerHTML=Tt),Jl=n(e),m(ae.$$.fragment,e),wl=n(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1xqk7ef"&&(pe.innerHTML=Ut),Tl=n(e),m(re.$$.fragment,e),Ul=n(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1sdpqou"&&(ce.innerHTML=Zt),Zl=n(e),m(me.$$.fragment,e),gl=n(e),Z=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-vxa9bu"&&(Z.innerHTML=gt),Gl=n(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-f1534l"&&(oe.textContent=Gt),jl=n(e),m(fe.$$.fragment,e),$l=n(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1c8v1nf"&&(Me.innerHTML=jt),vl=n(e),m(ue.$$.fragment,e),Wl=n(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-p1zz72"&&(de.innerHTML=$t),_l=n(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-i5so0v"&&(ye.innerHTML=vt),Vl=n(e),m(be.$$.fragment,e),kl=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-o0zap8"&&(he.innerHTML=Wt),Cl=n(e),m(Je.$$.fragment,e),Hl=n(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-610rhb"&&(g.innerHTML=_t),Il=n(e),m(we.$$.fragment,e),Bl=n(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-18d69j8"&&(Te.innerHTML=Vt),Rl=n(e),Ue=p(e,"UL",{"data-svelte-h":!0}),r(Ue)!=="svelte-1n2jyxj"&&(Ue.innerHTML=kt),Xl=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-60602z"&&(Ze.textContent=Ct),xl=n(e),m(ge.$$.fragment,e),zl=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-610aip"&&(Ge.textContent=Ht),Ll=n(e),m(je.$$.fragment,e),Nl=n(e),G=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(G)!=="svelte-n1o5lk"&&(G.innerHTML=It),Sl=n(e),$e=p(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1ncypu7"&&($e.innerHTML=Bt),Ql=n(e),m(ve.$$.fragment,e),Fl=n(e),j=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1lkw2bx"&&(j.innerHTML=Rt),Yl=n(e),m(We.$$.fragment,e),Dl=n(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-o28ro3"&&(_e.innerHTML=Xt),El=n(e),Ve=p(e,"UL",{"data-svelte-h":!0}),r(Ve)!=="svelte-14q6wc5"&&(Ve.innerHTML=xt),Pl=n(e),m(ke.$$.fragment,e),Al=n(e),He=p(e,"P",{}),zt(He).forEach(t),this.h()},h(){y(b,"name","hf:doc:metadata"),y(b,"content",qt),y(h,"class","tip"),y(J,"class","flex justify-center"),y(w,"class","flex justify-center"),y(T,"class","tip"),y(U,"class","flex justify-center"),y(Z,"class","flex justify-center"),y(g,"class","flex justify-center"),y(G,"class","flex justify-center"),y(j,"class","flex justify-center")},m(e,l){Dt(document.head,b),s(e,Ie,l),s(e,Ce,l),s(e,Be,l),o(v,e,l),s(e,Re,l),o(W,e,l),s(e,Xe,l),s(e,_,l),s(e,xe,l),s(e,V,l),s(e,ze,l),s(e,k,l),s(e,Le,l),s(e,C,l),s(e,Ne,l),o(H,e,l),s(e,Se,l),s(e,I,l),s(e,Qe,l),o(B,e,l),s(e,Fe,l),o(R,e,l),s(e,Ye,l),s(e,h,l),s(e,De,l),s(e,X,l),s(e,Ee,l),o(x,e,l),s(e,Pe,l),s(e,z,l),s(e,Ae,l),o(L,e,l),s(e,qe,l),s(e,N,l),s(e,Ke,l),o(S,e,l),s(e,Oe,l),s(e,J,l),s(e,el,l),s(e,Q,l),s(e,ll,l),s(e,F,l),s(e,tl,l),o(Y,e,l),s(e,sl,l),s(e,w,l),s(e,il,l),s(e,D,l),s(e,nl,l),s(e,T,l),s(e,al,l),s(e,E,l),s(e,pl,l),o(P,e,l),s(e,rl,l),s(e,A,l),s(e,cl,l),o(q,e,l),s(e,ml,l),s(e,K,l),s(e,ol,l),o(O,e,l),s(e,fl,l),s(e,U,l),s(e,Ml,l),s(e,ee,l),s(e,ul,l),o(le,e,l),s(e,dl,l),s(e,te,l),s(e,yl,l),s(e,se,l),s(e,bl,l),o(ie,e,l),s(e,hl,l),s(e,ne,l),s(e,Jl,l),o(ae,e,l),s(e,wl,l),s(e,pe,l),s(e,Tl,l),o(re,e,l),s(e,Ul,l),s(e,ce,l),s(e,Zl,l),o(me,e,l),s(e,gl,l),s(e,Z,l),s(e,Gl,l),s(e,oe,l),s(e,jl,l),o(fe,e,l),s(e,$l,l),s(e,Me,l),s(e,vl,l),o(ue,e,l),s(e,Wl,l),s(e,de,l),s(e,_l,l),s(e,ye,l),s(e,Vl,l),o(be,e,l),s(e,kl,l),s(e,he,l),s(e,Cl,l),o(Je,e,l),s(e,Hl,l),s(e,g,l),s(e,Il,l),o(we,e,l),s(e,Bl,l),s(e,Te,l),s(e,Rl,l),s(e,Ue,l),s(e,Xl,l),s(e,Ze,l),s(e,xl,l),o(ge,e,l),s(e,zl,l),s(e,Ge,l),s(e,Ll,l),o(je,e,l),s(e,Nl,l),s(e,G,l),s(e,Sl,l),s(e,$e,l),s(e,Ql,l),o(ve,e,l),s(e,Fl,l),s(e,j,l),s(e,Yl,l),o(We,e,l),s(e,Dl,l),s(e,_e,l),s(e,El,l),s(e,Ve,l),s(e,Pl,l),o(ke,e,l),s(e,Al,l),s(e,He,l),ql=!0},p:Nt,i(e){ql||(f(v.$$.fragment,e),f(W.$$.fragment,e),f(H.$$.fragment,e),f(B.$$.fragment,e),f(R.$$.fragment,e),f(x.$$.fragment,e),f(L.$$.fragment,e),f(S.$$.fragment,e),f(Y.$$.fragment,e),f(P.$$.fragment,e),f(q.$$.fragment,e),f(O.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(me.$$.fragment,e),f(fe.$$.fragment,e),f(ue.$$.fragment,e),f(be.$$.fragment,e),f(Je.$$.fragment,e),f(we.$$.fragment,e),f(ge.$$.fragment,e),f(je.$$.fragment,e),f(ve.$$.fragment,e),f(We.$$.fragment,e),f(ke.$$.fragment,e),ql=!0)},o(e){M(v.$$.fragment,e),M(W.$$.fragment,e),M(H.$$.fragment,e),M(B.$$.fragment,e),M(R.$$.fragment,e),M(x.$$.fragment,e),M(L.$$.fragment,e),M(S.$$.fragment,e),M(Y.$$.fragment,e),M(P.$$.fragment,e),M(q.$$.fragment,e),M(O.$$.fragment,e),M(le.$$.fragment,e),M(ie.$$.fragment,e),M(ae.$$.fragment,e),M(re.$$.fragment,e),M(me.$$.fragment,e),M(fe.$$.fragment,e),M(ue.$$.fragment,e),M(be.$$.fragment,e),M(Je.$$.fragment,e),M(we.$$.fragment,e),M(ge.$$.fragment,e),M(je.$$.fragment,e),M(ve.$$.fragment,e),M(We.$$.fragment,e),M(ke.$$.fragment,e),ql=!1},d(e){e&&(t(Ie),t(Ce),t(Be),t(Re),t(Xe),t(_),t(xe),t(V),t(ze),t(k),t(Le),t(C),t(Ne),t(Se),t(I),t(Qe),t(Fe),t(Ye),t(h),t(De),t(X),t(Ee),t(Pe),t(z),t(Ae),t(qe),t(N),t(Ke),t(Oe),t(J),t(el),t(Q),t(ll),t(F),t(tl),t(sl),t(w),t(il),t(D),t(nl),t(T),t(al),t(E),t(pl),t(rl),t(A),t(cl),t(ml),t(K),t(ol),t(fl),t(U),t(Ml),t(ee),t(ul),t(dl),t(te),t(yl),t(se),t(bl),t(hl),t(ne),t(Jl),t(wl),t(pe),t(Tl),t(Ul),t(ce),t(Zl),t(gl),t(Z),t(Gl),t(oe),t(jl),t($l),t(Me),t(vl),t(Wl),t(de),t(_l),t(ye),t(Vl),t(kl),t(he),t(Cl),t(Hl),t(g),t(Il),t(Bl),t(Te),t(Rl),t(Ue),t(Xl),t(Ze),t(xl),t(zl),t(Ge),t(Ll),t(Nl),t(G),t(Sl),t($e),t(Ql),t(Fl),t(j),t(Yl),t(Dl),t(_e),t(El),t(Ve),t(Pl),t(Al),t(He)),t(b),u(v,e),u(W,e),u(H,e),u(B,e),u(R,e),u(x,e),u(L,e),u(S,e),u(Y,e),u(P,e),u(q,e),u(O,e),u(le,e),u(ie,e),u(ae,e),u(re,e),u(me,e),u(fe,e),u(ue,e),u(be,e),u(Je,e),u(we,e),u(ge,e),u(je,e),u(ve,e),u(We,e),u(ke,e)}}}const qt='{"title":"有效且高效的扩散","local":"有效且高效的扩散","sections":[{"title":"速度","local":"速度","sections":[],"depth":2},{"title":"内存","local":"内存","sections":[],"depth":2},{"title":"质量","local":"质量","sections":[{"title":"更好的 checkpoints","local":"更好的-checkpoints","sections":[],"depth":3},{"title":"更好的 pipeline 组件","local":"更好的-pipeline-组件","sections":[],"depth":3},{"title":"更好的提示词工程","local":"更好的提示词工程","sections":[],"depth":3}],"depth":2},{"title":"最后","local":"最后","sections":[],"depth":2}],"depth":1}';function Kt(Kl){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class is extends Qt{constructor(b){super(),Ft(this,b,Kt,At,Lt,{})}}export{is as component};
