import{s as Ft,n as gt,o as $t}from"../chunks/scheduler.4430a55f.js";import{S as Yt,i as vt,e as a,s as n,c as o,h as Nt,a as p,d as t,b as i,f as Vt,g as d,j as M,k as St,l as Qt,m as s,n as c,t as J,o as U,p as T}from"../chunks/index.250b5259.js";import{C as y}from"../chunks/CodeBlock.3e25c118.js";import{H as m,E as Et}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.39f03929.js";function Lt(Pe){let f,Vl,kl,Sl,u,Fl,r,Ke="模块化Diffusers是一个快速构建灵活和可定制管道的框架。模块化Diffusers的核心是<code>ModularPipelineBlocks</code>，可以与其他块组合以适应新的工作流程。这些块被转换为<code>ModularPipeline</code>，一个开发者可以使用的友好用户界面。",gl,Z,Oe='本文档将向您展示如何使用模块化框架实现<a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a>管道。',$l,w,Yl,b,lt="<code>ModularPipelineBlocks</code>是<em>定义</em>，指定管道中单个步骤的组件、输入、输出和计算逻辑。有四种类型的块。",vl,I,et="<li><code>ModularPipelineBlocks</code>是最基本的单一步骤块。</li> <li><code>SequentialPipelineBlocks</code>是一个多块，线性组合其他块。一个块的输出是下一个块的输入。</li> <li><code>LoopSequentialPipelineBlocks</code>是一个多块，迭代运行，专为迭代工作流程设计。</li> <li><code>AutoPipelineBlocks</code>是一个针对不同工作流程的块集合，它根据输入选择运行哪个块。它旨在方便地将多个工作流程打包到单个管道中。</li>",Nl,j,tt='<a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a>是一个图像到图像的工作流程。从<code>IMAGE2IMAGE_BLOCKS</code>预设开始，这是一个用于图像到图像生成的<code>ModularPipelineBlocks</code>集合。',Ql,C,El,G,Ll,R,st="模块化Diffusers使用<em>状态</em>在块之间通信数据。有两种类型的状态。",Dl,_,nt="<li><code>PipelineState</code>是一个全局状态，可用于跟踪所有块的所有输入和输出。</li> <li><code>BlockState</code>是<code>PipelineState</code>中相关变量的局部视图，用于单个块。</li>",Al,W,Hl,X,it='<a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a> 与标准的图像到图像转换在其 <code>prepare_latents</code> 和 <code>denoise</code> 块上有所不同。所有其他块都可以重用，但你需要修改这两个。',zl,h,at="通过复制和修改现有的块，为 <code>prepare_latents</code> 和 <code>denoise</code> 创建占位符 <code>ModularPipelineBlocks</code>。",ql,k,pt="打印 <code>denoise</code> 块，可以看到它由 <code>LoopSequentialPipelineBlocks</code> 组成，包含三个子块，<code>before_denoiser</code>、<code>denoiser</code> 和 <code>after_denoiser</code>。只需要修改 <code>before_denoiser</code> 子块，根据变化图为去噪器准备潜在输入。",xl,B,Pl,V,Mt="用新的 <code>SDXLDiffDiffLoopBeforeDenoiser</code> 块替换 <code>StableDiffusionXLLoopBeforeDenoiser</code> 子块。",Kl,S,Ol,F,le,g,ot="<code>prepare_latents</code> 块需要进行以下更改。",ee,$,dt="<li>一个处理器来处理变化图</li> <li>一个新的 <code>inputs</code> 来接受用户提供的变化图，<code>timestep</code> 用于预计算所有潜在变量和 <code>num_inference_steps</code> 来创建更新图像区域的掩码</li> <li>更新 <code>__call__</code> 方法中的计算，用于处理变化图和创建掩码，并将其存储在 <code>BlockState</code> 中</li>",te,Y,se,v,ne,N,ct="<code>before_denoiser</code> 子块需要进行以下更改。",ie,Q,Jt="<li>新的 <code>inputs</code> 以接受 <code>denoising_start</code> 参数，<code>original_latents</code> 和 <code>diffdiff_masks</code> 来自 <code>prepare_latents</code> 块</li> <li>更新 <code>__call__</code> 方法中的计算以应用 Differential Diffusion</li>",ae,E,pe,L,Me,D,Ut="此时，您应该拥有创建 <code>ModularPipeline</code> 所需的所有块。",oe,A,Tt="复制现有的 <code>IMAGE2IMAGE_BLOCKS</code> 预设，对于 <code>set_timesteps</code> 块，使用 <code>TEXT2IMAGE_BLOCKS</code> 中的 <code>set_timesteps</code>，因为 Differential Diffusion 不需要 <code>strength</code> 参数。",de,H,yt="将 <code>prepare_latents</code> 和 <code>denoise</code> 块设置为您刚刚修改的 <code>SDXLDiffDiffPrepareLatentsStep</code> 和 <code>SDXLDiffDiffDenoiseStep</code> 块。",ce,z,mt="调用 <code>SequentialPipelineBlocks.from_blocks_dict</code> 在块上创建一个 <code>SequentialPipelineBlocks</code>。",Je,q,Ue,x,Te,P,ft="将 <code>SequentialPipelineBlocks</code> 转换为 <code>ModularPipeline</code>，使用 <code>ModularPipeline.init_pipeline</code> 方法。这会初始化从 <code>modular_model_index.json</code> 文件加载的预期组件。通过调用 <code>ModularPipeline.load_defau lt_components</code>。",ye,K,ut="初始化<code>ComponentManager</code>时传入pipeline是一个好主意，以帮助管理不同的组件。一旦调用<code>load_components()</code>，组件就会被注册到<code>ComponentManager</code>中，并且可以在工作流之间共享。下面的例子使用<code>collection</code>参数为组件分配了一个<code>&quot;diffdiff&quot;</code>标签，以便更好地组织。",me,O,fe,ll,ue,el,rt="可以向<code>ModularPipeline</code>添加其他工作流以支持更多功能，而无需从头重写整个pipeline。",re,tl,Zt="本节演示如何添加IP-Adapter或ControlNet。",Ze,sl,we,nl,wt="Stable Diffusion XL已经有一个预设的IP-Adapter块，你可以使用，并且不需要对现有的Differential Diffusion pipeline进行任何更改。",be,il,Ie,al,bt="使用<code>sub_blocks.insert</code>方法将其插入到<code>ModularPipeline</code>中。下面的例子在位置<code>0</code>插入了<code>ip_adapter_block</code>。打印pipeline可以看到<code>ip_adapter_block</code>被添加了，并且它需要一个<code>ip_adapter_image</code>。这也向pipeline添加了两个组件，<code>image_encoder</code>和<code>feature_extractor</code>。",je,pl,Ce,Ml,It="调用<code>~ModularPipeline.init_pipeline</code>来初始化一个<code>ModularPipeline</code>，并使用<code>load_components()</code>加载模型组件。加载并设置IP-Adapter以运行pipeline。",Ge,ol,Re,dl,_e,cl,jt="Stable Diffusion XL 已经预设了一个可以立即使用的 ControlNet 块。",We,Jl,Xe,Ul,Ct="然而，它需要修改 <code>denoise</code> 块，因为那是 ControlNet 将控制信息注入到 UNet 的地方。",he,Tl,Gt="通过将 <code>StableDiffusionXLLoopDenoiser</code> 子块替换为 <code>StableDiffusionXLControlNetLoopDenoiser</code> 来修改 <code>denoise</code> 块。",ke,yl,Be,ml,Rt="插入 <code>controlnet_input</code> 块并用新的 <code>controlnet_denoise_block</code> 替换 <code>denoise</code> 块。初始化一个 <code>ModularPipeline</code> 并将 <code>load_components()</code> 加载到其中。",Ve,fl,Se,ul,Fe,rl,_t="差分扩散、IP-Adapter 和 ControlNet 工作流可以通过使用 <code>AutoPipelineBlocks</code> 捆绑到一个单一的 <code>ModularPipeline</code> 中。这允许根据输入如 <code>control_image</code> 或 <code>ip_adapter_image</code> 自动选择要运行的子块。如果没有传递这些输入，则默认为差分扩散。",ge,Zl,Wt="使用 <code>block_trigger_inputs</code> 仅在提供 <code>control_image</code> 输入时运行 <code>SDXLDiffDiffControlNetDenoiseStep</code> 块。否则，使用 <code>SDXLDiffDiffDenoiseStep</code>。",$e,wl,Ye,bl,Xt="添加 <code>ip_adapter</code> 和 <code>controlnet_input</code> 块。",ve,Il,Ne,jl,ht="调用 <code>SequentialPipelineBlocks.from_blocks_dict</code> 来创建一个 <code>SequentialPipelineBlocks</code> 并创建一个 <code>ModularPipeline</code> 并加载模型组件以运行。",Qe,Cl,Ee,Gl,Le,Rl,kt="使用 <code>save_pretrained()</code> 将您的 <code>ModularPipeline</code> 添加到 Hub，并将 <code>push_to_hub</code> 参数设置为 <code>True</code>。",De,_l,Ae,Wl,Bt="其他用户可以使用 <code>from_pretrained()</code> 加载 <code>ModularPipeline</code>。",He,Xl,ze,hl,qe,Bl,xe;return u=new m({props:{title:"快速入门",local:"快速入门",headingTag:"h1"}}),w=new m({props:{title:"ModularPipelineBlocks",local:"modularpipelineblocks",headingTag:"h2"}}),C=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwSU1BR0UySU1BR0VfQkxPQ0tTJTBBSU1BR0UySU1BR0VfQkxPQ0tTJTIwJTNEJTIwSW5zZXJ0YWJsZURpY3QoJTVCJTBBJTIwJTIwJTIwJTIwKCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMVGV4dEVuY29kZXJTdGVwKSUyQyUwQSUyMCUyMCUyMCUyMCglMjJpbWFnZV9lbmNvZGVyJTIyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExWYWVFbmNvZGVyU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyaW5wdXQlMjIlMkMlMjBTdGFibGVEaWZmdXNpb25YTElucHV0U3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyc2V0X3RpbWVzdGVwcyUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1NldFRpbWVzdGVwc1N0ZXApJTJDJTBBJTIwJTIwJTIwJTIwKCUyMnByZXBhcmVfbGF0ZW50cyUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVMYXRlbnRzU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIycHJlcGFyZV9hZGRfY29uZCUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVBZGRpdGlvbmFsQ29uZGl0aW9uaW5nU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyZGVub2lzZSUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVub2lzZVN0ZXApJTJDJTBBJTIwJTIwJTIwJTIwKCUyMmRlY29kZSUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVjb2RlU3RlcCklMEElNUQp",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> IMAGE2IMAGE_BLOCKS
IMAGE2IMAGE_BLOCKS = InsertableDict([
    (<span class="hljs-string">&quot;text_encoder&quot;</span>, StableDiffusionXLTextEncoderStep),
    (<span class="hljs-string">&quot;image_encoder&quot;</span>, StableDiffusionXLVaeEncoderStep),
    (<span class="hljs-string">&quot;input&quot;</span>, StableDiffusionXLInputStep),
    (<span class="hljs-string">&quot;set_timesteps&quot;</span>, StableDiffusionXLImg2ImgSetTimestepsStep),
    (<span class="hljs-string">&quot;prepare_latents&quot;</span>, StableDiffusionXLImg2ImgPrepareLatentsStep),
    (<span class="hljs-string">&quot;prepare_add_cond&quot;</span>, StableDiffusionXLImg2ImgPrepareAdditionalConditioningStep),
    (<span class="hljs-string">&quot;denoise&quot;</span>, StableDiffusionXLDenoiseStep),
    (<span class="hljs-string">&quot;decode&quot;</span>, StableDiffusionXLDecodeStep)
])`,wrap:!1}}),G=new m({props:{title:"管道和块状态",local:"管道和块状态",headingTag:"h2"}}),W=new m({props:{title:"自定义块",local:"自定义块",headingTag:"h2"}}),B=new y({props:{code:"ZGVub2lzZV9ibG9ja3MlMjAlM0QlMjBJTUFHRTJJTUFHRV9CTE9DS1MlNUIlMjJkZW5vaXNlJTIyJTVEKCklMEFwcmludChkZW5vaXNlX2Jsb2Nrcyk=",highlighted:`denoise_blocks = IMAGE2IMAGE_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>]()
<span class="hljs-built_in">print</span>(denoise_blocks)`,wrap:!1}}),S=new y({props:{code:"JTIzJTIwJUU1JUE0JThEJUU1JTg4JUI2JUU3JThFJUIwJUU2JTlDJTg5JUU1JTlEJTk3JUU0JUJEJTlDJUU0JUI4JUJBJUU1JThEJUEwJUU0JUJEJThEJUU3JUFDJUE2JTBBY2xhc3MlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAoTW9kdWxhclBpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkNvcGllZCUyMGZyb20lMjBTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQcmVwYXJlTGF0ZW50c1N0ZXAlMjAtJTIwd2lsbCUyMG1vZGlmeSUyMGxhdGVyJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTIwJUU0JUI4JThFJTIwU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUHJlcGFyZUxhdGVudHNTdGVwJTIwJUU3JTlCJUI4JUU1JTkwJThDJUU3JTlBJTg0JUU1JUFFJTlFJUU3JThFJUIwJTBBJTBBY2xhc3MlMjBTRFhMRGlmZkRpZmZEZW5vaXNlU3RlcChTdGFibGVEaWZmdXNpb25YTERlbm9pc2VMb29wV3JhcHBlciklM0ElMEElMjAlMjAlMjAlMjBibG9ja19jbGFzc2VzJTIwJTNEJTIwJTVCU0RYTERpZmZEaWZmTG9vcEJlZm9yZURlbm9pc2VyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExMb29wRGVub2lzZXIlMkMlMjBTdGFibGVEaWZmdXNpb25YTExvb3BBZnRlckRlbm9pc2VyJTVEJTBBJTIwJTIwJTIwJTIwYmxvY2tfbmFtZXMlMjAlM0QlMjAlNUIlMjJiZWZvcmVfZGVub2lzZXIlMjIlMkMlMjAlMjJkZW5vaXNlciUyMiUyQyUyMCUyMmFmdGVyX2Rlbm9pc2VyJTIyJTVE",highlighted:`<span class="hljs-comment"># 复制现有块作为占位符</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffPrepareLatentsStep</span>(<span class="hljs-title class_ inherited__">ModularPipelineBlocks</span>):
    <span class="hljs-string">&quot;&quot;&quot;Copied from StableDiffusionXLImg2ImgPrepareLatentsStep - will modify later&quot;&quot;&quot;</span>
    <span class="hljs-comment"># ... 与 StableDiffusionXLImg2ImgPrepareLatentsStep 相同的实现</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffDenoiseStep</span>(<span class="hljs-title class_ inherited__">StableDiffusionXLDenoiseLoopWrapper</span>):
    block_classes = [SDXLDiffDiffLoopBeforeDenoiser, StableDiffusionXLLoopDenoiser, StableDiffusionXLLoopAfterDenoiser]
    block_names = [<span class="hljs-string">&quot;before_denoiser&quot;</span>, <span class="hljs-string">&quot;denoiser&quot;</span>, <span class="hljs-string">&quot;after_denoiser&quot;</span>]`,wrap:!1}}),F=new m({props:{title:"prepare_latents",local:"preparelatents",headingTag:"h3"}}),Y=new y({props:{code:"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",highlighted:`class SDXLDiffDiffPrepareLatentsStep(ModularPipelineBlocks):
    @property
    def expected_components(self) -&gt; List[ComponentSpec]:
        return [
            ComponentSpec(&quot;vae&quot;, AutoencoderKL),
            ComponentSpec(&quot;scheduler&quot;, EulerDiscreteScheduler),
<span class="hljs-addition">+           ComponentSpec(&quot;mask_processor&quot;, VaeImageProcessor, config=FrozenDict({&quot;do_normalize&quot;: False, &quot;do_convert_grayscale&quot;: True}))</span>
        ]
    @property
    def inputs(self) -&gt; List[Tuple[str, Any]]:
        return [
            InputParam(&quot;generator&quot;),
<span class="hljs-addition">+           InputParam(&quot;diffdiff_map&quot;, required=True),</span>
<span class="hljs-deletion">-           InputParam(&quot;latent_timestep&quot;, required=True, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;timesteps&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;num_inference_steps&quot;, type_hint=int),</span>
        ]

    @property
    def intermediate_outputs(self) -&gt; List[OutputParam]:
        return [
<span class="hljs-addition">+           OutputParam(&quot;original_latents&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           OutputParam(&quot;diffdiff_masks&quot;, type_hint=torch.Tensor),</span>
        ]
    def __call__(self, components, state: PipelineState):
        # ... existing logic ...
<span class="hljs-addition">+       # Process change map and create masks</span>
<span class="hljs-addition">+       diffdiff_map = components.mask_processor.preprocess(block_state.diffdiff_map, height=latent_height, width=latent_width)</span>
<span class="hljs-addition">+       thresholds = torch.arange(block_state.num_inference_steps, dtype=diffdiff_map.dtype) / block_state.num_inference_steps</span>
<span class="hljs-addition">+       block_state.diffdiff_masks = diffdiff_map &gt; (thresholds + (block_state.denoising_start or 0))</span>
<span class="hljs-addition">+       block_state.original_latents = block_state.latents</span>`,wrap:!1}}),v=new m({props:{title:"去噪",local:"去噪",headingTag:"h3"}}),E=new y({props:{code:"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",highlighted:`class SDXLDiffDiffLoopBeforeDenoiser(ModularPipelineBlocks):
    @property
    def description(self) -&gt; str:
        return (
            &quot;Step within the denoising loop for differential diffusion that prepare the latent input for the denoiser&quot;
        )

    @property
    def inputs(self) -&gt; List[str]:
        return [
            InputParam(&quot;latents&quot;, required=True, type_hint=torch.Tensor),
<span class="hljs-addition">+           InputParam(&quot;denoising_start&quot;),</span>
<span class="hljs-addition">+           InputParam(&quot;original_latents&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;diffdiff_masks&quot;, type_hint=torch.Tensor),</span>
        ]

    def __call__(self, components, block_state, i, t):
<span class="hljs-addition">+       # Apply differential diffusion logic</span>
<span class="hljs-addition">+       if i == 0 and block_state.denoising_start is None:</span>
<span class="hljs-addition">+           block_state.latents = block_state.original_latents[:1]</span>
<span class="hljs-addition">+       else:</span>
<span class="hljs-addition">+           block_state.mask = block_state.diffdiff_masks[i].unsqueeze(0).unsqueeze(1)</span>
<span class="hljs-addition">+           block_state.latents = block_state.original_latents[i] * block_state.mask + block_state.latents * (1 - block_state.mask)</span>

        # ... rest of existing logic ...`,wrap:!1}}),L=new m({props:{title:"组装块",local:"组装块",headingTag:"h2"}}),q=new y({props:{code:"RElGRkRJRkZfQkxPQ0tTJTIwJTNEJTIwSU1BR0UySU1BR0VfQkxPQ0tTLmNvcHkoKSUwQURJRkZESUZGX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMjAlM0QlMjBURVhUMklNQUdFX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMEFESUZGRElGRl9CTE9DS1MlNUIlMjJwcmVwYXJlX2xhdGVudHMlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAlMEFESUZGRElGRl9CTE9DS1MlNUIlMjJkZW5vaXNlJTIyJTVEJTIwJTNEJTIwU0RYTERpZmZEaWZmRGVub2lzZVN0ZXAlMEElMEFkZF9ibG9ja3MlMjAlM0QlMjBTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MuZnJvbV9ibG9ja3NfZGljdChESUZGRElGRl9CTE9DS1MpJTBBcHJpbnQoZGRfYmxvY2tzKQ==",highlighted:`DIFFDIFF_BLOCKS = IMAGE2IMAGE_BLOCKS.copy()
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>] = TEXT2IMAGE_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>]
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = SDXLDiffDiffPrepareLatentsStep
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>] = SDXLDiffDiffDenoiseStep

dd_blocks = SequentialPipelineBlocks.from_blocks_dict(DIFFDIFF_BLOCKS)
<span class="hljs-built_in">print</span>(dd_blocks)`,wrap:!1}}),x=new m({props:{title:"ModularPipeline",local:"modularpipeline",headingTag:"h2"}}),O=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyMENvbXBvbmVudHNNYW5hZ2VyJTBBJTBBY29tcG9uZW50cyUyMCUzRCUyMENvbXBvbmVudE1hbmFnZXIoKSUwQSUwQWRkX3BpcGVsaW5lJTIwJTNEJTIwZGRfYmxvY2tzLmluaXRfcGlwZWxpbmUoJTIyWWlZaVh1JTJGbW9kdWxhci1kZW1vLWF1dG8lMjIlMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRfZGVmYXVsdF9jb21wb25lbmV0cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBZGRfcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> ComponentsManager

components = ComponentManager()

dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, components_manager=components, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_default_componenets(torch_dtype=torch.float16)
dd_pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),ll=new m({props:{title:"添加工作流",local:"添加工作流",headingTag:"h2"}}),sl=new m({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h3"}}),il=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsLmVuY29kZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvSVBBZGFwdGVyU3RlcCUwQSUwQWlwX2FkYXB0ZXJfYmxvY2slMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9JUEFkYXB0ZXJTdGVwKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl.encoders <span class="hljs-keyword">import</span> StableDiffusionXLAutoIPAdapterStep

ip_adapter_block = StableDiffusionXLAutoIPAdapterStep()`,wrap:!1}}),pl=new y({props:{code:"ZGRfYmxvY2tzLnN1Yl9ibG9ja3MuaW5zZXJ0KCUyMmlwX2FkYXB0ZXIlMjIlMkMlMjBpcF9hZGFwdGVyX2Jsb2NrJTJDJTIwMCk=",highlighted:'dd_blocks.sub_blocks.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, ip_adapter_block, <span class="hljs-number">0</span>)',wrap:!1}}),ol=new y({props:{code:"ZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9ibG9ja3MuaW5pdF9waXBlbGluZSglMjJZaVlpWHUlMkZtb2R1bGFyLWRlbW8tYXV0byUyMiUyQyUyMGNvbGxlY3Rpb24lM0QlMjJkaWZmZGlmZiUyMiklMEFkZF9waXBlbGluZS5sb2FkX2NvbXBvbmVudHModG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWRkX3BpcGVsaW5lLmxvYWRlci5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRlci5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYpJTBBZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9waXBlbGluZS50byhkZXZpY2UpJTBBJTBBaXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZkaWZmX29yYW5nZS5qcGVnJTIyKSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZPenp5R1QlMkZ0ZXN0aW5nLXJlc291cmNlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmVyZW50aWFsJTJGMjAyNDAzMjkyMTExMjlfNDAyNDkxMTkzMC5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIpJTBBbWFzayUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGT3p6eUdUJTJGdGVzdGluZy1yZXNvdXJjZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZlcmVudGlhbCUyRmdyYWRpZW50X21hc2sucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBncmVlbiUyMHBlYXIlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJibHVycnklMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEZGV2aWNlKS5tYW51YWxfc2VlZCg0MiklMEElMEFpbWFnZSUyMCUzRCUyMGRkX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpcF9hZGFwdGVyX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZGlmZmRpZmZfbWFwJTNEbWFzayUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMEFvdXRwdXQlM0QlMjJpbWFnZXMlMjIlMEEpJTVCMCU1RA==",highlighted:`dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_components(torch_dtype=torch.float16)
dd_pipeline.loader.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
dd_pipeline.loader.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)
dd_pipeline = dd_pipeline.to(device)

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/diffdiff_orange.jpeg&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/20240329211129_4024911930.png?download=true&quot;</span>)
mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/gradient_mask.png?download=true&quot;</span>)

prompt = <span class="hljs-string">&quot;a green pear&quot;</span>
negative_prompt = <span class="hljs-string">&quot;blurry&quot;</span>
generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)

image = dd_pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    ip_adapter_image=ip_adapter_image,
    diffdiff_map=mask,
    image=image,

output=<span class="hljs-string">&quot;images&quot;</span>
)[<span class="hljs-number">0</span>]`,wrap:!1}}),dl=new m({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),Jl=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsLm1vZHVsYXJfYmxvY2tzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvQ29udHJvbE5ldElucHV0U3RlcCUwQSUwQWNvbnRyb2xfaW5wdXRfYmxvY2slMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9Db250cm9sTmV0SW5wdXRTdGVwKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl.modular_blocks <span class="hljs-keyword">import</span> StableDiffusionXLAutoControlNetInputStep

control_input_block = StableDiffusionXLAutoControlNetInputStep()`,wrap:!1}}),yl=new y({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZDb250cm9sTmV0RGVub2lzZVN0ZXAoU3RhYmxlRGlmZnVzaW9uWExEZW5vaXNlTG9vcFdyYXBwZXIpJTNBJTBBJTIwJTIwJTIwJTIwYmxvY2tfY2xhc3NlcyUyMCUzRCUyMCU1QlNEWExEaWZmRGlmZkxvb3BCZWZvcmVEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldExvb3BEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVub2lzZUxvb3BBZnRlckRlbm9pc2VyJTVEJTBBJTIwJTIwJTIwJTIwYmxvY2tfbmFtZXMlMjAlM0QlMjAlNUIlMjJiZWZvcmVfZGVub2lzZXIlMjIlMkMlMjAlMjJkZW5vaXNlciUyMiUyQyUyMCUyMmFmdGVyX2Rlbm9pc2VyJTIyJTVEJTBBJTBBY29udHJvbG5ldF9kZW5vaXNlX2Jsb2NrJTIwJTNEJTIwU0RYTERpZmZEaWZmQ29udHJvbE5ldERlbm9pc2VTdGVwKCk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffControlNetDenoiseStep</span>(<span class="hljs-title class_ inherited__">StableDiffusionXLDenoiseLoopWrapper</span>):
    block_classes = [SDXLDiffDiffLoopBeforeDenoiser, StableDiffusionXLControlNetLoopDenoiser, StableDiffusionXLDenoiseLoopAfterDenoiser]
    block_names = [<span class="hljs-string">&quot;before_denoiser&quot;</span>, <span class="hljs-string">&quot;denoiser&quot;</span>, <span class="hljs-string">&quot;after_denoiser&quot;</span>]

controlnet_denoise_block = SDXLDiffDiffControlNetDenoiseStep()`,wrap:!1}}),fl=new y({props:{code:"ZGRfYmxvY2tzLnN1Yl9ibG9ja3MuaW5zZXJ0KCUyMmNvbnRyb2xuZXRfaW5wdXQlMjIlMkMlMjBjb250cm9sX2lucHV0X2Jsb2NrJTJDJTIwNyklMEFkZF9ibG9ja3Muc3ViX2Jsb2NrcyU1QiUyMmRlbm9pc2UlMjIlNUQlMjAlM0QlMjBjb250cm9sbmV0X2Rlbm9pc2VfYmxvY2slMEElMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX2Jsb2Nrcy5pbml0X3BpcGVsaW5lKCUyMllpWWlYdSUyRm1vZHVsYXItZGVtby1hdXRvJTIyJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRfY29tcG9uZW50cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9waXBlbGluZS50byhkZXZpY2UpJTBBJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZkaWZmX3RvbWF0b19jYW5ueS5qcGVnJTIyKSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZPenp5R1QlMkZ0ZXN0aW5nLXJlc291cmNlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmVyZW50aWFsJTJGMjAyNDAzMjkyMTExMjlfNDAyNDkxMTkzMC5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIpJTBBbWFzayUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGT3p6eUdUJTJGdGVzdGluZy1yZXNvdXJjZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZlcmVudGlhbCUyRmdyYWRpZW50X21hc2sucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBncmVlbiUyMHBlYXIlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJibHVycnklMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEZGV2aWNlKS5tYW51YWxfc2VlZCg0MiklMEElMEFpbWFnZSUyMCUzRCUyMGRkX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0Rjb250cm9sX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjBkaWZmZGlmZl9tYXAlM0RtYXNrJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dCUzRCUyMmltYWdlcyUyMiUwQSklNUIwJTVE",highlighted:`dd_blocks.sub_blocks.insert(<span class="hljs-string">&quot;controlnet_input&quot;</span>, control_input_block, <span class="hljs-number">7</span>)
dd_blocks.sub_blocks[<span class="hljs-string">&quot;denoise&quot;</span>] = controlnet_denoise_block

dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_components(torch_dtype=torch.float16)
dd_pipeline = dd_pipeline.to(device)

control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/diffdiff_tomato_canny.jpeg&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/20240329211129_4024911930.png?download=true&quot;</span>)
mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/gradient_mask.png?download=true&quot;</span>)

prompt = <span class="hljs-string">&quot;a green pear&quot;</span>
negative_prompt = <span class="hljs-string">&quot;blurry&quot;</span>
generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)

image = dd_pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    control_image=control_image,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
    diffdiff_map=mask,
    image=image,
    output=<span class="hljs-string">&quot;images&quot;</span>
)[<span class="hljs-number">0</span>]`,wrap:!1}}),ul=new m({props:{title:"AutoPipelineBlocks",local:"autopipelineblocks",headingTag:"h3"}}),wl=new y({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZBdXRvRGVub2lzZVN0ZXAoQXV0b1BpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMGJsb2NrX2NsYXNzZXMlMjAlM0QlMjAlNUJTRFhMRGlmZkRpZmZDb250cm9sTmV0RGVub2lzZVN0ZXAlMkMlMjBTRFhMRGlmZkRpZmZEZW5vaXNlU3RlcCU1RCUwQSUyMCUyMCUyMCUyMGJsb2NrX25hbWVzJTIwJTNEJTIwJTVCJTIyY29udHIlMEFvbG5ldF9kZW5vaXNlJTIyJTJDJTIwJTIyZGVub2lzZSUyMiU1RCUwQWJsb2NrX3RyaWdnZXJfaW5wdXRzJTIwJTNEJTIwJTVCJTIyY29udHJvbG5ldF9jb25kJTIyJTJDJTIwTm9uZSU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffAutoDenoiseStep</span>(<span class="hljs-title class_ inherited__">AutoPipelineBlocks</span>):
    block_classes = [SDXLDiffDiffControlNetDenoiseStep, SDXLDiffDiffDenoiseStep]
    block_names = [<span class="hljs-string">&quot;contr
olnet_denoise&quot;</span>, <span class="hljs-string">&quot;denoise&quot;</span>]
block_trigger_inputs = [<span class="hljs-string">&quot;controlnet_cond&quot;</span>, <span class="hljs-literal">None</span>]`,wrap:!1}}),Il=new y({props:{code:"RElGRkRJRkZfQVVUT19CTE9DS1MlMjAlM0QlMjBJTUFHRTJJTUFHRV9CTE9DS1MuY29weSgpJTBBRElGRkRJRkZfQVVUT19CTE9DS1MlNUIlMjJwcmVwYXJlX2xhdGVudHMlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAlMEFESUZGRElGRl9BVVRPX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMjAlM0QlMjBURVhUMklNQUdFX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMEFESUZGRElGRl9BVVRPX0JMT0NLUyU1QiUyMmRlbm9pc2UlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZBdXRvRGVub2lzZVN0ZXAlMEFESUZGRElGRl9BVVRPX0JMT0NLUy5pbnNlcnQoJTIyaXBfYWRhcHRlciUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMQXV0b0lQQWRhcHRlclN0ZXAlMkMlMjAwKSUwQURJRkZESUZGX0FVVE9fQkxPQ0tTLmluc2VydCglMjJjb250cm9sbmV0X2lucHV0JTIyJTJDU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0QXV0b0lucHV0JTJDJTIwNyk=",highlighted:`DIFFDIFF_AUTO_BLOCKS = IMAGE2IMAGE_BLOCKS.copy()
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = SDXLDiffDiffPrepareLatentsStep
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>] = TEXT2IMAGE_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>]
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>] = SDXLDiffDiffAutoDenoiseStep
DIFFDIFF_AUTO_BLOCKS.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, StableDiffusionXLAutoIPAdapterStep, <span class="hljs-number">0</span>)
DIFFDIFF_AUTO_BLOCKS.insert(<span class="hljs-string">&quot;controlnet_input&quot;</span>,StableDiffusionXLControlNetAutoInput, <span class="hljs-number">7</span>)`,wrap:!1}}),Cl=new y({props:{code:"ZGRfYXV0b19ibG9ja3MlMjAlM0QlMjBTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MuZnJvbV9ibG9ja3NfZGljdChESUZGRElGRl9BVVRPX0JMT0NLUyklMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX2F1dG9fYmxvY2tzLmluaXRfcGlwZWxpbmUoJTIyWWlZaVh1JTJGbW9kdWxhci1kZW1vLWF1dG8lMjIlMkMlMjBjb2xsZWN0aW9uJTNEJTIyZGlmZmRpZmYlMjIpJTBBZGRfcGlwZWxpbmUubG9hZF9jb21wb25lbnRzKHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNik=",highlighted:`dd_auto_blocks = SequentialPipelineBlocks.from_blocks_dict(DIFFDIFF_AUTO_BLOCKS)
dd_pipeline = dd_auto_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_components(torch_dtype=torch.float16)`,wrap:!1}}),Gl=new m({props:{title:"分享",local:"分享",headingTag:"h2"}}),_l=new y({props:{code:"ZGRfcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMllpWWlYdSUyRnRlc3RfbW9kdWxhcl9kb2MlMjIlMkMlMjBwdXNoX3RvX2h1YiUzRFRydWUp",highlighted:'dd_pipeline.save_pretrained(<span class="hljs-string">&quot;YiYiXu/test_modular_doc&quot;</span>, push_to_hub=<span class="hljs-literal">True</span>)',wrap:!1}}),Xl=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwTW9kdWxhclBpcGVsaW5lJTJDJTIwQ29tcG9uZW50c01hbmFnZXIlMEElMEFjb21wb25lbnRzJTIwJTNEJTIwQ29tcG9uZW50c01hbmFnZXIoKSUwQSUwQWRpZmZkaWZmX3BpcGVsaW5lJTIwJTNEJTIwTW9kdWxhclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJZaVlpWHUlMkZtb2R1bGFyLWRpZmZkaWZmLTA3MDQlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRpZmZkaWZmX3BpcGVsaW5lLmxvYWRfY29tcG9uZW50cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> ModularPipeline, ComponentsManager

components = ComponentsManager()

diffdiff_pipeline = ModularPipeline.from_pretrained(<span class="hljs-string">&quot;YiYiXu/modular-diffdiff-0704&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, components_manager=components, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
diffdiff_pipeline.load_components(torch_dtype=torch.float16)`,wrap:!1}}),hl=new Et({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/zh/modular_diffusers/quickstart.md"}}),{c(){f=a("meta"),Vl=n(),kl=a("p"),Sl=n(),o(u.$$.fragment),Fl=n(),r=a("p"),r.innerHTML=Ke,gl=n(),Z=a("p"),Z.innerHTML=Oe,$l=n(),o(w.$$.fragment),Yl=n(),b=a("p"),b.innerHTML=lt,vl=n(),I=a("ul"),I.innerHTML=et,Nl=n(),j=a("p"),j.innerHTML=tt,Ql=n(),o(C.$$.fragment),El=n(),o(G.$$.fragment),Ll=n(),R=a("p"),R.innerHTML=st,Dl=n(),_=a("ul"),_.innerHTML=nt,Al=n(),o(W.$$.fragment),Hl=n(),X=a("p"),X.innerHTML=it,zl=n(),h=a("p"),h.innerHTML=at,ql=n(),k=a("p"),k.innerHTML=pt,xl=n(),o(B.$$.fragment),Pl=n(),V=a("p"),V.innerHTML=Mt,Kl=n(),o(S.$$.fragment),Ol=n(),o(F.$$.fragment),le=n(),g=a("p"),g.innerHTML=ot,ee=n(),$=a("ul"),$.innerHTML=dt,te=n(),o(Y.$$.fragment),se=n(),o(v.$$.fragment),ne=n(),N=a("p"),N.innerHTML=ct,ie=n(),Q=a("ul"),Q.innerHTML=Jt,ae=n(),o(E.$$.fragment),pe=n(),o(L.$$.fragment),Me=n(),D=a("p"),D.innerHTML=Ut,oe=n(),A=a("p"),A.innerHTML=Tt,de=n(),H=a("p"),H.innerHTML=yt,ce=n(),z=a("p"),z.innerHTML=mt,Je=n(),o(q.$$.fragment),Ue=n(),o(x.$$.fragment),Te=n(),P=a("p"),P.innerHTML=ft,ye=n(),K=a("p"),K.innerHTML=ut,me=n(),o(O.$$.fragment),fe=n(),o(ll.$$.fragment),ue=n(),el=a("p"),el.innerHTML=rt,re=n(),tl=a("p"),tl.textContent=Zt,Ze=n(),o(sl.$$.fragment),we=n(),nl=a("p"),nl.textContent=wt,be=n(),o(il.$$.fragment),Ie=n(),al=a("p"),al.innerHTML=bt,je=n(),o(pl.$$.fragment),Ce=n(),Ml=a("p"),Ml.innerHTML=It,Ge=n(),o(ol.$$.fragment),Re=n(),o(dl.$$.fragment),_e=n(),cl=a("p"),cl.textContent=jt,We=n(),o(Jl.$$.fragment),Xe=n(),Ul=a("p"),Ul.innerHTML=Ct,he=n(),Tl=a("p"),Tl.innerHTML=Gt,ke=n(),o(yl.$$.fragment),Be=n(),ml=a("p"),ml.innerHTML=Rt,Ve=n(),o(fl.$$.fragment),Se=n(),o(ul.$$.fragment),Fe=n(),rl=a("p"),rl.innerHTML=_t,ge=n(),Zl=a("p"),Zl.innerHTML=Wt,$e=n(),o(wl.$$.fragment),Ye=n(),bl=a("p"),bl.innerHTML=Xt,ve=n(),o(Il.$$.fragment),Ne=n(),jl=a("p"),jl.innerHTML=ht,Qe=n(),o(Cl.$$.fragment),Ee=n(),o(Gl.$$.fragment),Le=n(),Rl=a("p"),Rl.innerHTML=kt,De=n(),o(_l.$$.fragment),Ae=n(),Wl=a("p"),Wl.innerHTML=Bt,He=n(),o(Xl.$$.fragment),ze=n(),o(hl.$$.fragment),qe=n(),Bl=a("p"),this.h()},l(l){const e=Nt("svelte-u9bgzb",document.head);f=p(e,"META",{name:!0,content:!0}),e.forEach(t),Vl=i(l),kl=p(l,"P",{}),Vt(kl).forEach(t),Sl=i(l),d(u.$$.fragment,l),Fl=i(l),r=p(l,"P",{"data-svelte-h":!0}),M(r)!=="svelte-ucrd7f"&&(r.innerHTML=Ke),gl=i(l),Z=p(l,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-19clyan"&&(Z.innerHTML=Oe),$l=i(l),d(w.$$.fragment,l),Yl=i(l),b=p(l,"P",{"data-svelte-h":!0}),M(b)!=="svelte-y1aqdp"&&(b.innerHTML=lt),vl=i(l),I=p(l,"UL",{"data-svelte-h":!0}),M(I)!=="svelte-18g1w9a"&&(I.innerHTML=et),Nl=i(l),j=p(l,"P",{"data-svelte-h":!0}),M(j)!=="svelte-iezqb2"&&(j.innerHTML=tt),Ql=i(l),d(C.$$.fragment,l),El=i(l),d(G.$$.fragment,l),Ll=i(l),R=p(l,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1otv6ps"&&(R.innerHTML=st),Dl=i(l),_=p(l,"UL",{"data-svelte-h":!0}),M(_)!=="svelte-si6ftt"&&(_.innerHTML=nt),Al=i(l),d(W.$$.fragment,l),Hl=i(l),X=p(l,"P",{"data-svelte-h":!0}),M(X)!=="svelte-16qzi9k"&&(X.innerHTML=it),zl=i(l),h=p(l,"P",{"data-svelte-h":!0}),M(h)!=="svelte-1k439co"&&(h.innerHTML=at),ql=i(l),k=p(l,"P",{"data-svelte-h":!0}),M(k)!=="svelte-166t11t"&&(k.innerHTML=pt),xl=i(l),d(B.$$.fragment,l),Pl=i(l),V=p(l,"P",{"data-svelte-h":!0}),M(V)!=="svelte-incjm4"&&(V.innerHTML=Mt),Kl=i(l),d(S.$$.fragment,l),Ol=i(l),d(F.$$.fragment,l),le=i(l),g=p(l,"P",{"data-svelte-h":!0}),M(g)!=="svelte-hb8wge"&&(g.innerHTML=ot),ee=i(l),$=p(l,"UL",{"data-svelte-h":!0}),M($)!=="svelte-1bfho3z"&&($.innerHTML=dt),te=i(l),d(Y.$$.fragment,l),se=i(l),d(v.$$.fragment,l),ne=i(l),N=p(l,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1ynz8xa"&&(N.innerHTML=ct),ie=i(l),Q=p(l,"UL",{"data-svelte-h":!0}),M(Q)!=="svelte-1htu88p"&&(Q.innerHTML=Jt),ae=i(l),d(E.$$.fragment,l),pe=i(l),d(L.$$.fragment,l),Me=i(l),D=p(l,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1km1h3v"&&(D.innerHTML=Ut),oe=i(l),A=p(l,"P",{"data-svelte-h":!0}),M(A)!=="svelte-y5ubni"&&(A.innerHTML=Tt),de=i(l),H=p(l,"P",{"data-svelte-h":!0}),M(H)!=="svelte-19jyxik"&&(H.innerHTML=yt),ce=i(l),z=p(l,"P",{"data-svelte-h":!0}),M(z)!=="svelte-waxhub"&&(z.innerHTML=mt),Je=i(l),d(q.$$.fragment,l),Ue=i(l),d(x.$$.fragment,l),Te=i(l),P=p(l,"P",{"data-svelte-h":!0}),M(P)!=="svelte-16lygjc"&&(P.innerHTML=ft),ye=i(l),K=p(l,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1pzhpdm"&&(K.innerHTML=ut),me=i(l),d(O.$$.fragment,l),fe=i(l),d(ll.$$.fragment,l),ue=i(l),el=p(l,"P",{"data-svelte-h":!0}),M(el)!=="svelte-c6u23w"&&(el.innerHTML=rt),re=i(l),tl=p(l,"P",{"data-svelte-h":!0}),M(tl)!=="svelte-142sjmv"&&(tl.textContent=Zt),Ze=i(l),d(sl.$$.fragment,l),we=i(l),nl=p(l,"P",{"data-svelte-h":!0}),M(nl)!=="svelte-5vsg4f"&&(nl.textContent=wt),be=i(l),d(il.$$.fragment,l),Ie=i(l),al=p(l,"P",{"data-svelte-h":!0}),M(al)!=="svelte-y5o3kn"&&(al.innerHTML=bt),je=i(l),d(pl.$$.fragment,l),Ce=i(l),Ml=p(l,"P",{"data-svelte-h":!0}),M(Ml)!=="svelte-g5lfhr"&&(Ml.innerHTML=It),Ge=i(l),d(ol.$$.fragment,l),Re=i(l),d(dl.$$.fragment,l),_e=i(l),cl=p(l,"P",{"data-svelte-h":!0}),M(cl)!=="svelte-1rwsayd"&&(cl.textContent=jt),We=i(l),d(Jl.$$.fragment,l),Xe=i(l),Ul=p(l,"P",{"data-svelte-h":!0}),M(Ul)!=="svelte-3tgsuz"&&(Ul.innerHTML=Ct),he=i(l),Tl=p(l,"P",{"data-svelte-h":!0}),M(Tl)!=="svelte-hilcpg"&&(Tl.innerHTML=Gt),ke=i(l),d(yl.$$.fragment,l),Be=i(l),ml=p(l,"P",{"data-svelte-h":!0}),M(ml)!=="svelte-h6ms15"&&(ml.innerHTML=Rt),Ve=i(l),d(fl.$$.fragment,l),Se=i(l),d(ul.$$.fragment,l),Fe=i(l),rl=p(l,"P",{"data-svelte-h":!0}),M(rl)!=="svelte-leu4qu"&&(rl.innerHTML=_t),ge=i(l),Zl=p(l,"P",{"data-svelte-h":!0}),M(Zl)!=="svelte-fep99f"&&(Zl.innerHTML=Wt),$e=i(l),d(wl.$$.fragment,l),Ye=i(l),bl=p(l,"P",{"data-svelte-h":!0}),M(bl)!=="svelte-12g6sja"&&(bl.innerHTML=Xt),ve=i(l),d(Il.$$.fragment,l),Ne=i(l),jl=p(l,"P",{"data-svelte-h":!0}),M(jl)!=="svelte-ccq5o3"&&(jl.innerHTML=ht),Qe=i(l),d(Cl.$$.fragment,l),Ee=i(l),d(Gl.$$.fragment,l),Le=i(l),Rl=p(l,"P",{"data-svelte-h":!0}),M(Rl)!=="svelte-133sy88"&&(Rl.innerHTML=kt),De=i(l),d(_l.$$.fragment,l),Ae=i(l),Wl=p(l,"P",{"data-svelte-h":!0}),M(Wl)!=="svelte-1nf3567"&&(Wl.innerHTML=Bt),He=i(l),d(Xl.$$.fragment,l),ze=i(l),d(hl.$$.fragment,l),qe=i(l),Bl=p(l,"P",{}),Vt(Bl).forEach(t),this.h()},h(){St(f,"name","hf:doc:metadata"),St(f,"content",Dt)},m(l,e){Qt(document.head,f),s(l,Vl,e),s(l,kl,e),s(l,Sl,e),c(u,l,e),s(l,Fl,e),s(l,r,e),s(l,gl,e),s(l,Z,e),s(l,$l,e),c(w,l,e),s(l,Yl,e),s(l,b,e),s(l,vl,e),s(l,I,e),s(l,Nl,e),s(l,j,e),s(l,Ql,e),c(C,l,e),s(l,El,e),c(G,l,e),s(l,Ll,e),s(l,R,e),s(l,Dl,e),s(l,_,e),s(l,Al,e),c(W,l,e),s(l,Hl,e),s(l,X,e),s(l,zl,e),s(l,h,e),s(l,ql,e),s(l,k,e),s(l,xl,e),c(B,l,e),s(l,Pl,e),s(l,V,e),s(l,Kl,e),c(S,l,e),s(l,Ol,e),c(F,l,e),s(l,le,e),s(l,g,e),s(l,ee,e),s(l,$,e),s(l,te,e),c(Y,l,e),s(l,se,e),c(v,l,e),s(l,ne,e),s(l,N,e),s(l,ie,e),s(l,Q,e),s(l,ae,e),c(E,l,e),s(l,pe,e),c(L,l,e),s(l,Me,e),s(l,D,e),s(l,oe,e),s(l,A,e),s(l,de,e),s(l,H,e),s(l,ce,e),s(l,z,e),s(l,Je,e),c(q,l,e),s(l,Ue,e),c(x,l,e),s(l,Te,e),s(l,P,e),s(l,ye,e),s(l,K,e),s(l,me,e),c(O,l,e),s(l,fe,e),c(ll,l,e),s(l,ue,e),s(l,el,e),s(l,re,e),s(l,tl,e),s(l,Ze,e),c(sl,l,e),s(l,we,e),s(l,nl,e),s(l,be,e),c(il,l,e),s(l,Ie,e),s(l,al,e),s(l,je,e),c(pl,l,e),s(l,Ce,e),s(l,Ml,e),s(l,Ge,e),c(ol,l,e),s(l,Re,e),c(dl,l,e),s(l,_e,e),s(l,cl,e),s(l,We,e),c(Jl,l,e),s(l,Xe,e),s(l,Ul,e),s(l,he,e),s(l,Tl,e),s(l,ke,e),c(yl,l,e),s(l,Be,e),s(l,ml,e),s(l,Ve,e),c(fl,l,e),s(l,Se,e),c(ul,l,e),s(l,Fe,e),s(l,rl,e),s(l,ge,e),s(l,Zl,e),s(l,$e,e),c(wl,l,e),s(l,Ye,e),s(l,bl,e),s(l,ve,e),c(Il,l,e),s(l,Ne,e),s(l,jl,e),s(l,Qe,e),c(Cl,l,e),s(l,Ee,e),c(Gl,l,e),s(l,Le,e),s(l,Rl,e),s(l,De,e),c(_l,l,e),s(l,Ae,e),s(l,Wl,e),s(l,He,e),c(Xl,l,e),s(l,ze,e),c(hl,l,e),s(l,qe,e),s(l,Bl,e),xe=!0},p:gt,i(l){xe||(J(u.$$.fragment,l),J(w.$$.fragment,l),J(C.$$.fragment,l),J(G.$$.fragment,l),J(W.$$.fragment,l),J(B.$$.fragment,l),J(S.$$.fragment,l),J(F.$$.fragment,l),J(Y.$$.fragment,l),J(v.$$.fragment,l),J(E.$$.fragment,l),J(L.$$.fragment,l),J(q.$$.fragment,l),J(x.$$.fragment,l),J(O.$$.fragment,l),J(ll.$$.fragment,l),J(sl.$$.fragment,l),J(il.$$.fragment,l),J(pl.$$.fragment,l),J(ol.$$.fragment,l),J(dl.$$.fragment,l),J(Jl.$$.fragment,l),J(yl.$$.fragment,l),J(fl.$$.fragment,l),J(ul.$$.fragment,l),J(wl.$$.fragment,l),J(Il.$$.fragment,l),J(Cl.$$.fragment,l),J(Gl.$$.fragment,l),J(_l.$$.fragment,l),J(Xl.$$.fragment,l),J(hl.$$.fragment,l),xe=!0)},o(l){U(u.$$.fragment,l),U(w.$$.fragment,l),U(C.$$.fragment,l),U(G.$$.fragment,l),U(W.$$.fragment,l),U(B.$$.fragment,l),U(S.$$.fragment,l),U(F.$$.fragment,l),U(Y.$$.fragment,l),U(v.$$.fragment,l),U(E.$$.fragment,l),U(L.$$.fragment,l),U(q.$$.fragment,l),U(x.$$.fragment,l),U(O.$$.fragment,l),U(ll.$$.fragment,l),U(sl.$$.fragment,l),U(il.$$.fragment,l),U(pl.$$.fragment,l),U(ol.$$.fragment,l),U(dl.$$.fragment,l),U(Jl.$$.fragment,l),U(yl.$$.fragment,l),U(fl.$$.fragment,l),U(ul.$$.fragment,l),U(wl.$$.fragment,l),U(Il.$$.fragment,l),U(Cl.$$.fragment,l),U(Gl.$$.fragment,l),U(_l.$$.fragment,l),U(Xl.$$.fragment,l),U(hl.$$.fragment,l),xe=!1},d(l){l&&(t(Vl),t(kl),t(Sl),t(Fl),t(r),t(gl),t(Z),t($l),t(Yl),t(b),t(vl),t(I),t(Nl),t(j),t(Ql),t(El),t(Ll),t(R),t(Dl),t(_),t(Al),t(Hl),t(X),t(zl),t(h),t(ql),t(k),t(xl),t(Pl),t(V),t(Kl),t(Ol),t(le),t(g),t(ee),t($),t(te),t(se),t(ne),t(N),t(ie),t(Q),t(ae),t(pe),t(Me),t(D),t(oe),t(A),t(de),t(H),t(ce),t(z),t(Je),t(Ue),t(Te),t(P),t(ye),t(K),t(me),t(fe),t(ue),t(el),t(re),t(tl),t(Ze),t(we),t(nl),t(be),t(Ie),t(al),t(je),t(Ce),t(Ml),t(Ge),t(Re),t(_e),t(cl),t(We),t(Xe),t(Ul),t(he),t(Tl),t(ke),t(Be),t(ml),t(Ve),t(Se),t(Fe),t(rl),t(ge),t(Zl),t($e),t(Ye),t(bl),t(ve),t(Ne),t(jl),t(Qe),t(Ee),t(Le),t(Rl),t(De),t(Ae),t(Wl),t(He),t(ze),t(qe),t(Bl)),t(f),T(u,l),T(w,l),T(C,l),T(G,l),T(W,l),T(B,l),T(S,l),T(F,l),T(Y,l),T(v,l),T(E,l),T(L,l),T(q,l),T(x,l),T(O,l),T(ll,l),T(sl,l),T(il,l),T(pl,l),T(ol,l),T(dl,l),T(Jl,l),T(yl,l),T(fl,l),T(ul,l),T(wl,l),T(Il,l),T(Cl,l),T(Gl,l),T(_l,l),T(Xl,l),T(hl,l)}}}const Dt='{"title":"快速入门","local":"快速入门","sections":[{"title":"ModularPipelineBlocks","local":"modularpipelineblocks","sections":[],"depth":2},{"title":"管道和块状态","local":"管道和块状态","sections":[],"depth":2},{"title":"自定义块","local":"自定义块","sections":[{"title":"prepare_latents","local":"preparelatents","sections":[],"depth":3},{"title":"去噪","local":"去噪","sections":[],"depth":3}],"depth":2},{"title":"组装块","local":"组装块","sections":[],"depth":2},{"title":"ModularPipeline","local":"modularpipeline","sections":[],"depth":2},{"title":"添加工作流","local":"添加工作流","sections":[{"title":"IP-Adapter","local":"ip-adapter","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3},{"title":"AutoPipelineBlocks","local":"autopipelineblocks","sections":[],"depth":3}],"depth":2},{"title":"分享","local":"分享","sections":[],"depth":2}],"depth":1}';function At(Pe){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pt extends Yt{constructor(f){super(),vt(this,f,At,Lt,Ft,{})}}export{Pt as component};
