import{s as il,n as ml,o as cl}from"../chunks/scheduler.ed14c3fe.js";import{S as ol,i as Ml,e as p,s as n,c,h as ul,a as i,d as t,b as a,f as U,g as o,j as m,k as xs,l as h,m as l,n as M,t as u,o as d,p as r}from"../chunks/index.0eb90eca.js";import{C as g}from"../chunks/CodeBlock.c826eb2a.js";import{D as dl}from"../chunks/DocNotebookDropdown.21742870.js";import{H as $,E as rl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.432ceae3.js";function hl(ft){let f,As,zs,qs,Z,Ps,v,Os,_,Jt="🧨 Diffusers는 사용자 친화적이며 유연한 도구 상자로, 사용사례에 맞게 diffusion 시스템을 구축 할 수 있도록 설계되었습니다. 이 도구 상자의 핵심은 모델과 스케줄러입니다. <code>DiffusionPipeline</code>은 편의를 위해 이러한 구성 요소를 번들로 제공하지만, 파이프라인을 분리하고 모델과 스케줄러를 개별적으로 사용해 새로운 diffusion 시스템을 만들 수도 있습니다.",Ks,k,yt="이 튜토리얼에서는 기본 파이프라인부터 시작해 Stable Diffusion 파이프라인까지 진행하며 모델과 스케줄러를 사용해 추론을 위한 diffusion 시스템을 조립하는 방법을 배웁니다.",se,I,ee,R,Tt="파이프라인은 추론을 위해 모델을 실행하는 빠르고 쉬운 방법으로, 이미지를 생성하는 데 코드가 4줄 이상 필요하지 않습니다:",te,Q,le,T,wt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ddpm-cat.png" alt="Image of cat created from DDPMPipeline"/>',ne,G,Ct="정말 쉽습니다. 그런데 파이프라인은 어떻게 이렇게 할 수 있었을까요? 파이프라인을 세분화하여 내부에서 어떤 일이 일어나고 있는지 살펴보겠습니다.",ae,W,Vt="위 예시에서 파이프라인에는 <code>UNet2DModel</code> 모델과 <code>DDPMScheduler</code>가 포함되어 있습니다. 파이프라인은 원하는 출력 크기의 랜덤 노이즈를 받아 모델을 여러번 통과시켜 이미지의 노이즈를 제거합니다. 각 timestep에서 모델은 <em>noise residual</em>을 예측하고 스케줄러는 이를 사용하여 노이즈가 적은 이미지를 예측합니다. 파이프라인은 지정된 추론 스텝수에 도달할 때까지 이 과정을 반복합니다.",pe,x,$t="모델과 스케줄러를 별도로 사용하여 파이프라인을 다시 생성하기 위해 자체적인 노이즈 제거 프로세스를 작성해 보겠습니다.",ie,b,N,Ns,Zt="모델과 스케줄러를 불러옵니다:",it,E,mt,X,Es,vt="노이즈 제거 프로세스를 실행할 timestep 수를 설정합니다:",ct,B,ot,F,Xs,_t="스케줄러의 timestep을 설정하면 균등한 간격의 구성 요소를 가진 텐서가 생성됩니다.(이 예시에서는 50개) 각 요소는 모델이 이미지의 노이즈를 제거하는 시간 간격에 해당합니다. 나중에 노이즈 제거 루프를 만들 때 이 텐서를 반복하여 이미지의 노이즈를 제거합니다:",Mt,S,ut,H,Bs,kt="원하는 출력과 같은 모양을 가진 랜덤 노이즈를 생성합니다:",dt,L,rt,J,Fs,It="이제 timestep을 반복하는 루프를 작성합니다. 각 timestep에서 모델은 <code>UNet2DModel.forward()</code>를 통해 noisy residual을 반환합니다. 스케줄러의 <code>step()</code> 메서드는 noisy residual, timestep, 그리고 입력을 받아 이전 timestep에서 이미지를 예측합니다. 이 출력은 노이즈 제거 루프의 모델에 대한 다음 입력이 되며, <code>timesteps</code> 배열의 끝에 도달할 때까지 반복됩니다.",ht,D,gt,Ss,Rt="이것이 전체 노이즈 제거 프로세스이며, 동일한 패턴을 사용해 모든 diffusion 시스템을 작성할 수 있습니다.",bt,z,Hs,Qt="마지막 단계는 노이즈가 제거된 출력을 이미지로 변환하는 것입니다:",jt,Y,me,A,Gt="다음 섹션에서는 여러분의 기술을 시험해보고 좀 더 복잡한 Stable Diffusion 파이프라인을 분석해 보겠습니다. 방법은 거의 동일합니다. 필요한 구성요소들을 초기화하고 timestep수를 설정하여 <code>timestep</code> 배열을 생성합니다. 노이즈 제거 루프에서 <code>timestep</code> 배열이 사용되며, 이 배열의 각 요소에 대해 모델은 노이즈가 적은 이미지를 예측합니다. 노이즈 제거 루프는 <code>timestep</code>을 반복하고 각 timestep에서 noise residual을 출력하고 스케줄러는 이를 사용하여 이전 timestep에서 노이즈가 덜한 이미지를 예측합니다. 이 프로세스는 <code>timestep</code> 배열의 끝에 도달할 때까지 반복됩니다.",ce,q,Wt="한번 사용해 봅시다!",oe,P,Me,O,xt="Stable Diffusion 은 text-to-image <em>latent diffusion</em> 모델입니다. latent diffusion 모델이라고 불리는 이유는 실제 픽셀 공간 대신 이미지의 저차원의 표현으로 작업하기 때문이고, 메모리 효율이 더 높습니다. 인코더는 이미지를 더 작은 표현으로 압축하고, 디코더는 압축된 표현을 다시 이미지로 변환합니다. text-to-image 모델의 경우 텍스트 임베딩을 생성하기 위해 tokenizer와 인코더가 필요합니다. 이전 예제에서 이미 UNet 모델과 스케줄러가 필요하다는 것은 알고 계셨을 것입니다.",ue,K,Nt="보시다시피, 이것은 UNet 모델만 포함된 DDPM 파이프라인보다 더 복잡합니다. Stable Diffusion 모델에는 세 개의 개별 사전학습된 모델이 있습니다.",de,w,Et='<p>💡 VAE, UNet 및 텍스트 인코더 모델의 작동방식에 대한 자세한 내용은 <a href="https://huggingface.co/blog/stable_diffusion#how-does-stable-diffusion-work" rel="nofollow">How does Stable Diffusion work?</a> 블로그를 참조하세요.</p>',re,ss,Xt='이제 Stable Diffusion 파이프라인에 필요한 구성요소들이 무엇인지 알았으니, <code>from_pretrained()</code> 메서드를 사용해 모든 구성요소를 불러옵니다. 사전학습된 체크포인트 <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a>에서 찾을 수 있으며, 각 구성요소들은 별도의 하위 폴더에 저장되어 있습니다:',he,es,ge,ts,Bt="기본 <code>PNDMScheduler</code> 대신, <code>UniPCMultistepScheduler</code>로 교체하여 다른 스케줄러를 얼마나 쉽게 연결할 수 있는지 확인합니다:",be,ls,je,ns,Ft="추론 속도를 높이려면 스케줄러와 달리 학습 가능한 가중치가 있으므로 모델을 GPU로 옮기세요:",Ue,as,fe,ps,Je,is,St="다음 단계는 임베딩을 생성하기 위해 텍스트를 토큰화하는 것입니다. 이 텍스트는 UNet 모델에서 condition으로 사용되고 입력 프롬프트와 유사한 방향으로 diffusion 프로세스를 조정하는 데 사용됩니다.",ye,C,Ht="<p>💡 <code>guidance_scale</code> 매개변수는 이미지를 생성할 때 프롬프트에 얼마나 많은 가중치를 부여할지 결정합니다.</p>",Te,ms,Lt="다른 프롬프트를 생성하고 싶다면 원하는 프롬프트를 자유롭게 선택하세요!",we,cs,Ce,os,Dt="텍스트를 토큰화하고 프롬프트에서 임베딩을 생성합니다:",Ve,Ms,$e,us,zt="또한 패딩 토큰의 임베딩인 <em>unconditional 텍스트 임베딩</em>을 생성해야 합니다. 이 임베딩은 조건부 <code>text_embeddings</code>과 동일한 shape(<code>batch_size</code> 그리고 <code>seq_length</code>)을 가져야 합니다:",Ze,ds,ve,rs,Yt="두번의 forward pass를 피하기 위해 conditional 임베딩과 unconditional 임베딩을 배치(batch)로 연결하겠습니다:",_e,hs,ke,gs,Ie,bs,At="그다음 diffusion 프로세스의 시작점으로 초기 랜덤 노이즈를 생성합니다. 이것이 이미지의 잠재적 표현이며 점차적으로 노이즈가 제거됩니다. 이 시점에서 <code>latent</code> 이미지는 최종 이미지 크기보다 작지만 나중에 모델이 이를 512x512 이미지 크기로 변환하므로 괜찮습니다.",Re,y,Ls,qt="💡 <code>vae</code> 모델에는 3개의 다운 샘플링 레이어가 있기 때문에 높이와 너비가 8로 나뉩니다. 다음을 실행하여 확인할 수 있습니다:",Ut,js,Qe,Us,Ge,fs,We,Js,Pt="먼저 <code>UniPCMultistepScheduler</code>와 같은 향상된 스케줄러에 필요한 노이즈 스케일 값인 초기 노이즈 분포 <em>sigma</em> 로 입력을 스케일링 하는 것부터 시작합니다:",xe,ys,Ne,Ts,Ot="마지막 단계는 <code>latent</code>의 순수한 노이즈를 점진적으로 프롬프트에 설명된 이미지로 변환하는 노이즈 제거 루프를 생성하는 것입니다. 노이즈 제거 루프는 세 가지 작업을 수행해야 한다는 점을 기억하세요:",Ee,ws,Kt="<li>노이즈 제거 중에 사용할 스케줄러의 timesteps를 설정합니다.</li> <li>timestep을 따라 반복합니다.</li> <li>각 timestep에서 UNet 모델을 호출하여 noise residual을 예측하고 스케줄러에 전달하여 이전 노이즈 샘플을 계산합니다.</li>",Xe,Cs,Be,Vs,Fe,$s,sl="마지막 단계는 <code>vae</code>를 이용하여 잠재 표현을 이미지로 디코딩하고 <code>sample</code>과 함께 디코딩된 출력을 얻는 것입니다:",Se,Zs,He,vs,el="마지막으로 이미지를 <code>PIL.Image</code>로 변환하면 생성된 이미지를 확인할 수 있습니다!",Le,_s,De,V,tl='<img src="https://huggingface.co/blog/assets/98_stable_diffusion/stable_diffusion_k_lms.png"/>',ze,ks,Ye,Is,ll="기본 파이프라인부터 복잡한 파이프라인까지, 자신만의 diffusion 시스템을 작성하는 데 필요한 것은 노이즈 제거 루프뿐이라는 것을 알 수 있었습니다. 이 루프는 스케줄러의 timesteps를 설정하고, 이를 반복하며, UNet 모델을 호출하여 noise residual을 예측하고 스케줄러에 전달하여 이전 노이즈 샘플을 계산하는 과정을 번갈아 가며 수행해야 합니다.",Ae,Rs,nl="이것이 바로 🧨 Diffusers가 설계된 목적입니다: 모델과 스케줄러를 사용해 자신만의 diffusion 시스템을 직관적이고 쉽게 작성할 수 있도록 하기 위해서입니다.",qe,Qs,al="다음 단계를 자유롭게 진행하세요:",Pe,Gs,pl='<li>🧨 Diffusers에 <a href="using-diffusers/#contribute_pipeline">파이프라인 구축 및 기여</a>하는 방법을 알아보세요. 여러분이 어떤 아이디어를 내놓을지 기대됩니다!</li> <li>라이브러리에서 <a href="./api/pipelines/overview">기본 파이프라인</a>을 살펴보고, 모델과 스케줄러를 별도로 사용하여 파이프라인을 처음부터 해체하고 빌드할 수 있는지 확인해 보세요.</li>',Oe,Ws,Ke,Ys,st;return Z=new $({props:{title:"파이프라인, 모델 및 스케줄러 이해하기",local:"파이프라인-모델-및-스케줄러-이해하기",headingTag:"h1"}}),v=new dl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/write_own_pipeline.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/write_own_pipeline.ipynb"}]}}),I=new $({props:{title:"기본 파이프라인 해체하기",local:"기본-파이프라인-해체하기",headingTag:"h2"}}),Q=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQSUwQWRkcG0lMjAlM0QlMjBERFBNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMikudG8oJTIyY3VkYSUyMiklMEFpbWFnZSUyMCUzRCUyMGRkcG0obnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>ddpm = DDPMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = ddpm(num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),E=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMkMlMjBVTmV0MkRNb2RlbCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiklMEFtb2RlbCUyMCUzRCUyMFVOZXQyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNhdC0yNTYlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDPMScheduler.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),B=new g({props:{code:"c2NoZWR1bGVyLnNldF90aW1lc3RlcHMoNTAp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(<span class="hljs-number">50</span>)',wrap:!1}}),S=new g({props:{code:"c2NoZWR1bGVyLnRpbWVzdGVwcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.timesteps
tensor([<span class="hljs-number">980</span>, <span class="hljs-number">960</span>, <span class="hljs-number">940</span>, <span class="hljs-number">920</span>, <span class="hljs-number">900</span>, <span class="hljs-number">880</span>, <span class="hljs-number">860</span>, <span class="hljs-number">840</span>, <span class="hljs-number">820</span>, <span class="hljs-number">800</span>, <span class="hljs-number">780</span>, <span class="hljs-number">760</span>, <span class="hljs-number">740</span>, <span class="hljs-number">720</span>,
    <span class="hljs-number">700</span>, <span class="hljs-number">680</span>, <span class="hljs-number">660</span>, <span class="hljs-number">640</span>, <span class="hljs-number">620</span>, <span class="hljs-number">600</span>, <span class="hljs-number">580</span>, <span class="hljs-number">560</span>, <span class="hljs-number">540</span>, <span class="hljs-number">520</span>, <span class="hljs-number">500</span>, <span class="hljs-number">480</span>, <span class="hljs-number">460</span>, <span class="hljs-number">440</span>,
    <span class="hljs-number">420</span>, <span class="hljs-number">400</span>, <span class="hljs-number">380</span>, <span class="hljs-number">360</span>, <span class="hljs-number">340</span>, <span class="hljs-number">320</span>, <span class="hljs-number">300</span>, <span class="hljs-number">280</span>, <span class="hljs-number">260</span>, <span class="hljs-number">240</span>, <span class="hljs-number">220</span>, <span class="hljs-number">200</span>, <span class="hljs-number">180</span>, <span class="hljs-number">160</span>,
    <span class="hljs-number">140</span>, <span class="hljs-number">120</span>, <span class="hljs-number">100</span>,  <span class="hljs-number">80</span>,  <span class="hljs-number">60</span>,  <span class="hljs-number">40</span>,  <span class="hljs-number">20</span>,   <span class="hljs-number">0</span>])`,wrap:!1}}),L=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFzYW1wbGVfc2l6ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5zYW1wbGVfc2l6ZSUwQW5vaXNlJTIwJTNEJTIwdG9yY2gucmFuZG4oKDElMkMlMjAzJTJDJTIwc2FtcGxlX3NpemUlMkMlMjBzYW1wbGVfc2l6ZSklMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_size = model.config.sample_size
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, sample_size, sample_size), device=<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),D=new g({props:{code:"aW5wdXQlMjAlM0QlMjBub2lzZSUwQSUwQWZvciUyMHQlMjBpbiUyMHNjaGVkdWxlci50aW1lc3RlcHMlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9pc3lfcmVzaWR1YWwlMjAlM0QlMjBtb2RlbChpbnB1dCUyQyUyMHQpLnNhbXBsZSUwQSUyMCUyMCUyMCUyMHByZXZpb3VzX25vaXN5X3NhbXBsZSUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXN5X3Jlc2lkdWFsJTJDJTIwdCUyQyUyMGlucHV0KS5wcmV2X3NhbXBsZSUwQSUyMCUyMCUyMCUyMGlucHV0JTIwJTNEJTIwcHJldmlvdXNfbm9pc3lfc2FtcGxl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span> = noise

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> scheduler.timesteps:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noisy_residual = model(<span class="hljs-built_in">input</span>, t).sample
<span class="hljs-meta">... </span>    previous_noisy_sample = scheduler.step(noisy_residual, t, <span class="hljs-built_in">input</span>).prev_sample
<span class="hljs-meta">... </span>    <span class="hljs-built_in">input</span> = previous_noisy_sample`,wrap:!1}}),Y=new g({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBaW1hZ2UlMjAlM0QlMjAoaW5wdXQlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSklMEFpbWFnZSUyMCUzRCUyMGltYWdlLmNwdSgpLnBlcm11dGUoMCUyQyUyMDIlMkMlMjAzJTJDJTIwMSkubnVtcHkoKSU1QjAlNUQlMEFpbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheSgoaW1hZ2UlMjAqJTIwMjU1KS5yb3VuZCgpLmFzdHlwZSglMjJ1aW50OCUyMikpJTBBaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>image = (<span class="hljs-built_in">input</span> / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image.cpu().permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>).numpy()[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray((image * <span class="hljs-number">255</span>).<span class="hljs-built_in">round</span>().astype(<span class="hljs-string">&quot;uint8&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),P=new $({props:{title:"Stable Diffusion 파이프라인 해체하기",local:"stable-diffusion-파이프라인-해체하기",headingTag:"h2"}}),es=new g({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFRleHRNb2RlbCUyQyUyMENMSVBUb2tlbml6ZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTCUyQyUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTJDJTIwUE5ETVNjaGVkdWxlciUwQSUwQXZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyS0wuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ2YWUlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQ0xJUFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnRva2VuaXplciUyMiklMEF0ZXh0X2VuY29kZXIlMjAlM0QlMjBDTElQVGV4dE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyJTIyKSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel, CLIPTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL, UNet2DConditionModel, PNDMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;vae&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CLIPTokenizer.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder = CLIPTextModel.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),ls=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBJTBBc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = UniPCMultistepScheduler.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),as=new g({props:{code:"dG9yY2hfZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQXZhZS50byh0b3JjaF9kZXZpY2UpJTBBdGV4dF9lbmNvZGVyLnRvKHRvcmNoX2RldmljZSklMEF1bmV0LnRvKHRvcmNoX2RldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch_device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet.to(torch_device)`,wrap:!1}}),ps=new $({props:{title:"텍스트 임베딩 생성하기",local:"텍스트-임베딩-생성하기",headingTag:"h3"}}),cs=new g({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIyYSUyMHBob3RvZ3JhcGglMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIyJTVEJTBBaGVpZ2h0JTIwJTNEJTIwNTEyJTIwJTIwJTIzJTIwU3RhYmxlJTIwRGlmZnVzaW9uJUVDJTlEJTk4JTIwJUVBJUI4JUIwJUVCJUIzJUI4JTIwJUVCJTg2JTkyJUVDJTlEJUI0JTBBd2lkdGglMjAlM0QlMjA1MTIlMjAlMjAlMjMlMjBTdGFibGUlMjBEaWZmdXNpb24lRUMlOUQlOTglMjAlRUElQjglQjAlRUIlQjMlQjglMjAlRUIlODQlODglRUIlQjklODQlMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwMjUlMjAlMjAlMjMlMjAlRUIlODUlQjglRUMlOUQlQjQlRUMlQTYlODglMjAlRUMlQTAlOUMlRUElQjElQjAlMjAlRUMlOEElQTQlRUQlODUlOUQlMjAlRUMlODglOTglMEFndWlkYW5jZV9zY2FsZSUyMCUzRCUyMDcuNSUyMCUyMCUyMyUyMGNsYXNzaWZpZXItZnJlZSUyMGd1aWRhbmNlJUVCJUE1JUJDJTIwJUVDJTlDJTg0JUVEJTk1JTlDJTIwc2NhbGUlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUyMCUyMCUyMyUyMCVFQyVCNCU4OCVFQSVCOCVCMCUyMCVFQyU5RSVBMCVFQyU5RSVBQyUyMCVFQiU4NSVCOCVFQyU5RCVCNCVFQyVBNiU4OCVFQiVBNSVCQyUyMCVFQyU4MyU5RCVFQyU4NCVCMSVFRCU5NSU5OCVFQiU4QSU5NCUyMHNlZWQlMjBnZW5lcmF0b3IlMEFiYXRjaF9zaXplJTIwJTNEJTIwbGVuKHByb21wdCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;a photograph of an astronaut riding a horse&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>height = <span class="hljs-number">512</span>  <span class="hljs-comment"># Stable Diffusion의 기본 높이</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>width = <span class="hljs-number">512</span>  <span class="hljs-comment"># Stable Diffusion의 기본 너비</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">25</span>  <span class="hljs-comment"># 노이즈 제거 스텝 수</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_scale = <span class="hljs-number">7.5</span>  <span class="hljs-comment"># classifier-free guidance를 위한 scale</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># 초기 잠재 노이즈를 생성하는 seed generator</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-built_in">len</span>(prompt)`,wrap:!1}}),Ms=new g({props:{code:"dGV4dF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0R0b2tlbml6ZXIubW9kZWxfbWF4X2xlbmd0aCUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdGV4dF9lbmNvZGVyKHRleHRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_input = tokenizer(
<span class="hljs-meta">... </span>    prompt, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=tokenizer.model_max_length, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    text_embeddings = text_encoder(text_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`,wrap:!1}}),ds=new g({props:{code:"bWF4X2xlbmd0aCUyMCUzRCUyMHRleHRfaW5wdXQuaW5wdXRfaWRzLnNoYXBlJTVCLTElNUQlMEF1bmNvbmRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyJTIyJTVEJTIwKiUyMGJhdGNoX3NpemUlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0RtYXhfbGVuZ3RoJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF1bmNvbmRfZW1iZWRkaW5ncyUyMCUzRCUyMHRleHRfZW5jb2Rlcih1bmNvbmRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>max_length = text_input.input_ids.shape[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_input = tokenizer([<span class="hljs-string">&quot;&quot;</span>] * batch_size, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=max_length, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_embeddings = text_encoder(uncond_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`,wrap:!1}}),hs=new g({props:{code:"dGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2guY2F0KCU1QnVuY29uZF9lbWJlZGRpbmdzJTJDJTIwdGV4dF9lbWJlZGRpbmdzJTVEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>text_embeddings = torch.cat([uncond_embeddings, text_embeddings])',wrap:!1}}),gs=new $({props:{title:"랜덤 노이즈 생성",local:"랜덤-노이즈-생성",headingTag:"h3"}}),js=new g({props:{code:"MiUyMCoqJTIwKGxlbih2YWUuY29uZmlnLmJsb2NrX291dF9jaGFubmVscyklMjAtJTIwMSklMjAlM0QlM0QlMjA4",highlighted:'<span class="hljs-number">2</span> ** (<span class="hljs-built_in">len</span>(vae.config.block_out_channels) - <span class="hljs-number">1</span>) == <span class="hljs-number">8</span>',wrap:!1}}),Us=new g({props:{code:"bGF0ZW50cyUyMCUzRCUyMHRvcmNoLnJhbmRuKCUwQSUyMCUyMCUyMCUyMChiYXRjaF9zaXplJTJDJTIwdW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBoZWlnaHQlMjAlMkYlMkYlMjA4JTJDJTIwd2lkdGglMjAlMkYlMkYlMjA4KSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRHRvcmNoX2RldmljZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>latents = torch.randn(
<span class="hljs-meta">... </span>    (batch_size, unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    device=torch_device,
<span class="hljs-meta">... </span>)`,wrap:!1}}),fs=new $({props:{title:"이미지 노이즈 제거",local:"이미지-노이즈-제거",headingTag:"h3"}}),ys=new g({props:{code:"bGF0ZW50cyUyMCUzRCUyMGxhdGVudHMlMjAqJTIwc2NoZWR1bGVyLmluaXRfbm9pc2Vfc2lnbWE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>latents = latents * scheduler.init_noise_sigma',wrap:!1}}),Cs=new g({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFzY2hlZHVsZXIuc2V0X3RpbWVzdGVwcyhudW1faW5mZXJlbmNlX3N0ZXBzKSUwQSUwQWZvciUyMHQlMjBpbiUyMHRxZG0oc2NoZWR1bGVyLnRpbWVzdGVwcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBjbGFzc2lmaWVyLWZyZWUlMjBndWlkYW5jZSVFQiVBNSVCQyUyMCVFQyU4OCU5OCVFRCU5NiU4OSVFRCU5NSU5OCVFQiU4QSU5NCUyMCVFQSVCMiVCRCVFQyU5QSVCMCUyMCVFQiU5MSU5MCVFQiVCMiU4OCVFQyU5RCU5OCUyMGZvcndhcmQlMjBwYXNzJUVCJUE1JUJDJTIwJUVDJTg4JTk4JUVEJTk2JTg5JUVEJTk1JTk4JUVDJUE3JTgwJTIwJUVDJTk1JThBJUVCJThGJTg0JUVCJUExJTlEJTIwbGF0ZW50JUVCJUE1JUJDJTIwJUVEJTk5JTk1JUVDJTlFJUE1LiUwQSUyMCUyMCUyMCUyMGxhdGVudF9tb2RlbF9pbnB1dCUyMCUzRCUyMHRvcmNoLmNhdCglNUJsYXRlbnRzJTVEJTIwKiUyMDIpJTBBJTBBJTIwJTIwJTIwJTIwbGF0ZW50X21vZGVsX2lucHV0JTIwJTNEJTIwc2NoZWR1bGVyLnNjYWxlX21vZGVsX2lucHV0KGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHRpbWVzdGVwJTNEdCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBub2lzZSUyMHJlc2lkdWFsJTIwJUVDJTk4JTg4JUVDJUI4JUExJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5vaXNlX3ByZWQlMjAlM0QlMjB1bmV0KGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHQlMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMlM0R0ZXh0X2VtYmVkZGluZ3MpLnNhbXBsZSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGd1aWRhbmNlJTIwJUVDJTg4JTk4JUVEJTk2JTg5JTBBJTIwJTIwJTIwJTIwbm9pc2VfcHJlZF91bmNvbmQlMkMlMjBub2lzZV9wcmVkX3RleHQlMjAlM0QlMjBub2lzZV9wcmVkLmNodW5rKDIpJTBBJTIwJTIwJTIwJTIwbm9pc2VfcHJlZCUyMCUzRCUyMG5vaXNlX3ByZWRfdW5jb25kJTIwJTJCJTIwZ3VpZGFuY2Vfc2NhbGUlMjAqJTIwKG5vaXNlX3ByZWRfdGV4dCUyMC0lMjBub2lzZV9wcmVkX3VuY29uZCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjAlRUMlOUQlQjQlRUMlQTAlODQlMjAlRUIlODUlQjglRUMlOUQlQjQlRUMlQTYlODglMjAlRUMlODMlOTglRUQlOTQlOEMlRUMlOUQlODQlMjAlRUElQjMlODQlRUMlODIlQjAlMjB4X3QlMjAtJTNFJTIweF90LTElMEElMjAlMjAlMjAlMjBsYXRlbnRzJTIwJTNEJTIwc2NoZWR1bGVyLnN0ZXAobm9pc2VfcHJlZCUyQyUyMHQlMkMlMjBsYXRlbnRzKS5wcmV2X3NhbXBsZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(num_inference_steps)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> tqdm(scheduler.timesteps):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># classifier-free guidance를 수행하는 경우 두번의 forward pass를 수행하지 않도록 latent를 확장.</span>
<span class="hljs-meta">... </span>    latent_model_input = torch.cat([latents] * <span class="hljs-number">2</span>)

<span class="hljs-meta">... </span>    latent_model_input = scheduler.scale_model_input(latent_model_input, timestep=t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># noise residual 예측</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = unet(latent_model_input, t, encoder_hidden_states=text_embeddings).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># guidance 수행</span>
<span class="hljs-meta">... </span>    noise_pred_uncond, noise_pred_text = noise_pred.chunk(<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    noise_pred = noise_pred_uncond + guidance_scale * (noise_pred_text - noise_pred_uncond)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># 이전 노이즈 샘플을 계산 x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    latents = scheduler.step(noise_pred, t, latents).prev_sample`,wrap:!1}}),Vs=new $({props:{title:"이미지 디코딩",local:"이미지-디코딩",headingTag:"h3"}}),Zs=new g({props:{code:"JTIzJTIwbGF0ZW50JUVCJUE1JUJDJTIwJUVDJThBJUE0JUVDJUJDJTgwJUVDJTlEJUJDJUVCJUE3JTgxJUVEJTk1JTk4JUVBJUIzJUEwJTIwdmFlJUVCJUExJTlDJTIwJUVDJTlEJUI0JUVCJUFGJUI4JUVDJUE3JTgwJTIwJUVCJTk0JTk0JUVDJUJEJTk0JUVCJTk0JUE5JTBBbGF0ZW50cyUyMCUzRCUyMDElMjAlMkYlMjAwLjE4MjE1JTIwKiUyMGxhdGVudHMlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB2YWUuZGVjb2RlKGxhdGVudHMpLnNhbXBsZQ==",highlighted:`<span class="hljs-comment"># latent를 스케일링하고 vae로 이미지 디코딩</span>
latents = <span class="hljs-number">1</span> / <span class="hljs-number">0.18215</span> * latents
<span class="hljs-keyword">with</span> torch.no_grad():
    image = vae.decode(latents).sample`,wrap:!1}}),_s=new g({props:{code:"aW1hZ2UlMjAlM0QlMjAoaW1hZ2UlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSklMEFpbWFnZSUyMCUzRCUyMGltYWdlLmRldGFjaCgpLmNwdSgpLnBlcm11dGUoMCUyQyUyMDIlMkMlMjAzJTJDJTIwMSkubnVtcHkoKSUwQWltYWdlcyUyMCUzRCUyMChpbWFnZSUyMColMjAyNTUpLnJvdW5kKCkuYXN0eXBlKCUyMnVpbnQ4JTIyKSUwQXBpbF9pbWFnZXMlMjAlM0QlMjAlNUJJbWFnZS5mcm9tYXJyYXkoaW1hZ2UpJTIwZm9yJTIwaW1hZ2UlMjBpbiUyMGltYWdlcyU1RCUwQXBpbF9pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image.detach().cpu().permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>).numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>images = (image * <span class="hljs-number">255</span>).<span class="hljs-built_in">round</span>().astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pil_images = [Image.fromarray(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]
<span class="hljs-meta">&gt;&gt;&gt; </span>pil_images[<span class="hljs-number">0</span>]`,wrap:!1}}),ks=new $({props:{title:"다음 단계",local:"다음-단계",headingTag:"h2"}}),Ws=new rl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ko/using-diffusers/write_own_pipeline.md"}}),{c(){f=p("meta"),As=n(),zs=p("p"),qs=n(),c(Z.$$.fragment),Ps=n(),c(v.$$.fragment),Os=n(),_=p("p"),_.innerHTML=Jt,Ks=n(),k=p("p"),k.textContent=yt,se=n(),c(I.$$.fragment),ee=n(),R=p("p"),R.textContent=Tt,te=n(),c(Q.$$.fragment),le=n(),T=p("div"),T.innerHTML=wt,ne=n(),G=p("p"),G.textContent=Ct,ae=n(),W=p("p"),W.innerHTML=Vt,pe=n(),x=p("p"),x.textContent=$t,ie=n(),b=p("ol"),N=p("li"),Ns=p("p"),Ns.textContent=Zt,it=n(),c(E.$$.fragment),mt=n(),X=p("li"),Es=p("p"),Es.textContent=vt,ct=n(),c(B.$$.fragment),ot=n(),F=p("li"),Xs=p("p"),Xs.textContent=_t,Mt=n(),c(S.$$.fragment),ut=n(),H=p("li"),Bs=p("p"),Bs.textContent=kt,dt=n(),c(L.$$.fragment),rt=n(),J=p("li"),Fs=p("p"),Fs.innerHTML=It,ht=n(),c(D.$$.fragment),gt=n(),Ss=p("p"),Ss.textContent=Rt,bt=n(),z=p("li"),Hs=p("p"),Hs.textContent=Qt,jt=n(),c(Y.$$.fragment),me=n(),A=p("p"),A.innerHTML=Gt,ce=n(),q=p("p"),q.textContent=Wt,oe=n(),c(P.$$.fragment),Me=n(),O=p("p"),O.innerHTML=xt,ue=n(),K=p("p"),K.textContent=Nt,de=n(),w=p("blockquote"),w.innerHTML=Et,re=n(),ss=p("p"),ss.innerHTML=Xt,he=n(),c(es.$$.fragment),ge=n(),ts=p("p"),ts.innerHTML=Bt,be=n(),c(ls.$$.fragment),je=n(),ns=p("p"),ns.textContent=Ft,Ue=n(),c(as.$$.fragment),fe=n(),c(ps.$$.fragment),Je=n(),is=p("p"),is.textContent=St,ye=n(),C=p("blockquote"),C.innerHTML=Ht,Te=n(),ms=p("p"),ms.textContent=Lt,we=n(),c(cs.$$.fragment),Ce=n(),os=p("p"),os.textContent=Dt,Ve=n(),c(Ms.$$.fragment),$e=n(),us=p("p"),us.innerHTML=zt,Ze=n(),c(ds.$$.fragment),ve=n(),rs=p("p"),rs.textContent=Yt,_e=n(),c(hs.$$.fragment),ke=n(),c(gs.$$.fragment),Ie=n(),bs=p("p"),bs.innerHTML=At,Re=n(),y=p("blockquote"),Ls=p("p"),Ls.innerHTML=qt,Ut=n(),c(js.$$.fragment),Qe=n(),c(Us.$$.fragment),Ge=n(),c(fs.$$.fragment),We=n(),Js=p("p"),Js.innerHTML=Pt,xe=n(),c(ys.$$.fragment),Ne=n(),Ts=p("p"),Ts.innerHTML=Ot,Ee=n(),ws=p("ol"),ws.innerHTML=Kt,Xe=n(),c(Cs.$$.fragment),Be=n(),c(Vs.$$.fragment),Fe=n(),$s=p("p"),$s.innerHTML=sl,Se=n(),c(Zs.$$.fragment),He=n(),vs=p("p"),vs.innerHTML=el,Le=n(),c(_s.$$.fragment),De=n(),V=p("div"),V.innerHTML=tl,ze=n(),c(ks.$$.fragment),Ye=n(),Is=p("p"),Is.textContent=ll,Ae=n(),Rs=p("p"),Rs.textContent=nl,qe=n(),Qs=p("p"),Qs.textContent=al,Pe=n(),Gs=p("ul"),Gs.innerHTML=pl,Oe=n(),c(Ws.$$.fragment),Ke=n(),Ys=p("p"),this.h()},l(s){const e=ul("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(t),As=a(s),zs=i(s,"P",{}),U(zs).forEach(t),qs=a(s),o(Z.$$.fragment,s),Ps=a(s),o(v.$$.fragment,s),Os=a(s),_=i(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1w08vjm"&&(_.innerHTML=Jt),Ks=a(s),k=i(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1rh2wvk"&&(k.textContent=yt),se=a(s),o(I.$$.fragment,s),ee=a(s),R=i(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1ejhv0l"&&(R.textContent=Tt),te=a(s),o(Q.$$.fragment,s),le=a(s),T=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(T)!=="svelte-ej6f4c"&&(T.innerHTML=wt),ne=a(s),G=i(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1l346u9"&&(G.textContent=Ct),ae=a(s),W=i(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-abj3gw"&&(W.innerHTML=Vt),pe=a(s),x=i(s,"P",{"data-svelte-h":!0}),m(x)!=="svelte-dgd067"&&(x.textContent=$t),ie=a(s),b=i(s,"OL",{});var j=U(b);N=i(j,"LI",{});var et=U(N);Ns=i(et,"P",{"data-svelte-h":!0}),m(Ns)!=="svelte-j1r62h"&&(Ns.textContent=Zt),it=a(et),o(E.$$.fragment,et),et.forEach(t),mt=a(j),X=i(j,"LI",{});var tt=U(X);Es=i(tt,"P",{"data-svelte-h":!0}),m(Es)!=="svelte-khbsw8"&&(Es.textContent=vt),ct=a(tt),o(B.$$.fragment,tt),tt.forEach(t),ot=a(j),F=i(j,"LI",{});var lt=U(F);Xs=i(lt,"P",{"data-svelte-h":!0}),m(Xs)!=="svelte-yj8dtl"&&(Xs.textContent=_t),Mt=a(lt),o(S.$$.fragment,lt),lt.forEach(t),ut=a(j),H=i(j,"LI",{});var nt=U(H);Bs=i(nt,"P",{"data-svelte-h":!0}),m(Bs)!=="svelte-1mx5t16"&&(Bs.textContent=kt),dt=a(nt),o(L.$$.fragment,nt),nt.forEach(t),rt=a(j),J=i(j,"LI",{});var Ds=U(J);Fs=i(Ds,"P",{"data-svelte-h":!0}),m(Fs)!=="svelte-1dcn1b9"&&(Fs.innerHTML=It),ht=a(Ds),o(D.$$.fragment,Ds),gt=a(Ds),Ss=i(Ds,"P",{"data-svelte-h":!0}),m(Ss)!=="svelte-x05lv9"&&(Ss.textContent=Rt),Ds.forEach(t),bt=a(j),z=i(j,"LI",{});var at=U(z);Hs=i(at,"P",{"data-svelte-h":!0}),m(Hs)!=="svelte-1plitwm"&&(Hs.textContent=Qt),jt=a(at),o(Y.$$.fragment,at),at.forEach(t),j.forEach(t),me=a(s),A=i(s,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1lzspna"&&(A.innerHTML=Gt),ce=a(s),q=i(s,"P",{"data-svelte-h":!0}),m(q)!=="svelte-5z3iwd"&&(q.textContent=Wt),oe=a(s),o(P.$$.fragment,s),Me=a(s),O=i(s,"P",{"data-svelte-h":!0}),m(O)!=="svelte-cnatu9"&&(O.innerHTML=xt),ue=a(s),K=i(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1qnf9z2"&&(K.textContent=Nt),de=a(s),w=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(w)!=="svelte-1x7lfaf"&&(w.innerHTML=Et),re=a(s),ss=i(s,"P",{"data-svelte-h":!0}),m(ss)!=="svelte-xdwsf8"&&(ss.innerHTML=Xt),he=a(s),o(es.$$.fragment,s),ge=a(s),ts=i(s,"P",{"data-svelte-h":!0}),m(ts)!=="svelte-angdpe"&&(ts.innerHTML=Bt),be=a(s),o(ls.$$.fragment,s),je=a(s),ns=i(s,"P",{"data-svelte-h":!0}),m(ns)!=="svelte-xe2wp7"&&(ns.textContent=Ft),Ue=a(s),o(as.$$.fragment,s),fe=a(s),o(ps.$$.fragment,s),Je=a(s),is=i(s,"P",{"data-svelte-h":!0}),m(is)!=="svelte-nswq27"&&(is.textContent=St),ye=a(s),C=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(C)!=="svelte-1jen626"&&(C.innerHTML=Ht),Te=a(s),ms=i(s,"P",{"data-svelte-h":!0}),m(ms)!=="svelte-193i9if"&&(ms.textContent=Lt),we=a(s),o(cs.$$.fragment,s),Ce=a(s),os=i(s,"P",{"data-svelte-h":!0}),m(os)!=="svelte-v5k7o5"&&(os.textContent=Dt),Ve=a(s),o(Ms.$$.fragment,s),$e=a(s),us=i(s,"P",{"data-svelte-h":!0}),m(us)!=="svelte-1nerc8v"&&(us.innerHTML=zt),Ze=a(s),o(ds.$$.fragment,s),ve=a(s),rs=i(s,"P",{"data-svelte-h":!0}),m(rs)!=="svelte-iqpjwl"&&(rs.textContent=Yt),_e=a(s),o(hs.$$.fragment,s),ke=a(s),o(gs.$$.fragment,s),Ie=a(s),bs=i(s,"P",{"data-svelte-h":!0}),m(bs)!=="svelte-b5xa4e"&&(bs.innerHTML=At),Re=a(s),y=i(s,"BLOCKQUOTE",{class:!0});var pt=U(y);Ls=i(pt,"P",{"data-svelte-h":!0}),m(Ls)!=="svelte-132csr5"&&(Ls.innerHTML=qt),Ut=a(pt),o(js.$$.fragment,pt),pt.forEach(t),Qe=a(s),o(Us.$$.fragment,s),Ge=a(s),o(fs.$$.fragment,s),We=a(s),Js=i(s,"P",{"data-svelte-h":!0}),m(Js)!=="svelte-1xr7g73"&&(Js.innerHTML=Pt),xe=a(s),o(ys.$$.fragment,s),Ne=a(s),Ts=i(s,"P",{"data-svelte-h":!0}),m(Ts)!=="svelte-4n9fvy"&&(Ts.innerHTML=Ot),Ee=a(s),ws=i(s,"OL",{"data-svelte-h":!0}),m(ws)!=="svelte-iivnel"&&(ws.innerHTML=Kt),Xe=a(s),o(Cs.$$.fragment,s),Be=a(s),o(Vs.$$.fragment,s),Fe=a(s),$s=i(s,"P",{"data-svelte-h":!0}),m($s)!=="svelte-12g4hh4"&&($s.innerHTML=sl),Se=a(s),o(Zs.$$.fragment,s),He=a(s),vs=i(s,"P",{"data-svelte-h":!0}),m(vs)!=="svelte-1bjoomr"&&(vs.innerHTML=el),Le=a(s),o(_s.$$.fragment,s),De=a(s),V=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(V)!=="svelte-1b0w6va"&&(V.innerHTML=tl),ze=a(s),o(ks.$$.fragment,s),Ye=a(s),Is=i(s,"P",{"data-svelte-h":!0}),m(Is)!=="svelte-nwx4ql"&&(Is.textContent=ll),Ae=a(s),Rs=i(s,"P",{"data-svelte-h":!0}),m(Rs)!=="svelte-g0p09q"&&(Rs.textContent=nl),qe=a(s),Qs=i(s,"P",{"data-svelte-h":!0}),m(Qs)!=="svelte-qg73l2"&&(Qs.textContent=al),Pe=a(s),Gs=i(s,"UL",{"data-svelte-h":!0}),m(Gs)!=="svelte-y3g0al"&&(Gs.innerHTML=pl),Oe=a(s),o(Ws.$$.fragment,s),Ke=a(s),Ys=i(s,"P",{}),U(Ys).forEach(t),this.h()},h(){xs(f,"name","hf:doc:metadata"),xs(f,"content",gl),xs(T,"class","flex justify-center"),xs(w,"class","tip"),xs(C,"class","tip"),xs(y,"class","tip"),xs(V,"class","flex justify-center")},m(s,e){h(document.head,f),l(s,As,e),l(s,zs,e),l(s,qs,e),M(Z,s,e),l(s,Ps,e),M(v,s,e),l(s,Os,e),l(s,_,e),l(s,Ks,e),l(s,k,e),l(s,se,e),M(I,s,e),l(s,ee,e),l(s,R,e),l(s,te,e),M(Q,s,e),l(s,le,e),l(s,T,e),l(s,ne,e),l(s,G,e),l(s,ae,e),l(s,W,e),l(s,pe,e),l(s,x,e),l(s,ie,e),l(s,b,e),h(b,N),h(N,Ns),h(N,it),M(E,N,null),h(b,mt),h(b,X),h(X,Es),h(X,ct),M(B,X,null),h(b,ot),h(b,F),h(F,Xs),h(F,Mt),M(S,F,null),h(b,ut),h(b,H),h(H,Bs),h(H,dt),M(L,H,null),h(b,rt),h(b,J),h(J,Fs),h(J,ht),M(D,J,null),h(J,gt),h(J,Ss),h(b,bt),h(b,z),h(z,Hs),h(z,jt),M(Y,z,null),l(s,me,e),l(s,A,e),l(s,ce,e),l(s,q,e),l(s,oe,e),M(P,s,e),l(s,Me,e),l(s,O,e),l(s,ue,e),l(s,K,e),l(s,de,e),l(s,w,e),l(s,re,e),l(s,ss,e),l(s,he,e),M(es,s,e),l(s,ge,e),l(s,ts,e),l(s,be,e),M(ls,s,e),l(s,je,e),l(s,ns,e),l(s,Ue,e),M(as,s,e),l(s,fe,e),M(ps,s,e),l(s,Je,e),l(s,is,e),l(s,ye,e),l(s,C,e),l(s,Te,e),l(s,ms,e),l(s,we,e),M(cs,s,e),l(s,Ce,e),l(s,os,e),l(s,Ve,e),M(Ms,s,e),l(s,$e,e),l(s,us,e),l(s,Ze,e),M(ds,s,e),l(s,ve,e),l(s,rs,e),l(s,_e,e),M(hs,s,e),l(s,ke,e),M(gs,s,e),l(s,Ie,e),l(s,bs,e),l(s,Re,e),l(s,y,e),h(y,Ls),h(y,Ut),M(js,y,null),l(s,Qe,e),M(Us,s,e),l(s,Ge,e),M(fs,s,e),l(s,We,e),l(s,Js,e),l(s,xe,e),M(ys,s,e),l(s,Ne,e),l(s,Ts,e),l(s,Ee,e),l(s,ws,e),l(s,Xe,e),M(Cs,s,e),l(s,Be,e),M(Vs,s,e),l(s,Fe,e),l(s,$s,e),l(s,Se,e),M(Zs,s,e),l(s,He,e),l(s,vs,e),l(s,Le,e),M(_s,s,e),l(s,De,e),l(s,V,e),l(s,ze,e),M(ks,s,e),l(s,Ye,e),l(s,Is,e),l(s,Ae,e),l(s,Rs,e),l(s,qe,e),l(s,Qs,e),l(s,Pe,e),l(s,Gs,e),l(s,Oe,e),M(Ws,s,e),l(s,Ke,e),l(s,Ys,e),st=!0},p:ml,i(s){st||(u(Z.$$.fragment,s),u(v.$$.fragment,s),u(I.$$.fragment,s),u(Q.$$.fragment,s),u(E.$$.fragment,s),u(B.$$.fragment,s),u(S.$$.fragment,s),u(L.$$.fragment,s),u(D.$$.fragment,s),u(Y.$$.fragment,s),u(P.$$.fragment,s),u(es.$$.fragment,s),u(ls.$$.fragment,s),u(as.$$.fragment,s),u(ps.$$.fragment,s),u(cs.$$.fragment,s),u(Ms.$$.fragment,s),u(ds.$$.fragment,s),u(hs.$$.fragment,s),u(gs.$$.fragment,s),u(js.$$.fragment,s),u(Us.$$.fragment,s),u(fs.$$.fragment,s),u(ys.$$.fragment,s),u(Cs.$$.fragment,s),u(Vs.$$.fragment,s),u(Zs.$$.fragment,s),u(_s.$$.fragment,s),u(ks.$$.fragment,s),u(Ws.$$.fragment,s),st=!0)},o(s){d(Z.$$.fragment,s),d(v.$$.fragment,s),d(I.$$.fragment,s),d(Q.$$.fragment,s),d(E.$$.fragment,s),d(B.$$.fragment,s),d(S.$$.fragment,s),d(L.$$.fragment,s),d(D.$$.fragment,s),d(Y.$$.fragment,s),d(P.$$.fragment,s),d(es.$$.fragment,s),d(ls.$$.fragment,s),d(as.$$.fragment,s),d(ps.$$.fragment,s),d(cs.$$.fragment,s),d(Ms.$$.fragment,s),d(ds.$$.fragment,s),d(hs.$$.fragment,s),d(gs.$$.fragment,s),d(js.$$.fragment,s),d(Us.$$.fragment,s),d(fs.$$.fragment,s),d(ys.$$.fragment,s),d(Cs.$$.fragment,s),d(Vs.$$.fragment,s),d(Zs.$$.fragment,s),d(_s.$$.fragment,s),d(ks.$$.fragment,s),d(Ws.$$.fragment,s),st=!1},d(s){s&&(t(As),t(zs),t(qs),t(Ps),t(Os),t(_),t(Ks),t(k),t(se),t(ee),t(R),t(te),t(le),t(T),t(ne),t(G),t(ae),t(W),t(pe),t(x),t(ie),t(b),t(me),t(A),t(ce),t(q),t(oe),t(Me),t(O),t(ue),t(K),t(de),t(w),t(re),t(ss),t(he),t(ge),t(ts),t(be),t(je),t(ns),t(Ue),t(fe),t(Je),t(is),t(ye),t(C),t(Te),t(ms),t(we),t(Ce),t(os),t(Ve),t($e),t(us),t(Ze),t(ve),t(rs),t(_e),t(ke),t(Ie),t(bs),t(Re),t(y),t(Qe),t(Ge),t(We),t(Js),t(xe),t(Ne),t(Ts),t(Ee),t(ws),t(Xe),t(Be),t(Fe),t($s),t(Se),t(He),t(vs),t(Le),t(De),t(V),t(ze),t(Ye),t(Is),t(Ae),t(Rs),t(qe),t(Qs),t(Pe),t(Gs),t(Oe),t(Ke),t(Ys)),t(f),r(Z,s),r(v,s),r(I,s),r(Q,s),r(E),r(B),r(S),r(L),r(D),r(Y),r(P,s),r(es,s),r(ls,s),r(as,s),r(ps,s),r(cs,s),r(Ms,s),r(ds,s),r(hs,s),r(gs,s),r(js),r(Us,s),r(fs,s),r(ys,s),r(Cs,s),r(Vs,s),r(Zs,s),r(_s,s),r(ks,s),r(Ws,s)}}}const gl='{"title":"파이프라인, 모델 및 스케줄러 이해하기","local":"파이프라인-모델-및-스케줄러-이해하기","sections":[{"title":"기본 파이프라인 해체하기","local":"기본-파이프라인-해체하기","sections":[],"depth":2},{"title":"Stable Diffusion 파이프라인 해체하기","local":"stable-diffusion-파이프라인-해체하기","sections":[{"title":"텍스트 임베딩 생성하기","local":"텍스트-임베딩-생성하기","sections":[],"depth":3},{"title":"랜덤 노이즈 생성","local":"랜덤-노이즈-생성","sections":[],"depth":3},{"title":"이미지 노이즈 제거","local":"이미지-노이즈-제거","sections":[],"depth":3},{"title":"이미지 디코딩","local":"이미지-디코딩","sections":[],"depth":3}],"depth":2},{"title":"다음 단계","local":"다음-단계","sections":[],"depth":2}],"depth":1}';function bl(ft){return cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tl extends ol{constructor(f){super(),Ml(this,f,bl,hl,il,{})}}export{Tl as component};
