import{s as Nl,n as Dl,o as Kl}from"../chunks/scheduler.80eaf607.js";import{S as Ol,i as le,e as n,s as i,c as o,h as ee,a as p,d as t,b as a,f as Pl,j as u,g as m,k as L,l as te,m as s,n as c,t as r,o as f,p as M}from"../chunks/index.47529bd5.js";import{C as U}from"../chunks/CodeBlock.204d0d0f.js";import{H as vl,E as se}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9d0d6126.js";function ie(Vl){let d,N,q,D,h,K,j,_l='Diffusersは様々なタスクをこなすことができ、テキストから画像、画像から画像、画像の修復など、複数のタスクに対して同じように事前学習された重みを再利用することができます。しかし、ライブラリや拡散モデルに慣れていない場合、どのタスクにどのパイプラインを使えばいいのかがわかりにくいかもしれません。例えば、 <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">stable-diffusion-v1-5/stable-diffusion-v1-5</a> チェックポイントをテキストから画像に変換するために使用している場合、それぞれ<code>StableDiffusionImg2ImgPipeline</code>クラスと<code>StableDiffusionInpaintPipeline</code>クラスでチェックポイントをロードすることで、画像から画像や画像の修復にも使えることを知らない可能性もあります。',O,J,Il="<code>AutoPipeline</code> クラスは、🤗 Diffusers の様々なパイプラインをよりシンプルするために設計されています。この汎用的でタスク重視のパイプラインによってタスクそのものに集中することができます。<code>AutoPipeline</code> は、使用するべき正しいパイプラインクラスを自動的に検出するため、特定のパイプラインクラス名を知らなくても、タスクのチェックポイントを簡単にロードできます。",ll,y,Rl='<p>どのタスクがサポートされているかは、<a href="../api/pipelines/auto_pipeline">AutoPipeline</a> のリファレンスをご覧ください。現在、text-to-image、image-to-image、inpaintingをサポートしています。</p>',el,w,kl="このチュートリアルでは、<code>AutoPipeline</code> を使用して、事前に学習された重みが与えられたときに、特定のタスクを読み込むためのパイプラインクラスを自動的に推測する方法を示します。",tl,G,sl,W,Xl='まずはチェックポイントを選ぶことから始めましょう。例えば、 <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">stable-diffusion-v1-5/stable-diffusion-v1-5</a> チェックポイントでテキストから画像への変換したいなら、<code>AutoPipelineForText2Image</code>を使います:',il,T,al,b,Fl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-text2img.png" alt="generated image of peasant fighting dragon in wood cutting style"/>',nl,B,Sl="<code>AutoPipelineForText2Image</code> を具体的に見ていきましょう:",pl,v,xl='<li><a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> ファイルから <code>&quot;stable-diffusion&quot;</code> クラスを自動的に検出します。</li> <li><code>&quot;stable-diffusion&quot;</code> のクラス名に基づいて、テキストから画像へ変換する <code>StableDiffusionPipeline</code> を読み込みます。</li>',ml,V,Hl="同様に、画像から画像へ変換する場合、<code>AutoPipelineForImage2Image</code> は <code>model_index.json</code> ファイルから <code>&quot;stable-diffusion&quot;</code> チェックポイントを検出し、対応する <code>StableDiffusionImg2ImgPipeline</code> を読み込みます。また、入力画像にノイズの量やバリエーションの追加を決めるための強さなど、パイプラインクラスに固有の追加引数を渡すこともできます:",ol,_,ul,Z,Cl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-img2img.png" alt="generated image of a vermeer portrait of a dog wearing a pearl earring"/>',cl,I,$l="また、画像の修復を行いたい場合は、 <code>AutoPipelineForInpainting</code> が、同様にベースとなる<code>StableDiffusionInpaintPipeline</code>クラスを読み込みます：",rl,R,fl,g,Yl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-inpaint.png" alt="generated image of a tiger sitting on a bench"/>',Ml,k,Ql="サポートされていないチェックポイントを読み込もうとすると、エラーになります:",dl,X,yl,F,bl,S,El='いくつかのワークフローや多くのパイプラインを読み込む場合、不要なメモリを使ってしまう再読み込みをするよりも、チェックポイントから同じコンポーネントを再利用する方がメモリ効率が良いです。たとえば、テキストから画像への変換にチェックポイントを使い、画像から画像への変換にまたチェックポイントを使いたい場合、<a href="https://huggingface.co/docs/diffusers/v0.25.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe" rel="nofollow">from_pipe()</a> メソッドを使用します。このメソッドは、以前読み込まれたパイプラインのコンポーネントを使うことで追加のメモリを消費することなく、新しいパイプラインを作成します。',Zl,x,zl='<a href="https://huggingface.co/docs/diffusers/v0.25.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe" rel="nofollow">from_pipe()</a> メソッドは、元のパイプラインクラスを検出し、実行したいタスクに対応する新しいパイプラインクラスにマッピングします。例えば、テキストから画像への<code>&quot;stable-diffusion&quot;</code> クラスのパイプラインを読み込む場合：',gl,H,Ul,C,Al='そして、[from_pipe()] (<a href="https://huggingface.co/docs/diffusers/v0.25.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe)%E3%81%AF%E3%80%81%E3%82%82%E3%81%A8%E3%81%AE%60%22stable-diffusion%22%60" rel="nofollow">https://huggingface.co/docs/diffusers/v0.25.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe)は、もとの`“stable-diffusion”`</a> パイプラインのクラスである <code>StableDiffusionImg2ImgPipeline</code> にマップします:',hl,$,jl,Y,Ll="元のパイプラインにオプションとして引数（セーフティチェッカーの無効化など）を渡した場合、この引数も新しいパイプラインに渡されます:",Jl,Q,wl,E,ql="新しいパイプラインの動作を変更したい場合は、元のパイプラインの引数や設定を上書きすることができます。例えば、セーフティチェッカーをオンに戻し、<code>strength</code> 引数を追加します:",Gl,z,Wl,A,Tl,P,Bl;return h=new vl({props:{title:"AutoPipeline",local:"autopipeline",headingTag:"h1"}}),G=new vl({props:{title:"タスクに合わせてAutoPipeline を選択する",local:"タスクに合わせてautopipeline-を選択する",headingTag:"h2"}}),T=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSkudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJwZWFzYW50JTIwYW5kJTIwZHJhZ29uJTIwY29tYmF0JTJDJTIwd29vZCUyMGN1dHRpbmclMjBzdHlsZSUyQyUyMHZpa2luZyUyMGVyYSUyQyUyMGJldmVsJTIwd2l0aCUyMHJ1bmUlMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;peasant and dragon combat, wood cutting style, viking era, bevel with rune&quot;</span>

image = pipeline(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),_=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwb3J0cmFpdCUyMG9mJTIwYSUyMGRvZyUyMHdlYXJpbmclMjBhJTIwcGVhcmwlMjBlYXJyaW5nJTIyJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cGxvYWQud2lraW1lZGlhLm9yZyUyRndpa2lwZWRpYSUyRmNvbW1vbnMlMkZ0aHVtYiUyRjAlMkYwZiUyRjE2NjVfR2lybF93aXRoX2FfUGVhcmxfRWFycmluZy5qcGclMkY4MDBweC0xNjY1X0dpcmxfd2l0aF9hX1BlYXJsX0VhcnJpbmcuanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbWFnZS50aHVtYm5haWwoKDc2OCUyQyUyMDc2OCkpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBpbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMDAlMkMlMjBzdHJlbmd0aCUzRDAuNzUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEwLjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a portrait of a dog wearing a pearl earring&quot;</span>

url = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/0/0f/1665_Girl_with_a_Pearl_Earring.jpg/800px-1665_Girl_with_a_Pearl_Earring.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipeline(prompt, image, num_inference_steps=<span class="hljs-number">200</span>, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">10.5</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),R=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBbWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UobWFza191cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBtYWplc3RpYyUyMHRpZ2VyJTIwc2l0dGluZyUyMG9uJTIwYSUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMHN0cmVuZ3RoJTNEMC44MCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>
image = pipeline(prompt, image=init_image, mask_image=mask_image, num_inference_steps=<span class="hljs-number">50</span>, strength=<span class="hljs-number">0.80</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),X=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVuYWklMkZzaGFwLWUtaW1nMmltZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTIyVmFsdWVFcnJvciUzQSUyMEF1dG9QaXBlbGluZSUyMGNhbid0JTIwZmluZCUyMGElMjBwaXBlbGluZSUyMGxpbmtlZCUyMHRvJTIwU2hhcEVJbWcySW1nUGlwZWxpbmUlMjBmb3IlMjBOb25lJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;openai/shap-e-img2img&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-string">&quot;ValueError: AutoPipeline can&#x27;t find a pipeline linked to ShapEImg2ImgPipeline for None&quot;</span>`,wrap:!1}}),F=new vl({props:{title:"複数のパイプラインを使用する",local:"複数のパイプラインを使用する",headingTag:"h2"}}),H=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmVfdGV4dDJpbWclMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXByaW50KHR5cGUocGlwZWxpbmVfdGV4dDJpbWcpKSUwQSUyMiUzQ2NsYXNzJTIwJ2RpZmZ1c2Vycy5waXBlbGluZXMuc3RhYmxlX2RpZmZ1c2lvbi5waXBlbGluZV9zdGFibGVfZGlmZnVzaW9uLlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJyUzRSUyMg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2img = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(pipeline_text2img))
<span class="hljs-string">&quot;&lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt;&quot;</span>`,wrap:!1}}),$=new U({props:{code:"cGlwZWxpbmVfaW1nMmltZyUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltZyklMEFwcmludCh0eXBlKHBpcGVsaW5lX2ltZzJpbWcpKSUwQSUyMiUzQ2NsYXNzJTIwJ2RpZmZ1c2Vycy5waXBlbGluZXMuc3RhYmxlX2RpZmZ1c2lvbi5waXBlbGluZV9zdGFibGVfZGlmZnVzaW9uX2ltZzJpbWcuU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJyUzRSUyMg==",highlighted:`pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(pipeline_img2img))
<span class="hljs-string">&quot;&lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion_img2img.StableDiffusionImg2ImgPipeline&#x27;&gt;&quot;</span>`,wrap:!1}}),Q=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmVfdGV4dDJpbWclMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmVxdWlyZXNfc2FmZXR5X2NoZWNrZXIlM0RGYWxzZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlbGluZV9pbWcyaW1nJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9waXBlKHBpcGVsaW5lX3RleHQyaW1nKSUwQXByaW50KHBpcGVsaW5lX2ltZzJpbWcuY29uZmlnLnJlcXVpcmVzX3NhZmV0eV9jaGVja2VyKSUwQSUyMkZhbHNlJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2img = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    requires_safety_checker=<span class="hljs-literal">False</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img)
<span class="hljs-built_in">print</span>(pipeline_img2img.config.requires_safety_checker)
<span class="hljs-string">&quot;False&quot;</span>`,wrap:!1}}),z=new U({props:{code:"cGlwZWxpbmVfaW1nMmltZyUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltZyUyQyUyMHJlcXVpcmVzX3NhZmV0eV9jaGVja2VyJTNEVHJ1ZSUyQyUyMHN0cmVuZ3RoJTNEMC4zKSUwQXByaW50KHBpcGVsaW5lX2ltZzJpbWcuY29uZmlnLnJlcXVpcmVzX3NhZmV0eV9jaGVja2VyKSUwQSUyMlRydWUlMjI=",highlighted:`pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img, requires_safety_checker=<span class="hljs-literal">True</span>, strength=<span class="hljs-number">0.3</span>)
<span class="hljs-built_in">print</span>(pipeline_img2img.config.requires_safety_checker)
<span class="hljs-string">&quot;True&quot;</span>`,wrap:!1}}),A=new se({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ja/tutorials/autopipeline.md"}}),{c(){d=n("meta"),N=i(),q=n("p"),D=i(),o(h.$$.fragment),K=i(),j=n("p"),j.innerHTML=_l,O=i(),J=n("p"),J.innerHTML=Il,ll=i(),y=n("blockquote"),y.innerHTML=Rl,el=i(),w=n("p"),w.innerHTML=kl,tl=i(),o(G.$$.fragment),sl=i(),W=n("p"),W.innerHTML=Xl,il=i(),o(T.$$.fragment),al=i(),b=n("div"),b.innerHTML=Fl,nl=i(),B=n("p"),B.innerHTML=Sl,pl=i(),v=n("ol"),v.innerHTML=xl,ml=i(),V=n("p"),V.innerHTML=Hl,ol=i(),o(_.$$.fragment),ul=i(),Z=n("div"),Z.innerHTML=Cl,cl=i(),I=n("p"),I.innerHTML=$l,rl=i(),o(R.$$.fragment),fl=i(),g=n("div"),g.innerHTML=Yl,Ml=i(),k=n("p"),k.textContent=Ql,dl=i(),o(X.$$.fragment),yl=i(),o(F.$$.fragment),bl=i(),S=n("p"),S.innerHTML=El,Zl=i(),x=n("p"),x.innerHTML=zl,gl=i(),o(H.$$.fragment),Ul=i(),C=n("p"),C.innerHTML=Al,hl=i(),o($.$$.fragment),jl=i(),Y=n("p"),Y.textContent=Ll,Jl=i(),o(Q.$$.fragment),wl=i(),E=n("p"),E.innerHTML=ql,Gl=i(),o(z.$$.fragment),Wl=i(),o(A.$$.fragment),Tl=i(),P=n("p"),this.h()},l(l){const e=ee("svelte-u9bgzb",document.head);d=p(e,"META",{name:!0,content:!0}),e.forEach(t),N=a(l),q=p(l,"P",{}),Pl(q).forEach(t),D=a(l),u(h.$$.fragment,l),K=a(l),j=p(l,"P",{"data-svelte-h":!0}),m(j)!=="svelte-qai92n"&&(j.innerHTML=_l),O=a(l),J=p(l,"P",{"data-svelte-h":!0}),m(J)!=="svelte-bhmuwk"&&(J.innerHTML=Il),ll=a(l),y=p(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(y)!=="svelte-1615jnz"&&(y.innerHTML=Rl),el=a(l),w=p(l,"P",{"data-svelte-h":!0}),m(w)!=="svelte-fxxxlv"&&(w.innerHTML=kl),tl=a(l),u(G.$$.fragment,l),sl=a(l),W=p(l,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1l9b5y1"&&(W.innerHTML=Xl),il=a(l),u(T.$$.fragment,l),al=a(l),b=p(l,"DIV",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-1yzwly4"&&(b.innerHTML=Fl),nl=a(l),B=p(l,"P",{"data-svelte-h":!0}),m(B)!=="svelte-bx1qu8"&&(B.innerHTML=Sl),pl=a(l),v=p(l,"OL",{"data-svelte-h":!0}),m(v)!=="svelte-j698gc"&&(v.innerHTML=xl),ml=a(l),V=p(l,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1tv7o7j"&&(V.innerHTML=Hl),ol=a(l),u(_.$$.fragment,l),ul=a(l),Z=p(l,"DIV",{class:!0,"data-svelte-h":!0}),m(Z)!=="svelte-9fi2fw"&&(Z.innerHTML=Cl),cl=a(l),I=p(l,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1a50jb8"&&(I.innerHTML=$l),rl=a(l),u(R.$$.fragment,l),fl=a(l),g=p(l,"DIV",{class:!0,"data-svelte-h":!0}),m(g)!=="svelte-1id5o5z"&&(g.innerHTML=Yl),Ml=a(l),k=p(l,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1iuzdt9"&&(k.textContent=Ql),dl=a(l),u(X.$$.fragment,l),yl=a(l),u(F.$$.fragment,l),bl=a(l),S=p(l,"P",{"data-svelte-h":!0}),m(S)!=="svelte-q2xv6p"&&(S.innerHTML=El),Zl=a(l),x=p(l,"P",{"data-svelte-h":!0}),m(x)!=="svelte-mczuk5"&&(x.innerHTML=zl),gl=a(l),u(H.$$.fragment,l),Ul=a(l),C=p(l,"P",{"data-svelte-h":!0}),m(C)!=="svelte-5m0bbd"&&(C.innerHTML=Al),hl=a(l),u($.$$.fragment,l),jl=a(l),Y=p(l,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1m19tqu"&&(Y.textContent=Ll),Jl=a(l),u(Q.$$.fragment,l),wl=a(l),E=p(l,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1vu2fjh"&&(E.innerHTML=ql),Gl=a(l),u(z.$$.fragment,l),Wl=a(l),u(A.$$.fragment,l),Tl=a(l),P=p(l,"P",{}),Pl(P).forEach(t),this.h()},h(){L(d,"name","hf:doc:metadata"),L(d,"content",ae),L(y,"class","tip"),L(b,"class","flex justify-center"),L(Z,"class","flex justify-center"),L(g,"class","flex justify-center")},m(l,e){te(document.head,d),s(l,N,e),s(l,q,e),s(l,D,e),c(h,l,e),s(l,K,e),s(l,j,e),s(l,O,e),s(l,J,e),s(l,ll,e),s(l,y,e),s(l,el,e),s(l,w,e),s(l,tl,e),c(G,l,e),s(l,sl,e),s(l,W,e),s(l,il,e),c(T,l,e),s(l,al,e),s(l,b,e),s(l,nl,e),s(l,B,e),s(l,pl,e),s(l,v,e),s(l,ml,e),s(l,V,e),s(l,ol,e),c(_,l,e),s(l,ul,e),s(l,Z,e),s(l,cl,e),s(l,I,e),s(l,rl,e),c(R,l,e),s(l,fl,e),s(l,g,e),s(l,Ml,e),s(l,k,e),s(l,dl,e),c(X,l,e),s(l,yl,e),c(F,l,e),s(l,bl,e),s(l,S,e),s(l,Zl,e),s(l,x,e),s(l,gl,e),c(H,l,e),s(l,Ul,e),s(l,C,e),s(l,hl,e),c($,l,e),s(l,jl,e),s(l,Y,e),s(l,Jl,e),c(Q,l,e),s(l,wl,e),s(l,E,e),s(l,Gl,e),c(z,l,e),s(l,Wl,e),c(A,l,e),s(l,Tl,e),s(l,P,e),Bl=!0},p:Dl,i(l){Bl||(r(h.$$.fragment,l),r(G.$$.fragment,l),r(T.$$.fragment,l),r(_.$$.fragment,l),r(R.$$.fragment,l),r(X.$$.fragment,l),r(F.$$.fragment,l),r(H.$$.fragment,l),r($.$$.fragment,l),r(Q.$$.fragment,l),r(z.$$.fragment,l),r(A.$$.fragment,l),Bl=!0)},o(l){f(h.$$.fragment,l),f(G.$$.fragment,l),f(T.$$.fragment,l),f(_.$$.fragment,l),f(R.$$.fragment,l),f(X.$$.fragment,l),f(F.$$.fragment,l),f(H.$$.fragment,l),f($.$$.fragment,l),f(Q.$$.fragment,l),f(z.$$.fragment,l),f(A.$$.fragment,l),Bl=!1},d(l){l&&(t(N),t(q),t(D),t(K),t(j),t(O),t(J),t(ll),t(y),t(el),t(w),t(tl),t(sl),t(W),t(il),t(al),t(b),t(nl),t(B),t(pl),t(v),t(ml),t(V),t(ol),t(ul),t(Z),t(cl),t(I),t(rl),t(fl),t(g),t(Ml),t(k),t(dl),t(yl),t(bl),t(S),t(Zl),t(x),t(gl),t(Ul),t(C),t(hl),t(jl),t(Y),t(Jl),t(wl),t(E),t(Gl),t(Wl),t(Tl),t(P)),t(d),M(h,l),M(G,l),M(T,l),M(_,l),M(R,l),M(X,l),M(F,l),M(H,l),M($,l),M(Q,l),M(z,l),M(A,l)}}}const ae='{"title":"AutoPipeline","local":"autopipeline","sections":[{"title":"タスクに合わせてAutoPipeline を選択する","local":"タスクに合わせてautopipeline-を選択する","sections":[],"depth":2},{"title":"複数のパイプラインを使用する","local":"複数のパイプラインを使用する","sections":[],"depth":2}],"depth":1}';function ne(Vl){return Kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ce extends Ol{constructor(d){super(),le(this,d,ne,ie,Nl,{})}}export{ce as component};
