import{s as zt,n as Nt,o as St}from"../chunks/scheduler.80eaf607.js";import{S as Qt,i as Ft,e as a,s as i,c as m,h as Yt,a as p,d as t,b as n,f as Lt,j as c,g as r,k as y,l as Dt,m as s,n as u,t as M,o as f,p as o}from"../chunks/index.47529bd5.js";import{C as d}from"../chunks/CodeBlock.204d0d0f.js";import{D as Et}from"../chunks/DocNotebookDropdown.5da6b2b6.js";import{H as $,E as Pt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9d0d6126.js";function At(Kl){let b,Ie,He,Be,v,Re,W,Xe,_,Ol="<code>DiffusionPipeline</code>を使って特定のスタイルで画像を生成したり、希望する画像を生成したりするのは難しいことです。多くの場合、<code>DiffusionPipeline</code>を何度か実行してからでないと満足のいく画像は得られません。しかし、何もないところから何かを生成するにはたくさんの計算が必要です。生成を何度も何度も実行する場合、特にたくさんの計算量が必要になります。",xe,V,et="そのため、パイプラインから<em>計算</em>（速度）と<em>メモリ</em>（GPU RAM）の効率を最大限に引き出し、生成サイクル間の時間を短縮することで、より高速な反復処理を行えるようにすることが重要です。",Le,C,lt="このチュートリアルでは、<code>DiffusionPipeline</code>を用いて、より速く、より良い計算を行う方法を説明します。",ze,H,tt='まず、<a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a>モデルをロードします：',Ne,k,Se,I,st="ここで使用するプロンプトの例は年老いた戦士の長の肖像画ですが、ご自由に変更してください：",Qe,B,Fe,R,Ye,h,it='<p>💡 GPUを利用できない場合は、<a href="https://colab.research.google.com/" rel="nofollow">Colab</a>のようなGPUプロバイダーから無料で利用できます！</p>',De,X,nt="画像生成を高速化する最も簡単な方法の1つは、PyTorchモジュールと同じようにGPU上にパイプラインを配置することです：",Ee,x,Pe,L,at='同じイメージを使って改良できるようにするには、<a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>Generator</code></a>を使い、<a href="./using-diffusers/reusing_seeds">reproducibility</a>の種を設定します：',Ae,z,qe,N,pt="これで画像を生成できます：",Ke,S,Oe,J,rt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_1.png"/>',el,Q,mt="この処理にはT4 GPUで~30秒かかりました（割り当てられているGPUがT4より優れている場合はもっと速いかもしれません）。デフォルトでは、<code>DiffusionPipeline</code>は完全な<code>float32</code>精度で生成を50ステップ実行します。float16`のような低い精度に変更するか、推論ステップ数を減らすことで高速化することができます。",ll,F,ct="まずは <code>float16</code> でモデルをロードして画像を生成してみましょう：",tl,Y,sl,w,ut='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_2.png"/>',il,D,Mt="今回、画像生成にかかった時間はわずか11秒で、以前より3倍近く速くなりました！",nl,T,ft="<p>💡 パイプラインは常に <code>float16</code> で実行することを強くお勧めします。</p>",al,E,ot="生成ステップ数を減らすという方法もあります。より効率的なスケジューラを選択することで、出力品質を犠牲にすることなくステップ数を減らすことができます。<code>compatibles</code>メソッドを呼び出すことで、<code>DiffusionPipeline</code>の現在のモデルと互換性のあるスケジューラを見つけることができます：",pl,P,rl,A,dt="Stable Diffusionモデルはデフォルトで<code>PNDMScheduler</code>を使用します。このスケジューラは通常~50の推論ステップを必要としますが、<code>DPMSolverMultistepScheduler</code>のような高性能なスケジューラでは~20または25の推論ステップで済みます。<code>ConfigMixin.from_config()</code>メソッドを使用すると、新しいスケジューラをロードすることができます：",ml,q,cl,K,yt="ここで <code>num_inference_steps</code> を20に設定します：",ul,O,Ml,U,bt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_3.png"/>',fl,ee,ht="推論時間をわずか4秒に短縮することに成功した！⚡️",ol,le,dl,te,Jt="パイプラインのパフォーマンスを向上させるもう1つの鍵は、消費メモリを少なくすることです。一度に生成できる画像の数を確認する最も簡単な方法は、<code>OutOfMemoryError</code>（OOM）が発生するまで、さまざまなバッチサイズを試してみることです。",yl,se,wt="文章と <code>Generators</code> のリストから画像のバッチを生成する関数を作成します。各 <code>Generator</code> にシードを割り当てて、良い結果が得られた場合に再利用できるようにします。",bl,ie,hl,ne,Tt="<code>batch_size=4</code>で開始し、どれだけメモリを消費したかを確認します：",Jl,ae,wl,pe,Ut="大容量のRAMを搭載したGPUでない限り、上記のコードはおそらく<code>OOM</code>エラーを返したはずです！メモリの大半はクロスアテンションレイヤーが占めています。この処理をバッチで実行する代わりに、逐次実行することでメモリを大幅に節約できます。必要なのは、<code>enable_attention_slicing()</code>関数を使用することだけです：",Tl,re,Ul,me,Zt="今度は<code>batch_size</code>を8にしてみてください！",Zl,ce,gl,Z,gt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_5.png"/>',jl,ue,jt="以前は4枚の画像のバッチを生成することさえできませんでしたが、今では8枚の画像のバッチを1枚あたり～3.5秒で生成できます！これはおそらく、品質を犠牲にすることなくT4 GPUでできる最速の処理速度です。",Gl,Me,$l,fe,Gt="前の2つのセクションでは、<code>fp16</code> を使ってパイプラインの速度を最適化する方法、よりパフォーマン スなスケジューラーを使って生成ステップ数を減らす方法、アテンションスライスを有効 にしてメモリ消費量を減らす方法について学びました。今度は、生成される画像の品質を向上させる方法に焦点を当てます。",vl,oe,Wl,de,$t='最も単純なステップは、より良いチェックポイントを使うことです。Stable Diffusionモデルは良い出発点であり、公式発表以来、いくつかの改良版もリリースされています。しかし、新しいバージョンを使ったからといって、自動的に良い結果が得られるわけではありません。最良の結果を得るためには、自分でさまざまなチェックポイントを試してみたり、ちょっとした研究（<a href="https://minimaxir.com/2022/11/stable-diffusion-negative-prompt/" rel="nofollow">ネガティブプロンプト</a>の使用など）をしたりする必要があります。',_l,ye,vt='この分野が成長するにつれて、特定のスタイルを生み出すために微調整された、より質の高いチェックポイントが増えています。<a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">Hub</a>や<a href="https://huggingface.co/spaces/huggingface-projects/diffusers-gallery" rel="nofollow">Diffusers Gallery</a>を探索して、興味のあるものを見つけてみてください！',Vl,be,Cl,he,Wt='現在のパイプラインコンポーネントを新しいバージョンに置き換えてみることもできます。Stability AIが提供する最新の<a href="https://huggingface.co/stabilityai/stable-diffusion-2-1/tree/main/vae" rel="nofollow">autodecoder</a>をパイプラインにロードし、画像を生成してみましょう：',Hl,Je,kl,g,_t='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_6.png"/>',Il,we,Bl,Te,Vt="画像を生成するために使用する文章は、<em>プロンプトエンジニアリング</em>と呼ばれる分野を作られるほど、非常に重要です。プロンプト・エンジニアリングで考慮すべき点は以下の通りです：",Rl,Ue,Ct="<li>生成したい画像やその類似画像は、インターネット上にどのように保存されているか？</li> <li>私が望むスタイルにモデルを誘導するために、どのような追加詳細を与えるべきか？</li>",Xl,Ze,Ht="このことを念頭に置いて、プロンプトに色やより質の高いディテールを含めるように改良してみましょう：",xl,ge,Ll,je,kt="新しいプロンプトで画像のバッチを生成しましょう：",zl,Ge,Nl,j,It='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_7.png"/>',Sl,$e,Bt="かなりいいです！種が<code>1</code>の<code>Generator</code>に対応する2番目の画像に、被写体の年齢に関するテキストを追加して、もう少し手を加えてみましょう：",Ql,ve,Fl,G,Rt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_8.png"/>',Yl,We,Dl,_e,Xt="このチュートリアルでは、<code>DiffusionPipeline</code>を最適化して計算効率とメモリ効率を向上させ、生成される出力の品質を向上させる方法を学びました。パイプラインをさらに高速化することに興味があれば、以下のリソースを参照してください：",El,Ve,xt='<li><a href="./optimization/torch2.0">PyTorch 2.0</a>と<a href="https://pytorch.org/docs/stable/generated/torch.compile.html" rel="nofollow"><code>torch.compile</code></a>がどのように生成速度を5-300%高速化できるかを学んでください。A100 GPUの場合、画像生成は最大50%速くなります！</li> <li>PyTorch 2が使えない場合は、<a href="./optimization/xformers">xFormers</a>をインストールすることをお勧めします。このライブラリのメモリ効率の良いアテンションメカニズムは PyTorch 1.13.1 と相性が良く、高速化とメモリ消費量の削減を同時に実現します。</li> <li>モデルのオフロードなど、その他の最適化テクニックは <a href="./optimization/fp16">this guide</a> でカバーされています。</li>',Pl,Ce,Al,ke,ql;return v=new $({props:{title:"効果的で効率的な拡散モデル",local:"効果的で効率的な拡散モデル",headingTag:"h1"}}),W=new Et({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ja/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ja/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ja/tensorflow/stable_diffusion.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ja/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ja/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ja/tensorflow/stable_diffusion.ipynb"}]}}),k=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),B=new d({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIycG9ydHJhaXQlMjBwaG90byUyMG9mJTIwYSUyMG9sZCUyMHdhcnJpb3IlMjBjaGllZiUyMg==",highlighted:'prompt = <span class="hljs-string">&quot;portrait photo of a old warrior chief&quot;</span>',wrap:!1}}),R=new $({props:{title:"Speed",local:"speed",headingTag:"h2"}}),x=new d({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKQ==",highlighted:'pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),z=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCk=",highlighted:`<span class="hljs-keyword">import</span> torch

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)`,wrap:!1}}),S=new d({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Y=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),P=new d({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbXBhdGlibGVzJTBBJTVCJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19sbXNfZGlzY3JldGUuTE1TRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3VuaXBjX211bHRpc3RlcC5VbmlQQ011bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfa19kcG1fMl9kaXNjcmV0ZS5LRFBNMkRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kZWlzX211bHRpc3RlcC5ERUlTTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9kaXNjcmV0ZS5FdWxlckRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfbXVsdGlzdGVwLkRQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRwbS5ERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfc2luZ2xlc3RlcC5EUE1Tb2x2ZXJTaW5nbGVzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19rX2RwbV8yX2FuY2VzdHJhbF9kaXNjcmV0ZS5LRFBNMkFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19oZXVuX2Rpc2NyZXRlLkhldW5EaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfcG5kbS5QTkRNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9hbmNlc3RyYWxfZGlzY3JldGUuRXVsZXJBbmNlc3RyYWxEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRpbS5ERElNU2NoZWR1bGVyJTJDJTBBJTVE",highlighted:`pipeline.scheduler.compatibles
[
    diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler,
    diffusers.schedulers.scheduling_unipc_multistep.UniPCMultistepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_discrete.KDPM2DiscreteScheduler,
    diffusers.schedulers.scheduling_deis_multistep.DEISMultistepScheduler,
    diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler,
    diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler,
    diffusers.schedulers.scheduling_ddpm.DDPMScheduler,
    diffusers.schedulers.scheduling_dpmsolver_singlestep.DPMSolverSinglestepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_ancestral_discrete.KDPM2AncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_heun_discrete.HeunDiscreteScheduler,
    diffusers.schedulers.scheduling_pndm.PNDMScheduler,
    diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_ddim.DDIMScheduler,
]`,wrap:!1}}),q=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),O=new d({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),le=new $({props:{title:"メモリー",local:"メモリー",headingTag:"h2"}}),ie=new d({props:{code:"ZGVmJTIwZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNEMSklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlMjAlM0QlMjAlNUJ0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoaSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShiYXRjaF9zaXplKSU1RCUwQSUyMCUyMCUyMCUyMHByb21wdHMlMjAlM0QlMjBiYXRjaF9zaXplJTIwKiUyMCU1QnByb21wdCU1RCUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyMCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnByb21wdCUyMiUzQSUyMHByb21wdHMlMkMlMjAlMjJnZW5lcmF0b3IlMjIlM0ElMjBnZW5lcmF0b3IlMkMlMjAlMjJudW1faW5mZXJlbmNlX3N0ZXBzJTIyJTNBJTIwbnVtX2luZmVyZW5jZV9zdGVwcyU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_inputs</span>(<span class="hljs-params">batch_size=<span class="hljs-number">1</span></span>):
    generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(i) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size)]
    prompts = batch_size * [prompt]
    num_inference_steps = <span class="hljs-number">20</span>

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;prompt&quot;</span>: prompts, <span class="hljs-string">&quot;generator&quot;</span>: generator, <span class="hljs-string">&quot;num_inference_steps&quot;</span>: num_inference_steps}`,wrap:!1}}),ae=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCoqZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNENCkpLmltYWdlcyUwQW1ha2VfaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjAyJTJDJTIwMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

images = pipeline(**get_inputs(batch_size=<span class="hljs-number">4</span>)).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),re=new d({props:{code:"cGlwZWxpbmUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCk=",highlighted:"pipeline.enable_attention_slicing()",wrap:!1}}),ce=new d({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),Me=new $({props:{title:"品質",local:"品質",headingTag:"h2"}}),oe=new $({props:{title:"より良いチェックポイント",local:"より良いチェックポイント",headingTag:"h3"}}),be=new $({props:{title:"より良いパイプラインコンポーネント",local:"より良いパイプラインコンポーネント",headingTag:"h3"}}),Je=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0wlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkLXZhZS1mdC1tc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUudmFlJTIwJTNEJTIwdmFlJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.vae = vae
images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),we=new $({props:{title:"より良いプロンプト・エンジニアリング",local:"より良いプロンプトエンジニアリング",headingTag:"h3"}}),ge=new d({props:{code:"cHJvbXB0JTIwJTJCJTNEJTIwJTIyJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMiUwQXByb21wdCUyMCUyQiUzRCUyMCUyMiUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMg==",highlighted:`prompt += <span class="hljs-string">&quot;, tribal panther make up, blue on red, side profile, looking away, serious eyes&quot;</span>
prompt += <span class="hljs-string">&quot; 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>`,wrap:!1}}),Ge=new d({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),ve=new d({props:{code:"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",highlighted:`prompts = [
    <span class="hljs-string">&quot;portrait photo of the oldest warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a old warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a young warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
]

generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(prompts))]
images = pipeline(prompt=prompts, generator=generator, num_inference_steps=<span class="hljs-number">25</span>).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),We=new $({props:{title:"次のステップ",local:"次のステップ",headingTag:"h2"}}),Ce=new Pt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ja/stable_diffusion.md"}}),{c(){b=a("meta"),Ie=i(),He=a("p"),Be=i(),m(v.$$.fragment),Re=i(),m(W.$$.fragment),Xe=i(),_=a("p"),_.innerHTML=Ol,xe=i(),V=a("p"),V.innerHTML=et,Le=i(),C=a("p"),C.innerHTML=lt,ze=i(),H=a("p"),H.innerHTML=tt,Ne=i(),m(k.$$.fragment),Se=i(),I=a("p"),I.textContent=st,Qe=i(),m(B.$$.fragment),Fe=i(),m(R.$$.fragment),Ye=i(),h=a("blockquote"),h.innerHTML=it,De=i(),X=a("p"),X.textContent=nt,Ee=i(),m(x.$$.fragment),Pe=i(),L=a("p"),L.innerHTML=at,Ae=i(),m(z.$$.fragment),qe=i(),N=a("p"),N.textContent=pt,Ke=i(),m(S.$$.fragment),Oe=i(),J=a("div"),J.innerHTML=rt,el=i(),Q=a("p"),Q.innerHTML=mt,ll=i(),F=a("p"),F.innerHTML=ct,tl=i(),m(Y.$$.fragment),sl=i(),w=a("div"),w.innerHTML=ut,il=i(),D=a("p"),D.textContent=Mt,nl=i(),T=a("blockquote"),T.innerHTML=ft,al=i(),E=a("p"),E.innerHTML=ot,pl=i(),m(P.$$.fragment),rl=i(),A=a("p"),A.innerHTML=dt,ml=i(),m(q.$$.fragment),cl=i(),K=a("p"),K.innerHTML=yt,ul=i(),m(O.$$.fragment),Ml=i(),U=a("div"),U.innerHTML=bt,fl=i(),ee=a("p"),ee.textContent=ht,ol=i(),m(le.$$.fragment),dl=i(),te=a("p"),te.innerHTML=Jt,yl=i(),se=a("p"),se.innerHTML=wt,bl=i(),m(ie.$$.fragment),hl=i(),ne=a("p"),ne.innerHTML=Tt,Jl=i(),m(ae.$$.fragment),wl=i(),pe=a("p"),pe.innerHTML=Ut,Tl=i(),m(re.$$.fragment),Ul=i(),me=a("p"),me.innerHTML=Zt,Zl=i(),m(ce.$$.fragment),gl=i(),Z=a("div"),Z.innerHTML=gt,jl=i(),ue=a("p"),ue.textContent=jt,Gl=i(),m(Me.$$.fragment),$l=i(),fe=a("p"),fe.innerHTML=Gt,vl=i(),m(oe.$$.fragment),Wl=i(),de=a("p"),de.innerHTML=$t,_l=i(),ye=a("p"),ye.innerHTML=vt,Vl=i(),m(be.$$.fragment),Cl=i(),he=a("p"),he.innerHTML=Wt,Hl=i(),m(Je.$$.fragment),kl=i(),g=a("div"),g.innerHTML=_t,Il=i(),m(we.$$.fragment),Bl=i(),Te=a("p"),Te.innerHTML=Vt,Rl=i(),Ue=a("ul"),Ue.innerHTML=Ct,Xl=i(),Ze=a("p"),Ze.textContent=Ht,xl=i(),m(ge.$$.fragment),Ll=i(),je=a("p"),je.textContent=kt,zl=i(),m(Ge.$$.fragment),Nl=i(),j=a("div"),j.innerHTML=It,Sl=i(),$e=a("p"),$e.innerHTML=Bt,Ql=i(),m(ve.$$.fragment),Fl=i(),G=a("div"),G.innerHTML=Rt,Yl=i(),m(We.$$.fragment),Dl=i(),_e=a("p"),_e.innerHTML=Xt,El=i(),Ve=a("ul"),Ve.innerHTML=xt,Pl=i(),m(Ce.$$.fragment),Al=i(),ke=a("p"),this.h()},l(e){const l=Yt("svelte-u9bgzb",document.head);b=p(l,"META",{name:!0,content:!0}),l.forEach(t),Ie=n(e),He=p(e,"P",{}),Lt(He).forEach(t),Be=n(e),c(v.$$.fragment,e),Re=n(e),c(W.$$.fragment,e),Xe=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-110xkzt"&&(_.innerHTML=Ol),xe=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-110m145"&&(V.innerHTML=et),Le=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-4juhq1"&&(C.innerHTML=lt),ze=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-9bt3dz"&&(H.innerHTML=tt),Ne=n(e),c(k.$$.fragment,e),Se=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1p8bqyv"&&(I.textContent=st),Qe=n(e),c(B.$$.fragment,e),Fe=n(e),c(R.$$.fragment,e),Ye=n(e),h=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-ng7pew"&&(h.innerHTML=it),De=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-10gtbbd"&&(X.textContent=nt),Ee=n(e),c(x.$$.fragment,e),Pe=n(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-jq2u2i"&&(L.innerHTML=at),Ae=n(e),c(z.$$.fragment,e),qe=n(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1d3ggr0"&&(N.textContent=pt),Ke=n(e),c(S.$$.fragment,e),Oe=n(e),J=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1of5nwm"&&(J.innerHTML=rt),el=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1g8ad1q"&&(Q.innerHTML=mt),ll=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1li8qua"&&(F.innerHTML=ct),tl=n(e),c(Y.$$.fragment,e),sl=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1why3l7"&&(w.innerHTML=ut),il=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1ou4bc2"&&(D.textContent=Mt),nl=n(e),T=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1s3r878"&&(T.innerHTML=ft),al=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1w5obo7"&&(E.innerHTML=ot),pl=n(e),c(P.$$.fragment,e),rl=n(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1wi1jv0"&&(A.innerHTML=dt),ml=n(e),c(q.$$.fragment,e),cl=n(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1sfqrua"&&(K.innerHTML=yt),ul=n(e),c(O.$$.fragment,e),Ml=n(e),U=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-19w49w4"&&(U.innerHTML=bt),fl=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-76wtm1"&&(ee.textContent=ht),ol=n(e),c(le.$$.fragment,e),dl=n(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-mvbq4l"&&(te.innerHTML=Jt),yl=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1hr0mha"&&(se.innerHTML=wt),bl=n(e),c(ie.$$.fragment,e),hl=n(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1o7tisn"&&(ne.innerHTML=Tt),Jl=n(e),c(ae.$$.fragment,e),wl=n(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1vhu601"&&(pe.innerHTML=Ut),Tl=n(e),c(re.$$.fragment,e),Ul=n(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-fxkzqi"&&(me.innerHTML=Zt),Zl=n(e),c(ce.$$.fragment,e),gl=n(e),Z=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-vxa9bu"&&(Z.innerHTML=gt),jl=n(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-16an5na"&&(ue.textContent=jt),Gl=n(e),c(Me.$$.fragment,e),$l=n(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-t5m3mc"&&(fe.innerHTML=Gt),vl=n(e),c(oe.$$.fragment,e),Wl=n(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1on671o"&&(de.innerHTML=$t),_l=n(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-94e2nw"&&(ye.innerHTML=vt),Vl=n(e),c(be.$$.fragment,e),Cl=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-4hs92t"&&(he.innerHTML=Wt),Hl=n(e),c(Je.$$.fragment,e),kl=n(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-610rhb"&&(g.innerHTML=_t),Il=n(e),c(we.$$.fragment,e),Bl=n(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1mzftxu"&&(Te.innerHTML=Vt),Rl=n(e),Ue=p(e,"UL",{"data-svelte-h":!0}),r(Ue)!=="svelte-rjnows"&&(Ue.innerHTML=Ct),Xl=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-147l7so"&&(Ze.textContent=Ht),xl=n(e),c(ge.$$.fragment,e),Ll=n(e),je=p(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-175521y"&&(je.textContent=kt),zl=n(e),c(Ge.$$.fragment,e),Nl=n(e),j=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-n1o5lk"&&(j.innerHTML=It),Sl=n(e),$e=p(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-saeyf2"&&($e.innerHTML=Bt),Ql=n(e),c(ve.$$.fragment,e),Fl=n(e),G=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(G)!=="svelte-1lkw2bx"&&(G.innerHTML=Rt),Yl=n(e),c(We.$$.fragment,e),Dl=n(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1uv4l8d"&&(_e.innerHTML=Xt),El=n(e),Ve=p(e,"UL",{"data-svelte-h":!0}),r(Ve)!=="svelte-j2u29p"&&(Ve.innerHTML=xt),Pl=n(e),c(Ce.$$.fragment,e),Al=n(e),ke=p(e,"P",{}),Lt(ke).forEach(t),this.h()},h(){y(b,"name","hf:doc:metadata"),y(b,"content",qt),y(h,"class","tip"),y(J,"class","flex justify-center"),y(w,"class","flex justify-center"),y(T,"class","tip"),y(U,"class","flex justify-center"),y(Z,"class","flex justify-center"),y(g,"class","flex justify-center"),y(j,"class","flex justify-center"),y(G,"class","flex justify-center")},m(e,l){Dt(document.head,b),s(e,Ie,l),s(e,He,l),s(e,Be,l),u(v,e,l),s(e,Re,l),u(W,e,l),s(e,Xe,l),s(e,_,l),s(e,xe,l),s(e,V,l),s(e,Le,l),s(e,C,l),s(e,ze,l),s(e,H,l),s(e,Ne,l),u(k,e,l),s(e,Se,l),s(e,I,l),s(e,Qe,l),u(B,e,l),s(e,Fe,l),u(R,e,l),s(e,Ye,l),s(e,h,l),s(e,De,l),s(e,X,l),s(e,Ee,l),u(x,e,l),s(e,Pe,l),s(e,L,l),s(e,Ae,l),u(z,e,l),s(e,qe,l),s(e,N,l),s(e,Ke,l),u(S,e,l),s(e,Oe,l),s(e,J,l),s(e,el,l),s(e,Q,l),s(e,ll,l),s(e,F,l),s(e,tl,l),u(Y,e,l),s(e,sl,l),s(e,w,l),s(e,il,l),s(e,D,l),s(e,nl,l),s(e,T,l),s(e,al,l),s(e,E,l),s(e,pl,l),u(P,e,l),s(e,rl,l),s(e,A,l),s(e,ml,l),u(q,e,l),s(e,cl,l),s(e,K,l),s(e,ul,l),u(O,e,l),s(e,Ml,l),s(e,U,l),s(e,fl,l),s(e,ee,l),s(e,ol,l),u(le,e,l),s(e,dl,l),s(e,te,l),s(e,yl,l),s(e,se,l),s(e,bl,l),u(ie,e,l),s(e,hl,l),s(e,ne,l),s(e,Jl,l),u(ae,e,l),s(e,wl,l),s(e,pe,l),s(e,Tl,l),u(re,e,l),s(e,Ul,l),s(e,me,l),s(e,Zl,l),u(ce,e,l),s(e,gl,l),s(e,Z,l),s(e,jl,l),s(e,ue,l),s(e,Gl,l),u(Me,e,l),s(e,$l,l),s(e,fe,l),s(e,vl,l),u(oe,e,l),s(e,Wl,l),s(e,de,l),s(e,_l,l),s(e,ye,l),s(e,Vl,l),u(be,e,l),s(e,Cl,l),s(e,he,l),s(e,Hl,l),u(Je,e,l),s(e,kl,l),s(e,g,l),s(e,Il,l),u(we,e,l),s(e,Bl,l),s(e,Te,l),s(e,Rl,l),s(e,Ue,l),s(e,Xl,l),s(e,Ze,l),s(e,xl,l),u(ge,e,l),s(e,Ll,l),s(e,je,l),s(e,zl,l),u(Ge,e,l),s(e,Nl,l),s(e,j,l),s(e,Sl,l),s(e,$e,l),s(e,Ql,l),u(ve,e,l),s(e,Fl,l),s(e,G,l),s(e,Yl,l),u(We,e,l),s(e,Dl,l),s(e,_e,l),s(e,El,l),s(e,Ve,l),s(e,Pl,l),u(Ce,e,l),s(e,Al,l),s(e,ke,l),ql=!0},p:Nt,i(e){ql||(M(v.$$.fragment,e),M(W.$$.fragment,e),M(k.$$.fragment,e),M(B.$$.fragment,e),M(R.$$.fragment,e),M(x.$$.fragment,e),M(z.$$.fragment,e),M(S.$$.fragment,e),M(Y.$$.fragment,e),M(P.$$.fragment,e),M(q.$$.fragment,e),M(O.$$.fragment,e),M(le.$$.fragment,e),M(ie.$$.fragment,e),M(ae.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(Me.$$.fragment,e),M(oe.$$.fragment,e),M(be.$$.fragment,e),M(Je.$$.fragment,e),M(we.$$.fragment,e),M(ge.$$.fragment,e),M(Ge.$$.fragment,e),M(ve.$$.fragment,e),M(We.$$.fragment,e),M(Ce.$$.fragment,e),ql=!0)},o(e){f(v.$$.fragment,e),f(W.$$.fragment,e),f(k.$$.fragment,e),f(B.$$.fragment,e),f(R.$$.fragment,e),f(x.$$.fragment,e),f(z.$$.fragment,e),f(S.$$.fragment,e),f(Y.$$.fragment,e),f(P.$$.fragment,e),f(q.$$.fragment,e),f(O.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(ce.$$.fragment,e),f(Me.$$.fragment,e),f(oe.$$.fragment,e),f(be.$$.fragment,e),f(Je.$$.fragment,e),f(we.$$.fragment,e),f(ge.$$.fragment,e),f(Ge.$$.fragment,e),f(ve.$$.fragment,e),f(We.$$.fragment,e),f(Ce.$$.fragment,e),ql=!1},d(e){e&&(t(Ie),t(He),t(Be),t(Re),t(Xe),t(_),t(xe),t(V),t(Le),t(C),t(ze),t(H),t(Ne),t(Se),t(I),t(Qe),t(Fe),t(Ye),t(h),t(De),t(X),t(Ee),t(Pe),t(L),t(Ae),t(qe),t(N),t(Ke),t(Oe),t(J),t(el),t(Q),t(ll),t(F),t(tl),t(sl),t(w),t(il),t(D),t(nl),t(T),t(al),t(E),t(pl),t(rl),t(A),t(ml),t(cl),t(K),t(ul),t(Ml),t(U),t(fl),t(ee),t(ol),t(dl),t(te),t(yl),t(se),t(bl),t(hl),t(ne),t(Jl),t(wl),t(pe),t(Tl),t(Ul),t(me),t(Zl),t(gl),t(Z),t(jl),t(ue),t(Gl),t($l),t(fe),t(vl),t(Wl),t(de),t(_l),t(ye),t(Vl),t(Cl),t(he),t(Hl),t(kl),t(g),t(Il),t(Bl),t(Te),t(Rl),t(Ue),t(Xl),t(Ze),t(xl),t(Ll),t(je),t(zl),t(Nl),t(j),t(Sl),t($e),t(Ql),t(Fl),t(G),t(Yl),t(Dl),t(_e),t(El),t(Ve),t(Pl),t(Al),t(ke)),t(b),o(v,e),o(W,e),o(k,e),o(B,e),o(R,e),o(x,e),o(z,e),o(S,e),o(Y,e),o(P,e),o(q,e),o(O,e),o(le,e),o(ie,e),o(ae,e),o(re,e),o(ce,e),o(Me,e),o(oe,e),o(be,e),o(Je,e),o(we,e),o(ge,e),o(Ge,e),o(ve,e),o(We,e),o(Ce,e)}}}const qt='{"title":"効果的で効率的な拡散モデル","local":"効果的で効率的な拡散モデル","sections":[{"title":"Speed","local":"speed","sections":[],"depth":2},{"title":"メモリー","local":"メモリー","sections":[],"depth":2},{"title":"品質","local":"品質","sections":[{"title":"より良いチェックポイント","local":"より良いチェックポイント","sections":[],"depth":3},{"title":"より良いパイプラインコンポーネント","local":"より良いパイプラインコンポーネント","sections":[],"depth":3},{"title":"より良いプロンプト・エンジニアリング","local":"より良いプロンプトエンジニアリング","sections":[],"depth":3}],"depth":2},{"title":"次のステップ","local":"次のステップ","sections":[],"depth":2}],"depth":1}';function Kt(Kl){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class is extends Qt{constructor(b){super(),Ft(this,b,Kt,At,zt,{})}}export{is as component};
