import{s as ml,n as fl,o as ol}from"../chunks/scheduler.80eaf607.js";import{S as ul,i as cl,e as i,s as n,c as f,h as rl,a as p,d as s,b as a,f as pl,j as o,g as m,k as Be,l as dl,m as l,n as u,t as c,o as r,p as d}from"../chunks/index.47529bd5.js";import{C as g}from"../chunks/CodeBlock.204d0d0f.js";import{D as gl}from"../chunks/DocNotebookDropdown.5da6b2b6.js";import{H as Se,E as hl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9d0d6126.js";function Ml(cs){let h,Ne,Ve,Xe,$,Pe,U,Re,T,rs="拡散モデル(Diffusion Model)は、ランダムな正規分布から段階的にノイズ除去するように学習され、画像や音声などの目的のものを生成できます。これは生成AIに多大な関心を呼び起こしました。インターネット上で拡散によって生成された画像の例を見たことがあるでしょう。🧨 Diffusersは、誰もが拡散モデルに広くアクセスできるようにすることを目的としたライブラリです。",Ye,_,ds="この案内では、開発者または日常的なユーザーに関わらず、🧨 Diffusers を紹介し、素早く目的のものを生成できるようにします！このライブラリには3つの主要コンポーネントがあります:",De,v,gs='<li><code>DiffusionPipeline</code>は事前に学習された拡散モデルからサンプルを迅速に生成するために設計された高レベルのエンドツーエンドクラス。</li> <li>拡散システムを作成するためのビルディングブロックとして使用できる、人気のある事前学習された<a href="./api/models">モデル</a>アーキテクチャとモジュール。</li> <li>多くの異なる<a href="./api/schedulers/overview">スケジューラ</a> - ノイズがどのようにトレーニングのために加えられるか、そして生成中にどのようにノイズ除去された画像を生成するかを制御するアルゴリズム。</li>',Ee,C,hs="この案内では、<code>DiffusionPipeline</code>を生成に使用する方法を紹介し、モデルとスケジューラを組み合わせて<code>DiffusionPipeline</code>の内部で起こっていることを再現する方法を説明します。",Qe,M,Ms='<p>この案内は🧨 Diffusers <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/diffusers_intro.ipynb" rel="nofollow">ノートブック</a>を簡略化したもので、すぐに使い始めることができます。Diffusers 🧨のゴール、設計哲学、コアAPIの詳細についてもっと知りたい方は、ノートブックをご覧ください！</p>',Fe,J,bs="始める前に必要なライブラリーがすべてインストールされていることを確認してください：",Ae,Z,Ke,x,js='<li><a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate</a>生成とトレーニングのためのモデルのロードを高速化します</li> <li><a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a>ような最も一般的な拡散モデルを実行するには、<a href="https://huggingface.co/docs/transformers/index" rel="nofollow">🤗 Transformers</a>が必要です。</li>',Oe,k,et,G,ys='<code>DiffusionPipeline</code>は事前学習された拡散システムを生成に使用する最も簡単な方法です。これはモデルとスケジューラを含むエンドツーエンドのシステムです。<code>DiffusionPipeline</code>は多くの作業／タスクにすぐに使用することができます。また、サポートされているタスクの完全なリストについては<a href="./api/pipelines/overview#diffusers-summary">🧨Diffusersの概要</a>の表を参照してください。',tt,W,ws='<thead><tr><th><strong>タスク</strong></th> <th><strong>説明</strong></th> <th><strong>パイプライン</strong></th></tr></thead> <tbody><tr><td>Unconditional Image Generation</td> <td>正規分布から画像生成</td> <td><a href="./using-diffusers/unconditional_image_generation">unconditional_image_generation</a></td></tr> <tr><td>Text-Guided Image Generation</td> <td>文章から画像生成</td> <td><a href="./using-diffusers/conditional_image_generation">conditional_image_generation</a></td></tr> <tr><td>Text-Guided Image-to-Image Translation</td> <td>画像と文章から新たな画像生成</td> <td><a href="./using-diffusers/img2img">img2img</a></td></tr> <tr><td>Text-Guided Image-Inpainting</td> <td>画像、マスク、および文章が指定された場合に、画像のマスクされた部分を文章をもとに修復</td> <td><a href="./using-diffusers/inpaint">inpaint</a></td></tr> <tr><td>Text-Guided Depth-to-Image Translation</td> <td>文章と深度推定によって構造を保持しながら画像生成</td> <td><a href="./using-diffusers/depth2img">depth2img</a></td></tr></tbody>',st,q,$s=`まず、<code>DiffusionPipeline</code>のインスタンスを作成し、ダウンロードしたいパイプラインのチェックポイントを指定します。
この<code>DiffusionPipeline</code>はHugging Face Hubに保存されている任意の<a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">チェックポイント</a>を使用することができます。
この案内では、<a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5</code></a>チェックポイントでテキストから画像へ生成します。`,lt,H,Us='<p>[!WARNING][Stable Diffusion]モデルについては、モデルを実行する前にまず<a href="https://huggingface.co/spaces/CompVis/stable-diffusion-license" rel="nofollow">ライセンス</a>を注意深くお読みください。🧨  Diffusers は、攻撃的または有害なコンテンツを防ぐために <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow"><code>safety_checker</code></a> を実装していますが、モデルの改良された画像生成機能により、潜在的に有害なコンテンツが生成される可能性があります。</p>',nt,L,Ts="モデルを<code>from_pretrained()</code>メソッドでロードします：",at,I,it,B,_s="<code>DiffusionPipeline</code>は全てのモデリング、トークン化、スケジューリングコンポーネントをダウンロードしてキャッシュします。Stable Diffusionパイプラインは<code>UNet2DConditionModel</code>と<code>PNDMScheduler</code>などで構成されています：",pt,S,mt,V,vs=`このモデルはおよそ14億個のパラメータで構成されているため、GPU上でパイプラインを実行することを強く推奨します。
PyTorchと同じように、ジェネレータオブジェクトをGPUに移すことができます：`,ft,z,ot,N,Cs='これで、文章を <code>pipeline</code> に渡して画像を生成し、ノイズ除去された画像にアクセスできるようになりました。デフォルトでは、画像出力は<a href="https://pillow.readthedocs.io/en/stable/reference/Image.html?highlight=image#the-image-class" rel="nofollow"><code>PIL.Image</code></a>オブジェクトでラップされます。',ut,X,ct,b,Js='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/image_of_squirrel_painting.png"/>',rt,P,Zs="<code>save</code>関数で画像を保存できます:",dt,R,gt,Y,ht,D,xs="ローカルでパイプラインを使用することもできます。唯一の違いは、最初にウェイトをダウンロードする必要があることです：",Mt,E,bt,Q,ks="保存したウェイトをパイプラインにロードします：",jt,F,yt,A,Gs="これで、上のセクションと同じようにパイプラインを動かすことができます。",wt,K,$t,O,Ws="スケジューラーによって、ノイズ除去のスピードや品質のトレードオフが異なります。どれが自分に最適かを知る最善の方法は、実際に試してみることです！Diffusers 🧨の主な機能の1つは、スケジューラを簡単に切り替えることができることです。例えば、デフォルトの<code>PNDMScheduler</code>を<code>EulerDiscreteScheduler</code>に置き換えるには、<code>from_config()</code>メソッドでロードできます：",Ut,ee,Tt,te,qs="新しいスケジューラを使って画像を生成し、その違いに気づくかどうか試してみてください！",_t,se,Hs="次のセクションでは、<code>DiffusionPipeline</code>を構成するコンポーネント（モデルとスケジューラ）を詳しく見て、これらのコンポーネントを使って猫の画像を生成する方法を学びます。",vt,le,Ct,ne,Ls='ほとんどのモデルはノイズの多いサンプルを取り、各タイムステップで<em>残りのノイズ</em>を予測します（他のモデルは前のサンプルを直接予測するか、速度または<a href="https://github.com/huggingface/diffusers/blob/5e5ce13e2f89ac45a0066cb3f369462a3cf1d9ef/src/diffusers/schedulers/scheduling_ddim.py#L110" rel="nofollow"><code>v-prediction</code></a>を予測するように学習します）。モデルを混ぜて他の拡散システムを作ることもできます。',Jt,ae,Is="モデルは<code>from_pretrained()</code>メソッドで開始されます。このメソッドはモデルをローカルにキャッシュするので、次にモデルをロードするときに高速になります。この案内では、<code>UNet2DModel</code>をロードします。これは基本的な画像生成モデルであり、猫画像で学習されたチェックポイントを使います：",Zt,ie,xt,pe,Bs="モデルのパラメータにアクセスするには、<code>model.config</code> を呼び出せます：",kt,me,Gt,fe,Ss="モデル構成は🧊凍結🧊されたディクショナリであり、モデル作成後にこれらのパラメー タを変更することはできません。これは意図的なもので、最初にモデル・アーキテクチャを定義するために使用されるパラメータが同じままであることを保証します。他のパラメータは生成中に調整することができます。",Wt,oe,Vs="最も重要なパラメータは以下の通りです：",qt,ue,zs="<li>sample_size`: 入力サンプルの高さと幅。</li> <li><code>in_channels</code>: 入力サンプルの入力チャンネル数。</li> <li>down_block_types<code>と</code>up_block_types`: UNet アーキテクチャを作成するために使用されるダウンサンプリングブロックとアップサンプリングブロックのタイプ。</li> <li>block_out_channels`: ダウンサンプリングブロックの出力チャンネル数。逆順でアップサンプリングブロックの入力チャンネル数にも使用されます。</li> <li>layer_per_block`: 各 UNet ブロックに含まれる ResNet ブロックの数。</li>",Ht,ce,Ns="このモデルを生成に使用するには、ランダムな画像の形の正規分布を作成します。このモデルは複数のランダムな正規分布を受け取ることができるため<code>batch</code>軸を入れます。入力チャンネル数に対応する<code>channel</code>軸も必要です。画像の高さと幅に対応する<code>sample_size</code>軸を持つ必要があります：",Lt,re,It,de,Xs="画像生成には、ノイズの多い画像と <code>timestep</code> をモデルに渡します。<code>timestep</code>は入力画像がどの程度ノイズが多いかを示します。これは、モデルが拡散プロセスにおける自分の位置を決定するのに役立ちます。モデルの出力を得るには <code>sample</code> メソッドを使用します：",Bt,ge,St,he,Ps="しかし、実際の例を生成するには、ノイズ除去プロセスをガイドするスケジューラが必要です。次のセクションでは、モデルをスケジューラと組み合わせる方法を学びます。",Vt,Me,zt,be,Rs="スケジューラは、モデルの出力（この場合は <code>noisy_residual</code> ）が与えられたときに、ノイズの多いサンプルからノイズの少ないサンプルへの移行を管理します。",Nt,j,Ys="<p>🧨 Diffusersは拡散システムを構築するためのツールボックスです。<code>DiffusionPipeline</code>は事前に構築された拡散システムを使い始めるのに便利な方法ですが、独自のモデルとスケジューラコンポーネントを個別に選択してカスタム拡散システムを構築することもできます。</p>",Xt,je,Ds="この案内では、<code>DDPMScheduler</code>を<code>from_config()</code>メソッドでインスタンス化します：",Pt,ye,Rt,y,Es="<p>💡 スケジューラがどのようにコンフィギュレーションからインスタンス化されるかに注目してください。モデルとは異なり、スケジューラは学習可能な重みを持たず、パラメーターを持ちません！</p>",Yt,we,Qs="最も重要なパラメータは以下の通りです：",Dt,$e,Fs="<li>num_train_timesteps`: ノイズ除去処理の長さ、言い換えれば、ランダムな正規分布をデータサンプルに処理するのに必要なタイムステップ数です。</li> <li><code>beta_schedule</code>: 生成とトレーニングに使用するノイズスケジュールのタイプ。</li> <li><code>beta_start</code> と <code>beta_end</code>: ノイズスケジュールの開始値と終了値。</li>",Et,Ue,As="少しノイズの少ない画像を予測するには、スケジューラの <code>step()</code> メソッドに以下を渡します: モデルの出力、<code>timestep</code>、現在の <code>sample</code>。",Qt,Te,Ft,_e,Ks="<code>less_noisy_sample</code>は次の<code>timestep</code>に渡すことができ、そこでさらにノイズが少なくなります！",At,ve,Os="では、すべてをまとめて、ノイズ除去プロセス全体を視覚化してみましょう。",Kt,Ce,el="まず、ノイズ除去された画像を後処理して <code>PIL.Image</code> として表示する関数を作成します：",Ot,Je,es,Ze,tl="ノイズ除去処理を高速化するために入力とモデルをGPUに移します：",ts,xe,ss,ke,sl="ここで、ノイズが少なくなったサンプルの残りのノイズを予測するノイズ除去ループを作成し、スケジューラを使ってさらにノイズの少ないサンプルを計算します：",ls,Ge,ns,We,ll="何もないところから猫が生成されるのを、座って見てください！😻",as,w,nl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/diffusion-quicktour.png"/>',is,qe,ps,He,al="このクイックツアーで、🧨ディフューザーを使ったクールな画像をいくつか作成できたと思います！次のステップとして",ms,Le,il='<li>モデルをトレーニングまたは微調整については、<a href="./tutorials/basic_training">training</a>チュートリアルを参照してください。</li> <li>様々な使用例については、公式およびコミュニティの<a href="https://github.com/huggingface/diffusers/tree/main/examples#-diffusers-examples" rel="nofollow">training or finetuning scripts</a>の例を参照してください。</li> <li>スケジューラのロード、アクセス、変更、比較については<a href="./using-diffusers/schedulers">Using different Schedulers</a>ガイドを参照してください。</li> <li>プロンプトエンジニアリング、スピードとメモリの最適化、より高品質な画像を生成するためのヒントやトリックについては、<a href="./stable_diffusion">Stable Diffusion</a>ガイドを参照してください。</li> <li>🧨 Diffusers の高速化については、最適化された <a href="./optimization/fp16">PyTorch on a GPU</a>のガイド、<a href="./optimization/mps">Stable Diffusion on Apple Silicon (M1/M2)</a>と<a href="./optimization/onnx">ONNX Runtime</a>を参照してください。</li>',fs,Ie,os,ze,us;return $=new gl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ja/quicktour.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ja/pytorch/quicktour.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ja/tensorflow/quicktour.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ja/quicktour.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ja/pytorch/quicktour.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ja/tensorflow/quicktour.ipynb"}]}}),U=new Se({props:{title:"簡単な案内",local:"簡単な案内",headingTag:"h1"}}),Z=new g({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLS11cGdyYWRlJTIwZGlmZnVzZXJzJTIwYWNjZWxlcmF0ZSUyMHRyYW5zZm9ybWVycw==",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install --upgrade diffusers accelerate transformers</span>`,wrap:!1}}),k=new Se({props:{title:"拡散パイプライン",local:"拡散パイプライン",headingTag:"h2"}}),I=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),S=new g({props:{code:"cGlwZWxpbmU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline
StableDiffusionPipeline {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.13.1&quot;</span>,
  ...,
  <span class="hljs-string">&quot;scheduler&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  ],
  ...,
  <span class="hljs-string">&quot;unet&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  ],
  <span class="hljs-string">&quot;vae&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  ]
}`,wrap:!1}}),z=new g({props:{code:"cGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),X=new g({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJBbiUyMGltYWdlJTIwb2YlMjBhJTIwc3F1aXJyZWwlMjBpbiUyMFBpY2Fzc28lMjBzdHlsZSUyMikuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipeline(<span class="hljs-string">&quot;An image of a squirrel in Picasso style&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),R=new g({props:{code:"aW1hZ2Uuc2F2ZSglMjJpbWFnZV9vZl9zcXVpcnJlbF9wYWludGluZy5wbmclMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;image_of_squirrel_painting.png&quot;</span>)',wrap:!1}}),Y=new Se({props:{title:"ローカルパイプライン",local:"ローカルパイプライン",headingTag:"h3"}}),E=new g({props:{code:"IWdpdCUyMGxmcyUyMGluc3RhbGwlMEEhZ2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01",highlighted:`!git lfs install
!git <span class="hljs-built_in">clone</span> https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5`,wrap:!1}}),F=new g({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)',wrap:!1}}),K=new Se({props:{title:"スケジューラの交換",local:"スケジューラの交換",headingTag:"h3"}}),ee=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = EulerDiscreteScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),le=new Se({props:{title:"モデル",local:"モデル",headingTag:"h2"}}),ie=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiUwQW1vZGVsJTIwJTNEJTIwVU5ldDJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),me=new g({props:{code:"bW9kZWwuY29uZmln",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.config',wrap:!1}}),re=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5tYW51YWxfc2VlZCgwKSUwQSUwQW5vaXN5X3NhbXBsZSUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjBtb2RlbC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBtb2RlbC5jb25maWcuc2FtcGxlX3NpemUlMkMlMjBtb2RlbC5jb25maWcuc2FtcGxlX3NpemUpJTBBbm9pc3lfc2FtcGxlLnNoYXBl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample = torch.randn(<span class="hljs-number">1</span>, model.config.in_channels, model.config.sample_size, model.config.sample_size)
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample.shape
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>])`,wrap:!1}}),ge=new g({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG5vaXN5X3Jlc2lkdWFsJTIwJTNEJTIwbW9kZWwoc2FtcGxlJTNEbm9pc3lfc2FtcGxlJTJDJTIwdGltZXN0ZXAlM0QyKS5zYW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    noisy_residual = model(sample=noisy_sample, timestep=<span class="hljs-number">2</span>).sample`,wrap:!1}}),Me=new Se({props:{title:"スケジューラ",local:"スケジューラ",headingTag:"h2"}}),ye=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fY29uZmlnKHJlcG9faWQpJTBBc2NoZWR1bGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDPMScheduler.from_config(repo_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler
DDPMScheduler {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;DDPMScheduler&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.13.1&quot;</span>,
  <span class="hljs-string">&quot;beta_end&quot;</span>: <span class="hljs-number">0.02</span>,
  <span class="hljs-string">&quot;beta_schedule&quot;</span>: <span class="hljs-string">&quot;linear&quot;</span>,
  <span class="hljs-string">&quot;beta_start&quot;</span>: <span class="hljs-number">0.0001</span>,
  <span class="hljs-string">&quot;clip_sample&quot;</span>: true,
  <span class="hljs-string">&quot;clip_sample_range&quot;</span>: <span class="hljs-number">1.0</span>,
  <span class="hljs-string">&quot;num_train_timesteps&quot;</span>: <span class="hljs-number">1000</span>,
  <span class="hljs-string">&quot;prediction_type&quot;</span>: <span class="hljs-string">&quot;epsilon&quot;</span>,
  <span class="hljs-string">&quot;trained_betas&quot;</span>: null,
  <span class="hljs-string">&quot;variance_type&quot;</span>: <span class="hljs-string">&quot;fixed_small&quot;</span>
}`,wrap:!1}}),Te=new g({props:{code:"bGVzc19ub2lzeV9zYW1wbGUlMjAlM0QlMjBzY2hlZHVsZXIuc3RlcChtb2RlbF9vdXRwdXQlM0Rub2lzeV9yZXNpZHVhbCUyQyUyMHRpbWVzdGVwJTNEMiUyQyUyMHNhbXBsZSUzRG5vaXN5X3NhbXBsZSkucHJldl9zYW1wbGUlMEFsZXNzX25vaXN5X3NhbXBsZS5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>less_noisy_sample = scheduler.step(model_output=noisy_residual, timestep=<span class="hljs-number">2</span>, sample=noisy_sample).prev_sample
<span class="hljs-meta">&gt;&gt;&gt; </span>less_noisy_sample.shape`,wrap:!1}}),Je=new g({props:{code:"aW1wb3J0JTIwUElMLkltYWdlJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwZGlzcGxheV9zYW1wbGUoc2FtcGxlJTJDJTIwaSklM0ElMEElMjAlMjAlMjAlMjBpbWFnZV9wcm9jZXNzZWQlMjAlM0QlMjBzYW1wbGUuY3B1KCkucGVybXV0ZSgwJTJDJTIwMiUyQyUyMDMlMkMlMjAxKSUwQSUyMCUyMCUyMCUyMGltYWdlX3Byb2Nlc3NlZCUyMCUzRCUyMChpbWFnZV9wcm9jZXNzZWQlMjAlMkIlMjAxLjApJTIwKiUyMDEyNy41JTBBJTIwJTIwJTIwJTIwaW1hZ2VfcHJvY2Vzc2VkJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc2VkLm51bXB5KCkuYXN0eXBlKG5wLnVpbnQ4KSUwQSUwQSUyMCUyMCUyMCUyMGltYWdlX3BpbCUyMCUzRCUyMFBJTC5JbWFnZS5mcm9tYXJyYXkoaW1hZ2VfcHJvY2Vzc2VkJTVCMCU1RCklMEElMjAlMjAlMjAlMjBkaXNwbGF5KGYlMjJJbWFnZSUyMGF0JTIwc3RlcCUyMCU3QmklN0QlMjIpJTBBJTIwJTIwJTIwJTIwZGlzcGxheShpbWFnZV9waWwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL.Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">display_sample</span>(<span class="hljs-params">sample, i</span>):
<span class="hljs-meta">... </span>    image_processed = sample.cpu().permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    image_processed = (image_processed + <span class="hljs-number">1.0</span>) * <span class="hljs-number">127.5</span>
<span class="hljs-meta">... </span>    image_processed = image_processed.numpy().astype(np.uint8)

<span class="hljs-meta">... </span>    image_pil = PIL.Image.fromarray(image_processed[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>    display(<span class="hljs-string">f&quot;Image at step <span class="hljs-subst">{i}</span>&quot;</span>)
<span class="hljs-meta">... </span>    display(image_pil)`,wrap:!1}}),xe=new g({props:{code:"bW9kZWwudG8oJTIyY3VkYSUyMiklMEFub2lzeV9zYW1wbGUlMjAlM0QlMjBub2lzeV9zYW1wbGUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample = noisy_sample.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Ge=new g({props:{code:"aW1wb3J0JTIwdHFkbSUwQSUwQXNhbXBsZSUyMCUzRCUyMG5vaXN5X3NhbXBsZSUwQSUwQWZvciUyMGklMkMlMjB0JTIwaW4lMjBlbnVtZXJhdGUodHFkbS50cWRtKHNjaGVkdWxlci50aW1lc3RlcHMpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMDEuJTIwcHJlZGljdCUyMG5vaXNlJTIwcmVzaWR1YWwlMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWwlMjAlM0QlMjBtb2RlbChzYW1wbGUlMkMlMjB0KS5zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAyLiUyMGNvbXB1dGUlMjBsZXNzJTIwbm9pc3klMjBpbWFnZSUyMGFuZCUyMHNldCUyMHhfdCUyMC0lM0UlMjB4X3QtMSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKHJlc2lkdWFsJTJDJTIwdCUyQyUyMHNhbXBsZSkucHJldl9zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAzLiUyMG9wdGlvbmFsbHklMjBsb29rJTIwYXQlMjBpbWFnZSUwQSUyMCUyMCUyMCUyMGlmJTIwKGklMjAlMkIlMjAxKSUyMCUyNSUyMDUwJTIwJTNEJTNEJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc3BsYXlfc2FtcGxlKHNhbXBsZSUyQyUyMGklMjAlMkIlMjAxKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>sample = noisy_sample

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm.tqdm(scheduler.timesteps)):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># 1. predict noise residual</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        residual = model(sample, t).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># 2. compute less noisy image and set x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    sample = scheduler.step(residual, t, sample).prev_sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># 3. optionally look at image</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> (i + <span class="hljs-number">1</span>) % <span class="hljs-number">50</span> == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>        display_sample(sample, i + <span class="hljs-number">1</span>)`,wrap:!1}}),qe=new Se({props:{title:"次のステップ",local:"次のステップ",headingTag:"h2"}}),Ie=new hl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ja/quicktour.md"}}),{c(){h=i("meta"),Ne=n(),Ve=i("p"),Xe=n(),f($.$$.fragment),Pe=n(),f(U.$$.fragment),Re=n(),T=i("p"),T.textContent=rs,Ye=n(),_=i("p"),_.textContent=ds,De=n(),v=i("ul"),v.innerHTML=gs,Ee=n(),C=i("p"),C.innerHTML=hs,Qe=n(),M=i("blockquote"),M.innerHTML=Ms,Fe=n(),J=i("p"),J.textContent=bs,Ae=n(),f(Z.$$.fragment),Ke=n(),x=i("ul"),x.innerHTML=js,Oe=n(),f(k.$$.fragment),et=n(),G=i("p"),G.innerHTML=ys,tt=n(),W=i("table"),W.innerHTML=ws,st=n(),q=i("p"),q.innerHTML=$s,lt=n(),H=i("blockquote"),H.innerHTML=Us,nt=n(),L=i("p"),L.innerHTML=Ts,at=n(),f(I.$$.fragment),it=n(),B=i("p"),B.innerHTML=_s,pt=n(),f(S.$$.fragment),mt=n(),V=i("p"),V.textContent=vs,ft=n(),f(z.$$.fragment),ot=n(),N=i("p"),N.innerHTML=Cs,ut=n(),f(X.$$.fragment),ct=n(),b=i("div"),b.innerHTML=Js,rt=n(),P=i("p"),P.innerHTML=Zs,dt=n(),f(R.$$.fragment),gt=n(),f(Y.$$.fragment),ht=n(),D=i("p"),D.textContent=xs,Mt=n(),f(E.$$.fragment),bt=n(),Q=i("p"),Q.textContent=ks,jt=n(),f(F.$$.fragment),yt=n(),A=i("p"),A.textContent=Gs,wt=n(),f(K.$$.fragment),$t=n(),O=i("p"),O.innerHTML=Ws,Ut=n(),f(ee.$$.fragment),Tt=n(),te=i("p"),te.textContent=qs,_t=n(),se=i("p"),se.innerHTML=Hs,vt=n(),f(le.$$.fragment),Ct=n(),ne=i("p"),ne.innerHTML=Ls,Jt=n(),ae=i("p"),ae.innerHTML=Is,Zt=n(),f(ie.$$.fragment),xt=n(),pe=i("p"),pe.innerHTML=Bs,kt=n(),f(me.$$.fragment),Gt=n(),fe=i("p"),fe.textContent=Ss,Wt=n(),oe=i("p"),oe.textContent=Vs,qt=n(),ue=i("ul"),ue.innerHTML=zs,Ht=n(),ce=i("p"),ce.innerHTML=Ns,Lt=n(),f(re.$$.fragment),It=n(),de=i("p"),de.innerHTML=Xs,Bt=n(),f(ge.$$.fragment),St=n(),he=i("p"),he.textContent=Ps,Vt=n(),f(Me.$$.fragment),zt=n(),be=i("p"),be.innerHTML=Rs,Nt=n(),j=i("blockquote"),j.innerHTML=Ys,Xt=n(),je=i("p"),je.innerHTML=Ds,Pt=n(),f(ye.$$.fragment),Rt=n(),y=i("blockquote"),y.innerHTML=Es,Yt=n(),we=i("p"),we.textContent=Qs,Dt=n(),$e=i("ul"),$e.innerHTML=Fs,Et=n(),Ue=i("p"),Ue.innerHTML=As,Qt=n(),f(Te.$$.fragment),Ft=n(),_e=i("p"),_e.innerHTML=Ks,At=n(),ve=i("p"),ve.textContent=Os,Kt=n(),Ce=i("p"),Ce.innerHTML=el,Ot=n(),f(Je.$$.fragment),es=n(),Ze=i("p"),Ze.textContent=tl,ts=n(),f(xe.$$.fragment),ss=n(),ke=i("p"),ke.textContent=sl,ls=n(),f(Ge.$$.fragment),ns=n(),We=i("p"),We.textContent=ll,as=n(),w=i("div"),w.innerHTML=nl,is=n(),f(qe.$$.fragment),ps=n(),He=i("p"),He.textContent=al,ms=n(),Le=i("ul"),Le.innerHTML=il,fs=n(),f(Ie.$$.fragment),os=n(),ze=i("p"),this.h()},l(e){const t=rl("svelte-u9bgzb",document.head);h=p(t,"META",{name:!0,content:!0}),t.forEach(s),Ne=a(e),Ve=p(e,"P",{}),pl(Ve).forEach(s),Xe=a(e),o($.$$.fragment,e),Pe=a(e),o(U.$$.fragment,e),Re=a(e),T=p(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-8fww4q"&&(T.textContent=rs),Ye=a(e),_=p(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1jcd1kt"&&(_.textContent=ds),De=a(e),v=p(e,"UL",{"data-svelte-h":!0}),m(v)!=="svelte-q05j96"&&(v.innerHTML=gs),Ee=a(e),C=p(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-11en9bt"&&(C.innerHTML=hs),Qe=a(e),M=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(M)!=="svelte-e0e6mc"&&(M.innerHTML=Ms),Fe=a(e),J=p(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-vu4fy1"&&(J.textContent=bs),Ae=a(e),o(Z.$$.fragment,e),Ke=a(e),x=p(e,"UL",{"data-svelte-h":!0}),m(x)!=="svelte-127wkj3"&&(x.innerHTML=js),Oe=a(e),o(k.$$.fragment,e),et=a(e),G=p(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-17sg266"&&(G.innerHTML=ys),tt=a(e),W=p(e,"TABLE",{"data-svelte-h":!0}),m(W)!=="svelte-ihh3bo"&&(W.innerHTML=ws),st=a(e),q=p(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1asnlw6"&&(q.innerHTML=$s),lt=a(e),H=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),m(H)!=="svelte-1v1hy7k"&&(H.innerHTML=Us),nt=a(e),L=p(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-9217qk"&&(L.innerHTML=Ts),at=a(e),o(I.$$.fragment,e),it=a(e),B=p(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1kkhsyn"&&(B.innerHTML=_s),pt=a(e),o(S.$$.fragment,e),mt=a(e),V=p(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-vs77ec"&&(V.textContent=vs),ft=a(e),o(z.$$.fragment,e),ot=a(e),N=p(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1s6yxe6"&&(N.innerHTML=Cs),ut=a(e),o(X.$$.fragment,e),ct=a(e),b=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-6cjtp1"&&(b.innerHTML=Js),rt=a(e),P=p(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1njwl3p"&&(P.innerHTML=Zs),dt=a(e),o(R.$$.fragment,e),gt=a(e),o(Y.$$.fragment,e),ht=a(e),D=p(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-ym515z"&&(D.textContent=xs),Mt=a(e),o(E.$$.fragment,e),bt=a(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-c2ekdz"&&(Q.textContent=ks),jt=a(e),o(F.$$.fragment,e),yt=a(e),A=p(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1w7rorw"&&(A.textContent=Gs),wt=a(e),o(K.$$.fragment,e),$t=a(e),O=p(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-doj56"&&(O.innerHTML=Ws),Ut=a(e),o(ee.$$.fragment,e),Tt=a(e),te=p(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1dfll12"&&(te.textContent=qs),_t=a(e),se=p(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-qz8594"&&(se.innerHTML=Hs),vt=a(e),o(le.$$.fragment,e),Ct=a(e),ne=p(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-m81eak"&&(ne.innerHTML=Ls),Jt=a(e),ae=p(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-z93j1x"&&(ae.innerHTML=Is),Zt=a(e),o(ie.$$.fragment,e),xt=a(e),pe=p(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-zg39xw"&&(pe.innerHTML=Bs),kt=a(e),o(me.$$.fragment,e),Gt=a(e),fe=p(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-duc30n"&&(fe.textContent=Ss),Wt=a(e),oe=p(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-xh79f3"&&(oe.textContent=Vs),qt=a(e),ue=p(e,"UL",{"data-svelte-h":!0}),m(ue)!=="svelte-vjxthd"&&(ue.innerHTML=zs),Ht=a(e),ce=p(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1wu3gqi"&&(ce.innerHTML=Ns),Lt=a(e),o(re.$$.fragment,e),It=a(e),de=p(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-tfiut1"&&(de.innerHTML=Xs),Bt=a(e),o(ge.$$.fragment,e),St=a(e),he=p(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-10p45zu"&&(he.textContent=Ps),Vt=a(e),o(Me.$$.fragment,e),zt=a(e),be=p(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1ln9s03"&&(be.innerHTML=Rs),Nt=a(e),j=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(j)!=="svelte-9g21wf"&&(j.innerHTML=Ys),Xt=a(e),je=p(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-14qd3e5"&&(je.innerHTML=Ds),Pt=a(e),o(ye.$$.fragment,e),Rt=a(e),y=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(y)!=="svelte-19ufcj6"&&(y.innerHTML=Es),Yt=a(e),we=p(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-xh79f3"&&(we.textContent=Qs),Dt=a(e),$e=p(e,"UL",{"data-svelte-h":!0}),m($e)!=="svelte-1kldhq3"&&($e.innerHTML=Fs),Et=a(e),Ue=p(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-fc38zg"&&(Ue.innerHTML=As),Qt=a(e),o(Te.$$.fragment,e),Ft=a(e),_e=p(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-17613xv"&&(_e.innerHTML=Ks),At=a(e),ve=p(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-1ooe71"&&(ve.textContent=Os),Kt=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-2ptaov"&&(Ce.innerHTML=el),Ot=a(e),o(Je.$$.fragment,e),es=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-kqyg05"&&(Ze.textContent=tl),ts=a(e),o(xe.$$.fragment,e),ss=a(e),ke=p(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-znv8iz"&&(ke.textContent=sl),ls=a(e),o(Ge.$$.fragment,e),ns=a(e),We=p(e,"P",{"data-svelte-h":!0}),m(We)!=="svelte-ss97vg"&&(We.textContent=ll),as=a(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(w)!=="svelte-1yzsrw6"&&(w.innerHTML=nl),is=a(e),o(qe.$$.fragment,e),ps=a(e),He=p(e,"P",{"data-svelte-h":!0}),m(He)!=="svelte-16pa74u"&&(He.textContent=al),ms=a(e),Le=p(e,"UL",{"data-svelte-h":!0}),m(Le)!=="svelte-1awshj"&&(Le.innerHTML=il),fs=a(e),o(Ie.$$.fragment,e),os=a(e),ze=p(e,"P",{}),pl(ze).forEach(s),this.h()},h(){Be(h,"name","hf:doc:metadata"),Be(h,"content",bl),Be(M,"class","tip"),Be(b,"class","flex justify-center"),Be(j,"class","tip"),Be(y,"class","tip"),Be(w,"class","flex justify-center")},m(e,t){dl(document.head,h),l(e,Ne,t),l(e,Ve,t),l(e,Xe,t),u($,e,t),l(e,Pe,t),u(U,e,t),l(e,Re,t),l(e,T,t),l(e,Ye,t),l(e,_,t),l(e,De,t),l(e,v,t),l(e,Ee,t),l(e,C,t),l(e,Qe,t),l(e,M,t),l(e,Fe,t),l(e,J,t),l(e,Ae,t),u(Z,e,t),l(e,Ke,t),l(e,x,t),l(e,Oe,t),u(k,e,t),l(e,et,t),l(e,G,t),l(e,tt,t),l(e,W,t),l(e,st,t),l(e,q,t),l(e,lt,t),l(e,H,t),l(e,nt,t),l(e,L,t),l(e,at,t),u(I,e,t),l(e,it,t),l(e,B,t),l(e,pt,t),u(S,e,t),l(e,mt,t),l(e,V,t),l(e,ft,t),u(z,e,t),l(e,ot,t),l(e,N,t),l(e,ut,t),u(X,e,t),l(e,ct,t),l(e,b,t),l(e,rt,t),l(e,P,t),l(e,dt,t),u(R,e,t),l(e,gt,t),u(Y,e,t),l(e,ht,t),l(e,D,t),l(e,Mt,t),u(E,e,t),l(e,bt,t),l(e,Q,t),l(e,jt,t),u(F,e,t),l(e,yt,t),l(e,A,t),l(e,wt,t),u(K,e,t),l(e,$t,t),l(e,O,t),l(e,Ut,t),u(ee,e,t),l(e,Tt,t),l(e,te,t),l(e,_t,t),l(e,se,t),l(e,vt,t),u(le,e,t),l(e,Ct,t),l(e,ne,t),l(e,Jt,t),l(e,ae,t),l(e,Zt,t),u(ie,e,t),l(e,xt,t),l(e,pe,t),l(e,kt,t),u(me,e,t),l(e,Gt,t),l(e,fe,t),l(e,Wt,t),l(e,oe,t),l(e,qt,t),l(e,ue,t),l(e,Ht,t),l(e,ce,t),l(e,Lt,t),u(re,e,t),l(e,It,t),l(e,de,t),l(e,Bt,t),u(ge,e,t),l(e,St,t),l(e,he,t),l(e,Vt,t),u(Me,e,t),l(e,zt,t),l(e,be,t),l(e,Nt,t),l(e,j,t),l(e,Xt,t),l(e,je,t),l(e,Pt,t),u(ye,e,t),l(e,Rt,t),l(e,y,t),l(e,Yt,t),l(e,we,t),l(e,Dt,t),l(e,$e,t),l(e,Et,t),l(e,Ue,t),l(e,Qt,t),u(Te,e,t),l(e,Ft,t),l(e,_e,t),l(e,At,t),l(e,ve,t),l(e,Kt,t),l(e,Ce,t),l(e,Ot,t),u(Je,e,t),l(e,es,t),l(e,Ze,t),l(e,ts,t),u(xe,e,t),l(e,ss,t),l(e,ke,t),l(e,ls,t),u(Ge,e,t),l(e,ns,t),l(e,We,t),l(e,as,t),l(e,w,t),l(e,is,t),u(qe,e,t),l(e,ps,t),l(e,He,t),l(e,ms,t),l(e,Le,t),l(e,fs,t),u(Ie,e,t),l(e,os,t),l(e,ze,t),us=!0},p:fl,i(e){us||(c($.$$.fragment,e),c(U.$$.fragment,e),c(Z.$$.fragment,e),c(k.$$.fragment,e),c(I.$$.fragment,e),c(S.$$.fragment,e),c(z.$$.fragment,e),c(X.$$.fragment,e),c(R.$$.fragment,e),c(Y.$$.fragment,e),c(E.$$.fragment,e),c(F.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(me.$$.fragment,e),c(re.$$.fragment,e),c(ge.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(Te.$$.fragment,e),c(Je.$$.fragment,e),c(xe.$$.fragment,e),c(Ge.$$.fragment,e),c(qe.$$.fragment,e),c(Ie.$$.fragment,e),us=!0)},o(e){r($.$$.fragment,e),r(U.$$.fragment,e),r(Z.$$.fragment,e),r(k.$$.fragment,e),r(I.$$.fragment,e),r(S.$$.fragment,e),r(z.$$.fragment,e),r(X.$$.fragment,e),r(R.$$.fragment,e),r(Y.$$.fragment,e),r(E.$$.fragment,e),r(F.$$.fragment,e),r(K.$$.fragment,e),r(ee.$$.fragment,e),r(le.$$.fragment,e),r(ie.$$.fragment,e),r(me.$$.fragment,e),r(re.$$.fragment,e),r(ge.$$.fragment,e),r(Me.$$.fragment,e),r(ye.$$.fragment,e),r(Te.$$.fragment,e),r(Je.$$.fragment,e),r(xe.$$.fragment,e),r(Ge.$$.fragment,e),r(qe.$$.fragment,e),r(Ie.$$.fragment,e),us=!1},d(e){e&&(s(Ne),s(Ve),s(Xe),s(Pe),s(Re),s(T),s(Ye),s(_),s(De),s(v),s(Ee),s(C),s(Qe),s(M),s(Fe),s(J),s(Ae),s(Ke),s(x),s(Oe),s(et),s(G),s(tt),s(W),s(st),s(q),s(lt),s(H),s(nt),s(L),s(at),s(it),s(B),s(pt),s(mt),s(V),s(ft),s(ot),s(N),s(ut),s(ct),s(b),s(rt),s(P),s(dt),s(gt),s(ht),s(D),s(Mt),s(bt),s(Q),s(jt),s(yt),s(A),s(wt),s($t),s(O),s(Ut),s(Tt),s(te),s(_t),s(se),s(vt),s(Ct),s(ne),s(Jt),s(ae),s(Zt),s(xt),s(pe),s(kt),s(Gt),s(fe),s(Wt),s(oe),s(qt),s(ue),s(Ht),s(ce),s(Lt),s(It),s(de),s(Bt),s(St),s(he),s(Vt),s(zt),s(be),s(Nt),s(j),s(Xt),s(je),s(Pt),s(Rt),s(y),s(Yt),s(we),s(Dt),s($e),s(Et),s(Ue),s(Qt),s(Ft),s(_e),s(At),s(ve),s(Kt),s(Ce),s(Ot),s(es),s(Ze),s(ts),s(ss),s(ke),s(ls),s(ns),s(We),s(as),s(w),s(is),s(ps),s(He),s(ms),s(Le),s(fs),s(os),s(ze)),s(h),d($,e),d(U,e),d(Z,e),d(k,e),d(I,e),d(S,e),d(z,e),d(X,e),d(R,e),d(Y,e),d(E,e),d(F,e),d(K,e),d(ee,e),d(le,e),d(ie,e),d(me,e),d(re,e),d(ge,e),d(Me,e),d(ye,e),d(Te,e),d(Je,e),d(xe,e),d(Ge,e),d(qe,e),d(Ie,e)}}}const bl='{"title":"簡単な案内","local":"簡単な案内","sections":[{"title":"拡散パイプライン","local":"拡散パイプライン","sections":[{"title":"ローカルパイプライン","local":"ローカルパイプライン","sections":[],"depth":3},{"title":"スケジューラの交換","local":"スケジューラの交換","sections":[],"depth":3}],"depth":2},{"title":"モデル","local":"モデル","sections":[],"depth":2},{"title":"スケジューラ","local":"スケジューラ","sections":[],"depth":2},{"title":"次のステップ","local":"次のステップ","sections":[],"depth":2}],"depth":1}';function jl(cs){return ol(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _l extends ul{constructor(h){super(),cl(this,h,jl,Ml,ml,{})}}export{_l as component};
