# KarrasVeScheduler

`KarrasVeScheduler` is a stochastic sampler tailored to variance-expanding (VE) models. It is based on the [Elucidating the Design Space of Diffusion-Based Generative Models](https://huggingface.co/papers/2206.00364) and [Score-based generative modeling through stochastic differential equations](https://huggingface.co/papers/2011.13456) papers.

## KarrasVeScheduler[[diffusers.KarrasVeScheduler]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.KarrasVeScheduler</name><anchor>diffusers.KarrasVeScheduler</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/deprecated/scheduling_karras_ve.py#L49</source><parameters>[{"name": "sigma_min", "val": ": float = 0.02"}, {"name": "sigma_max", "val": ": float = 100"}, {"name": "s_noise", "val": ": float = 1.007"}, {"name": "s_churn", "val": ": float = 80"}, {"name": "s_min", "val": ": float = 0.05"}, {"name": "s_max", "val": ": float = 50"}]</parameters><paramsdesc>- **sigma_min** (`float`, defaults to 0.02) --
  The minimum noise magnitude.
- **sigma_max** (`float`, defaults to 100) --
  The maximum noise magnitude.
- **s_noise** (`float`, defaults to 1.007) --
  The amount of additional noise to counteract loss of detail during sampling. A reasonable range is [1.000,
  1.011].
- **s_churn** (`float`, defaults to 80) --
  The parameter controlling the overall amount of stochasticity. A reasonable range is [0, 100].
- **s_min** (`float`, defaults to 0.05) --
  The start value of the sigma range to add noise (enable stochasticity). A reasonable range is [0, 10].
- **s_max** (`float`, defaults to 50) --
  The end value of the sigma range to add noise. A reasonable range is [0.2, 80].</paramsdesc><paramgroups>0</paramgroups></docstring>

A stochastic scheduler tailored to variance-expanding models.

This model inherits from [SchedulerMixin](/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin) and [ConfigMixin](/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin). Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.

> [!TIP] > For more details on the parameters, see [Appendix E](https://huggingface.co/papers/2206.00364). The grid
search > values used to find the optimal `{s_noise, s_churn, s_min, s_max}` for a specific model are described in
Table 5 of > the paper.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>add_noise_to_input</name><anchor>diffusers.KarrasVeScheduler.add_noise_to_input</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/deprecated/scheduling_karras_ve.py#L135</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "sigma", "val": ": float"}, {"name": "generator", "val": ": typing.Optional[torch._C.Generator] = None"}]</parameters><paramsdesc>- **sample** (`torch.Tensor`) --
  The input sample.
- **sigma** (`float`) --
- **generator** (`torch.Generator`, *optional*) --
  A random number generator.</paramsdesc><paramgroups>0</paramgroups></docstring>

Explicit Langevin-like "churn" step of adding noise to the sample according to a `gamma_i ≥ 0` to reach a
higher noise level `sigma_hat = sigma_i + gamma_i*sigma_i`.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>scale_model_input</name><anchor>diffusers.KarrasVeScheduler.scale_model_input</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/deprecated/scheduling_karras_ve.py#L96</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Optional[int] = None"}]</parameters><paramsdesc>- **sample** (`torch.Tensor`) --
  The input sample.
- **timestep** (`int`, *optional*) --
  The current timestep in the diffusion chain.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>A scaled input sample.</retdesc></docstring>

Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_timesteps</name><anchor>diffusers.KarrasVeScheduler.set_timesteps</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/deprecated/scheduling_karras_ve.py#L113</source><parameters>[{"name": "num_inference_steps", "val": ": int"}, {"name": "device", "val": ": typing.Union[str, torch.device] = None"}]</parameters><paramsdesc>- **num_inference_steps** (`int`) --
  The number of diffusion steps used when generating samples with a pre-trained model.
- **device** (`str` or `torch.device`, *optional*) --
  The device to which the timesteps should be moved to. If `None`, the timesteps are not moved.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the discrete timesteps used for the diffusion chain (to be run before inference).




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>step</name><anchor>diffusers.KarrasVeScheduler.step</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/deprecated/scheduling_karras_ve.py#L161</source><parameters>[{"name": "model_output", "val": ": Tensor"}, {"name": "sigma_hat", "val": ": float"}, {"name": "sigma_prev", "val": ": float"}, {"name": "sample_hat", "val": ": Tensor"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **model_output** (`torch.Tensor`) --
  The direct output from learned diffusion model.
- **sigma_hat** (`float`) --
- **sigma_prev** (`float`) --
- **sample_hat** (`torch.Tensor`) --
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a `~schedulers.scheduling_karras_ve.KarrasVESchedulerOutput` or `tuple`.</paramsdesc><paramgroups>0</paramgroups><rettype>`~schedulers.scheduling_karras_ve.KarrasVESchedulerOutput` or `tuple`</rettype><retdesc>If return_dict is `True`, `~schedulers.scheduling_karras_ve.KarrasVESchedulerOutput` is returned,
otherwise a tuple is returned where the first element is the sample tensor.</retdesc></docstring>

Predict the sample from the previous timestep by reversing the SDE. This function propagates the diffusion
process from the learned model outputs (most often the predicted noise).








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>step_correct</name><anchor>diffusers.KarrasVeScheduler.step_correct</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/deprecated/scheduling_karras_ve.py#L200</source><parameters>[{"name": "model_output", "val": ": Tensor"}, {"name": "sigma_hat", "val": ": float"}, {"name": "sigma_prev", "val": ": float"}, {"name": "sample_hat", "val": ": Tensor"}, {"name": "sample_prev", "val": ": Tensor"}, {"name": "derivative", "val": ": Tensor"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **model_output** (`torch.Tensor`) --
  The direct output from learned diffusion model.
- **sigma_hat** (`float`) -- TODO
- **sigma_prev** (`float`) -- TODO
- **sample_hat** (`torch.Tensor`) -- TODO
- **sample_prev** (`torch.Tensor`) -- TODO
- **derivative** (`torch.Tensor`) -- TODO
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a [DDPMSchedulerOutput](/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.schedulers.scheduling_ddpm.DDPMSchedulerOutput) or `tuple`.</paramsdesc><paramgroups>0</paramgroups><rettype>prev_sample (TODO)</rettype><retdesc>updated sample in the diffusion chain. derivative (TODO): TODO</retdesc></docstring>

Corrects the predicted sample based on the `model_output` of the network.








</div></div>

## KarrasVeOutput[[diffusers.schedulers.deprecated.scheduling_karras_ve.KarrasVeOutput]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.schedulers.deprecated.scheduling_karras_ve.KarrasVeOutput</name><anchor>diffusers.schedulers.deprecated.scheduling_karras_ve.KarrasVeOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/deprecated/scheduling_karras_ve.py#L29</source><parameters>[{"name": "prev_sample", "val": ": Tensor"}, {"name": "derivative", "val": ": Tensor"}, {"name": "pred_original_sample", "val": ": typing.Optional[torch.Tensor] = None"}]</parameters><paramsdesc>- **prev_sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` for images) --
  Computed sample (x_{t-1}) of previous timestep. `prev_sample` should be used as next model input in the
  denoising loop.
- **derivative** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` for images) --
  Derivative of predicted original image sample (x_0).
- **pred_original_sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` for images) --
  The predicted denoised sample (x_{0}) based on the model output from the current timestep.
  `pred_original_sample` can be used to preview progress or for guidance.</paramsdesc><paramgroups>0</paramgroups></docstring>

Output class for the scheduler's step function output.




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/schedulers/stochastic_karras_ve.md" />