# Latent Consistency Model Multistep Scheduler

## Overview

Multistep and onestep scheduler (Algorithm 3) introduced alongside latent consistency models in the paper [Latent Consistency Models: Synthesizing High-Resolution Images with Few-Step Inference](https://huggingface.co/papers/2310.04378) by Simian Luo, Yiqin Tan, Longbo Huang, Jian Li, and Hang Zhao.
This scheduler should be able to generate good samples from [LatentConsistencyModelPipeline](/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline) in 1-8 steps.

## LCMScheduler[[diffusers.LCMScheduler]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.LCMScheduler</name><anchor>diffusers.LCMScheduler</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_lcm.py#L134</source><parameters>[{"name": "num_train_timesteps", "val": ": int = 1000"}, {"name": "beta_start", "val": ": float = 0.00085"}, {"name": "beta_end", "val": ": float = 0.012"}, {"name": "beta_schedule", "val": ": str = 'scaled_linear'"}, {"name": "trained_betas", "val": ": typing.Union[numpy.ndarray, typing.List[float], NoneType] = None"}, {"name": "original_inference_steps", "val": ": int = 50"}, {"name": "clip_sample", "val": ": bool = False"}, {"name": "clip_sample_range", "val": ": float = 1.0"}, {"name": "set_alpha_to_one", "val": ": bool = True"}, {"name": "steps_offset", "val": ": int = 0"}, {"name": "prediction_type", "val": ": str = 'epsilon'"}, {"name": "thresholding", "val": ": bool = False"}, {"name": "dynamic_thresholding_ratio", "val": ": float = 0.995"}, {"name": "sample_max_value", "val": ": float = 1.0"}, {"name": "timestep_spacing", "val": ": str = 'leading'"}, {"name": "timestep_scaling", "val": ": float = 10.0"}, {"name": "rescale_betas_zero_snr", "val": ": bool = False"}]</parameters><paramsdesc>- **num_train_timesteps** (`int`, defaults to 1000) --
  The number of diffusion steps to train the model.
- **beta_start** (`float`, defaults to 0.0001) --
  The starting `beta` value of inference.
- **beta_end** (`float`, defaults to 0.02) --
  The final `beta` value.
- **beta_schedule** (`str`, defaults to `"linear"`) --
  The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model. Choose from
  `linear`, `scaled_linear`, or `squaredcos_cap_v2`.
- **trained_betas** (`np.ndarray`, *optional*) --
  Pass an array of betas directly to the constructor to bypass `beta_start` and `beta_end`.
- **original_inference_steps** (`int`, *optional*, defaults to 50) --
  The default number of inference steps used to generate a linearly-spaced timestep schedule, from which we
  will ultimately take `num_inference_steps` evenly spaced timesteps to form the final timestep schedule.
- **clip_sample** (`bool`, defaults to `True`) --
  Clip the predicted sample for numerical stability.
- **clip_sample_range** (`float`, defaults to 1.0) --
  The maximum magnitude for sample clipping. Valid only when `clip_sample=True`.
- **set_alpha_to_one** (`bool`, defaults to `True`) --
  Each diffusion step uses the alphas product value at that step and at the previous one. For the final step
  there is no previous alpha. When this option is `True` the previous alpha product is fixed to `1`,
  otherwise it uses the alpha value at step 0.
- **steps_offset** (`int`, defaults to 0) --
  An offset added to the inference steps, as required by some model families.
- **prediction_type** (`str`, defaults to `epsilon`, *optional*) --
  Prediction type of the scheduler function; can be `epsilon` (predicts the noise of the diffusion process),
  `sample` (directly predicts the noisy sample`) or `v_prediction` (see section 2.4 of [Imagen
  Video](https://imagen.research.google/video/paper.pdf) paper).
- **thresholding** (`bool`, defaults to `False`) --
  Whether to use the "dynamic thresholding" method. This is unsuitable for latent-space diffusion models such
  as Stable Diffusion.
- **dynamic_thresholding_ratio** (`float`, defaults to 0.995) --
  The ratio for the dynamic thresholding method. Valid only when `thresholding=True`.
- **sample_max_value** (`float`, defaults to 1.0) --
  The threshold value for dynamic thresholding. Valid only when `thresholding=True`.
- **timestep_spacing** (`str`, defaults to `"leading"`) --
  The way the timesteps should be scaled. Refer to Table 2 of the [Common Diffusion Noise Schedules and
  Sample Steps are Flawed](https://huggingface.co/papers/2305.08891) for more information.
- **timestep_scaling** (`float`, defaults to 10.0) --
  The factor the timesteps will be multiplied by when calculating the consistency model boundary conditions
  `c_skip` and `c_out`. Increasing this will decrease the approximation error (although the approximation
  error at the default of `10.0` is already pretty small).
- **rescale_betas_zero_snr** (`bool`, defaults to `False`) --
  Whether to rescale the betas to have zero terminal SNR. This enables the model to generate very bright and
  dark samples instead of limiting it to samples with medium brightness. Loosely related to
  [`--offset_noise`](https://github.com/huggingface/diffusers/blob/74fd735eb073eb1d774b1ab4154a0876eb82f055/examples/dreambooth/train_dreambooth.py#L506).</paramsdesc><paramgroups>0</paramgroups></docstring>

`LCMScheduler` extends the denoising procedure introduced in denoising diffusion probabilistic models (DDPMs) with
non-Markovian guidance.

This model inherits from [SchedulerMixin](/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin) and [ConfigMixin](/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin). [~ConfigMixin](/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin) takes care of storing all config
attributes that are passed in the scheduler's `__init__` function, such as `num_train_timesteps`. They can be
accessed via `scheduler.config.num_train_timesteps`. [SchedulerMixin](/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin) provides general loading and saving
functionality via the [SchedulerMixin.save_pretrained()](/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.save_pretrained) and [from_pretrained()](/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained) functions.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>scale_model_input</name><anchor>diffusers.LCMScheduler.scale_model_input</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_lcm.py#L299</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Optional[int] = None"}]</parameters><paramsdesc>- **sample** (`torch.Tensor`) --
  The input sample.
- **timestep** (`int`, *optional*) --
  The current timestep in the diffusion chain.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>A scaled input sample.</retdesc></docstring>

Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_begin_index</name><anchor>diffusers.LCMScheduler.set_begin_index</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_lcm.py#L289</source><parameters>[{"name": "begin_index", "val": ": int = 0"}]</parameters><paramsdesc>- **begin_index** (`int`) --
  The begin index for the scheduler.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the begin index for the scheduler. This function should be run from pipeline before the inference.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_timesteps</name><anchor>diffusers.LCMScheduler.set_timesteps</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_lcm.py#L349</source><parameters>[{"name": "num_inference_steps", "val": ": typing.Optional[int] = None"}, {"name": "device", "val": ": typing.Union[str, torch.device] = None"}, {"name": "original_inference_steps", "val": ": typing.Optional[int] = None"}, {"name": "timesteps", "val": ": typing.Optional[typing.List[int]] = None"}, {"name": "strength", "val": ": int = 1.0"}]</parameters><paramsdesc>- **num_inference_steps** (`int`, *optional*) --
  The number of diffusion steps used when generating samples with a pre-trained model. If used,
  `timesteps` must be `None`.
- **device** (`str` or `torch.device`, *optional*) --
  The device to which the timesteps should be moved to. If `None`, the timesteps are not moved.
- **original_inference_steps** (`int`, *optional*) --
  The original number of inference steps, which will be used to generate a linearly-spaced timestep
  schedule (which is different from the standard `diffusers` implementation). We will then take
  `num_inference_steps` timesteps from this schedule, evenly spaced in terms of indices, and use that as
  our final timestep schedule. If not set, this will default to the `original_inference_steps` attribute.
- **timesteps** (`List[int]`, *optional*) --
  Custom timesteps used to support arbitrary spacing between timesteps. If `None`, then the default
  timestep spacing strategy of equal spacing between timesteps on the training/distillation timestep
  schedule is used. If `timesteps` is passed, `num_inference_steps` must be `None`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the discrete timesteps used for the diffusion chain (to be run before inference).




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>step</name><anchor>diffusers.LCMScheduler.step</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_lcm.py#L497</source><parameters>[{"name": "model_output", "val": ": Tensor"}, {"name": "timestep", "val": ": int"}, {"name": "sample", "val": ": Tensor"}, {"name": "generator", "val": ": typing.Optional[torch._C.Generator] = None"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **model_output** (`torch.Tensor`) --
  The direct output from learned diffusion model.
- **timestep** (`float`) --
  The current discrete timestep in the diffusion chain.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.
- **generator** (`torch.Generator`, *optional*) --
  A random number generator.
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a `LCMSchedulerOutput` or `tuple`.</paramsdesc><paramgroups>0</paramgroups><rettype>`~schedulers.scheduling_utils.LCMSchedulerOutput` or `tuple`</rettype><retdesc>If return_dict is `True`, `LCMSchedulerOutput` is returned, otherwise a
tuple is returned where the first element is the sample tensor.</retdesc></docstring>

Predict the sample from the previous timestep by reversing the SDE. This function propagates the diffusion
process from the learned model outputs (most often the predicted noise).








</div></div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/schedulers/lcm.md" />