# SkyReelsV2Transformer3DModel

A Diffusion Transformer model for 3D video-like data was introduced in [SkyReels-V2](https://github.com/SkyworkAI/SkyReels-V2) by the Skywork AI.

The model can be loaded with the following code snippet.

```python
from diffusers import SkyReelsV2Transformer3DModel

transformer = SkyReelsV2Transformer3DModel.from_pretrained("Skywork/SkyReels-V2-DF-1.3B-540P-Diffusers", subfolder="transformer", torch_dtype=torch.bfloat16)
```

## SkyReelsV2Transformer3DModel[[diffusers.SkyReelsV2Transformer3DModel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.SkyReelsV2Transformer3DModel</name><anchor>diffusers.SkyReelsV2Transformer3DModel</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/transformer_skyreels_v2.py#L518</source><parameters>[{"name": "patch_size", "val": ": typing.Tuple[int] = (1, 2, 2)"}, {"name": "num_attention_heads", "val": ": int = 16"}, {"name": "attention_head_dim", "val": ": int = 128"}, {"name": "in_channels", "val": ": int = 16"}, {"name": "out_channels", "val": ": int = 16"}, {"name": "text_dim", "val": ": int = 4096"}, {"name": "freq_dim", "val": ": int = 256"}, {"name": "ffn_dim", "val": ": int = 8192"}, {"name": "num_layers", "val": ": int = 32"}, {"name": "cross_attn_norm", "val": ": bool = True"}, {"name": "qk_norm", "val": ": typing.Optional[str] = 'rms_norm_across_heads'"}, {"name": "eps", "val": ": float = 1e-06"}, {"name": "image_dim", "val": ": typing.Optional[int] = None"}, {"name": "added_kv_proj_dim", "val": ": typing.Optional[int] = None"}, {"name": "rope_max_seq_len", "val": ": int = 1024"}, {"name": "pos_embed_seq_len", "val": ": typing.Optional[int] = None"}, {"name": "inject_sample_info", "val": ": bool = False"}, {"name": "num_frame_per_block", "val": ": int = 1"}]</parameters><paramsdesc>- **patch_size** (`Tuple[int]`, defaults to `(1, 2, 2)`) --
  3D patch dimensions for video embedding (t_patch, h_patch, w_patch).
- **num_attention_heads** (`int`, defaults to `16`) --
  Fixed length for text embeddings.
- **attention_head_dim** (`int`, defaults to `128`) --
  The number of channels in each head.
- **in_channels** (`int`, defaults to `16`) --
  The number of channels in the input.
- **out_channels** (`int`, defaults to `16`) --
  The number of channels in the output.
- **text_dim** (`int`, defaults to `4096`) --
  Input dimension for text embeddings.
- **freq_dim** (`int`, defaults to `256`) --
  Dimension for sinusoidal time embeddings.
- **ffn_dim** (`int`, defaults to `8192`) --
  Intermediate dimension in feed-forward network.
- **num_layers** (`int`, defaults to `32`) --
  The number of layers of transformer blocks to use.
- **window_size** (`Tuple[int]`, defaults to `(-1, -1)`) --
  Window size for local attention (-1 indicates global attention).
- **cross_attn_norm** (`bool`, defaults to `True`) --
  Enable cross-attention normalization.
- **qk_norm** (`str`, *optional*, defaults to `"rms_norm_across_heads"`) --
  Enable query/key normalization.
- **eps** (`float`, defaults to `1e-6`) --
  Epsilon value for normalization layers.
- **inject_sample_info** (`bool`, defaults to `False`) --
  Whether to inject sample information into the model.
- **image_dim** (`int`, *optional*) --
  The dimension of the image embeddings.
- **added_kv_proj_dim** (`int`, *optional*) --
  The dimension of the added key/value projection.
- **rope_max_seq_len** (`int`, defaults to `1024`) --
  The maximum sequence length for the rotary embeddings.
- **pos_embed_seq_len** (`int`, *optional*) --
  The sequence length for the positional embeddings.</paramsdesc><paramgroups>0</paramgroups></docstring>

A Transformer model for video-like data used in the Wan-based SkyReels-V2 model.




</div>

## Transformer2DModelOutput[[diffusers.models.modeling_outputs.Transformer2DModelOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.modeling_outputs.Transformer2DModelOutput</name><anchor>diffusers.models.modeling_outputs.Transformer2DModelOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_outputs.py#L21</source><parameters>[{"name": "sample", "val": ": torch.Tensor"}]</parameters><paramsdesc>- **sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` or `(batch size, num_vector_embeds - 1, num_latent_pixels)` if [Transformer2DModel](/docs/diffusers/main/en/api/models/transformer2d#diffusers.Transformer2DModel) is discrete) --
  The hidden states output conditioned on the `encoder_hidden_states` input. If discrete, returns probability
  distributions for the unnoised latent pixels.</paramsdesc><paramgroups>0</paramgroups></docstring>

The output of [Transformer2DModel](/docs/diffusers/main/en/api/models/transformer2d#diffusers.Transformer2DModel).




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/skyreels_v2_transformer_3d.md" />