# ControlNetModel

The ControlNet model was introduced in [Adding Conditional Control to Text-to-Image Diffusion Models](https://huggingface.co/papers/2302.05543) by Lvmin Zhang, Anyi Rao, Maneesh Agrawala. It provides a greater degree of control over text-to-image generation by conditioning the model on additional inputs such as edge maps, depth maps, segmentation maps, and keypoints for pose detection.

The abstract from the paper is:

*We present ControlNet, a neural network architecture to add spatial conditioning controls to large, pretrained text-to-image diffusion models. ControlNet locks the production-ready large diffusion models, and reuses their deep and robust encoding layers pretrained with billions of images as a strong backbone to learn a diverse set of conditional controls. The neural architecture is connected with "zero convolutions" (zero-initialized convolution layers) that progressively grow the parameters from zero and ensure that no harmful noise could affect the finetuning. We test various conditioning controls, eg, edges, depth, segmentation, human pose, etc, with Stable Diffusion, using single or multiple conditions, with or without prompts. We show that the training of ControlNets is robust with small (<50k) and large (>1m) datasets. Extensive results show that ControlNet may facilitate wider applications to control image diffusion models.*

## Loading from the original format

By default the [ControlNetModel](/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel) should be loaded with [from_pretrained()](/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained), but it can also be loaded
from the original format using `FromOriginalModelMixin.from_single_file` as follows:

```py
from diffusers import StableDiffusionControlNetPipeline, ControlNetModel

url = "https://huggingface.co/lllyasviel/ControlNet-v1-1/blob/main/control_v11p_sd15_canny.pth"  # can also be a local path
controlnet = ControlNetModel.from_single_file(url)

url = "https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/blob/main/v1-5-pruned.safetensors"  # can also be a local path
pipe = StableDiffusionControlNetPipeline.from_single_file(url, controlnet=controlnet)
```

## ControlNetModel[[diffusers.ControlNetModel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.ControlNetModel</name><anchor>diffusers.ControlNetModel</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnets/controlnet.py#L109</source><parameters>[{"name": "in_channels", "val": ": int = 4"}, {"name": "conditioning_channels", "val": ": int = 3"}, {"name": "flip_sin_to_cos", "val": ": bool = True"}, {"name": "freq_shift", "val": ": int = 0"}, {"name": "down_block_types", "val": ": typing.Tuple[str, ...] = ('CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'DownBlock2D')"}, {"name": "mid_block_type", "val": ": typing.Optional[str] = 'UNetMidBlock2DCrossAttn'"}, {"name": "only_cross_attention", "val": ": typing.Union[bool, typing.Tuple[bool]] = False"}, {"name": "block_out_channels", "val": ": typing.Tuple[int, ...] = (320, 640, 1280, 1280)"}, {"name": "layers_per_block", "val": ": int = 2"}, {"name": "downsample_padding", "val": ": int = 1"}, {"name": "mid_block_scale_factor", "val": ": float = 1"}, {"name": "act_fn", "val": ": str = 'silu'"}, {"name": "norm_num_groups", "val": ": typing.Optional[int] = 32"}, {"name": "norm_eps", "val": ": float = 1e-05"}, {"name": "cross_attention_dim", "val": ": int = 1280"}, {"name": "transformer_layers_per_block", "val": ": typing.Union[int, typing.Tuple[int, ...]] = 1"}, {"name": "encoder_hid_dim", "val": ": typing.Optional[int] = None"}, {"name": "encoder_hid_dim_type", "val": ": typing.Optional[str] = None"}, {"name": "attention_head_dim", "val": ": typing.Union[int, typing.Tuple[int, ...]] = 8"}, {"name": "num_attention_heads", "val": ": typing.Union[int, typing.Tuple[int, ...], NoneType] = None"}, {"name": "use_linear_projection", "val": ": bool = False"}, {"name": "class_embed_type", "val": ": typing.Optional[str] = None"}, {"name": "addition_embed_type", "val": ": typing.Optional[str] = None"}, {"name": "addition_time_embed_dim", "val": ": typing.Optional[int] = None"}, {"name": "num_class_embeds", "val": ": typing.Optional[int] = None"}, {"name": "upcast_attention", "val": ": bool = False"}, {"name": "resnet_time_scale_shift", "val": ": str = 'default'"}, {"name": "projection_class_embeddings_input_dim", "val": ": typing.Optional[int] = None"}, {"name": "controlnet_conditioning_channel_order", "val": ": str = 'rgb'"}, {"name": "conditioning_embedding_out_channels", "val": ": typing.Optional[typing.Tuple[int, ...]] = (16, 32, 96, 256)"}, {"name": "global_pool_conditions", "val": ": bool = False"}, {"name": "addition_embed_type_num_heads", "val": ": int = 64"}]</parameters><paramsdesc>- **in_channels** (`int`, defaults to 4) --
  The number of channels in the input sample.
- **flip_sin_to_cos** (`bool`, defaults to `True`) --
  Whether to flip the sin to cos in the time embedding.
- **freq_shift** (`int`, defaults to 0) --
  The frequency shift to apply to the time embedding.
- **down_block_types** (`tuple[str]`, defaults to `("CrossAttnDownBlock2D", "CrossAttnDownBlock2D", "CrossAttnDownBlock2D", "DownBlock2D")`) --
  The tuple of downsample blocks to use.
- **only_cross_attention** (`Union[bool, Tuple[bool]]`, defaults to `False`) --
- **block_out_channels** (`tuple[int]`, defaults to `(320, 640, 1280, 1280)`) --
  The tuple of output channels for each block.
- **layers_per_block** (`int`, defaults to 2) --
  The number of layers per block.
- **downsample_padding** (`int`, defaults to 1) --
  The padding to use for the downsampling convolution.
- **mid_block_scale_factor** (`float`, defaults to 1) --
  The scale factor to use for the mid block.
- **act_fn** (`str`, defaults to "silu") --
  The activation function to use.
- **norm_num_groups** (`int`, *optional*, defaults to 32) --
  The number of groups to use for the normalization. If None, normalization and activation layers is skipped
  in post-processing.
- **norm_eps** (`float`, defaults to 1e-5) --
  The epsilon to use for the normalization.
- **cross_attention_dim** (`int`, defaults to 1280) --
  The dimension of the cross attention features.
- **transformer_layers_per_block** (`int` or `Tuple[int]`, *optional*, defaults to 1) --
  The number of transformer blocks of type `BasicTransformerBlock`. Only relevant for
  `~models.unet_2d_blocks.CrossAttnDownBlock2D`, `~models.unet_2d_blocks.CrossAttnUpBlock2D`,
  `~models.unet_2d_blocks.UNetMidBlock2DCrossAttn`.
- **encoder_hid_dim** (`int`, *optional*, defaults to None) --
  If `encoder_hid_dim_type` is defined, `encoder_hidden_states` will be projected from `encoder_hid_dim`
  dimension to `cross_attention_dim`.
- **encoder_hid_dim_type** (`str`, *optional*, defaults to `None`) --
  If given, the `encoder_hidden_states` and potentially other embeddings are down-projected to text
  embeddings of dimension `cross_attention` according to `encoder_hid_dim_type`.
- **attention_head_dim** (`Union[int, Tuple[int]]`, defaults to 8) --
  The dimension of the attention heads.
- **use_linear_projection** (`bool`, defaults to `False`) --
- **class_embed_type** (`str`, *optional*, defaults to `None`) --
  The type of class embedding to use which is ultimately summed with the time embeddings. Choose from None,
  `"timestep"`, `"identity"`, `"projection"`, or `"simple_projection"`.
- **addition_embed_type** (`str`, *optional*, defaults to `None`) --
  Configures an optional embedding which will be summed with the time embeddings. Choose from `None` or
  "text". "text" will use the `TextTimeEmbedding` layer.
- **num_class_embeds** (`int`, *optional*, defaults to 0) --
  Input dimension of the learnable embedding matrix to be projected to `time_embed_dim`, when performing
  class conditioning with `class_embed_type` equal to `None`.
- **upcast_attention** (`bool`, defaults to `False`) --
- **resnet_time_scale_shift** (`str`, defaults to `"default"`) --
  Time scale shift config for ResNet blocks (see `ResnetBlock2D`). Choose from `default` or `scale_shift`.
- **projection_class_embeddings_input_dim** (`int`, *optional*, defaults to `None`) --
  The dimension of the `class_labels` input when `class_embed_type="projection"`. Required when
  `class_embed_type="projection"`.
- **controlnet_conditioning_channel_order** (`str`, defaults to `"rgb"`) --
  The channel order of conditional image. Will convert to `rgb` if it's `bgr`.
- **conditioning_embedding_out_channels** (`tuple[int]`, *optional*, defaults to `(16, 32, 96, 256)`) --
  The tuple of output channel for each block in the `conditioning_embedding` layer.
- **global_pool_conditions** (`bool`, defaults to `False`) --
  TODO(Patrick) - unused parameter.
- **addition_embed_type_num_heads** (`int`, defaults to 64) --
  The number of heads to use for the `TextTimeEmbedding` layer.</paramsdesc><paramgroups>0</paramgroups></docstring>

A ControlNet model.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>forward</name><anchor>diffusers.ControlNetModel.forward</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnets/controlnet.py#L660</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Union[torch.Tensor, float, int]"}, {"name": "encoder_hidden_states", "val": ": Tensor"}, {"name": "controlnet_cond", "val": ": Tensor"}, {"name": "conditioning_scale", "val": ": float = 1.0"}, {"name": "class_labels", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "timestep_cond", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "attention_mask", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "added_cond_kwargs", "val": ": typing.Optional[typing.Dict[str, torch.Tensor]] = None"}, {"name": "cross_attention_kwargs", "val": ": typing.Optional[typing.Dict[str, typing.Any]] = None"}, {"name": "guess_mode", "val": ": bool = False"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **sample** (`torch.Tensor`) --
  The noisy input tensor.
- **timestep** (`Union[torch.Tensor, float, int]`) --
  The number of timesteps to denoise an input.
- **encoder_hidden_states** (`torch.Tensor`) --
  The encoder hidden states.
- **controlnet_cond** (`torch.Tensor`) --
  The conditional input tensor of shape `(batch_size, sequence_length, hidden_size)`.
- **conditioning_scale** (`float`, defaults to `1.0`) --
  The scale factor for ControlNet outputs.
- **class_labels** (`torch.Tensor`, *optional*, defaults to `None`) --
  Optional class labels for conditioning. Their embeddings will be summed with the timestep embeddings.
- **timestep_cond** (`torch.Tensor`, *optional*, defaults to `None`) --
  Additional conditional embeddings for timestep. If provided, the embeddings will be summed with the
  timestep_embedding passed through the `self.time_embedding` layer to obtain the final timestep
  embeddings.
- **attention_mask** (`torch.Tensor`, *optional*, defaults to `None`) --
  An attention mask of shape `(batch, key_tokens)` is applied to `encoder_hidden_states`. If `1` the mask
  is kept, otherwise if `0` it is discarded. Mask will be converted into a bias, which adds large
  negative values to the attention scores corresponding to "discard" tokens.
- **added_cond_kwargs** (`dict`) --
  Additional conditions for the Stable Diffusion XL UNet.
- **cross_attention_kwargs** (`dict[str]`, *optional*, defaults to `None`) --
  A kwargs dictionary that if specified is passed along to the `AttnProcessor`.
- **guess_mode** (`bool`, defaults to `False`) --
  In this mode, the ControlNet encoder tries its best to recognize the input content of the input even if
  you remove all prompts. A `guidance_scale` between 3.0 and 5.0 is recommended.
- **return_dict** (`bool`, defaults to `True`) --
  Whether or not to return a [ControlNetOutput](/docs/diffusers/main/en/api/models/controlnet#diffusers.models.controlnets.ControlNetOutput) instead of a plain
  tuple.</paramsdesc><paramgroups>0</paramgroups><rettype>[ControlNetOutput](/docs/diffusers/main/en/api/models/controlnet#diffusers.models.controlnets.ControlNetOutput) **or** `tuple`</rettype><retdesc>If `return_dict` is `True`, a [ControlNetOutput](/docs/diffusers/main/en/api/models/controlnet#diffusers.models.controlnets.ControlNetOutput) is returned,
otherwise a tuple is returned where the first element is the sample tensor.</retdesc></docstring>

The [ControlNetModel](/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel) forward method.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_unet</name><anchor>diffusers.ControlNetModel.from_unet</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnets/controlnet.py#L442</source><parameters>[{"name": "unet", "val": ": UNet2DConditionModel"}, {"name": "controlnet_conditioning_channel_order", "val": ": str = 'rgb'"}, {"name": "conditioning_embedding_out_channels", "val": ": typing.Optional[typing.Tuple[int, ...]] = (16, 32, 96, 256)"}, {"name": "load_weights_from_unet", "val": ": bool = True"}, {"name": "conditioning_channels", "val": ": int = 3"}]</parameters><paramsdesc>- **unet** (`UNet2DConditionModel`) --
  The UNet model weights to copy to the [ControlNetModel](/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel). All configuration options are also copied
  where applicable.</paramsdesc><paramgroups>0</paramgroups></docstring>

Instantiate a [ControlNetModel](/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel) from [UNet2DConditionModel](/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel).




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_attention_slice</name><anchor>diffusers.ControlNetModel.set_attention_slice</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnets/controlnet.py#L595</source><parameters>[{"name": "slice_size", "val": ": typing.Union[str, int, typing.List[int]]"}]</parameters><paramsdesc>- **slice_size** (`str` or `int` or `list(int)`, *optional*, defaults to `"auto"`) --
  When `"auto"`, input to the attention heads is halved, so attention is computed in two steps. If
  `"max"`, maximum amount of memory is saved by running only one slice at a time. If a number is
  provided, uses as many slices as `attention_head_dim // slice_size`. In this case, `attention_head_dim`
  must be a multiple of `slice_size`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Enable sliced attention computation.

When this option is enabled, the attention module splits the input tensor in slices to compute attention in
several steps. This is useful for saving some memory in exchange for a small decrease in speed.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_attn_processor</name><anchor>diffusers.ControlNetModel.set_attn_processor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnets/controlnet.py#L544</source><parameters>[{"name": "processor", "val": ": typing.Union[diffusers.models.attention_processor.AttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor2_0, diffusers.models.attention_processor.JointAttnProcessor2_0, diffusers.models.attention_processor.PAGJointAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGJointAttnProcessor2_0, diffusers.models.attention_processor.FusedJointAttnProcessor2_0, diffusers.models.attention_processor.AllegroAttnProcessor2_0, diffusers.models.attention_processor.AuraFlowAttnProcessor2_0, diffusers.models.attention_processor.FusedAuraFlowAttnProcessor2_0, diffusers.models.attention_processor.FluxAttnProcessor2_0, diffusers.models.attention_processor.FluxAttnProcessor2_0_NPU, diffusers.models.attention_processor.FusedFluxAttnProcessor2_0, diffusers.models.attention_processor.FusedFluxAttnProcessor2_0_NPU, diffusers.models.attention_processor.CogVideoXAttnProcessor2_0, diffusers.models.attention_processor.FusedCogVideoXAttnProcessor2_0, diffusers.models.attention_processor.XFormersAttnAddedKVProcessor, diffusers.models.attention_processor.XFormersAttnProcessor, diffusers.models.attention_processor.XLAFlashAttnProcessor2_0, diffusers.models.attention_processor.AttnProcessorNPU, diffusers.models.attention_processor.AttnProcessor2_0, diffusers.models.attention_processor.MochiVaeAttnProcessor2_0, diffusers.models.attention_processor.MochiAttnProcessor2_0, diffusers.models.attention_processor.StableAudioAttnProcessor2_0, diffusers.models.attention_processor.HunyuanAttnProcessor2_0, diffusers.models.attention_processor.FusedHunyuanAttnProcessor2_0, diffusers.models.attention_processor.PAGHunyuanAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGHunyuanAttnProcessor2_0, diffusers.models.attention_processor.LuminaAttnProcessor2_0, diffusers.models.attention_processor.FusedAttnProcessor2_0, diffusers.models.attention_processor.CustomDiffusionXFormersAttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor2_0, diffusers.models.attention_processor.SlicedAttnProcessor, diffusers.models.attention_processor.SlicedAttnAddedKVProcessor, diffusers.models.attention_processor.SanaLinearAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGSanaLinearAttnProcessor2_0, diffusers.models.attention_processor.PAGIdentitySanaLinearAttnProcessor2_0, diffusers.models.attention_processor.SanaMultiscaleLinearAttention, diffusers.models.attention_processor.SanaMultiscaleAttnProcessor2_0, diffusers.models.attention_processor.SanaMultiscaleAttentionProjection, diffusers.models.attention_processor.IPAdapterAttnProcessor, diffusers.models.attention_processor.IPAdapterAttnProcessor2_0, diffusers.models.attention_processor.IPAdapterXFormersAttnProcessor, diffusers.models.attention_processor.SD3IPAdapterJointAttnProcessor2_0, diffusers.models.attention_processor.PAGIdentitySelfAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGIdentitySelfAttnProcessor2_0, diffusers.models.attention_processor.LoRAAttnProcessor, diffusers.models.attention_processor.LoRAAttnProcessor2_0, diffusers.models.attention_processor.LoRAXFormersAttnProcessor, diffusers.models.attention_processor.LoRAAttnAddedKVProcessor, typing.Dict[str, typing.Union[diffusers.models.attention_processor.AttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor2_0, diffusers.models.attention_processor.JointAttnProcessor2_0, diffusers.models.attention_processor.PAGJointAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGJointAttnProcessor2_0, diffusers.models.attention_processor.FusedJointAttnProcessor2_0, diffusers.models.attention_processor.AllegroAttnProcessor2_0, diffusers.models.attention_processor.AuraFlowAttnProcessor2_0, diffusers.models.attention_processor.FusedAuraFlowAttnProcessor2_0, diffusers.models.attention_processor.FluxAttnProcessor2_0, diffusers.models.attention_processor.FluxAttnProcessor2_0_NPU, diffusers.models.attention_processor.FusedFluxAttnProcessor2_0, diffusers.models.attention_processor.FusedFluxAttnProcessor2_0_NPU, diffusers.models.attention_processor.CogVideoXAttnProcessor2_0, diffusers.models.attention_processor.FusedCogVideoXAttnProcessor2_0, diffusers.models.attention_processor.XFormersAttnAddedKVProcessor, diffusers.models.attention_processor.XFormersAttnProcessor, diffusers.models.attention_processor.XLAFlashAttnProcessor2_0, diffusers.models.attention_processor.AttnProcessorNPU, diffusers.models.attention_processor.AttnProcessor2_0, diffusers.models.attention_processor.MochiVaeAttnProcessor2_0, diffusers.models.attention_processor.MochiAttnProcessor2_0, diffusers.models.attention_processor.StableAudioAttnProcessor2_0, diffusers.models.attention_processor.HunyuanAttnProcessor2_0, diffusers.models.attention_processor.FusedHunyuanAttnProcessor2_0, diffusers.models.attention_processor.PAGHunyuanAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGHunyuanAttnProcessor2_0, diffusers.models.attention_processor.LuminaAttnProcessor2_0, diffusers.models.attention_processor.FusedAttnProcessor2_0, diffusers.models.attention_processor.CustomDiffusionXFormersAttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor2_0, diffusers.models.attention_processor.SlicedAttnProcessor, diffusers.models.attention_processor.SlicedAttnAddedKVProcessor, diffusers.models.attention_processor.SanaLinearAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGSanaLinearAttnProcessor2_0, diffusers.models.attention_processor.PAGIdentitySanaLinearAttnProcessor2_0, diffusers.models.attention_processor.SanaMultiscaleLinearAttention, diffusers.models.attention_processor.SanaMultiscaleAttnProcessor2_0, diffusers.models.attention_processor.SanaMultiscaleAttentionProjection, diffusers.models.attention_processor.IPAdapterAttnProcessor, diffusers.models.attention_processor.IPAdapterAttnProcessor2_0, diffusers.models.attention_processor.IPAdapterXFormersAttnProcessor, diffusers.models.attention_processor.SD3IPAdapterJointAttnProcessor2_0, diffusers.models.attention_processor.PAGIdentitySelfAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGIdentitySelfAttnProcessor2_0, diffusers.models.attention_processor.LoRAAttnProcessor, diffusers.models.attention_processor.LoRAAttnProcessor2_0, diffusers.models.attention_processor.LoRAXFormersAttnProcessor, diffusers.models.attention_processor.LoRAAttnAddedKVProcessor]]]"}]</parameters><paramsdesc>- **processor** (`dict` of `AttentionProcessor` or only `AttentionProcessor`) --
  The instantiated processor class or a dictionary of processor classes that will be set as the processor
  for **all** `Attention` layers.

  If `processor` is a dict, the key needs to define the path to the corresponding cross attention
  processor. This is strongly recommended when setting trainable attention processors.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the attention processor to use to compute attention.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_default_attn_processor</name><anchor>diffusers.ControlNetModel.set_default_attn_processor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnets/controlnet.py#L579</source><parameters>[]</parameters></docstring>

Disables custom attention processors and sets the default attention implementation.


</div></div>

## ControlNetOutput[[diffusers.models.controlnets.ControlNetOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.controlnets.ControlNetOutput</name><anchor>diffusers.models.controlnets.ControlNetOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/controlnets/controlnet.py#L45</source><parameters>[{"name": "down_block_res_samples", "val": ": typing.Tuple[torch.Tensor]"}, {"name": "mid_block_res_sample", "val": ": Tensor"}]</parameters><paramsdesc>- **down_block_res_samples** (`tuple[torch.Tensor]`) --
  A tuple of downsample activations at different resolutions for each downsampling block. Each tensor should
  be of shape `(batch_size, channel * resolution, height //resolution, width // resolution)`. Output can be
  used to condition the original UNet's downsampling activations.
- **mid_down_block_re_sample** (`torch.Tensor`) --
  The activation of the middle block (the lowest sample resolution). Each tensor should be of shape
  `(batch_size, channel * lowest_resolution, height // lowest_resolution, width // lowest_resolution)`.
  Output can be used to condition the original UNet's middle block activation.</paramsdesc><paramgroups>0</paramgroups></docstring>

The output of [ControlNetModel](/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel).




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/controlnet.md" />