# Attention Processor

An attention processor is a class for applying different types of attention mechanisms.

## AttnProcessor[[diffusers.models.attention_processor.AttnProcessor]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.AttnProcessor</name><anchor>diffusers.models.attention_processor.AttnProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L1101</source><parameters>[]</parameters></docstring>

Default processor for performing attention-related computations.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.AttnProcessor2_0</name><anchor>diffusers.models.attention_processor.AttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L2694</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product attention (enabled by default if you're using PyTorch 2.0).


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.AttnAddedKVProcessor</name><anchor>diffusers.models.attention_processor.AttnAddedKVProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L1277</source><parameters>[]</parameters></docstring>

Processor for performing attention-related computations with extra learnable key and value matrices for the text
encoder.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.AttnAddedKVProcessor2_0</name><anchor>diffusers.models.attention_processor.AttnAddedKVProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L1344</source><parameters>[]</parameters></docstring>

Processor for performing scaled dot-product attention (enabled by default if you're using PyTorch 2.0), with extra
learnable key and value matrices for the text encoder.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.AttnProcessorNPU</name><anchor>diffusers.models.attention_processor.AttnProcessorNPU</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L2580</source><parameters>[]</parameters></docstring>

Processor for implementing flash attention using torch_npu. Torch_npu supports only fp16 and bf16 data types. If
fp32 is used, F.scaled_dot_product_attention will be used for computation, but the acceleration effect on NPU is
not significant.



</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.FusedAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.FusedAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L3666</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product attention (enabled by default if you're using PyTorch 2.0). It uses
fused projection layers. For self-attention modules, all projection matrices (i.e., query, key, value) are fused.
For cross-attention modules, key and value projection matrices are fused.

> [!WARNING] > This API is currently 🧪 experimental in nature and can change in future.


</div>

## Allegro[[diffusers.models.attention_processor.AllegroAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.AllegroAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.AllegroAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L1991</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product attention (enabled by default if you're using PyTorch 2.0). This is
used in the Allegro model. It applies a normalization layer and rotary embedding on the query and key vector.


</div>

## AuraFlow[[diffusers.models.attention_processor.AuraFlowAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.AuraFlowAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.AuraFlowAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L2085</source><parameters>[]</parameters></docstring>
Attention processor used typically in processing Aura Flow.

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.FusedAuraFlowAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.FusedAuraFlowAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L2178</source><parameters>[]</parameters></docstring>
Attention processor used typically in processing Aura Flow with fused projections.

</div>

## CogVideoX[[diffusers.models.attention_processor.CogVideoXAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.CogVideoXAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.CogVideoXAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L2275</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product attention for the CogVideoX model. It applies a rotary embedding on
query and key vectors, but does not include spatial normalization.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.FusedCogVideoXAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.FusedCogVideoXAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L2344</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product attention for the CogVideoX model. It applies a rotary embedding on
query and key vectors, but does not include spatial normalization.


</div>

## CrossFrameAttnProcessor[[diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.CrossFrameAttnProcessor]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.CrossFrameAttnProcessor</name><anchor>diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.CrossFrameAttnProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L62</source><parameters>[{"name": "batch_size", "val": " = 2"}]</parameters><paramsdesc>- **batch_size** -- The number that represents actual batch size, other than the frames.
  For example, calling unet with a single prompt and num_images_per_prompt=1, batch_size should be equal to
  2, due to classifier-free guidance.</paramsdesc><paramgroups>0</paramgroups></docstring>

Cross frame attention processor. Each frame attends the first frame.




</div>

## Custom Diffusion[[diffusers.models.attention_processor.CustomDiffusionAttnProcessor]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.CustomDiffusionAttnProcessor</name><anchor>diffusers.models.attention_processor.CustomDiffusionAttnProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L1173</source><parameters>[{"name": "train_kv", "val": ": bool = True"}, {"name": "train_q_out", "val": ": bool = True"}, {"name": "hidden_size", "val": ": typing.Optional[int] = None"}, {"name": "cross_attention_dim", "val": ": typing.Optional[int] = None"}, {"name": "out_bias", "val": ": bool = True"}, {"name": "dropout", "val": ": float = 0.0"}]</parameters><paramsdesc>- **train_kv** (`bool`, defaults to `True`) --
  Whether to newly train the key and value matrices corresponding to the text features.
- **train_q_out** (`bool`, defaults to `True`) --
  Whether to newly train query matrices corresponding to the latent image features.
- **hidden_size** (`int`, *optional*, defaults to `None`) --
  The hidden size of the attention layer.
- **cross_attention_dim** (`int`, *optional*, defaults to `None`) --
  The number of channels in the `encoder_hidden_states`.
- **out_bias** (`bool`, defaults to `True`) --
  Whether to include the bias parameter in `train_q_out`.
- **dropout** (`float`, *optional*, defaults to 0.0) --
  The dropout probability to use.</paramsdesc><paramgroups>0</paramgroups></docstring>

Processor for implementing attention for the Custom Diffusion method.




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.CustomDiffusionAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.CustomDiffusionAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L3884</source><parameters>[{"name": "train_kv", "val": ": bool = True"}, {"name": "train_q_out", "val": ": bool = True"}, {"name": "hidden_size", "val": ": typing.Optional[int] = None"}, {"name": "cross_attention_dim", "val": ": typing.Optional[int] = None"}, {"name": "out_bias", "val": ": bool = True"}, {"name": "dropout", "val": ": float = 0.0"}]</parameters><paramsdesc>- **train_kv** (`bool`, defaults to `True`) --
  Whether to newly train the key and value matrices corresponding to the text features.
- **train_q_out** (`bool`, defaults to `True`) --
  Whether to newly train query matrices corresponding to the latent image features.
- **hidden_size** (`int`, *optional*, defaults to `None`) --
  The hidden size of the attention layer.
- **cross_attention_dim** (`int`, *optional*, defaults to `None`) --
  The number of channels in the `encoder_hidden_states`.
- **out_bias** (`bool`, defaults to `True`) --
  Whether to include the bias parameter in `train_q_out`.
- **dropout** (`float`, *optional*, defaults to 0.0) --
  The dropout probability to use.</paramsdesc><paramgroups>0</paramgroups></docstring>

Processor for implementing attention for the Custom Diffusion method using PyTorch 2.0’s memory-efficient scaled
dot-product attention.




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.CustomDiffusionXFormersAttnProcessor</name><anchor>diffusers.models.attention_processor.CustomDiffusionXFormersAttnProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L3768</source><parameters>[{"name": "train_kv", "val": ": bool = True"}, {"name": "train_q_out", "val": ": bool = False"}, {"name": "hidden_size", "val": ": typing.Optional[int] = None"}, {"name": "cross_attention_dim", "val": ": typing.Optional[int] = None"}, {"name": "out_bias", "val": ": bool = True"}, {"name": "dropout", "val": ": float = 0.0"}, {"name": "attention_op", "val": ": typing.Optional[typing.Callable] = None"}]</parameters><paramsdesc>- **train_kv** (`bool`, defaults to `True`) --
  Whether to newly train the key and value matrices corresponding to the text features.
- **train_q_out** (`bool`, defaults to `True`) --
  Whether to newly train query matrices corresponding to the latent image features.
- **hidden_size** (`int`, *optional*, defaults to `None`) --
  The hidden size of the attention layer.
- **cross_attention_dim** (`int`, *optional*, defaults to `None`) --
  The number of channels in the `encoder_hidden_states`.
- **out_bias** (`bool`, defaults to `True`) --
  Whether to include the bias parameter in `train_q_out`.
- **dropout** (`float`, *optional*, defaults to 0.0) --
  The dropout probability to use.
- **attention_op** (`Callable`, *optional*, defaults to `None`) --
  The base
  [operator](https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.AttentionOpBase) to use
  as the attention operator. It is recommended to set to `None`, and allow xFormers to choose the best operator.</paramsdesc><paramgroups>0</paramgroups></docstring>

Processor for implementing memory efficient attention using xFormers for the Custom Diffusion method.




</div>

## Flux[[diffusers.models.attention_processor.FluxAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.FluxAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.FluxAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5503</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.FusedFluxAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.FusedFluxAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5527</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.FluxSingleAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.FluxSingleAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5513</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>

Processor for implementing scaled dot-product attention (enabled by default if you're using PyTorch 2.0).


</div>

## Hunyuan[[diffusers.models.attention_processor.HunyuanAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.HunyuanAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.HunyuanAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L3122</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product attention (enabled by default if you're using PyTorch 2.0). This is
used in the HunyuanDiT model. It applies a s normalization layer and rotary embedding on query and key vector.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.FusedHunyuanAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.FusedHunyuanAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L3220</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product attention (enabled by default if you're using PyTorch 2.0) with fused
projection layers. This is used in the HunyuanDiT model. It applies a s normalization layer and rotary embedding on
query and key vector.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.PAGHunyuanAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.PAGHunyuanAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L3323</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product attention (enabled by default if you're using PyTorch 2.0). This is
used in the HunyuanDiT model. It applies a normalization layer and rotary embedding on query and key vector. This
variant of the processor employs [Pertubed Attention Guidance](https://huggingface.co/papers/2403.17377).


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.PAGCFGHunyuanAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.PAGCFGHunyuanAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L3446</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product attention (enabled by default if you're using PyTorch 2.0). This is
used in the HunyuanDiT model. It applies a normalization layer and rotary embedding on query and key vector. This
variant of the processor employs [Pertubed Attention Guidance](https://huggingface.co/papers/2403.17377).


</div>

## IdentitySelfAttnProcessor2_0[[diffusers.models.attention_processor.PAGIdentitySelfAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.PAGIdentitySelfAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.PAGIdentitySelfAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5041</source><parameters>[]</parameters></docstring>

Processor for implementing PAG using scaled dot-product attention (enabled by default if you're using PyTorch 2.0).
PAG reference: https://huggingface.co/papers/2403.17377


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.PAGCFGIdentitySelfAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.PAGCFGIdentitySelfAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5140</source><parameters>[]</parameters></docstring>

Processor for implementing PAG using scaled dot-product attention (enabled by default if you're using PyTorch 2.0).
PAG reference: https://huggingface.co/papers/2403.17377


</div>

## IP-Adapter[[diffusers.models.attention_processor.IPAdapterAttnProcessor]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.IPAdapterAttnProcessor</name><anchor>diffusers.models.attention_processor.IPAdapterAttnProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L4206</source><parameters>[{"name": "hidden_size", "val": ""}, {"name": "cross_attention_dim", "val": " = None"}, {"name": "num_tokens", "val": " = (4,)"}, {"name": "scale", "val": " = 1.0"}]</parameters><paramsdesc>- **hidden_size** (`int`) --
  The hidden size of the attention layer.
- **cross_attention_dim** (`int`) --
  The number of channels in the `encoder_hidden_states`.
- **num_tokens** (`int`, `Tuple[int]` or `List[int]`, defaults to `(4,)`) --
  The context length of the image features.
- **scale** (`float` or List`float`, defaults to 1.0) --
  the weight scale of image prompt.</paramsdesc><paramgroups>0</paramgroups></docstring>

Attention processor for Multiple IP-Adapters.




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.IPAdapterAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.IPAdapterAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L4406</source><parameters>[{"name": "hidden_size", "val": ""}, {"name": "cross_attention_dim", "val": " = None"}, {"name": "num_tokens", "val": " = (4,)"}, {"name": "scale", "val": " = 1.0"}]</parameters><paramsdesc>- **hidden_size** (`int`) --
  The hidden size of the attention layer.
- **cross_attention_dim** (`int`) --
  The number of channels in the `encoder_hidden_states`.
- **num_tokens** (`int`, `Tuple[int]` or `List[int]`, defaults to `(4,)`) --
  The context length of the image features.
- **scale** (`float` or `List[float]`, defaults to 1.0) --
  the weight scale of image prompt.</paramsdesc><paramgroups>0</paramgroups></docstring>

Attention processor for IP-Adapter for PyTorch 2.0.




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.SD3IPAdapterJointAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.SD3IPAdapterJointAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L4870</source><parameters>[{"name": "hidden_size", "val": ": int"}, {"name": "ip_hidden_states_dim", "val": ": int"}, {"name": "head_dim", "val": ": int"}, {"name": "timesteps_emb_dim", "val": ": int = 1280"}, {"name": "scale", "val": ": float = 0.5"}]</parameters><paramsdesc>- **hidden_size** (`int`) --
  The number of hidden channels.
- **ip_hidden_states_dim** (`int`) --
  The image feature dimension.
- **head_dim** (`int`) --
  The number of head channels.
- **timesteps_emb_dim** (`int`, defaults to 1280) --
  The number of input channels for timestep embedding.
- **scale** (`float`, defaults to 0.5) --
  IP-Adapter scale.</paramsdesc><paramgroups>0</paramgroups></docstring>

Attention processor for IP-Adapter used typically in processing the SD3-like self-attention projections, with
additional image-based information and timestep embeddings.




</div>

## JointAttnProcessor2_0[[diffusers.models.attention_processor.JointAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.JointAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.JointAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L1420</source><parameters>[]</parameters></docstring>
Attention processor used typically in processing the SD3-like self-attention projections.

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.PAGJointAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.PAGJointAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L1506</source><parameters>[]</parameters></docstring>
Attention processor used typically in processing the SD3-like self-attention projections.

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.PAGCFGJointAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.PAGCFGJointAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L1662</source><parameters>[]</parameters></docstring>
Attention processor used typically in processing the SD3-like self-attention projections.

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.FusedJointAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.FusedJointAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L1827</source><parameters>[]</parameters></docstring>
Attention processor used typically in processing the SD3-like self-attention projections.

</div>

## LoRA[[diffusers.models.attention_processor.LoRAAttnProcessor]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.LoRAAttnProcessor</name><anchor>diffusers.models.attention_processor.LoRAAttnProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5303</source><parameters>[]</parameters></docstring>

Processor for implementing attention with LoRA.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.LoRAAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.LoRAAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5312</source><parameters>[]</parameters></docstring>

Processor for implementing attention with LoRA (enabled by default if you're using PyTorch 2.0).


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.LoRAAttnAddedKVProcessor</name><anchor>diffusers.models.attention_processor.LoRAAttnAddedKVProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5330</source><parameters>[]</parameters></docstring>

Processor for implementing attention with LoRA with extra learnable key and value matrices for the text encoder.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.LoRAXFormersAttnProcessor</name><anchor>diffusers.models.attention_processor.LoRAXFormersAttnProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5321</source><parameters>[]</parameters></docstring>

Processor for implementing attention with LoRA using xFormers.


</div>

## Lumina-T2X[[diffusers.models.attention_processor.LuminaAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.LuminaAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.LuminaAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L3570</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product attention (enabled by default if you're using PyTorch 2.0). This is
used in the LuminaNextDiT model. It applies a s normalization layer and rotary embedding on query and key vector.


</div>

## Mochi[[diffusers.models.attention_processor.MochiAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.MochiAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.MochiAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L996</source><parameters>[]</parameters></docstring>
Attention processor used in Mochi.

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.MochiVaeAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.MochiVaeAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L2904</source><parameters>[]</parameters></docstring>

Attention processor used in Mochi VAE.


</div>

## Sana[[diffusers.models.attention_processor.SanaLinearAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.SanaLinearAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.SanaLinearAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5339</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product linear attention.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.SanaMultiscaleAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.SanaMultiscaleAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5243</source><parameters>[]</parameters></docstring>

Processor for implementing multiscale quadratic attention.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.PAGCFGSanaLinearAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.PAGCFGSanaLinearAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5391</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product linear attention.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.PAGIdentitySanaLinearAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.PAGIdentitySanaLinearAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5446</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product linear attention.


</div>

## Stable Audio[[diffusers.models.attention_processor.StableAudioAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.StableAudioAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.StableAudioAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L2989</source><parameters>[]</parameters></docstring>

Processor for implementing scaled dot-product attention (enabled by default if you're using PyTorch 2.0). This is
used in the Stable Audio model. It applies rotary embedding on query and key vector, and allows MHA, GQA or MQA.


</div>

## SlicedAttnProcessor[[diffusers.models.attention_processor.SlicedAttnProcessor]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.SlicedAttnProcessor</name><anchor>diffusers.models.attention_processor.SlicedAttnProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L3998</source><parameters>[{"name": "slice_size", "val": ": int"}]</parameters><paramsdesc>- **slice_size** (`int`, *optional*) --
  The number of steps to compute attention. Uses as many slices as `attention_head_dim // slice_size`, and
  `attention_head_dim` must be a multiple of the `slice_size`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Processor for implementing sliced attention.




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.SlicedAttnAddedKVProcessor</name><anchor>diffusers.models.attention_processor.SlicedAttnAddedKVProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L4085</source><parameters>[{"name": "slice_size", "val": ""}]</parameters><paramsdesc>- **slice_size** (`int`, *optional*) --
  The number of steps to compute attention. Uses as many slices as `attention_head_dim // slice_size`, and
  `attention_head_dim` must be a multiple of the `slice_size`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Processor for implementing sliced attention with extra learnable key and value matrices for the text encoder.




</div>

## XFormersAttnProcessor[[diffusers.models.attention_processor.XFormersAttnProcessor]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.XFormersAttnProcessor</name><anchor>diffusers.models.attention_processor.XFormersAttnProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L2486</source><parameters>[{"name": "attention_op", "val": ": typing.Optional[typing.Callable] = None"}]</parameters><paramsdesc>- **attention_op** (`Callable`, *optional*, defaults to `None`) --
  The base
  [operator](https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.AttentionOpBase) to
  use as the attention operator. It is recommended to set to `None`, and allow xFormers to choose the best
  operator.</paramsdesc><paramgroups>0</paramgroups></docstring>

Processor for implementing memory efficient attention using xFormers.




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.XFormersAttnAddedKVProcessor</name><anchor>diffusers.models.attention_processor.XFormersAttnAddedKVProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L2415</source><parameters>[{"name": "attention_op", "val": ": typing.Optional[typing.Callable] = None"}]</parameters><paramsdesc>- **attention_op** (`Callable`, *optional*, defaults to `None`) --
  The base
  [operator](https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.AttentionOpBase) to
  use as the attention operator. It is recommended to set to `None`, and allow xFormers to choose the best
  operator.</paramsdesc><paramgroups>0</paramgroups></docstring>

Processor for implementing memory efficient attention using xFormers.




</div>

## XLAFlashAttnProcessor2_0[[diffusers.models.attention_processor.XLAFlashAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.XLAFlashAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.XLAFlashAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L2788</source><parameters>[{"name": "partition_spec", "val": ": typing.Optional[typing.Tuple[typing.Optional[str], ...]] = None"}]</parameters></docstring>

Processor for implementing scaled dot-product attention with pallas flash attention kernel if using `torch_xla`.


</div>

## XFormersJointAttnProcessor[[diffusers.models.attention_processor.XFormersJointAttnProcessor]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.XFormersJointAttnProcessor</name><anchor>diffusers.models.attention_processor.XFormersJointAttnProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L1906</source><parameters>[{"name": "attention_op", "val": ": typing.Optional[typing.Callable] = None"}]</parameters><paramsdesc>- **attention_op** (`Callable`, *optional*, defaults to `None`) --
  The base
  [operator](https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.AttentionOpBase) to
  use as the attention operator. It is recommended to set to `None`, and allow xFormers to choose the best
  operator.</paramsdesc><paramgroups>0</paramgroups></docstring>

Processor for implementing memory efficient attention using xFormers.




</div>

## IPAdapterXFormersAttnProcessor[[diffusers.models.attention_processor.IPAdapterXFormersAttnProcessor]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.IPAdapterXFormersAttnProcessor</name><anchor>diffusers.models.attention_processor.IPAdapterXFormersAttnProcessor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L4638</source><parameters>[{"name": "hidden_size", "val": ""}, {"name": "cross_attention_dim", "val": " = None"}, {"name": "num_tokens", "val": " = (4,)"}, {"name": "scale", "val": " = 1.0"}, {"name": "attention_op", "val": ": typing.Optional[typing.Callable] = None"}]</parameters><paramsdesc>- **hidden_size** (`int`) --
  The hidden size of the attention layer.
- **cross_attention_dim** (`int`) --
  The number of channels in the `encoder_hidden_states`.
- **num_tokens** (`int`, `Tuple[int]` or `List[int]`, defaults to `(4,)`) --
  The context length of the image features.
- **scale** (`float` or `List[float]`, defaults to 1.0) --
  the weight scale of image prompt.
- **attention_op** (`Callable`, *optional*, defaults to `None`) --
  The base
  [operator](https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.AttentionOpBase) to
  use as the attention operator. It is recommended to set to `None`, and allow xFormers to choose the best
  operator.</paramsdesc><paramgroups>0</paramgroups></docstring>

Attention processor for IP-Adapter using xFormers.




</div>

## FluxIPAdapterJointAttnProcessor2_0[[diffusers.models.attention_processor.FluxIPAdapterJointAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.FluxIPAdapterJointAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.FluxIPAdapterJointAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5537</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

## XLAFluxFlashAttnProcessor2_0[[diffusers.models.attention_processor.XLAFluxFlashAttnProcessor2_0]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.attention_processor.XLAFluxFlashAttnProcessor2_0</name><anchor>diffusers.models.attention_processor.XLAFluxFlashAttnProcessor2_0</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py#L5577</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>

Processor for implementing scaled dot-product attention with pallas flash attention kernel if using `torch_xla`.


</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/attnprocessor.md" />