import{s as ts,n as as,o as ls}from"../chunks/scheduler.888833de.js";import{S as ns,i as is,e as i,s as l,c as r,h as ps,a as p,d as t,b as n,f as ss,g as m,j as o,k as P,l as os,m as a,n as c,t as u,o as h,p as d}from"../chunks/index.128ce987.js";import{C as y}from"../chunks/CodeBlock.37df032e.js";import{D as rs}from"../chunks/DocNotebookDropdown.cbea0b77.js";import{H as xe,E as ms}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function cs(Ee){let f,O,A,ee,J,se,T,te,j,Xe="Shap-E is a conditional model for generating 3D assets which could be used for video game development, interior design, and architecture. It is trained on a large dataset of 3D assets, and post-processed to render more views of each object and produce 16K instead of 4K point clouds. The Shap-E model is trained in two steps:",ae,U,Se="<li>an encoder accepts the point clouds and rendered views of a 3D asset and outputs the parameters of implicit functions that represent the asset</li> <li>a diffusion model is trained on the latents produced by the encoder to generate either neural radiance fields (NeRFs) or a textured 3D mesh, making it easier to render and use the 3D asset in downstream applications</li>",le,Z,Re="This guide will show you how to use Shap-E to start generating your own 3D assets!",ne,I,Ne="Before you begin, make sure you have the following libraries installed:",ie,_,pe,W,oe,v,Ve='To generate a gif of a 3D object, pass a text prompt to the <a href="/docs/diffusers/main/en/api/pipelines/shap_e#diffusers.ShapEPipeline">ShapEPipeline</a>. The pipeline generates a list of image frames which are used to create the 3D object.',re,C,me,B,Ye='이제 <a href="/docs/diffusers/main/en/api/utilities#diffusers.utils.export_to_gif">export_to_gif()</a> 함수를 사용해 이미지 프레임 리스트를 3D 오브젝트의 gif로 변환합니다.',ce,G,ue,M,qe='<div><img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/shap_e/firecracker_out.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">prompt = &quot;A firecracker&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/shap_e/cake_out.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">prompt = &quot;A birthday cupcake&quot;</figcaption></div>',he,k,de,$,Qe='To generate a 3D object from another image, use the <a href="/docs/diffusers/main/en/api/pipelines/shap_e#diffusers.ShapEImg2ImgPipeline">ShapEImg2ImgPipeline</a>. You can use an existing image or generate an entirely new one. Let’s use the <a href="../api/pipelines/kandinsky">Kandinsky 2.1</a> model to generate a new image.',fe,x,ye,E,ze='Pass the cheeseburger to the <a href="/docs/diffusers/main/en/api/pipelines/shap_e#diffusers.ShapEImg2ImgPipeline">ShapEImg2ImgPipeline</a> to generate a 3D representation of it.',Me,X,ge,g,Fe='<div><img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/shap_e/burger_in.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">cheeseburger</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/shap_e/burger_out.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">3D cheeseburger</figcaption></div>',be,S,we,R,He='Shap-E is a flexible model that can also generate textured mesh outputs to be rendered for downstream applications. In this example, you’ll convert the output into a <code>glb</code> file because the 🤗 Datasets library supports mesh visualization of <code>glb</code> files which can be rendered by the <a href="https://huggingface.co/docs/hub/datasets-viewer#dataset-preview" rel="nofollow">Dataset viewer</a>.',Je,N,De='You can generate mesh outputs for both the <a href="/docs/diffusers/main/en/api/pipelines/shap_e#diffusers.ShapEPipeline">ShapEPipeline</a> and <a href="/docs/diffusers/main/en/api/pipelines/shap_e#diffusers.ShapEImg2ImgPipeline">ShapEImg2ImgPipeline</a> by specifying the <code>output_type</code> parameter as <code>&quot;mesh&quot;</code>:',Te,V,je,Y,Le="Use the <code>export_to_ply()</code> function to save the mesh output as a <code>ply</code> file:",Ue,b,Pe="<p>You can optionally save the mesh output as an <code>obj</code> file with the <code>export_to_obj()</code> function. The ability to save the mesh output in a variety of formats makes it more flexible for downstream usage!</p>",Ze,q,Ie,Q,Ae="Then you can convert the <code>ply</code> file to a <code>glb</code> file with the trimesh library:",_e,z,We,F,Ke="By default, the mesh output is focused from the bottom viewpoint but you can change the default viewpoint by applying a rotation transform:",ve,H,Ce,D,Oe="Upload the mesh file to your dataset repository to visualize it with the Dataset viewer!",Be,w,es='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/3D-cake.gif"/>',Ge,L,ke,K,$e;return J=new xe({props:{title:"Shap-E",local:"shap-e",headingTag:"h1"}}),T=new rs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/shap-e.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/shap-e.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/shap-e.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/shap-e.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/shap-e.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/shap-e.ipynb"}]}}),_=new y({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwdHJpbWVzaA==",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate trimesh</span>`,wrap:!1}}),W=new xe({props:{title:"Text-to-3D",local:"text-to-3d",headingTag:"h2"}}),C=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU2hhcEVQaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMHRvcmNoLmRldmljZSglMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiklMEElMEFwaXBlJTIwJTNEJTIwU2hhcEVQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGc2hhcC1lJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oZGV2aWNlKSUwQSUwQWd1aWRhbmNlX3NjYWxlJTIwJTNEJTIwMTUuMCUwQXByb21wdCUyMCUzRCUyMCU1QiUyMkElMjBmaXJlY3JhY2tlciUyMiUyQyUyMCUyMkElMjBiaXJ0aGRheSUyMGN1cGNha2UlMjIlNUQlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEZ3VpZGFuY2Vfc2NhbGUlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENjQlMkMlMEElMjAlMjAlMjAlMjBmcmFtZV9zaXplJTNEMjU2JTJDJTBBKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ShapEPipeline

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)

pipe = ShapEPipeline.from_pretrained(<span class="hljs-string">&quot;openai/shap-e&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe = pipe.to(device)

guidance_scale = <span class="hljs-number">15.0</span>
prompt = [<span class="hljs-string">&quot;A firecracker&quot;</span>, <span class="hljs-string">&quot;A birthday cupcake&quot;</span>]

images = pipe(
    prompt,
    guidance_scale=guidance_scale,
    num_inference_steps=<span class="hljs-number">64</span>,
    frame_size=<span class="hljs-number">256</span>,
).images`,wrap:!1}}),G=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFleHBvcnRfdG9fZ2lmKGltYWdlcyU1QjAlNUQlMkMlMjAlMjJmaXJlY3JhY2tlcl8zZC5naWYlMjIpJTBBZXhwb3J0X3RvX2dpZihpbWFnZXMlNUIxJTVEJTJDJTIwJTIyY2FrZV8zZC5naWYlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

export_to_gif(images[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;firecracker_3d.gif&quot;</span>)
export_to_gif(images[<span class="hljs-number">1</span>], <span class="hljs-string">&quot;cake_3d.gif&quot;</span>)`,wrap:!1}}),k=new xe({props:{title:"Image-to-3D",local:"image-to-3d",headingTag:"h2"}}),x=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwcmlvcl9waXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMS1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjaGVlc2VidXJnZXIlMkMlMjB3aGl0ZSUyMGJhY2tncm91bmQlMjIlMEElMEFpbWFnZV9lbWJlZHMlMkMlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlMjAlM0QlMjBwcmlvcl9waXBlbGluZShwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuMCkudG9fdHVwbGUoKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRzJTNEaW1hZ2VfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjJidXJnZXIucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

prior_pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-prior&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cheeseburger, white background&quot;</span>

image_embeds, negative_image_embeds = prior_pipeline(prompt, guidance_scale=<span class="hljs-number">1.0</span>).to_tuple()
image = pipeline(
    prompt,
    image_embeds=image_embeds,
    negative_image_embeds=negative_image_embeds,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;burger.png&quot;</span>)`,wrap:!1}}),X=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNoYXBFSW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFwaXBlJTIwJTNEJTIwU2hhcEVJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRnNoYXAtZS1pbWcyaW1nJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBZ3VpZGFuY2Vfc2NhbGUlMjAlM0QlMjAzLjAlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oJTIyYnVyZ2VyLnBuZyUyMikucmVzaXplKCgyNTYlMkMlMjAyNTYpKSUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRGd1aWRhbmNlX3NjYWxlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDY0JTJDJTBBJTIwJTIwJTIwJTIwZnJhbWVfc2l6ZSUzRDI1NiUyQyUwQSkuaW1hZ2VzJTBBJTBBZ2lmX3BhdGglMjAlM0QlMjBleHBvcnRfdG9fZ2lmKGltYWdlcyU1QjAlNUQlMkMlMjAlMjJidXJnZXJfM2QuZ2lmJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ShapEImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

pipe = ShapEImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;openai/shap-e-img2img&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

guidance_scale = <span class="hljs-number">3.0</span>
image = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;burger.png&quot;</span>).resize((<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))

images = pipe(
    image,
    guidance_scale=guidance_scale,
    num_inference_steps=<span class="hljs-number">64</span>,
    frame_size=<span class="hljs-number">256</span>,
).images

gif_path = export_to_gif(images[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;burger_3d.gif&quot;</span>)`,wrap:!1}}),S=new xe({props:{title:"Generate mesh",local:"generate-mesh",headingTag:"h2"}}),V=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU2hhcEVQaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMHRvcmNoLmRldmljZSglMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiklMEElMEFwaXBlJTIwJTNEJTIwU2hhcEVQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGc2hhcC1lJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oZGV2aWNlKSUwQSUwQWd1aWRhbmNlX3NjYWxlJTIwJTNEJTIwMTUuMCUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBiaXJ0aGRheSUyMGN1cGNha2UlMjIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEZ3VpZGFuY2Vfc2NhbGUlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENjQlMkMlMjBmcmFtZV9zaXplJTNEMjU2JTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJtZXNoJTIyKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ShapEPipeline

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)

pipe = ShapEPipeline.from_pretrained(<span class="hljs-string">&quot;openai/shap-e&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipe = pipe.to(device)

guidance_scale = <span class="hljs-number">15.0</span>
prompt = <span class="hljs-string">&quot;A birthday cupcake&quot;</span>

images = pipe(prompt, guidance_scale=guidance_scale, num_inference_steps=<span class="hljs-number">64</span>, frame_size=<span class="hljs-number">256</span>, output_type=<span class="hljs-string">&quot;mesh&quot;</span>).images`,wrap:!1}}),q=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19wbHklMEElMEFwbHlfcGF0aCUyMCUzRCUyMGV4cG9ydF90b19wbHkoaW1hZ2VzJTVCMCU1RCUyQyUyMCUyMjNkX2Nha2UucGx5JTIyKSUwQXByaW50KGYlMjJTYXZlZCUyMHRvJTIwZm9sZGVyJTNBJTIwJTdCcGx5X3BhdGglN0QlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_ply

ply_path = export_to_ply(images[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;3d_cake.ply&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Saved to folder: <span class="hljs-subst">{ply_path}</span>&quot;</span>)`,wrap:!1}}),z=new y({props:{code:"aW1wb3J0JTIwdHJpbWVzaCUwQSUwQW1lc2glMjAlM0QlMjB0cmltZXNoLmxvYWQoJTIyM2RfY2FrZS5wbHklMjIpJTBBbWVzaF9leHBvcnQlMjAlM0QlMjBtZXNoLmV4cG9ydCglMjIzZF9jYWtlLmdsYiUyMiUyQyUyMGZpbGVfdHlwZSUzRCUyMmdsYiUyMik=",highlighted:`<span class="hljs-keyword">import</span> trimesh

mesh = trimesh.load(<span class="hljs-string">&quot;3d_cake.ply&quot;</span>)
mesh_export = mesh.export(<span class="hljs-string">&quot;3d_cake.glb&quot;</span>, file_type=<span class="hljs-string">&quot;glb&quot;</span>)`,wrap:!1}}),H=new y({props:{code:"aW1wb3J0JTIwdHJpbWVzaCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQW1lc2glMjAlM0QlMjB0cmltZXNoLmxvYWQoJTIyM2RfY2FrZS5wbHklMjIpJTBBcm90JTIwJTNEJTIwdHJpbWVzaC50cmFuc2Zvcm1hdGlvbnMucm90YXRpb25fbWF0cml4KC1ucC5waSUyMCUyRiUyMDIlMkMlMjAlNUIxJTJDJTIwMCUyQyUyMDAlNUQpJTBBbWVzaCUyMCUzRCUyMG1lc2guYXBwbHlfdHJhbnNmb3JtKHJvdCklMEFtZXNoX2V4cG9ydCUyMCUzRCUyMG1lc2guZXhwb3J0KCUyMjNkX2Nha2UuZ2xiJTIyJTJDJTIwZmlsZV90eXBlJTNEJTIyZ2xiJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> trimesh
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

mesh = trimesh.load(<span class="hljs-string">&quot;3d_cake.ply&quot;</span>)
rot = trimesh.transformations.rotation_matrix(-np.pi / <span class="hljs-number">2</span>, [<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>])
mesh = mesh.apply_transform(rot)
mesh_export = mesh.export(<span class="hljs-string">&quot;3d_cake.glb&quot;</span>, file_type=<span class="hljs-string">&quot;glb&quot;</span>)`,wrap:!1}}),L=new ms({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/shap-e.md"}}),{c(){f=i("meta"),O=l(),A=i("p"),ee=l(),r(J.$$.fragment),se=l(),r(T.$$.fragment),te=l(),j=i("p"),j.textContent=Xe,ae=l(),U=i("ol"),U.innerHTML=Se,le=l(),Z=i("p"),Z.textContent=Re,ne=l(),I=i("p"),I.textContent=Ne,ie=l(),r(_.$$.fragment),pe=l(),r(W.$$.fragment),oe=l(),v=i("p"),v.innerHTML=Ve,re=l(),r(C.$$.fragment),me=l(),B=i("p"),B.innerHTML=Ye,ce=l(),r(G.$$.fragment),ue=l(),M=i("div"),M.innerHTML=qe,he=l(),r(k.$$.fragment),de=l(),$=i("p"),$.innerHTML=Qe,fe=l(),r(x.$$.fragment),ye=l(),E=i("p"),E.innerHTML=ze,Me=l(),r(X.$$.fragment),ge=l(),g=i("div"),g.innerHTML=Fe,be=l(),r(S.$$.fragment),we=l(),R=i("p"),R.innerHTML=He,Je=l(),N=i("p"),N.innerHTML=De,Te=l(),r(V.$$.fragment),je=l(),Y=i("p"),Y.innerHTML=Le,Ue=l(),b=i("blockquote"),b.innerHTML=Pe,Ze=l(),r(q.$$.fragment),Ie=l(),Q=i("p"),Q.innerHTML=Ae,_e=l(),r(z.$$.fragment),We=l(),F=i("p"),F.textContent=Ke,ve=l(),r(H.$$.fragment),Ce=l(),D=i("p"),D.textContent=Oe,Be=l(),w=i("div"),w.innerHTML=es,Ge=l(),r(L.$$.fragment),ke=l(),K=i("p"),this.h()},l(e){const s=ps("svelte-u9bgzb",document.head);f=p(s,"META",{name:!0,content:!0}),s.forEach(t),O=n(e),A=p(e,"P",{}),ss(A).forEach(t),ee=n(e),m(J.$$.fragment,e),se=n(e),m(T.$$.fragment,e),te=n(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1t7c2id"&&(j.textContent=Xe),ae=n(e),U=p(e,"OL",{"data-svelte-h":!0}),o(U)!=="svelte-ux9ywu"&&(U.innerHTML=Se),le=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1pve02t"&&(Z.textContent=Re),ne=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-cwruts"&&(I.textContent=Ne),ie=n(e),m(_.$$.fragment,e),pe=n(e),m(W.$$.fragment,e),oe=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1b4su35"&&(v.innerHTML=Ve),re=n(e),m(C.$$.fragment,e),me=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1lzkqv5"&&(B.innerHTML=Ye),ce=n(e),m(G.$$.fragment,e),ue=n(e),M=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(M)!=="svelte-1lcwzvo"&&(M.innerHTML=qe),he=n(e),m(k.$$.fragment,e),de=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-7zoabe"&&($.innerHTML=Qe),fe=n(e),m(x.$$.fragment,e),ye=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-bxa3ys"&&(E.innerHTML=ze),Me=n(e),m(X.$$.fragment,e),ge=n(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-xd6lpk"&&(g.innerHTML=Fe),be=n(e),m(S.$$.fragment,e),we=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-b3two7"&&(R.innerHTML=He),Je=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-950hda"&&(N.innerHTML=De),Te=n(e),m(V.$$.fragment,e),je=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1c35t88"&&(Y.innerHTML=Le),Ue=n(e),b=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-2yfe2x"&&(b.innerHTML=Pe),Ze=n(e),m(q.$$.fragment,e),Ie=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-15r1kyy"&&(Q.innerHTML=Ae),_e=n(e),m(z.$$.fragment,e),We=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-14frru"&&(F.textContent=Ke),ve=n(e),m(H.$$.fragment,e),Ce=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1dqio5f"&&(D.textContent=Oe),Be=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1dmju3n"&&(w.innerHTML=es),Ge=n(e),m(L.$$.fragment,e),ke=n(e),K=p(e,"P",{}),ss(K).forEach(t),this.h()},h(){P(f,"name","hf:doc:metadata"),P(f,"content",us),P(M,"class","flex gap-4"),P(g,"class","flex gap-4"),P(b,"class","tip"),P(w,"class","flex justify-center")},m(e,s){os(document.head,f),a(e,O,s),a(e,A,s),a(e,ee,s),c(J,e,s),a(e,se,s),c(T,e,s),a(e,te,s),a(e,j,s),a(e,ae,s),a(e,U,s),a(e,le,s),a(e,Z,s),a(e,ne,s),a(e,I,s),a(e,ie,s),c(_,e,s),a(e,pe,s),c(W,e,s),a(e,oe,s),a(e,v,s),a(e,re,s),c(C,e,s),a(e,me,s),a(e,B,s),a(e,ce,s),c(G,e,s),a(e,ue,s),a(e,M,s),a(e,he,s),c(k,e,s),a(e,de,s),a(e,$,s),a(e,fe,s),c(x,e,s),a(e,ye,s),a(e,E,s),a(e,Me,s),c(X,e,s),a(e,ge,s),a(e,g,s),a(e,be,s),c(S,e,s),a(e,we,s),a(e,R,s),a(e,Je,s),a(e,N,s),a(e,Te,s),c(V,e,s),a(e,je,s),a(e,Y,s),a(e,Ue,s),a(e,b,s),a(e,Ze,s),c(q,e,s),a(e,Ie,s),a(e,Q,s),a(e,_e,s),c(z,e,s),a(e,We,s),a(e,F,s),a(e,ve,s),c(H,e,s),a(e,Ce,s),a(e,D,s),a(e,Be,s),a(e,w,s),a(e,Ge,s),c(L,e,s),a(e,ke,s),a(e,K,s),$e=!0},p:as,i(e){$e||(u(J.$$.fragment,e),u(T.$$.fragment,e),u(_.$$.fragment,e),u(W.$$.fragment,e),u(C.$$.fragment,e),u(G.$$.fragment,e),u(k.$$.fragment,e),u(x.$$.fragment,e),u(X.$$.fragment,e),u(S.$$.fragment,e),u(V.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(H.$$.fragment,e),u(L.$$.fragment,e),$e=!0)},o(e){h(J.$$.fragment,e),h(T.$$.fragment,e),h(_.$$.fragment,e),h(W.$$.fragment,e),h(C.$$.fragment,e),h(G.$$.fragment,e),h(k.$$.fragment,e),h(x.$$.fragment,e),h(X.$$.fragment,e),h(S.$$.fragment,e),h(V.$$.fragment,e),h(q.$$.fragment,e),h(z.$$.fragment,e),h(H.$$.fragment,e),h(L.$$.fragment,e),$e=!1},d(e){e&&(t(O),t(A),t(ee),t(se),t(te),t(j),t(ae),t(U),t(le),t(Z),t(ne),t(I),t(ie),t(pe),t(oe),t(v),t(re),t(me),t(B),t(ce),t(ue),t(M),t(he),t(de),t($),t(fe),t(ye),t(E),t(Me),t(ge),t(g),t(be),t(we),t(R),t(Je),t(N),t(Te),t(je),t(Y),t(Ue),t(b),t(Ze),t(Ie),t(Q),t(_e),t(We),t(F),t(ve),t(Ce),t(D),t(Be),t(w),t(Ge),t(ke),t(K)),t(f),d(J,e),d(T,e),d(_,e),d(W,e),d(C,e),d(G,e),d(k,e),d(x,e),d(X,e),d(S,e),d(V,e),d(q,e),d(z,e),d(H,e),d(L,e)}}}const us='{"title":"Shap-E","local":"shap-e","sections":[{"title":"Text-to-3D","local":"text-to-3d","sections":[],"depth":2},{"title":"Image-to-3D","local":"image-to-3d","sections":[],"depth":2},{"title":"Generate mesh","local":"generate-mesh","sections":[],"depth":2}],"depth":1}';function hs(Ee){return ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends ns{constructor(f){super(),is(this,f,hs,cs,ts,{})}}export{bs as component};
