import{s as ht,n as wt,o as bt}from"../chunks/scheduler.888833de.js";import{S as yt,i as Jt,e as n,s,c as r,h as Tt,a as p,d as t,b as a,f as Mt,g as m,j as o,k as Ue,l as gt,m as i,n as f,t as d,o as u,p as c}from"../chunks/index.128ce987.js";import{C as M}from"../chunks/CodeBlock.37df032e.js";import{D as jt}from"../chunks/DocNotebookDropdown.cbea0b77.js";import{H as w,E as Zt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function Ut(xl){let h,ve,je,We,T,Ie,g,Ge,j,El='Diffusion models consists of multiple components like UNets or diffusion transformers (DiTs), text encoders, variational autoencoders (VAEs), and schedulers. The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> wraps all of these components into a single easy-to-use API without giving up the flexibility to modify it’s components.',$e,Z,Hl='This guide will show you how to load a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',Be,U,_e,v,Cl='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is a base pipeline class that automatically selects and returns an instance of a model’s pipeline subclass, like <a href="/docs/diffusers/main/en/api/pipelines/qwenimage#diffusers.QwenImagePipeline">QwenImagePipeline</a>, by scanning the <code>model_index.json</code> file for the class name.',ke,W,Rl='Pass a model id to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load a pipeline.',xe,I,Ee,G,Xl='Every model has a specific pipeline subclass that inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. A subclass usually has a narrow focus and are task-specific. See the table below for an example.',He,$,Ql='<thead><tr><th>pipeline subclass</th> <th>task</th></tr></thead> <tbody><tr><td><a href="/docs/diffusers/main/en/api/pipelines/qwenimage#diffusers.QwenImagePipeline">QwenImagePipeline</a></td> <td>text-to-image</td></tr> <tr><td><a href="/docs/diffusers/main/en/api/pipelines/qwenimage#diffusers.QwenImageImg2ImgPipeline">QwenImageImg2ImgPipeline</a></td> <td>image-to-image</td></tr> <tr><td><a href="/docs/diffusers/main/en/api/pipelines/qwenimage#diffusers.QwenImageInpaintPipeline">QwenImageInpaintPipeline</a></td> <td>inpaint</td></tr></tbody>',Ce,B,Pl='You could use the subclass directly by passing a model id to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>.',Re,_,Xe,b,Yl='<p>Refer to the <a href="./other-formats#single-file-format">Single file format</a> docs to learn how to load single file models.</p>',Qe,k,Pe,x,Ll='Pipelines can also be run locally. Use <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download" rel="nofollow">snapshot_download</a> to download a model repository.',Ye,E,Le,H,Vl='The model is downloaded to your <a href="../installation#cache">cache</a>. Pass the folder path to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load it.',Ve,C,qe,R,ql='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method won’t download files from the Hub when it detects a local path. But this also means it won’t download and cache any updates that have been made to the model either.',Fe,X,Ne,Q,Fl='Use the <code>torch_dtype</code> argument in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load a model with a specific data type. This allows you to load different models in different precisions. For example, loading a large transformer model in half-precision reduces the memory required.',Se,P,Nl="Pass the data type for each model as a dictionary to <code>torch_dtype</code>. Use the <code>default</code> key to set the default data type. If a model isn’t in the dictionary and <code>default</code> isn’t provided, it is loaded in full precision (<code>torch.float32</code>).",De,Y,ze,L,Sl="You don’t need to use a dictionary if you’re loading all the models in the same data type.",Ae,V,Ke,q,Oe,F,Dl="The <code>device_map</code> argument determines individual model or pipeline placement on an accelerator like a GPU. It is especially helpful when there are multiple GPUs.",el,N,zl="A pipeline supports two options for <code>device_map</code>, <code>&quot;cuda&quot;</code> and <code>&quot;balanced&quot;</code>. Refer to the table below to compare the placement strategies.",ll,S,Al="<thead><tr><th>parameter</th> <th>description</th></tr></thead> <tbody><tr><td><code>&quot;cuda&quot;</code></td> <td>places pipeline on a supported accelerator device like CUDA</td></tr> <tr><td><code>&quot;balanced&quot;</code></td> <td>evenly distributes pipeline on all GPUs</td></tr></tbody>",tl,D,Kl='Use the <code>max_memory</code> argument in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to allocate a maximum amount of memory to use on each device. By default, Diffusers uses the maximum amount available.',il,z,sl,A,Ol="The <code>hf_device_map</code> attribute allows you to access and view the <code>device_map</code>.",al,K,nl,O,et='Reset a pipeline’s <code>device_map</code> with the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.reset_device_map">reset_device_map()</a> method. This is necessary if you want to use methods such as <code>.to()</code>, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, and <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a>.',pl,ee,ol,le,rl,te,lt='Large models are often <a href="../training/distributed_inference#model-sharding">sharded</a> into smaller files so that they are easier to load. Diffusers supports loading shards in parallel to speed up the loading process.',ml,ie,tt="Set <code>HF_ENABLE_PARALLEL_LOADING</code> to <code>&quot;YES&quot;</code> to enable parallel loading of shards.",fl,se,it="The <code>device_map</code> argument should be set to <code>&quot;cuda&quot;</code> to pre-allocate a large chunk of memory based on the model size. This substantially reduces model load time because warming up the memory allocator now avoids many smaller calls to the allocator later.",dl,ae,ul,ne,cl,pe,st='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is flexible and accommodates loading different models or schedulers. You can experiment with different schedulers to optimize for generation speed or quality, and you can replace models with more performant ones.',Ml,oe,at="The example below uses a more stable VAE version.",hl,re,wl,me,bl,fe,nt='When working with multiple pipelines that use the same model, the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method enables reusing a model instead of reloading it each time. This allows you to use multiple pipelines without increasing memory usage.',yl,de,pt="Memory usage is determined by the pipeline with the highest memory requirement regardless of the number of pipelines.",Jl,ue,ot='The example below loads a pipeline and then loads a second pipeline with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> to use <a href="../api/pipelines/pag">perturbed-attention guidance (PAG)</a> to improve generation quality.',Tl,y,rt='<p>Use <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForText2Image">AutoPipelineForText2Image</a> because <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> doesn’t support PAG. Refer to the <a href="../tutorials/autopipeline">AutoPipeline</a> docs to learn more.</p>',gl,ce,jl,Me,mt="Set <code>enable_pag=True</code> in the second pipeline to enable PAG. The second pipeline uses the same amount of memory because it shares model weights with the first one.",Zl,he,Ul,J,ft='<p>Pipelines created by <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> share the same models and <em>state</em>. Modifying the state of a model in one pipeline affects all the other pipelines that share the same model.</p>',vl,we,dt='Some methods may not work correctly on pipelines created with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a>. For example, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> relies on a unique model execution order, which may differ in the new pipeline. To ensure proper functionality, reapply these methods on the new pipeline.',Wl,be,Il,ye,ut='Diffusers provides a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">safety checker</a> for older Stable Diffusion models to prevent generating harmful content. It screens the generated output against a set of hardcoded harmful concepts.',Gl,Je,ct='If you want to disable the safety checker, pass <code>safety_checker=None</code> in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> as shown below.',$l,Te,Bl,ge,_l,Ze,kl;return T=new jt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"}]}}),g=new w({props:{title:"DiffusionPipeline",local:"diffusionpipeline",headingTag:"h1"}}),U=new w({props:{title:"Loading a pipeline",local:"loading-a-pipeline",headingTag:"h2"}}),I=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),_=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),k=new w({props:{title:"Local pipelines",local:"local-pipelines",headingTag:"h3"}}),E=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

snapshot_download(repo_id=<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>)`,wrap:!1}}),C=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJwYXRoJTJGdG8lMkZ5b3VyJTJGY2FjaGUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
  <span class="hljs-string">&quot;path/to/your/cache&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),X=new w({props:{title:"Pipeline data types",local:"pipeline-data-types",headingTag:"h2"}}),Y=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUwQSUyMCUyMHRvcmNoX2R0eXBlJTNEJTdCJTIydHJhbnNmb3JtZXIlMjIlM0ElMjB0b3JjaC5iZmxvYXQxNiUyQyUyMCUyMmRlZmF1bHQlMjIlM0ElMjB0b3JjaC5mbG9hdDE2JTdEJTJDJTBBKSUwQXByaW50KHBpcGVsaW5lLnRyYW5zZm9ybWVyLmR0eXBlJTJDJTIwcGlwZWxpbmUudmFlLmR0eXBlKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>,
  torch_dtype={<span class="hljs-string">&quot;transformer&quot;</span>: torch.bfloat16, <span class="hljs-string">&quot;default&quot;</span>: torch.float16},
)
<span class="hljs-built_in">print</span>(pipeline.transformer.dtype, pipeline.vae.dtype)`,wrap:!1}}),V=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcHJpbnQocGlwZWxpbmUudHJhbnNmb3JtZXIuZHR5cGUlMkMlMjBwaXBlbGluZS52YWUuZHR5cGUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16
)
<span class="hljs-built_in">print</span>(pipeline.transformer.dtype, pipeline.vae.dtype)`,wrap:!1}}),q=new w({props:{title:"Device placement",local:"device-placement",headingTag:"h2"}}),z=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtYXhfbWVtb3J5JTIwJTNEJTIwJTdCMCUzQSUyMCUyMjE2R0IlMjIlMkMlMjAxJTNBJTIwJTIyMTZHQiUyMiU3RCUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyJTJDJTIwJTBBJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

max_memory = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;16GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;16GB&quot;</span>}
pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, 
  torch_dtype=torch.bfloat16,
  device_map=<span class="hljs-string">&quot;cuda&quot;</span>,
)`,wrap:!1}}),K=new M({props:{code:"cHJpbnQocGlwZWxpbmUuaGZfZGV2aWNlX21hcCklMEElMjMlMjAlN0IndW5ldCclM0ElMjAxJTJDJTIwJ3ZhZSclM0ElMjAxJTJDJTIwJ3NhZmV0eV9jaGVja2VyJyUzQSUyMDAlMkMlMjAndGV4dF9lbmNvZGVyJyUzQSUyMDAlN0Q=",highlighted:`<span class="hljs-built_in">print</span>(pipeline.hf_device_map)
<span class="hljs-comment"># {&#x27;unet&#x27;: 1, &#x27;vae&#x27;: 1, &#x27;safety_checker&#x27;: 0, &#x27;text_encoder&#x27;: 0}</span>`,wrap:!1}}),ee=new M({props:{code:"cGlwZWxpbmUucmVzZXRfZGV2aWNlX21hcCgp",highlighted:"pipeline.reset_device_map()",wrap:!1}}),le=new w({props:{title:"Parallel loading",local:"parallel-loading",headingTag:"h2"}}),ae=new M({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQW9zLmVudmlyb24lNUIlMjJIRl9FTkFCTEVfUEFSQUxMRUxfTE9BRElORyUyMiU1RCUyMCUzRCUyMCUyMllFUyUyMiUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMldhbi1BSSUyRldhbjIuMi1JMlYtQTE0Qi1EaWZmdXNlcnMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

os.environ[<span class="hljs-string">&quot;HF_ENABLE_PARALLEL_LOADING&quot;</span>] = <span class="hljs-string">&quot;YES&quot;</span>

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;Wan-AI/Wan2.2-I2V-A14B-Diffusers&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),ne=new w({props:{title:"Replacing models in a pipeline",local:"replacing-models-in-a-pipeline",headingTag:"h2"}}),re=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBBdXRvTW9kZWwlMEElMEF2YWUlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMm1hZGVieW9sbGluJTJGc2R4bC12YWUtZnAxNi1maXglMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwdmFlJTNEdmFlJTJDJTBBJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, AutoModel

vae = AutoModel.from_pretrained(
  <span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16
)

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  vae=vae,
  torch_dtype=torch.float16,
  device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),me=new w({props:{title:"Reusing models in multiple pipelines",local:"reusing-models-in-multiple-pipelines",headingTag:"h2"}}),ce=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQSUwQXBpcGVsaW5lX3NkeGwlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBzaXBwaW5nJTIwYSUyMG1hcmdhcml0YSUyMGluJTIwYSUyMHBvb2wlMjBpbiUyMFBhbG0lMjBTcHJpbmdzJTJDJTIwQ2FsaWZvcm5pYSUwQWhpZ2hseSUyMGRldGFpbGVkJTJDJTIwaGlnaCUyMGJ1ZGdldCUyMGhvbGx5d29vZCUyMG1vdmllJTJDJTIwY2luZW1hc2NvcGUlMkMlMjBtb29keSUyQyUyMGVwaWMlMkMlMjBnb3JnZW91cyUyQyUyMGZpbG0lMjBncmFpbiUwQSUyMiUyMiUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmVfc2R4bChwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFwcmludChmJTIyTWF4JTIwbWVtb3J5JTIwcmVzZXJ2ZWQlM0ElMjAlN0J0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCklMjAlMkYlMjAxMDI0KiozJTNBLjJmJTdEJTIwR0IlMjIpJTBBJTIzJTIwTWF4JTIwbWVtb3J5JTIwcmVzZXJ2ZWQlM0ElMjAxMC40NyUyMEdC",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image

pipeline_sdxl = AutoPipelineForText2Image.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
image = pipeline_sdxl(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
<span class="hljs-comment"># Max memory reserved: 10.47 GB</span>`,wrap:!1}}),he=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcGlwZSglMEElMjAlMjBwaXBlbGluZV9zZHhsJTJDJTIwZW5hYmxlX3BhZyUzRFRydWUlMEEpJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwc2lwcGluZyUyMGElMjBtYXJnYXJpdGElMjBpbiUyMGElMjBwb29sJTIwaW4lMjBQYWxtJTIwU3ByaW5ncyUyQyUyMENhbGlmb3JuaWElMEFoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMEElMjIlMjIlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCkuaW1hZ2VzJTVCMCU1RCUwQXByaW50KGYlMjJNYXglMjBtZW1vcnklMjByZXNlcnZlZCUzQSUyMCU3QnRvcmNoLmN1ZGEubWF4X21lbW9yeV9hbGxvY2F0ZWQoKSUyMCUyRiUyMDEwMjQqKjMlM0EuMmYlN0QlMjBHQiUyMiklMEElMjMlMjBNYXglMjBtZW1vcnklMjByZXNlcnZlZCUzQSUyMDEwLjQ3JTIwR0I=",highlighted:`pipeline = AutoPipelineForText2Image.from_pipe(
  pipeline_sdxl, enable_pag=<span class="hljs-literal">True</span>
)
prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
image = pipeline(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
<span class="hljs-comment"># Max memory reserved: 10.47 GB</span>`,wrap:!1}}),be=new w({props:{title:"Safety checker",local:"safety-checker",headingTag:"h2"}}),Te=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTBBKSUwQSUyMiUyMiUyMiUwQVlvdSUyMGhhdmUlMjBkaXNhYmxlZCUyMHRoZSUyMHNhZmV0eSUyMGNoZWNrZXIlMjBmb3IlMjAlM0NjbGFzcyUyMCdkaWZmdXNlcnMucGlwZWxpbmVzLnN0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmVfc3RhYmxlX2RpZmZ1c2lvbi5TdGFibGVEaWZmdXNpb25QaXBlbGluZSclM0UlMjBieSUyMHBhc3NpbmclMjAlNjBzYWZldHlfY2hlY2tlciUzRE5vbmUlNjAuJTIwRW5zdXJlJTIwdGhhdCUyMHlvdSUyMGFiaWRlJTIwYnklMjB0aGUlMjBjb25kaXRpb25zJTIwb2YlMjB0aGUlMjBTdGFibGUlMjBEaWZmdXNpb24lMjBsaWNlbnNlJTIwYW5kJTIwZG8lMjBub3QlMjBleHBvc2UlMjB1bmZpbHRlcmVkJTIwcmVzdWx0cyUyMGluJTIwc2VydmljZXMlMjBvciUyMGFwcGxpY2F0aW9ucyUyMG9wZW4lMjB0byUyMHRoZSUyMHB1YmxpYy4lMjBCb3RoJTIwdGhlJTIwZGlmZnVzZXJzJTIwdGVhbSUyMGFuZCUyMEh1Z2dpbmclMjBGYWNlJTIwc3Ryb25nbHklMjByZWNvbW1lbmQlMjBrZWVwaW5nJTIwdGhlJTIwc2FmZXR5JTIwZmlsdGVyJTIwZW5hYmxlZCUyMGluJTIwYWxsJTIwcHVibGljLWZhY2luZyUyMGNpcmN1bXN0YW5jZXMlMkMlMjBkaXNhYmxpbmclMjBpdCUyMG9ubHklMjBmb3IlMjB1c2UlMjBjYXNlcyUyMHRoYXQlMjBpbnZvbHZlJTIwYW5hbHl6aW5nJTIwbmV0d29yayUyMGJlaGF2aW9yJTIwb3IlMjBhdWRpdGluZyUyMGl0cyUyMHJlc3VsdHMuJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTJDJTIwcGxlYXNlJTIwaGF2ZSUyMGElMjBsb29rJTIwYXQlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUyRnB1bGwlMkYyNTQlMjAuJTBBJTIyJTIyJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, safety_checker=<span class="hljs-literal">None</span>
)
<span class="hljs-string">&quot;&quot;&quot;
You have disabled the safety checker for &lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt; by passing \`safety_checker=None\`. Ensure that you abide by the conditions of the Stable Diffusion license and do not expose unfiltered results in services or applications open to the public. Both the diffusers team and Hugging Face strongly recommend keeping the safety filter enabled in all public-facing circumstances, disabling it only for use cases that involve analyzing network behavior or auditing its results. For more information, please have a look at https://github.com/huggingface/diffusers/pull/254 .
&quot;&quot;&quot;</span>`,wrap:!1}}),ge=new Zt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/loading.md"}}),{c(){h=n("meta"),ve=s(),je=n("p"),We=s(),r(T.$$.fragment),Ie=s(),r(g.$$.fragment),Ge=s(),j=n("p"),j.innerHTML=El,$e=s(),Z=n("p"),Z.innerHTML=Hl,Be=s(),r(U.$$.fragment),_e=s(),v=n("p"),v.innerHTML=Cl,ke=s(),W=n("p"),W.innerHTML=Rl,xe=s(),r(I.$$.fragment),Ee=s(),G=n("p"),G.innerHTML=Xl,He=s(),$=n("table"),$.innerHTML=Ql,Ce=s(),B=n("p"),B.innerHTML=Pl,Re=s(),r(_.$$.fragment),Xe=s(),b=n("blockquote"),b.innerHTML=Yl,Qe=s(),r(k.$$.fragment),Pe=s(),x=n("p"),x.innerHTML=Ll,Ye=s(),r(E.$$.fragment),Le=s(),H=n("p"),H.innerHTML=Vl,Ve=s(),r(C.$$.fragment),qe=s(),R=n("p"),R.innerHTML=ql,Fe=s(),r(X.$$.fragment),Ne=s(),Q=n("p"),Q.innerHTML=Fl,Se=s(),P=n("p"),P.innerHTML=Nl,De=s(),r(Y.$$.fragment),ze=s(),L=n("p"),L.textContent=Sl,Ae=s(),r(V.$$.fragment),Ke=s(),r(q.$$.fragment),Oe=s(),F=n("p"),F.innerHTML=Dl,el=s(),N=n("p"),N.innerHTML=zl,ll=s(),S=n("table"),S.innerHTML=Al,tl=s(),D=n("p"),D.innerHTML=Kl,il=s(),r(z.$$.fragment),sl=s(),A=n("p"),A.innerHTML=Ol,al=s(),r(K.$$.fragment),nl=s(),O=n("p"),O.innerHTML=et,pl=s(),r(ee.$$.fragment),ol=s(),r(le.$$.fragment),rl=s(),te=n("p"),te.innerHTML=lt,ml=s(),ie=n("p"),ie.innerHTML=tt,fl=s(),se=n("p"),se.innerHTML=it,dl=s(),r(ae.$$.fragment),ul=s(),r(ne.$$.fragment),cl=s(),pe=n("p"),pe.innerHTML=st,Ml=s(),oe=n("p"),oe.textContent=at,hl=s(),r(re.$$.fragment),wl=s(),r(me.$$.fragment),bl=s(),fe=n("p"),fe.innerHTML=nt,yl=s(),de=n("p"),de.textContent=pt,Jl=s(),ue=n("p"),ue.innerHTML=ot,Tl=s(),y=n("blockquote"),y.innerHTML=rt,gl=s(),r(ce.$$.fragment),jl=s(),Me=n("p"),Me.innerHTML=mt,Zl=s(),r(he.$$.fragment),Ul=s(),J=n("blockquote"),J.innerHTML=ft,vl=s(),we=n("p"),we.innerHTML=dt,Wl=s(),r(be.$$.fragment),Il=s(),ye=n("p"),ye.innerHTML=ut,Gl=s(),Je=n("p"),Je.innerHTML=ct,$l=s(),r(Te.$$.fragment),Bl=s(),r(ge.$$.fragment),_l=s(),Ze=n("p"),this.h()},l(e){const l=Tt("svelte-u9bgzb",document.head);h=p(l,"META",{name:!0,content:!0}),l.forEach(t),ve=a(e),je=p(e,"P",{}),Mt(je).forEach(t),We=a(e),m(T.$$.fragment,e),Ie=a(e),m(g.$$.fragment,e),Ge=a(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-15acv4d"&&(j.innerHTML=El),$e=a(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1r7k4fu"&&(Z.innerHTML=Hl),Be=a(e),m(U.$$.fragment,e),_e=a(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-77vcgr"&&(v.innerHTML=Cl),ke=a(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-ebiflz"&&(W.innerHTML=Rl),xe=a(e),m(I.$$.fragment,e),Ee=a(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-18gmtm6"&&(G.innerHTML=Xl),He=a(e),$=p(e,"TABLE",{"data-svelte-h":!0}),o($)!=="svelte-yqi7at"&&($.innerHTML=Ql),Ce=a(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-7u1us2"&&(B.innerHTML=Pl),Re=a(e),m(_.$$.fragment,e),Xe=a(e),b=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-88i11w"&&(b.innerHTML=Yl),Qe=a(e),m(k.$$.fragment,e),Pe=a(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-12ybt7d"&&(x.innerHTML=Ll),Ye=a(e),m(E.$$.fragment,e),Le=a(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-18vxmhu"&&(H.innerHTML=Vl),Ve=a(e),m(C.$$.fragment,e),qe=a(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-km3nn9"&&(R.innerHTML=ql),Fe=a(e),m(X.$$.fragment,e),Ne=a(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-ht6trw"&&(Q.innerHTML=Fl),Se=a(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-xbxzon"&&(P.innerHTML=Nl),De=a(e),m(Y.$$.fragment,e),ze=a(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-17eskne"&&(L.textContent=Sl),Ae=a(e),m(V.$$.fragment,e),Ke=a(e),m(q.$$.fragment,e),Oe=a(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-16dgqhw"&&(F.innerHTML=Dl),el=a(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-yjq2nu"&&(N.innerHTML=zl),ll=a(e),S=p(e,"TABLE",{"data-svelte-h":!0}),o(S)!=="svelte-1u6nxso"&&(S.innerHTML=Al),tl=a(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-ssiv2x"&&(D.innerHTML=Kl),il=a(e),m(z.$$.fragment,e),sl=a(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-jt67uv"&&(A.innerHTML=Ol),al=a(e),m(K.$$.fragment,e),nl=a(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-17qp95k"&&(O.innerHTML=et),pl=a(e),m(ee.$$.fragment,e),ol=a(e),m(le.$$.fragment,e),rl=a(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-14tzv1s"&&(te.innerHTML=lt),ml=a(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-uz1jzg"&&(ie.innerHTML=tt),fl=a(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-34lk0z"&&(se.innerHTML=it),dl=a(e),m(ae.$$.fragment,e),ul=a(e),m(ne.$$.fragment,e),cl=a(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1ejgwxl"&&(pe.innerHTML=st),Ml=a(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1i6angb"&&(oe.textContent=at),hl=a(e),m(re.$$.fragment,e),wl=a(e),m(me.$$.fragment,e),bl=a(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-2i9f2r"&&(fe.innerHTML=nt),yl=a(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-fe2l13"&&(de.textContent=pt),Jl=a(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-142eqve"&&(ue.innerHTML=ot),Tl=a(e),y=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-tcfbns"&&(y.innerHTML=rt),gl=a(e),m(ce.$$.fragment,e),jl=a(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-tea5ze"&&(Me.innerHTML=mt),Zl=a(e),m(he.$$.fragment,e),Ul=a(e),J=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-1mgat1c"&&(J.innerHTML=ft),vl=a(e),we=p(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1iyxpvz"&&(we.innerHTML=dt),Wl=a(e),m(be.$$.fragment,e),Il=a(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1fc5mnv"&&(ye.innerHTML=ut),Gl=a(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-3onxuv"&&(Je.innerHTML=ct),$l=a(e),m(Te.$$.fragment,e),Bl=a(e),m(ge.$$.fragment,e),_l=a(e),Ze=p(e,"P",{}),Mt(Ze).forEach(t),this.h()},h(){Ue(h,"name","hf:doc:metadata"),Ue(h,"content",vt),Ue(b,"class","tip"),Ue(y,"class","warning"),Ue(J,"class","warning")},m(e,l){gt(document.head,h),i(e,ve,l),i(e,je,l),i(e,We,l),f(T,e,l),i(e,Ie,l),f(g,e,l),i(e,Ge,l),i(e,j,l),i(e,$e,l),i(e,Z,l),i(e,Be,l),f(U,e,l),i(e,_e,l),i(e,v,l),i(e,ke,l),i(e,W,l),i(e,xe,l),f(I,e,l),i(e,Ee,l),i(e,G,l),i(e,He,l),i(e,$,l),i(e,Ce,l),i(e,B,l),i(e,Re,l),f(_,e,l),i(e,Xe,l),i(e,b,l),i(e,Qe,l),f(k,e,l),i(e,Pe,l),i(e,x,l),i(e,Ye,l),f(E,e,l),i(e,Le,l),i(e,H,l),i(e,Ve,l),f(C,e,l),i(e,qe,l),i(e,R,l),i(e,Fe,l),f(X,e,l),i(e,Ne,l),i(e,Q,l),i(e,Se,l),i(e,P,l),i(e,De,l),f(Y,e,l),i(e,ze,l),i(e,L,l),i(e,Ae,l),f(V,e,l),i(e,Ke,l),f(q,e,l),i(e,Oe,l),i(e,F,l),i(e,el,l),i(e,N,l),i(e,ll,l),i(e,S,l),i(e,tl,l),i(e,D,l),i(e,il,l),f(z,e,l),i(e,sl,l),i(e,A,l),i(e,al,l),f(K,e,l),i(e,nl,l),i(e,O,l),i(e,pl,l),f(ee,e,l),i(e,ol,l),f(le,e,l),i(e,rl,l),i(e,te,l),i(e,ml,l),i(e,ie,l),i(e,fl,l),i(e,se,l),i(e,dl,l),f(ae,e,l),i(e,ul,l),f(ne,e,l),i(e,cl,l),i(e,pe,l),i(e,Ml,l),i(e,oe,l),i(e,hl,l),f(re,e,l),i(e,wl,l),f(me,e,l),i(e,bl,l),i(e,fe,l),i(e,yl,l),i(e,de,l),i(e,Jl,l),i(e,ue,l),i(e,Tl,l),i(e,y,l),i(e,gl,l),f(ce,e,l),i(e,jl,l),i(e,Me,l),i(e,Zl,l),f(he,e,l),i(e,Ul,l),i(e,J,l),i(e,vl,l),i(e,we,l),i(e,Wl,l),f(be,e,l),i(e,Il,l),i(e,ye,l),i(e,Gl,l),i(e,Je,l),i(e,$l,l),f(Te,e,l),i(e,Bl,l),f(ge,e,l),i(e,_l,l),i(e,Ze,l),kl=!0},p:wt,i(e){kl||(d(T.$$.fragment,e),d(g.$$.fragment,e),d(U.$$.fragment,e),d(I.$$.fragment,e),d(_.$$.fragment,e),d(k.$$.fragment,e),d(E.$$.fragment,e),d(C.$$.fragment,e),d(X.$$.fragment,e),d(Y.$$.fragment,e),d(V.$$.fragment,e),d(q.$$.fragment,e),d(z.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(re.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),d(he.$$.fragment,e),d(be.$$.fragment,e),d(Te.$$.fragment,e),d(ge.$$.fragment,e),kl=!0)},o(e){u(T.$$.fragment,e),u(g.$$.fragment,e),u(U.$$.fragment,e),u(I.$$.fragment,e),u(_.$$.fragment,e),u(k.$$.fragment,e),u(E.$$.fragment,e),u(C.$$.fragment,e),u(X.$$.fragment,e),u(Y.$$.fragment,e),u(V.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(be.$$.fragment,e),u(Te.$$.fragment,e),u(ge.$$.fragment,e),kl=!1},d(e){e&&(t(ve),t(je),t(We),t(Ie),t(Ge),t(j),t($e),t(Z),t(Be),t(_e),t(v),t(ke),t(W),t(xe),t(Ee),t(G),t(He),t($),t(Ce),t(B),t(Re),t(Xe),t(b),t(Qe),t(Pe),t(x),t(Ye),t(Le),t(H),t(Ve),t(qe),t(R),t(Fe),t(Ne),t(Q),t(Se),t(P),t(De),t(ze),t(L),t(Ae),t(Ke),t(Oe),t(F),t(el),t(N),t(ll),t(S),t(tl),t(D),t(il),t(sl),t(A),t(al),t(nl),t(O),t(pl),t(ol),t(rl),t(te),t(ml),t(ie),t(fl),t(se),t(dl),t(ul),t(cl),t(pe),t(Ml),t(oe),t(hl),t(wl),t(bl),t(fe),t(yl),t(de),t(Jl),t(ue),t(Tl),t(y),t(gl),t(jl),t(Me),t(Zl),t(Ul),t(J),t(vl),t(we),t(Wl),t(Il),t(ye),t(Gl),t(Je),t($l),t(Bl),t(_l),t(Ze)),t(h),c(T,e),c(g,e),c(U,e),c(I,e),c(_,e),c(k,e),c(E,e),c(C,e),c(X,e),c(Y,e),c(V,e),c(q,e),c(z,e),c(K,e),c(ee,e),c(le,e),c(ae,e),c(ne,e),c(re,e),c(me,e),c(ce,e),c(he,e),c(be,e),c(Te,e),c(ge,e)}}}const vt='{"title":"DiffusionPipeline","local":"diffusionpipeline","sections":[{"title":"Loading a pipeline","local":"loading-a-pipeline","sections":[{"title":"Local pipelines","local":"local-pipelines","sections":[],"depth":3}],"depth":2},{"title":"Pipeline data types","local":"pipeline-data-types","sections":[],"depth":2},{"title":"Device placement","local":"device-placement","sections":[],"depth":2},{"title":"Parallel loading","local":"parallel-loading","sections":[],"depth":2},{"title":"Replacing models in a pipeline","local":"replacing-models-in-a-pipeline","sections":[],"depth":2},{"title":"Reusing models in multiple pipelines","local":"reusing-models-in-multiple-pipelines","sections":[],"depth":2},{"title":"Safety checker","local":"safety-checker","sections":[],"depth":2}],"depth":1}';function Wt(xl){return bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends yt{constructor(h){super(),Jt(this,h,Wt,Ut,ht,{})}}export{kt as component};
