import{s as Ct,n as Rt,o as kt}from"../chunks/scheduler.888833de.js";import{S as vt,i as Yt,e as i,s as a,c as m,h as Et,a as p,d as l,b as n,f as Vt,g as r,j as o,k as re,l as Ht,m as s,n as c,t as d,o as M,p as J}from"../chunks/index.128ce987.js";import{C as u}from"../chunks/CodeBlock.37df032e.js";import{D as Nt}from"../chunks/DocNotebookDropdown.cbea0b77.js";import{H as nt,E as $t}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function xt(it){let y,ce,oe,de,T,Me,h,Je,g,pt="Image editing typically requires providing a mask of the area to be edited. DiffEdit automatically generates the mask for you based on a text query, making it easier overall to create a mask without image editing software. The DiffEdit algorithm works in three steps:",ue,U,ot="<li>the diffusion model denoises an image conditioned on some query text and reference text which produces different noise estimates for different areas of the image; the difference is used to infer a mask to identify which area of the image needs to be changed to match the query text</li> <li>the input image is encoded into latent space with DDIM</li> <li>the latents are decoded with the diffusion model conditioned on the text query, using the mask as a guide such that pixels outside the mask remain the same as in the input image</li>",ye,j,mt="This guide will show you how to use DiffEdit to edit images without manually creating a mask.",fe,Z,rt="Before you begin, make sure you have the following libraries installed:",we,I,be,W,ct='The <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline">StableDiffusionDiffEditPipeline</a> requires an image mask and a set of partially inverted latents. The image mask is generated from the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.generate_mask">generate_mask()</a> function, and includes two parameters, <code>source_prompt</code> and <code>target_prompt</code>. These parameters determine what to edit in the image. For example, if you want to change a bowl of <em>fruits</em> to a bowl of <em>pears</em>, then:',Te,_,he,G,dt='The partially inverted latents are generated from the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.invert">invert()</a> function, and it is generally a good idea to include a <code>prompt</code> or <em>caption</em> describing the image to help guide the inverse latent sampling process. The caption can often be your <code>source_prompt</code>, but feel free to experiment with other text descriptions!',ge,B,Mt="Let’s load the pipeline, scheduler, inverse scheduler, and enable some optimizations to reduce memory usage:",Ue,X,je,V,Jt="Load the image to edit:",Ze,C,Ie,R,ut='Use the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.generate_mask">generate_mask()</a> function to generate the image mask. You’ll need to pass it the <code>source_prompt</code> and <code>target_prompt</code> to specify what to edit in the image:',We,k,_e,v,yt="Next, create the inverted latents and pass it a caption describing the image:",Ge,Y,Be,E,ft="Finally, pass the image mask and inverted latents to the pipeline. The <code>target_prompt</code> becomes the <code>prompt</code> now, and the <code>source_prompt</code> is used as the <code>negative_prompt</code>:",Xe,H,Ve,f,wt='<div><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/blob/main/assets/target.png?raw=true"/> <figcaption class="mt-2 text-center text-sm text-gray-500">edited image</figcaption></div>',Ce,N,Re,$,bt='The source and target embeddings can be automatically generated with the <a href="https://huggingface.co/docs/transformers/model_doc/flan-t5" rel="nofollow">Flan-T5</a> model instead of creating them manually.',ke,x,Tt="Load the Flan-T5 model and tokenizer from the 🤗 Transformers library:",ve,F,Ye,Q,ht="Provide some initial text to prompt the model to generate the source and target prompts.",Ee,z,He,S,gt="Next, create a utility function to generate the prompts:",Ne,D,$e,w,Ut='<p>Check out the <a href="https://huggingface.co/docs/transformers/main/en/generation_strategies" rel="nofollow">generation strategy</a> guide if you’re interested in learning more about strategies for generating different quality text.</p>',xe,A,jt='Load the text encoder model used by the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline">StableDiffusionDiffEditPipeline</a> to encode the text. You’ll use the text encoder to compute the text embeddings:',Fe,q,Qe,L,Zt='Finally, pass the embeddings to the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.generate_mask">generate_mask()</a> and <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.invert">invert()</a> functions, and pipeline to generate the image:',ze,P,Se,K,De,O,It='While you can use the <code>source_prompt</code> as a caption to help generate the partially inverted latents, you can also use the <a href="https://huggingface.co/docs/transformers/model_doc/blip" rel="nofollow">BLIP</a> model to automatically generate a caption.',Ae,ee,Wt="Load the BLIP model and processor from the 🤗 Transformers library:",qe,te,Le,le,_t="Create a utility function to generate a caption from the input image:",Pe,se,Ke,ae,Gt="Load an input image and generate a caption for it using the <code>generate_caption</code> function:",Oe,ne,et,b,Bt='<figure><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png"/> <figcaption class="text-center">generated caption: &quot;a photograph of a bowl of fruit on a table&quot;</figcaption></figure>',tt,ie,Xt='Now you can drop the caption into the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.invert">invert()</a> function to generate the partially inverted latents!',lt,pe,st,me,at;return T=new nt({props:{title:"DiffEdit",local:"diffedit",headingTag:"h1"}}),h=new Nt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/diffedit.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/diffedit.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/diffedit.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/diffedit.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/diffedit.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/diffedit.ipynb"}]}}),I=new u({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRl",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate</span>`,wrap:!1}}),_=new u({props:{code:"c291cmNlX3Byb21wdCUyMCUzRCUyMCUyMmElMjBib3dsJTIwb2YlMjBmcnVpdHMlMjIlMEF0YXJnZXRfcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJvd2wlMjBvZiUyMHBlYXJzJTIy",highlighted:`source_prompt = <span class="hljs-string">&quot;a bowl of fruits&quot;</span>
target_prompt = <span class="hljs-string">&quot;a bowl of pears&quot;</span>`,wrap:!1}}),X=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVNjaGVkdWxlciUyQyUyMERESU1JbnZlcnNlU2NoZWR1bGVyJTJDJTIwU3RhYmxlRGlmZnVzaW9uRGlmZkVkaXRQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uRGlmZkVkaXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHNhZmV0eV9jaGVja2VyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmludmVyc2Vfc2NoZWR1bGVyJTIwJTNEJTIwRERJTUludmVyc2VTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXBpcGVsaW5lLmVuYWJsZV92YWVfc2xpY2luZygp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, DDIMInverseScheduler, StableDiffusionDiffEditPipeline

pipeline = StableDiffusionDiffEditPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
    torch_dtype=torch.float16,
    safety_checker=<span class="hljs-literal">None</span>,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.inverse_scheduler = DDIMInverseScheduler.from_config(pipeline.scheduler.config)
pipeline.enable_model_cpu_offload()
pipeline.enable_vae_slicing()`,wrap:!1}}),C=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGWGlhbmctY2QlMkZEaWZmRWRpdC1zdGFibGUtZGlmZnVzaW9uJTJGcmF3JTJGbWFpbiUyRmFzc2V0cyUyRm9yaWdpbi5wbmclMjIlMEFyYXdfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNzY4JTJDJTIwNzY4KSklMEFyYXdfaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

img_url = <span class="hljs-string">&quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;</span>
raw_image = load_image(img_url).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))
raw_image`,wrap:!1}}),k=new u({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBc291cmNlX3Byb21wdCUyMCUzRCUyMCUyMmElMjBib3dsJTIwb2YlMjBmcnVpdHMlMjIlMEF0YXJnZXRfcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJhc2tldCUyMG9mJTIwcGVhcnMlMjIlMEFtYXNrX2ltYWdlJTIwJTNEJTIwcGlwZWxpbmUuZ2VuZXJhdGVfbWFzayglMEElMjAlMjAlMjAlMjBpbWFnZSUzRHJhd19pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMHNvdXJjZV9wcm9tcHQlM0Rzb3VyY2VfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X3Byb21wdCUzRHRhcmdldF9wcm9tcHQlMkMlMEEpJTBBSW1hZ2UuZnJvbWFycmF5KChtYXNrX2ltYWdlLnNxdWVlemUoKSoyNTUpLmFzdHlwZSglMjJ1aW50OCUyMiklMkMlMjAlMjJMJTIyKS5yZXNpemUoKDc2OCUyQyUyMDc2OCkp",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

source_prompt = <span class="hljs-string">&quot;a bowl of fruits&quot;</span>
target_prompt = <span class="hljs-string">&quot;a basket of pears&quot;</span>
mask_image = pipeline.generate_mask(
    image=raw_image,
    source_prompt=source_prompt,
    target_prompt=target_prompt,
)
Image.fromarray((mask_image.squeeze()*<span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>), <span class="hljs-string">&quot;L&quot;</span>).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))`,wrap:!1}}),Y=new u({props:{code:"aW52X2xhdGVudHMlMjAlM0QlMjBwaXBlbGluZS5pbnZlcnQocHJvbXB0JTNEc291cmNlX3Byb21wdCUyQyUyMGltYWdlJTNEcmF3X2ltYWdlKS5sYXRlbnRz",highlighted:"inv_latents = pipeline.invert(prompt=source_prompt, image=raw_image).latents",wrap:!1}}),H=new u({props:{code:"b3V0cHV0X2ltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEdGFyZ2V0X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfbGF0ZW50cyUzRGludl9sYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEc291cmNlX3Byb21wdCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoKG1hc2tfaW1hZ2Uuc3F1ZWV6ZSgpKjI1NSkuYXN0eXBlKCUyMnVpbnQ4JTIyKSUyQyUyMCUyMkwlMjIpLnJlc2l6ZSgoNzY4JTJDJTIwNzY4KSklMEFtYWtlX2ltYWdlX2dyaWQoJTVCcmF3X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMG91dHB1dF9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`output_image = pipeline(
    prompt=target_prompt,
    mask_image=mask_image,
    image_latents=inv_latents,
    negative_prompt=source_prompt,
).images[<span class="hljs-number">0</span>]
mask_image = Image.fromarray((mask_image.squeeze()*<span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>), <span class="hljs-string">&quot;L&quot;</span>).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))
make_image_grid([raw_image, mask_image, output_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),N=new nt({props:{title:"Generate source and target embeddings",local:"generate-source-and-target-embeddings",headingTag:"h2"}}),F=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1sYXJnZSUyMiklMEFtb2RlbCUyMCUzRCUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LWxhcmdlJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, T5ForConditionalGeneration

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-large&quot;</span>)
model = T5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-large&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.float16)`,wrap:!1}}),z=new u({props:{code:"c291cmNlX2NvbmNlcHQlMjAlM0QlMjAlMjJib3dsJTIyJTBBdGFyZ2V0X2NvbmNlcHQlMjAlM0QlMjAlMjJiYXNrZXQlMjIlMEElMEFzb3VyY2VfdGV4dCUyMCUzRCUyMGYlMjJQcm92aWRlJTIwYSUyMGNhcHRpb24lMjBmb3IlMjBpbWFnZXMlMjBjb250YWluaW5nJTIwYSUyMCU3QnNvdXJjZV9jb25jZXB0JTdELiUyMCUyMiUwQSUyMlRoZSUyMGNhcHRpb25zJTIwc2hvdWxkJTIwYmUlMjBpbiUyMEVuZ2xpc2glMjBhbmQlMjBzaG91bGQlMjBiZSUyMG5vJTIwbG9uZ2VyJTIwdGhhbiUyMDE1MCUyMGNoYXJhY3RlcnMuJTIyJTBBJTBBdGFyZ2V0X3RleHQlMjAlM0QlMjBmJTIyUHJvdmlkZSUyMGElMjBjYXB0aW9uJTIwZm9yJTIwaW1hZ2VzJTIwY29udGFpbmluZyUyMGElMjAlN0J0YXJnZXRfY29uY2VwdCU3RC4lMjAlMjIlMEElMjJUaGUlMjBjYXB0aW9ucyUyMHNob3VsZCUyMGJlJTIwaW4lMjBFbmdsaXNoJTIwYW5kJTIwc2hvdWxkJTIwYmUlMjBubyUyMGxvbmdlciUyMHRoYW4lMjAxNTAlMjBjaGFyYWN0ZXJzLiUyMg==",highlighted:`source_concept = <span class="hljs-string">&quot;bowl&quot;</span>
target_concept = <span class="hljs-string">&quot;basket&quot;</span>

source_text = <span class="hljs-string">f&quot;Provide a caption for images containing a <span class="hljs-subst">{source_concept}</span>. &quot;</span>
<span class="hljs-string">&quot;The captions should be in English and should be no longer than 150 characters.&quot;</span>

target_text = <span class="hljs-string">f&quot;Provide a caption for images containing a <span class="hljs-subst">{target_concept}</span>. &quot;</span>
<span class="hljs-string">&quot;The captions should be in English and should be no longer than 150 characters.&quot;</span>`,wrap:!1}}),D=new u({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwZ2VuZXJhdGVfcHJvbXB0cyhpbnB1dF9wcm9tcHQpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3Byb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcy50byglMjJjdWRhJTIyKSUwQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjB0ZW1wZXJhdHVyZSUzRDAuOCUyQyUyMG51bV9yZXR1cm5fc2VxdWVuY2VzJTNEMTYlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjglMkMlMjB0b3BfayUzRDEwJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUwQXNvdXJjZV9wcm9tcHRzJTIwJTNEJTIwZ2VuZXJhdGVfcHJvbXB0cyhzb3VyY2VfdGV4dCklMEF0YXJnZXRfcHJvbXB0cyUyMCUzRCUyMGdlbmVyYXRlX3Byb21wdHModGFyZ2V0X3RleHQpJTBBcHJpbnQoc291cmNlX3Byb21wdHMpJTBBcHJpbnQodGFyZ2V0X3Byb21wdHMp",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_prompts</span>(<span class="hljs-params">input_prompt</span>):
    input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids.to(<span class="hljs-string">&quot;cuda&quot;</span>)

    outputs = model.generate(
        input_ids, temperature=<span class="hljs-number">0.8</span>, num_return_sequences=<span class="hljs-number">16</span>, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">128</span>, top_k=<span class="hljs-number">10</span>
    )
    <span class="hljs-keyword">return</span> tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)

source_prompts = generate_prompts(source_text)
target_prompts = generate_prompts(target_text)
<span class="hljs-built_in">print</span>(source_prompts)
<span class="hljs-built_in">print</span>(target_prompts)`,wrap:!1}}),q=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionDiffEditPipeline

pipeline = StableDiffusionDiffEditPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
pipeline.enable_vae_slicing()

<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">embed_prompts</span>(<span class="hljs-params">sentences, tokenizer, text_encoder, device=<span class="hljs-string">&quot;cuda&quot;</span></span>):
    embeddings = []
    <span class="hljs-keyword">for</span> sent <span class="hljs-keyword">in</span> sentences:
        text_inputs = tokenizer(
            sent,
            padding=<span class="hljs-string">&quot;max_length&quot;</span>,
            max_length=tokenizer.model_max_length,
            truncation=<span class="hljs-literal">True</span>,
            return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
        )
        text_input_ids = text_inputs.input_ids
        prompt_embeds = text_encoder(text_input_ids.to(device), attention_mask=<span class="hljs-literal">None</span>)[<span class="hljs-number">0</span>]
        embeddings.append(prompt_embeds)
    <span class="hljs-keyword">return</span> torch.concatenate(embeddings, dim=<span class="hljs-number">0</span>).mean(dim=<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)

source_embeds = embed_prompts(source_prompts, pipeline.tokenizer, pipeline.text_encoder)
target_embeds = embed_prompts(target_prompts, pipeline.tokenizer, pipeline.text_encoder)`,wrap:!1}}),P=new u({props:{code:"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",highlighted:`  from diffusers import DDIMInverseScheduler, DDIMScheduler
  from diffusers.utils import load_image, make_image_grid
  from PIL import Image

  pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
  pipeline.inverse_scheduler = DDIMInverseScheduler.from_config(pipeline.scheduler.config)

  img_url = &quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;
  raw_image = load_image(img_url).resize((768, 768))

  mask_image = pipeline.generate_mask(
      image=raw_image,
<span class="hljs-deletion">-     source_prompt=source_prompt,</span>
<span class="hljs-deletion">-     target_prompt=target_prompt,</span>
<span class="hljs-addition">+     source_prompt_embeds=source_embeds,</span>
<span class="hljs-addition">+     target_prompt_embeds=target_embeds,</span>
  )

  inv_latents = pipeline.invert(
<span class="hljs-deletion">-     prompt=source_prompt,</span>
<span class="hljs-addition">+     prompt_embeds=source_embeds,</span>
      image=raw_image,
  ).latents

  output_image = pipeline(
      mask_image=mask_image,
      image_latents=inv_latents,
<span class="hljs-deletion">-     prompt=target_prompt,</span>
<span class="hljs-deletion">-     negative_prompt=source_prompt,</span>
<span class="hljs-addition">+     prompt_embeds=target_embeds,</span>
<span class="hljs-addition">+     negative_prompt_embeds=source_embeds,</span>
  ).images[0]
  mask_image = Image.fromarray((mask_image.squeeze()*255).astype(&quot;uint8&quot;), &quot;L&quot;)
  make_image_grid([raw_image, mask_image, output_image], rows=1, cols=3)`,wrap:!1}}),K=new nt({props:{title:"Generate a caption for inversion",local:"generate-a-caption-for-inversion",headingTag:"h2"}}),te=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQmxpcEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMEJsaXBQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBCbGlwUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGYmxpcC1pbWFnZS1jYXB0aW9uaW5nLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBCbGlwRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGYmxpcC1pbWFnZS1jYXB0aW9uaW5nLWJhc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BlipForConditionalGeneration, BlipProcessor

processor = BlipProcessor.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip-image-captioning-base&quot;</span>)
model = BlipForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip-image-captioning-base&quot;</span>, torch_dtype=torch.float16, low_cpu_mem_usage=<span class="hljs-literal">True</span>)`,wrap:!1}}),se=new u({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwZ2VuZXJhdGVfY2FwdGlvbihpbWFnZXMlMkMlMjBjYXB0aW9uX2dlbmVyYXRvciUyQyUyMGNhcHRpb25fcHJvY2Vzc29yKSUzQSUwQSUyMCUyMCUyMCUyMHRleHQlMjAlM0QlMjAlMjJhJTIwcGhvdG9ncmFwaCUyMG9mJTIyJTBBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwY2FwdGlvbl9wcm9jZXNzb3IoaW1hZ2VzJTJDJTIwdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBkdHlwZSUzRGNhcHRpb25fZ2VuZXJhdG9yLmR0eXBlKSUwQSUyMCUyMCUyMCUyMGNhcHRpb25fZ2VuZXJhdG9yLnRvKCUyMmN1ZGElMjIpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMGNhcHRpb25fZ2VuZXJhdG9yLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwb2ZmbG9hZCUyMGNhcHRpb24lMjBnZW5lcmF0b3IlMEElMjAlMjAlMjAlMjBjYXB0aW9uX2dlbmVyYXRvci50byglMjJjcHUlMjIpJTBBJTBBJTIwJTIwJTIwJTIwY2FwdGlvbiUyMCUzRCUyMGNhcHRpb25fcHJvY2Vzc29yLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNhcHRpb24=",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_caption</span>(<span class="hljs-params">images, caption_generator, caption_processor</span>):
    text = <span class="hljs-string">&quot;a photograph of&quot;</span>

    inputs = caption_processor(images, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=caption_generator.dtype)
    caption_generator.to(<span class="hljs-string">&quot;cuda&quot;</span>)
    outputs = caption_generator.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)

    <span class="hljs-comment"># offload caption generator</span>
    caption_generator.to(<span class="hljs-string">&quot;cpu&quot;</span>)

    caption = caption_processor.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> caption`,wrap:!1}}),ne=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGWGlhbmctY2QlMkZEaWZmRWRpdC1zdGFibGUtZGlmZnVzaW9uJTJGcmF3JTJGbWFpbiUyRmFzc2V0cyUyRm9yaWdpbi5wbmclMjIlMEFyYXdfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNzY4JTJDJTIwNzY4KSklMEFjYXB0aW9uJTIwJTNEJTIwZ2VuZXJhdGVfY2FwdGlvbihyYXdfaW1hZ2UlMkMlMjBtb2RlbCUyQyUyMHByb2Nlc3Nvcik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;</span>
raw_image = load_image(img_url).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))
caption = generate_caption(raw_image, model, processor)`,wrap:!1}}),pe=new $t({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/diffedit.md"}}),{c(){y=i("meta"),ce=a(),oe=i("p"),de=a(),m(T.$$.fragment),Me=a(),m(h.$$.fragment),Je=a(),g=i("p"),g.textContent=pt,ue=a(),U=i("ol"),U.innerHTML=ot,ye=a(),j=i("p"),j.textContent=mt,fe=a(),Z=i("p"),Z.textContent=rt,we=a(),m(I.$$.fragment),be=a(),W=i("p"),W.innerHTML=ct,Te=a(),m(_.$$.fragment),he=a(),G=i("p"),G.innerHTML=dt,ge=a(),B=i("p"),B.textContent=Mt,Ue=a(),m(X.$$.fragment),je=a(),V=i("p"),V.textContent=Jt,Ze=a(),m(C.$$.fragment),Ie=a(),R=i("p"),R.innerHTML=ut,We=a(),m(k.$$.fragment),_e=a(),v=i("p"),v.textContent=yt,Ge=a(),m(Y.$$.fragment),Be=a(),E=i("p"),E.innerHTML=ft,Xe=a(),m(H.$$.fragment),Ve=a(),f=i("div"),f.innerHTML=wt,Ce=a(),m(N.$$.fragment),Re=a(),$=i("p"),$.innerHTML=bt,ke=a(),x=i("p"),x.textContent=Tt,ve=a(),m(F.$$.fragment),Ye=a(),Q=i("p"),Q.textContent=ht,Ee=a(),m(z.$$.fragment),He=a(),S=i("p"),S.textContent=gt,Ne=a(),m(D.$$.fragment),$e=a(),w=i("blockquote"),w.innerHTML=Ut,xe=a(),A=i("p"),A.innerHTML=jt,Fe=a(),m(q.$$.fragment),Qe=a(),L=i("p"),L.innerHTML=Zt,ze=a(),m(P.$$.fragment),Se=a(),m(K.$$.fragment),De=a(),O=i("p"),O.innerHTML=It,Ae=a(),ee=i("p"),ee.textContent=Wt,qe=a(),m(te.$$.fragment),Le=a(),le=i("p"),le.textContent=_t,Pe=a(),m(se.$$.fragment),Ke=a(),ae=i("p"),ae.innerHTML=Gt,Oe=a(),m(ne.$$.fragment),et=a(),b=i("div"),b.innerHTML=Bt,tt=a(),ie=i("p"),ie.innerHTML=Xt,lt=a(),m(pe.$$.fragment),st=a(),me=i("p"),this.h()},l(e){const t=Et("svelte-u9bgzb",document.head);y=p(t,"META",{name:!0,content:!0}),t.forEach(l),ce=n(e),oe=p(e,"P",{}),Vt(oe).forEach(l),de=n(e),r(T.$$.fragment,e),Me=n(e),r(h.$$.fragment,e),Je=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-9fgb3t"&&(g.textContent=pt),ue=n(e),U=p(e,"OL",{"data-svelte-h":!0}),o(U)!=="svelte-13ofpju"&&(U.innerHTML=ot),ye=n(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-9vh5wh"&&(j.textContent=mt),fe=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-cwruts"&&(Z.textContent=rt),we=n(e),r(I.$$.fragment,e),be=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1rtgewh"&&(W.innerHTML=ct),Te=n(e),r(_.$$.fragment,e),he=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-q1naxr"&&(G.innerHTML=dt),ge=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-19i848b"&&(B.textContent=Mt),Ue=n(e),r(X.$$.fragment,e),je=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1umymvd"&&(V.textContent=Jt),Ze=n(e),r(C.$$.fragment,e),Ie=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-p1ppsn"&&(R.innerHTML=ut),We=n(e),r(k.$$.fragment,e),_e=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-58wksg"&&(v.textContent=yt),Ge=n(e),r(Y.$$.fragment,e),Be=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-949sql"&&(E.innerHTML=ft),Xe=n(e),r(H.$$.fragment,e),Ve=n(e),f=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-6s9t77"&&(f.innerHTML=wt),Ce=n(e),r(N.$$.fragment,e),Re=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-whlnrh"&&($.innerHTML=bt),ke=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1lu7pxc"&&(x.textContent=Tt),ve=n(e),r(F.$$.fragment,e),Ye=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1t1js6"&&(Q.textContent=ht),Ee=n(e),r(z.$$.fragment,e),He=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1p4c9jk"&&(S.textContent=gt),Ne=n(e),r(D.$$.fragment,e),$e=n(e),w=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-3fn58u"&&(w.innerHTML=Ut),xe=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-wrl4ww"&&(A.innerHTML=jt),Fe=n(e),r(q.$$.fragment,e),Qe=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-dltym8"&&(L.innerHTML=Zt),ze=n(e),r(P.$$.fragment,e),Se=n(e),r(K.$$.fragment,e),De=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1y9t3by"&&(O.innerHTML=It),Ae=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-13qc2l3"&&(ee.textContent=Wt),qe=n(e),r(te.$$.fragment,e),Le=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-16pyjsw"&&(le.textContent=_t),Pe=n(e),r(se.$$.fragment,e),Ke=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-3lbf1j"&&(ae.innerHTML=Gt),Oe=n(e),r(ne.$$.fragment,e),et=n(e),b=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-1jq3ee2"&&(b.innerHTML=Bt),tt=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-14bczqy"&&(ie.innerHTML=Xt),lt=n(e),r(pe.$$.fragment,e),st=n(e),me=p(e,"P",{}),Vt(me).forEach(l),this.h()},h(){re(y,"name","hf:doc:metadata"),re(y,"content",Ft),re(f,"class","flex gap-4"),re(w,"class","tip"),re(b,"class","flex justify-center")},m(e,t){Ht(document.head,y),s(e,ce,t),s(e,oe,t),s(e,de,t),c(T,e,t),s(e,Me,t),c(h,e,t),s(e,Je,t),s(e,g,t),s(e,ue,t),s(e,U,t),s(e,ye,t),s(e,j,t),s(e,fe,t),s(e,Z,t),s(e,we,t),c(I,e,t),s(e,be,t),s(e,W,t),s(e,Te,t),c(_,e,t),s(e,he,t),s(e,G,t),s(e,ge,t),s(e,B,t),s(e,Ue,t),c(X,e,t),s(e,je,t),s(e,V,t),s(e,Ze,t),c(C,e,t),s(e,Ie,t),s(e,R,t),s(e,We,t),c(k,e,t),s(e,_e,t),s(e,v,t),s(e,Ge,t),c(Y,e,t),s(e,Be,t),s(e,E,t),s(e,Xe,t),c(H,e,t),s(e,Ve,t),s(e,f,t),s(e,Ce,t),c(N,e,t),s(e,Re,t),s(e,$,t),s(e,ke,t),s(e,x,t),s(e,ve,t),c(F,e,t),s(e,Ye,t),s(e,Q,t),s(e,Ee,t),c(z,e,t),s(e,He,t),s(e,S,t),s(e,Ne,t),c(D,e,t),s(e,$e,t),s(e,w,t),s(e,xe,t),s(e,A,t),s(e,Fe,t),c(q,e,t),s(e,Qe,t),s(e,L,t),s(e,ze,t),c(P,e,t),s(e,Se,t),c(K,e,t),s(e,De,t),s(e,O,t),s(e,Ae,t),s(e,ee,t),s(e,qe,t),c(te,e,t),s(e,Le,t),s(e,le,t),s(e,Pe,t),c(se,e,t),s(e,Ke,t),s(e,ae,t),s(e,Oe,t),c(ne,e,t),s(e,et,t),s(e,b,t),s(e,tt,t),s(e,ie,t),s(e,lt,t),c(pe,e,t),s(e,st,t),s(e,me,t),at=!0},p:Rt,i(e){at||(d(T.$$.fragment,e),d(h.$$.fragment,e),d(I.$$.fragment,e),d(_.$$.fragment,e),d(X.$$.fragment,e),d(C.$$.fragment,e),d(k.$$.fragment,e),d(Y.$$.fragment,e),d(H.$$.fragment,e),d(N.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(D.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(pe.$$.fragment,e),at=!0)},o(e){M(T.$$.fragment,e),M(h.$$.fragment,e),M(I.$$.fragment,e),M(_.$$.fragment,e),M(X.$$.fragment,e),M(C.$$.fragment,e),M(k.$$.fragment,e),M(Y.$$.fragment,e),M(H.$$.fragment,e),M(N.$$.fragment,e),M(F.$$.fragment,e),M(z.$$.fragment,e),M(D.$$.fragment,e),M(q.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(pe.$$.fragment,e),at=!1},d(e){e&&(l(ce),l(oe),l(de),l(Me),l(Je),l(g),l(ue),l(U),l(ye),l(j),l(fe),l(Z),l(we),l(be),l(W),l(Te),l(he),l(G),l(ge),l(B),l(Ue),l(je),l(V),l(Ze),l(Ie),l(R),l(We),l(_e),l(v),l(Ge),l(Be),l(E),l(Xe),l(Ve),l(f),l(Ce),l(Re),l($),l(ke),l(x),l(ve),l(Ye),l(Q),l(Ee),l(He),l(S),l(Ne),l($e),l(w),l(xe),l(A),l(Fe),l(Qe),l(L),l(ze),l(Se),l(De),l(O),l(Ae),l(ee),l(qe),l(Le),l(le),l(Pe),l(Ke),l(ae),l(Oe),l(et),l(b),l(tt),l(ie),l(lt),l(st),l(me)),l(y),J(T,e),J(h,e),J(I,e),J(_,e),J(X,e),J(C,e),J(k,e),J(Y,e),J(H,e),J(N,e),J(F,e),J(z,e),J(D,e),J(q,e),J(P,e),J(K,e),J(te,e),J(se,e),J(ne,e),J(pe,e)}}}const Ft='{"title":"DiffEdit","local":"diffedit","sections":[{"title":"Generate source and target embeddings","local":"generate-source-and-target-embeddings","sections":[],"depth":2},{"title":"Generate a caption for inversion","local":"generate-a-caption-for-inversion","sections":[],"depth":2}],"depth":1}';function Qt(it){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lt extends vt{constructor(y){super(),Yt(this,y,Qt,xt,Ct,{})}}export{Lt as component};
