import{s as kt,n as Xt,o as It}from"../chunks/scheduler.888833de.js";import{S as Rt,i as Gt,e as s,s as n,c as p,h as Bt,a as r,d as l,b as i,f as vt,g as m,j as o,k as pe,l as Ht,m as a,n as c,t as u,o as d,p as h}from"../chunks/index.128ce987.js";import{C as f}from"../chunks/CodeBlock.37df032e.js";import{H as me,E as Vt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function Et(nt){let M,ce,re,ue,g,de,_,it='The <a href="https://hf.co/papers/2306.00637" rel="nofollow">Wuerstchen</a> model drastically reduces computational costs by compressing the latent space by 42x, without compromising image quality and accelerating inference. During training, Wuerstchen uses two models (VQGAN + autoencoder) to compress the latents, and then a third model (text-conditioned latent diffusion model) is conditioned on this highly compressed space to generate an image.',he,T,st="To fit the prior model into GPU memory and to speedup training, try enabling <code>gradient_accumulation_steps</code>, <code>gradient_checkpointing</code>, and <code>mixed_precision</code> respectively.",fe,J,rt='This guide explores the <a href="https://github.com/huggingface/diffusers/blob/main/examples/wuerstchen/text_to_image/train_text_to_image_prior.py" rel="nofollow">train_text_to_image_prior.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',Me,U,ot="Before running the script, make sure you install the library from source:",ye,j,be,x,pt="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",we,Z,ge,y,mt='<p>🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.</p>',_e,$,ct="Initialize an 🤗 Accelerate environment:",Te,W,Je,C,ut="To setup a default 🤗 Accelerate environment without choosing any configurations:",Ue,v,je,k,dt="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",xe,X,Ze,I,ht='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',$e,b,ft='<p>The following sections highlight parts of the training scripts that are important for understanding how to modify it, but it doesn’t cover every aspect of the <a href="https://github.com/huggingface/diffusers/blob/main/examples/wuerstchen/text_to_image/train_text_to_image_prior.py" rel="nofollow">script</a> in detail. If you’re interested in learning more, feel free to read through the scripts and let us know if you have any questions or concerns.</p>',We,R,Ce,G,Mt='The training scripts provides many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/6e68c71503682c8693cb5b06a4da4911dfd655ee/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L192" rel="nofollow"><code>parse_args()</code></a> function. It provides default values for each parameter, such as the training batch size and learning rate, but you can also set your own values in the training command if you’d like.',ve,B,yt="For example, to speedup training with mixed precision using the fp16 format, add the <code>--mixed_precision</code> parameter to the training command:",ke,H,Xe,V,bt='Most of the parameters are identical to the parameters in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so let’s dive right into the Wuerstchen training script!',Ie,E,Re,N,wt='The training script is also similar to the <a href="text2image#training-script">Text-to-image</a> training guide, but it’s been modified to support Wuerstchen. This guide focuses on the code that is unique to the Wuerstchen training script.',Ge,F,gt='The <a href="https://github.com/huggingface/diffusers/blob/6e68c71503682c8693cb5b06a4da4911dfd655ee/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L441" rel="nofollow"><code>main()</code></a> function starts by initializing the image encoder - an <a href="https://github.com/huggingface/diffusers/blob/main/examples/wuerstchen/text_to_image/modeling_efficient_net_encoder.py" rel="nofollow">EfficientNet</a> - in addition to the usual scheduler and tokenizer.',Be,Q,He,Y,_t="You’ll also load the <code>WuerstchenPrior</code> model for optimization.",Ve,A,Ee,L,Tt='Next, you’ll apply some <a href="https://github.com/huggingface/diffusers/blob/65ef7a0c5c594b4f84092e328fbdd73183613b30/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L656" rel="nofollow">transforms</a> to the images and <a href="https://github.com/huggingface/diffusers/blob/65ef7a0c5c594b4f84092e328fbdd73183613b30/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L637" rel="nofollow">tokenize</a> the captions:',Ne,S,Fe,z,Jt='Finally, the <a href="https://github.com/huggingface/diffusers/blob/65ef7a0c5c594b4f84092e328fbdd73183613b30/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L656" rel="nofollow">training loop</a> handles compressing the images to latent space with the <code>EfficientNetEncoder</code>, adding noise to the latents, and predicting the noise residual with the <code>WuerstchenPrior</code> model.',Qe,q,Ye,P,Ut='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',Ae,D,Le,K,jt="Once you’ve made all your changes or you’re okay with the default configuration, you’re ready to launch the training script! 🚀",Se,O,xt='Set the <code>DATASET_NAME</code> environment variable to the dataset name from the Hub. This guide uses the <a href="https://huggingface.co/datasets/lambdalabs/naruto-blip-captions" rel="nofollow">Naruto BLIP captions</a> dataset, but you can create and train on your own datasets as well (see the <a href="create_dataset">Create a dataset for training</a> guide).',ze,w,Zt="<p>To monitor training progress with Weights &amp; Biases, add the <code>--report_to=wandb</code> parameter to the training command. You’ll also need to add the <code>--validation_prompt</code> to the training command to keep track of results. This can be really useful for debugging the model and viewing intermediate results.</p>",qe,ee,Pe,te,$t="Once training is complete, you can use your newly trained model for inference!",De,le,Ke,ae,Oe,ne,Wt="Congratulations on training a Wuerstchen model! To learn more about how to use your new model, the following may be helpful:",et,ie,Ct='<li>Take a look at the <a href="../api/pipelines/wuerstchen#text-to-image-generation">Wuerstchen</a> API documentation to learn more about how to use the pipeline for text-to-image generation and its limitations.</li>',tt,se,lt,oe,at;return g=new me({props:{title:"Wuerstchen",local:"wuerstchen",headingTag:"h1"}}),j=new f({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),Z=new f({props:{code:"Y2QlMjBleGFtcGxlcyUyRnd1ZXJzdGNoZW4lMkZ0ZXh0X3RvX2ltYWdlJTBBcGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`<span class="hljs-built_in">cd</span> examples/wuerstchen/text_to_image
pip install -r requirements.txt`,wrap:!1}}),W=new f({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),v=new f({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),X=new f({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),R=new me({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),H=new f({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX3RleHRfdG9faW1hZ2VfcHJpb3IucHklMjAlNUMlMEElMjAlMjAtLW1peGVkX3ByZWNpc2lvbiUzRCUyMmZwMTYlMjI=",highlighted:`accelerate launch train_text_to_image_prior.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>`,wrap:!1}}),E=new me({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),Q=new f({props:{code:"d2l0aCUyMENvbnRleHRNYW5hZ2VycyhkZWVwc3BlZWRfemVyb19pbml0X2Rpc2FibGVkX2NvbnRleHRfbWFuYWdlcigpKSUzQSUwQSUyMCUyMCUyMCUyMHByZXRyYWluZWRfY2hlY2twb2ludF9maWxlJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUyMmRvbWUyNzIlMkZ3dWVyc3RjaGVuJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJtb2RlbF92Ml9zdGFnZV9iLnB0JTIyKSUwQSUyMCUyMCUyMCUyMHN0YXRlX2RpY3QlMjAlM0QlMjB0b3JjaC5sb2FkKHByZXRyYWluZWRfY2hlY2twb2ludF9maWxlJTJDJTIwbWFwX2xvY2F0aW9uJTNEJTIyY3B1JTIyKSUwQSUyMCUyMCUyMCUyMGltYWdlX2VuY29kZXIlMjAlM0QlMjBFZmZpY2llbnROZXRFbmNvZGVyKCklMEElMjAlMjAlMjAlMjBpbWFnZV9lbmNvZGVyLmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0JTVCJTIyZWZmbmV0X3N0YXRlX2RpY3QlMjIlNUQpJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW5jb2Rlci5ldmFsKCk=",highlighted:`<span class="hljs-keyword">with</span> ContextManagers(deepspeed_zero_init_disabled_context_manager()):
    pretrained_checkpoint_file = hf_hub_download(<span class="hljs-string">&quot;dome272/wuerstchen&quot;</span>, filename=<span class="hljs-string">&quot;model_v2_stage_b.pt&quot;</span>)
    state_dict = torch.load(pretrained_checkpoint_file, map_location=<span class="hljs-string">&quot;cpu&quot;</span>)
    image_encoder = EfficientNetEncoder()
    image_encoder.load_state_dict(state_dict[<span class="hljs-string">&quot;effnet_state_dict&quot;</span>])
    image_encoder.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),A=new f({props:{code:"cHJpb3IlMjAlM0QlMjBXdWVyc3RjaGVuUHJpb3IuZnJvbV9wcmV0cmFpbmVkKGFyZ3MucHJldHJhaW5lZF9wcmlvcl9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBzdWJmb2xkZXIlM0QlMjJwcmlvciUyMiklMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBvcHRpbWl6ZXJfY2xzKCUwQSUyMCUyMCUyMCUyMHByaW9yLnBhcmFtZXRlcnMoKSUyQyUwQSUyMCUyMCUyMCUyMGxyJTNEYXJncy5sZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwYmV0YXMlM0QoYXJncy5hZGFtX2JldGExJTJDJTIwYXJncy5hZGFtX2JldGEyKSUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9kZWNheSUzRGFyZ3MuYWRhbV93ZWlnaHRfZGVjYXklMkMlMEElMjAlMjAlMjAlMjBlcHMlM0RhcmdzLmFkYW1fZXBzaWxvbiUyQyUwQSk=",highlighted:`prior = WuerstchenPrior.from_pretrained(args.pretrained_prior_model_name_or_path, subfolder=<span class="hljs-string">&quot;prior&quot;</span>)

optimizer = optimizer_cls(
    prior.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),S=new f({props:{code:"ZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZS5jb252ZXJ0KCUyMlJHQiUyMiklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZXMlNUJpbWFnZV9jb2x1bW4lNUQlNUQlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMmVmZm5ldF9waXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjAlNUJlZmZuZXRfdHJhbnNmb3JtcyhpbWFnZSklMjBmb3IlMjBpbWFnZSUyMGluJTIwaW1hZ2VzJTVEJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIlMjJ0ZXh0X2lucHV0X2lkcyUyMiU1RCUyQyUyMGV4YW1wbGVzJTVCJTIydGV4dF9tYXNrJTIyJTVEJTIwJTNEJTIwdG9rZW5pemVfY2FwdGlvbnMoZXhhbXBsZXMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">examples</span>):
    images = [image.convert(<span class="hljs-string">&quot;RGB&quot;</span>) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[image_column]]
    examples[<span class="hljs-string">&quot;effnet_pixel_values&quot;</span>] = [effnet_transforms(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]
    examples[<span class="hljs-string">&quot;text_input_ids&quot;</span>], examples[<span class="hljs-string">&quot;text_mask&quot;</span>] = tokenize_captions(examples)
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),q=new f({props:{code:"cHJlZF9ub2lzZSUyMCUzRCUyMHByaW9yKG5vaXN5X2xhdGVudHMlMkMlMjB0aW1lc3RlcHMlMkMlMjBwcm9tcHRfZW1iZWRzKQ==",highlighted:"pred_noise = prior(noisy_latents, timesteps, prompt_embeds)",wrap:!1}}),D=new me({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),ee=new f({props:{code:"ZXhwb3J0JTIwREFUQVNFVF9OQU1FJTNEJTIybGFtYmRhbGFicyUyRm5hcnV0by1ibGlwLWNhcHRpb25zJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMCUyMHRyYWluX3RleHRfdG9faW1hZ2VfcHJpb3IucHklMjAlNUMlMEElMjAlMjAtLW1peGVkX3ByZWNpc2lvbiUzRCUyMmZwMTYlMjIlMjAlNUMlMEElMjAlMjAtLWRhdGFzZXRfbmFtZSUzRCUyNERBVEFTRVRfTkFNRSUyMCU1QyUwQSUyMCUyMC0tcmVzb2x1dGlvbiUzRDc2OCUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAtLWRhdGFsb2FkZXJfbnVtX3dvcmtlcnMlM0Q0JTIwJTVDJTBBJTIwJTIwLS1tYXhfdHJhaW5fc3RlcHMlM0QxNTAwMCUyMCU1QyUwQSUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUzRDFlLTA1JTIwJTVDJTBBJTIwJTIwLS1tYXhfZ3JhZF9ub3JtJTNEMSUyMCU1QyUwQSUyMCUyMC0tY2hlY2twb2ludHNfdG90YWxfbGltaXQlM0QzJTIwJTVDJTBBJTIwJTIwLS1scl9zY2hlZHVsZXIlM0QlMjJjb25zdGFudCUyMiUyMCU1QyUwQSUyMCUyMC0tbHJfd2FybXVwX3N0ZXBzJTNEMCUyMCU1QyUwQSUyMCUyMC0tdmFsaWRhdGlvbl9wcm9tcHRzJTNEJTIyQSUyMHJvYm90JTIwbmFydXRvJTJDJTIwNGslMjBwaG90byUyMiUyMCU1QyUwQSUyMCUyMC0tcmVwb3J0X3RvJTNEJTIyd2FuZGIlMjIlMjAlNUMlMEElMjAlMjAtLXB1c2hfdG9faHViJTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTNEJTIyd3VlcnN0Y2hlbi1wcmlvci1uYXJ1dG8tbW9kZWwlMjI=",highlighted:`<span class="hljs-built_in">export</span> DATASET_NAME=<span class="hljs-string">&quot;lambdalabs/naruto-blip-captions&quot;</span>

accelerate launch  train_text_to_image_prior.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> \\
  --dataset_name=<span class="hljs-variable">$DATASET_NAME</span> \\
  --resolution=768 \\
  --train_batch_size=4 \\
  --gradient_accumulation_steps=4 \\
  --gradient_checkpointing \\
  --dataloader_num_workers=4 \\
  --max_train_steps=15000 \\
  --learning_rate=1e-05 \\
  --max_grad_norm=1 \\
  --checkpoints_total_limit=3 \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> \\
  --lr_warmup_steps=0 \\
  --validation_prompts=<span class="hljs-string">&quot;A robot naruto, 4k photo&quot;</span> \\
  --report_to=<span class="hljs-string">&quot;wandb&quot;</span> \\
  --push_to_hub \\
  --output_dir=<span class="hljs-string">&quot;wuerstchen-prior-naruto-model&quot;</span>`,wrap:!1}}),le=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMucGlwZWxpbmVzLnd1ZXJzdGNoZW4lMjBpbXBvcnQlMjBERUZBVUxUX1NUQUdFX0NfVElNRVNURVBTJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZzYXZlZCUyRm1vZGVsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQWNhcHRpb24lMjAlM0QlMjAlMjJBJTIwY3V0ZSUyMGJpcmQlMjBuYXJ1dG8lMjBob2xkaW5nJTIwYSUyMHNoaWVsZCUyMiUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMGNhcHRpb24lMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxNTM2JTJDJTBBJTIwJTIwJTIwJTIwcHJpb3JfdGltZXN0ZXBzJTNEREVGQVVMVF9TVEFHRV9DX1RJTUVTVEVQUyUyQyUwQSUyMCUyMCUyMCUyMHByaW9yX2d1aWRhbmNlX3NjYWxlJTNENC4wJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMiUyQyUwQSkuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.pipelines.wuerstchen <span class="hljs-keyword">import</span> DEFAULT_STAGE_C_TIMESTEPS

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;path/to/saved/model&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

caption = <span class="hljs-string">&quot;A cute bird naruto holding a shield&quot;</span>
images = pipeline(
    caption,
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1536</span>,
    prior_timesteps=DEFAULT_STAGE_C_TIMESTEPS,
    prior_guidance_scale=<span class="hljs-number">4.0</span>,
    num_images_per_prompt=<span class="hljs-number">2</span>,
).images`,wrap:!1}}),ae=new me({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),se=new Vt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/wuerstchen.md"}}),{c(){M=s("meta"),ce=n(),re=s("p"),ue=n(),p(g.$$.fragment),de=n(),_=s("p"),_.innerHTML=it,he=n(),T=s("p"),T.innerHTML=st,fe=n(),J=s("p"),J.innerHTML=rt,Me=n(),U=s("p"),U.textContent=ot,ye=n(),p(j.$$.fragment),be=n(),x=s("p"),x.textContent=pt,we=n(),p(Z.$$.fragment),ge=n(),y=s("blockquote"),y.innerHTML=mt,_e=n(),$=s("p"),$.textContent=ct,Te=n(),p(W.$$.fragment),Je=n(),C=s("p"),C.textContent=ut,Ue=n(),p(v.$$.fragment),je=n(),k=s("p"),k.textContent=dt,xe=n(),p(X.$$.fragment),Ze=n(),I=s("p"),I.innerHTML=ht,$e=n(),b=s("blockquote"),b.innerHTML=ft,We=n(),p(R.$$.fragment),Ce=n(),G=s("p"),G.innerHTML=Mt,ve=n(),B=s("p"),B.innerHTML=yt,ke=n(),p(H.$$.fragment),Xe=n(),V=s("p"),V.innerHTML=bt,Ie=n(),p(E.$$.fragment),Re=n(),N=s("p"),N.innerHTML=wt,Ge=n(),F=s("p"),F.innerHTML=gt,Be=n(),p(Q.$$.fragment),He=n(),Y=s("p"),Y.innerHTML=_t,Ve=n(),p(A.$$.fragment),Ee=n(),L=s("p"),L.innerHTML=Tt,Ne=n(),p(S.$$.fragment),Fe=n(),z=s("p"),z.innerHTML=Jt,Qe=n(),p(q.$$.fragment),Ye=n(),P=s("p"),P.innerHTML=Ut,Ae=n(),p(D.$$.fragment),Le=n(),K=s("p"),K.textContent=jt,Se=n(),O=s("p"),O.innerHTML=xt,ze=n(),w=s("blockquote"),w.innerHTML=Zt,qe=n(),p(ee.$$.fragment),Pe=n(),te=s("p"),te.textContent=$t,De=n(),p(le.$$.fragment),Ke=n(),p(ae.$$.fragment),Oe=n(),ne=s("p"),ne.textContent=Wt,et=n(),ie=s("ul"),ie.innerHTML=Ct,tt=n(),p(se.$$.fragment),lt=n(),oe=s("p"),this.h()},l(e){const t=Bt("svelte-u9bgzb",document.head);M=r(t,"META",{name:!0,content:!0}),t.forEach(l),ce=i(e),re=r(e,"P",{}),vt(re).forEach(l),ue=i(e),m(g.$$.fragment,e),de=i(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-i7ckto"&&(_.innerHTML=it),he=i(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1ogrf3c"&&(T.innerHTML=st),fe=i(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-19e0b6t"&&(J.innerHTML=rt),Me=i(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-l7dm2q"&&(U.textContent=ot),ye=i(e),m(j.$$.fragment,e),be=i(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-z4z0b9"&&(x.textContent=pt),we=i(e),m(Z.$$.fragment,e),ge=i(e),y=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-1in84qc"&&(y.innerHTML=mt),_e=i(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-60q53m"&&($.textContent=ct),Te=i(e),m(W.$$.fragment,e),Je=i(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-di6juu"&&(C.textContent=ut),Ue=i(e),m(v.$$.fragment,e),je=i(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-tsz4qp"&&(k.textContent=dt),xe=i(e),m(X.$$.fragment,e),Ze=i(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1fkfdql"&&(I.innerHTML=ht),$e=i(e),b=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-1kgaigt"&&(b.innerHTML=ft),We=i(e),m(R.$$.fragment,e),Ce=i(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-5hssf5"&&(G.innerHTML=Mt),ve=i(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1r0bv1x"&&(B.innerHTML=yt),ke=i(e),m(H.$$.fragment,e),Xe=i(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-94nkgl"&&(V.innerHTML=bt),Ie=i(e),m(E.$$.fragment,e),Re=i(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1qezx8a"&&(N.innerHTML=wt),Ge=i(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1dwkzrk"&&(F.innerHTML=gt),Be=i(e),m(Q.$$.fragment,e),He=i(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1q4frxg"&&(Y.innerHTML=_t),Ve=i(e),m(A.$$.fragment,e),Ee=i(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-hccx6h"&&(L.innerHTML=Tt),Ne=i(e),m(S.$$.fragment,e),Fe=i(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1mgnmwn"&&(z.innerHTML=Jt),Qe=i(e),m(q.$$.fragment,e),Ye=i(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-6gmbd2"&&(P.innerHTML=Ut),Ae=i(e),m(D.$$.fragment,e),Le=i(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-9dei1q"&&(K.textContent=jt),Se=i(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-csbhgn"&&(O.innerHTML=xt),ze=i(e),w=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-rxdmtb"&&(w.innerHTML=Zt),qe=i(e),m(ee.$$.fragment,e),Pe=i(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1x6in5t"&&(te.textContent=$t),De=i(e),m(le.$$.fragment,e),Ke=i(e),m(ae.$$.fragment,e),Oe=i(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1o0am8e"&&(ne.textContent=Wt),et=i(e),ie=r(e,"UL",{"data-svelte-h":!0}),o(ie)!=="svelte-m7qkni"&&(ie.innerHTML=Ct),tt=i(e),m(se.$$.fragment,e),lt=i(e),oe=r(e,"P",{}),vt(oe).forEach(l),this.h()},h(){pe(M,"name","hf:doc:metadata"),pe(M,"content",Nt),pe(y,"class","tip"),pe(b,"class","tip"),pe(w,"class","tip")},m(e,t){Ht(document.head,M),a(e,ce,t),a(e,re,t),a(e,ue,t),c(g,e,t),a(e,de,t),a(e,_,t),a(e,he,t),a(e,T,t),a(e,fe,t),a(e,J,t),a(e,Me,t),a(e,U,t),a(e,ye,t),c(j,e,t),a(e,be,t),a(e,x,t),a(e,we,t),c(Z,e,t),a(e,ge,t),a(e,y,t),a(e,_e,t),a(e,$,t),a(e,Te,t),c(W,e,t),a(e,Je,t),a(e,C,t),a(e,Ue,t),c(v,e,t),a(e,je,t),a(e,k,t),a(e,xe,t),c(X,e,t),a(e,Ze,t),a(e,I,t),a(e,$e,t),a(e,b,t),a(e,We,t),c(R,e,t),a(e,Ce,t),a(e,G,t),a(e,ve,t),a(e,B,t),a(e,ke,t),c(H,e,t),a(e,Xe,t),a(e,V,t),a(e,Ie,t),c(E,e,t),a(e,Re,t),a(e,N,t),a(e,Ge,t),a(e,F,t),a(e,Be,t),c(Q,e,t),a(e,He,t),a(e,Y,t),a(e,Ve,t),c(A,e,t),a(e,Ee,t),a(e,L,t),a(e,Ne,t),c(S,e,t),a(e,Fe,t),a(e,z,t),a(e,Qe,t),c(q,e,t),a(e,Ye,t),a(e,P,t),a(e,Ae,t),c(D,e,t),a(e,Le,t),a(e,K,t),a(e,Se,t),a(e,O,t),a(e,ze,t),a(e,w,t),a(e,qe,t),c(ee,e,t),a(e,Pe,t),a(e,te,t),a(e,De,t),c(le,e,t),a(e,Ke,t),c(ae,e,t),a(e,Oe,t),a(e,ne,t),a(e,et,t),a(e,ie,t),a(e,tt,t),c(se,e,t),a(e,lt,t),a(e,oe,t),at=!0},p:Xt,i(e){at||(u(g.$$.fragment,e),u(j.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(v.$$.fragment,e),u(X.$$.fragment,e),u(R.$$.fragment,e),u(H.$$.fragment,e),u(E.$$.fragment,e),u(Q.$$.fragment,e),u(A.$$.fragment,e),u(S.$$.fragment,e),u(q.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),at=!0)},o(e){d(g.$$.fragment,e),d(j.$$.fragment,e),d(Z.$$.fragment,e),d(W.$$.fragment,e),d(v.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(H.$$.fragment,e),d(E.$$.fragment,e),d(Q.$$.fragment,e),d(A.$$.fragment,e),d(S.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),at=!1},d(e){e&&(l(ce),l(re),l(ue),l(de),l(_),l(he),l(T),l(fe),l(J),l(Me),l(U),l(ye),l(be),l(x),l(we),l(ge),l(y),l(_e),l($),l(Te),l(Je),l(C),l(Ue),l(je),l(k),l(xe),l(Ze),l(I),l($e),l(b),l(We),l(Ce),l(G),l(ve),l(B),l(ke),l(Xe),l(V),l(Ie),l(Re),l(N),l(Ge),l(F),l(Be),l(He),l(Y),l(Ve),l(Ee),l(L),l(Ne),l(Fe),l(z),l(Qe),l(Ye),l(P),l(Ae),l(Le),l(K),l(Se),l(O),l(ze),l(w),l(qe),l(Pe),l(te),l(De),l(Ke),l(Oe),l(ne),l(et),l(ie),l(tt),l(lt),l(oe)),l(M),h(g,e),h(j,e),h(Z,e),h(W,e),h(v,e),h(X,e),h(R,e),h(H,e),h(E,e),h(Q,e),h(A,e),h(S,e),h(q,e),h(D,e),h(ee,e),h(le,e),h(ae,e),h(se,e)}}}const Nt='{"title":"Wuerstchen","local":"wuerstchen","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Ft(nt){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends Rt{constructor(M){super(),Gt(this,M,Ft,Et,kt,{})}}export{St as component};
