import{s as Qt,n as qt,o as At}from"../chunks/scheduler.888833de.js";import{S as Dt,i as Pt,e as s,s as n,c as p,h as Kt,a as o,d as l,b as i,f as St,g as u,j as r,k as he,l as Ot,m as a,n as c,t as d,o as m,p as h}from"../chunks/index.128ce987.js";import{C as f}from"../chunks/CodeBlock.37df032e.js";import{H as fe,E as el}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function tl(ht){let y,ye,de,Me,w,be,_,ft='<a href="https://hf.co/papers/2208.01618" rel="nofollow">Textual Inversion</a> is a training technique for personalizing image generation models with just a few example images of what you want it to learn. This technique works by learning and updating the text embeddings (the new embeddings are tied to a special word you must use in the prompt) to match the example images you provide.',ge,T,yt='If you’re training on a GPU with limited vRAM, you should try enabling the <code>gradient_checkpointing</code> and <code>mixed_precision</code> parameters in the training command. You can also reduce your memory footprint by using memory-efficient attention with <a href="../optimization/xformers">xFormers</a>.',we,v,Mt='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/textual_inversion/textual_inversion.py" rel="nofollow">textual_inversion.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',_e,J,bt="Before running the script, make sure you install the library from source:",Te,U,ve,Z,gt="Navigate to the example folder with the training script and install the required dependencies for the script you’re using:",Je,x,Ue,M,wt='<p>🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.</p>',Ze,j,_t="Initialize an 🤗 Accelerate environment:",xe,$,je,X,Tt="To setup a default 🤗 Accelerate environment without choosing any configurations:",$e,k,Xe,C,vt="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",ke,R,Ce,W,Jt='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Re,b,Ut='<p>The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/textual_inversion/textual_inversion.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.</p>',We,I,Ie,G,Zt='The training script has many parameters to help you tailor the training run to your needs. All of the parameters and their descriptions are listed in the <a href="https://github.com/huggingface/diffusers/blob/839c2a5ece0af4e75530cb520d77bc7ed8acf474/examples/textual_inversion/textual_inversion.py#L176" rel="nofollow"><code>parse_args()</code></a> function. Where applicable, Diffusers provides default values for each parameter such as the training batch size and learning rate, but feel free to change these values in the training command if you’d like.',Ge,L,xt="For example, to increase the number of gradient accumulation steps above the default value of 1:",Le,F,Fe,B,jt="Some other basic and important parameters to specify include:",Be,V,$t="<li><code>--pretrained_model_name_or_path</code>: the name of the model on the Hub or a local path to the pretrained model</li> <li><code>--train_data_dir</code>: path to a folder containing the training dataset (example images)</li> <li><code>--output_dir</code>: where to save the trained model</li> <li><code>--push_to_hub</code>: whether to push the trained model to the Hub</li> <li><code>--checkpointing_steps</code>: frequency of saving a checkpoint as the model trains; this is useful if for some reason training is interrupted, you can continue training from that checkpoint by adding <code>--resume_from_checkpoint</code> to your training command</li> <li><code>--num_vectors</code>: the number of vectors to learn the embeddings with; increasing this parameter helps the model learn better but it comes with increased training costs</li> <li><code>--placeholder_token</code>: the special word to tie the learned embeddings to (you must use the word in your prompt for inference)</li> <li><code>--initializer_token</code>: a single-word that roughly describes the object or style you’re trying to train on</li> <li><code>--learnable_property</code>: whether you’re training the model to learn a new “style” (for example, Van Gogh’s painting style) or “object” (for example, your dog)</li>",Ve,Y,Ye,H,Xt='Unlike some of the other training scripts, textual_inversion.py has a custom dataset class, <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L487" rel="nofollow"><code>TextualInversionDataset</code></a> for creating a dataset. You can customize the image size, placeholder token, interpolation method, whether to crop the image, and more. If you need to change how the dataset is created, you can modify <code>TextualInversionDataset</code>.',He,N,kt='Next, you’ll find the dataset preprocessing code and training loop in the <a href="https://github.com/huggingface/diffusers/blob/839c2a5ece0af4e75530cb520d77bc7ed8acf474/examples/textual_inversion/textual_inversion.py#L573" rel="nofollow"><code>main()</code></a> function.',Ne,z,Ct='The script starts by loading the <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L616" rel="nofollow">tokenizer</a>, <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L622" rel="nofollow">scheduler and model</a>:',ze,E,Ee,S,Rt='The special <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L632" rel="nofollow">placeholder token</a> is added next to the tokenizer, and the embedding is readjusted to account for the new token.',Se,Q,Wt='Then, the script <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L716" rel="nofollow">creates a dataset</a> from the <code>TextualInversionDataset</code>:',Qe,q,qe,A,It='Finally, the <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L784" rel="nofollow">training loop</a> handles everything else from predicting the noisy residual to updating the embedding weights of the special placeholder token.',Ae,D,Gt='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',De,P,Pe,K,Lt="Once you’ve made all your changes or you’re okay with the default configuration, you’re ready to launch the training script! 🚀",Ke,O,Ft='For this guide, you’ll download some images of a <a href="https://huggingface.co/datasets/diffusers/cat_toy_example" rel="nofollow">cat toy</a> and store them in a directory. But remember, you can create and use your own dataset if you want (see the <a href="create_dataset">Create a dataset for training</a> guide).',Oe,ee,et,te,Bt="Set the environment variable <code>MODEL_NAME</code> to a model id on the Hub or a path to a local model, and <code>DATA_DIR</code>  to the path where you just downloaded the cat images to. The script creates and saves the following files to your repository:",tt,le,Vt="<li><code>learned_embeds.bin</code>: the learned embedding vectors corresponding to your example images</li> <li><code>token_identifier.txt</code>: the special placeholder token</li> <li><code>type_of_concept.txt</code>: the type of concept you’re training on (either “object” or “style”)</li>",lt,g,Yt="<p>A full training run takes ~1 hour on a single V100 GPU.</p>",at,ae,Ht="One more thing before you launch the script. If you’re interested in following along with the training process, you can periodically save generated images as training progresses. Add the following parameters to the training command:",nt,ne,it,ie,st,se,Nt="After training is complete, you can use your newly trained model for inference like:",ot,oe,rt,re,pt,pe,zt="Congratulations on training your own Textual Inversion model! 🎉 To learn more about how to use your new model, the following guides may be helpful:",ut,ue,Et='<li>Learn how to <a href="../using-diffusers/loading_adapters">load Textual Inversion embeddings</a> and also use them as negative embeddings.</li> <li>Learn how to use <a href="textual_inversion_inference">Textual Inversion</a> for inference with Stable Diffusion 1/2 and Stable Diffusion XL.</li>',ct,ce,dt,me,mt;return w=new fe({props:{title:"Textual Inversion",local:"textual-inversion",headingTag:"h1"}}),U=new f({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),x=new f({props:{code:"Y2QlMjBleGFtcGxlcyUyRnRleHR1YWxfaW52ZXJzaW9uJTBBcGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`<span class="hljs-built_in">cd</span> examples/textual_inversion
pip install -r requirements.txt`,wrap:!1}}),$=new f({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),k=new f({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),R=new f({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),I=new fe({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),F=new f({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRleHR1YWxfaW52ZXJzaW9uLnB5JTIwJTVDJTBBJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0",highlighted:`accelerate launch textual_inversion.py \\
  --gradient_accumulation_steps=4`,wrap:!1}}),Y=new fe({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),E=new f({props:{code:"JTIzJTIwTG9hZCUyMHRva2VuaXplciUwQWlmJTIwYXJncy50b2tlbml6ZXJfbmFtZSUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUyMCUzRCUyMENMSVBUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGFyZ3MudG9rZW5pemVyX25hbWUpJTBBZWxpZiUyMGFyZ3MucHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0ElMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlMjAlM0QlMjBDTElQVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChhcmdzLnByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwc3ViZm9sZGVyJTNEJTIydG9rZW5pemVyJTIyKSUwQSUwQSUyMyUyMExvYWQlMjBzY2hlZHVsZXIlMjBhbmQlMjBtb2RlbHMlMEFub2lzZV9zY2hlZHVsZXIlMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChhcmdzLnByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQXRleHRfZW5jb2RlciUyMCUzRCUyMENMSVBUZXh0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGFyZ3MucHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXIlMjIlMkMlMjByZXZpc2lvbiUzRGFyZ3MucmV2aXNpb24lMEEpJTBBdmFlJTIwJTNEJTIwQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoYXJncy5wcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMHN1YmZvbGRlciUzRCUyMnZhZSUyMiUyQyUyMHJldmlzaW9uJTNEYXJncy5yZXZpc2lvbiklMEF1bmV0JTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGFyZ3MucHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwcmV2aXNpb24lM0RhcmdzLnJldmlzaW9uJTBBKQ==",highlighted:`<span class="hljs-comment"># Load tokenizer</span>
<span class="hljs-keyword">if</span> args.tokenizer_name:
    tokenizer = CLIPTokenizer.from_pretrained(args.tokenizer_name)
<span class="hljs-keyword">elif</span> args.pretrained_model_name_or_path:
    tokenizer = CLIPTokenizer.from_pretrained(args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)

<span class="hljs-comment"># Load scheduler and models</span>
noise_scheduler = DDPMScheduler.from_pretrained(args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
text_encoder = CLIPTextModel.from_pretrained(
    args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, revision=args.revision
)
vae = AutoencoderKL.from_pretrained(args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, revision=args.revision)
unet = UNet2DConditionModel.from_pretrained(
    args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, revision=args.revision
)`,wrap:!1}}),q=new f({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMFRleHR1YWxJbnZlcnNpb25EYXRhc2V0KCUwQSUyMCUyMCUyMCUyMGRhdGFfcm9vdCUzRGFyZ3MudHJhaW5fZGF0YV9kaXIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBzaXplJTNEYXJncy5yZXNvbHV0aW9uJTJDJTBBJTIwJTIwJTIwJTIwcGxhY2Vob2xkZXJfdG9rZW4lM0QoJTIyJTIwJTIyLmpvaW4odG9rZW5pemVyLmNvbnZlcnRfaWRzX3RvX3Rva2VucyhwbGFjZWhvbGRlcl90b2tlbl9pZHMpKSklMkMlMEElMjAlMjAlMjAlMjByZXBlYXRzJTNEYXJncy5yZXBlYXRzJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5hYmxlX3Byb3BlcnR5JTNEYXJncy5sZWFybmFibGVfcHJvcGVydHklMkMlMEElMjAlMjAlMjAlMjBjZW50ZXJfY3JvcCUzRGFyZ3MuY2VudGVyX2Nyb3AlMkMlMEElMjAlMjAlMjAlMjBzZXQlM0QlMjJ0cmFpbiUyMiUyQyUwQSklMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwdG9yY2gudXRpbHMuZGF0YS5EYXRhTG9hZGVyKCUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEYXJncy50cmFpbl9iYXRjaF9zaXplJTJDJTIwc2h1ZmZsZSUzRFRydWUlMkMlMjBudW1fd29ya2VycyUzRGFyZ3MuZGF0YWxvYWRlcl9udW1fd29ya2VycyUwQSk=",highlighted:`train_dataset = TextualInversionDataset(
    data_root=args.train_data_dir,
    tokenizer=tokenizer,
    size=args.resolution,
    placeholder_token=(<span class="hljs-string">&quot; &quot;</span>.join(tokenizer.convert_ids_to_tokens(placeholder_token_ids))),
    repeats=args.repeats,
    learnable_property=args.learnable_property,
    center_crop=args.center_crop,
    <span class="hljs-built_in">set</span>=<span class="hljs-string">&quot;train&quot;</span>,
)
train_dataloader = torch.utils.data.DataLoader(
    train_dataset, batch_size=args.train_batch_size, shuffle=<span class="hljs-literal">True</span>, num_workers=args.dataloader_num_workers
)`,wrap:!1}}),P=new fe({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),ee=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBbG9jYWxfZGlyJTIwJTNEJTIwJTIyLiUyRmNhdCUyMiUwQXNuYXBzaG90X2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyRmNhdF90b3lfZXhhbXBsZSUyMiUyQyUyMGxvY2FsX2RpciUzRGxvY2FsX2RpciUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMjBpZ25vcmVfcGF0dGVybnMlM0QlMjIuZ2l0YXR0cmlidXRlcyUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

local_dir = <span class="hljs-string">&quot;./cat&quot;</span>
snapshot_download(
    <span class="hljs-string">&quot;diffusers/cat_toy_example&quot;</span>, local_dir=local_dir, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, ignore_patterns=<span class="hljs-string">&quot;.gitattributes&quot;</span>
)`,wrap:!1}}),ne=new f({props:{code:"LS12YWxpZGF0aW9uX3Byb21wdCUzRCUyMkElMjAlM0NjYXQtdG95JTNFJTIwdHJhaW4lMjIlMEEtLW51bV92YWxpZGF0aW9uX2ltYWdlcyUzRDQlMEEtLXZhbGlkYXRpb25fc3RlcHMlM0QxMDA=",highlighted:`--validation_prompt=<span class="hljs-string">&quot;A &lt;cat-toy&gt; train&quot;</span>
--num_validation_images=4
--validation_steps=100`,wrap:!1}}),ie=new f({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQWV4cG9ydCUyMERBVEFfRElSJTNEJTIyLiUyRmNhdCUyMiUwQSUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjB0ZXh0dWFsX2ludmVyc2lvbi5weSUyMCU1QyUwQSUyMCUyMC0tcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0QlMjRNT0RFTF9OQU1FJTIwJTVDJTBBJTIwJTIwLS10cmFpbl9kYXRhX2RpciUzRCUyNERBVEFfRElSJTIwJTVDJTBBJTIwJTIwLS1sZWFybmFibGVfcHJvcGVydHklM0QlMjJvYmplY3QlMjIlMjAlNUMlMEElMjAlMjAtLXBsYWNlaG9sZGVyX3Rva2VuJTNEJTIyJTNDY2F0LXRveSUzRSUyMiUyMCU1QyUwQSUyMCUyMC0taW5pdGlhbGl6ZXJfdG9rZW4lM0QlMjJ0b3klMjIlMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlNUMlMEElMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0QxJTIwJTVDJTBBJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTIwJTVDJTBBJTIwJTIwLS1tYXhfdHJhaW5fc3RlcHMlM0QzMDAwJTIwJTVDJTBBJTIwJTIwLS1sZWFybmluZ19yYXRlJTNENS4wZS0wNCUyMCU1QyUwQSUyMCUyMC0tc2NhbGVfbHIlMjAlNUMlMEElMjAlMjAtLWxyX3NjaGVkdWxlciUzRCUyMmNvbnN0YW50JTIyJTIwJTVDJTBBJTIwJTIwLS1scl93YXJtdXBfc3RlcHMlM0QwJTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTNEJTIydGV4dHVhbF9pbnZlcnNpb25fY2F0JTIyJTIwJTVDJTBBJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> DATA_DIR=<span class="hljs-string">&quot;./cat&quot;</span>

accelerate launch textual_inversion.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
  --train_data_dir=<span class="hljs-variable">$DATA_DIR</span> \\
  --learnable_property=<span class="hljs-string">&quot;object&quot;</span> \\
  --placeholder_token=<span class="hljs-string">&quot;&lt;cat-toy&gt;&quot;</span> \\
  --initializer_token=<span class="hljs-string">&quot;toy&quot;</span> \\
  --resolution=512 \\
  --train_batch_size=1 \\
  --gradient_accumulation_steps=4 \\
  --max_train_steps=3000 \\
  --learning_rate=5.0e-04 \\
  --scale_lr \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> \\
  --lr_warmup_steps=0 \\
  --output_dir=<span class="hljs-string">&quot;textual_inversion_cat&quot;</span> \\
  --push_to_hub`,wrap:!1}}),oe=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF90ZXh0dWFsX2ludmVyc2lvbiglMjJzZC1jb25jZXB0cy1saWJyYXJ5JTJGY2F0LXRveSUyMiklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkElMjAlM0NjYXQtdG95JTNFJTIwdHJhaW4lMjIlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC10cmFpbi5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)
image = pipeline(<span class="hljs-string">&quot;A &lt;cat-toy&gt; train&quot;</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-train.png&quot;</span>)`,wrap:!1}}),re=new fe({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),ce=new el({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/text_inversion.md"}}),{c(){y=s("meta"),ye=n(),de=s("p"),Me=n(),p(w.$$.fragment),be=n(),_=s("p"),_.innerHTML=ft,ge=n(),T=s("p"),T.innerHTML=yt,we=n(),v=s("p"),v.innerHTML=Mt,_e=n(),J=s("p"),J.textContent=bt,Te=n(),p(U.$$.fragment),ve=n(),Z=s("p"),Z.textContent=gt,Je=n(),p(x.$$.fragment),Ue=n(),M=s("blockquote"),M.innerHTML=wt,Ze=n(),j=s("p"),j.textContent=_t,xe=n(),p($.$$.fragment),je=n(),X=s("p"),X.textContent=Tt,$e=n(),p(k.$$.fragment),Xe=n(),C=s("p"),C.textContent=vt,ke=n(),p(R.$$.fragment),Ce=n(),W=s("p"),W.innerHTML=Jt,Re=n(),b=s("blockquote"),b.innerHTML=Ut,We=n(),p(I.$$.fragment),Ie=n(),G=s("p"),G.innerHTML=Zt,Ge=n(),L=s("p"),L.textContent=xt,Le=n(),p(F.$$.fragment),Fe=n(),B=s("p"),B.textContent=jt,Be=n(),V=s("ul"),V.innerHTML=$t,Ve=n(),p(Y.$$.fragment),Ye=n(),H=s("p"),H.innerHTML=Xt,He=n(),N=s("p"),N.innerHTML=kt,Ne=n(),z=s("p"),z.innerHTML=Ct,ze=n(),p(E.$$.fragment),Ee=n(),S=s("p"),S.innerHTML=Rt,Se=n(),Q=s("p"),Q.innerHTML=Wt,Qe=n(),p(q.$$.fragment),qe=n(),A=s("p"),A.innerHTML=It,Ae=n(),D=s("p"),D.innerHTML=Gt,De=n(),p(P.$$.fragment),Pe=n(),K=s("p"),K.textContent=Lt,Ke=n(),O=s("p"),O.innerHTML=Ft,Oe=n(),p(ee.$$.fragment),et=n(),te=s("p"),te.innerHTML=Bt,tt=n(),le=s("ul"),le.innerHTML=Vt,lt=n(),g=s("blockquote"),g.innerHTML=Yt,at=n(),ae=s("p"),ae.textContent=Ht,nt=n(),p(ne.$$.fragment),it=n(),p(ie.$$.fragment),st=n(),se=s("p"),se.textContent=Nt,ot=n(),p(oe.$$.fragment),rt=n(),p(re.$$.fragment),pt=n(),pe=s("p"),pe.textContent=zt,ut=n(),ue=s("ul"),ue.innerHTML=Et,ct=n(),p(ce.$$.fragment),dt=n(),me=s("p"),this.h()},l(e){const t=Kt("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),ye=i(e),de=o(e,"P",{}),St(de).forEach(l),Me=i(e),u(w.$$.fragment,e),be=i(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-vnm0dn"&&(_.innerHTML=ft),ge=i(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1ns9xvu"&&(T.innerHTML=yt),we=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-vv5nfp"&&(v.innerHTML=Mt),_e=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-l7dm2q"&&(J.textContent=bt),Te=i(e),u(U.$$.fragment,e),ve=i(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1nancx8"&&(Z.textContent=gt),Je=i(e),u(x.$$.fragment,e),Ue=i(e),M=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-1in84qc"&&(M.innerHTML=wt),Ze=i(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-60q53m"&&(j.textContent=_t),xe=i(e),u($.$$.fragment,e),je=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-di6juu"&&(X.textContent=Tt),$e=i(e),u(k.$$.fragment,e),Xe=i(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-tsz4qp"&&(C.textContent=vt),ke=i(e),u(R.$$.fragment,e),Ce=i(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1fkfdql"&&(W.innerHTML=Jt),Re=i(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-upgvrc"&&(b.innerHTML=Ut),We=i(e),u(I.$$.fragment,e),Ie=i(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1mhz0qu"&&(G.innerHTML=Zt),Ge=i(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-g9gzy9"&&(L.textContent=xt),Le=i(e),u(F.$$.fragment,e),Fe=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-tgclk5"&&(B.textContent=jt),Be=i(e),V=o(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-eyv1zk"&&(V.innerHTML=$t),Ve=i(e),u(Y.$$.fragment,e),Ye=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-qs703o"&&(H.innerHTML=Xt),He=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-k3h2bp"&&(N.innerHTML=kt),Ne=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-4766ss"&&(z.innerHTML=Ct),ze=i(e),u(E.$$.fragment,e),Ee=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-16cbi1f"&&(S.innerHTML=Rt),Se=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-70930c"&&(Q.innerHTML=Wt),Qe=i(e),u(q.$$.fragment,e),qe=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1mc4ymd"&&(A.innerHTML=It),Ae=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-6gmbd2"&&(D.innerHTML=Gt),De=i(e),u(P.$$.fragment,e),Pe=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-9dei1q"&&(K.textContent=Lt),Ke=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1gl7574"&&(O.innerHTML=Ft),Oe=i(e),u(ee.$$.fragment,e),et=i(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-k1bp7z"&&(te.innerHTML=Bt),tt=i(e),le=o(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-17m22mk"&&(le.innerHTML=Vt),lt=i(e),g=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-mhhy05"&&(g.innerHTML=Yt),at=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-iowxvh"&&(ae.textContent=Ht),nt=i(e),u(ne.$$.fragment,e),it=i(e),u(ie.$$.fragment,e),st=i(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1pqx2cy"&&(se.textContent=Nt),ot=i(e),u(oe.$$.fragment,e),rt=i(e),u(re.$$.fragment,e),pt=i(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-18p6tri"&&(pe.textContent=zt),ut=i(e),ue=o(e,"UL",{"data-svelte-h":!0}),r(ue)!=="svelte-gq7brs"&&(ue.innerHTML=Et),ct=i(e),u(ce.$$.fragment,e),dt=i(e),me=o(e,"P",{}),St(me).forEach(l),this.h()},h(){he(y,"name","hf:doc:metadata"),he(y,"content",ll),he(M,"class","tip"),he(b,"class","tip"),he(g,"class","warning")},m(e,t){Ot(document.head,y),a(e,ye,t),a(e,de,t),a(e,Me,t),c(w,e,t),a(e,be,t),a(e,_,t),a(e,ge,t),a(e,T,t),a(e,we,t),a(e,v,t),a(e,_e,t),a(e,J,t),a(e,Te,t),c(U,e,t),a(e,ve,t),a(e,Z,t),a(e,Je,t),c(x,e,t),a(e,Ue,t),a(e,M,t),a(e,Ze,t),a(e,j,t),a(e,xe,t),c($,e,t),a(e,je,t),a(e,X,t),a(e,$e,t),c(k,e,t),a(e,Xe,t),a(e,C,t),a(e,ke,t),c(R,e,t),a(e,Ce,t),a(e,W,t),a(e,Re,t),a(e,b,t),a(e,We,t),c(I,e,t),a(e,Ie,t),a(e,G,t),a(e,Ge,t),a(e,L,t),a(e,Le,t),c(F,e,t),a(e,Fe,t),a(e,B,t),a(e,Be,t),a(e,V,t),a(e,Ve,t),c(Y,e,t),a(e,Ye,t),a(e,H,t),a(e,He,t),a(e,N,t),a(e,Ne,t),a(e,z,t),a(e,ze,t),c(E,e,t),a(e,Ee,t),a(e,S,t),a(e,Se,t),a(e,Q,t),a(e,Qe,t),c(q,e,t),a(e,qe,t),a(e,A,t),a(e,Ae,t),a(e,D,t),a(e,De,t),c(P,e,t),a(e,Pe,t),a(e,K,t),a(e,Ke,t),a(e,O,t),a(e,Oe,t),c(ee,e,t),a(e,et,t),a(e,te,t),a(e,tt,t),a(e,le,t),a(e,lt,t),a(e,g,t),a(e,at,t),a(e,ae,t),a(e,nt,t),c(ne,e,t),a(e,it,t),c(ie,e,t),a(e,st,t),a(e,se,t),a(e,ot,t),c(oe,e,t),a(e,rt,t),c(re,e,t),a(e,pt,t),a(e,pe,t),a(e,ut,t),a(e,ue,t),a(e,ct,t),c(ce,e,t),a(e,dt,t),a(e,me,t),mt=!0},p:qt,i(e){mt||(d(w.$$.fragment,e),d(U.$$.fragment,e),d(x.$$.fragment,e),d($.$$.fragment,e),d(k.$$.fragment,e),d(R.$$.fragment,e),d(I.$$.fragment,e),d(F.$$.fragment,e),d(Y.$$.fragment,e),d(E.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),d(ee.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),mt=!0)},o(e){m(w.$$.fragment,e),m(U.$$.fragment,e),m(x.$$.fragment,e),m($.$$.fragment,e),m(k.$$.fragment,e),m(R.$$.fragment,e),m(I.$$.fragment,e),m(F.$$.fragment,e),m(Y.$$.fragment,e),m(E.$$.fragment,e),m(q.$$.fragment,e),m(P.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(ce.$$.fragment,e),mt=!1},d(e){e&&(l(ye),l(de),l(Me),l(be),l(_),l(ge),l(T),l(we),l(v),l(_e),l(J),l(Te),l(ve),l(Z),l(Je),l(Ue),l(M),l(Ze),l(j),l(xe),l(je),l(X),l($e),l(Xe),l(C),l(ke),l(Ce),l(W),l(Re),l(b),l(We),l(Ie),l(G),l(Ge),l(L),l(Le),l(Fe),l(B),l(Be),l(V),l(Ve),l(Ye),l(H),l(He),l(N),l(Ne),l(z),l(ze),l(Ee),l(S),l(Se),l(Q),l(Qe),l(qe),l(A),l(Ae),l(D),l(De),l(Pe),l(K),l(Ke),l(O),l(Oe),l(et),l(te),l(tt),l(le),l(lt),l(g),l(at),l(ae),l(nt),l(it),l(st),l(se),l(ot),l(rt),l(pt),l(pe),l(ut),l(ue),l(ct),l(dt),l(me)),l(y),h(w,e),h(U,e),h(x,e),h($,e),h(k,e),h(R,e),h(I,e),h(F,e),h(Y,e),h(E,e),h(q,e),h(P,e),h(ee,e),h(ne,e),h(ie,e),h(oe,e),h(re,e),h(ce,e)}}}const ll='{"title":"Textual Inversion","local":"textual-inversion","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function al(ht){return At(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rl extends Dt{constructor(y){super(),Pt(this,y,al,tl,Qt,{})}}export{rl as component};
