import{s as Ee,n as Ae,o as Ne}from"../chunks/scheduler.888833de.js";import{S as ze,i as Qe,e as s,s as i,c as o,h as Se,a as p,d as l,b as n,f as Le,g as d,j as r,k as ut,l as qe,m as a,n as c,t as m,o as u,p as h}from"../chunks/index.128ce987.js";import{C as f}from"../chunks/CodeBlock.37df032e.js";import{H as ht,E as De}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function Pe(me){let w,ft,ct,wt,b,Mt,y,ue='<a href="https://hf.co/papers/2302.08453" rel="nofollow">T2I-Adapter</a> is a lightweight adapter model that provides an additional conditioning input image (line art, canny, sketch, depth, pose) to better control image generation. It is similar to a ControlNet, but it is a lot smaller (~77M parameters and ~300MB file size) because its only inserts weights into the UNet instead of copying and training it.',Jt,g,he="The T2I-Adapter is only available for training with the Stable Diffusion XL (SDXL) model.",Tt,_,fe='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/t2i_adapter/train_t2i_adapter_sdxl.py" rel="nofollow">train_t2i_adapter_sdxl.py</a> training script to help you become familiar with it, and how you can adapt it for your own use-case.',bt,Z,we="Before running the script, make sure you install the library from source:",yt,U,gt,I,Me="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",_t,j,Zt,M,Je='<p>🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.</p>',Ut,G,Te="Initialize an 🤗 Accelerate environment:",It,W,jt,R,be="To setup a default 🤗 Accelerate environment without choosing any configurations:",Gt,v,Wt,$,ye="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",Rt,x,vt,C,ge='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',$t,J,_e='<p>The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/t2i_adapter/train_t2i_adapter_sdxl.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.</p>',xt,k,Ct,X,Ze='The training script provides many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/aab6de22c33cc01fb7bc81c0807d6109e2c998c9/examples/t2i_adapter/train_t2i_adapter_sdxl.py#L233" rel="nofollow"><code>parse_args()</code></a> function. It provides default values for each parameter, such as the training batch size and learning rate, but you can also set your own values in the training command if you’d like.',kt,B,Ue="For example, to activate gradient accumulation, add the <code>--gradient_accumulation_steps</code> parameter to the training command:",Xt,V,Bt,Y,Ie='Many of the basic and important parameters are described in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so this guide just focuses on the relevant T2I-Adapter parameters:',Vt,H,je='<li><code>--pretrained_vae_model_name_or_path</code>: path to a pretrained VAE; the SDXL VAE is known to suffer from numerical instability, so this parameter allows you to specify a better <a href="https://huggingface.co/madebyollin/sdxl-vae-fp16-fix" rel="nofollow">VAE</a></li> <li><code>--crops_coords_top_left_h</code> and <code>--crops_coords_top_left_w</code>: height and width coordinates to include in SDXL’s crop coordinate embeddings</li> <li><code>--conditioning_image_column</code>: the column of the conditioning images in the dataset</li> <li><code>--proportion_empty_prompts</code>: the proportion of image prompts to replace with empty strings</li>',Yt,F,Ht,L,Ge='As with the script parameters, a walkthrough of the training script is provided in the <a href="text2image#training-script">Text-to-image</a> training guide. Instead, this guide takes a look at the T2I-Adapter relevant parts of the script.',Ft,E,We='The training script begins by preparing the dataset. This includes <a href="https://github.com/huggingface/diffusers/blob/aab6de22c33cc01fb7bc81c0807d6109e2c998c9/examples/t2i_adapter/train_t2i_adapter_sdxl.py#L674" rel="nofollow">tokenizing</a> the prompt and <a href="https://github.com/huggingface/diffusers/blob/aab6de22c33cc01fb7bc81c0807d6109e2c998c9/examples/t2i_adapter/train_t2i_adapter_sdxl.py#L714" rel="nofollow">applying transforms</a> to the images and conditioning images.',Lt,A,Et,N,Re='Within the <a href="https://github.com/huggingface/diffusers/blob/aab6de22c33cc01fb7bc81c0807d6109e2c998c9/examples/t2i_adapter/train_t2i_adapter_sdxl.py#L770" rel="nofollow"><code>main()</code></a> function, the T2I-Adapter is either loaded from a pretrained adapter or it is randomly initialized:',At,z,Nt,Q,ve='The <a href="https://github.com/huggingface/diffusers/blob/aab6de22c33cc01fb7bc81c0807d6109e2c998c9/examples/t2i_adapter/train_t2i_adapter_sdxl.py#L952" rel="nofollow">optimizer</a> is initialized for the T2I-Adapter parameters:',zt,S,Qt,q,$e='Lastly, in the <a href="https://github.com/huggingface/diffusers/blob/aab6de22c33cc01fb7bc81c0807d6109e2c998c9/examples/t2i_adapter/train_t2i_adapter_sdxl.py#L1086" rel="nofollow">training loop</a>, the adapter conditioning image and the text embeddings are passed to the UNet to predict the noise residual:',St,D,qt,P,xe='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',Dt,K,Pt,O,Ce="Now you’re ready to launch the training script! 🚀",Kt,tt,ke='For this example training, you’ll use the <a href="https://huggingface.co/datasets/fusing/fill50k" rel="nofollow">fusing/fill50k</a> dataset. You can also create and use your own dataset if you want (see the <a href="https://moon-ci-docs.huggingface.co/docs/diffusers/pr_5512/en/training/create_dataset" rel="nofollow">Create a dataset for training</a> guide).',Ot,et,Xe="Set the environment variable <code>MODEL_DIR</code> to a model id on the Hub or a path to a local model and <code>OUTPUT_DIR</code> to where you want to save the model.",te,lt,Be="Download the following images to condition your training with:",ee,at,le,T,Ve="<p>To monitor training progress with Weights &amp; Biases, add the <code>--report_to=wandb</code> parameter to the training command. You’ll also need to add the <code>--validation_image</code>, <code>--validation_prompt</code>, and <code>--validation_steps</code> to the training command to keep track of results. This can be really useful for debugging the model and viewing intermediate results.</p>",ae,it,ie,nt,Ye="Once training is complete, you can use your T2I-Adapter for inference:",ne,st,se,pt,pe,rt,He="Congratulations on training a T2I-Adapter model! 🎉 To learn more:",re,ot,Fe='<li>Read the <a href="https://huggingface.co/blog/t2i-sdxl-adapters" rel="nofollow">Efficient Controllable Generation for SDXL with T2I-Adapters</a> blog post to learn more details about the experimental results from the T2I-Adapter team.</li>',oe,dt,de,mt,ce;return b=new ht({props:{title:"T2I-Adapter",local:"t2i-adapter",headingTag:"h1"}}),U=new f({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),j=new f({props:{code:"Y2QlMjBleGFtcGxlcyUyRnQyaV9hZGFwdGVyJTBBcGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`<span class="hljs-built_in">cd</span> examples/t2i_adapter
pip install -r requirements.txt`,wrap:!1}}),W=new f({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),v=new f({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),x=new f({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),k=new ht({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),V=new f({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX3QyaV9hZGFwdGVyX3NkeGwucHklMjAlNUMlMEElMjAlMjAtLS0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNENA==",highlighted:`accelerate launch train_t2i_adapter_sdxl.py \\
  ----gradient_accumulation_steps=4`,wrap:!1}}),F=new ht({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),A=new f({props:{code:"Y29uZGl0aW9uaW5nX2ltYWdlX3RyYW5zZm9ybXMlMjAlM0QlMjB0cmFuc2Zvcm1zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3Jtcy5SZXNpemUoYXJncy5yZXNvbHV0aW9uJTJDJTIwaW50ZXJwb2xhdGlvbiUzRHRyYW5zZm9ybXMuSW50ZXJwb2xhdGlvbk1vZGUuQklMSU5FQVIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3Jtcy5DZW50ZXJDcm9wKGFyZ3MucmVzb2x1dGlvbiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1zLlRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEp",highlighted:`conditioning_image_transforms = transforms.Compose(
    [
        transforms.Resize(args.resolution, interpolation=transforms.InterpolationMode.BILINEAR),
        transforms.CenterCrop(args.resolution),
        transforms.ToTensor(),
    ]
)`,wrap:!1}}),z=new f({props:{code:"aWYlMjBhcmdzLmFkYXB0ZXJfbW9kZWxfbmFtZV9vcl9wYXRoJTNBJTBBJTIwJTIwJTIwJTIwbG9nZ2VyLmluZm8oJTIyTG9hZGluZyUyMGV4aXN0aW5nJTIwYWRhcHRlciUyMHdlaWdodHMuJTIyKSUwQSUyMCUyMCUyMCUyMHQyaWFkYXB0ZXIlMjAlM0QlMjBUMklBZGFwdGVyLmZyb21fcHJldHJhaW5lZChhcmdzLmFkYXB0ZXJfbW9kZWxfbmFtZV9vcl9wYXRoKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBsb2dnZXIuaW5mbyglMjJJbml0aWFsaXppbmclMjB0MmlhZGFwdGVyJTIwd2VpZ2h0cy4lMjIpJTBBJTIwJTIwJTIwJTIwdDJpYWRhcHRlciUyMCUzRCUyMFQySUFkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5fY2hhbm5lbHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2hhbm5lbHMlM0QoMzIwJTJDJTIwNjQwJTJDJTIwMTI4MCUyQyUyMDEyODApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jlc19ibG9ja3MlM0QyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG93bnNjYWxlX2ZhY3RvciUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWRhcHRlcl90eXBlJTNEJTIyZnVsbF9hZGFwdGVyX3hsJTIyJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">if</span> args.adapter_model_name_or_path:
    logger.info(<span class="hljs-string">&quot;Loading existing adapter weights.&quot;</span>)
    t2iadapter = T2IAdapter.from_pretrained(args.adapter_model_name_or_path)
<span class="hljs-keyword">else</span>:
    logger.info(<span class="hljs-string">&quot;Initializing t2iadapter weights.&quot;</span>)
    t2iadapter = T2IAdapter(
        in_channels=<span class="hljs-number">3</span>,
        channels=(<span class="hljs-number">320</span>, <span class="hljs-number">640</span>, <span class="hljs-number">1280</span>, <span class="hljs-number">1280</span>),
        num_res_blocks=<span class="hljs-number">2</span>,
        downscale_factor=<span class="hljs-number">16</span>,
        adapter_type=<span class="hljs-string">&quot;full_adapter_xl&quot;</span>,
    )`,wrap:!1}}),S=new f({props:{code:"cGFyYW1zX3RvX29wdGltaXplJTIwJTNEJTIwdDJpYWRhcHRlci5wYXJhbWV0ZXJzKCklMEFvcHRpbWl6ZXIlMjAlM0QlMjBvcHRpbWl6ZXJfY2xhc3MoJTBBJTIwJTIwJTIwJTIwcGFyYW1zX3RvX29wdGltaXplJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0RhcmdzLmxlYXJuaW5nX3JhdGUlMkMlMEElMjAlMjAlMjAlMjBiZXRhcyUzRChhcmdzLmFkYW1fYmV0YTElMkMlMjBhcmdzLmFkYW1fYmV0YTIpJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEYXJncy5hZGFtX3dlaWdodF9kZWNheSUyQyUwQSUyMCUyMCUyMCUyMGVwcyUzRGFyZ3MuYWRhbV9lcHNpbG9uJTJDJTBBKQ==",highlighted:`params_to_optimize = t2iadapter.parameters()
optimizer = optimizer_class(
    params_to_optimize,
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),D=new f({props:{code:"dDJpYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGJhdGNoJTVCJTIyY29uZGl0aW9uaW5nX3BpeGVsX3ZhbHVlcyUyMiU1RC50byhkdHlwZSUzRHdlaWdodF9kdHlwZSklMEFkb3duX2Jsb2NrX2FkZGl0aW9uYWxfcmVzaWR1YWxzJTIwJTNEJTIwdDJpYWRhcHRlcih0MmlhZGFwdGVyX2ltYWdlKSUwQWRvd25fYmxvY2tfYWRkaXRpb25hbF9yZXNpZHVhbHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBzYW1wbGUudG8oZHR5cGUlM0R3ZWlnaHRfZHR5cGUpJTIwZm9yJTIwc2FtcGxlJTIwaW4lMjBkb3duX2Jsb2NrX2FkZGl0aW9uYWxfcmVzaWR1YWxzJTBBJTVEJTBBJTBBbW9kZWxfcHJlZCUyMCUzRCUyMHVuZXQoJTBBJTIwJTIwJTIwJTIwaW5wX25vaXN5X2xhdGVudHMlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcHMlMkMlMEElMjAlMjAlMjAlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMlM0RiYXRjaCU1QiUyMnByb21wdF9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBhZGRlZF9jb25kX2t3YXJncyUzRGJhdGNoJTVCJTIydW5ldF9hZGRlZF9jb25kaXRpb25zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZG93bl9ibG9ja19hZGRpdGlvbmFsX3Jlc2lkdWFscyUzRGRvd25fYmxvY2tfYWRkaXRpb25hbF9yZXNpZHVhbHMlMkMlMEEpLnNhbXBsZQ==",highlighted:`t2iadapter_image = batch[<span class="hljs-string">&quot;conditioning_pixel_values&quot;</span>].to(dtype=weight_dtype)
down_block_additional_residuals = t2iadapter(t2iadapter_image)
down_block_additional_residuals = [
    sample.to(dtype=weight_dtype) <span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> down_block_additional_residuals
]

model_pred = unet(
    inp_noisy_latents,
    timesteps,
    encoder_hidden_states=batch[<span class="hljs-string">&quot;prompt_ids&quot;</span>],
    added_cond_kwargs=batch[<span class="hljs-string">&quot;unet_added_conditions&quot;</span>],
    down_block_additional_residuals=down_block_additional_residuals,
).sample`,wrap:!1}}),K=new ht({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),at=new f({props:{code:"d2dldCUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNvbnRyb2xuZXRfdHJhaW5pbmclMkZjb25kaXRpb25pbmdfaW1hZ2VfMS5wbmclMEF3Z2V0JTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY29udHJvbG5ldF90cmFpbmluZyUyRmNvbmRpdGlvbmluZ19pbWFnZV8yLnBuZw==",highlighted:`wget https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/conditioning_image_1.png
wget https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_training/conditioning_image_2.png`,wrap:!1}}),it=new f({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBZXhwb3J0JTIwT1VUUFVUX0RJUiUzRCUyMnBhdGglMjB0byUyMHNhdmUlMjBtb2RlbCUyMiUwQSUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjB0cmFpbl90MmlfYWRhcHRlcl9zZHhsLnB5JTIwJTVDJTBBJTIwLS1wcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUzRCUyNE1PREVMX0RJUiUyMCU1QyUwQSUyMC0tb3V0cHV0X2RpciUzRCUyNE9VVFBVVF9ESVIlMjAlNUMlMEElMjAtLWRhdGFzZXRfbmFtZSUzRGZ1c2luZyUyRmZpbGw1MGslMjAlNUMlMEElMjAtLW1peGVkX3ByZWNpc2lvbiUzRCUyMmZwMTYlMjIlMjAlNUMlMEElMjAtLXJlc29sdXRpb24lM0QxMDI0JTIwJTVDJTBBJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtNSUyMCU1QyUwQSUyMC0tbWF4X3RyYWluX3N0ZXBzJTNEMTUwMDAlMjAlNUMlMEElMjAtLXZhbGlkYXRpb25faW1hZ2UlMjAlMjIuJTJGY29uZGl0aW9uaW5nX2ltYWdlXzEucG5nJTIyJTIwJTIyLiUyRmNvbmRpdGlvbmluZ19pbWFnZV8yLnBuZyUyMiUyMCU1QyUwQSUyMC0tdmFsaWRhdGlvbl9wcm9tcHQlMjAlMjJyZWQlMjBjaXJjbGUlMjB3aXRoJTIwYmx1ZSUyMGJhY2tncm91bmQlMjIlMjAlMjJjeWFuJTIwY2lyY2xlJTIwd2l0aCUyMGJyb3duJTIwZmxvcmFsJTIwYmFja2dyb3VuZCUyMiUyMCU1QyUwQSUyMC0tdmFsaWRhdGlvbl9zdGVwcyUzRDEwMCUyMCU1QyUwQSUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAtLXJlcG9ydF90byUzRCUyMndhbmRiJTIyJTIwJTVDJTBBJTIwLS1zZWVkJTNENDIlMjAlNUMlMEElMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path to save model&quot;</span>

accelerate launch train_t2i_adapter_sdxl.py \\
 --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_DIR</span> \\
 --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
 --dataset_name=fusing/fill50k \\
 --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> \\
 --resolution=1024 \\
 --learning_rate=1e-5 \\
 --max_train_steps=15000 \\
 --validation_image <span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span> <span class="hljs-string">&quot;./conditioning_image_2.png&quot;</span> \\
 --validation_prompt <span class="hljs-string">&quot;red circle with blue background&quot;</span> <span class="hljs-string">&quot;cyan circle with brown floral background&quot;</span> \\
 --validation_steps=100 \\
 --train_batch_size=1 \\
 --gradient_accumulation_steps=4 \\
 --report_to=<span class="hljs-string">&quot;wandb&quot;</span> \\
 --seed=42 \\
 --push_to_hub`,wrap:!1}}),st=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMQWRhcHRlclBpcGVsaW5lJTJDJTIwVDJJQWRhcHRlciUyQyUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXJUZXN0JTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBUMklBZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZhZGFwdGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExBZGFwdGVyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMGFkYXB0ZXIlM0RhZGFwdGVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXJUZXN0LmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyLiUyRmNvbmRpdGlvbmluZ19pbWFnZV8xLnBuZyUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJwYWxlJTIwZ29sZGVuJTIwcm9kJTIwY2lyY2xlJTIwd2l0aCUyMG9sZCUyMGxhY2UlMjBiYWNrZ3JvdW5kJTIyJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMCklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMGltYWdlJTNEY29udHJvbF9pbWFnZSUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyLiUyRm91dHB1dC5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLAdapterPipeline, T2IAdapter, EulerAncestralDiscreteSchedulerTest
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

adapter = T2IAdapter.from_pretrained(<span class="hljs-string">&quot;path/to/adapter&quot;</span>, torch_dtype=torch.float16)
pipeline = StableDiffusionXLAdapterPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, adapter=adapter, torch_dtype=torch.float16
)

pipeline.scheduler = EulerAncestralDiscreteSchedulerTest.from_config(pipe.scheduler.config)
pipeline.enable_xformers_memory_efficient_attention()
pipeline.enable_model_cpu_offload()

control_image = load_image(<span class="hljs-string">&quot;./conditioning_image_1.png&quot;</span>)
prompt = <span class="hljs-string">&quot;pale golden rod circle with old lace background&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipeline(
    prompt, image=control_image, generator=generator
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;./output.png&quot;</span>)`,wrap:!1}}),pt=new ht({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),dt=new De({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/t2i_adapters.md"}}),{c(){w=s("meta"),ft=i(),ct=s("p"),wt=i(),o(b.$$.fragment),Mt=i(),y=s("p"),y.innerHTML=ue,Jt=i(),g=s("p"),g.textContent=he,Tt=i(),_=s("p"),_.innerHTML=fe,bt=i(),Z=s("p"),Z.textContent=we,yt=i(),o(U.$$.fragment),gt=i(),I=s("p"),I.textContent=Me,_t=i(),o(j.$$.fragment),Zt=i(),M=s("blockquote"),M.innerHTML=Je,Ut=i(),G=s("p"),G.textContent=Te,It=i(),o(W.$$.fragment),jt=i(),R=s("p"),R.textContent=be,Gt=i(),o(v.$$.fragment),Wt=i(),$=s("p"),$.textContent=ye,Rt=i(),o(x.$$.fragment),vt=i(),C=s("p"),C.innerHTML=ge,$t=i(),J=s("blockquote"),J.innerHTML=_e,xt=i(),o(k.$$.fragment),Ct=i(),X=s("p"),X.innerHTML=Ze,kt=i(),B=s("p"),B.innerHTML=Ue,Xt=i(),o(V.$$.fragment),Bt=i(),Y=s("p"),Y.innerHTML=Ie,Vt=i(),H=s("ul"),H.innerHTML=je,Yt=i(),o(F.$$.fragment),Ht=i(),L=s("p"),L.innerHTML=Ge,Ft=i(),E=s("p"),E.innerHTML=We,Lt=i(),o(A.$$.fragment),Et=i(),N=s("p"),N.innerHTML=Re,At=i(),o(z.$$.fragment),Nt=i(),Q=s("p"),Q.innerHTML=ve,zt=i(),o(S.$$.fragment),Qt=i(),q=s("p"),q.innerHTML=$e,St=i(),o(D.$$.fragment),qt=i(),P=s("p"),P.innerHTML=xe,Dt=i(),o(K.$$.fragment),Pt=i(),O=s("p"),O.textContent=Ce,Kt=i(),tt=s("p"),tt.innerHTML=ke,Ot=i(),et=s("p"),et.innerHTML=Xe,te=i(),lt=s("p"),lt.textContent=Be,ee=i(),o(at.$$.fragment),le=i(),T=s("blockquote"),T.innerHTML=Ve,ae=i(),o(it.$$.fragment),ie=i(),nt=s("p"),nt.textContent=Ye,ne=i(),o(st.$$.fragment),se=i(),o(pt.$$.fragment),pe=i(),rt=s("p"),rt.textContent=He,re=i(),ot=s("ul"),ot.innerHTML=Fe,oe=i(),o(dt.$$.fragment),de=i(),mt=s("p"),this.h()},l(t){const e=Se("svelte-u9bgzb",document.head);w=p(e,"META",{name:!0,content:!0}),e.forEach(l),ft=n(t),ct=p(t,"P",{}),Le(ct).forEach(l),wt=n(t),d(b.$$.fragment,t),Mt=n(t),y=p(t,"P",{"data-svelte-h":!0}),r(y)!=="svelte-141hs7v"&&(y.innerHTML=ue),Jt=n(t),g=p(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-q7pibo"&&(g.textContent=he),Tt=n(t),_=p(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1smklx4"&&(_.innerHTML=fe),bt=n(t),Z=p(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-l7dm2q"&&(Z.textContent=we),yt=n(t),d(U.$$.fragment,t),gt=n(t),I=p(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-z4z0b9"&&(I.textContent=Me),_t=n(t),d(j.$$.fragment,t),Zt=n(t),M=p(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-1in84qc"&&(M.innerHTML=Je),Ut=n(t),G=p(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-60q53m"&&(G.textContent=Te),It=n(t),d(W.$$.fragment,t),jt=n(t),R=p(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-di6juu"&&(R.textContent=be),Gt=n(t),d(v.$$.fragment,t),Wt=n(t),$=p(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-tsz4qp"&&($.textContent=ye),Rt=n(t),d(x.$$.fragment,t),vt=n(t),C=p(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1fkfdql"&&(C.innerHTML=ge),$t=n(t),J=p(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-huyypd"&&(J.innerHTML=_e),xt=n(t),d(k.$$.fragment,t),Ct=n(t),X=p(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1sjljcs"&&(X.innerHTML=Ze),kt=n(t),B=p(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-b2fqcf"&&(B.innerHTML=Ue),Xt=n(t),d(V.$$.fragment,t),Bt=n(t),Y=p(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-oc0282"&&(Y.innerHTML=Ie),Vt=n(t),H=p(t,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-1crwgei"&&(H.innerHTML=je),Yt=n(t),d(F.$$.fragment,t),Ht=n(t),L=p(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1qht5q7"&&(L.innerHTML=Ge),Ft=n(t),E=p(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-nmesa9"&&(E.innerHTML=We),Lt=n(t),d(A.$$.fragment,t),Et=n(t),N=p(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-orrg4q"&&(N.innerHTML=Re),At=n(t),d(z.$$.fragment,t),Nt=n(t),Q=p(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-e46yue"&&(Q.innerHTML=ve),zt=n(t),d(S.$$.fragment,t),Qt=n(t),q=p(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-engbqm"&&(q.innerHTML=$e),St=n(t),d(D.$$.fragment,t),qt=n(t),P=p(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-6gmbd2"&&(P.innerHTML=xe),Dt=n(t),d(K.$$.fragment,t),Pt=n(t),O=p(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-rsq2yy"&&(O.textContent=Ce),Kt=n(t),tt=p(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-178wjhm"&&(tt.innerHTML=ke),Ot=n(t),et=p(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-10uo8vi"&&(et.innerHTML=Xe),te=n(t),lt=p(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1uo0m2d"&&(lt.textContent=Be),ee=n(t),d(at.$$.fragment,t),le=n(t),T=p(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1kkzrge"&&(T.innerHTML=Ve),ae=n(t),d(it.$$.fragment,t),ie=n(t),nt=p(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-sa6wu"&&(nt.textContent=Ye),ne=n(t),d(st.$$.fragment,t),se=n(t),d(pt.$$.fragment,t),pe=n(t),rt=p(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-t88jw7"&&(rt.textContent=He),re=n(t),ot=p(t,"UL",{"data-svelte-h":!0}),r(ot)!=="svelte-1jui77"&&(ot.innerHTML=Fe),oe=n(t),d(dt.$$.fragment,t),de=n(t),mt=p(t,"P",{}),Le(mt).forEach(l),this.h()},h(){ut(w,"name","hf:doc:metadata"),ut(w,"content",Ke),ut(M,"class","tip"),ut(J,"class","tip"),ut(T,"class","tip")},m(t,e){qe(document.head,w),a(t,ft,e),a(t,ct,e),a(t,wt,e),c(b,t,e),a(t,Mt,e),a(t,y,e),a(t,Jt,e),a(t,g,e),a(t,Tt,e),a(t,_,e),a(t,bt,e),a(t,Z,e),a(t,yt,e),c(U,t,e),a(t,gt,e),a(t,I,e),a(t,_t,e),c(j,t,e),a(t,Zt,e),a(t,M,e),a(t,Ut,e),a(t,G,e),a(t,It,e),c(W,t,e),a(t,jt,e),a(t,R,e),a(t,Gt,e),c(v,t,e),a(t,Wt,e),a(t,$,e),a(t,Rt,e),c(x,t,e),a(t,vt,e),a(t,C,e),a(t,$t,e),a(t,J,e),a(t,xt,e),c(k,t,e),a(t,Ct,e),a(t,X,e),a(t,kt,e),a(t,B,e),a(t,Xt,e),c(V,t,e),a(t,Bt,e),a(t,Y,e),a(t,Vt,e),a(t,H,e),a(t,Yt,e),c(F,t,e),a(t,Ht,e),a(t,L,e),a(t,Ft,e),a(t,E,e),a(t,Lt,e),c(A,t,e),a(t,Et,e),a(t,N,e),a(t,At,e),c(z,t,e),a(t,Nt,e),a(t,Q,e),a(t,zt,e),c(S,t,e),a(t,Qt,e),a(t,q,e),a(t,St,e),c(D,t,e),a(t,qt,e),a(t,P,e),a(t,Dt,e),c(K,t,e),a(t,Pt,e),a(t,O,e),a(t,Kt,e),a(t,tt,e),a(t,Ot,e),a(t,et,e),a(t,te,e),a(t,lt,e),a(t,ee,e),c(at,t,e),a(t,le,e),a(t,T,e),a(t,ae,e),c(it,t,e),a(t,ie,e),a(t,nt,e),a(t,ne,e),c(st,t,e),a(t,se,e),c(pt,t,e),a(t,pe,e),a(t,rt,e),a(t,re,e),a(t,ot,e),a(t,oe,e),c(dt,t,e),a(t,de,e),a(t,mt,e),ce=!0},p:Ae,i(t){ce||(m(b.$$.fragment,t),m(U.$$.fragment,t),m(j.$$.fragment,t),m(W.$$.fragment,t),m(v.$$.fragment,t),m(x.$$.fragment,t),m(k.$$.fragment,t),m(V.$$.fragment,t),m(F.$$.fragment,t),m(A.$$.fragment,t),m(z.$$.fragment,t),m(S.$$.fragment,t),m(D.$$.fragment,t),m(K.$$.fragment,t),m(at.$$.fragment,t),m(it.$$.fragment,t),m(st.$$.fragment,t),m(pt.$$.fragment,t),m(dt.$$.fragment,t),ce=!0)},o(t){u(b.$$.fragment,t),u(U.$$.fragment,t),u(j.$$.fragment,t),u(W.$$.fragment,t),u(v.$$.fragment,t),u(x.$$.fragment,t),u(k.$$.fragment,t),u(V.$$.fragment,t),u(F.$$.fragment,t),u(A.$$.fragment,t),u(z.$$.fragment,t),u(S.$$.fragment,t),u(D.$$.fragment,t),u(K.$$.fragment,t),u(at.$$.fragment,t),u(it.$$.fragment,t),u(st.$$.fragment,t),u(pt.$$.fragment,t),u(dt.$$.fragment,t),ce=!1},d(t){t&&(l(ft),l(ct),l(wt),l(Mt),l(y),l(Jt),l(g),l(Tt),l(_),l(bt),l(Z),l(yt),l(gt),l(I),l(_t),l(Zt),l(M),l(Ut),l(G),l(It),l(jt),l(R),l(Gt),l(Wt),l($),l(Rt),l(vt),l(C),l($t),l(J),l(xt),l(Ct),l(X),l(kt),l(B),l(Xt),l(Bt),l(Y),l(Vt),l(H),l(Yt),l(Ht),l(L),l(Ft),l(E),l(Lt),l(Et),l(N),l(At),l(Nt),l(Q),l(zt),l(Qt),l(q),l(St),l(qt),l(P),l(Dt),l(Pt),l(O),l(Kt),l(tt),l(Ot),l(et),l(te),l(lt),l(ee),l(le),l(T),l(ae),l(ie),l(nt),l(ne),l(se),l(pe),l(rt),l(re),l(ot),l(oe),l(de),l(mt)),l(w),h(b,t),h(U,t),h(j,t),h(W,t),h(v,t),h(x,t),h(k,t),h(V,t),h(F,t),h(A,t),h(z,t),h(S,t),h(D,t),h(K,t),h(at,t),h(it,t),h(st,t),h(pt,t),h(dt,t)}}}const Ke='{"title":"T2I-Adapter","local":"t2i-adapter","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Oe(me){return Ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends ze{constructor(w){super(),Qe(this,w,Oe,Pe,Ee,{})}}export{il as component};
