import{s as nl,n as rl,o as ol}from"../chunks/scheduler.888833de.js";import{S as pl,i as cl,e as n,s,c as p,h as dl,a as r,d as l,b as i,f as il,g as c,j as o,k as jt,l as ml,m as a,n as d,t as m,o as f,p as u}from"../chunks/index.128ce987.js";import{C as M}from"../chunks/CodeBlock.37df032e.js";import{H as we,E as fl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function ul(Ct){let h,Je,be,Ue,b,ge,T,Zt='<a href="https://hf.co/papers/2310.04378" rel="nofollow">Latent Consistency Models (LCMs)</a> are able to generate high-quality images in just a few steps, representing a big leap forward because many pipelines require at least 25+ steps. LCMs are produced by applying the latent consistency distillation method to any Stable Diffusion model. This method works by applying <em>one-stage guided distillation</em> to the latent space, and incorporating a <em>skipping-step</em> method to consistently skip timesteps to accelerate the distillation process (refer to section 4.1, 4.2, and 4.3 of the paper for more details).',_e,J,It='If you’re training on a GPU with limited vRAM, try enabling <code>gradient_checkpointing</code>, <code>gradient_accumulation_steps</code>, and <code>mixed_precision</code> to reduce memory-usage and speedup training. You can reduce your memory-usage even more by enabling memory-efficient attention with <a href="../optimization/xformers">xFormers</a> and <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes’</a> 8-bit optimizer.',je,U,$t='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sd_wds.py" rel="nofollow">train_lcm_distill_sd_wds.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',Ce,g,Wt="Before running the script, make sure you install the library from source:",Ze,_,Ie,j,Rt="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",$e,C,We,y,xt='<p>🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.</p>',Re,Z,Xt="Initialize an 🤗 Accelerate environment (try enabling <code>torch.compile</code> to significantly speedup training):",xe,I,Xe,$,vt="To setup a default 🤗 Accelerate environment without choosing any configurations:",ve,W,Ge,R,Gt="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",Ne,x,ke,X,Nt='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Le,v,Ve,w,kt='<p>The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sd_wds.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.</p>',Be,G,Lt='The training script provides many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L419" rel="nofollow"><code>parse_args()</code></a> function. This function provides default values for each parameter, such as the training batch size and learning rate, but you can also set your own values in the training command if you’d like.',He,N,Vt="For example, to speedup training with mixed precision using the fp16 format, add the <code>--mixed_precision</code> parameter to the training command:",Qe,k,Fe,L,Bt='Most of the parameters are identical to the parameters in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so you’ll focus on the parameters that are relevant to latent consistency distillation in this guide.',Ye,V,Ht='<li><code>--pretrained_teacher_model</code>: the path to a pretrained latent diffusion model to use as the teacher model</li> <li><code>--pretrained_vae_model_name_or_path</code>: path to a pretrained VAE; the SDXL VAE is known to suffer from numerical instability, so this parameter allows you to specify an alternative VAE (like this <a href="(https://huggingface.co/madebyollin/sdxl-vae-fp16-fix)">VAE</a> by madebyollin which works in fp16)</li> <li><code>--w_min</code> and <code>--w_max</code>: the minimum and maximum guidance scale values for guidance scale sampling</li> <li><code>--num_ddim_timesteps</code>: the number of timesteps for DDIM sampling</li> <li><code>--loss_type</code>: the type of loss (L2 or Huber) to calculate for latent consistency distillation; Huber loss is generally preferred because it’s more robust to outliers</li> <li><code>--huber_c</code>: the Huber loss parameter</li>',Se,B,Ee,H,Qt='The training script starts by creating a dataset class - <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L141" rel="nofollow"><code>Text2ImageDataset</code></a> - for preprocessing the images and creating a training dataset.',ze,Q,Ae,F,Ft='For improved performance on reading and writing large datasets stored in the cloud, this script uses the <a href="https://github.com/webdataset/webdataset" rel="nofollow">WebDataset</a> format to create a preprocessing pipeline to apply transforms and create a dataset and dataloader for training. Images are processed and fed to the training loop without having to download the full dataset first.',De,Y,qe,S,Yt='In the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L768" rel="nofollow"><code>main()</code></a> function, all the necessary components like the noise scheduler, tokenizers, text encoders, and VAE are loaded. The teacher UNet is also loaded here and then you can create a student UNet from the teacher UNet. The student UNet is updated by the optimizer during training.',Pe,E,Ke,z,St='Now you can create the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L979" rel="nofollow">optimizer</a> to update the UNet parameters:',Oe,A,et,D,Et='Create the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L994" rel="nofollow">dataset</a>:',tt,q,lt,P,zt='Next, you’re ready to setup the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1049" rel="nofollow">training loop</a> and implement the latent consistency distillation method (see Algorithm 1 in the paper for more details). This section of the script takes care of adding noise to the latents, sampling and creating a guidance scale embedding, and predicting the original image from the noise.',at,K,st,O,At='It gets the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1172" rel="nofollow">teacher model predictions</a> and the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1209" rel="nofollow">LCM predictions</a> next, calculates the loss, and then backpropagates it to the LCM.',it,ee,nt,te,Dt='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers tutorial</a> which breaks down the basic pattern of the denoising process.',rt,le,ot,ae,qt="Now you’re ready to launch the training script and start distilling!",pt,se,Pt='For this guide, you’ll use the <code>--train_shards_path_or_url</code> to specify the path to the <a href="https://github.com/google-research-datasets/conceptual-12m" rel="nofollow">Conceptual Captions 12M</a> dataset stored on the Hub <a href="https://huggingface.co/datasets/laion/conceptual-captions-12m-webdataset" rel="nofollow">here</a>. Set the <code>MODEL_DIR</code> environment variable to the name of the teacher model and <code>OUTPUT_DIR</code> to where you want to save the model.',ct,ie,dt,ne,Kt="Once training is complete, you can use your new LCM for inference.",mt,re,ft,oe,ut,pe,Ot='LoRA is a training technique for significantly reducing the number of trainable parameters. As a result, training is faster and it is easier to store the resulting weights because they are a lot smaller (~100MBs). Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_lora_sd_wds.py" rel="nofollow">train_lcm_distill_lora_sd_wds.py</a> or <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_lora_sdxl_wds.py" rel="nofollow">train_lcm_distill_lora_sdxl.wds.py</a> script to train with LoRA.',Mt,ce,el='The LoRA training script is discussed in more detail in the <a href="lora">LoRA training</a> guide.',ht,de,yt,me,tl='Stable Diffusion XL (SDXL) is a powerful text-to-image model that generates high-resolution images, and it adds a second text-encoder to its architecture. Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sdxl_wds.py" rel="nofollow">train_lcm_distill_sdxl_wds.py</a> script to train a SDXL model with LoRA.',wt,fe,ll='The SDXL training script is discussed in more detail in the <a href="sdxl">SDXL training</a> guide.',bt,ue,Tt,Me,al="Congratulations on distilling a LCM model! To learn more about LCM, the following may be helpful:",Jt,he,sl='<li>Learn how to use <a href="../using-diffusers/lcm">LCMs for inference</a> for text-to-image, image-to-image, and with LoRA checkpoints.</li> <li>Read the <a href="https://huggingface.co/blog/lcm_lora" rel="nofollow">SDXL in 4 steps with Latent Consistency LoRAs</a> blog post to learn more about SDXL LCM-LoRA’s for super fast inference, quality comparisons, benchmarks, and more.</li>',Ut,ye,gt,Te,_t;return b=new we({props:{title:"Latent Consistency Distillation",local:"latent-consistency-distillation",headingTag:"h1"}}),_=new M({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),C=new M({props:{code:"Y2QlMjBleGFtcGxlcyUyRmNvbnNpc3RlbmN5X2Rpc3RpbGxhdGlvbiUwQXBpcCUyMGluc3RhbGwlMjAtciUyMHJlcXVpcmVtZW50cy50eHQ=",highlighted:`<span class="hljs-built_in">cd</span> examples/consistency_distillation
pip install -r requirements.txt`,wrap:!1}}),I=new M({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),W=new M({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),x=new M({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),v=new we({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),k=new M({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2xjbV9kaXN0aWxsX3NkX3dkcy5weSUyMCU1QyUwQSUyMCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMg==",highlighted:`accelerate launch train_lcm_distill_sd_wds.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>`,wrap:!1}}),B=new we({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),Q=new M({props:{code:"ZGVmJTIwdHJhbnNmb3JtKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLnJlc2l6ZShpbWFnZSUyQyUyMHJlc29sdXRpb24lMkMlMjBpbnRlcnBvbGF0aW9uJTNEdHJhbnNmb3Jtcy5JbnRlcnBvbGF0aW9uTW9kZS5CSUxJTkVBUiklMEElMEElMjAlMjAlMjAlMjBjX3RvcCUyQyUyMGNfbGVmdCUyQyUyMF8lMkMlMjBfJTIwJTNEJTIwdHJhbnNmb3Jtcy5SYW5kb21Dcm9wLmdldF9wYXJhbXMoaW1hZ2UlMkMlMjBvdXRwdXRfc2l6ZSUzRChyZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbikpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBURi5jcm9wKGltYWdlJTJDJTIwY190b3AlMkMlMjBjX2xlZnQlMkMlMjByZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbiklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLnRvX3RlbnNvcihpbWFnZSklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLm5vcm1hbGl6ZShpbWFnZSUyQyUyMCU1QjAuNSU1RCUyQyUyMCU1QjAuNSU1RCklMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMjAlM0QlMjBpbWFnZSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">example</span>):
    image = example[<span class="hljs-string">&quot;image&quot;</span>]
    image = TF.resize(image, resolution, interpolation=transforms.InterpolationMode.BILINEAR)

    c_top, c_left, _, _ = transforms.RandomCrop.get_params(image, output_size=(resolution, resolution))
    image = TF.crop(image, c_top, c_left, resolution, resolution)
    image = TF.to_tensor(image)
    image = TF.normalize(image, [<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>])

    example[<span class="hljs-string">&quot;image&quot;</span>] = image
    <span class="hljs-keyword">return</span> example`,wrap:!1}}),Y=new M({props:{code:"cHJvY2Vzc2luZ19waXBlbGluZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMHdkcy5kZWNvZGUoJTIycGlsJTIyJTJDJTIwaGFuZGxlciUzRHdkcy5pZ25vcmVfYW5kX2NvbnRpbnVlKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy5yZW5hbWUoaW1hZ2UlM0QlMjJqcGclM0JwbmclM0JqcGVnJTNCd2VicCUyMiUyQyUyMHRleHQlM0QlMjJ0ZXh0JTNCdHh0JTNCY2FwdGlvbiUyMiUyQyUyMGhhbmRsZXIlM0R3ZHMud2Fybl9hbmRfY29udGludWUpJTJDJTBBJTIwJTIwJTIwJTIwd2RzLm1hcChmaWx0ZXJfa2V5cyglN0IlMjJpbWFnZSUyMiUyQyUyMCUyMnRleHQlMjIlN0QpKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy5tYXAodHJhbnNmb3JtKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy50b190dXBsZSglMjJpbWFnZSUyMiUyQyUyMCUyMnRleHQlMjIpJTJDJTBBJTVE",highlighted:`processing_pipeline = [
    wds.decode(<span class="hljs-string">&quot;pil&quot;</span>, handler=wds.ignore_and_continue),
    wds.rename(image=<span class="hljs-string">&quot;jpg;png;jpeg;webp&quot;</span>, text=<span class="hljs-string">&quot;text;txt;caption&quot;</span>, handler=wds.warn_and_continue),
    wds.<span class="hljs-built_in">map</span>(filter_keys({<span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>})),
    wds.<span class="hljs-built_in">map</span>(transform),
    wds.to_tuple(<span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>),
]`,wrap:!1}}),E=new M({props:{code:"dGVhY2hlcl91bmV0JTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGFyZ3MucHJldHJhaW5lZF90ZWFjaGVyX21vZGVsJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUyMHJldmlzaW9uJTNEYXJncy50ZWFjaGVyX3JldmlzaW9uJTBBKSUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCgqKnRlYWNoZXJfdW5ldC5jb25maWcpJTBBdW5ldC5sb2FkX3N0YXRlX2RpY3QodGVhY2hlcl91bmV0LnN0YXRlX2RpY3QoKSUyQyUyMHN0cmljdCUzREZhbHNlKSUwQXVuZXQudHJhaW4oKQ==",highlighted:`teacher_unet = UNet2DConditionModel.from_pretrained(
    args.pretrained_teacher_model, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, revision=args.teacher_revision
)

unet = UNet2DConditionModel(**teacher_unet.config)
unet.load_state_dict(teacher_unet.state_dict(), strict=<span class="hljs-literal">False</span>)
unet.train()`,wrap:!1}}),A=new M({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwb3B0aW1pemVyX2NsYXNzKCUwQSUyMCUyMCUyMCUyMHVuZXQucGFyYW1ldGVycygpJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0RhcmdzLmxlYXJuaW5nX3JhdGUlMkMlMEElMjAlMjAlMjAlMjBiZXRhcyUzRChhcmdzLmFkYW1fYmV0YTElMkMlMjBhcmdzLmFkYW1fYmV0YTIpJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEYXJncy5hZGFtX3dlaWdodF9kZWNheSUyQyUwQSUyMCUyMCUyMCUyMGVwcyUzRGFyZ3MuYWRhbV9lcHNpbG9uJTJDJTBBKQ==",highlighted:`optimizer = optimizer_class(
    unet.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),q=new M({props:{code:"ZGF0YXNldCUyMCUzRCUyMFRleHQySW1hZ2VEYXRhc2V0KCUwQSUyMCUyMCUyMCUyMHRyYWluX3NoYXJkc19wYXRoX29yX3VybCUzRGFyZ3MudHJhaW5fc2hhcmRzX3BhdGhfb3JfdXJsJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2V4YW1wbGVzJTNEYXJncy5tYXhfdHJhaW5fc2FtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHBlcl9ncHVfYmF0Y2hfc2l6ZSUzRGFyZ3MudHJhaW5fYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGdsb2JhbF9iYXRjaF9zaXplJTNEYXJncy50cmFpbl9iYXRjaF9zaXplJTIwKiUyMGFjY2VsZXJhdG9yLm51bV9wcm9jZXNzZXMlMkMlMEElMjAlMjAlMjAlMjBudW1fd29ya2VycyUzRGFyZ3MuZGF0YWxvYWRlcl9udW1fd29ya2VycyUyQyUwQSUyMCUyMCUyMCUyMHJlc29sdXRpb24lM0RhcmdzLnJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlX2J1ZmZlcl9zaXplJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMHBpbl9tZW1vcnklM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGVyc2lzdGVudF93b3JrZXJzJTNEVHJ1ZSUyQyUwQSklMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwZGF0YXNldC50cmFpbl9kYXRhbG9hZGVy",highlighted:`dataset = Text2ImageDataset(
    train_shards_path_or_url=args.train_shards_path_or_url,
    num_train_examples=args.max_train_samples,
    per_gpu_batch_size=args.train_batch_size,
    global_batch_size=args.train_batch_size * accelerator.num_processes,
    num_workers=args.dataloader_num_workers,
    resolution=args.resolution,
    shuffle_buffer_size=<span class="hljs-number">1000</span>,
    pin_memory=<span class="hljs-literal">True</span>,
    persistent_workers=<span class="hljs-literal">True</span>,
)
train_dataloader = dataset.train_dataloader`,wrap:!1}}),K=new M({props:{code:"cHJlZF94XzAlMjAlM0QlMjBwcmVkaWN0ZWRfb3JpZ2luKCUwQSUyMCUyMCUyMCUyMG5vaXNlX3ByZWQlMkMlMEElMjAlMjAlMjAlMjBzdGFydF90aW1lc3RlcHMlMkMlMEElMjAlMjAlMjAlMjBub2lzeV9tb2RlbF9pbnB1dCUyQyUwQSUyMCUyMCUyMCUyMG5vaXNlX3NjaGVkdWxlci5jb25maWcucHJlZGljdGlvbl90eXBlJTJDJTBBJTIwJTIwJTIwJTIwYWxwaGFfc2NoZWR1bGUlMkMlMEElMjAlMjAlMjAlMjBzaWdtYV9zY2hlZHVsZSUyQyUwQSklMEElMEFtb2RlbF9wcmVkJTIwJTNEJTIwY19za2lwX3N0YXJ0JTIwKiUyMG5vaXN5X21vZGVsX2lucHV0JTIwJTJCJTIwY19vdXRfc3RhcnQlMjAqJTIwcHJlZF94XzA=",highlighted:`pred_x_0 = predicted_origin(
    noise_pred,
    start_timesteps,
    noisy_model_input,
    noise_scheduler.config.prediction_type,
    alpha_schedule,
    sigma_schedule,
)

model_pred = c_skip_start * noisy_model_input + c_out_start * pred_x_0`,wrap:!1}}),ee=new M({props:{code:"aWYlMjBhcmdzLmxvc3NfdHlwZSUyMCUzRCUzRCUyMCUyMmwyJTIyJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMEYubXNlX2xvc3MobW9kZWxfcHJlZC5mbG9hdCgpJTJDJTIwdGFyZ2V0LmZsb2F0KCklMkMlMjByZWR1Y3Rpb24lM0QlMjJtZWFuJTIyKSUwQWVsaWYlMjBhcmdzLmxvc3NfdHlwZSUyMCUzRCUzRCUyMCUyMmh1YmVyJTIyJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMHRvcmNoLm1lYW4oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guc3FydCgobW9kZWxfcHJlZC5mbG9hdCgpJTIwLSUyMHRhcmdldC5mbG9hdCgpKSUyMCoqJTIwMiUyMCUyQiUyMGFyZ3MuaHViZXJfYyoqMiklMjAtJTIwYXJncy5odWJlcl9jJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">if</span> args.loss_type == <span class="hljs-string">&quot;l2&quot;</span>:
    loss = F.mse_loss(model_pred.<span class="hljs-built_in">float</span>(), target.<span class="hljs-built_in">float</span>(), reduction=<span class="hljs-string">&quot;mean&quot;</span>)
<span class="hljs-keyword">elif</span> args.loss_type == <span class="hljs-string">&quot;huber&quot;</span>:
    loss = torch.mean(
        torch.sqrt((model_pred.<span class="hljs-built_in">float</span>() - target.<span class="hljs-built_in">float</span>()) ** <span class="hljs-number">2</span> + args.huber_c**<span class="hljs-number">2</span>) - args.huber_c
    )`,wrap:!1}}),le=new we({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),ie=new M({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBZXhwb3J0JTIwT1VUUFVUX0RJUiUzRCUyMnBhdGglMkZ0byUyRnNhdmVkJTJGbW9kZWwlMjIlMEElMEFhY2NlbGVyYXRlJTIwbGF1bmNoJTIwdHJhaW5fbGNtX2Rpc3RpbGxfc2Rfd2RzLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wcmV0cmFpbmVkX3RlYWNoZXJfbW9kZWwlM0QlMjRNT0RFTF9ESVIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW91dHB1dF9kaXIlM0QlMjRPVVRQVVRfRElSJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1taXhlZF9wcmVjaXNpb24lM0RmcDE2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXNvbHV0aW9uJTNENTEyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtNiUyMC0tbG9zc190eXBlJTNEJTIyaHViZXIlMjIlMjAtLWVtYV9kZWNheSUzRDAuOTUlMjAtLWFkYW1fd2VpZ2h0X2RlY2F5JTNEMC4wJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXhfdHJhaW5fc3RlcHMlM0QxMDAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXhfdHJhaW5fc2FtcGxlcyUzRDQwMDAwMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFsb2FkZXJfbnVtX3dvcmtlcnMlM0Q4JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10cmFpbl9zaGFyZHNfcGF0aF9vcl91cmwlM0QlMjJwaXBlJTNBY3VybCUyMC1MJTIwLXMlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZsYWlvbiUyRmNvbmNlcHR1YWwtY2FwdGlvbnMtMTJtLXdlYmRhdGFzZXQlMkZyZXNvbHZlJTJGbWFpbiUyRmRhdGElMkYlN0IwMDAwMC4uMDEwOTklN0QudGFyJTNGZG93bmxvYWQlM0R0cnVlJTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS12YWxpZGF0aW9uX3N0ZXBzJTNEMjAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jaGVja3BvaW50aW5nX3N0ZXBzJTNEMjAwJTIwLS1jaGVja3BvaW50c190b3RhbF9saW1pdCUzRDEwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10cmFpbl9iYXRjaF9zaXplJTNEMTIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAtLWVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdXNlXzhiaXRfYWRhbSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVzdW1lX2Zyb21fY2hlY2twb2ludCUzRGxhdGVzdCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVwb3J0X3RvJTNEd2FuZGIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNlZWQlM0Q0NTM2NDU2MzQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path/to/saved/model&quot;</span>

accelerate launch train_lcm_distill_sd_wds.py \\
    --pretrained_teacher_model=<span class="hljs-variable">$MODEL_DIR</span> \\
    --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
    --mixed_precision=fp16 \\
    --resolution=512 \\
    --learning_rate=1e-6 --loss_type=<span class="hljs-string">&quot;huber&quot;</span> --ema_decay=0.95 --adam_weight_decay=0.0 \\
    --max_train_steps=1000 \\
    --max_train_samples=4000000 \\
    --dataloader_num_workers=8 \\
    --train_shards_path_or_url=<span class="hljs-string">&quot;pipe:curl -L -s https://huggingface.co/datasets/laion/conceptual-captions-12m-webdataset/resolve/main/data/{00000..01099}.tar?download=true&quot;</span> \\
    --validation_steps=200 \\
    --checkpointing_steps=200 --checkpoints_total_limit=10 \\
    --train_batch_size=12 \\
    --gradient_checkpointing --enable_xformers_memory_efficient_attention \\
    --gradient_accumulation_steps=1 \\
    --use_8bit_adam \\
    --resume_from_checkpoint=latest \\
    --report_to=wandb \\
    --seed=453645634 \\
    --push_to_hub`,wrap:!1}}),re=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTJDJTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBMQ01TY2hlZHVsZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci11c2VybmFtZSUyRnlvdXItbW9kZWwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1bmV0JTNEdW5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKSUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJzdXNoaSUyMHJvbGxzJTIwaW4lMjB0aGUlMjBmb3JtJTIwb2YlMjBwYW5kYSUyMGhlYWRzJTJDJTIwc3VzaGklMjBwbGF0dGVyJTIyJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMS4wKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel, DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;your-username/your-model&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, unet=unet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)

pipeline.scheduler = LCMScheduler.from_config(pipe.scheduler.config)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;sushi rolls in the form of panda heads, sushi platter&quot;</span>

image = pipeline(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">1.0</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),oe=new we({props:{title:"LoRA",local:"lora",headingTag:"h2"}}),de=new we({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),ue=new we({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),ye=new fl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/lcm_distill.md"}}),{c(){h=n("meta"),Je=s(),be=n("p"),Ue=s(),p(b.$$.fragment),ge=s(),T=n("p"),T.innerHTML=Zt,_e=s(),J=n("p"),J.innerHTML=It,je=s(),U=n("p"),U.innerHTML=$t,Ce=s(),g=n("p"),g.textContent=Wt,Ze=s(),p(_.$$.fragment),Ie=s(),j=n("p"),j.textContent=Rt,$e=s(),p(C.$$.fragment),We=s(),y=n("blockquote"),y.innerHTML=xt,Re=s(),Z=n("p"),Z.innerHTML=Xt,xe=s(),p(I.$$.fragment),Xe=s(),$=n("p"),$.textContent=vt,ve=s(),p(W.$$.fragment),Ge=s(),R=n("p"),R.textContent=Gt,Ne=s(),p(x.$$.fragment),ke=s(),X=n("p"),X.innerHTML=Nt,Le=s(),p(v.$$.fragment),Ve=s(),w=n("blockquote"),w.innerHTML=kt,Be=s(),G=n("p"),G.innerHTML=Lt,He=s(),N=n("p"),N.innerHTML=Vt,Qe=s(),p(k.$$.fragment),Fe=s(),L=n("p"),L.innerHTML=Bt,Ye=s(),V=n("ul"),V.innerHTML=Ht,Se=s(),p(B.$$.fragment),Ee=s(),H=n("p"),H.innerHTML=Qt,ze=s(),p(Q.$$.fragment),Ae=s(),F=n("p"),F.innerHTML=Ft,De=s(),p(Y.$$.fragment),qe=s(),S=n("p"),S.innerHTML=Yt,Pe=s(),p(E.$$.fragment),Ke=s(),z=n("p"),z.innerHTML=St,Oe=s(),p(A.$$.fragment),et=s(),D=n("p"),D.innerHTML=Et,tt=s(),p(q.$$.fragment),lt=s(),P=n("p"),P.innerHTML=zt,at=s(),p(K.$$.fragment),st=s(),O=n("p"),O.innerHTML=At,it=s(),p(ee.$$.fragment),nt=s(),te=n("p"),te.innerHTML=Dt,rt=s(),p(le.$$.fragment),ot=s(),ae=n("p"),ae.textContent=qt,pt=s(),se=n("p"),se.innerHTML=Pt,ct=s(),p(ie.$$.fragment),dt=s(),ne=n("p"),ne.textContent=Kt,mt=s(),p(re.$$.fragment),ft=s(),p(oe.$$.fragment),ut=s(),pe=n("p"),pe.innerHTML=Ot,Mt=s(),ce=n("p"),ce.innerHTML=el,ht=s(),p(de.$$.fragment),yt=s(),me=n("p"),me.innerHTML=tl,wt=s(),fe=n("p"),fe.innerHTML=ll,bt=s(),p(ue.$$.fragment),Tt=s(),Me=n("p"),Me.textContent=al,Jt=s(),he=n("ul"),he.innerHTML=sl,Ut=s(),p(ye.$$.fragment),gt=s(),Te=n("p"),this.h()},l(e){const t=dl("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(l),Je=i(e),be=r(e,"P",{}),il(be).forEach(l),Ue=i(e),c(b.$$.fragment,e),ge=i(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1oefohu"&&(T.innerHTML=Zt),_e=i(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-w1dbtu"&&(J.innerHTML=It),je=i(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1izwzxl"&&(U.innerHTML=$t),Ce=i(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-l7dm2q"&&(g.textContent=Wt),Ze=i(e),c(_.$$.fragment,e),Ie=i(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-z4z0b9"&&(j.textContent=Rt),$e=i(e),c(C.$$.fragment,e),We=i(e),y=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-1in84qc"&&(y.innerHTML=xt),Re=i(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-h7f7kz"&&(Z.innerHTML=Xt),xe=i(e),c(I.$$.fragment,e),Xe=i(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-di6juu"&&($.textContent=vt),ve=i(e),c(W.$$.fragment,e),Ge=i(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-tsz4qp"&&(R.textContent=Gt),Ne=i(e),c(x.$$.fragment,e),ke=i(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1fkfdql"&&(X.innerHTML=Nt),Le=i(e),c(v.$$.fragment,e),Ve=i(e),w=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-sd7gud"&&(w.innerHTML=kt),Be=i(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-z8r4ny"&&(G.innerHTML=Lt),He=i(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1r0bv1x"&&(N.innerHTML=Vt),Qe=i(e),c(k.$$.fragment,e),Fe=i(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-opb00x"&&(L.innerHTML=Bt),Ye=i(e),V=r(e,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-q5d022"&&(V.innerHTML=Ht),Se=i(e),c(B.$$.fragment,e),Ee=i(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-xygc62"&&(H.innerHTML=Qt),ze=i(e),c(Q.$$.fragment,e),Ae=i(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1fe8qlp"&&(F.innerHTML=Ft),De=i(e),c(Y.$$.fragment,e),qe=i(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-184frii"&&(S.innerHTML=Yt),Pe=i(e),c(E.$$.fragment,e),Ke=i(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-he12t1"&&(z.innerHTML=St),Oe=i(e),c(A.$$.fragment,e),et=i(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1c3frfx"&&(D.innerHTML=Et),tt=i(e),c(q.$$.fragment,e),lt=i(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-4kbgth"&&(P.innerHTML=zt),at=i(e),c(K.$$.fragment,e),st=i(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1g18b9r"&&(O.innerHTML=At),it=i(e),c(ee.$$.fragment,e),nt=i(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1pefyrm"&&(te.innerHTML=Dt),rt=i(e),c(le.$$.fragment,e),ot=i(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-5c8ldp"&&(ae.textContent=qt),pt=i(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-14rdptq"&&(se.innerHTML=Pt),ct=i(e),c(ie.$$.fragment,e),dt=i(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-2n690z"&&(ne.textContent=Kt),mt=i(e),c(re.$$.fragment,e),ft=i(e),c(oe.$$.fragment,e),ut=i(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-21u499"&&(pe.innerHTML=Ot),Mt=i(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1sxi0tl"&&(ce.innerHTML=el),ht=i(e),c(de.$$.fragment,e),yt=i(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-swritx"&&(me.innerHTML=tl),wt=i(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-6dxtva"&&(fe.innerHTML=ll),bt=i(e),c(ue.$$.fragment,e),Tt=i(e),Me=r(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1bflftn"&&(Me.textContent=al),Jt=i(e),he=r(e,"UL",{"data-svelte-h":!0}),o(he)!=="svelte-e624yw"&&(he.innerHTML=sl),Ut=i(e),c(ye.$$.fragment,e),gt=i(e),Te=r(e,"P",{}),il(Te).forEach(l),this.h()},h(){jt(h,"name","hf:doc:metadata"),jt(h,"content",Ml),jt(y,"class","tip"),jt(w,"class","tip")},m(e,t){ml(document.head,h),a(e,Je,t),a(e,be,t),a(e,Ue,t),d(b,e,t),a(e,ge,t),a(e,T,t),a(e,_e,t),a(e,J,t),a(e,je,t),a(e,U,t),a(e,Ce,t),a(e,g,t),a(e,Ze,t),d(_,e,t),a(e,Ie,t),a(e,j,t),a(e,$e,t),d(C,e,t),a(e,We,t),a(e,y,t),a(e,Re,t),a(e,Z,t),a(e,xe,t),d(I,e,t),a(e,Xe,t),a(e,$,t),a(e,ve,t),d(W,e,t),a(e,Ge,t),a(e,R,t),a(e,Ne,t),d(x,e,t),a(e,ke,t),a(e,X,t),a(e,Le,t),d(v,e,t),a(e,Ve,t),a(e,w,t),a(e,Be,t),a(e,G,t),a(e,He,t),a(e,N,t),a(e,Qe,t),d(k,e,t),a(e,Fe,t),a(e,L,t),a(e,Ye,t),a(e,V,t),a(e,Se,t),d(B,e,t),a(e,Ee,t),a(e,H,t),a(e,ze,t),d(Q,e,t),a(e,Ae,t),a(e,F,t),a(e,De,t),d(Y,e,t),a(e,qe,t),a(e,S,t),a(e,Pe,t),d(E,e,t),a(e,Ke,t),a(e,z,t),a(e,Oe,t),d(A,e,t),a(e,et,t),a(e,D,t),a(e,tt,t),d(q,e,t),a(e,lt,t),a(e,P,t),a(e,at,t),d(K,e,t),a(e,st,t),a(e,O,t),a(e,it,t),d(ee,e,t),a(e,nt,t),a(e,te,t),a(e,rt,t),d(le,e,t),a(e,ot,t),a(e,ae,t),a(e,pt,t),a(e,se,t),a(e,ct,t),d(ie,e,t),a(e,dt,t),a(e,ne,t),a(e,mt,t),d(re,e,t),a(e,ft,t),d(oe,e,t),a(e,ut,t),a(e,pe,t),a(e,Mt,t),a(e,ce,t),a(e,ht,t),d(de,e,t),a(e,yt,t),a(e,me,t),a(e,wt,t),a(e,fe,t),a(e,bt,t),d(ue,e,t),a(e,Tt,t),a(e,Me,t),a(e,Jt,t),a(e,he,t),a(e,Ut,t),d(ye,e,t),a(e,gt,t),a(e,Te,t),_t=!0},p:rl,i(e){_t||(m(b.$$.fragment,e),m(_.$$.fragment,e),m(C.$$.fragment,e),m(I.$$.fragment,e),m(W.$$.fragment,e),m(x.$$.fragment,e),m(v.$$.fragment,e),m(k.$$.fragment,e),m(B.$$.fragment,e),m(Q.$$.fragment,e),m(Y.$$.fragment,e),m(E.$$.fragment,e),m(A.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(oe.$$.fragment,e),m(de.$$.fragment,e),m(ue.$$.fragment,e),m(ye.$$.fragment,e),_t=!0)},o(e){f(b.$$.fragment,e),f(_.$$.fragment,e),f(C.$$.fragment,e),f(I.$$.fragment,e),f(W.$$.fragment,e),f(x.$$.fragment,e),f(v.$$.fragment,e),f(k.$$.fragment,e),f(B.$$.fragment,e),f(Q.$$.fragment,e),f(Y.$$.fragment,e),f(E.$$.fragment,e),f(A.$$.fragment,e),f(q.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(oe.$$.fragment,e),f(de.$$.fragment,e),f(ue.$$.fragment,e),f(ye.$$.fragment,e),_t=!1},d(e){e&&(l(Je),l(be),l(Ue),l(ge),l(T),l(_e),l(J),l(je),l(U),l(Ce),l(g),l(Ze),l(Ie),l(j),l($e),l(We),l(y),l(Re),l(Z),l(xe),l(Xe),l($),l(ve),l(Ge),l(R),l(Ne),l(ke),l(X),l(Le),l(Ve),l(w),l(Be),l(G),l(He),l(N),l(Qe),l(Fe),l(L),l(Ye),l(V),l(Se),l(Ee),l(H),l(ze),l(Ae),l(F),l(De),l(qe),l(S),l(Pe),l(Ke),l(z),l(Oe),l(et),l(D),l(tt),l(lt),l(P),l(at),l(st),l(O),l(it),l(nt),l(te),l(rt),l(ot),l(ae),l(pt),l(se),l(ct),l(dt),l(ne),l(mt),l(ft),l(ut),l(pe),l(Mt),l(ce),l(ht),l(yt),l(me),l(wt),l(fe),l(bt),l(Tt),l(Me),l(Jt),l(he),l(Ut),l(gt),l(Te)),l(h),u(b,e),u(_,e),u(C,e),u(I,e),u(W,e),u(x,e),u(v,e),u(k,e),u(B,e),u(Q,e),u(Y,e),u(E,e),u(A,e),u(q,e),u(K,e),u(ee,e),u(le,e),u(ie,e),u(re,e),u(oe,e),u(de,e),u(ue,e),u(ye,e)}}}const Ml='{"title":"Latent Consistency Distillation","local":"latent-consistency-distillation","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"LoRA","local":"lora","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function hl(Ct){return ol(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jl extends pl{constructor(h){super(),cl(this,h,hl,ul,nl,{})}}export{Jl as component};
