import{s as Xt,n as Bt,o as vt}from"../chunks/scheduler.888833de.js";import{S as Rt,i as xt,e as o,s,c as d,h as Ht,a as i,d as a,b as n,f as Gt,g as p,j as r,k as Mt,l as Ct,m as l,n as u,t as c,o as m,p as M}from"../chunks/index.128ce987.js";import{C as F}from"../chunks/CodeBlock.37df032e.js";import{H as ht,E as Yt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function Wt(ft){let h,q,W,E,y,L,T,gt='There are many datasets on the <a href="https://huggingface.co/datasets?task_categories=task_categories:text-to-image&amp;sort=downloads" rel="nofollow">Hub</a> to train a model on, but if you can’t find one you’re interested in or want to use your own, you can create a dataset with the 🤗 <a href="https://huggingface.co/docs/datasets" rel="nofollow">Datasets</a> library. The dataset structure depends on the task you want to train your model on. The most basic dataset structure is a directory of images for tasks like unconditional image generation. Another dataset structure may be a directory of images and a text file containing their corresponding text captions for tasks like text-to-image generation.',N,J,yt="This guide will show you two ways to create a dataset to finetune on:",Q,j,Tt="<li>provide a folder of images to the <code>--train_data_dir</code> argument</li> <li>upload a dataset to the Hub and pass the dataset repository id to the <code>--dataset_name</code> argument</li>",A,f,Jt='<p>💡 Learn more about how to create an image dataset for training in the <a href="https://huggingface.co/docs/datasets/image_dataset" rel="nofollow">Create an image dataset</a> guide.</p>',V,w,S,_,jt='For unconditional generation, you can provide your own dataset as a folder of images. The training script uses the <a href="https://huggingface.co/docs/datasets/en/image_dataset#imagefolder" rel="nofollow"><code>ImageFolder</code></a> builder from 🤗 Datasets to automatically build a dataset from the folder. Your directory structure should look like:',P,b,D,Z,wt="Pass the path to the dataset directory to the <code>--train_data_dir</code> argument, and then you can start training:",K,U,O,k,tt,g,_t='<p>💡 For more details and context about creating and uploading a dataset to the Hub, take a look at the <a href="https://huggingface.co/blog/image-search-datasets" rel="nofollow">Image search with 🤗 Datasets</a> post.</p>',et,$,bt='Start by creating a dataset with the <a href="https://huggingface.co/docs/datasets/image_load#imagefolder" rel="nofollow"><code>ImageFolder</code></a> feature, which creates an <code>image</code> column containing the PIL-encoded images.',at,I,Zt="You can use the <code>data_dir</code> or <code>data_files</code> parameters to specify the location of the dataset. The <code>data_files</code> parameter supports mapping specific files to dataset splits like <code>train</code> or <code>test</code>:",lt,G,st,X,Ut='Then use the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.push_to_hub" rel="nofollow">push_to_hub</a> method to upload the dataset to the Hub:',nt,B,ot,v,kt="Now the dataset is available for training by passing the dataset name to the <code>--dataset_name</code> argument:",it,R,rt,x,dt,H,$t="Now that you’ve created a dataset, you can plug it into the <code>train_data_dir</code> (if your dataset is local) or <code>dataset_name</code> (if your dataset is on the Hub) arguments of a training script.",pt,C,It='For your next steps, feel free to try and use your dataset to train a model for <a href="unconditional_training">unconditional generation</a> or <a href="text2image">text-to-image generation</a>!',ut,Y,ct,z,mt;return y=new ht({props:{title:"Create a dataset for training",local:"create-a-dataset-for-training",headingTag:"h1"}}),w=new ht({props:{title:"Provide a dataset as a folder",local:"provide-a-dataset-as-a-folder",headingTag:"h2"}}),b=new F({props:{code:"ZGF0YV9kaXIlMkZ4eHgucG5nJTBBZGF0YV9kaXIlMkZ4eHkucG5nJTBBZGF0YV9kaXIlMkYlNUIuLi4lNUQlMkZ4eHoucG5n",highlighted:`data_dir/xxx.png
data_dir/xxy.png
data_dir/[...]/xxz.png`,wrap:!1}}),U=new F({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX3VuY29uZGl0aW9uYWwucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRyYWluX2RhdGFfZGlyJTIwJTNDcGF0aC10by10cmFpbi1kaXJlY3RvcnklM0UlMjAlNUMlMEElMjAlMjAlMjAlMjAlM0NvdGhlci1hcmd1bWVudHMlM0U=",highlighted:`accelerate launch train_unconditional.py \\
    --train_data_dir &lt;path-to-train-directory&gt; \\
    &lt;other-arguments&gt;`,wrap:!1}}),k=new ht({props:{title:"Upload your data to the Hub",local:"upload-your-data-to-the-hub",headingTag:"h2"}}),G=new F({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwZXhhbXBsZSUyMDElM0ElMjBsb2NhbCUyMGZvbGRlciUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1hZ2Vmb2xkZXIlMjIlMkMlMjBkYXRhX2RpciUzRCUyMnBhdGhfdG9feW91cl9mb2xkZXIlMjIpJTBBJTBBJTIzJTIwZXhhbXBsZSUyMDIlM0ElMjBsb2NhbCUyMGZpbGVzJTIwKHN1cHBvcnRlZCUyMGZvcm1hdHMlMjBhcmUlMjB0YXIlMkMlMjBnemlwJTJDJTIwemlwJTJDJTIweHolMkMlMjByYXIlMkMlMjB6c3RkKSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1hZ2Vmb2xkZXIlMjIlMkMlMjBkYXRhX2ZpbGVzJTNEJTIycGF0aF90b196aXBfZmlsZSUyMiklMEElMEElMjMlMjBleGFtcGxlJTIwMyUzQSUyMHJlbW90ZSUyMGZpbGVzJTIwKHN1cHBvcnRlZCUyMGZvcm1hdHMlMjBhcmUlMjB0YXIlMkMlMjBnemlwJTJDJTIwemlwJTJDJTIweHolMkMlMjByYXIlMkMlMjB6c3RkKSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyaW1hZ2Vmb2xkZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2ZpbGVzJTNEJTIyaHR0cHMlM0ElMkYlMkZkb3dubG9hZC5taWNyb3NvZnQuY29tJTJGZG93bmxvYWQlMkYzJTJGRSUyRjElMkYzRTFDM0YyMS1FQ0RCLTQ4NjktODM2OC02REVCQTc3QjkxOUYlMkZrYWdnbGVjYXRzYW5kZG9nc18zMzY3YS56aXAlMjIlMkMlMEEpJTBBJTBBJTIzJTIwZXhhbXBsZSUyMDQlM0ElMjBwcm92aWRpbmclMjBzZXZlcmFsJTIwc3BsaXRzJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJpbWFnZWZvbGRlciUyMiUyQyUyMGRhdGFfZmlsZXMlM0QlN0IlMjJ0cmFpbiUyMiUzQSUyMCU1QiUyMnBhdGglMkZ0byUyRmZpbGUxJTIyJTJDJTIwJTIycGF0aCUyRnRvJTJGZmlsZTIlMjIlNUQlMkMlMjAlMjJ0ZXN0JTIyJTNBJTIwJTVCJTIycGF0aCUyRnRvJTJGZmlsZTMlMjIlMkMlMjAlMjJwYXRoJTJGdG8lMkZmaWxlNCUyMiU1RCU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># example 1: local folder</span>
dataset = load_dataset(<span class="hljs-string">&quot;imagefolder&quot;</span>, data_dir=<span class="hljs-string">&quot;path_to_your_folder&quot;</span>)

<span class="hljs-comment"># example 2: local files (supported formats are tar, gzip, zip, xz, rar, zstd)</span>
dataset = load_dataset(<span class="hljs-string">&quot;imagefolder&quot;</span>, data_files=<span class="hljs-string">&quot;path_to_zip_file&quot;</span>)

<span class="hljs-comment"># example 3: remote files (supported formats are tar, gzip, zip, xz, rar, zstd)</span>
dataset = load_dataset(
    <span class="hljs-string">&quot;imagefolder&quot;</span>,
    data_files=<span class="hljs-string">&quot;https://download.microsoft.com/download/3/E/1/3E1C3F21-ECDB-4869-8368-6DEBA77B919F/kagglecatsanddogs_3367a.zip&quot;</span>,
)

<span class="hljs-comment"># example 4: providing several splits</span>
dataset = load_dataset(
    <span class="hljs-string">&quot;imagefolder&quot;</span>, data_files={<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">&quot;path/to/file1&quot;</span>, <span class="hljs-string">&quot;path/to/file2&quot;</span>], <span class="hljs-string">&quot;test&quot;</span>: [<span class="hljs-string">&quot;path/to/file3&quot;</span>, <span class="hljs-string">&quot;path/to/file4&quot;</span>]}
)`,wrap:!1}}),B=new F({props:{code:"JTIzJTIwYXNzdW1pbmclMjB5b3UlMjBoYXZlJTIwcmFuJTIwdGhlJTIwaGYlMjBhdXRoJTIwbG9naW4lMjBjb21tYW5kJTIwaW4lMjBhJTIwdGVybWluYWwlMEFkYXRhc2V0LnB1c2hfdG9faHViKCUyMm5hbWVfb2ZfeW91cl9kYXRhc2V0JTIyKSUwQSUwQSUyMyUyMGlmJTIweW91JTIwd2FudCUyMHRvJTIwcHVzaCUyMHRvJTIwYSUyMHByaXZhdGUlMjByZXBvJTJDJTIwc2ltcGx5JTIwcGFzcyUyMHByaXZhdGUlM0RUcnVlJTNBJTBBZGF0YXNldC5wdXNoX3RvX2h1YiglMjJuYW1lX29mX3lvdXJfZGF0YXNldCUyMiUyQyUyMHByaXZhdGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-comment"># assuming you have ran the hf auth login command in a terminal</span>
dataset.push_to_hub(<span class="hljs-string">&quot;name_of_your_dataset&quot;</span>)

<span class="hljs-comment"># if you want to push to a private repo, simply pass private=True:</span>
dataset.push_to_hub(<span class="hljs-string">&quot;name_of_your_dataset&quot;</span>, private=<span class="hljs-literal">True</span>)`,wrap:!1}}),R=new F({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMCUyMHRyYWluX3RleHRfdG9faW1hZ2UucHklMjAlNUMlMEElMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTIwJTVDJTBBJTIwJTIwLS1kYXRhc2V0X25hbWUlM0QlMjJuYW1lX29mX3lvdXJfZGF0YXNldCUyMiUyMCU1QyUwQSUyMCUyMCUzQ290aGVyLWFyZ3VtZW50cyUzRQ==",highlighted:`accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>  train_text_to_image.py \\
  --pretrained_model_name_or_path=<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span> \\
  --dataset_name=<span class="hljs-string">&quot;name_of_your_dataset&quot;</span> \\
  &lt;other-arguments&gt;`,wrap:!1}}),x=new ht({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Y=new Yt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/create_dataset.md"}}),{c(){h=o("meta"),q=s(),W=o("p"),E=s(),d(y.$$.fragment),L=s(),T=o("p"),T.innerHTML=gt,N=s(),J=o("p"),J.textContent=yt,Q=s(),j=o("ul"),j.innerHTML=Tt,A=s(),f=o("blockquote"),f.innerHTML=Jt,V=s(),d(w.$$.fragment),S=s(),_=o("p"),_.innerHTML=jt,P=s(),d(b.$$.fragment),D=s(),Z=o("p"),Z.innerHTML=wt,K=s(),d(U.$$.fragment),O=s(),d(k.$$.fragment),tt=s(),g=o("blockquote"),g.innerHTML=_t,et=s(),$=o("p"),$.innerHTML=bt,at=s(),I=o("p"),I.innerHTML=Zt,lt=s(),d(G.$$.fragment),st=s(),X=o("p"),X.innerHTML=Ut,nt=s(),d(B.$$.fragment),ot=s(),v=o("p"),v.innerHTML=kt,it=s(),d(R.$$.fragment),rt=s(),d(x.$$.fragment),dt=s(),H=o("p"),H.innerHTML=$t,pt=s(),C=o("p"),C.innerHTML=It,ut=s(),d(Y.$$.fragment),ct=s(),z=o("p"),this.h()},l(t){const e=Ht("svelte-u9bgzb",document.head);h=i(e,"META",{name:!0,content:!0}),e.forEach(a),q=n(t),W=i(t,"P",{}),Gt(W).forEach(a),E=n(t),p(y.$$.fragment,t),L=n(t),T=i(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1kq6fl5"&&(T.innerHTML=gt),N=n(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1ki6nhc"&&(J.textContent=yt),Q=n(t),j=i(t,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-136e0w1"&&(j.innerHTML=Tt),A=n(t),f=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(f)!=="svelte-1f197i8"&&(f.innerHTML=Jt),V=n(t),p(w.$$.fragment,t),S=n(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1tbm8ke"&&(_.innerHTML=jt),P=n(t),p(b.$$.fragment,t),D=n(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-16r2a6g"&&(Z.innerHTML=wt),K=n(t),p(U.$$.fragment,t),O=n(t),p(k.$$.fragment,t),tt=n(t),g=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-f9us11"&&(g.innerHTML=_t),et=n(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-117nzzz"&&($.innerHTML=bt),at=n(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-10hf74w"&&(I.innerHTML=Zt),lt=n(t),p(G.$$.fragment,t),st=n(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-2nvk44"&&(X.innerHTML=Ut),nt=n(t),p(B.$$.fragment,t),ot=n(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-19t9o3p"&&(v.innerHTML=kt),it=n(t),p(R.$$.fragment,t),rt=n(t),p(x.$$.fragment,t),dt=n(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1ata9m5"&&(H.innerHTML=$t),pt=n(t),C=i(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-oyixgb"&&(C.innerHTML=It),ut=n(t),p(Y.$$.fragment,t),ct=n(t),z=i(t,"P",{}),Gt(z).forEach(a),this.h()},h(){Mt(h,"name","hf:doc:metadata"),Mt(h,"content",zt),Mt(f,"class","tip"),Mt(g,"class","tip")},m(t,e){Ct(document.head,h),l(t,q,e),l(t,W,e),l(t,E,e),u(y,t,e),l(t,L,e),l(t,T,e),l(t,N,e),l(t,J,e),l(t,Q,e),l(t,j,e),l(t,A,e),l(t,f,e),l(t,V,e),u(w,t,e),l(t,S,e),l(t,_,e),l(t,P,e),u(b,t,e),l(t,D,e),l(t,Z,e),l(t,K,e),u(U,t,e),l(t,O,e),u(k,t,e),l(t,tt,e),l(t,g,e),l(t,et,e),l(t,$,e),l(t,at,e),l(t,I,e),l(t,lt,e),u(G,t,e),l(t,st,e),l(t,X,e),l(t,nt,e),u(B,t,e),l(t,ot,e),l(t,v,e),l(t,it,e),u(R,t,e),l(t,rt,e),u(x,t,e),l(t,dt,e),l(t,H,e),l(t,pt,e),l(t,C,e),l(t,ut,e),u(Y,t,e),l(t,ct,e),l(t,z,e),mt=!0},p:Bt,i(t){mt||(c(y.$$.fragment,t),c(w.$$.fragment,t),c(b.$$.fragment,t),c(U.$$.fragment,t),c(k.$$.fragment,t),c(G.$$.fragment,t),c(B.$$.fragment,t),c(R.$$.fragment,t),c(x.$$.fragment,t),c(Y.$$.fragment,t),mt=!0)},o(t){m(y.$$.fragment,t),m(w.$$.fragment,t),m(b.$$.fragment,t),m(U.$$.fragment,t),m(k.$$.fragment,t),m(G.$$.fragment,t),m(B.$$.fragment,t),m(R.$$.fragment,t),m(x.$$.fragment,t),m(Y.$$.fragment,t),mt=!1},d(t){t&&(a(q),a(W),a(E),a(L),a(T),a(N),a(J),a(Q),a(j),a(A),a(f),a(V),a(S),a(_),a(P),a(D),a(Z),a(K),a(O),a(tt),a(g),a(et),a($),a(at),a(I),a(lt),a(st),a(X),a(nt),a(ot),a(v),a(it),a(rt),a(dt),a(H),a(pt),a(C),a(ut),a(ct),a(z)),a(h),M(y,t),M(w,t),M(b,t),M(U,t),M(k,t),M(G,t),M(B,t),M(R,t),M(x,t),M(Y,t)}}}const zt='{"title":"Create a dataset for training","local":"create-a-dataset-for-training","sections":[{"title":"Provide a dataset as a folder","local":"provide-a-dataset-as-a-folder","sections":[],"depth":2},{"title":"Upload your data to the Hub","local":"upload-your-data-to-the-hub","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Ft(ft){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends Rt{constructor(h){super(),xt(this,h,Ft,Wt,Xt,{})}}export{Qt as component};
