import{s as Ua,o as Za,n as Mn}from"../chunks/scheduler.888833de.js";import{S as ga,i as _a,e as i,s as a,c as M,h as Ia,a as o,d as l,b as t,f as wa,g as u,j as c,k as v,l as xa,m as n,n as y,t as f,o as J,p as h}from"../chunks/index.128ce987.js";import{C as U}from"../chunks/CodeBlock.37df032e.js";import{H as x,E as Ga}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";import{H as Ta,a as dn}from"../chunks/HfOption.79a0a3f5.js";function va(G){let m,T="The <code>balanced</code> device placement strategy evenly splits the pipeline across all available devices.",j,b,p,r,w="You can inspect a pipeline’s device map with <code>hf_device_map</code>.",_,Z,I;return b=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>
)`,wrap:!1}}),Z=new U({props:{code:"cHJpbnQocGlwZWxpbmUuaGZfZGV2aWNlX21hcCklMEElN0IndW5ldCclM0ElMjAxJTJDJTIwJ3ZhZSclM0ElMjAxJTJDJTIwJ3NhZmV0eV9jaGVja2VyJyUzQSUyMDAlMkMlMjAndGV4dF9lbmNvZGVyJyUzQSUyMDAlN0Q=",highlighted:`<span class="hljs-built_in">print</span>(pipeline.hf_device_map)
{<span class="hljs-string">&#x27;unet&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;vae&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;safety_checker&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text_encoder&#x27;</span>: <span class="hljs-number">0</span>}`,wrap:!1}}),{c(){m=i("p"),m.innerHTML=T,j=a(),M(b.$$.fragment),p=a(),r=i("p"),r.innerHTML=w,_=a(),M(Z.$$.fragment)},l(d){m=o(d,"P",{"data-svelte-h":!0}),c(m)!=="svelte-13intml"&&(m.innerHTML=T),j=t(d),u(b.$$.fragment,d),p=t(d),r=o(d,"P",{"data-svelte-h":!0}),c(r)!=="svelte-cfrzyx"&&(r.innerHTML=w),_=t(d),u(Z.$$.fragment,d)},m(d,g){n(d,m,g),n(d,j,g),y(b,d,g),n(d,p,g),n(d,r,g),n(d,_,g),y(Z,d,g),I=!0},p:Mn,i(d){I||(f(b.$$.fragment,d),f(Z.$$.fragment,d),I=!0)},o(d){J(b.$$.fragment,d),J(Z.$$.fragment,d),I=!1},d(d){d&&(l(m),l(j),l(p),l(r),l(_)),h(b,d),h(Z,d)}}}function Ca(G){let m,T='The <code>device_map</code> is useful for loading large models, such as the Flux diffusion transformer which has 12.5B parameters. Set it to <code>&quot;auto&quot;</code> to automatically distribute a model across the fastest device first before moving to slower devices. Refer to the <a href="../training/distributed_inference#model-sharding">Model sharding</a> docs for more details.',j,b,p,r,w="You can inspect a model’s device map with <code>hf_device_map</code>.",_,Z,I;return b=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel

transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, 
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16
)`,wrap:!1}}),Z=new U({props:{code:"cHJpbnQodHJhbnNmb3JtZXIuaGZfZGV2aWNlX21hcCk=",highlighted:'<span class="hljs-built_in">print</span>(transformer.hf_device_map)',wrap:!1}}),{c(){m=i("p"),m.innerHTML=T,j=a(),M(b.$$.fragment),p=a(),r=i("p"),r.innerHTML=w,_=a(),M(Z.$$.fragment)},l(d){m=o(d,"P",{"data-svelte-h":!0}),c(m)!=="svelte-djqsxo"&&(m.innerHTML=T),j=t(d),u(b.$$.fragment,d),p=t(d),r=o(d,"P",{"data-svelte-h":!0}),c(r)!=="svelte-af1u4w"&&(r.innerHTML=w),_=t(d),u(Z.$$.fragment,d)},m(d,g){n(d,m,g),n(d,j,g),y(b,d,g),n(d,p,g),n(d,r,g),n(d,_,g),y(Z,d,g),I=!0},p:Mn,i(d){I||(f(b.$$.fragment,d),f(Z.$$.fragment,d),I=!0)},o(d){J(b.$$.fragment,d),J(Z.$$.fragment,d),I=!1},d(d){d&&(l(m),l(j),l(p),l(r),l(_)),h(b,d),h(Z,d)}}}function Wa(G){let m,T,j,b;return m=new dn({props:{id:"device-map",option:"pipeline level",$$slots:{default:[va]},$$scope:{ctx:G}}}),j=new dn({props:{id:"device-map",option:"model level",$$slots:{default:[Ca]},$$scope:{ctx:G}}}),{c(){M(m.$$.fragment),T=a(),M(j.$$.fragment)},l(p){u(m.$$.fragment,p),T=t(p),u(j.$$.fragment,p)},m(p,r){y(m,p,r),n(p,T,r),y(j,p,r),b=!0},p(p,r){const w={};r&2&&(w.$$scope={dirty:r,ctx:p}),m.$set(w);const _={};r&2&&(_.$$scope={dirty:r,ctx:p}),j.$set(_)},i(p){b||(f(m.$$.fragment,p),f(j.$$.fragment,p),b=!0)},o(p){J(m.$$.fragment,p),J(j.$$.fragment,p),b=!1},d(p){p&&l(T),h(m,p),h(j,p)}}}function ka(G){let m,T='Call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_group_offload">enable_group_offload()</a> on a pipeline.',j,b,p;return b=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-keyword">from</span> diffusers.hooks <span class="hljs-keyword">import</span> apply_group_offloading
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

onload_device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>)
offload_device = torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)

pipeline = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>, torch_dtype=torch.bfloat16)
pipeline.enable_group_offload(
    onload_device=onload_device,
    offload_device=offload_device,
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    use_stream=<span class="hljs-literal">True</span>
)

prompt = (
    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
)
video = pipeline(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){m=i("p"),m.innerHTML=T,j=a(),M(b.$$.fragment)},l(r){m=o(r,"P",{"data-svelte-h":!0}),c(m)!=="svelte-7or8mg"&&(m.innerHTML=T),j=t(r),u(b.$$.fragment,r)},m(r,w){n(r,m,w),n(r,j,w),y(b,r,w),p=!0},p:Mn,i(r){p||(f(b.$$.fragment,r),p=!0)},o(r){J(b.$$.fragment,r),p=!1},d(r){r&&(l(m),l(j)),h(b,r)}}}function Ba(G){let m,T='Call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_group_offload">enable_group_offload()</a> on standard Diffusers model components that inherit from <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. For other model components that don’t inherit from <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>, such as a generic <a href="https://pytorch.org/docs/stable/generated/torch.nn.Module.html" rel="nofollow">torch.nn.Module</a>, use <a href="/docs/diffusers/main/en/api/utilities#diffusers.hooks.apply_group_offloading">apply_group_offloading()</a> instead.',j,b,p;return b=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-keyword">from</span> diffusers.hooks <span class="hljs-keyword">import</span> apply_group_offloading
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

onload_device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>)
offload_device = torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
pipeline = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>, torch_dtype=torch.bfloat16)

<span class="hljs-comment"># Use the enable_group_offload method for Diffusers model implementations</span>
pipeline.transformer.enable_group_offload(onload_device=onload_device, offload_device=offload_device, offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>)
pipeline.vae.enable_group_offload(onload_device=onload_device, offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>)

<span class="hljs-comment"># Use the apply_group_offloading method for other model components</span>
apply_group_offloading(pipeline.text_encoder, onload_device=onload_device, offload_type=<span class="hljs-string">&quot;block_level&quot;</span>, num_blocks_per_group=<span class="hljs-number">2</span>)

prompt = (
    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
)
video = pipeline(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){m=i("p"),m.innerHTML=T,j=a(),M(b.$$.fragment)},l(r){m=o(r,"P",{"data-svelte-h":!0}),c(m)!=="svelte-1tfd1v"&&(m.innerHTML=T),j=t(r),u(b.$$.fragment,r)},m(r,w){n(r,m,w),n(r,j,w),y(b,r,w),p=!0},p:Mn,i(r){p||(f(b.$$.fragment,r),p=!0)},o(r){J(b.$$.fragment,r),p=!1},d(r){r&&(l(m),l(j)),h(b,r)}}}function Va(G){let m,T,j,b;return m=new dn({props:{id:"group-offloading",option:"pipeline",$$slots:{default:[ka]},$$scope:{ctx:G}}}),j=new dn({props:{id:"group-offloading",option:"model",$$slots:{default:[Ba]},$$scope:{ctx:G}}}),{c(){M(m.$$.fragment),T=a(),M(j.$$.fragment)},l(p){u(m.$$.fragment,p),T=t(p),u(j.$$.fragment,p)},m(p,r){y(m,p,r),n(p,T,r),y(j,p,r),b=!0},p(p,r){const w={};r&2&&(w.$$scope={dirty:r,ctx:p}),m.$set(w);const _={};r&2&&(_.$$scope={dirty:r,ctx:p}),j.$set(_)},i(p){b||(f(m.$$.fragment,p),f(j.$$.fragment,p),b=!0)},o(p){J(m.$$.fragment,p),J(j.$$.fragment,p),b=!1},d(p){p&&l(T),h(m,p),h(j,p)}}}function Xa(G){let m,T,j,b,p,r,w,_='Modern diffusion models like <a href="../api/pipelines/flux">Flux</a> and <a href="../api/pipelines/wan">Wan</a> have billions of parameters that take up a lot of memory on your hardware for inference. This is challenging because common GPUs often don’t have sufficient memory. To overcome the memory limitations, you can use more than one GPU (if available), offload some of the pipeline components to the CPU, and more.',Z,I,d="This guide will show you how to reduce your memory usage.",g,C,un="<p>Keep in mind these techniques may need to be adjusted depending on the model. For example, a transformer-based diffusion model may not benefit equally from these memory optimizations as a UNet-based model.</p>",we,H,Te,E,yn='If you have access to more than one GPU, there a few options for efficiently loading and distributing a large model across your hardware. These features are supported by the <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> library, so make sure it is installed first.',Ue,S,Ze,F,ge,A,fn="Loading large checkpoints in several shards in useful because the shards are loaded one at a time. This keeps memory usage low, only requiring enough memory for the model size and the largest shard size. We recommend sharding when the fp32 checkpoint is greater than 5GB. The default shard size is 5GB.",_e,L,Jn='Shard a checkpoint in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a> with the <code>max_shard_size</code> parameter.',Ie,q,xe,D,hn="Now you can use the sharded checkpoint, instead of the regular checkpoint, to save memory.",Ge,P,ve,K,Ce,W,bn="<p>Device placement is an experimental feature and the API may change. Only the <code>balanced</code> strategy is supported at the moment. We plan to support additional mapping strategies in the future.</p>",We,O,jn="The <code>device_map</code> parameter controls how the model components in a pipeline or the layers in an individual model are distributed across devices.",ke,k,Be,ss,wn="When designing your own <code>device_map</code>, it should be a dictionary of a model’s specific module name or layer and a device identifier (an integer for GPUs, <code>cpu</code> for CPUs, and <code>disk</code> for disk).",Ve,es,Tn="Call <code>hf_device_map</code> on a model to see how model layers are distributed and then design your own.",Xe,ls,Ne,ns,Un="For example, the <code>device_map</code> below places <code>single_transformer_blocks.10</code> through <code>single_transformer_blocks.20</code> on a second GPU (<code>1</code>).",Ye,as,$e,ts,Zn="Pass a dictionary mapping maximum memory usage to each device to enforce a limit. If a device is not in <code>max_memory</code>, it is ignored and pipeline components won’t be distributed to it.",Qe,is,Re,os,gn="Diffusers uses the maxmium memory of all devices by default, but if they don’t fit on the GPUs, then you’ll need to use a single GPU and offload to the CPU with the methods below.",ze,ps,_n='<li><a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> only works on a single GPU but a very large model may not fit on it</li> <li><a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> may work but it is extremely slow and also limited to a single GPU</li>',He,rs,In='Use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.reset_device_map">reset_device_map()</a> method to reset the <code>device_map</code>. This is necessary if you want to use methods like <code>.to()</code>, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, and <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on a pipeline that was device-mapped.',Ee,cs,Se,ms,Fe,ds,xn="VAE slicing saves memory by splitting large batches of inputs into a single batch of data and separately processing them. This method works best when generating more than one image at a time.",Ae,Ms,Gn="For example, if you’re generating 4 images at once, decoding would increase peak activation memory by 4x. VAE slicing reduces this by only decoding 1 image at a time instead of all 4 images at once.",Le,us,vn='Call <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline.enable_vae_slicing">enable_vae_slicing()</a> to enable sliced VAE. You can expect a small increase in performance when decoding multi-image batches and no performance impact for single-image batches.',qe,ys,De,B,Cn='<p>The <a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a> and <a href="/docs/diffusers/main/en/api/models/asymmetricautoencoderkl#diffusers.AsymmetricAutoencoderKL">AsymmetricAutoencoderKL</a> classes don’t support slicing.</p>',Pe,fs,Ke,Js,Wn="VAE tiling saves memory by dividing an image into smaller overlapping tiles instead of processing the entire image at once. This also reduces peak memory usage because the GPU is only processing a tile at a time.",Oe,hs,kn='Call <a href="/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline.enable_vae_tiling">enable_vae_tiling()</a> to enable VAE tiling. The generated image may have some tone variation from tile-to-tile because they’re decoded separately, but there shouldn’t be any obvious seams between the tiles. Tiling is disabled for resolutions lower than a pre-specified (but configurable) limit. For example, this limit is 512x512 for the VAE in <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>.',sl,bs,el,js,Bn='<p>[!WARNING][AutoencoderKLWan](/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan) and <a href="/docs/diffusers/main/en/api/models/asymmetricautoencoderkl#diffusers.AsymmetricAutoencoderKL">AsymmetricAutoencoderKL</a> don’t support tiling.</p>',ll,ws,nl,Ts,Vn="Offloading strategies move not currently active layers or models to the CPU to avoid increasing GPU memory. These strategies can be combined with quantization and torch.compile to balance inference speed and memory usage.",al,Us,Xn='Refer to the <a href="./speed-memory-optims">Compile and offloading quantized models</a> guide for more details.',tl,Zs,il,gs,Nn="CPU offloading selectively moves weights from the GPU to the CPU. When a component is required, it is transferred to the GPU and when it isn’t required, it is moved to the CPU. This method works on submodules rather than whole models. It saves memory by avoiding storing the entire model on the GPU.",ol,_s,Yn="CPU offloading dramatically reduces memory usage, but it is also <strong>extremely slow</strong> because submodules are passed back and forth multiple times between devices. It can often be impractical due to how slow it is.",pl,V,$n='<p>Don’t move the pipeline to CUDA before calling <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, otherwise the amount of memory saved is only minimal (refer to this <a href="https://github.com/huggingface/diffusers/issues/1934" rel="nofollow">issue</a> for more details). This is a stateful operation that installs hooks on the model.</p>',rl,Is,Qn='Call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> to enable it on a pipeline.',cl,xs,ml,Gs,dl,vs,Rn='Model offloading moves entire models to the GPU instead of selectively moving <em>some</em> layers or model components. One of the main pipeline models, usually the text encoder, UNet, and VAE, is placed on the GPU while the other components are held on the CPU. Components like the UNet that run multiple times stays on the GPU until its completely finished and no longer needed. This eliminates the communication overhead of <a href="#cpu-offloading">CPU offloading</a> and makes model offloading a faster alternative. The tradeoff is memory savings won’t be as large.',Ml,X,zn='<p>Keep in mind that if models are reused outside the pipeline after hookes have been installed (see <a href="https://huggingface.co/docs/accelerate/en/package_reference/big_modeling#accelerate.hooks.remove_hook_from_module" rel="nofollow">Removing Hooks</a> for more details), you need to run the entire pipeline and models in the expected order to properly offload them. This is a stateful operation that installs hooks on the model.</p>',ul,Cs,Hn='Call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> to enable it on a pipeline.',yl,Ws,fl,ks,En='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> also helps when you’re using the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline.encode_prompt">encode_prompt()</a> method on its own to generate the text encoders hidden state.',Jl,Bs,hl,Vs,Sn='Group offloading moves groups of internal layers (<a href="https://pytorch.org/docs/stable/generated/torch.nn.ModuleList.html" rel="nofollow">torch.nn.ModuleList</a> or <a href="https://pytorch.org/docs/stable/generated/torch.nn.Sequential.html" rel="nofollow">torch.nn.Sequential</a>) to the CPU. It uses less memory than <a href="#model-offloading">model offloading</a> and it is faster than <a href="#cpu-offloading">CPU offloading</a> because it reduces communication overhead.',bl,N,Fn="<p>Group offloading may not work with all models if the forward implementation contains weight-dependent device casting of inputs because it may clash with group offloading’s device casting mechanism.</p>",jl,Xs,An="Enable group offloading by configuring the <code>offload_type</code> parameter to <code>block_level</code> or <code>leaf_level</code>.",wl,Ns,Ln='<li><code>block_level</code> offloads groups of layers based on the <code>num_blocks_per_group</code> parameter. For example, if <code>num_blocks_per_group=2</code> on a model with 40 layers, 2 layers are onloaded and offloaded at a time (20 total onloads/offloads). This drastically reduces memory requirements.</li> <li><code>leaf_level</code> offloads individual layers at the lowest level and is equivalent to <a href="#cpu-offloading">CPU offloading</a>. But it can be made faster if you use streams without giving up inference speed.</li>',Tl,Ys,qn="Group offloading is supported for entire pipelines or individual models. Applying group offloading to the entire pipeline is the easiest option while selectively applying it to individual models gives users more flexibility to use different offloading techniques for different models.",Ul,Y,Zl,$s,gl,Qs,Dn='The <code>use_stream</code> parameter can be activated for CUDA devices that support asynchronous data transfer streams to reduce overall execution time compared to <a href="#cpu-offloading">CPU offloading</a>. It overlaps data transfer and computation by using layer prefetching. The next layer to be executed is loaded onto the GPU while the current layer is still being executed. It can increase CPU memory significantly so ensure you have 2x the amount of memory as the model size.',_l,Rs,Pn='Set <code>record_stream=True</code> for more of a speedup at the cost of slightly increased memory usage. Refer to the <a href="https://pytorch.org/docs/stable/generated/torch.Tensor.record_stream.html" rel="nofollow">torch.Tensor.record_stream</a> docs to learn more.',Il,$,Kn="<p>When <code>use_stream=True</code> on VAEs with tiling enabled, make sure to do a dummy forward pass (possible with dummy inputs as well) before inference to avoid device mismatch errors. This may not work on all implementations, so feel free to open an issue if you encounter any problems.</p>",xl,zs,On="If you’re using <code>block_level</code> group offloading with <code>use_stream</code> enabled, the <code>num_blocks_per_group</code> parameter should be set to <code>1</code>, otherwise a warning will be raised.",Gl,Hs,vl,Es,sa="The <code>low_cpu_mem_usage</code> parameter can be set to <code>True</code> to reduce CPU memory usage when using streams during group offloading. It is best for <code>leaf_level</code> offloading and when CPU memory is bottlenecked. Memory is saved by creating pinned tensors on the fly instead of pre-pinning them. However, this may increase overall execution time.",Cl,Ss,Wl,Fs,ea="Group offloading can consume significant system memory depending on the model size. On systems with limited memory, try group offloading onto the disk as a secondary memory.",kl,As,la='Set the <code>offload_to_disk_path</code> argument in either <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_group_offload">enable_group_offload()</a> or <a href="/docs/diffusers/main/en/api/utilities#diffusers.hooks.apply_group_offloading">apply_group_offloading()</a> to offload the model to the disk.',Bl,Ls,Vl,qs,na='Refer to these <a href="https://github.com/huggingface/diffusers/pull/11682#issue-3129365363" rel="nofollow">two</a> <a href="https://github.com/huggingface/diffusers/pull/11682#issuecomment-2955715126" rel="nofollow">tables</a> to compare the speed and memory trade-offs.',Xl,Ds,Nl,Q,aa='<p>Combine layerwise casting with <a href="#group-offloading">group offloading</a> for even more memory savings.</p>',Yl,Ps,ta="Layerwise casting stores weights in a smaller data format (for example, <code>torch.float8_e4m3fn</code> and <code>torch.float8_e5m2</code>) to use less memory and upcasts those weights to a higher precision like <code>torch.float16</code> or <code>torch.bfloat16</code> for computation. Certain layers (normalization and modulation related weights) are skipped because storing them in fp8 can degrade generation quality.",$l,R,ia='<p>Layerwise casting may not work with all models if the forward implementation contains internal typecasting of weights. The current implementation of layerwise casting assumes the forward pass is independent of the weight precision and the input datatypes are always specified in <code>compute_dtype</code> (see <a href="https://github.com/huggingface/transformers/blob/7f5077e53682ca855afc826162b204ebf809f1f9/src/transformers/models/t5/modeling_t5.py#L294-L299" rel="nofollow">here</a> for an incompatible implementation).</p> <p>Layerwise casting may also fail on custom modeling implementations with <a href="https://huggingface.co/docs/peft/index" rel="nofollow">PEFT</a> layers. There are some checks available but they are not extensively tested or guaranteed to work in all cases.</p>',Ql,Ks,oa='Call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_layerwise_casting">enable_layerwise_casting()</a> to set the storage and computation datatypes.',Rl,Os,zl,se,pa='The <a href="/docs/diffusers/main/en/api/utilities#diffusers.hooks.apply_layerwise_casting">apply_layerwise_casting()</a> method can also be used if you need more control and flexibility. It can be partially applied to model layers by calling it on specific internal modules. Use the <code>skip_modules_pattern</code> or <code>skip_modules_classes</code> parameters to specify modules to avoid, such as the normalization and modulation layers.',Hl,ee,El,le,Sl,ne,ra='<a href="https://pytorch.org/tutorials/intermediate/memory_format_tutorial.html" rel="nofollow">torch.channels_last</a> flips how tensors are stored from <code>(batch size, channels, height, width)</code> to <code>(batch size, heigh, width, channels)</code>. This aligns the tensors with how the hardware sequentially accesses the tensors stored in memory and avoids skipping around in memory to access the pixel values.',Fl,ae,ca="Not all operators currently support the channels-last format and may result in worst performance, but it is still worth trying.",Al,te,Ll,ie,ql,oe,ma='<a href="https://pytorch.org/docs/stable/generated/torch.jit.trace.html" rel="nofollow">torch.jit.trace</a> records the operations a model performs on a sample input and creates a new, optimized representation of the model based on the recorded execution path. During tracing, the model is optimized to reduce overhead from Python and dynamic control flows and operations are fused together for more efficiency. The returned executable or <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptFunction.html" rel="nofollow">ScriptFunction</a> can be compiled.',Dl,pe,Pl,re,da="Replace the pipeline’s UNet with the traced version.",Kl,ce,Ol,me,sn,z,Ma='<p>Memory-efficient attention optimizes for memory usage <em>and</em> <a href="./fp16#scaled-dot-product-attention">inference speed</a>!</p>',en,de,ua="The Transformers attention mechanism is memory-intensive, especially for long sequences, so you can try using different and more memory-efficient attention types.",ln,Me,ya='By default, if PyTorch &gt;= 2.0 is installed, <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">scaled dot-product attention (SDPA)</a> is used. You don’t need to make any additional changes to your code.',nn,ue,fa='SDPA supports <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a> and <a href="https://github.com/facebookresearch/xformers" rel="nofollow">xFormers</a> as well as a native C++ PyTorch implementation. It automatically selects the most optimal implementation based on your input.',an,ye,Ja='You can explicitly use xFormers with the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> method.',tn,fe,on,Je,ha='Call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.disable_xformers_memory_efficient_attention">disable_xformers_memory_efficient_attention()</a> to disable it.',pn,he,rn,be,cn,je,mn;return p=new x({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h1"}}),H=new x({props:{title:"Multiple GPUs",local:"multiple-gpus",headingTag:"h2"}}),S=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYWNjZWxlcmF0ZQ==",highlighted:"pip install -U accelerate",wrap:!1}}),F=new x({props:{title:"Sharded checkpoints",local:"sharded-checkpoints",headingTag:"h3"}}),q=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQXVuZXQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIlMEEpJTBBdW5ldC5zYXZlX3ByZXRyYWluZWQoJTIyc2R4bC11bmV0LXNoYXJkZWQlMjIlMkMlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjVHQiUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel

unet = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>
)
unet.save_pretrained(<span class="hljs-string">&quot;sdxl-unet-sharded&quot;</span>, max_shard_size=<span class="hljs-string">&quot;5GB&quot;</span>)`,wrap:!1}}),P=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXVuZXQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnVzZXJuYW1lJTJGc2R4bC11bmV0LXNoYXJkZWQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmV0JTNEdW5ldCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, StableDiffusionXLPipeline

unet = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;username/sdxl-unet-sharded&quot;</span>, torch_dtype=torch.float16
)
pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    unet=unet,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),K=new x({props:{title:"Device placement",local:"device-placement",headingTag:"h3"}}),k=new Ta({props:{id:"device-map",options:["pipeline level","model level"],$$slots:{default:[Wa]},$$scope:{ctx:G}}}),ls=new U({props:{code:"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",highlighted:`<span class="hljs-built_in">print</span>(transformer.hf_device_map)
{<span class="hljs-string">&#x27;pos_embed&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;time_text_embed&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;context_embedder&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;x_embedder&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;transformer_blocks&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.0&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.1&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.2&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.3&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.4&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.5&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.6&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.7&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.8&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.9&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.10&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.11&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.12&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.13&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.14&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.15&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.16&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.17&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.18&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.19&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.20&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.21&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.22&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.23&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.24&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.25&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.26&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.27&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.28&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.29&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.30&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.31&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.32&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.33&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.34&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.35&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.36&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.37&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;norm_out&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;proj_out&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>}`,wrap:!1}}),as=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel

device_map = {
    <span class="hljs-string">&#x27;pos_embed&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;time_text_embed&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;context_embedder&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;x_embedder&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;transformer_blocks&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.0&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.1&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.2&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.3&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.4&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.5&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.6&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.7&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.8&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.9&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;single_transformer_blocks.10&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;single_transformer_blocks.11&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;single_transformer_blocks.12&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;single_transformer_blocks.13&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;single_transformer_blocks.14&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;single_transformer_blocks.15&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;single_transformer_blocks.16&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;single_transformer_blocks.17&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;single_transformer_blocks.18&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;single_transformer_blocks.19&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;single_transformer_blocks.20&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;single_transformer_blocks.21&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.22&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.23&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.24&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.25&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.26&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.27&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.28&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.29&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.30&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.31&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.32&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.33&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.34&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.35&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.36&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;single_transformer_blocks.37&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;norm_out&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>, <span class="hljs-string">&#x27;proj_out&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>
}

transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, 
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    device_map=device_map,
    torch_dtype=torch.bfloat16
)`,wrap:!1}}),is=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1heF9tZW1vcnklMjAlM0QlMjAlN0IwJTNBJTIyMUdCJTIyJTJDJTIwMSUzQSUyMjFHQiUyMiU3RCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X21lbW9yeSUzRG1heF9tZW1vcnklMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, StableDiffusionXLPipeline

max_memory = {<span class="hljs-number">0</span>:<span class="hljs-string">&quot;1GB&quot;</span>, <span class="hljs-number">1</span>:<span class="hljs-string">&quot;1GB&quot;</span>}
pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
    max_memory=max_memory
)`,wrap:!1}}),cs=new U({props:{code:"cGlwZWxpbmUucmVzZXRfZGV2aWNlX21hcCgp",highlighted:"pipeline.reset_device_map()",wrap:!1}}),ms=new x({props:{title:"VAE slicing",local:"vae-slicing",headingTag:"h2"}}),ys=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV92YWVfc2xpY2luZygpJTBBcGlwZWxpbmUoJTVCJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyME1hcnMlMjIlNUQqMzIpLmltYWdlcyU1QjAlNUQlMEFwcmludChmJTIyTWF4JTIwbWVtb3J5JTIwcmVzZXJ2ZWQlM0ElMjAlN0J0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCklMjAlMkYlMjAxMDI0KiozJTNBLjJmJTdEJTIwR0IlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_vae_slicing()
pipeline([<span class="hljs-string">&quot;An astronaut riding a horse on Mars&quot;</span>]*<span class="hljs-number">32</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),fs=new x({props:{title:"VAE tiling",local:"vae-tiling",headingTag:"h2"}}),bs=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5lbmFibGVfdmFlX3RpbGluZygpJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW1nMmltZy1zZHhsLWluaXQucG5nJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFwaXBlbGluZShwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBzdHJlbmd0aCUzRDAuNSkuaW1hZ2VzJTVCMCU1RCUwQXByaW50KGYlMjJNYXglMjBtZW1vcnklMjByZXNlcnZlZCUzQSUyMCU3QnRvcmNoLmN1ZGEubWF4X21lbW9yeV9hbGxvY2F0ZWQoKSUyMCUyRiUyMDEwMjQqKjMlM0EuMmYlN0QlMjBHQiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_vae_tiling()

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl-init.png&quot;</span>)
prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.5</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),ws=new x({props:{title:"Offloading",local:"offloading",headingTag:"h2"}}),Zs=new x({props:{title:"CPU offloading",local:"cpu-offloading",headingTag:"h3"}}),xs=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1zY2huZWxsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEFwaXBlbGluZS5lbmFibGVfc2VxdWVudGlhbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyME1hcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAuJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMzYwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxdWVuY2VfbGVuZ3RoJTNEMjU2JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBcHJpbnQoZiUyMk1heCUyMG1lbW9yeSUyMHJlc2VydmVkJTNBJTIwJTdCdG9yY2guY3VkYS5tYXhfbWVtb3J5X2FsbG9jYXRlZCgpJTIwJTJGJTIwMTAyNCoqMyUzQS4yZiU3RCUyMEdCJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16
)
pipeline.enable_sequential_cpu_offload()

pipeline(
    prompt=<span class="hljs-string">&quot;An astronaut riding a horse on Mars&quot;</span>,
    guidance_scale=<span class="hljs-number">0.</span>,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">1360</span>,
    num_inference_steps=<span class="hljs-number">4</span>,
    max_sequence_length=<span class="hljs-number">256</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),Gs=new x({props:{title:"Model offloading",local:"model-offloading",headingTag:"h3"}}),Ws=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1zY2huZWxsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBNYXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwLiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTM2MCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDI1NiUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQXByaW50KGYlMjJNYXglMjBtZW1vcnklMjByZXNlcnZlZCUzQSUyMCU3QnRvcmNoLmN1ZGEubWF4X21lbW9yeV9hbGxvY2F0ZWQoKSUyMCUyRiUyMDEwMjQqKjMlM0EuMmYlN0QlMjBHQiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16
)
pipeline.enable_model_cpu_offload()

pipeline(
    prompt=<span class="hljs-string">&quot;An astronaut riding a horse on Mars&quot;</span>,
    guidance_scale=<span class="hljs-number">0.</span>,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">1360</span>,
    num_inference_steps=<span class="hljs-number">4</span>,
    max_sequence_length=<span class="hljs-number">256</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),Bs=new x({props:{title:"Group offloading",local:"group-offloading",headingTag:"h3"}}),Y=new Ta({props:{id:"group-offloading",options:["pipeline","model"],$$slots:{default:[Va]},$$scope:{ctx:G}}}),$s=new x({props:{title:"CUDA stream",local:"cuda-stream",headingTag:"h4"}}),Hs=new U({props:{code:"cGlwZWxpbmUudHJhbnNmb3JtZXIuZW5hYmxlX2dyb3VwX29mZmxvYWQob25sb2FkX2RldmljZSUzRG9ubG9hZF9kZXZpY2UlMkMlMjBvZmZsb2FkX2RldmljZSUzRG9mZmxvYWRfZGV2aWNlJTJDJTIwb2ZmbG9hZF90eXBlJTNEJTIybGVhZl9sZXZlbCUyMiUyQyUyMHVzZV9zdHJlYW0lM0RUcnVlJTJDJTIwcmVjb3JkX3N0cmVhbSUzRFRydWUp",highlighted:'pipeline.transformer.enable_group_offload(onload_device=onload_device, offload_device=offload_device, offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>, use_stream=<span class="hljs-literal">True</span>, record_stream=<span class="hljs-literal">True</span>)',wrap:!1}}),Ss=new x({props:{title:"Offloading to disk",local:"offloading-to-disk",headingTag:"h4"}}),Ls=new U({props:{code:"cGlwZWxpbmUudHJhbnNmb3JtZXIuZW5hYmxlX2dyb3VwX29mZmxvYWQob25sb2FkX2RldmljZSUzRG9ubG9hZF9kZXZpY2UlMkMlMjBvZmZsb2FkX2RldmljZSUzRG9mZmxvYWRfZGV2aWNlJTJDJTIwb2ZmbG9hZF90eXBlJTNEJTIybGVhZl9sZXZlbCUyMiUyQyUyMG9mZmxvYWRfdG9fZGlza19wYXRoJTNEJTIycGF0aCUyRnRvJTJGZGlzayUyMiklMEElMEFhcHBseV9ncm91cF9vZmZsb2FkaW5nKHBpcGVsaW5lLnRleHRfZW5jb2RlciUyQyUyMG9ubG9hZF9kZXZpY2UlM0RvbmxvYWRfZGV2aWNlJTJDJTIwb2ZmbG9hZF90eXBlJTNEJTIyYmxvY2tfbGV2ZWwlMjIlMkMlMjBudW1fYmxvY2tzX3Blcl9ncm91cCUzRDIlMkMlMjBvZmZsb2FkX3RvX2Rpc2tfcGF0aCUzRCUyMnBhdGglMkZ0byUyRmRpc2slMjIp",highlighted:`pipeline.transformer.enable_group_offload(onload_device=onload_device, offload_device=offload_device, offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>, offload_to_disk_path=<span class="hljs-string">&quot;path/to/disk&quot;</span>)

apply_group_offloading(pipeline.text_encoder, onload_device=onload_device, offload_type=<span class="hljs-string">&quot;block_level&quot;</span>, num_blocks_per_group=<span class="hljs-number">2</span>, offload_to_disk_path=<span class="hljs-string">&quot;path/to/disk&quot;</span>)`,wrap:!1}}),Ds=new x({props:{title:"Layerwise casting",local:"layerwise-casting",headingTag:"h2"}}),Os=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline, CogVideoXTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

transformer = CogVideoXTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    torch_dtype=torch.bfloat16
)
transformer.enable_layerwise_casting(storage_dtype=torch.float8_e4m3fn, compute_dtype=torch.bfloat16)

pipeline = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = (
    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
)
video = pipeline(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),ee=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YVHJhbnNmb3JtZXIzRE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy5ob29rcyUyMGltcG9ydCUyMGFwcGx5X2xheWVyd2lzZV9jYXN0aW5nJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBDb2dWaWRlb1hUcmFuc2Zvcm1lcjNETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTViJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQSUyMyUyMHNraXAlMjB0aGUlMjBub3JtYWxpemF0aW9uJTIwbGF5ZXIlMEFhcHBseV9sYXllcndpc2VfY2FzdGluZyglMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lciUyQyUwQSUyMCUyMCUyMCUyMHN0b3JhZ2VfZHR5cGUlM0R0b3JjaC5mbG9hdDhfZTRtM2ZuJTJDJTBBJTIwJTIwJTIwJTIwY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwc2tpcF9tb2R1bGVzX2NsYXNzZXMlM0QlNUIlMjJub3JtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbm9uX2Jsb2NraW5nJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.hooks <span class="hljs-keyword">import</span> apply_layerwise_casting

transformer = CogVideoXTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    torch_dtype=torch.bfloat16
)

<span class="hljs-comment"># skip the normalization layer</span>
apply_layerwise_casting(
    transformer,
    storage_dtype=torch.float8_e4m3fn,
    compute_dtype=torch.bfloat16,
    skip_modules_classes=[<span class="hljs-string">&quot;norm&quot;</span>],
    non_blocking=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),le=new x({props:{title:"torch.channels_last",local:"torchchannelslast",headingTag:"h2"}}),te=new U({props:{code:"cHJpbnQocGlwZWxpbmUudW5ldC5jb252X291dC5zdGF0ZV9kaWN0KCklNUIlMjJ3ZWlnaHQlMjIlNUQuc3RyaWRlKCkpJTIwJTIwJTIzJTIwKDI4ODAlMkMlMjA5JTJDJTIwMyUyQyUyMDEpJTBBcGlwZWxpbmUudW5ldC50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMjAlMjAlMjMlMjBpbi1wbGFjZSUyMG9wZXJhdGlvbiUwQXByaW50KCUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lLnVuZXQuY29udl9vdXQuc3RhdGVfZGljdCgpJTVCJTIyd2VpZ2h0JTIyJTVELnN0cmlkZSgpJTBBKSUyMCUyMCUyMyUyMCgyODgwJTJDJTIwMSUyQyUyMDk2MCUyQyUyMDMyMCklMjBoYXZpbmclMjBhJTIwc3RyaWRlJTIwb2YlMjAxJTIwZm9yJTIwdGhlJTIwMm5kJTIwZGltZW5zaW9uJTIwcHJvdmVzJTIwdGhhdCUyMGl0JTIwd29ya3M=",highlighted:`<span class="hljs-built_in">print</span>(pipeline.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride())  <span class="hljs-comment"># (2880, 9, 3, 1)</span>
pipeline.unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># in-place operation</span>
<span class="hljs-built_in">print</span>(
    pipeline.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride()
)  <span class="hljs-comment"># (2880, 1, 960, 320) having a stride of 1 for the 2nd dimension proves that it works</span>`,wrap:!1}}),ie=new x({props:{title:"torch.jit.trace",local:"torchjittrace",headingTag:"h2"}}),pe=new U({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwZnVuY3Rvb2xzJTBBJTBBJTIzJTIwdG9yY2glMjBkaXNhYmxlJTIwZ3JhZCUwQXRvcmNoLnNldF9ncmFkX2VuYWJsZWQoRmFsc2UpJTBBJTBBJTIzJTIwc2V0JTIwdmFyaWFibGVzJTBBbl9leHBlcmltZW50cyUyMCUzRCUyMDIlMEF1bmV0X3J1bnNfcGVyX2V4cGVyaW1lbnQlMjAlM0QlMjA1MCUwQSUwQSUyMyUyMGxvYWQlMjBzYW1wbGUlMjBpbnB1dHMlMEFkZWYlMjBnZW5lcmF0ZV9pbnB1dHMoKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMHRvcmNoLnJhbmRuKCgyJTJDJTIwNCUyQyUyMDY0JTJDJTIwNjQpJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUyMiUyQyUyMGR0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMjAlMjAlMjAlMjB0aW1lc3RlcCUyMCUzRCUyMHRvcmNoLnJhbmQoMSUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTIwKiUyMDk5OSUwQSUyMCUyMCUyMCUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMHRvcmNoLnJhbmRuKCgyJTJDJTIwNzclMkMlMjA3NjgpJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUyMiUyQyUyMGR0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzYW1wbGUlMkMlMjB0aW1lc3RlcCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUwQSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBdW5ldCUyMCUzRCUyMHBpcGVsaW5lLnVuZXQlMEF1bmV0LmV2YWwoKSUwQXVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTIwJTIwJTIzJTIwdXNlJTIwY2hhbm5lbHNfbGFzdCUyMG1lbW9yeSUyMGZvcm1hdCUwQXVuZXQuZm9yd2FyZCUyMCUzRCUyMGZ1bmN0b29scy5wYXJ0aWFsKHVuZXQuZm9yd2FyZCUyQyUyMHJldHVybl9kaWN0JTNERmFsc2UpJTIwJTIwJTIzJTIwc2V0JTIwcmV0dXJuX2RpY3QlM0RGYWxzZSUyMGFzJTIwZGVmYXVsdCUwQSUwQSUyMyUyMHdhcm11cCUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDMpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBnZW5lcmF0ZV9pbnB1dHMoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9yaWdfb3V0cHV0JTIwJTNEJTIwdW5ldCgqaW5wdXRzKSUwQSUwQSUyMyUyMHRyYWNlJTBBcHJpbnQoJTIydHJhY2luZy4uJTIyKSUwQXVuZXRfdHJhY2VkJTIwJTNEJTIwdG9yY2guaml0LnRyYWNlKHVuZXQlMkMlMjBpbnB1dHMpJTBBdW5ldF90cmFjZWQuZXZhbCgpJTBBcHJpbnQoJTIyZG9uZSUyMHRyYWNpbmclMjIpJTBBJTBBJTIzJTIwd2FybXVwJTIwYW5kJTIwb3B0aW1pemUlMjBncmFwaCUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDUpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBnZW5lcmF0ZV9pbnB1dHMoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9yaWdfb3V0cHV0JTIwJTNEJTIwdW5ldF90cmFjZWQoKmlucHV0cyklMEElMEElMjMlMjBiZW5jaG1hcmtpbmclMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMF8lMjBpbiUyMHJhbmdlKG5fZXhwZXJpbWVudHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5zeW5jaHJvbml6ZSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhcnRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwXyUyMGluJTIwcmFuZ2UodW5ldF9ydW5zX3Blcl9leHBlcmltZW50KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9yaWdfb3V0cHV0JTIwJTNEJTIwdW5ldF90cmFjZWQoKmlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3JjaC5jdWRhLnN5bmNocm9uaXplKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIydW5ldCUyMHRyYWNlZCUyMGluZmVyZW5jZSUyMHRvb2slMjAlN0J0aW1lLnRpbWUoKSUyMC0lMjBzdGFydF90aW1lJTNBLjJmJTdEJTIwc2Vjb25kcyUyMiklMEElMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZShuX2V4cGVyaW1lbnRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLmN1ZGEuc3luY2hyb25pemUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXJ0X3RpbWUlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMF8lMjBpbiUyMHJhbmdlKHVuZXRfcnVuc19wZXJfZXhwZXJpbWVudCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcmlnX291dHB1dCUyMCUzRCUyMHVuZXQoKmlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3JjaC5jdWRhLnN5bmNocm9uaXplKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIydW5ldCUyMGluZmVyZW5jZSUyMHRvb2slMjAlN0J0aW1lLnRpbWUoKSUyMC0lMjBzdGFydF90aW1lJTNBLjJmJTdEJTIwc2Vjb25kcyUyMiklMEElMEElMjMlMjBzYXZlJTIwdGhlJTIwbW9kZWwlMEF1bmV0X3RyYWNlZC5zYXZlKCUyMnVuZXRfdHJhY2VkLnB0JTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> functools

<span class="hljs-comment"># torch disable grad</span>
torch.set_grad_enabled(<span class="hljs-literal">False</span>)

<span class="hljs-comment"># set variables</span>
n_experiments = <span class="hljs-number">2</span>
unet_runs_per_experiment = <span class="hljs-number">50</span>

<span class="hljs-comment"># load sample inputs</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_inputs</span>():
    sample = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    timestep = torch.rand(<span class="hljs-number">1</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16) * <span class="hljs-number">999</span>
    encoder_hidden_states = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">77</span>, <span class="hljs-number">768</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    <span class="hljs-keyword">return</span> sample, timestep, encoder_hidden_states


pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
unet = pipeline.unet
unet.<span class="hljs-built_in">eval</span>()
unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># use channels_last memory format</span>
unet.forward = functools.partial(unet.forward, return_dict=<span class="hljs-literal">False</span>)  <span class="hljs-comment"># set return_dict=False as default</span>

<span class="hljs-comment"># warmup</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet(*inputs)

<span class="hljs-comment"># trace</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;tracing..&quot;</span>)
unet_traced = torch.jit.trace(unet, inputs)
unet_traced.<span class="hljs-built_in">eval</span>()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;done tracing&quot;</span>)

<span class="hljs-comment"># warmup and optimize graph</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet_traced(*inputs)

<span class="hljs-comment"># benchmarking</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet_traced(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet traced inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)

<span class="hljs-comment"># save the model</span>
unet_traced.save(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)`,wrap:!1}}),ce=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVOZXQyRENvbmRpdGlvbk91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUzQSUyMHRvcmNoLlRlbnNvciUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwdXNlJTIwaml0dGVkJTIwdW5ldCUwQXVuZXRfdHJhY2VkJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydW5ldF90cmFjZWQucHQlMjIpJTBBJTBBJTIzJTIwZGVsJTIwcGlwZWxpbmUudW5ldCUwQWNsYXNzJTIwVHJhY2VkVU5ldCh0b3JjaC5ubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmluX2NoYW5uZWxzJTIwJTNEJTIwcGlwZS51bmV0LmNvbmZpZy5pbl9jaGFubmVscyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZGV2aWNlJTIwJTNEJTIwcGlwZS51bmV0LmRldmljZSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHQlMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2FtcGxlJTIwJTNEJTIwdW5ldF90cmFjZWQobGF0ZW50X21vZGVsX2lucHV0JTJDJTIwdCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyklNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwVU5ldDJEQ29uZGl0aW9uT3V0cHV0KHNhbXBsZSUzRHNhbXBsZSklMEElMEFwaXBlbGluZS51bmV0JTIwJTNEJTIwVHJhY2VkVU5ldCgpJTBBJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGUoJTVCcHJvbXB0JTVEJTIwKiUyMDElMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass

<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">UNet2DConditionOutput</span>:
    sample: torch.Tensor

pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># use jitted unet</span>
unet_traced = torch.jit.load(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)

<span class="hljs-comment"># del pipeline.unet</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TracedUNet</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.in_channels = pipe.unet.config.in_channels
        self.device = pipe.unet.device

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, latent_model_input, t, encoder_hidden_states</span>):
        sample = unet_traced(latent_model_input, t, encoder_hidden_states)[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">return</span> UNet2DConditionOutput(sample=sample)

pipeline.unet = TracedUNet()

<span class="hljs-keyword">with</span> torch.inference_mode():
    image = pipe([prompt] * <span class="hljs-number">1</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),me=new x({props:{title:"Memory-efficient attention",local:"memory-efficient-attention",headingTag:"h2"}}),fe=new U({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHhmb3JtZXJzJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-comment"># pip install xformers</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_xformers_memory_efficient_attention()`,wrap:!1}}),he=new U({props:{code:"cGlwZWxpbmUuZGlzYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:"pipeline.disable_xformers_memory_efficient_attention()",wrap:!1}}),be=new Ga({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/memory.md"}}),{c(){m=i("meta"),T=a(),j=i("p"),b=a(),M(p.$$.fragment),r=a(),w=i("p"),w.innerHTML=_,Z=a(),I=i("p"),I.textContent=d,g=a(),C=i("blockquote"),C.innerHTML=un,we=a(),M(H.$$.fragment),Te=a(),E=i("p"),E.innerHTML=yn,Ue=a(),M(S.$$.fragment),Ze=a(),M(F.$$.fragment),ge=a(),A=i("p"),A.textContent=fn,_e=a(),L=i("p"),L.innerHTML=Jn,Ie=a(),M(q.$$.fragment),xe=a(),D=i("p"),D.textContent=hn,Ge=a(),M(P.$$.fragment),ve=a(),M(K.$$.fragment),Ce=a(),W=i("blockquote"),W.innerHTML=bn,We=a(),O=i("p"),O.innerHTML=jn,ke=a(),M(k.$$.fragment),Be=a(),ss=i("p"),ss.innerHTML=wn,Ve=a(),es=i("p"),es.innerHTML=Tn,Xe=a(),M(ls.$$.fragment),Ne=a(),ns=i("p"),ns.innerHTML=Un,Ye=a(),M(as.$$.fragment),$e=a(),ts=i("p"),ts.innerHTML=Zn,Qe=a(),M(is.$$.fragment),Re=a(),os=i("p"),os.textContent=gn,ze=a(),ps=i("ul"),ps.innerHTML=_n,He=a(),rs=i("p"),rs.innerHTML=In,Ee=a(),M(cs.$$.fragment),Se=a(),M(ms.$$.fragment),Fe=a(),ds=i("p"),ds.textContent=xn,Ae=a(),Ms=i("p"),Ms.textContent=Gn,Le=a(),us=i("p"),us.innerHTML=vn,qe=a(),M(ys.$$.fragment),De=a(),B=i("blockquote"),B.innerHTML=Cn,Pe=a(),M(fs.$$.fragment),Ke=a(),Js=i("p"),Js.textContent=Wn,Oe=a(),hs=i("p"),hs.innerHTML=kn,sl=a(),M(bs.$$.fragment),el=a(),js=i("blockquote"),js.innerHTML=Bn,ll=a(),M(ws.$$.fragment),nl=a(),Ts=i("p"),Ts.textContent=Vn,al=a(),Us=i("p"),Us.innerHTML=Xn,tl=a(),M(Zs.$$.fragment),il=a(),gs=i("p"),gs.textContent=Nn,ol=a(),_s=i("p"),_s.innerHTML=Yn,pl=a(),V=i("blockquote"),V.innerHTML=$n,rl=a(),Is=i("p"),Is.innerHTML=Qn,cl=a(),M(xs.$$.fragment),ml=a(),M(Gs.$$.fragment),dl=a(),vs=i("p"),vs.innerHTML=Rn,Ml=a(),X=i("blockquote"),X.innerHTML=zn,ul=a(),Cs=i("p"),Cs.innerHTML=Hn,yl=a(),M(Ws.$$.fragment),fl=a(),ks=i("p"),ks.innerHTML=En,Jl=a(),M(Bs.$$.fragment),hl=a(),Vs=i("p"),Vs.innerHTML=Sn,bl=a(),N=i("blockquote"),N.innerHTML=Fn,jl=a(),Xs=i("p"),Xs.innerHTML=An,wl=a(),Ns=i("ul"),Ns.innerHTML=Ln,Tl=a(),Ys=i("p"),Ys.textContent=qn,Ul=a(),M(Y.$$.fragment),Zl=a(),M($s.$$.fragment),gl=a(),Qs=i("p"),Qs.innerHTML=Dn,_l=a(),Rs=i("p"),Rs.innerHTML=Pn,Il=a(),$=i("blockquote"),$.innerHTML=Kn,xl=a(),zs=i("p"),zs.innerHTML=On,Gl=a(),M(Hs.$$.fragment),vl=a(),Es=i("p"),Es.innerHTML=sa,Cl=a(),M(Ss.$$.fragment),Wl=a(),Fs=i("p"),Fs.textContent=ea,kl=a(),As=i("p"),As.innerHTML=la,Bl=a(),M(Ls.$$.fragment),Vl=a(),qs=i("p"),qs.innerHTML=na,Xl=a(),M(Ds.$$.fragment),Nl=a(),Q=i("blockquote"),Q.innerHTML=aa,Yl=a(),Ps=i("p"),Ps.innerHTML=ta,$l=a(),R=i("blockquote"),R.innerHTML=ia,Ql=a(),Ks=i("p"),Ks.innerHTML=oa,Rl=a(),M(Os.$$.fragment),zl=a(),se=i("p"),se.innerHTML=pa,Hl=a(),M(ee.$$.fragment),El=a(),M(le.$$.fragment),Sl=a(),ne=i("p"),ne.innerHTML=ra,Fl=a(),ae=i("p"),ae.textContent=ca,Al=a(),M(te.$$.fragment),Ll=a(),M(ie.$$.fragment),ql=a(),oe=i("p"),oe.innerHTML=ma,Dl=a(),M(pe.$$.fragment),Pl=a(),re=i("p"),re.textContent=da,Kl=a(),M(ce.$$.fragment),Ol=a(),M(me.$$.fragment),sn=a(),z=i("blockquote"),z.innerHTML=Ma,en=a(),de=i("p"),de.textContent=ua,ln=a(),Me=i("p"),Me.innerHTML=ya,nn=a(),ue=i("p"),ue.innerHTML=fa,an=a(),ye=i("p"),ye.innerHTML=Ja,tn=a(),M(fe.$$.fragment),on=a(),Je=i("p"),Je.innerHTML=ha,pn=a(),M(he.$$.fragment),rn=a(),M(be.$$.fragment),cn=a(),je=i("p"),this.h()},l(s){const e=Ia("svelte-u9bgzb",document.head);m=o(e,"META",{name:!0,content:!0}),e.forEach(l),T=t(s),j=o(s,"P",{}),wa(j).forEach(l),b=t(s),u(p.$$.fragment,s),r=t(s),w=o(s,"P",{"data-svelte-h":!0}),c(w)!=="svelte-11rtgo9"&&(w.innerHTML=_),Z=t(s),I=o(s,"P",{"data-svelte-h":!0}),c(I)!=="svelte-vxpcfq"&&(I.textContent=d),g=t(s),C=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(C)!=="svelte-13f2072"&&(C.innerHTML=un),we=t(s),u(H.$$.fragment,s),Te=t(s),E=o(s,"P",{"data-svelte-h":!0}),c(E)!=="svelte-646d08"&&(E.innerHTML=yn),Ue=t(s),u(S.$$.fragment,s),Ze=t(s),u(F.$$.fragment,s),ge=t(s),A=o(s,"P",{"data-svelte-h":!0}),c(A)!=="svelte-z6beln"&&(A.textContent=fn),_e=t(s),L=o(s,"P",{"data-svelte-h":!0}),c(L)!=="svelte-115ttl4"&&(L.innerHTML=Jn),Ie=t(s),u(q.$$.fragment,s),xe=t(s),D=o(s,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1f9wrc7"&&(D.textContent=hn),Ge=t(s),u(P.$$.fragment,s),ve=t(s),u(K.$$.fragment,s),Ce=t(s),W=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(W)!=="svelte-1wauenq"&&(W.innerHTML=bn),We=t(s),O=o(s,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1n4q4np"&&(O.innerHTML=jn),ke=t(s),u(k.$$.fragment,s),Be=t(s),ss=o(s,"P",{"data-svelte-h":!0}),c(ss)!=="svelte-2a94z6"&&(ss.innerHTML=wn),Ve=t(s),es=o(s,"P",{"data-svelte-h":!0}),c(es)!=="svelte-c7w8iz"&&(es.innerHTML=Tn),Xe=t(s),u(ls.$$.fragment,s),Ne=t(s),ns=o(s,"P",{"data-svelte-h":!0}),c(ns)!=="svelte-1ut2jly"&&(ns.innerHTML=Un),Ye=t(s),u(as.$$.fragment,s),$e=t(s),ts=o(s,"P",{"data-svelte-h":!0}),c(ts)!=="svelte-1oxgib7"&&(ts.innerHTML=Zn),Qe=t(s),u(is.$$.fragment,s),Re=t(s),os=o(s,"P",{"data-svelte-h":!0}),c(os)!=="svelte-whoqae"&&(os.textContent=gn),ze=t(s),ps=o(s,"UL",{"data-svelte-h":!0}),c(ps)!=="svelte-5cwvqn"&&(ps.innerHTML=_n),He=t(s),rs=o(s,"P",{"data-svelte-h":!0}),c(rs)!=="svelte-6e1s7a"&&(rs.innerHTML=In),Ee=t(s),u(cs.$$.fragment,s),Se=t(s),u(ms.$$.fragment,s),Fe=t(s),ds=o(s,"P",{"data-svelte-h":!0}),c(ds)!=="svelte-d36gg7"&&(ds.textContent=xn),Ae=t(s),Ms=o(s,"P",{"data-svelte-h":!0}),c(Ms)!=="svelte-5ay0zr"&&(Ms.textContent=Gn),Le=t(s),us=o(s,"P",{"data-svelte-h":!0}),c(us)!=="svelte-jm20t4"&&(us.innerHTML=vn),qe=t(s),u(ys.$$.fragment,s),De=t(s),B=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(B)!=="svelte-y65jzc"&&(B.innerHTML=Cn),Pe=t(s),u(fs.$$.fragment,s),Ke=t(s),Js=o(s,"P",{"data-svelte-h":!0}),c(Js)!=="svelte-vsq5zh"&&(Js.textContent=Wn),Oe=t(s),hs=o(s,"P",{"data-svelte-h":!0}),c(hs)!=="svelte-a79yk8"&&(hs.innerHTML=kn),sl=t(s),u(bs.$$.fragment,s),el=t(s),js=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),c(js)!=="svelte-1ch13xh"&&(js.innerHTML=Bn),ll=t(s),u(ws.$$.fragment,s),nl=t(s),Ts=o(s,"P",{"data-svelte-h":!0}),c(Ts)!=="svelte-1lghmz8"&&(Ts.textContent=Vn),al=t(s),Us=o(s,"P",{"data-svelte-h":!0}),c(Us)!=="svelte-sey8xy"&&(Us.innerHTML=Xn),tl=t(s),u(Zs.$$.fragment,s),il=t(s),gs=o(s,"P",{"data-svelte-h":!0}),c(gs)!=="svelte-nwk8qi"&&(gs.textContent=Nn),ol=t(s),_s=o(s,"P",{"data-svelte-h":!0}),c(_s)!=="svelte-1jssif2"&&(_s.innerHTML=Yn),pl=t(s),V=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(V)!=="svelte-13dgwz1"&&(V.innerHTML=$n),rl=t(s),Is=o(s,"P",{"data-svelte-h":!0}),c(Is)!=="svelte-vdp76n"&&(Is.innerHTML=Qn),cl=t(s),u(xs.$$.fragment,s),ml=t(s),u(Gs.$$.fragment,s),dl=t(s),vs=o(s,"P",{"data-svelte-h":!0}),c(vs)!=="svelte-lwbzkf"&&(vs.innerHTML=Rn),Ml=t(s),X=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(X)!=="svelte-1u2javr"&&(X.innerHTML=zn),ul=t(s),Cs=o(s,"P",{"data-svelte-h":!0}),c(Cs)!=="svelte-t552fb"&&(Cs.innerHTML=Hn),yl=t(s),u(Ws.$$.fragment,s),fl=t(s),ks=o(s,"P",{"data-svelte-h":!0}),c(ks)!=="svelte-1ic7r11"&&(ks.innerHTML=En),Jl=t(s),u(Bs.$$.fragment,s),hl=t(s),Vs=o(s,"P",{"data-svelte-h":!0}),c(Vs)!=="svelte-6x5rs4"&&(Vs.innerHTML=Sn),bl=t(s),N=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(N)!=="svelte-16e328k"&&(N.innerHTML=Fn),jl=t(s),Xs=o(s,"P",{"data-svelte-h":!0}),c(Xs)!=="svelte-pp820p"&&(Xs.innerHTML=An),wl=t(s),Ns=o(s,"UL",{"data-svelte-h":!0}),c(Ns)!=="svelte-8dkla6"&&(Ns.innerHTML=Ln),Tl=t(s),Ys=o(s,"P",{"data-svelte-h":!0}),c(Ys)!=="svelte-axmnvs"&&(Ys.textContent=qn),Ul=t(s),u(Y.$$.fragment,s),Zl=t(s),u($s.$$.fragment,s),gl=t(s),Qs=o(s,"P",{"data-svelte-h":!0}),c(Qs)!=="svelte-1ik3m1u"&&(Qs.innerHTML=Dn),_l=t(s),Rs=o(s,"P",{"data-svelte-h":!0}),c(Rs)!=="svelte-f4wc5s"&&(Rs.innerHTML=Pn),Il=t(s),$=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c($)!=="svelte-yvi407"&&($.innerHTML=Kn),xl=t(s),zs=o(s,"P",{"data-svelte-h":!0}),c(zs)!=="svelte-17oamma"&&(zs.innerHTML=On),Gl=t(s),u(Hs.$$.fragment,s),vl=t(s),Es=o(s,"P",{"data-svelte-h":!0}),c(Es)!=="svelte-1ixqgvf"&&(Es.innerHTML=sa),Cl=t(s),u(Ss.$$.fragment,s),Wl=t(s),Fs=o(s,"P",{"data-svelte-h":!0}),c(Fs)!=="svelte-mq1z2c"&&(Fs.textContent=ea),kl=t(s),As=o(s,"P",{"data-svelte-h":!0}),c(As)!=="svelte-1p1tymo"&&(As.innerHTML=la),Bl=t(s),u(Ls.$$.fragment,s),Vl=t(s),qs=o(s,"P",{"data-svelte-h":!0}),c(qs)!=="svelte-1ugmkgt"&&(qs.innerHTML=na),Xl=t(s),u(Ds.$$.fragment,s),Nl=t(s),Q=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(Q)!=="svelte-ebjnol"&&(Q.innerHTML=aa),Yl=t(s),Ps=o(s,"P",{"data-svelte-h":!0}),c(Ps)!=="svelte-1boiobn"&&(Ps.innerHTML=ta),$l=t(s),R=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(R)!=="svelte-vsu53i"&&(R.innerHTML=ia),Ql=t(s),Ks=o(s,"P",{"data-svelte-h":!0}),c(Ks)!=="svelte-19ytv0"&&(Ks.innerHTML=oa),Rl=t(s),u(Os.$$.fragment,s),zl=t(s),se=o(s,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1hmx68j"&&(se.innerHTML=pa),Hl=t(s),u(ee.$$.fragment,s),El=t(s),u(le.$$.fragment,s),Sl=t(s),ne=o(s,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1tu261v"&&(ne.innerHTML=ra),Fl=t(s),ae=o(s,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-dfwok5"&&(ae.textContent=ca),Al=t(s),u(te.$$.fragment,s),Ll=t(s),u(ie.$$.fragment,s),ql=t(s),oe=o(s,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-15jhfav"&&(oe.innerHTML=ma),Dl=t(s),u(pe.$$.fragment,s),Pl=t(s),re=o(s,"P",{"data-svelte-h":!0}),c(re)!=="svelte-16t9h37"&&(re.textContent=da),Kl=t(s),u(ce.$$.fragment,s),Ol=t(s),u(me.$$.fragment,s),sn=t(s),z=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(z)!=="svelte-xvud2b"&&(z.innerHTML=Ma),en=t(s),de=o(s,"P",{"data-svelte-h":!0}),c(de)!=="svelte-8q1sue"&&(de.textContent=ua),ln=t(s),Me=o(s,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-1idpc42"&&(Me.innerHTML=ya),nn=t(s),ue=o(s,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-4p44md"&&(ue.innerHTML=fa),an=t(s),ye=o(s,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-u62ci7"&&(ye.innerHTML=Ja),tn=t(s),u(fe.$$.fragment,s),on=t(s),Je=o(s,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-p2p9rw"&&(Je.innerHTML=ha),pn=t(s),u(he.$$.fragment,s),rn=t(s),u(be.$$.fragment,s),cn=t(s),je=o(s,"P",{}),wa(je).forEach(l),this.h()},h(){v(m,"name","hf:doc:metadata"),v(m,"content",Na),v(C,"class","tip"),v(W,"class","warning"),v(B,"class","warning"),v(V,"class","warning"),v(X,"class","warning"),v(N,"class","warning"),v($,"class","tip"),v(Q,"class","tip"),v(R,"class","warning"),v(z,"class","tip")},m(s,e){xa(document.head,m),n(s,T,e),n(s,j,e),n(s,b,e),y(p,s,e),n(s,r,e),n(s,w,e),n(s,Z,e),n(s,I,e),n(s,g,e),n(s,C,e),n(s,we,e),y(H,s,e),n(s,Te,e),n(s,E,e),n(s,Ue,e),y(S,s,e),n(s,Ze,e),y(F,s,e),n(s,ge,e),n(s,A,e),n(s,_e,e),n(s,L,e),n(s,Ie,e),y(q,s,e),n(s,xe,e),n(s,D,e),n(s,Ge,e),y(P,s,e),n(s,ve,e),y(K,s,e),n(s,Ce,e),n(s,W,e),n(s,We,e),n(s,O,e),n(s,ke,e),y(k,s,e),n(s,Be,e),n(s,ss,e),n(s,Ve,e),n(s,es,e),n(s,Xe,e),y(ls,s,e),n(s,Ne,e),n(s,ns,e),n(s,Ye,e),y(as,s,e),n(s,$e,e),n(s,ts,e),n(s,Qe,e),y(is,s,e),n(s,Re,e),n(s,os,e),n(s,ze,e),n(s,ps,e),n(s,He,e),n(s,rs,e),n(s,Ee,e),y(cs,s,e),n(s,Se,e),y(ms,s,e),n(s,Fe,e),n(s,ds,e),n(s,Ae,e),n(s,Ms,e),n(s,Le,e),n(s,us,e),n(s,qe,e),y(ys,s,e),n(s,De,e),n(s,B,e),n(s,Pe,e),y(fs,s,e),n(s,Ke,e),n(s,Js,e),n(s,Oe,e),n(s,hs,e),n(s,sl,e),y(bs,s,e),n(s,el,e),n(s,js,e),n(s,ll,e),y(ws,s,e),n(s,nl,e),n(s,Ts,e),n(s,al,e),n(s,Us,e),n(s,tl,e),y(Zs,s,e),n(s,il,e),n(s,gs,e),n(s,ol,e),n(s,_s,e),n(s,pl,e),n(s,V,e),n(s,rl,e),n(s,Is,e),n(s,cl,e),y(xs,s,e),n(s,ml,e),y(Gs,s,e),n(s,dl,e),n(s,vs,e),n(s,Ml,e),n(s,X,e),n(s,ul,e),n(s,Cs,e),n(s,yl,e),y(Ws,s,e),n(s,fl,e),n(s,ks,e),n(s,Jl,e),y(Bs,s,e),n(s,hl,e),n(s,Vs,e),n(s,bl,e),n(s,N,e),n(s,jl,e),n(s,Xs,e),n(s,wl,e),n(s,Ns,e),n(s,Tl,e),n(s,Ys,e),n(s,Ul,e),y(Y,s,e),n(s,Zl,e),y($s,s,e),n(s,gl,e),n(s,Qs,e),n(s,_l,e),n(s,Rs,e),n(s,Il,e),n(s,$,e),n(s,xl,e),n(s,zs,e),n(s,Gl,e),y(Hs,s,e),n(s,vl,e),n(s,Es,e),n(s,Cl,e),y(Ss,s,e),n(s,Wl,e),n(s,Fs,e),n(s,kl,e),n(s,As,e),n(s,Bl,e),y(Ls,s,e),n(s,Vl,e),n(s,qs,e),n(s,Xl,e),y(Ds,s,e),n(s,Nl,e),n(s,Q,e),n(s,Yl,e),n(s,Ps,e),n(s,$l,e),n(s,R,e),n(s,Ql,e),n(s,Ks,e),n(s,Rl,e),y(Os,s,e),n(s,zl,e),n(s,se,e),n(s,Hl,e),y(ee,s,e),n(s,El,e),y(le,s,e),n(s,Sl,e),n(s,ne,e),n(s,Fl,e),n(s,ae,e),n(s,Al,e),y(te,s,e),n(s,Ll,e),y(ie,s,e),n(s,ql,e),n(s,oe,e),n(s,Dl,e),y(pe,s,e),n(s,Pl,e),n(s,re,e),n(s,Kl,e),y(ce,s,e),n(s,Ol,e),y(me,s,e),n(s,sn,e),n(s,z,e),n(s,en,e),n(s,de,e),n(s,ln,e),n(s,Me,e),n(s,nn,e),n(s,ue,e),n(s,an,e),n(s,ye,e),n(s,tn,e),y(fe,s,e),n(s,on,e),n(s,Je,e),n(s,pn,e),y(he,s,e),n(s,rn,e),y(be,s,e),n(s,cn,e),n(s,je,e),mn=!0},p(s,[e]){const ba={};e&2&&(ba.$$scope={dirty:e,ctx:s}),k.$set(ba);const ja={};e&2&&(ja.$$scope={dirty:e,ctx:s}),Y.$set(ja)},i(s){mn||(f(p.$$.fragment,s),f(H.$$.fragment,s),f(S.$$.fragment,s),f(F.$$.fragment,s),f(q.$$.fragment,s),f(P.$$.fragment,s),f(K.$$.fragment,s),f(k.$$.fragment,s),f(ls.$$.fragment,s),f(as.$$.fragment,s),f(is.$$.fragment,s),f(cs.$$.fragment,s),f(ms.$$.fragment,s),f(ys.$$.fragment,s),f(fs.$$.fragment,s),f(bs.$$.fragment,s),f(ws.$$.fragment,s),f(Zs.$$.fragment,s),f(xs.$$.fragment,s),f(Gs.$$.fragment,s),f(Ws.$$.fragment,s),f(Bs.$$.fragment,s),f(Y.$$.fragment,s),f($s.$$.fragment,s),f(Hs.$$.fragment,s),f(Ss.$$.fragment,s),f(Ls.$$.fragment,s),f(Ds.$$.fragment,s),f(Os.$$.fragment,s),f(ee.$$.fragment,s),f(le.$$.fragment,s),f(te.$$.fragment,s),f(ie.$$.fragment,s),f(pe.$$.fragment,s),f(ce.$$.fragment,s),f(me.$$.fragment,s),f(fe.$$.fragment,s),f(he.$$.fragment,s),f(be.$$.fragment,s),mn=!0)},o(s){J(p.$$.fragment,s),J(H.$$.fragment,s),J(S.$$.fragment,s),J(F.$$.fragment,s),J(q.$$.fragment,s),J(P.$$.fragment,s),J(K.$$.fragment,s),J(k.$$.fragment,s),J(ls.$$.fragment,s),J(as.$$.fragment,s),J(is.$$.fragment,s),J(cs.$$.fragment,s),J(ms.$$.fragment,s),J(ys.$$.fragment,s),J(fs.$$.fragment,s),J(bs.$$.fragment,s),J(ws.$$.fragment,s),J(Zs.$$.fragment,s),J(xs.$$.fragment,s),J(Gs.$$.fragment,s),J(Ws.$$.fragment,s),J(Bs.$$.fragment,s),J(Y.$$.fragment,s),J($s.$$.fragment,s),J(Hs.$$.fragment,s),J(Ss.$$.fragment,s),J(Ls.$$.fragment,s),J(Ds.$$.fragment,s),J(Os.$$.fragment,s),J(ee.$$.fragment,s),J(le.$$.fragment,s),J(te.$$.fragment,s),J(ie.$$.fragment,s),J(pe.$$.fragment,s),J(ce.$$.fragment,s),J(me.$$.fragment,s),J(fe.$$.fragment,s),J(he.$$.fragment,s),J(be.$$.fragment,s),mn=!1},d(s){s&&(l(T),l(j),l(b),l(r),l(w),l(Z),l(I),l(g),l(C),l(we),l(Te),l(E),l(Ue),l(Ze),l(ge),l(A),l(_e),l(L),l(Ie),l(xe),l(D),l(Ge),l(ve),l(Ce),l(W),l(We),l(O),l(ke),l(Be),l(ss),l(Ve),l(es),l(Xe),l(Ne),l(ns),l(Ye),l($e),l(ts),l(Qe),l(Re),l(os),l(ze),l(ps),l(He),l(rs),l(Ee),l(Se),l(Fe),l(ds),l(Ae),l(Ms),l(Le),l(us),l(qe),l(De),l(B),l(Pe),l(Ke),l(Js),l(Oe),l(hs),l(sl),l(el),l(js),l(ll),l(nl),l(Ts),l(al),l(Us),l(tl),l(il),l(gs),l(ol),l(_s),l(pl),l(V),l(rl),l(Is),l(cl),l(ml),l(dl),l(vs),l(Ml),l(X),l(ul),l(Cs),l(yl),l(fl),l(ks),l(Jl),l(hl),l(Vs),l(bl),l(N),l(jl),l(Xs),l(wl),l(Ns),l(Tl),l(Ys),l(Ul),l(Zl),l(gl),l(Qs),l(_l),l(Rs),l(Il),l($),l(xl),l(zs),l(Gl),l(vl),l(Es),l(Cl),l(Wl),l(Fs),l(kl),l(As),l(Bl),l(Vl),l(qs),l(Xl),l(Nl),l(Q),l(Yl),l(Ps),l($l),l(R),l(Ql),l(Ks),l(Rl),l(zl),l(se),l(Hl),l(El),l(Sl),l(ne),l(Fl),l(ae),l(Al),l(Ll),l(ql),l(oe),l(Dl),l(Pl),l(re),l(Kl),l(Ol),l(sn),l(z),l(en),l(de),l(ln),l(Me),l(nn),l(ue),l(an),l(ye),l(tn),l(on),l(Je),l(pn),l(rn),l(cn),l(je)),l(m),h(p,s),h(H,s),h(S,s),h(F,s),h(q,s),h(P,s),h(K,s),h(k,s),h(ls,s),h(as,s),h(is,s),h(cs,s),h(ms,s),h(ys,s),h(fs,s),h(bs,s),h(ws,s),h(Zs,s),h(xs,s),h(Gs,s),h(Ws,s),h(Bs,s),h(Y,s),h($s,s),h(Hs,s),h(Ss,s),h(Ls,s),h(Ds,s),h(Os,s),h(ee,s),h(le,s),h(te,s),h(ie,s),h(pe,s),h(ce,s),h(me,s),h(fe,s),h(he,s),h(be,s)}}}const Na='{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[{"title":"Multiple GPUs","local":"multiple-gpus","sections":[{"title":"Sharded checkpoints","local":"sharded-checkpoints","sections":[],"depth":3},{"title":"Device placement","local":"device-placement","sections":[],"depth":3}],"depth":2},{"title":"VAE slicing","local":"vae-slicing","sections":[],"depth":2},{"title":"VAE tiling","local":"vae-tiling","sections":[],"depth":2},{"title":"Offloading","local":"offloading","sections":[{"title":"CPU offloading","local":"cpu-offloading","sections":[],"depth":3},{"title":"Model offloading","local":"model-offloading","sections":[],"depth":3},{"title":"Group offloading","local":"group-offloading","sections":[{"title":"CUDA stream","local":"cuda-stream","sections":[],"depth":4},{"title":"Offloading to disk","local":"offloading-to-disk","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Layerwise casting","local":"layerwise-casting","sections":[],"depth":2},{"title":"torch.channels_last","local":"torchchannelslast","sections":[],"depth":2},{"title":"torch.jit.trace","local":"torchjittrace","sections":[],"depth":2},{"title":"Memory-efficient attention","local":"memory-efficient-attention","sections":[],"depth":2}],"depth":1}';function Ya(G){return Za(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ea extends ga{constructor(m){super(),_a(this,m,Ya,Xa,Ua,{})}}export{Ea as component};
