import{s as ai,n as ii,o as ni}from"../chunks/scheduler.888833de.js";import{S as pi,i as oi,e as n,s as a,c as r,h as ri,a as p,d as l,b as i,f as si,g as M,j as o,k as y,l as Mi,m as s,n as c,t as m,o as d,p as u}from"../chunks/index.128ce987.js";import{C as h}from"../chunks/CodeBlock.37df032e.js";import{H as jt,E as ci}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function mi(vs){let J,gt,Ut,It,C,Ct,w,_s='<img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/>',Zt,f,Gs=`<p>This document has now grown outdated given the emergence of existing evaluation frameworks for diffusion models for image generation. Please check
out works like <a href="https://crfm.stanford.edu/helm/heim/latest/" rel="nofollow">HEIM</a>, <a href="https://huggingface.co/papers/2307.06350" rel="nofollow">T2I-Compbench</a>,
<a href="https://huggingface.co/papers/2310.11513" rel="nofollow">GenEval</a>.</p>`,Bt,Z,xs='Evaluation of generative models like <a href="https://huggingface.co/docs/diffusers/stable_diffusion" rel="nofollow">Stable Diffusion</a> is subjective in nature. But as practitioners and researchers, we often have to make careful choices amongst many different possibilities. So, when working with different generative models (like GANs, Diffusion, etc.), how do we choose one over the other?',Wt,B,ks=`Qualitative evaluation of such models can be error-prone and might incorrectly influence a decision.
However, quantitative metrics don’t necessarily correspond to image quality. So, usually, a combination
of both qualitative and quantitative evaluations provides a stronger signal when choosing one model
over the other.`,vt,W,Xs="In this document, we provide a non-exhaustive overview of qualitative and quantitative methods to evaluate Diffusion models. For quantitative methods, we specifically focus on how to implement them alongside <code>diffusers</code>.",_t,v,Vs='The methods shown in this document can also be used to evaluate different <a href="https://huggingface.co/docs/diffusers/main/en/api/schedulers/overview" rel="nofollow">noise schedulers</a> keeping the underlying generation model fixed.',Gt,_,xt,G,Rs="We cover Diffusion models with the following pipelines:",kt,x,Hs='<li>Text-guided image generation (such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img" rel="nofollow"><code>StableDiffusionPipeline</code></a>).</li> <li>Text-guided image generation, additionally conditioned on an input image (such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img" rel="nofollow"><code>StableDiffusionImg2ImgPipeline</code></a> and <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/pix2pix" rel="nofollow"><code>StableDiffusionInstructPix2PixPipeline</code></a>).</li> <li>Class-conditioned image generation models (such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/dit" rel="nofollow"><code>DiTPipeline</code></a>).</li>',Xt,k,Vt,X,Fs=`Qualitative evaluation typically involves human assessment of generated images. Quality is measured across aspects such as compositionality, image-text alignment, and spatial relations. Common prompts provide a degree of uniformity for subjective metrics.
DrawBench and PartiPrompts are prompt datasets used for qualitative benchmarking. DrawBench and PartiPrompts were introduced by <a href="https://imagen.research.google/" rel="nofollow">Imagen</a> and <a href="https://parti.research.google/" rel="nofollow">Parti</a> respectively.`,Rt,V,Ns='From the <a href="https://parti.research.google/" rel="nofollow">official Parti website</a>:',Ht,R,Es="<p>PartiPrompts (P2) is a rich set of over 1600 prompts in English that we release as part of this work. P2 can be used to measure model capabilities across various categories and challenge aspects.</p>",Ft,H,Ys='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/parti-prompts.png" alt="parti-prompts"/>',Nt,F,Qs="PartiPrompts has the following columns:",Et,N,As="<li>Prompt</li> <li>Category of the prompt (such as “Abstract”, “World Knowledge”, etc.)</li> <li>Challenge reflecting the difficulty (such as “Basic”, “Complex”, “Writing &amp; Symbols”, etc.)</li>",Yt,E,zs="These benchmarks allow for side-by-side human evaluation of different image generation models.",Qt,Y,Ss="For this, the 🧨 Diffusers team has built <strong>Open Parti Prompts</strong>, which is a community-driven qualitative benchmark based on Parti Prompts to compare state-of-the-art open-source diffusion models:",At,Q,$s='<li><a href="https://huggingface.co/spaces/OpenGenAI/open-parti-prompts" rel="nofollow">Open Parti Prompts Game</a>: For 10 parti prompts, 4 generated images are shown and the user selects the image that suits the prompt best.</li> <li><a href="https://huggingface.co/spaces/OpenGenAI/parti-prompts-leaderboard" rel="nofollow">Open Parti Prompts Leaderboard</a>: The leaderboard comparing the currently best open-sourced diffusion models to each other.</li>',zt,A,Ls="To manually compare images, let’s see how we can use <code>diffusers</code> on a couple of PartiPrompts.",St,z,qs='Below we show some prompts sampled across different challenges: Basic, Complex, Linguistic Structures, Imagination, and Writing &amp; Symbols. Here we are using PartiPrompts as a <a href="https://huggingface.co/datasets/nateraw/parti-prompts" rel="nofollow">dataset</a>.',$t,S,Lt,$,Ps='Now we can use these prompts to generate some images using Stable Diffusion (<a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">v1-4 checkpoint</a>):',qt,L,Pt,q,Ds='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/parti-prompts-14.png" alt="parti-prompts-14"/>',Dt,P,Ks='We can also set <code>num_images_per_prompt</code> accordingly to compare different images for the same prompt. Running the same pipeline but with a different checkpoint (<a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">v1-5</a>), yields:',Kt,D,Os='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/parti-prompts-15.png" alt="parti-prompts-15"/>',Ot,K,ea=`Once several images are generated from all the prompts using multiple models (under evaluation), these results are presented to human evaluators for scoring. For
more details on the DrawBench and PartiPrompts benchmarks, refer to their respective papers.`,el,T,ta=`<p>It is useful to look at some inference samples while a model is training to measure the
training progress. In our <a href="https://github.com/huggingface/diffusers/tree/main/examples/" rel="nofollow">training scripts</a>, we support this utility with additional support for
logging to TensorBoard and Weights &amp; Biases.</p>`,tl,O,ll,ee,la="In this section, we will walk you through how to evaluate three different diffusion pipelines using:",sl,te,sa="<li>CLIP score</li> <li>CLIP directional similarity</li> <li>FID</li>",al,le,il,se,aa='<a href="https://huggingface.co/papers/2104.08718" rel="nofollow">CLIP score</a> measures the compatibility of image-caption pairs. Higher CLIP scores imply higher compatibility 🔼. The CLIP score is a quantitative measurement of the qualitative concept “compatibility”. Image-caption pair compatibility can also be thought of as the semantic similarity between the image and the caption. CLIP score was found to have high correlation with human judgement.',nl,ae,ia='Let’s first load a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>:',pl,ie,ol,ne,na="Generate some images with multiple prompts:",rl,pe,Ml,oe,pa="And then, we calculate the CLIP score.",cl,re,ml,Me,oa="In the above example, we generated one image per prompt. If we generated multiple images per prompt, we would have to take the average score from the generated images per prompt.",dl,ce,ra=`Now, if we wanted to compare two checkpoints compatible with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> we should pass a generator while calling the pipeline. First, we generate images with a
fixed seed with the <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">v1-4 Stable Diffusion checkpoint</a>:`,ul,me,hl,de,Ma='Then we load the <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">v1-5 checkpoint</a> to generate images:',yl,ue,Jl,he,ca="And finally, we compare their CLIP scores:",wl,ye,fl,Je,ma='It seems like the <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">v1-5</a> checkpoint performs better than its predecessor. Note, however, that the number of prompts we used to compute the CLIP scores is quite low. For a more practical evaluation, this number should be way higher, and the prompts should be diverse.',Tl,j,da=`<p>By construction, there are some limitations in this score. The captions in the training dataset
were crawled from the web and extracted from <code>alt</code> and similar tags associated an image on the internet.
They are not necessarily representative of what a human being would use to describe an image. Hence we
had to “engineer” some prompts here.</p>`,jl,we,Ul,fe,ua='In this case, we condition the generation pipeline with an input image as well as a text prompt. Let’s take the <a href="/docs/diffusers/main/en/api/pipelines/pix2pix#diffusers.StableDiffusionInstructPix2PixPipeline">StableDiffusionInstructPix2PixPipeline</a>, as an example. It takes an edit instruction as an input prompt and an input image to be edited.',bl,Te,ha="Here is one example:",gl,je,ya='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/edit-instruction.png" alt="edit-instruction"/>',Il,Ue,Ja='One strategy to evaluate such a model is to measure the consistency of the change between the two images (in <a href="https://huggingface.co/docs/transformers/model_doc/clip" rel="nofollow">CLIP</a> space) with the change between the two image captions (as shown in <a href="https://huggingface.co/papers/2108.00946" rel="nofollow">CLIP-Guided Domain Adaptation of Image Generators</a>). This is referred to as the ”<strong>CLIP directional similarity</strong>“.',Cl,be,wa="<li>Caption 1 corresponds to the input image (image 1) that is to be edited.</li> <li>Caption 2 corresponds to the edited image (image 2). It should reflect the edit instruction.</li>",Zl,ge,fa="Following is a pictorial overview:",Bl,Ie,Ta='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/edit-consistency.png" alt="edit-consistency"/>',Wl,Ce,ja="We have prepared a mini dataset to implement this metric. Let’s first load the dataset.",vl,Ze,_l,Be,Gl,We,Ua="Here we have:",xl,ve,ba="<li><code>input</code> is a caption corresponding to the <code>image</code>.</li> <li><code>edit</code> denotes the edit instruction.</li> <li><code>output</code> denotes the modified caption reflecting the <code>edit</code> instruction.</li>",kl,_e,ga="Let’s take a look at a sample.",Xl,Ge,Vl,xe,Rl,ke,Ia="And here is the image:",Hl,Xe,Fl,Ve,Ca='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/edit-dataset.png" alt="edit-dataset"/>',Nl,Re,Za="We will first edit the images of our dataset with the edit instruction and compute the directional similarity.",El,He,Ba='Let’s first load the <a href="/docs/diffusers/main/en/api/pipelines/pix2pix#diffusers.StableDiffusionInstructPix2PixPipeline">StableDiffusionInstructPix2PixPipeline</a>:',Yl,Fe,Ql,Ne,Wa="Now, we perform the edits:",Al,Ee,zl,Ye,va="To measure the directional similarity, we first load CLIP’s image and text encoders:",Sl,Qe,$l,Ae,_a='Notice that we are using a particular CLIP checkpoint, i.e., <code>openai/clip-vit-large-patch14</code>. This is because the Stable Diffusion pre-training was performed with this CLIP variant. For more details, refer to the <a href="https://huggingface.co/docs/transformers/model_doc/clip" rel="nofollow">documentation</a>.',Ll,ze,Ga="Next, we prepare a PyTorch <code>nn.Module</code> to compute directional similarity:",ql,Se,Pl,$e,xa="Let’s put <code>DirectionalSimilarity</code> to use now.",Dl,Le,Kl,qe,ka="Like the CLIP Score, the higher the CLIP directional similarity, the better it is.",Ol,Pe,Xa="It should be noted that the <code>StableDiffusionInstructPix2PixPipeline</code> exposes two arguments, namely, <code>image_guidance_scale</code> and <code>guidance_scale</code> that let you control the quality of the final edited image. We encourage you to experiment with these two arguments and see the impact of that on the directional similarity.",es,De,Va="We can extend the idea of this metric to measure how similar the original image and edited version are. To do that, we can just do <code>F.cosine_similarity(img_feat_two, img_feat_one)</code>. For these kinds of edits, we would still want the primary semantics of the images to be preserved as much as possible, i.e., a high similarity score.",ts,Ke,Ra='We can use these metrics for similar pipelines such as the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/pix2pix_zero#diffusers.StableDiffusionPix2PixZeroPipeline" rel="nofollow"><code>StableDiffusionPix2PixZeroPipeline</code></a>.',ls,U,Ha="<p>Both CLIP score and CLIP direction similarity rely on the CLIP model, which can make the evaluations biased.</p>",ss,Oe,Fa='<strong><em>Extending metrics like IS, FID (discussed later), or KID can be difficult</em></strong> when the model under evaluation was pre-trained on a large image-captioning dataset (such as the <a href="https://laion.ai/blog/laion-5b/" rel="nofollow">LAION-5B dataset</a>). This is because underlying these metrics is an InceptionNet (pre-trained on the ImageNet-1k dataset) used for extracting intermediate image features. The pre-training dataset of Stable Diffusion may have limited overlap with the pre-training dataset of InceptionNet, so it is not a good candidate here for feature extraction.',as,et,Na='<strong><em>Using the above metrics helps evaluate models that are class-conditioned. For example, <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/dit" rel="nofollow">DiT</a>. It was pre-trained being conditioned on the ImageNet-1k classes.</em></strong>',is,tt,ns,lt,Ea='Class-conditioned generative models are usually pre-trained on a class-labeled dataset such as <a href="https://huggingface.co/datasets/imagenet-1k" rel="nofollow">ImageNet-1k</a>. Popular metrics for evaluating these models include Fréchet Inception Distance (FID), Kernel Inception Distance (KID), and Inception Score (IS). In this document, we focus on FID (<a href="https://huggingface.co/papers/1706.08500" rel="nofollow">Heusel et al.</a>). We show how to compute it with the <a href="https://huggingface.co/docs/diffusers/api/pipelines/dit" rel="nofollow"><code>DiTPipeline</code></a>, which uses the <a href="https://huggingface.co/papers/2212.09748" rel="nofollow">DiT model</a> under the hood.',ps,st,Ya='FID aims to measure how similar are two datasets of images. As per <a href="https://mmgeneration.readthedocs.io/en/latest/quick_run.html#fid" rel="nofollow">this resource</a>:',os,at,Qa="<p>Fréchet Inception Distance is a measure of similarity between two datasets of images. It was shown to correlate well with the human judgment of visual quality and is most often used to evaluate the quality of samples of Generative Adversarial Networks. FID is calculated by computing the Fréchet distance between two Gaussians fitted to feature representations of the Inception network.</p>",rs,it,Aa="These two datasets are essentially the dataset of real images and the dataset of fake images (generated images in our case). FID is usually calculated with two large datasets. However, for this document, we will work with two mini datasets.",Ms,nt,za="Let’s first download a few images from the ImageNet-1k training set:",cs,pt,ms,ot,ds,rt,Sa="These are 10 images from the following ImageNet-1k classes: “cassette_player”, “chain_saw” (x2), “church”, “gas_pump” (x3), “parachute” (x2), and “tench”.",us,b,$a='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/real-images.png" alt="real-images"/><br/> <em>Real images.</em>',hs,Mt,La="Now that the images are loaded, let’s apply some lightweight pre-processing on them to use them for FID calculation.",ys,ct,Js,mt,qa='We now load the <a href="https://huggingface.co/docs/diffusers/api/pipelines/dit" rel="nofollow"><code>DiTPipeline</code></a> to generate images conditioned on the above-mentioned classes.',ws,dt,fs,ut,Pa='Now, we can compute the FID using <a href="https://torchmetrics.readthedocs.io/" rel="nofollow"><code>torchmetrics</code></a>.',Ts,ht,js,yt,Da="The lower the FID, the better it is. Several things can influence FID here:",Us,Jt,Ka="<li>Number of images (both real and fake)</li> <li>Randomness induced in the diffusion process</li> <li>Number of inference steps in the diffusion process</li> <li>The scheduler being used in the diffusion process</li>",bs,wt,Oa="For the last two points, it is, therefore, a good practice to run the evaluation across different seeds and inference steps, and then report an average result.",gs,g,ei=`<p>FID results tend to be fragile as they depend on a lot of factors:</p> <ul><li>The specific Inception model used during computation.</li> <li>The implementation accuracy of the computation.</li> <li>The image format (not the same if we start from PNGs vs JPGs).</li></ul> <p>Keeping that in mind, FID is often most useful when comparing similar runs, but it is
hard to reproduce paper results unless the authors carefully disclose the FID
measurement code.</p> <p>These points apply to other related metrics too, such as KID and IS.</p>`,Is,ft,ti="As a final step, let’s visually inspect the <code>fake_images</code>.",Cs,I,li='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/evaluation_diffusion_models/fake-images.png" alt="fake-images"/><br/> <em>Fake images.</em>',Zs,Tt,Bs,bt,Ws;return C=new jt({props:{title:"Evaluating Diffusion Models",local:"evaluating-diffusion-models",headingTag:"h1"}}),_=new jt({props:{title:"Scenarios",local:"scenarios",headingTag:"h2"}}),k=new jt({props:{title:"Qualitative Evaluation",local:"qualitative-evaluation",headingTag:"h2"}}),S=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwcHJvbXB0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJuYXRlcmF3JTJGcGFydGktcHJvbXB0cyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTIzJTIwcHJvbXB0cyUyMCUzRCUyMHByb21wdHMuc2h1ZmZsZSgpJTBBJTIzJTIwc2FtcGxlX3Byb21wdHMlMjAlM0QlMjAlNUJwcm9tcHRzJTVCaSU1RCU1QiUyMlByb21wdCUyMiU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDUpJTVEJTBBJTBBJTIzJTIwRml4aW5nJTIwdGhlc2UlMjBzYW1wbGUlMjBwcm9tcHRzJTIwaW4lMjB0aGUlMjBpbnRlcmVzdCUyMG9mJTIwcmVwcm9kdWNpYmlsaXR5LiUwQXNhbXBsZV9wcm9tcHRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGNvcmdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGhvdCUyMGFpciUyMGJhbGxvb24lMjB3aXRoJTIwYSUyMHlpbi15YW5nJTIwc3ltYm9sJTJDJTIwd2l0aCUyMHRoZSUyMG1vb24lMjB2aXNpYmxlJTIwaW4lMjB0aGUlMjBkYXl0aW1lJTIwc2t5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGNhciUyMHdpdGglMjBubyUyMHdpbmRvd3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhJTIwY3ViZSUyMG1hZGUlMjBvZiUyMHBvcmN1cGluZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCdUaGUlMjBzYXlpbmclMjAlMjJCRSUyMEVYQ0VMTEVOVCUyMFRPJTIwRUFDSCUyME9USEVSJTIyJTIwd3JpdHRlbiUyMG9uJTIwYSUyMHJlZCUyMGJyaWNrJTIwd2FsbCUyMHdpdGglMjBhJTIwZ3JhZmZpdGklMjBpbWFnZSUyMG9mJTIwYSUyMGdyZWVuJTIwYWxpZW4lMjB3ZWFyaW5nJTIwYSUyMHR1eGVkby4lMjBBJTIweWVsbG93JTIwZmlyZSUyMGh5ZHJhbnQlMjBpcyUyMG9uJTIwYSUyMHNpZGV3YWxrJTIwaW4lMjB0aGUlMjBmb3JlZ3JvdW5kLiclMkMlMEElNUQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># prompts = load_dataset(&quot;nateraw/parti-prompts&quot;, split=&quot;train&quot;)</span>
<span class="hljs-comment"># prompts = prompts.shuffle()</span>
<span class="hljs-comment"># sample_prompts = [prompts[i][&quot;Prompt&quot;] for i in range(5)]</span>

<span class="hljs-comment"># Fixing these sample prompts in the interest of reproducibility.</span>
sample_prompts = [
    <span class="hljs-string">&quot;a corgi&quot;</span>,
    <span class="hljs-string">&quot;a hot air balloon with a yin-yang symbol, with the moon visible in the daytime sky&quot;</span>,
    <span class="hljs-string">&quot;a car with no windows&quot;</span>,
    <span class="hljs-string">&quot;a cube made of porcupine&quot;</span>,
    <span class="hljs-string">&#x27;The saying &quot;BE EXCELLENT TO EACH OTHER&quot; written on a red brick wall with a graffiti image of a green alien wearing a tuxedo. A yellow fire hydrant is on a sidewalk in the foreground.&#x27;</span>,
]`,wrap:!1}}),L=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFzZWVkJTIwJTNEJTIwMCUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKHNlZWQpJTBBJTBBaW1hZ2VzJTIwJTNEJTIwc2RfcGlwZWxpbmUoc2FtcGxlX3Byb21wdHMlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">import</span> torch

seed = <span class="hljs-number">0</span>
generator = torch.manual_seed(seed)

images = sd_pipeline(sample_prompts, num_images_per_prompt=<span class="hljs-number">1</span>, generator=generator).images`,wrap:!1}}),O=new jt({props:{title:"Quantitative Evaluation",local:"quantitative-evaluation",headingTag:"h2"}}),le=new jt({props:{title:"Text-guided image generation",local:"text-guided-image-generation",headingTag:"h3"}}),ie=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9ja3B0JTIwJTNEJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXNkX3BpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NrcHQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_ckpt = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
sd_pipeline = StableDiffusionPipeline.from_pretrained(model_ckpt, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),pe=new h({props:{code:"cHJvbXB0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwaGlnaCUyMHRlY2glMjBzb2xhcnB1bmslMjB1dG9waWElMjBpbiUyMHRoZSUyMEFtYXpvbiUyMHJhaW5mb3Jlc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwcGlrYWNodSUyMGZpbmUlMjBkaW5pbmclMjB3aXRoJTIwYSUyMHZpZXclMjB0byUyMHRoZSUyMEVpZmZlbCUyMFRvd2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMG1lY2hhJTIwcm9ib3QlMjBpbiUyMGElMjBmYXZlbGElMjBpbiUyMGV4cHJlc3Npb25pc3QlMjBzdHlsZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmFuJTIwaW5zZWN0JTIwcm9ib3QlMjBwcmVwYXJpbmclMjBhJTIwZGVsaWNpb3VzJTIwbWVhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBzbWFsbCUyMGNhYmluJTIwb24lMjB0b3AlMjBvZiUyMGElMjBzbm93eSUyMG1vdW50YWluJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwRGlzbmV5JTJDJTIwYXJ0c3RhdGlvbiUyMiUyQyUwQSU1RCUwQSUwQWltYWdlcyUyMCUzRCUyMHNkX3BpcGVsaW5lKHByb21wdHMlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMikuaW1hZ2VzJTBBJTBBcHJpbnQoaW1hZ2VzLnNoYXBlKSUwQSUyMyUyMCg2JTJDJTIwNTEyJTJDJTIwNTEyJTJDJTIwMyk=",highlighted:`prompts = [
    <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>,
    <span class="hljs-string">&quot;A high tech solarpunk utopia in the Amazon rainforest&quot;</span>,
    <span class="hljs-string">&quot;A pikachu fine dining with a view to the Eiffel Tower&quot;</span>,
    <span class="hljs-string">&quot;A mecha robot in a favela in expressionist style&quot;</span>,
    <span class="hljs-string">&quot;an insect robot preparing a delicious meal&quot;</span>,
    <span class="hljs-string">&quot;A small cabin on top of a snowy mountain in the style of Disney, artstation&quot;</span>,
]

images = sd_pipeline(prompts, num_images_per_prompt=<span class="hljs-number">1</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>).images

<span class="hljs-built_in">print</span>(images.shape)
<span class="hljs-comment"># (6, 512, 512, 3)</span>`,wrap:!1}}),re=new h({props:{code:"ZnJvbSUyMHRvcmNobWV0cmljcy5mdW5jdGlvbmFsLm11bHRpbW9kYWwlMjBpbXBvcnQlMjBjbGlwX3Njb3JlJTBBZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEFjbGlwX3Njb3JlX2ZuJTIwJTNEJTIwcGFydGlhbChjbGlwX3Njb3JlJTJDJTIwbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTIyb3BlbmFpJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JTIyKSUwQSUwQWRlZiUyMGNhbGN1bGF0ZV9jbGlwX3Njb3JlKGltYWdlcyUyQyUyMHByb21wdHMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VzX2ludCUyMCUzRCUyMChpbWFnZXMlMjAqJTIwMjU1KS5hc3R5cGUoJTIydWludDglMjIpJTBBJTIwJTIwJTIwJTIwY2xpcF9zY29yZSUyMCUzRCUyMGNsaXBfc2NvcmVfZm4odG9yY2guZnJvbV9udW1weShpbWFnZXNfaW50KS5wZXJtdXRlKDAlMkMlMjAzJTJDJTIwMSUyQyUyMDIpJTJDJTIwcHJvbXB0cykuZGV0YWNoKCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByb3VuZChmbG9hdChjbGlwX3Njb3JlKSUyQyUyMDQpJTBBJTBBc2RfY2xpcF9zY29yZSUyMCUzRCUyMGNhbGN1bGF0ZV9jbGlwX3Njb3JlKGltYWdlcyUyQyUyMHByb21wdHMpJTBBcHJpbnQoZiUyMkNMSVAlMjBzY29yZSUzQSUyMCU3QnNkX2NsaXBfc2NvcmUlN0QlMjIpJTBBJTIzJTIwQ0xJUCUyMHNjb3JlJTNBJTIwMzUuNzAzOA==",highlighted:`<span class="hljs-keyword">from</span> torchmetrics.functional.multimodal <span class="hljs-keyword">import</span> clip_score
<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

clip_score_fn = partial(clip_score, model_name_or_path=<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_clip_score</span>(<span class="hljs-params">images, prompts</span>):
    images_int = (images * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
    clip_score = clip_score_fn(torch.from_numpy(images_int).permute(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>), prompts).detach()
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">round</span>(<span class="hljs-built_in">float</span>(clip_score), <span class="hljs-number">4</span>)

sd_clip_score = calculate_clip_score(images, prompts)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP score: <span class="hljs-subst">{sd_clip_score}</span>&quot;</span>)
<span class="hljs-comment"># CLIP score: 35.7038</span>`,wrap:!1}}),me=new h({props:{code:"c2VlZCUyMCUzRCUyMDAlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZChzZWVkKSUwQSUwQWltYWdlcyUyMCUzRCUyMHNkX3BpcGVsaW5lKHByb21wdHMlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMikuaW1hZ2Vz",highlighted:`seed = <span class="hljs-number">0</span>
generator = torch.manual_seed(seed)

images = sd_pipeline(prompts, num_images_per_prompt=<span class="hljs-number">1</span>, generator=generator, output_type=<span class="hljs-string">&quot;np&quot;</span>).images`,wrap:!1}}),ue=new h({props:{code:"bW9kZWxfY2twdF8xXzUlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFzZF9waXBlbGluZV8xXzUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfY2twdF8xXzUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2VzXzFfNSUyMCUzRCUyMHNkX3BpcGVsaW5lXzFfNShwcm9tcHRzJTJDJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMSUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMG91dHB1dF90eXBlJTNEJTIybnAlMjIpLmltYWdlcw==",highlighted:`model_ckpt_1_5 = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
sd_pipeline_1_5 = StableDiffusionPipeline.from_pretrained(model_ckpt_1_5, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

images_1_5 = sd_pipeline_1_5(prompts, num_images_per_prompt=<span class="hljs-number">1</span>, generator=generator, output_type=<span class="hljs-string">&quot;np&quot;</span>).images`,wrap:!1}}),ye=new h({props:{code:"c2RfY2xpcF9zY29yZV8xXzQlMjAlM0QlMjBjYWxjdWxhdGVfY2xpcF9zY29yZShpbWFnZXMlMkMlMjBwcm9tcHRzKSUwQXByaW50KGYlMjJDTElQJTIwU2NvcmUlMjB3aXRoJTIwdi0xLTQlM0ElMjAlN0JzZF9jbGlwX3Njb3JlXzFfNCU3RCUyMiklMEElMjMlMjBDTElQJTIwU2NvcmUlMjB3aXRoJTIwdi0xLTQlM0ElMjAzNC45MTAyJTBBJTBBc2RfY2xpcF9zY29yZV8xXzUlMjAlM0QlMjBjYWxjdWxhdGVfY2xpcF9zY29yZShpbWFnZXNfMV81JTJDJTIwcHJvbXB0cyklMEFwcmludChmJTIyQ0xJUCUyMFNjb3JlJTIwd2l0aCUyMHYtMS01JTNBJTIwJTdCc2RfY2xpcF9zY29yZV8xXzUlN0QlMjIpJTBBJTIzJTIwQ0xJUCUyMFNjb3JlJTIwd2l0aCUyMHYtMS01JTNBJTIwMzYuMjEzNw==",highlighted:`sd_clip_score_1_4 = calculate_clip_score(images, prompts)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP Score with v-1-4: <span class="hljs-subst">{sd_clip_score_1_4}</span>&quot;</span>)
<span class="hljs-comment"># CLIP Score with v-1-4: 34.9102</span>

sd_clip_score_1_5 = calculate_clip_score(images_1_5, prompts)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP Score with v-1-5: <span class="hljs-subst">{sd_clip_score_1_5}</span>&quot;</span>)
<span class="hljs-comment"># CLIP Score with v-1-5: 36.2137</span>`,wrap:!1}}),we=new jt({props:{title:"Image-conditioned text-to-image generation",local:"image-conditioned-text-to-image-generation",headingTag:"h3"}}),Ze=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzYXlha3BhdWwlMkZpbnN0cnVjdHBpeDJwaXgtZGVtbyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZGF0YXNldC5mZWF0dXJlcw==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;sayakpaul/instructpix2pix-demo&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
dataset.features`,wrap:!1}}),Be=new h({props:{code:"JTdCJ2lucHV0JyUzQSUyMFZhbHVlKGR0eXBlJTNEJ3N0cmluZyclMkMlMjBpZCUzRE5vbmUpJTJDJTBBJTIwJ2VkaXQnJTNBJTIwVmFsdWUoZHR5cGUlM0Qnc3RyaW5nJyUyQyUyMGlkJTNETm9uZSklMkMlMEElMjAnb3V0cHV0JyUzQSUyMFZhbHVlKGR0eXBlJTNEJ3N0cmluZyclMkMlMjBpZCUzRE5vbmUpJTJDJTBBJTIwJ2ltYWdlJyUzQSUyMEltYWdlKGRlY29kZSUzRFRydWUlMkMlMjBpZCUzRE5vbmUpJTdE",highlighted:`{<span class="hljs-string">&#x27;input&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=None),
 <span class="hljs-string">&#x27;edit&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=None),
 <span class="hljs-string">&#x27;output&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=None),
 <span class="hljs-string">&#x27;image&#x27;</span>: Image(decode=True, <span class="hljs-built_in">id</span>=None)}`,wrap:!1}}),Ge=new h({props:{code:"aWR4JTIwJTNEJTIwMCUwQXByaW50KGYlMjJPcmlnaW5hbCUyMGNhcHRpb24lM0ElMjAlN0JkYXRhc2V0JTVCaWR4JTVEJTVCJ2lucHV0JyU1RCU3RCUyMiklMEFwcmludChmJTIyRWRpdCUyMGluc3RydWN0aW9uJTNBJTIwJTdCZGF0YXNldCU1QmlkeCU1RCU1QidlZGl0JyU1RCU3RCUyMiklMEFwcmludChmJTIyTW9kaWZpZWQlMjBjYXB0aW9uJTNBJTIwJTdCZGF0YXNldCU1QmlkeCU1RCU1QidvdXRwdXQnJTVEJTdEJTIyKQ==",highlighted:`idx = <span class="hljs-number">0</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Original caption: <span class="hljs-subst">{dataset[idx][<span class="hljs-string">&#x27;input&#x27;</span>]}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Edit instruction: <span class="hljs-subst">{dataset[idx][<span class="hljs-string">&#x27;edit&#x27;</span>]}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Modified caption: <span class="hljs-subst">{dataset[idx][<span class="hljs-string">&#x27;output&#x27;</span>]}</span>&quot;</span>)`,wrap:!1}}),xe=new h({props:{code:"T3JpZ2luYWwlMjBjYXB0aW9uJTNBJTIwMi4lMjBGQVJPRSUyMElTTEFORFMlM0ElMjBBbiUyMGFyY2hpcGVsYWdvJTIwb2YlMjAxOCUyMG1vdW50YWlub3VzJTIwaXNsZXMlMjBpbiUyMHRoZSUyME5vcnRoJTIwQXRsYW50aWMlMjBPY2VhbiUyMGJldHdlZW4lMjBOb3J3YXklMjBhbmQlMjBJY2VsYW5kJTJDJTIwdGhlJTIwRmFyb2UlMjBJc2xhbmRzJTIwaGFzJTIwJ2V2ZXJ5dGhpbmclMjB5b3UlMjBjb3VsZCUyMGhvcGUlMjBmb3InJTJDJTIwYWNjb3JkaW5nJTIwdG8lMjBCaWclMjA3JTIwVHJhdmVsLiUyMEl0JTIwYm9hc3RzJTIwJ2NyeXN0YWwlMjBjbGVhciUyMHdhdGVyZmFsbHMlMkMlMjByb2NreSUyMGNsaWZmcyUyMHRoYXQlMjBzZWVtJTIwdG8lMjBqdXQlMjBvdXQlMjBvZiUyMG5vd2hlcmUlMjBhbmQlMjB2ZWx2ZXR5JTIwZ3JlZW4lMjBoaWxscyclMEFFZGl0JTIwaW5zdHJ1Y3Rpb24lM0ElMjBtYWtlJTIwdGhlJTIwaXNsZXMlMjBhbGwlMjB3aGl0ZSUyMG1hcmJsZSUwQU1vZGlmaWVkJTIwY2FwdGlvbiUzQSUyMDIuJTIwV0hJVEUlMjBNQVJCTEUlMjBJU0xBTkRTJTNBJTIwQW4lMjBhcmNoaXBlbGFnbyUyMG9mJTIwMTglMjBtb3VudGFpbm91cyUyMHdoaXRlJTIwbWFyYmxlJTIwaXNsZXMlMjBpbiUyMHRoZSUyME5vcnRoJTIwQXRsYW50aWMlMjBPY2VhbiUyMGJldHdlZW4lMjBOb3J3YXklMjBhbmQlMjBJY2VsYW5kJTJDJTIwdGhlJTIwV2hpdGUlMjBNYXJibGUlMjBJc2xhbmRzJTIwaGFzJTIwJ2V2ZXJ5dGhpbmclMjB5b3UlMjBjb3VsZCUyMGhvcGUlMjBmb3InJTJDJTIwYWNjb3JkaW5nJTIwdG8lMjBCaWclMjA3JTIwVHJhdmVsLiUyMEl0JTIwYm9hc3RzJTIwJ2NyeXN0YWwlMjBjbGVhciUyMHdhdGVyZmFsbHMlMkMlMjByb2NreSUyMGNsaWZmcyUyMHRoYXQlMjBzZWVtJTIwdG8lMjBqdXQlMjBvdXQlMjBvZiUyMG5vd2hlcmUlMjBhbmQlMjB2ZWx2ZXR5JTIwZ3JlZW4lMjBoaWxscyc=",highlighted:`Original caption: 2. FAROE ISLANDS: An archipelago of 18 mountainous isles <span class="hljs-keyword">in</span> the North Atlantic Ocean between Norway and Iceland, the Faroe Islands has <span class="hljs-string">&#x27;everything you could hope for&#x27;</span>, according to Big 7 Travel. It boasts <span class="hljs-string">&#x27;crystal clear waterfalls, rocky cliffs that seem to jut out of nowhere and velvety green hills&#x27;</span>
Edit instruction: make the isles all white marble
Modified caption: 2. WHITE MARBLE ISLANDS: An archipelago of 18 mountainous white marble isles <span class="hljs-keyword">in</span> the North Atlantic Ocean between Norway and Iceland, the White Marble Islands has <span class="hljs-string">&#x27;everything you could hope for&#x27;</span>, according to Big 7 Travel. It boasts <span class="hljs-string">&#x27;crystal clear waterfalls, rocky cliffs that seem to jut out of nowhere and velvety green hills&#x27;</span>`,wrap:!1}}),Xe=new h({props:{code:"ZGF0YXNldCU1QmlkeCU1RCU1QiUyMmltYWdlJTIyJTVE",highlighted:'dataset[idx][<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),Fe=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkluc3RydWN0UGl4MlBpeFBpcGVsaW5lJTBBJTBBaW5zdHJ1Y3RfcGl4MnBpeF9waXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkluc3RydWN0UGl4MlBpeFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ0aW1icm9va3MlMkZpbnN0cnVjdC1waXgycGl4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline

instruct_pix2pix_pipeline = StableDiffusionInstructPix2PixPipeline.from_pretrained(
    <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Ee=new h({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwZWRpdF9pbWFnZShpbnB1dF9pbWFnZSUyQyUyMGluc3RydWN0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwaW5zdHJ1Y3RfcGl4MnBpeF9waXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnN0cnVjdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTNEaW5wdXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwKS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2UlMEElMEFpbnB1dF9pbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEFvcmlnaW5hbF9jYXB0aW9ucyUyMCUzRCUyMCU1QiU1RCUwQW1vZGlmaWVkX2NhcHRpb25zJTIwJTNEJTIwJTVCJTVEJTBBZWRpdGVkX2ltYWdlcyUyMCUzRCUyMCU1QiU1RCUwQSUwQWZvciUyMGlkeCUyMGluJTIwcmFuZ2UobGVuKGRhdGFzZXQpKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0X2ltYWdlJTIwJTNEJTIwZGF0YXNldCU1QmlkeCU1RCU1QiUyMmltYWdlJTIyJTVEJTBBJTIwJTIwJTIwJTIwZWRpdF9pbnN0cnVjdGlvbiUyMCUzRCUyMGRhdGFzZXQlNUJpZHglNUQlNUIlMjJlZGl0JTIyJTVEJTBBJTIwJTIwJTIwJTIwZWRpdGVkX2ltYWdlJTIwJTNEJTIwZWRpdF9pbWFnZShpbnB1dF9pbWFnZSUyQyUyMGVkaXRfaW5zdHJ1Y3Rpb24pJTBBJTBBJTIwJTIwJTIwJTIwaW5wdXRfaW1hZ2VzLmFwcGVuZChucC5hcnJheShpbnB1dF9pbWFnZSkpJTBBJTIwJTIwJTIwJTIwb3JpZ2luYWxfY2FwdGlvbnMuYXBwZW5kKGRhdGFzZXQlNUJpZHglNUQlNUIlMjJpbnB1dCUyMiU1RCklMEElMjAlMjAlMjAlMjBtb2RpZmllZF9jYXB0aW9ucy5hcHBlbmQoZGF0YXNldCU1QmlkeCU1RCU1QiUyMm91dHB1dCUyMiU1RCklMEElMjAlMjAlMjAlMjBlZGl0ZWRfaW1hZ2VzLmFwcGVuZChlZGl0ZWRfaW1hZ2Up",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">edit_image</span>(<span class="hljs-params">input_image, instruction</span>):
    image = instruct_pix2pix_pipeline(
        instruction,
        image=input_image,
        output_type=<span class="hljs-string">&quot;np&quot;</span>,
        generator=generator,
    ).images[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> image

input_images = []
original_captions = []
modified_captions = []
edited_images = []

<span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
    input_image = dataset[idx][<span class="hljs-string">&quot;image&quot;</span>]
    edit_instruction = dataset[idx][<span class="hljs-string">&quot;edit&quot;</span>]
    edited_image = edit_image(input_image, edit_instruction)

    input_images.append(np.array(input_image))
    original_captions.append(dataset[idx][<span class="hljs-string">&quot;input&quot;</span>])
    modified_captions.append(dataset[idx][<span class="hljs-string">&quot;output&quot;</span>])
    edited_images.append(edited_image)`,wrap:!1}}),Qe=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBDTElQVG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwQ0xJUFRleHRNb2RlbFdpdGhQcm9qZWN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24lMkMlMEElMjAlMjAlMjAlMjBDTElQSW1hZ2VQcm9jZXNzb3IlMkMlMEEpJTBBJTBBY2xpcF9pZCUyMCUzRCUyMCUyMm9wZW5haSUyRmNsaXAtdml0LWxhcmdlLXBhdGNoMTQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBDTElQVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjbGlwX2lkKSUwQXRleHRfZW5jb2RlciUyMCUzRCUyMENMSVBUZXh0TW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoY2xpcF9pZCkudG8oJTIyY3VkYSUyMiklMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBDTElQSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKGNsaXBfaWQpJTBBaW1hZ2VfZW5jb2RlciUyMCUzRCUyMENMSVBWaXNpb25Nb2RlbFdpdGhQcm9qZWN0aW9uLmZyb21fcHJldHJhaW5lZChjbGlwX2lkKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    CLIPTokenizer,
    CLIPTextModelWithProjection,
    CLIPVisionModelWithProjection,
    CLIPImageProcessor,
)

clip_id = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
tokenizer = CLIPTokenizer.from_pretrained(clip_id)
text_encoder = CLIPTextModelWithProjection.from_pretrained(clip_id).to(<span class="hljs-string">&quot;cuda&quot;</span>)
image_processor = CLIPImageProcessor.from_pretrained(clip_id)
image_encoder = CLIPVisionModelWithProjection.from_pretrained(clip_id).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Se=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F


<span class="hljs-keyword">class</span> <span class="hljs-title class_">DirectionalSimilarity</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, tokenizer, text_encoder, image_processor, image_encoder</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.tokenizer = tokenizer
        self.text_encoder = text_encoder
        self.image_processor = image_processor
        self.image_encoder = image_encoder

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_image</span>(<span class="hljs-params">self, image</span>):
        image = self.image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;pixel_values&quot;</span>]
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: image.to(<span class="hljs-string">&quot;cuda&quot;</span>)}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_text</span>(<span class="hljs-params">self, text</span>):
        inputs = self.tokenizer(
            text,
            max_length=self.tokenizer.model_max_length,
            padding=<span class="hljs-string">&quot;max_length&quot;</span>,
            truncation=<span class="hljs-literal">True</span>,
            return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
        )
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;input_ids&quot;</span>: inputs.input_ids.to(<span class="hljs-string">&quot;cuda&quot;</span>)}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_image</span>(<span class="hljs-params">self, image</span>):
        preprocessed_image = self.preprocess_image(image)
        image_features = self.image_encoder(**preprocessed_image).image_embeds
        image_features = image_features / image_features.norm(dim=<span class="hljs-number">1</span>, keepdim=<span class="hljs-literal">True</span>)
        <span class="hljs-keyword">return</span> image_features

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_text</span>(<span class="hljs-params">self, text</span>):
        tokenized_text = self.tokenize_text(text)
        text_features = self.text_encoder(**tokenized_text).text_embeds
        text_features = text_features / text_features.norm(dim=<span class="hljs-number">1</span>, keepdim=<span class="hljs-literal">True</span>)
        <span class="hljs-keyword">return</span> text_features

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_directional_similarity</span>(<span class="hljs-params">self, img_feat_one, img_feat_two, text_feat_one, text_feat_two</span>):
        sim_direction = F.cosine_similarity(img_feat_two - img_feat_one, text_feat_two - text_feat_one)
        <span class="hljs-keyword">return</span> sim_direction

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, image_one, image_two, caption_one, caption_two</span>):
        img_feat_one = self.encode_image(image_one)
        img_feat_two = self.encode_image(image_two)
        text_feat_one = self.encode_text(caption_one)
        text_feat_two = self.encode_text(caption_two)
        directional_similarity = self.compute_directional_similarity(
            img_feat_one, img_feat_two, text_feat_one, text_feat_two
        )
        <span class="hljs-keyword">return</span> directional_similarity`,wrap:!1}}),Le=new h({props:{code:"ZGlyX3NpbWlsYXJpdHklMjAlM0QlMjBEaXJlY3Rpb25hbFNpbWlsYXJpdHkodG9rZW5pemVyJTJDJTIwdGV4dF9lbmNvZGVyJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTJDJTIwaW1hZ2VfZW5jb2RlciklMEFzY29yZXMlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oaW5wdXRfaW1hZ2VzKSklM0ElMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGlucHV0X2ltYWdlcyU1QmklNUQlMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9jYXB0aW9uJTIwJTNEJTIwb3JpZ2luYWxfY2FwdGlvbnMlNUJpJTVEJTBBJTIwJTIwJTIwJTIwZWRpdGVkX2ltYWdlJTIwJTNEJTIwZWRpdGVkX2ltYWdlcyU1QmklNUQlMEElMjAlMjAlMjAlMjBtb2RpZmllZF9jYXB0aW9uJTIwJTNEJTIwbW9kaWZpZWRfY2FwdGlvbnMlNUJpJTVEJTBBJTBBJTIwJTIwJTIwJTIwc2ltaWxhcml0eV9zY29yZSUyMCUzRCUyMGRpcl9zaW1pbGFyaXR5KG9yaWdpbmFsX2ltYWdlJTJDJTIwZWRpdGVkX2ltYWdlJTJDJTIwb3JpZ2luYWxfY2FwdGlvbiUyQyUyMG1vZGlmaWVkX2NhcHRpb24pJTBBJTIwJTIwJTIwJTIwc2NvcmVzLmFwcGVuZChmbG9hdChzaW1pbGFyaXR5X3Njb3JlLmRldGFjaCgpLmNwdSgpKSklMEElMEFwcmludChmJTIyQ0xJUCUyMGRpcmVjdGlvbmFsJTIwc2ltaWxhcml0eSUzQSUyMCU3Qm5wLm1lYW4oc2NvcmVzKSU3RCUyMiklMEElMjMlMjBDTElQJTIwZGlyZWN0aW9uYWwlMjBzaW1pbGFyaXR5JTNBJTIwMC4wNzk3OTc2NTUzNDQwMDk0",highlighted:`dir_similarity = DirectionalSimilarity(tokenizer, text_encoder, image_processor, image_encoder)
scores = []

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(input_images)):
    original_image = input_images[i]
    original_caption = original_captions[i]
    edited_image = edited_images[i]
    modified_caption = modified_captions[i]

    similarity_score = dir_similarity(original_image, edited_image, original_caption, modified_caption)
    scores.append(<span class="hljs-built_in">float</span>(similarity_score.detach().cpu()))

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CLIP directional similarity: <span class="hljs-subst">{np.mean(scores)}</span>&quot;</span>)
<span class="hljs-comment"># CLIP directional similarity: 0.0797976553440094</span>`,wrap:!1}}),tt=new jt({props:{title:"Class-conditioned image generation",local:"class-conditioned-image-generation",headingTag:"h3"}}),pt=new h({props:{code:"ZnJvbSUyMHppcGZpbGUlMjBpbXBvcnQlMjBaaXBGaWxlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFkZWYlMjBkb3dubG9hZCh1cmwlMkMlMjBsb2NhbF9maWxlcGF0aCklM0ElMEElMjAlMjAlMjAlMjByJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjB3aXRoJTIwb3Blbihsb2NhbF9maWxlcGF0aCUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYud3JpdGUoci5jb250ZW50KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxvY2FsX2ZpbGVwYXRoJTBBJTBBZHVtbXlfZGF0YXNldF91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZzYXlha3BhdWwlMkZzYW1wbGUtZGF0YXNldHMlMkZyZXNvbHZlJTJGbWFpbiUyRnNhbXBsZS1pbWFnZW5ldC1pbWFnZXMuemlwJTIyJTBBbG9jYWxfZmlsZXBhdGglMjAlM0QlMjBkb3dubG9hZChkdW1teV9kYXRhc2V0X3VybCUyQyUyMGR1bW15X2RhdGFzZXRfdXJsLnNwbGl0KCUyMiUyRiUyMiklNUItMSU1RCklMEElMEF3aXRoJTIwWmlwRmlsZShsb2NhbF9maWxlcGF0aCUyQyUyMCUyMnIlMjIpJTIwYXMlMjB6aXBwZXIlM0ElMEElMjAlMjAlMjAlMjB6aXBwZXIuZXh0cmFjdGFsbCglMjIuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> zipfile <span class="hljs-keyword">import</span> ZipFile
<span class="hljs-keyword">import</span> requests


<span class="hljs-keyword">def</span> <span class="hljs-title function_">download</span>(<span class="hljs-params">url, local_filepath</span>):
    r = requests.get(url)
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(local_filepath, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
        f.write(r.content)
    <span class="hljs-keyword">return</span> local_filepath

dummy_dataset_url = <span class="hljs-string">&quot;https://hf.co/datasets/sayakpaul/sample-datasets/resolve/main/sample-imagenet-images.zip&quot;</span>
local_filepath = download(dummy_dataset_url, dummy_dataset_url.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>])

<span class="hljs-keyword">with</span> ZipFile(local_filepath, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> zipper:
    zipper.extractall(<span class="hljs-string">&quot;.&quot;</span>)`,wrap:!1}}),ot=new h({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFkYXRhc2V0X3BhdGglMjAlM0QlMjAlMjJzYW1wbGUtaW1hZ2VuZXQtaW1hZ2VzJTIyJTBBaW1hZ2VfcGF0aHMlMjAlM0QlMjBzb3J0ZWQoJTVCb3MucGF0aC5qb2luKGRhdGFzZXRfcGF0aCUyQyUyMHgpJTIwZm9yJTIweCUyMGluJTIwb3MubGlzdGRpcihkYXRhc2V0X3BhdGgpJTVEKSUwQSUwQXJlYWxfaW1hZ2VzJTIwJTNEJTIwJTVCbnAuYXJyYXkoSW1hZ2Uub3BlbihwYXRoKS5jb252ZXJ0KCUyMlJHQiUyMikpJTIwZm9yJTIwcGF0aCUyMGluJTIwaW1hZ2VfcGF0aHMlNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

dataset_path = <span class="hljs-string">&quot;sample-imagenet-images&quot;</span>
image_paths = <span class="hljs-built_in">sorted</span>([os.path.join(dataset_path, x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> os.listdir(dataset_path)])

real_images = [np.array(Image.<span class="hljs-built_in">open</span>(path).convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> image_paths]`,wrap:!1}}),ct=new h({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBmdW5jdGlvbmFsJTIwYXMlMjBGJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMEFkZWYlMjBwcmVwcm9jZXNzX2ltYWdlKGltYWdlKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwdG9yY2gudGVuc29yKGltYWdlKS51bnNxdWVlemUoMCklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMGltYWdlLnBlcm11dGUoMCUyQyUyMDMlMkMlMjAxJTJDJTIwMiklMjAlMkYlMjAyNTUuMCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMEYuY2VudGVyX2Nyb3AoaW1hZ2UlMkMlMjAoMjU2JTJDJTIwMjU2KSklMEElMEFyZWFsX2ltYWdlcyUyMCUzRCUyMHRvcmNoLmNhdCglNUJwcmVwcm9jZXNzX2ltYWdlKGltYWdlKSUyMGZvciUyMGltYWdlJTIwaW4lMjByZWFsX2ltYWdlcyU1RCklMEFwcmludChyZWFsX2ltYWdlcy5zaGFwZSklMEElMjMlMjB0b3JjaC5TaXplKCU1QjEwJTJDJTIwMyUyQyUyMDI1NiUyQyUyMDI1NiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> functional <span class="hljs-keyword">as</span> F
<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_image</span>(<span class="hljs-params">image</span>):
    image = torch.tensor(image).unsqueeze(<span class="hljs-number">0</span>)
    image = image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>) / <span class="hljs-number">255.0</span>
    <span class="hljs-keyword">return</span> F.center_crop(image, (<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))

real_images = torch.cat([preprocess_image(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> real_images])
<span class="hljs-built_in">print</span>(real_images.shape)
<span class="hljs-comment"># torch.Size([10, 3, 256, 256])</span>`,wrap:!1}}),dt=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpVFBpcGVsaW5lJTJDJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTBBJTBBZGl0X3BpcGVsaW5lJTIwJTNEJTIwRGlUUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGRGlULVhMLTItMjU2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWRpdF9waXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcoZGl0X3BpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBZGl0X3BpcGVsaW5lJTIwJTNEJTIwZGl0X3BpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBc2VlZCUyMCUzRCUyMDAlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZChzZWVkKSUwQSUwQSUwQXdvcmRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyY2Fzc2V0dGUlMjBwbGF5ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjaGFpbnNhdyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNoYWluc2F3JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2h1cmNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZ2FzJTIwcHVtcCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmdhcyUyMHB1bXAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJnYXMlMjBwdW1wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycGFyYWNodXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycGFyYWNodXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGVuY2glMjIlMkMlMEElNUQlMEElMEFjbGFzc19pZHMlMjAlM0QlMjBkaXRfcGlwZWxpbmUuZ2V0X2xhYmVsX2lkcyh3b3JkcyklMEFvdXRwdXQlMjAlM0QlMjBkaXRfcGlwZWxpbmUoY2xhc3NfbGFiZWxzJTNEY2xhc3NfaWRzJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMiklMEElMEFmYWtlX2ltYWdlcyUyMCUzRCUyMG91dHB1dC5pbWFnZXMlMEFmYWtlX2ltYWdlcyUyMCUzRCUyMHRvcmNoLnRlbnNvcihmYWtlX2ltYWdlcyklMEFmYWtlX2ltYWdlcyUyMCUzRCUyMGZha2VfaW1hZ2VzLnBlcm11dGUoMCUyQyUyMDMlMkMlMjAxJTJDJTIwMiklMEFwcmludChmYWtlX2ltYWdlcy5zaGFwZSklMEElMjMlMjB0b3JjaC5TaXplKCU1QjEwJTJDJTIwMyUyQyUyMDI1NiUyQyUyMDI1NiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiTPipeline, DPMSolverMultistepScheduler

dit_pipeline = DiTPipeline.from_pretrained(<span class="hljs-string">&quot;facebook/DiT-XL-2-256&quot;</span>, torch_dtype=torch.float16)
dit_pipeline.scheduler = DPMSolverMultistepScheduler.from_config(dit_pipeline.scheduler.config)
dit_pipeline = dit_pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

seed = <span class="hljs-number">0</span>
generator = torch.manual_seed(seed)


words = [
    <span class="hljs-string">&quot;cassette player&quot;</span>,
    <span class="hljs-string">&quot;chainsaw&quot;</span>,
    <span class="hljs-string">&quot;chainsaw&quot;</span>,
    <span class="hljs-string">&quot;church&quot;</span>,
    <span class="hljs-string">&quot;gas pump&quot;</span>,
    <span class="hljs-string">&quot;gas pump&quot;</span>,
    <span class="hljs-string">&quot;gas pump&quot;</span>,
    <span class="hljs-string">&quot;parachute&quot;</span>,
    <span class="hljs-string">&quot;parachute&quot;</span>,
    <span class="hljs-string">&quot;tench&quot;</span>,
]

class_ids = dit_pipeline.get_label_ids(words)
output = dit_pipeline(class_labels=class_ids, generator=generator, output_type=<span class="hljs-string">&quot;np&quot;</span>)

fake_images = output.images
fake_images = torch.tensor(fake_images)
fake_images = fake_images.permute(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
<span class="hljs-built_in">print</span>(fake_images.shape)
<span class="hljs-comment"># torch.Size([10, 3, 256, 256])</span>`,wrap:!1}}),ht=new h({props:{code:"ZnJvbSUyMHRvcmNobWV0cmljcy5pbWFnZS5maWQlMjBpbXBvcnQlMjBGcmVjaGV0SW5jZXB0aW9uRGlzdGFuY2UlMEElMEFmaWQlMjAlM0QlMjBGcmVjaGV0SW5jZXB0aW9uRGlzdGFuY2Uobm9ybWFsaXplJTNEVHJ1ZSklMEFmaWQudXBkYXRlKHJlYWxfaW1hZ2VzJTJDJTIwcmVhbCUzRFRydWUpJTBBZmlkLnVwZGF0ZShmYWtlX2ltYWdlcyUyQyUyMHJlYWwlM0RGYWxzZSklMEElMEFwcmludChmJTIyRklEJTNBJTIwJTdCZmxvYXQoZmlkLmNvbXB1dGUoKSklN0QlMjIpJTBBJTIzJTIwRklEJTNBJTIwMTc3LjcxNDcyMTY3OTY4NzU=",highlighted:`<span class="hljs-keyword">from</span> torchmetrics.image.fid <span class="hljs-keyword">import</span> FrechetInceptionDistance

fid = FrechetInceptionDistance(normalize=<span class="hljs-literal">True</span>)
fid.update(real_images, real=<span class="hljs-literal">True</span>)
fid.update(fake_images, real=<span class="hljs-literal">False</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;FID: <span class="hljs-subst">{<span class="hljs-built_in">float</span>(fid.compute())}</span>&quot;</span>)
<span class="hljs-comment"># FID: 177.7147216796875</span>`,wrap:!1}}),Tt=new ci({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/conceptual/evaluation.md"}}),{c(){J=n("meta"),gt=a(),Ut=n("p"),It=a(),r(C.$$.fragment),Ct=a(),w=n("a"),w.innerHTML=_s,Zt=a(),f=n("blockquote"),f.innerHTML=Gs,Bt=a(),Z=n("p"),Z.innerHTML=xs,Wt=a(),B=n("p"),B.textContent=ks,vt=a(),W=n("p"),W.innerHTML=Xs,_t=a(),v=n("p"),v.innerHTML=Vs,Gt=a(),r(_.$$.fragment),xt=a(),G=n("p"),G.textContent=Rs,kt=a(),x=n("ul"),x.innerHTML=Hs,Xt=a(),r(k.$$.fragment),Vt=a(),X=n("p"),X.innerHTML=Fs,Rt=a(),V=n("p"),V.innerHTML=Ns,Ht=a(),R=n("blockquote"),R.innerHTML=Es,Ft=a(),H=n("p"),H.innerHTML=Ys,Nt=a(),F=n("p"),F.textContent=Qs,Et=a(),N=n("ul"),N.innerHTML=As,Yt=a(),E=n("p"),E.textContent=zs,Qt=a(),Y=n("p"),Y.innerHTML=Ss,At=a(),Q=n("ul"),Q.innerHTML=$s,zt=a(),A=n("p"),A.innerHTML=Ls,St=a(),z=n("p"),z.innerHTML=qs,$t=a(),r(S.$$.fragment),Lt=a(),$=n("p"),$.innerHTML=Ps,qt=a(),r(L.$$.fragment),Pt=a(),q=n("p"),q.innerHTML=Ds,Dt=a(),P=n("p"),P.innerHTML=Ks,Kt=a(),D=n("p"),D.innerHTML=Os,Ot=a(),K=n("p"),K.textContent=ea,el=a(),T=n("blockquote"),T.innerHTML=ta,tl=a(),r(O.$$.fragment),ll=a(),ee=n("p"),ee.textContent=la,sl=a(),te=n("ul"),te.innerHTML=sa,al=a(),r(le.$$.fragment),il=a(),se=n("p"),se.innerHTML=aa,nl=a(),ae=n("p"),ae.innerHTML=ia,pl=a(),r(ie.$$.fragment),ol=a(),ne=n("p"),ne.textContent=na,rl=a(),r(pe.$$.fragment),Ml=a(),oe=n("p"),oe.textContent=pa,cl=a(),r(re.$$.fragment),ml=a(),Me=n("p"),Me.textContent=oa,dl=a(),ce=n("p"),ce.innerHTML=ra,ul=a(),r(me.$$.fragment),hl=a(),de=n("p"),de.innerHTML=Ma,yl=a(),r(ue.$$.fragment),Jl=a(),he=n("p"),he.textContent=ca,wl=a(),r(ye.$$.fragment),fl=a(),Je=n("p"),Je.innerHTML=ma,Tl=a(),j=n("blockquote"),j.innerHTML=da,jl=a(),r(we.$$.fragment),Ul=a(),fe=n("p"),fe.innerHTML=ua,bl=a(),Te=n("p"),Te.textContent=ha,gl=a(),je=n("p"),je.innerHTML=ya,Il=a(),Ue=n("p"),Ue.innerHTML=Ja,Cl=a(),be=n("ul"),be.innerHTML=wa,Zl=a(),ge=n("p"),ge.textContent=fa,Bl=a(),Ie=n("p"),Ie.innerHTML=Ta,Wl=a(),Ce=n("p"),Ce.textContent=ja,vl=a(),r(Ze.$$.fragment),_l=a(),r(Be.$$.fragment),Gl=a(),We=n("p"),We.textContent=Ua,xl=a(),ve=n("ul"),ve.innerHTML=ba,kl=a(),_e=n("p"),_e.textContent=ga,Xl=a(),r(Ge.$$.fragment),Vl=a(),r(xe.$$.fragment),Rl=a(),ke=n("p"),ke.textContent=Ia,Hl=a(),r(Xe.$$.fragment),Fl=a(),Ve=n("p"),Ve.innerHTML=Ca,Nl=a(),Re=n("p"),Re.textContent=Za,El=a(),He=n("p"),He.innerHTML=Ba,Yl=a(),r(Fe.$$.fragment),Ql=a(),Ne=n("p"),Ne.textContent=Wa,Al=a(),r(Ee.$$.fragment),zl=a(),Ye=n("p"),Ye.textContent=va,Sl=a(),r(Qe.$$.fragment),$l=a(),Ae=n("p"),Ae.innerHTML=_a,Ll=a(),ze=n("p"),ze.innerHTML=Ga,ql=a(),r(Se.$$.fragment),Pl=a(),$e=n("p"),$e.innerHTML=xa,Dl=a(),r(Le.$$.fragment),Kl=a(),qe=n("p"),qe.textContent=ka,Ol=a(),Pe=n("p"),Pe.innerHTML=Xa,es=a(),De=n("p"),De.innerHTML=Va,ts=a(),Ke=n("p"),Ke.innerHTML=Ra,ls=a(),U=n("blockquote"),U.innerHTML=Ha,ss=a(),Oe=n("p"),Oe.innerHTML=Fa,as=a(),et=n("p"),et.innerHTML=Na,is=a(),r(tt.$$.fragment),ns=a(),lt=n("p"),lt.innerHTML=Ea,ps=a(),st=n("p"),st.innerHTML=Ya,os=a(),at=n("blockquote"),at.innerHTML=Qa,rs=a(),it=n("p"),it.textContent=Aa,Ms=a(),nt=n("p"),nt.textContent=za,cs=a(),r(pt.$$.fragment),ms=a(),r(ot.$$.fragment),ds=a(),rt=n("p"),rt.textContent=Sa,us=a(),b=n("p"),b.innerHTML=$a,hs=a(),Mt=n("p"),Mt.textContent=La,ys=a(),r(ct.$$.fragment),Js=a(),mt=n("p"),mt.innerHTML=qa,ws=a(),r(dt.$$.fragment),fs=a(),ut=n("p"),ut.innerHTML=Pa,Ts=a(),r(ht.$$.fragment),js=a(),yt=n("p"),yt.textContent=Da,Us=a(),Jt=n("ul"),Jt.innerHTML=Ka,bs=a(),wt=n("p"),wt.textContent=Oa,gs=a(),g=n("blockquote"),g.innerHTML=ei,Is=a(),ft=n("p"),ft.innerHTML=ti,Cs=a(),I=n("p"),I.innerHTML=li,Zs=a(),r(Tt.$$.fragment),Bs=a(),bt=n("p"),this.h()},l(e){const t=ri("svelte-u9bgzb",document.head);J=p(t,"META",{name:!0,content:!0}),t.forEach(l),gt=i(e),Ut=p(e,"P",{}),si(Ut).forEach(l),It=i(e),M(C.$$.fragment,e),Ct=i(e),w=p(e,"A",{target:!0,href:!0,"data-svelte-h":!0}),o(w)!=="svelte-1fn2wis"&&(w.innerHTML=_s),Zt=i(e),f=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-14gwzbu"&&(f.innerHTML=Gs),Bt=i(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-z81vpv"&&(Z.innerHTML=xs),Wt=i(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-14o42r"&&(B.textContent=ks),vt=i(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-tqblgl"&&(W.innerHTML=Xs),_t=i(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1on511i"&&(v.innerHTML=Vs),Gt=i(e),M(_.$$.fragment,e),xt=i(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-cqau2t"&&(G.textContent=Rs),kt=i(e),x=p(e,"UL",{"data-svelte-h":!0}),o(x)!=="svelte-1izcxm8"&&(x.innerHTML=Hs),Xt=i(e),M(k.$$.fragment,e),Vt=i(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-cad463"&&(X.innerHTML=Fs),Rt=i(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-15hirvk"&&(V.innerHTML=Ns),Ht=i(e),R=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(R)!=="svelte-191e550"&&(R.innerHTML=Es),Ft=i(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-19xz367"&&(H.innerHTML=Ys),Nt=i(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-76ujpq"&&(F.textContent=Qs),Et=i(e),N=p(e,"UL",{"data-svelte-h":!0}),o(N)!=="svelte-umnjz5"&&(N.innerHTML=As),Yt=i(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-ybl15o"&&(E.textContent=zs),Qt=i(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-f7spg1"&&(Y.innerHTML=Ss),At=i(e),Q=p(e,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-18glkk1"&&(Q.innerHTML=$s),zt=i(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-e5mnz8"&&(A.innerHTML=Ls),St=i(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-304bv6"&&(z.innerHTML=qs),$t=i(e),M(S.$$.fragment,e),Lt=i(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-tpmlzv"&&($.innerHTML=Ps),qt=i(e),M(L.$$.fragment,e),Pt=i(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-4i7yd5"&&(q.innerHTML=Ds),Dt=i(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-a4b9f"&&(P.innerHTML=Ks),Kt=i(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-gipltn"&&(D.innerHTML=Os),Ot=i(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1vqr9z3"&&(K.textContent=ea),el=i(e),T=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-6xf271"&&(T.innerHTML=ta),tl=i(e),M(O.$$.fragment,e),ll=i(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-6557l0"&&(ee.textContent=la),sl=i(e),te=p(e,"UL",{"data-svelte-h":!0}),o(te)!=="svelte-dg8xrl"&&(te.innerHTML=sa),al=i(e),M(le.$$.fragment,e),il=i(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1i7u4ia"&&(se.innerHTML=aa),nl=i(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-7rr7b3"&&(ae.innerHTML=ia),pl=i(e),M(ie.$$.fragment,e),ol=i(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-6rdsa0"&&(ne.textContent=na),rl=i(e),M(pe.$$.fragment,e),Ml=i(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1iembt3"&&(oe.textContent=pa),cl=i(e),M(re.$$.fragment,e),ml=i(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1a3tn0d"&&(Me.textContent=oa),dl=i(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1ibhx6s"&&(ce.innerHTML=ra),ul=i(e),M(me.$$.fragment,e),hl=i(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1uab86h"&&(de.innerHTML=Ma),yl=i(e),M(ue.$$.fragment,e),Jl=i(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-ni3sdy"&&(he.textContent=ca),wl=i(e),M(ye.$$.fragment,e),fl=i(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1kq1w3v"&&(Je.innerHTML=ma),Tl=i(e),j=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-7u3pnh"&&(j.innerHTML=da),jl=i(e),M(we.$$.fragment,e),Ul=i(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-18ubjo5"&&(fe.innerHTML=ua),bl=i(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-r4qmx2"&&(Te.textContent=ha),gl=i(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-tnn31f"&&(je.innerHTML=ya),Il=i(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-lwbe5g"&&(Ue.innerHTML=Ja),Cl=i(e),be=p(e,"UL",{"data-svelte-h":!0}),o(be)!=="svelte-yda35x"&&(be.innerHTML=wa),Zl=i(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1bn7xvw"&&(ge.textContent=fa),Bl=i(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-fs1abj"&&(Ie.innerHTML=Ta),Wl=i(e),Ce=p(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1t03m2p"&&(Ce.textContent=ja),vl=i(e),M(Ze.$$.fragment,e),_l=i(e),M(Be.$$.fragment,e),Gl=i(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1q1xt9i"&&(We.textContent=Ua),xl=i(e),ve=p(e,"UL",{"data-svelte-h":!0}),o(ve)!=="svelte-mhcjab"&&(ve.innerHTML=ba),kl=i(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-9q1iss"&&(_e.textContent=ga),Xl=i(e),M(Ge.$$.fragment,e),Vl=i(e),M(xe.$$.fragment,e),Rl=i(e),ke=p(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-5rwzaj"&&(ke.textContent=Ia),Hl=i(e),M(Xe.$$.fragment,e),Fl=i(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1r4pb3b"&&(Ve.innerHTML=Ca),Nl=i(e),Re=p(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1n3s9hn"&&(Re.textContent=Za),El=i(e),He=p(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-ss3jc3"&&(He.innerHTML=Ba),Yl=i(e),M(Fe.$$.fragment,e),Ql=i(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-pfw8ud"&&(Ne.textContent=Wa),Al=i(e),M(Ee.$$.fragment,e),zl=i(e),Ye=p(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-1nzzrqn"&&(Ye.textContent=va),Sl=i(e),M(Qe.$$.fragment,e),$l=i(e),Ae=p(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1c659ih"&&(Ae.innerHTML=_a),Ll=i(e),ze=p(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-k3cp0u"&&(ze.innerHTML=Ga),ql=i(e),M(Se.$$.fragment,e),Pl=i(e),$e=p(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1tdcjay"&&($e.innerHTML=xa),Dl=i(e),M(Le.$$.fragment,e),Kl=i(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-14mrga2"&&(qe.textContent=ka),Ol=i(e),Pe=p(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-vck7qn"&&(Pe.innerHTML=Xa),es=i(e),De=p(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-nbfdj7"&&(De.innerHTML=Va),ts=i(e),Ke=p(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-9ga2iu"&&(Ke.innerHTML=Ra),ls=i(e),U=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-11ujc7t"&&(U.innerHTML=Ha),ss=i(e),Oe=p(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-7qwtg3"&&(Oe.innerHTML=Fa),as=i(e),et=p(e,"P",{"data-svelte-h":!0}),o(et)!=="svelte-hcc15s"&&(et.innerHTML=Na),is=i(e),M(tt.$$.fragment,e),ns=i(e),lt=p(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1tzk2c3"&&(lt.innerHTML=Ea),ps=i(e),st=p(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1rk18fl"&&(st.innerHTML=Ya),os=i(e),at=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(at)!=="svelte-7e4j74"&&(at.innerHTML=Qa),rs=i(e),it=p(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-simh2d"&&(it.textContent=Aa),Ms=i(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1h659dy"&&(nt.textContent=za),cs=i(e),M(pt.$$.fragment,e),ms=i(e),M(ot.$$.fragment,e),ds=i(e),rt=p(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-1jd4ltz"&&(rt.textContent=Sa),us=i(e),b=p(e,"P",{align:!0,"data-svelte-h":!0}),o(b)!=="svelte-94lw7t"&&(b.innerHTML=$a),hs=i(e),Mt=p(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-iw90qp"&&(Mt.textContent=La),ys=i(e),M(ct.$$.fragment,e),Js=i(e),mt=p(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-a40j2v"&&(mt.innerHTML=qa),ws=i(e),M(dt.$$.fragment,e),fs=i(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1nlt7gv"&&(ut.innerHTML=Pa),Ts=i(e),M(ht.$$.fragment,e),js=i(e),yt=p(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-17lmdw3"&&(yt.textContent=Da),Us=i(e),Jt=p(e,"UL",{"data-svelte-h":!0}),o(Jt)!=="svelte-16n90lm"&&(Jt.innerHTML=Ka),bs=i(e),wt=p(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-1evgdla"&&(wt.textContent=Oa),gs=i(e),g=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-pf76q4"&&(g.innerHTML=ei),Is=i(e),ft=p(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-ptrlon"&&(ft.innerHTML=ti),Cs=i(e),I=p(e,"P",{align:!0,"data-svelte-h":!0}),o(I)!=="svelte-16e5oh4"&&(I.innerHTML=li),Zs=i(e),M(Tt.$$.fragment,e),Bs=i(e),bt=p(e,"P",{}),si(bt).forEach(l),this.h()},h(){y(J,"name","hf:doc:metadata"),y(J,"content",di),y(w,"target","_blank"),y(w,"href","https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/evaluation.ipynb"),y(f,"class","tip"),y(T,"class","tip"),y(j,"class","warning"),y(U,"class","tip"),y(b,"align","center"),y(g,"class","warning"),y(I,"align","center")},m(e,t){Mi(document.head,J),s(e,gt,t),s(e,Ut,t),s(e,It,t),c(C,e,t),s(e,Ct,t),s(e,w,t),s(e,Zt,t),s(e,f,t),s(e,Bt,t),s(e,Z,t),s(e,Wt,t),s(e,B,t),s(e,vt,t),s(e,W,t),s(e,_t,t),s(e,v,t),s(e,Gt,t),c(_,e,t),s(e,xt,t),s(e,G,t),s(e,kt,t),s(e,x,t),s(e,Xt,t),c(k,e,t),s(e,Vt,t),s(e,X,t),s(e,Rt,t),s(e,V,t),s(e,Ht,t),s(e,R,t),s(e,Ft,t),s(e,H,t),s(e,Nt,t),s(e,F,t),s(e,Et,t),s(e,N,t),s(e,Yt,t),s(e,E,t),s(e,Qt,t),s(e,Y,t),s(e,At,t),s(e,Q,t),s(e,zt,t),s(e,A,t),s(e,St,t),s(e,z,t),s(e,$t,t),c(S,e,t),s(e,Lt,t),s(e,$,t),s(e,qt,t),c(L,e,t),s(e,Pt,t),s(e,q,t),s(e,Dt,t),s(e,P,t),s(e,Kt,t),s(e,D,t),s(e,Ot,t),s(e,K,t),s(e,el,t),s(e,T,t),s(e,tl,t),c(O,e,t),s(e,ll,t),s(e,ee,t),s(e,sl,t),s(e,te,t),s(e,al,t),c(le,e,t),s(e,il,t),s(e,se,t),s(e,nl,t),s(e,ae,t),s(e,pl,t),c(ie,e,t),s(e,ol,t),s(e,ne,t),s(e,rl,t),c(pe,e,t),s(e,Ml,t),s(e,oe,t),s(e,cl,t),c(re,e,t),s(e,ml,t),s(e,Me,t),s(e,dl,t),s(e,ce,t),s(e,ul,t),c(me,e,t),s(e,hl,t),s(e,de,t),s(e,yl,t),c(ue,e,t),s(e,Jl,t),s(e,he,t),s(e,wl,t),c(ye,e,t),s(e,fl,t),s(e,Je,t),s(e,Tl,t),s(e,j,t),s(e,jl,t),c(we,e,t),s(e,Ul,t),s(e,fe,t),s(e,bl,t),s(e,Te,t),s(e,gl,t),s(e,je,t),s(e,Il,t),s(e,Ue,t),s(e,Cl,t),s(e,be,t),s(e,Zl,t),s(e,ge,t),s(e,Bl,t),s(e,Ie,t),s(e,Wl,t),s(e,Ce,t),s(e,vl,t),c(Ze,e,t),s(e,_l,t),c(Be,e,t),s(e,Gl,t),s(e,We,t),s(e,xl,t),s(e,ve,t),s(e,kl,t),s(e,_e,t),s(e,Xl,t),c(Ge,e,t),s(e,Vl,t),c(xe,e,t),s(e,Rl,t),s(e,ke,t),s(e,Hl,t),c(Xe,e,t),s(e,Fl,t),s(e,Ve,t),s(e,Nl,t),s(e,Re,t),s(e,El,t),s(e,He,t),s(e,Yl,t),c(Fe,e,t),s(e,Ql,t),s(e,Ne,t),s(e,Al,t),c(Ee,e,t),s(e,zl,t),s(e,Ye,t),s(e,Sl,t),c(Qe,e,t),s(e,$l,t),s(e,Ae,t),s(e,Ll,t),s(e,ze,t),s(e,ql,t),c(Se,e,t),s(e,Pl,t),s(e,$e,t),s(e,Dl,t),c(Le,e,t),s(e,Kl,t),s(e,qe,t),s(e,Ol,t),s(e,Pe,t),s(e,es,t),s(e,De,t),s(e,ts,t),s(e,Ke,t),s(e,ls,t),s(e,U,t),s(e,ss,t),s(e,Oe,t),s(e,as,t),s(e,et,t),s(e,is,t),c(tt,e,t),s(e,ns,t),s(e,lt,t),s(e,ps,t),s(e,st,t),s(e,os,t),s(e,at,t),s(e,rs,t),s(e,it,t),s(e,Ms,t),s(e,nt,t),s(e,cs,t),c(pt,e,t),s(e,ms,t),c(ot,e,t),s(e,ds,t),s(e,rt,t),s(e,us,t),s(e,b,t),s(e,hs,t),s(e,Mt,t),s(e,ys,t),c(ct,e,t),s(e,Js,t),s(e,mt,t),s(e,ws,t),c(dt,e,t),s(e,fs,t),s(e,ut,t),s(e,Ts,t),c(ht,e,t),s(e,js,t),s(e,yt,t),s(e,Us,t),s(e,Jt,t),s(e,bs,t),s(e,wt,t),s(e,gs,t),s(e,g,t),s(e,Is,t),s(e,ft,t),s(e,Cs,t),s(e,I,t),s(e,Zs,t),c(Tt,e,t),s(e,Bs,t),s(e,bt,t),Ws=!0},p:ii,i(e){Ws||(m(C.$$.fragment,e),m(_.$$.fragment,e),m(k.$$.fragment,e),m(S.$$.fragment,e),m(L.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(re.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(ye.$$.fragment,e),m(we.$$.fragment,e),m(Ze.$$.fragment,e),m(Be.$$.fragment,e),m(Ge.$$.fragment,e),m(xe.$$.fragment,e),m(Xe.$$.fragment,e),m(Fe.$$.fragment,e),m(Ee.$$.fragment,e),m(Qe.$$.fragment,e),m(Se.$$.fragment,e),m(Le.$$.fragment,e),m(tt.$$.fragment,e),m(pt.$$.fragment,e),m(ot.$$.fragment,e),m(ct.$$.fragment,e),m(dt.$$.fragment,e),m(ht.$$.fragment,e),m(Tt.$$.fragment,e),Ws=!0)},o(e){d(C.$$.fragment,e),d(_.$$.fragment,e),d(k.$$.fragment,e),d(S.$$.fragment,e),d(L.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(re.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(ye.$$.fragment,e),d(we.$$.fragment,e),d(Ze.$$.fragment,e),d(Be.$$.fragment,e),d(Ge.$$.fragment,e),d(xe.$$.fragment,e),d(Xe.$$.fragment,e),d(Fe.$$.fragment,e),d(Ee.$$.fragment,e),d(Qe.$$.fragment,e),d(Se.$$.fragment,e),d(Le.$$.fragment,e),d(tt.$$.fragment,e),d(pt.$$.fragment,e),d(ot.$$.fragment,e),d(ct.$$.fragment,e),d(dt.$$.fragment,e),d(ht.$$.fragment,e),d(Tt.$$.fragment,e),Ws=!1},d(e){e&&(l(gt),l(Ut),l(It),l(Ct),l(w),l(Zt),l(f),l(Bt),l(Z),l(Wt),l(B),l(vt),l(W),l(_t),l(v),l(Gt),l(xt),l(G),l(kt),l(x),l(Xt),l(Vt),l(X),l(Rt),l(V),l(Ht),l(R),l(Ft),l(H),l(Nt),l(F),l(Et),l(N),l(Yt),l(E),l(Qt),l(Y),l(At),l(Q),l(zt),l(A),l(St),l(z),l($t),l(Lt),l($),l(qt),l(Pt),l(q),l(Dt),l(P),l(Kt),l(D),l(Ot),l(K),l(el),l(T),l(tl),l(ll),l(ee),l(sl),l(te),l(al),l(il),l(se),l(nl),l(ae),l(pl),l(ol),l(ne),l(rl),l(Ml),l(oe),l(cl),l(ml),l(Me),l(dl),l(ce),l(ul),l(hl),l(de),l(yl),l(Jl),l(he),l(wl),l(fl),l(Je),l(Tl),l(j),l(jl),l(Ul),l(fe),l(bl),l(Te),l(gl),l(je),l(Il),l(Ue),l(Cl),l(be),l(Zl),l(ge),l(Bl),l(Ie),l(Wl),l(Ce),l(vl),l(_l),l(Gl),l(We),l(xl),l(ve),l(kl),l(_e),l(Xl),l(Vl),l(Rl),l(ke),l(Hl),l(Fl),l(Ve),l(Nl),l(Re),l(El),l(He),l(Yl),l(Ql),l(Ne),l(Al),l(zl),l(Ye),l(Sl),l($l),l(Ae),l(Ll),l(ze),l(ql),l(Pl),l($e),l(Dl),l(Kl),l(qe),l(Ol),l(Pe),l(es),l(De),l(ts),l(Ke),l(ls),l(U),l(ss),l(Oe),l(as),l(et),l(is),l(ns),l(lt),l(ps),l(st),l(os),l(at),l(rs),l(it),l(Ms),l(nt),l(cs),l(ms),l(ds),l(rt),l(us),l(b),l(hs),l(Mt),l(ys),l(Js),l(mt),l(ws),l(fs),l(ut),l(Ts),l(js),l(yt),l(Us),l(Jt),l(bs),l(wt),l(gs),l(g),l(Is),l(ft),l(Cs),l(I),l(Zs),l(Bs),l(bt)),l(J),u(C,e),u(_,e),u(k,e),u(S,e),u(L,e),u(O,e),u(le,e),u(ie,e),u(pe,e),u(re,e),u(me,e),u(ue,e),u(ye,e),u(we,e),u(Ze,e),u(Be,e),u(Ge,e),u(xe,e),u(Xe,e),u(Fe,e),u(Ee,e),u(Qe,e),u(Se,e),u(Le,e),u(tt,e),u(pt,e),u(ot,e),u(ct,e),u(dt,e),u(ht,e),u(Tt,e)}}}const di='{"title":"Evaluating Diffusion Models","local":"evaluating-diffusion-models","sections":[{"title":"Scenarios","local":"scenarios","sections":[],"depth":2},{"title":"Qualitative Evaluation","local":"qualitative-evaluation","sections":[],"depth":2},{"title":"Quantitative Evaluation","local":"quantitative-evaluation","sections":[{"title":"Text-guided image generation","local":"text-guided-image-generation","sections":[],"depth":3},{"title":"Image-conditioned text-to-image generation","local":"image-conditioned-text-to-image-generation","sections":[],"depth":3},{"title":"Class-conditioned image generation","local":"class-conditioned-image-generation","sections":[],"depth":3}],"depth":2}],"depth":1}';function ui(vs){return ni(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fi extends pi{constructor(J){super(),oi(this,J,ui,mi,ai,{})}}export{fi as component};
