import{s as St,n as Mt,o as xt}from"../chunks/scheduler.888833de.js";import{S as yt,i as Dt,e as i,s as o,c as u,h as $t,a as d,d as s,b as r,f as b,g as m,j as p,k as v,l as t,m as l,n as f,t as h,o as g,p as _}from"../chunks/index.128ce987.js";import{D as M}from"../chunks/Docstring.23ed6b62.js";import{H as Ne,E as Tt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function Pt(st){let x,ue,ce,me,O,fe,E,ot='<code>DPMSolverMultistepScheduler</code> is a multistep scheduler from <a href="https://huggingface.co/papers/2206.00927" rel="nofollow">DPM-Solver: A Fast ODE Solver for Diffusion Probabilistic Model Sampling in Around 10 Steps</a> and <a href="https://huggingface.co/papers/2211.01095" rel="nofollow">DPM-Solver++: Fast Solver for Guided Sampling of Diffusion Probabilistic Models</a> by Cheng Lu, Yuhao Zhou, Fan Bao, Jianfei Chen, Chongxuan Li, and Jun Zhu.',he,I,rt=`DPMSolver (and the improved version DPMSolver++) is a fast dedicated high-order solver for diffusion ODEs with convergence order guarantee. Empirically, DPMSolver sampling with only 20 steps can generate high-quality
samples, and it can generate quite good samples even in 10 steps.`,ge,q,_e,N,nt="It is recommended to set <code>solver_order</code> to 2 for guide sampling, and <code>solver_order=3</code> for unconditional sampling.",ve,z,it=`Dynamic thresholding from <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen</a> is supported, and for pixel-space
diffusion models, you can set both <code>algorithm_type=&quot;dpmsolver++&quot;</code> and <code>thresholding=True</code> to use the dynamic
thresholding. This thresholding method is unsuitable for latent-space diffusion models such as
Stable Diffusion.`,be,F,dt="The SDE variant of DPMSolver and DPM-Solver++ is also supported, but only for the first and second-order solvers. This is a fast SDE solver for the reverse diffusion SDE. It is recommended to use the second-order <code>sde-dpmsolver++</code>.",Se,k,Me,a,H,ze,Q,at="<code>DPMSolverMultistepScheduler</code> is a fast dedicated high-order solver for diffusion ODEs.",Fe,X,lt=`This model inherits from <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a> and <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin">ConfigMixin</a>. Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.`,ke,S,A,He,ee,ct=`Convert the model output to the corresponding type the DPMSolver/DPMSolver++ algorithm needs. DPM-Solver is
designed to discretize an integral of the noise prediction model, and DPM-Solver++ is designed to discretize an
integral of the data prediction model.`,Ae,V,pt=`<p>&gt; The algorithm and model type are decoupled. You can use either DPMSolver or DPMSolver++ for both
noise &gt; prediction and data prediction models.</p>`,Ve,D,W,We,te,ut="One step for the first-order DPMSolver (equivalent to DDIM).",Ue,$,U,Re,se,mt="One step for the second-order multistep DPMSolver.",je,T,R,Be,oe,ft="One step for the third-order multistep DPMSolver.",Ge,P,j,Ye,re,ht=`Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.`,Je,w,B,Ke,ne,gt="Sets the begin index for the scheduler. This function should be run from pipeline before the inference.",Ze,C,G,Qe,ie,_t="Sets the discrete timesteps used for the diffusion chain (to be run before inference).",Xe,L,Y,et,de,vt=`Predict the sample from the previous timestep by reversing the SDE. This function propagates the sample with
the multistep DPMSolver.`,xe,J,ye,y,K,tt,ae,bt="Base class for the output of a scheduler’s <code>step</code> function.",De,Z,$e,pe,Te;return O=new Ne({props:{title:"DPMSolverMultistepScheduler",local:"dpmsolvermultistepscheduler",headingTag:"h1"}}),q=new Ne({props:{title:"Tips",local:"tips",headingTag:"h2"}}),k=new Ne({props:{title:"DPMSolverMultistepScheduler",local:"diffusers.DPMSolverMultistepScheduler",headingTag:"h2"}}),H=new M({props:{name:"class diffusers.DPMSolverMultistepScheduler",anchor:"diffusers.DPMSolverMultistepScheduler",parameters:[{name:"num_train_timesteps",val:": int = 1000"},{name:"beta_start",val:": float = 0.0001"},{name:"beta_end",val:": float = 0.02"},{name:"beta_schedule",val:": str = 'linear'"},{name:"trained_betas",val:": typing.Union[numpy.ndarray, typing.List[float], NoneType] = None"},{name:"solver_order",val:": int = 2"},{name:"prediction_type",val:": str = 'epsilon'"},{name:"thresholding",val:": bool = False"},{name:"dynamic_thresholding_ratio",val:": float = 0.995"},{name:"sample_max_value",val:": float = 1.0"},{name:"algorithm_type",val:": str = 'dpmsolver++'"},{name:"solver_type",val:": str = 'midpoint'"},{name:"lower_order_final",val:": bool = True"},{name:"euler_at_final",val:": bool = False"},{name:"use_karras_sigmas",val:": typing.Optional[bool] = False"},{name:"use_exponential_sigmas",val:": typing.Optional[bool] = False"},{name:"use_beta_sigmas",val:": typing.Optional[bool] = False"},{name:"use_lu_lambdas",val:": typing.Optional[bool] = False"},{name:"use_flow_sigmas",val:": typing.Optional[bool] = False"},{name:"flow_shift",val:": typing.Optional[float] = 1.0"},{name:"final_sigmas_type",val:": typing.Optional[str] = 'zero'"},{name:"lambda_min_clipped",val:": float = -inf"},{name:"variance_type",val:": typing.Optional[str] = None"},{name:"timestep_spacing",val:": str = 'linspace'"},{name:"steps_offset",val:": int = 0"},{name:"rescale_betas_zero_snr",val:": bool = False"},{name:"use_dynamic_shifting",val:": bool = False"},{name:"time_shift_type",val:": str = 'exponential'"}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.num_train_timesteps",description:`<strong>num_train_timesteps</strong> (<code>int</code>, defaults to 1000) &#x2014;
The number of diffusion steps to train the model.`,name:"num_train_timesteps"},{anchor:"diffusers.DPMSolverMultistepScheduler.beta_start",description:`<strong>beta_start</strong> (<code>float</code>, defaults to 0.0001) &#x2014;
The starting <code>beta</code> value of inference.`,name:"beta_start"},{anchor:"diffusers.DPMSolverMultistepScheduler.beta_end",description:`<strong>beta_end</strong> (<code>float</code>, defaults to 0.02) &#x2014;
The final <code>beta</code> value.`,name:"beta_end"},{anchor:"diffusers.DPMSolverMultistepScheduler.beta_schedule",description:`<strong>beta_schedule</strong> (<code>str</code>, defaults to <code>&quot;linear&quot;</code>) &#x2014;
The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model. Choose from
<code>linear</code>, <code>scaled_linear</code>, or <code>squaredcos_cap_v2</code>.`,name:"beta_schedule"},{anchor:"diffusers.DPMSolverMultistepScheduler.trained_betas",description:`<strong>trained_betas</strong> (<code>np.ndarray</code>, <em>optional</em>) &#x2014;
Pass an array of betas directly to the constructor to bypass <code>beta_start</code> and <code>beta_end</code>.`,name:"trained_betas"},{anchor:"diffusers.DPMSolverMultistepScheduler.solver_order",description:`<strong>solver_order</strong> (<code>int</code>, defaults to 2) &#x2014;
The DPMSolver order which can be <code>1</code> or <code>2</code> or <code>3</code>. It is recommended to use <code>solver_order=2</code> for guided
sampling, and <code>solver_order=3</code> for unconditional sampling.`,name:"solver_order"},{anchor:"diffusers.DPMSolverMultistepScheduler.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, defaults to <code>epsilon</code>, <em>optional</em>) &#x2014;
Prediction type of the scheduler function; can be <code>epsilon</code> (predicts the noise of the diffusion process),
<code>sample</code> (directly predicts the noisy sample), <code>v_prediction</code> (see section 2.4 of <a href="https://imagen.research.google/video/paper.pdf" rel="nofollow">Imagen
Video</a> paper), or <code>flow_prediction</code>.`,name:"prediction_type"},{anchor:"diffusers.DPMSolverMultistepScheduler.thresholding",description:`<strong>thresholding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the &#x201C;dynamic thresholding&#x201D; method. This is unsuitable for latent-space diffusion models such
as Stable Diffusion.`,name:"thresholding"},{anchor:"diffusers.DPMSolverMultistepScheduler.dynamic_thresholding_ratio",description:`<strong>dynamic_thresholding_ratio</strong> (<code>float</code>, defaults to 0.995) &#x2014;
The ratio for the dynamic thresholding method. Valid only when <code>thresholding=True</code>.`,name:"dynamic_thresholding_ratio"},{anchor:"diffusers.DPMSolverMultistepScheduler.sample_max_value",description:`<strong>sample_max_value</strong> (<code>float</code>, defaults to 1.0) &#x2014;
The threshold value for dynamic thresholding. Valid only when <code>thresholding=True</code> and
<code>algorithm_type=&quot;dpmsolver++&quot;</code>.`,name:"sample_max_value"},{anchor:"diffusers.DPMSolverMultistepScheduler.algorithm_type",description:`<strong>algorithm_type</strong> (<code>str</code>, defaults to <code>dpmsolver++</code>) &#x2014;
Algorithm type for the solver; can be <code>dpmsolver</code>, <code>dpmsolver++</code>, <code>sde-dpmsolver</code> or <code>sde-dpmsolver++</code>. The
<code>dpmsolver</code> type implements the algorithms in the <a href="https://huggingface.co/papers/2206.00927" rel="nofollow">DPMSolver</a>
paper, and the <code>dpmsolver++</code> type implements the algorithms in the
<a href="https://huggingface.co/papers/2211.01095" rel="nofollow">DPMSolver++</a> paper. It is recommended to use <code>dpmsolver++</code> or
<code>sde-dpmsolver++</code> with <code>solver_order=2</code> for guided sampling like in Stable Diffusion.`,name:"algorithm_type"},{anchor:"diffusers.DPMSolverMultistepScheduler.solver_type",description:`<strong>solver_type</strong> (<code>str</code>, defaults to <code>midpoint</code>) &#x2014;
Solver type for the second-order solver; can be <code>midpoint</code> or <code>heun</code>. The solver type slightly affects the
sample quality, especially for a small number of steps. It is recommended to use <code>midpoint</code> solvers.`,name:"solver_type"},{anchor:"diffusers.DPMSolverMultistepScheduler.lower_order_final",description:`<strong>lower_order_final</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use lower-order solvers in the final steps. Only valid for &lt; 15 inference steps. This can
stabilize the sampling of DPMSolver for steps &lt; 15, especially for steps &lt;= 10.`,name:"lower_order_final"},{anchor:"diffusers.DPMSolverMultistepScheduler.euler_at_final",description:`<strong>euler_at_final</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use Euler&#x2019;s method in the final step. It is a trade-off between numerical stability and detail
richness. This can stabilize the sampling of the SDE variant of DPMSolver for small number of inference
steps, but sometimes may result in blurring.`,name:"euler_at_final"},{anchor:"diffusers.DPMSolverMultistepScheduler.use_karras_sigmas",description:`<strong>use_karras_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Karras sigmas for step sizes in the noise schedule during the sampling process. If <code>True</code>,
the sigmas are determined according to a sequence of noise levels {&#x3C3;i}.`,name:"use_karras_sigmas"},{anchor:"diffusers.DPMSolverMultistepScheduler.use_exponential_sigmas",description:`<strong>use_exponential_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use exponential sigmas for step sizes in the noise schedule during the sampling process.`,name:"use_exponential_sigmas"},{anchor:"diffusers.DPMSolverMultistepScheduler.use_beta_sigmas",description:`<strong>use_beta_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use beta sigmas for step sizes in the noise schedule during the sampling process. Refer to <a href="https://huggingface.co/papers/2407.12173" rel="nofollow">Beta
Sampling is All You Need</a> for more information.`,name:"use_beta_sigmas"},{anchor:"diffusers.DPMSolverMultistepScheduler.use_lu_lambdas",description:`<strong>use_lu_lambdas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use the uniform-logSNR for step sizes proposed by Lu&#x2019;s DPM-Solver in the noise schedule during
the sampling process. If <code>True</code>, the sigmas and time steps are determined according to a sequence of
<code>lambda(t)</code>.`,name:"use_lu_lambdas"},{anchor:"diffusers.DPMSolverMultistepScheduler.use_flow_sigmas",description:`<strong>use_flow_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use flow sigmas for step sizes in the noise schedule during the sampling process.`,name:"use_flow_sigmas"},{anchor:"diffusers.DPMSolverMultistepScheduler.flow_shift",description:`<strong>flow_shift</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The shift value for the timestep schedule for flow matching.`,name:"flow_shift"},{anchor:"diffusers.DPMSolverMultistepScheduler.final_sigmas_type",description:`<strong>final_sigmas_type</strong> (<code>str</code>, defaults to <code>&quot;zero&quot;</code>) &#x2014;
The final <code>sigma</code> value for the noise schedule during the sampling process. If <code>&quot;sigma_min&quot;</code>, the final
sigma is the same as the last sigma in the training schedule. If <code>zero</code>, the final sigma is set to 0.`,name:"final_sigmas_type"},{anchor:"diffusers.DPMSolverMultistepScheduler.lambda_min_clipped",description:`<strong>lambda_min_clipped</strong> (<code>float</code>, defaults to <code>-inf</code>) &#x2014;
Clipping threshold for the minimum value of <code>lambda(t)</code> for numerical stability. This is critical for the
cosine (<code>squaredcos_cap_v2</code>) noise schedule.`,name:"lambda_min_clipped"},{anchor:"diffusers.DPMSolverMultistepScheduler.variance_type",description:`<strong>variance_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to &#x201C;learned&#x201D; or &#x201C;learned_range&#x201D; for diffusion models that predict variance. If set, the model&#x2019;s output
contains the predicted Gaussian variance.`,name:"variance_type"},{anchor:"diffusers.DPMSolverMultistepScheduler.timestep_spacing",description:`<strong>timestep_spacing</strong> (<code>str</code>, defaults to <code>&quot;linspace&quot;</code>) &#x2014;
The way the timesteps should be scaled. Refer to Table 2 of the <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and
Sample Steps are Flawed</a> for more information.`,name:"timestep_spacing"},{anchor:"diffusers.DPMSolverMultistepScheduler.steps_offset",description:`<strong>steps_offset</strong> (<code>int</code>, defaults to 0) &#x2014;
An offset added to the inference steps, as required by some model families.`,name:"steps_offset"},{anchor:"diffusers.DPMSolverMultistepScheduler.rescale_betas_zero_snr",description:`<strong>rescale_betas_zero_snr</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to rescale the betas to have zero terminal SNR. This enables the model to generate very bright and
dark samples instead of limiting it to samples with medium brightness. Loosely related to
<a href="https://github.com/huggingface/diffusers/blob/74fd735eb073eb1d774b1ab4154a0876eb82f055/examples/dreambooth/train_dreambooth.py#L506" rel="nofollow"><code>--offset_noise</code></a>.`,name:"rescale_betas_zero_snr"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L115"}}),A=new M({props:{name:"convert_model_output",anchor:"diffusers.DPMSolverMultistepScheduler.convert_model_output",parameters:[{name:"model_output",val:": Tensor"},{name:"*args",val:""},{name:"sample",val:": Tensor = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.convert_model_output.model_output",description:`<strong>model_output</strong> (<code>torch.Tensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DPMSolverMultistepScheduler.convert_model_output.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L621",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The converted model output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),W=new M({props:{name:"dpm_solver_first_order_update",anchor:"diffusers.DPMSolverMultistepScheduler.dpm_solver_first_order_update",parameters:[{name:"model_output",val:": Tensor"},{name:"*args",val:""},{name:"sample",val:": Tensor = None"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.dpm_solver_first_order_update.model_output",description:`<strong>model_output</strong> (<code>torch.Tensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DPMSolverMultistepScheduler.dpm_solver_first_order_update.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L719",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),U=new M({props:{name:"multistep_dpm_solver_second_order_update",anchor:"diffusers.DPMSolverMultistepScheduler.multistep_dpm_solver_second_order_update",parameters:[{name:"model_output_list",val:": typing.List[torch.Tensor]"},{name:"*args",val:""},{name:"sample",val:": Tensor = None"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.multistep_dpm_solver_second_order_update.model_output_list",description:`<strong>model_output_list</strong> (<code>List[torch.Tensor]</code>) &#x2014;
The direct outputs from learned diffusion model at current and latter timesteps.`,name:"model_output_list"},{anchor:"diffusers.DPMSolverMultistepScheduler.multistep_dpm_solver_second_order_update.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L788",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),R=new M({props:{name:"multistep_dpm_solver_third_order_update",anchor:"diffusers.DPMSolverMultistepScheduler.multistep_dpm_solver_third_order_update",parameters:[{name:"model_output_list",val:": typing.List[torch.Tensor]"},{name:"*args",val:""},{name:"sample",val:": Tensor = None"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.multistep_dpm_solver_third_order_update.model_output_list",description:`<strong>model_output_list</strong> (<code>List[torch.Tensor]</code>) &#x2014;
The direct outputs from learned diffusion model at current and latter timesteps.`,name:"model_output_list"},{anchor:"diffusers.DPMSolverMultistepScheduler.multistep_dpm_solver_third_order_update.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L911",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),j=new M({props:{name:"scale_model_input",anchor:"diffusers.DPMSolverMultistepScheduler.scale_model_input",parameters:[{name:"sample",val:": Tensor"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.scale_model_input.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
The input sample.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L1126",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A scaled input sample.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),B=new M({props:{name:"set_begin_index",anchor:"diffusers.DPMSolverMultistepScheduler.set_begin_index",parameters:[{name:"begin_index",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.set_begin_index.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
The begin index for the scheduler.`,name:"begin_index"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L321"}}),G=new M({props:{name:"set_timesteps",anchor:"diffusers.DPMSolverMultistepScheduler.set_timesteps",parameters:[{name:"num_inference_steps",val:": int = None"},{name:"device",val:": typing.Union[str, torch.device] = None"},{name:"mu",val:": typing.Optional[float] = None"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.set_timesteps.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>) &#x2014;
The number of diffusion steps used when generating samples with a pre-trained model.`,name:"num_inference_steps"},{anchor:"diffusers.DPMSolverMultistepScheduler.set_timesteps.device",description:`<strong>device</strong> (<code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device to which the timesteps should be moved to. If <code>None</code>, the timesteps are not moved.`,name:"device"},{anchor:"diffusers.DPMSolverMultistepScheduler.set_timesteps.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps used to support arbitrary timesteps schedule. If <code>None</code>, timesteps will be generated
based on the <code>timestep_spacing</code> attribute. If <code>timesteps</code> is passed, <code>num_inference_steps</code> and <code>sigmas</code>
must be <code>None</code>, and <code>timestep_spacing</code> attribute will be ignored.`,name:"timesteps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L331"}}),Y=new M({props:{name:"step",anchor:"diffusers.DPMSolverMultistepScheduler.step",parameters:[{name:"model_output",val:": Tensor"},{name:"timestep",val:": typing.Union[int, torch.Tensor]"},{name:"sample",val:": Tensor"},{name:"generator",val:" = None"},{name:"variance_noise",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.DPMSolverMultistepScheduler.step.model_output",description:`<strong>model_output</strong> (<code>torch.Tensor</code>) &#x2014;
The direct output from learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DPMSolverMultistepScheduler.step.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.DPMSolverMultistepScheduler.step.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"},{anchor:"diffusers.DPMSolverMultistepScheduler.step.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A random number generator.`,name:"generator"},{anchor:"diffusers.DPMSolverMultistepScheduler.step.variance_noise",description:`<strong>variance_noise</strong> (<code>torch.Tensor</code>) &#x2014;
Alternative to generating noise with <code>generator</code> by directly providing the noise for the variance
itself. Useful for methods such as <code>LEdits++</code>.`,name:"variance_noise"},{anchor:"diffusers.DPMSolverMultistepScheduler.step.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/schedulers/edm_multistep_dpm_solver#diffusers.schedulers.scheduling_utils.SchedulerOutput">SchedulerOutput</a> or <code>tuple</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep.py#L1037",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If return_dict is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/schedulers/edm_multistep_dpm_solver#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> is returned, otherwise a
tuple is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/schedulers/edm_multistep_dpm_solver#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> or <code>tuple</code></p>
`}}),J=new Ne({props:{title:"SchedulerOutput",local:"diffusers.schedulers.scheduling_utils.SchedulerOutput",headingTag:"h2"}}),K=new M({props:{name:"class diffusers.schedulers.scheduling_utils.SchedulerOutput",anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput",parameters:[{name:"prev_sample",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput.prev_sample",description:`<strong>prev_sample</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code> for images) &#x2014;
Computed sample <code>(x_{t-1})</code> of previous timestep. <code>prev_sample</code> should be used as next model input in the
denoising loop.`,name:"prev_sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_utils.py#L62"}}),Z=new Tt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/schedulers/multistep_dpm_solver.md"}}),{c(){x=i("meta"),ue=o(),ce=i("p"),me=o(),u(O.$$.fragment),fe=o(),E=i("p"),E.innerHTML=ot,he=o(),I=i("p"),I.textContent=rt,ge=o(),u(q.$$.fragment),_e=o(),N=i("p"),N.innerHTML=nt,ve=o(),z=i("p"),z.innerHTML=it,be=o(),F=i("p"),F.innerHTML=dt,Se=o(),u(k.$$.fragment),Me=o(),a=i("div"),u(H.$$.fragment),ze=o(),Q=i("p"),Q.innerHTML=at,Fe=o(),X=i("p"),X.innerHTML=lt,ke=o(),S=i("div"),u(A.$$.fragment),He=o(),ee=i("p"),ee.textContent=ct,Ae=o(),V=i("blockquote"),V.innerHTML=pt,Ve=o(),D=i("div"),u(W.$$.fragment),We=o(),te=i("p"),te.textContent=ut,Ue=o(),$=i("div"),u(U.$$.fragment),Re=o(),se=i("p"),se.textContent=mt,je=o(),T=i("div"),u(R.$$.fragment),Be=o(),oe=i("p"),oe.textContent=ft,Ge=o(),P=i("div"),u(j.$$.fragment),Ye=o(),re=i("p"),re.textContent=ht,Je=o(),w=i("div"),u(B.$$.fragment),Ke=o(),ne=i("p"),ne.textContent=gt,Ze=o(),C=i("div"),u(G.$$.fragment),Qe=o(),ie=i("p"),ie.textContent=_t,Xe=o(),L=i("div"),u(Y.$$.fragment),et=o(),de=i("p"),de.textContent=vt,xe=o(),u(J.$$.fragment),ye=o(),y=i("div"),u(K.$$.fragment),tt=o(),ae=i("p"),ae.innerHTML=bt,De=o(),u(Z.$$.fragment),$e=o(),pe=i("p"),this.h()},l(e){const n=$t("svelte-u9bgzb",document.head);x=d(n,"META",{name:!0,content:!0}),n.forEach(s),ue=r(e),ce=d(e,"P",{}),b(ce).forEach(s),me=r(e),m(O.$$.fragment,e),fe=r(e),E=d(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-194x5ku"&&(E.innerHTML=ot),he=r(e),I=d(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-l6rv24"&&(I.textContent=rt),ge=r(e),m(q.$$.fragment,e),_e=r(e),N=d(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-pt2glg"&&(N.innerHTML=nt),ve=r(e),z=d(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1ng0gyl"&&(z.innerHTML=it),be=r(e),F=d(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-18n28n2"&&(F.innerHTML=dt),Se=r(e),m(k.$$.fragment,e),Me=r(e),a=d(e,"DIV",{class:!0});var c=b(a);m(H.$$.fragment,c),ze=r(c),Q=d(c,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-12v1qo2"&&(Q.innerHTML=at),Fe=r(c),X=d(c,"P",{"data-svelte-h":!0}),p(X)!=="svelte-linuuh"&&(X.innerHTML=lt),ke=r(c),S=d(c,"DIV",{class:!0});var le=b(S);m(A.$$.fragment,le),He=r(le),ee=d(le,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1st02i8"&&(ee.textContent=ct),Ae=r(le),V=d(le,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(V)!=="svelte-lwd2ft"&&(V.innerHTML=pt),le.forEach(s),Ve=r(c),D=d(c,"DIV",{class:!0});var Pe=b(D);m(W.$$.fragment,Pe),We=r(Pe),te=d(Pe,"P",{"data-svelte-h":!0}),p(te)!=="svelte-4nw43d"&&(te.textContent=ut),Pe.forEach(s),Ue=r(c),$=d(c,"DIV",{class:!0});var we=b($);m(U.$$.fragment,we),Re=r(we),se=d(we,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1d6o6zu"&&(se.textContent=mt),we.forEach(s),je=r(c),T=d(c,"DIV",{class:!0});var Ce=b(T);m(R.$$.fragment,Ce),Be=r(Ce),oe=d(Ce,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-17nne8p"&&(oe.textContent=ft),Ce.forEach(s),Ge=r(c),P=d(c,"DIV",{class:!0});var Le=b(P);m(j.$$.fragment,Le),Ye=r(Le),re=d(Le,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1rkfgpx"&&(re.textContent=ht),Le.forEach(s),Je=r(c),w=d(c,"DIV",{class:!0});var Oe=b(w);m(B.$$.fragment,Oe),Ke=r(Oe),ne=d(Oe,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1k141rk"&&(ne.textContent=gt),Oe.forEach(s),Ze=r(c),C=d(c,"DIV",{class:!0});var Ee=b(C);m(G.$$.fragment,Ee),Qe=r(Ee),ie=d(Ee,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1vzm9q"&&(ie.textContent=_t),Ee.forEach(s),Xe=r(c),L=d(c,"DIV",{class:!0});var Ie=b(L);m(Y.$$.fragment,Ie),et=r(Ie),de=d(Ie,"P",{"data-svelte-h":!0}),p(de)!=="svelte-7jbjgx"&&(de.textContent=vt),Ie.forEach(s),c.forEach(s),xe=r(e),m(J.$$.fragment,e),ye=r(e),y=d(e,"DIV",{class:!0});var qe=b(y);m(K.$$.fragment,qe),tt=r(qe),ae=d(qe,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-6ojmkw"&&(ae.innerHTML=bt),qe.forEach(s),De=r(e),m(Z.$$.fragment,e),$e=r(e),pe=d(e,"P",{}),b(pe).forEach(s),this.h()},h(){v(x,"name","hf:doc:metadata"),v(x,"content",wt),v(V,"class","tip"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){t(document.head,x),l(e,ue,n),l(e,ce,n),l(e,me,n),f(O,e,n),l(e,fe,n),l(e,E,n),l(e,he,n),l(e,I,n),l(e,ge,n),f(q,e,n),l(e,_e,n),l(e,N,n),l(e,ve,n),l(e,z,n),l(e,be,n),l(e,F,n),l(e,Se,n),f(k,e,n),l(e,Me,n),l(e,a,n),f(H,a,null),t(a,ze),t(a,Q),t(a,Fe),t(a,X),t(a,ke),t(a,S),f(A,S,null),t(S,He),t(S,ee),t(S,Ae),t(S,V),t(a,Ve),t(a,D),f(W,D,null),t(D,We),t(D,te),t(a,Ue),t(a,$),f(U,$,null),t($,Re),t($,se),t(a,je),t(a,T),f(R,T,null),t(T,Be),t(T,oe),t(a,Ge),t(a,P),f(j,P,null),t(P,Ye),t(P,re),t(a,Je),t(a,w),f(B,w,null),t(w,Ke),t(w,ne),t(a,Ze),t(a,C),f(G,C,null),t(C,Qe),t(C,ie),t(a,Xe),t(a,L),f(Y,L,null),t(L,et),t(L,de),l(e,xe,n),f(J,e,n),l(e,ye,n),l(e,y,n),f(K,y,null),t(y,tt),t(y,ae),l(e,De,n),f(Z,e,n),l(e,$e,n),l(e,pe,n),Te=!0},p:Mt,i(e){Te||(h(O.$$.fragment,e),h(q.$$.fragment,e),h(k.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(W.$$.fragment,e),h(U.$$.fragment,e),h(R.$$.fragment,e),h(j.$$.fragment,e),h(B.$$.fragment,e),h(G.$$.fragment,e),h(Y.$$.fragment,e),h(J.$$.fragment,e),h(K.$$.fragment,e),h(Z.$$.fragment,e),Te=!0)},o(e){g(O.$$.fragment,e),g(q.$$.fragment,e),g(k.$$.fragment,e),g(H.$$.fragment,e),g(A.$$.fragment,e),g(W.$$.fragment,e),g(U.$$.fragment,e),g(R.$$.fragment,e),g(j.$$.fragment,e),g(B.$$.fragment,e),g(G.$$.fragment,e),g(Y.$$.fragment,e),g(J.$$.fragment,e),g(K.$$.fragment,e),g(Z.$$.fragment,e),Te=!1},d(e){e&&(s(ue),s(ce),s(me),s(fe),s(E),s(he),s(I),s(ge),s(_e),s(N),s(ve),s(z),s(be),s(F),s(Se),s(Me),s(a),s(xe),s(ye),s(y),s(De),s($e),s(pe)),s(x),_(O,e),_(q,e),_(k,e),_(H),_(A),_(W),_(U),_(R),_(j),_(B),_(G),_(Y),_(J,e),_(K),_(Z,e)}}}const wt='{"title":"DPMSolverMultistepScheduler","local":"dpmsolvermultistepscheduler","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"DPMSolverMultistepScheduler","local":"diffusers.DPMSolverMultistepScheduler","sections":[],"depth":2},{"title":"SchedulerOutput","local":"diffusers.schedulers.scheduling_utils.SchedulerOutput","sections":[],"depth":2}],"depth":1}';function Ct(st){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends yt{constructor(x){super(),Dt(this,x,Ct,Pt,St,{})}}export{qt as component};
