import{s as mi,n as ci,o as fi}from"../chunks/scheduler.888833de.js";import{S as ui,i as gi,e as r,s as i,c as m,h as hi,a as l,d as n,b as s,f as w,j as p,g as c,k as b,l as o,m as a,n as f,t as u,o as g,p as h}from"../chunks/index.128ce987.js";import{D as y}from"../chunks/Docstring.23ed6b62.js";import{C as Ce}from"../chunks/CodeBlock.37df032e.js";import{H as T,E as _i}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function bi($n){let x,Oe,qe,Ke,M,In="<p>This pipeline is deprecated but it can still be used. However, we won’t test the pipeline anymore and won’t accept any changes to it. If you run into any issues, reinstall the last Diffusers version that supported this model.</p>",et,B,tt,U,jn='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',nt,L,Wn='The UniDiffuser model was proposed in <a href="https://huggingface.co/papers/2303.06555" rel="nofollow">One Transformer Fits All Distributions in Multi-Modal Diffusion at Scale</a> by Fan Bao, Shen Nie, Kaiwen Xue, Chongxuan Li, Shi Pu, Yaole Wang, Gang Yue, Yue Cao, Hang Su, Jun Zhu.',it,R,Gn="The abstract from the paper is:",st,N,Xn="<em>This paper proposes a unified diffusion framework (dubbed UniDiffuser) to fit all distributions relevant to a set of multi-modal data in one model. Our key insight is — learning diffusion models for marginal, conditional, and joint distributions can be unified as predicting the noise in the perturbed data, where the perturbation levels (i.e. timesteps) can be different for different modalities. Inspired by the unified view, UniDiffuser learns all distributions simultaneously with a minimal modification to the original diffusion model — perturbs data in all modalities instead of a single modality, inputs individual timesteps in different modalities, and predicts the noise of all modalities instead of a single modality. UniDiffuser is parameterized by a transformer for diffusion models to handle input types of different modalities. Implemented on large-scale paired image-text data, UniDiffuser is able to perform image, text, text-to-image, image-to-text, and image-text pair generation by setting proper timesteps without additional overhead. In particular, UniDiffuser is able to produce perceptually realistic samples in all tasks and its quantitative results (e.g., the FID and CLIP score) are not only superior to existing general-purpose models but also comparable to the bespoken models (e.g., Stable Diffusion and DALL-E 2) in representative tasks (e.g., text-to-image generation).</em>",at,F,Cn='You can find the original codebase at <a href="https://github.com/thu-ml/unidiffuser" rel="nofollow">thu-ml/unidiffuser</a> and additional checkpoints at <a href="https://huggingface.co/thu-ml" rel="nofollow">thu-ml</a>.',ot,J,Pn="<p>There is currently an issue on PyTorch 1.X where the output images are all black or the pixel values become <code>NaNs</code>. This issue can be mitigated by switching to PyTorch 2.X.</p>",rt,Q,Vn='This pipeline was contributed by <a href="https://github.com/dg845" rel="nofollow">dg845</a>. ❤️',lt,z,pt,S,Dn="Because the UniDiffuser model is trained to model the joint distribution of (image, text) pairs, it is capable of performing a diverse range of generation tasks:",dt,Y,mt,H,En='Unconditional generation (where we start from only latents sampled from a standard Gaussian prior) from a <a href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline">UniDiffuserPipeline</a> will produce a (image, text) pair:',ct,q,ft,A,kn="This is also called “joint” generation in the UniDiffuser paper, since we are sampling from the joint image-text distribution.",ut,O,Bn=`Note that the generation task is inferred from the inputs used when calling the pipeline.
It is also possible to manually specify the unconditional generation task (“mode”) manually with <a href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline.set_joint_mode">UniDiffuserPipeline.set_joint_mode()</a>:`,gt,K,ht,ee,Ln=`When the mode is set manually, subsequent calls to the pipeline will use the set mode without attempting to infer the mode.
You can reset the mode with <a href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline.reset_mode">UniDiffuserPipeline.reset_mode()</a>, after which the pipeline will once again infer the mode.`,_t,te,Rn="You can also generate only an image or only text (which the UniDiffuser paper calls “marginal” generation since we sample from the marginal distribution of images and text, respectively):",bt,ne,wt,ie,yt,se,Nn=`UniDiffuser is also capable of sampling from conditional distributions; that is, the distribution of images conditioned on a text prompt or the distribution of texts conditioned on an image.
Here is an example of sampling from the conditional image distribution (text-to-image generation or text-conditioned image generation):`,xt,ae,vt,oe,Fn='The <code>text2img</code> mode requires that either an input <code>prompt</code> or <code>prompt_embeds</code> be supplied. You can set the <code>text2img</code> mode manually with <a href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline.set_text_to_image_mode">UniDiffuserPipeline.set_text_to_image_mode()</a>.',Tt,re,Mt,le,Qn="Similarly, UniDiffuser can also produce text samples given an image (image-to-text or image-conditioned text generation):",Ut,pe,Jt,de,zn='The <code>img2text</code> mode requires that an input <code>image</code> be supplied. You can set the <code>img2text</code> mode manually with <a href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline.set_image_to_text_mode">UniDiffuserPipeline.set_image_to_text_mode()</a>.',Zt,me,$t,ce,Sn=`The UniDiffuser authors suggest performing image variation through a “round-trip” generation method, where given an input image, we first perform an image-to-text generation, and then perform a text-to-image generation on the outputs of the first generation.
This produces a new image which is semantically similar to the input image:`,It,fe,jt,ue,Wt,ge,Yn="Similarly, text variation can be performed on an input prompt with a text-to-image generation followed by a image-to-text generation:",Gt,he,Xt,Z,Hn='<p>Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.</p>',Ct,_e,Pt,d,be,en,Pe,qn=`Pipeline for a bimodal image-text model which supports unconditional text and image generation, text-conditioned
image generation, image-conditioned text generation, and joint image-text generation.`,tn,Ve,An=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,nn,$,we,sn,De,On="The call function to the pipeline for generation.",an,I,ye,on,Ee,Kn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,rn,j,xe,ln,ke,ei=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,pn,W,ve,dn,Be,ti=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,mn,G,Te,cn,Le,ni=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,fn,X,Me,un,Re,ii="Encodes the prompt into text encoder hidden states.",gn,C,Ue,hn,Ne,si="Removes a manually set mode; after calling this, the pipeline will infer the mode from inputs.",_n,P,Je,bn,Fe,ai="Manually set the generation mode to unconditional (“marginal”) image generation.",wn,V,Ze,yn,Qe,oi="Manually set the generation mode to image-conditioned text generation.",xn,D,$e,vn,ze,ri="Manually set the generation mode to unconditional joint image-text generation.",Tn,E,Ie,Mn,Se,li="Manually set the generation mode to unconditional (“marginal”) text generation.",Un,k,je,Jn,Ye,pi="Manually set the generation mode to text-conditioned image generation.",Vt,We,Dt,v,Ge,Zn,He,di="Output class for joint image-text pipelines.",Et,Xe,kt,Ae,Bt;return B=new T({props:{title:"UniDiffuser",local:"unidiffuser",headingTag:"h1"}}),z=new T({props:{title:"Usage Examples",local:"usage-examples",headingTag:"h2"}}),Y=new T({props:{title:"Unconditional Image and Text Generation",local:"unconditional-image-and-text-generation",headingTag:"h3"}}),q=new Ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9pZF9vcl9wYXRoJTIwJTNEJTIwJTIydGh1LW1sJTJGdW5pZGlmZnVzZXItdjElMjIlMEFwaXBlJTIwJTNEJTIwVW5pRGlmZnVzZXJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKGRldmljZSklMEElMEElMjMlMjBVbmNvbmRpdGlvbmFsJTIwaW1hZ2UlMjBhbmQlMjB0ZXh0JTIwZ2VuZXJhdGlvbi4lMjBUaGUlMjBnZW5lcmF0aW9uJTIwdGFzayUyMGlzJTIwYXV0b21hdGljYWxseSUyMGluZmVycmVkLiUwQXNhbXBsZSUyMCUzRCUyMHBpcGUobnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4LjApJTBBaW1hZ2UlMjAlM0QlMjBzYW1wbGUuaW1hZ2VzJTVCMCU1RCUwQXRleHQlMjAlM0QlMjBzYW1wbGUudGV4dCU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnVuaWRpZmZ1c2VyX2pvaW50X3NhbXBsZV9pbWFnZS5wbmclMjIpJTBBcHJpbnQodGV4dCk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Unconditional image and text generation. The generation task is automatically inferred.</span>
sample = pipe(num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
image = sample.images[<span class="hljs-number">0</span>]
text = sample.text[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;unidiffuser_joint_sample_image.png&quot;</span>)
<span class="hljs-built_in">print</span>(text)`,wrap:!1}}),K=new Ce({props:{code:"JTIzJTIwRXF1aXZhbGVudCUyMHRvJTIwdGhlJTIwYWJvdmUuJTBBcGlwZS5zZXRfam9pbnRfbW9kZSgpJTBBc2FtcGxlJTIwJTNEJTIwcGlwZShudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDguMCk=",highlighted:`<span class="hljs-comment"># Equivalent to the above.</span>
pipe.set_joint_mode()
sample = pipe(num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)`,wrap:!1}}),ne=new Ce({props:{code:"JTIzJTIwVW5saWtlJTIwb3RoZXIlMjBnZW5lcmF0aW9uJTIwdGFza3MlMkMlMjBpbWFnZS1vbmx5JTIwYW5kJTIwdGV4dC1vbmx5JTIwZ2VuZXJhdGlvbiUyMGRvbid0JTIwdXNlJTIwY2xhc3NpZmllci1mcmVlJTIwZ3VpZGFuY2UlMEElMjMlMjBJbWFnZS1vbmx5JTIwZ2VuZXJhdGlvbiUwQXBpcGUuc2V0X2ltYWdlX21vZGUoKSUwQXNhbXBsZV9pbWFnZSUyMCUzRCUyMHBpcGUobnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwKS5pbWFnZXMlNUIwJTVEJTBBJTIzJTIwVGV4dC1vbmx5JTIwZ2VuZXJhdGlvbiUwQXBpcGUuc2V0X3RleHRfbW9kZSgpJTBBc2FtcGxlX3RleHQlMjAlM0QlMjBwaXBlKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCkudGV4dCU1QjAlNUQ=",highlighted:`<span class="hljs-comment"># Unlike other generation tasks, image-only and text-only generation don&#x27;t use classifier-free guidance</span>
<span class="hljs-comment"># Image-only generation</span>
pipe.set_image_mode()
sample_image = pipe(num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-comment"># Text-only generation</span>
pipe.set_text_mode()
sample_text = pipe(num_inference_steps=<span class="hljs-number">20</span>).text[<span class="hljs-number">0</span>]`,wrap:!1}}),ie=new T({props:{title:"Text-to-Image Generation",local:"text-to-image-generation",headingTag:"h3"}}),ae=new Ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9pZF9vcl9wYXRoJTIwJTNEJTIwJTIydGh1LW1sJTJGdW5pZGlmZnVzZXItdjElMjIlMEFwaXBlJTIwJTNEJTIwVW5pRGlmZnVzZXJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKGRldmljZSklMEElMEElMjMlMjBUZXh0LXRvLWltYWdlJTIwZ2VuZXJhdGlvbiUwQXByb21wdCUyMCUzRCUyMCUyMmFuJTIwZWxlcGhhbnQlMjB1bmRlciUyMHRoZSUyMHNlYSUyMiUwQSUwQXNhbXBsZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4LjApJTBBdDJpX2ltYWdlJTIwJTNEJTIwc2FtcGxlLmltYWdlcyU1QjAlNUQlMEF0MmlfaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Text-to-image generation</span>
prompt = <span class="hljs-string">&quot;an elephant under the sea&quot;</span>

sample = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
t2i_image = sample.images[<span class="hljs-number">0</span>]
t2i_image`,wrap:!1}}),re=new T({props:{title:"Image-to-Text Generation",local:"image-to-text-generation",headingTag:"h3"}}),pe=new Ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkX29yX3BhdGglMjAlM0QlMjAlMjJ0aHUtbWwlMkZ1bmlkaWZmdXNlci12MSUyMiUwQXBpcGUlMjAlM0QlMjBVbmlEaWZmdXNlclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZF9vcl9wYXRoJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUudG8oZGV2aWNlKSUwQSUwQSUyMyUyMEltYWdlLXRvLXRleHQlMjBnZW5lcmF0aW9uJTBBaW1hZ2VfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnVuaWRpZmZ1c2VyJTJGdW5pZGlmZnVzZXJfZXhhbXBsZV9pbWFnZS5qcGclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWFnZV91cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFzYW1wbGUlMjAlM0QlMjBwaXBlKGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKSUwQWkydF90ZXh0JTIwJTNEJTIwc2FtcGxlLnRleHQlNUIwJTVEJTBBcHJpbnQoaTJ0X3RleHQp",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Image-to-text generation</span>
image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/unidiffuser/unidiffuser_example_image.jpg&quot;</span>
init_image = load_image(image_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

sample = pipe(image=init_image, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
i2t_text = sample.text[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(i2t_text)`,wrap:!1}}),me=new T({props:{title:"Image Variation",local:"image-variation",headingTag:"h3"}}),fe=new Ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkX29yX3BhdGglMjAlM0QlMjAlMjJ0aHUtbWwlMkZ1bmlkaWZmdXNlci12MSUyMiUwQXBpcGUlMjAlM0QlMjBVbmlEaWZmdXNlclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZF9vcl9wYXRoJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUudG8oZGV2aWNlKSUwQSUwQSUyMyUyMEltYWdlJTIwdmFyaWF0aW9uJTIwY2FuJTIwYmUlMjBwZXJmb3JtZWQlMjB3aXRoJTIwYW4lMjBpbWFnZS10by10ZXh0JTIwZ2VuZXJhdGlvbiUyMGZvbGxvd2VkJTIwYnklMjBhJTIwdGV4dC10by1pbWFnZSUyMGdlbmVyYXRpb24lM0ElMEElMjMlMjAxLiUyMEltYWdlLXRvLXRleHQlMjBnZW5lcmF0aW9uJTBBaW1hZ2VfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnVuaWRpZmZ1c2VyJTJGdW5pZGlmZnVzZXJfZXhhbXBsZV9pbWFnZS5qcGclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWFnZV91cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFzYW1wbGUlMjAlM0QlMjBwaXBlKGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKSUwQWkydF90ZXh0JTIwJTNEJTIwc2FtcGxlLnRleHQlNUIwJTVEJTBBcHJpbnQoaTJ0X3RleHQpJTBBJTBBJTIzJTIwMi4lMjBUZXh0LXRvLWltYWdlJTIwZ2VuZXJhdGlvbiUwQXNhbXBsZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEaTJ0X3RleHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDguMCklMEFmaW5hbF9pbWFnZSUyMCUzRCUyMHNhbXBsZS5pbWFnZXMlNUIwJTVEJTBBZmluYWxfaW1hZ2Uuc2F2ZSglMjJ1bmlkaWZmdXNlcl9pbWFnZV92YXJpYXRpb25fc2FtcGxlLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Image variation can be performed with an image-to-text generation followed by a text-to-image generation:</span>
<span class="hljs-comment"># 1. Image-to-text generation</span>
image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/unidiffuser/unidiffuser_example_image.jpg&quot;</span>
init_image = load_image(image_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

sample = pipe(image=init_image, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
i2t_text = sample.text[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(i2t_text)

<span class="hljs-comment"># 2. Text-to-image generation</span>
sample = pipe(prompt=i2t_text, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
final_image = sample.images[<span class="hljs-number">0</span>]
final_image.save(<span class="hljs-string">&quot;unidiffuser_image_variation_sample.png&quot;</span>)`,wrap:!1}}),ue=new T({props:{title:"Text Variation",local:"text-variation",headingTag:"h3"}}),he=new Ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9pZF9vcl9wYXRoJTIwJTNEJTIwJTIydGh1LW1sJTJGdW5pZGlmZnVzZXItdjElMjIlMEFwaXBlJTIwJTNEJTIwVW5pRGlmZnVzZXJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKGRldmljZSklMEElMEElMjMlMjBUZXh0JTIwdmFyaWF0aW9uJTIwY2FuJTIwYmUlMjBwZXJmb3JtZWQlMjB3aXRoJTIwYSUyMHRleHQtdG8taW1hZ2UlMjBnZW5lcmF0aW9uJTIwZm9sbG93ZWQlMjBieSUyMGElMjBpbWFnZS10by10ZXh0JTIwZ2VuZXJhdGlvbiUzQSUwQSUyMyUyMDEuJTIwVGV4dC10by1pbWFnZSUyMGdlbmVyYXRpb24lMEFwcm9tcHQlMjAlM0QlMjAlMjJhbiUyMGVsZXBoYW50JTIwdW5kZXIlMjB0aGUlMjBzZWElMjIlMEElMEFzYW1wbGUlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKSUwQXQyaV9pbWFnZSUyMCUzRCUyMHNhbXBsZS5pbWFnZXMlNUIwJTVEJTBBdDJpX2ltYWdlLnNhdmUoJTIydW5pZGlmZnVzZXJfdGV4dDJpbWdfc2FtcGxlX2ltYWdlLnBuZyUyMiklMEElMEElMjMlMjAyLiUyMEltYWdlLXRvLXRleHQlMjBnZW5lcmF0aW9uJTBBc2FtcGxlJTIwJTNEJTIwcGlwZShpbWFnZSUzRHQyaV9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKSUwQWZpbmFsX3Byb21wdCUyMCUzRCUyMHNhbXBsZS50ZXh0JTVCMCU1RCUwQXByaW50KGZpbmFsX3Byb21wdCk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Text variation can be performed with a text-to-image generation followed by a image-to-text generation:</span>
<span class="hljs-comment"># 1. Text-to-image generation</span>
prompt = <span class="hljs-string">&quot;an elephant under the sea&quot;</span>

sample = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
t2i_image = sample.images[<span class="hljs-number">0</span>]
t2i_image.save(<span class="hljs-string">&quot;unidiffuser_text2img_sample_image.png&quot;</span>)

<span class="hljs-comment"># 2. Image-to-text generation</span>
sample = pipe(image=t2i_image, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
final_prompt = sample.text[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(final_prompt)`,wrap:!1}}),_e=new T({props:{title:"UniDiffuserPipeline",local:"diffusers.UniDiffuserPipeline",headingTag:"h2"}}),be=new y({props:{name:"class diffusers.UniDiffuserPipeline",anchor:"diffusers.UniDiffuserPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"clip_image_processor",val:": CLIPImageProcessor"},{name:"clip_tokenizer",val:": CLIPTokenizer"},{name:"text_decoder",val:": UniDiffuserTextDecoder"},{name:"text_tokenizer",val:": GPT2Tokenizer"},{name:"unet",val:": UniDiffuserModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.UniDiffuserPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations. This
is part of the UniDiffuser image representation along with the CLIP vision encoding.`,name:"vae"},{anchor:"diffusers.UniDiffuserPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.UniDiffuserPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModel</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModel" rel="nofollow">CLIPVisionModel</a> to encode images as part of its image representation along with the VAE
latent representation.`,name:"image_encoder"},{anchor:"diffusers.UniDiffuserPipeline.image_processor",description:`<strong>image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a> to preprocess an image before CLIP encoding it with <code>image_encoder</code>.`,name:"image_processor"},{anchor:"diffusers.UniDiffuserPipeline.clip_tokenizer",description:`<strong>clip_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize the prompt before encoding it with <code>text_encoder</code>.`,name:"clip_tokenizer"},{anchor:"diffusers.UniDiffuserPipeline.text_decoder",description:`<strong>text_decoder</strong> (<code>UniDiffuserTextDecoder</code>) &#x2014;
Frozen text decoder. This is a GPT-style model which is used to generate text from the UniDiffuser
embedding.`,name:"text_decoder"},{anchor:"diffusers.UniDiffuserPipeline.text_tokenizer",description:`<strong>text_tokenizer</strong> (<code>GPT2Tokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Tokenizer" rel="nofollow">GPT2Tokenizer</a> to decode text for text generation; used along with the <code>text_decoder</code>.`,name:"text_tokenizer"},{anchor:"diffusers.UniDiffuserPipeline.unet",description:`<strong>unet</strong> (<code>UniDiffuserModel</code>) &#x2014;
A <a href="https://github.com/baofff/U-ViT" rel="nofollow">U-ViT</a> model with UNNet-style skip connections between transformer
layers to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.UniDiffuserPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image and/or text latents. The
original UniDiffuser paper uses the <a href="/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> scheduler.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L65"}}),we=new y({props:{name:"__call__",anchor:"diffusers.UniDiffuserPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[torch.Tensor, PIL.Image.Image, NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"data_type",val:": typing.Optional[int] = 1"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 8.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"num_prompts_per_image",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_latents",val:": typing.Optional[torch.Tensor] = None"},{name:"vae_latents",val:": typing.Optional[torch.Tensor] = None"},{name:"clip_latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Optional[typing.Callable[[int, int, torch.Tensor], NoneType]] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"diffusers.UniDiffuserPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.
Required for text-conditioned image generation (<code>text2img</code>) mode.`,name:"prompt"},{anchor:"diffusers.UniDiffuserPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code> or <code>PIL.Image.Image</code>, <em>optional</em>) &#x2014;
<code>Image</code> or tensor representing an image batch. Required for image-conditioned text generation
(<code>img2text</code>) mode.`,name:"image"},{anchor:"diffusers.UniDiffuserPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.UniDiffuserPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.UniDiffuserPipeline.__call__.data_type",description:`<strong>data_type</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The data type (either 0 or 1). Only used if you are loading a checkpoint which supports a data type
embedding; this is added for compatibility with the
<a href="https://huggingface.co/thu-ml/unidiffuser-v1" rel="nofollow">UniDiffuser-v1</a> checkpoint.`,name:"data_type"},{anchor:"diffusers.UniDiffuserPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.UniDiffuserPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 8.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.UniDiffuserPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>). Used in
text-conditioned image generation (<code>text2img</code>) mode.`,name:"negative_prompt"},{anchor:"diffusers.UniDiffuserPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt. Used in <code>text2img</code> (text-conditioned image generation) and
<code>img</code> mode. If the mode is joint and both <code>num_images_per_prompt</code> and <code>num_prompts_per_image</code> are
supplied, <code>min(num_images_per_prompt, num_prompts_per_image)</code> samples are generated.`,name:"num_images_per_prompt"},{anchor:"diffusers.UniDiffuserPipeline.__call__.num_prompts_per_image",description:`<strong>num_prompts_per_image</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of prompts to generate per image. Used in <code>img2text</code> (image-conditioned text generation) and
<code>text</code> mode. If the mode is joint and both <code>num_images_per_prompt</code> and <code>num_prompts_per_image</code> are
supplied, <code>min(num_images_per_prompt, num_prompts_per_image)</code> samples are generated.`,name:"num_prompts_per_image"},{anchor:"diffusers.UniDiffuserPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.UniDiffuserPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.UniDiffuserPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for joint
image-text generation. Can be used to tweak the same generation with different prompts. If not
provided, a latents tensor is generated by sampling using the supplied random <code>generator</code>. This assumes
a full set of VAE, CLIP, and text latents, if supplied, overrides the value of <code>prompt_latents</code>,
<code>vae_latents</code>, and <code>clip_latents</code>.`,name:"latents"},{anchor:"diffusers.UniDiffuserPipeline.__call__.prompt_latents",description:`<strong>prompt_latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for text
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"prompt_latents"},{anchor:"diffusers.UniDiffuserPipeline.__call__.vae_latents",description:`<strong>vae_latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"vae_latents"},{anchor:"diffusers.UniDiffuserPipeline.__call__.clip_latents",description:`<strong>clip_latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"clip_latents"},{anchor:"diffusers.UniDiffuserPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument. Used in text-conditioned
image generation (<code>text2img</code>) mode.`,name:"prompt_embeds"},{anchor:"diffusers.UniDiffuserPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are be generated from the <code>negative_prompt</code> input argument. Used
in text-conditioned image generation (<code>text2img</code>) mode.`,name:"negative_prompt_embeds"},{anchor:"diffusers.UniDiffuserPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.UniDiffuserPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.ImageTextPipelineOutput">ImageTextPipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.UniDiffuserPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.UniDiffuserPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L1119",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.ImageTextPipelineOutput"
>ImageTextPipelineOutput</a> is returned, otherwise a
<code>tuple</code> is returned where the first element is a list with the generated images and the second element
is a list of generated texts.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.ImageTextPipelineOutput"
>ImageTextPipelineOutput</a> or <code>tuple</code></p>
`}}),ye=new y({props:{name:"disable_vae_slicing",anchor:"diffusers.UniDiffuserPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L244"}}),xe=new y({props:{name:"disable_vae_tiling",anchor:"diffusers.UniDiffuserPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L273"}}),ve=new y({props:{name:"enable_vae_slicing",anchor:"diffusers.UniDiffuserPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L230"}}),Te=new y({props:{name:"enable_vae_tiling",anchor:"diffusers.UniDiffuserPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L258"}}),Me=new y({props:{name:"encode_prompt",anchor:"diffusers.UniDiffuserPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L421"}}),Ue=new y({props:{name:"reset_mode",anchor:"diffusers.UniDiffuserPipeline.reset_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L307"}}),Je=new y({props:{name:"set_image_mode",anchor:"diffusers.UniDiffuserPipeline.set_image_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L291"}}),Ze=new y({props:{name:"set_image_to_text_mode",anchor:"diffusers.UniDiffuserPipeline.set_image_to_text_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L299"}}),$e=new y({props:{name:"set_joint_mode",anchor:"diffusers.UniDiffuserPipeline.set_joint_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L303"}}),Ie=new y({props:{name:"set_text_mode",anchor:"diffusers.UniDiffuserPipeline.set_text_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L287"}}),je=new y({props:{name:"set_text_to_image_mode",anchor:"diffusers.UniDiffuserPipeline.set_text_to_image_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L295"}}),We=new T({props:{title:"ImageTextPipelineOutput",local:"diffusers.ImageTextPipelineOutput",headingTag:"h2"}}),Ge=new y({props:{name:"class diffusers.ImageTextPipelineOutput",anchor:"diffusers.ImageTextPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray, NoneType]"},{name:"text",val:": typing.Union[typing.List[str], typing.List[typing.List[str]], NoneType]"}],parametersDescription:[{anchor:"diffusers.ImageTextPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.ImageTextPipelineOutput.text",description:`<strong>text</strong> (<code>List[str]</code> or <code>List[List[str]]</code>) &#x2014;
List of generated text strings of length <code>batch_size</code> or a list of list of strings whose outer list has
length <code>batch_size</code>.`,name:"text"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L48"}}),Xe=new _i({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/unidiffuser.md"}}),{c(){x=r("meta"),Oe=i(),qe=r("p"),Ke=i(),M=r("blockquote"),M.innerHTML=In,et=i(),m(B.$$.fragment),tt=i(),U=r("div"),U.innerHTML=jn,nt=i(),L=r("p"),L.innerHTML=Wn,it=i(),R=r("p"),R.textContent=Gn,st=i(),N=r("p"),N.innerHTML=Xn,at=i(),F=r("p"),F.innerHTML=Cn,ot=i(),J=r("blockquote"),J.innerHTML=Pn,rt=i(),Q=r("p"),Q.innerHTML=Vn,lt=i(),m(z.$$.fragment),pt=i(),S=r("p"),S.textContent=Dn,dt=i(),m(Y.$$.fragment),mt=i(),H=r("p"),H.innerHTML=En,ct=i(),m(q.$$.fragment),ft=i(),A=r("p"),A.textContent=kn,ut=i(),O=r("p"),O.innerHTML=Bn,gt=i(),m(K.$$.fragment),ht=i(),ee=r("p"),ee.innerHTML=Ln,_t=i(),te=r("p"),te.textContent=Rn,bt=i(),m(ne.$$.fragment),wt=i(),m(ie.$$.fragment),yt=i(),se=r("p"),se.textContent=Nn,xt=i(),m(ae.$$.fragment),vt=i(),oe=r("p"),oe.innerHTML=Fn,Tt=i(),m(re.$$.fragment),Mt=i(),le=r("p"),le.textContent=Qn,Ut=i(),m(pe.$$.fragment),Jt=i(),de=r("p"),de.innerHTML=zn,Zt=i(),m(me.$$.fragment),$t=i(),ce=r("p"),ce.textContent=Sn,It=i(),m(fe.$$.fragment),jt=i(),m(ue.$$.fragment),Wt=i(),ge=r("p"),ge.textContent=Yn,Gt=i(),m(he.$$.fragment),Xt=i(),Z=r("blockquote"),Z.innerHTML=Hn,Ct=i(),m(_e.$$.fragment),Pt=i(),d=r("div"),m(be.$$.fragment),en=i(),Pe=r("p"),Pe.textContent=qn,tn=i(),Ve=r("p"),Ve.innerHTML=An,nn=i(),$=r("div"),m(we.$$.fragment),sn=i(),De=r("p"),De.textContent=On,an=i(),I=r("div"),m(ye.$$.fragment),on=i(),Ee=r("p"),Ee.innerHTML=Kn,rn=i(),j=r("div"),m(xe.$$.fragment),ln=i(),ke=r("p"),ke.innerHTML=ei,pn=i(),W=r("div"),m(ve.$$.fragment),dn=i(),Be=r("p"),Be.textContent=ti,mn=i(),G=r("div"),m(Te.$$.fragment),cn=i(),Le=r("p"),Le.textContent=ni,fn=i(),X=r("div"),m(Me.$$.fragment),un=i(),Re=r("p"),Re.textContent=ii,gn=i(),C=r("div"),m(Ue.$$.fragment),hn=i(),Ne=r("p"),Ne.textContent=si,_n=i(),P=r("div"),m(Je.$$.fragment),bn=i(),Fe=r("p"),Fe.textContent=ai,wn=i(),V=r("div"),m(Ze.$$.fragment),yn=i(),Qe=r("p"),Qe.textContent=oi,xn=i(),D=r("div"),m($e.$$.fragment),vn=i(),ze=r("p"),ze.textContent=ri,Tn=i(),E=r("div"),m(Ie.$$.fragment),Mn=i(),Se=r("p"),Se.textContent=li,Un=i(),k=r("div"),m(je.$$.fragment),Jn=i(),Ye=r("p"),Ye.textContent=pi,Vt=i(),m(We.$$.fragment),Dt=i(),v=r("div"),m(Ge.$$.fragment),Zn=i(),He=r("p"),He.textContent=di,Et=i(),m(Xe.$$.fragment),kt=i(),Ae=r("p"),this.h()},l(e){const t=hi("svelte-u9bgzb",document.head);x=l(t,"META",{name:!0,content:!0}),t.forEach(n),Oe=s(e),qe=l(e,"P",{}),w(qe).forEach(n),Ke=s(e),M=l(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(M)!=="svelte-124tjg"&&(M.innerHTML=In),et=s(e),c(B.$$.fragment,e),tt=s(e),U=l(e,"DIV",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-si9ct8"&&(U.innerHTML=jn),nt=s(e),L=l(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-x4qgym"&&(L.innerHTML=Wn),it=s(e),R=l(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1cwsb16"&&(R.textContent=Gn),st=s(e),N=l(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1rrofj2"&&(N.innerHTML=Xn),at=s(e),F=l(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1mkhqav"&&(F.innerHTML=Cn),ot=s(e),J=l(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(J)!=="svelte-5fhayf"&&(J.innerHTML=Pn),rt=s(e),Q=l(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1eykv1b"&&(Q.innerHTML=Vn),lt=s(e),c(z.$$.fragment,e),pt=s(e),S=l(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-cbm0c5"&&(S.textContent=Dn),dt=s(e),c(Y.$$.fragment,e),mt=s(e),H=l(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-c6xivp"&&(H.innerHTML=En),ct=s(e),c(q.$$.fragment,e),ft=s(e),A=l(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-19mmnnc"&&(A.textContent=kn),ut=s(e),O=l(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-uomou7"&&(O.innerHTML=Bn),gt=s(e),c(K.$$.fragment,e),ht=s(e),ee=l(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-tnllgp"&&(ee.innerHTML=Ln),_t=s(e),te=l(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1y647uj"&&(te.textContent=Rn),bt=s(e),c(ne.$$.fragment,e),wt=s(e),c(ie.$$.fragment,e),yt=s(e),se=l(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-euu6tg"&&(se.textContent=Nn),xt=s(e),c(ae.$$.fragment,e),vt=s(e),oe=l(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-19zjjlo"&&(oe.innerHTML=Fn),Tt=s(e),c(re.$$.fragment,e),Mt=s(e),le=l(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-tubb14"&&(le.textContent=Qn),Ut=s(e),c(pe.$$.fragment,e),Jt=s(e),de=l(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1sf5a0r"&&(de.innerHTML=zn),Zt=s(e),c(me.$$.fragment,e),$t=s(e),ce=l(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-lnxqa8"&&(ce.textContent=Sn),It=s(e),c(fe.$$.fragment,e),jt=s(e),c(ue.$$.fragment,e),Wt=s(e),ge=l(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1t6lzo0"&&(ge.textContent=Yn),Gt=s(e),c(he.$$.fragment,e),Xt=s(e),Z=l(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(Z)!=="svelte-r1jcqf"&&(Z.innerHTML=Hn),Ct=s(e),c(_e.$$.fragment,e),Pt=s(e),d=l(e,"DIV",{class:!0});var _=w(d);c(be.$$.fragment,_),en=s(_),Pe=l(_,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-qg5tdp"&&(Pe.textContent=qn),tn=s(_),Ve=l(_,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-496sm0"&&(Ve.innerHTML=An),nn=s(_),$=l(_,"DIV",{class:!0});var Lt=w($);c(we.$$.fragment,Lt),sn=s(Lt),De=l(Lt,"P",{"data-svelte-h":!0}),p(De)!=="svelte-50j04k"&&(De.textContent=On),Lt.forEach(n),an=s(_),I=l(_,"DIV",{class:!0});var Rt=w(I);c(ye.$$.fragment,Rt),on=s(Rt),Ee=l(Rt,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1s3c06i"&&(Ee.innerHTML=Kn),Rt.forEach(n),rn=s(_),j=l(_,"DIV",{class:!0});var Nt=w(j);c(xe.$$.fragment,Nt),ln=s(Nt),ke=l(Nt,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-pkn4ui"&&(ke.innerHTML=ei),Nt.forEach(n),pn=s(_),W=l(_,"DIV",{class:!0});var Ft=w(W);c(ve.$$.fragment,Ft),dn=s(Ft),Be=l(Ft,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-14bnrb6"&&(Be.textContent=ti),Ft.forEach(n),mn=s(_),G=l(_,"DIV",{class:!0});var Qt=w(G);c(Te.$$.fragment,Qt),cn=s(Qt),Le=l(Qt,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1xwrf7t"&&(Le.textContent=ni),Qt.forEach(n),fn=s(_),X=l(_,"DIV",{class:!0});var zt=w(X);c(Me.$$.fragment,zt),un=s(zt),Re=l(zt,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-16q0ax1"&&(Re.textContent=ii),zt.forEach(n),gn=s(_),C=l(_,"DIV",{class:!0});var St=w(C);c(Ue.$$.fragment,St),hn=s(St),Ne=l(St,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-ycux85"&&(Ne.textContent=si),St.forEach(n),_n=s(_),P=l(_,"DIV",{class:!0});var Yt=w(P);c(Je.$$.fragment,Yt),bn=s(Yt),Fe=l(Yt,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-f12s4l"&&(Fe.textContent=ai),Yt.forEach(n),wn=s(_),V=l(_,"DIV",{class:!0});var Ht=w(V);c(Ze.$$.fragment,Ht),yn=s(Ht),Qe=l(Ht,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1b9y8l5"&&(Qe.textContent=oi),Ht.forEach(n),xn=s(_),D=l(_,"DIV",{class:!0});var qt=w(D);c($e.$$.fragment,qt),vn=s(qt),ze=l(qt,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-u7njpc"&&(ze.textContent=ri),qt.forEach(n),Tn=s(_),E=l(_,"DIV",{class:!0});var At=w(E);c(Ie.$$.fragment,At),Mn=s(At),Se=l(At,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-p08nnp"&&(Se.textContent=li),At.forEach(n),Un=s(_),k=l(_,"DIV",{class:!0});var Ot=w(k);c(je.$$.fragment,Ot),Jn=s(Ot),Ye=l(Ot,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-rah46x"&&(Ye.textContent=pi),Ot.forEach(n),_.forEach(n),Vt=s(e),c(We.$$.fragment,e),Dt=s(e),v=l(e,"DIV",{class:!0});var Kt=w(v);c(Ge.$$.fragment,Kt),Zn=s(Kt),He=l(Kt,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1i2ycus"&&(He.textContent=di),Kt.forEach(n),Et=s(e),c(Xe.$$.fragment,e),kt=s(e),Ae=l(e,"P",{}),w(Ae).forEach(n),this.h()},h(){b(x,"name","hf:doc:metadata"),b(x,"content",wi),b(M,"class","warning"),b(U,"class","flex flex-wrap space-x-1"),b(J,"class","warning"),b(Z,"class","tip"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){o(document.head,x),a(e,Oe,t),a(e,qe,t),a(e,Ke,t),a(e,M,t),a(e,et,t),f(B,e,t),a(e,tt,t),a(e,U,t),a(e,nt,t),a(e,L,t),a(e,it,t),a(e,R,t),a(e,st,t),a(e,N,t),a(e,at,t),a(e,F,t),a(e,ot,t),a(e,J,t),a(e,rt,t),a(e,Q,t),a(e,lt,t),f(z,e,t),a(e,pt,t),a(e,S,t),a(e,dt,t),f(Y,e,t),a(e,mt,t),a(e,H,t),a(e,ct,t),f(q,e,t),a(e,ft,t),a(e,A,t),a(e,ut,t),a(e,O,t),a(e,gt,t),f(K,e,t),a(e,ht,t),a(e,ee,t),a(e,_t,t),a(e,te,t),a(e,bt,t),f(ne,e,t),a(e,wt,t),f(ie,e,t),a(e,yt,t),a(e,se,t),a(e,xt,t),f(ae,e,t),a(e,vt,t),a(e,oe,t),a(e,Tt,t),f(re,e,t),a(e,Mt,t),a(e,le,t),a(e,Ut,t),f(pe,e,t),a(e,Jt,t),a(e,de,t),a(e,Zt,t),f(me,e,t),a(e,$t,t),a(e,ce,t),a(e,It,t),f(fe,e,t),a(e,jt,t),f(ue,e,t),a(e,Wt,t),a(e,ge,t),a(e,Gt,t),f(he,e,t),a(e,Xt,t),a(e,Z,t),a(e,Ct,t),f(_e,e,t),a(e,Pt,t),a(e,d,t),f(be,d,null),o(d,en),o(d,Pe),o(d,tn),o(d,Ve),o(d,nn),o(d,$),f(we,$,null),o($,sn),o($,De),o(d,an),o(d,I),f(ye,I,null),o(I,on),o(I,Ee),o(d,rn),o(d,j),f(xe,j,null),o(j,ln),o(j,ke),o(d,pn),o(d,W),f(ve,W,null),o(W,dn),o(W,Be),o(d,mn),o(d,G),f(Te,G,null),o(G,cn),o(G,Le),o(d,fn),o(d,X),f(Me,X,null),o(X,un),o(X,Re),o(d,gn),o(d,C),f(Ue,C,null),o(C,hn),o(C,Ne),o(d,_n),o(d,P),f(Je,P,null),o(P,bn),o(P,Fe),o(d,wn),o(d,V),f(Ze,V,null),o(V,yn),o(V,Qe),o(d,xn),o(d,D),f($e,D,null),o(D,vn),o(D,ze),o(d,Tn),o(d,E),f(Ie,E,null),o(E,Mn),o(E,Se),o(d,Un),o(d,k),f(je,k,null),o(k,Jn),o(k,Ye),a(e,Vt,t),f(We,e,t),a(e,Dt,t),a(e,v,t),f(Ge,v,null),o(v,Zn),o(v,He),a(e,Et,t),f(Xe,e,t),a(e,kt,t),a(e,Ae,t),Bt=!0},p:ci,i(e){Bt||(u(B.$$.fragment,e),u(z.$$.fragment,e),u(Y.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(we.$$.fragment,e),u(ye.$$.fragment,e),u(xe.$$.fragment,e),u(ve.$$.fragment,e),u(Te.$$.fragment,e),u(Me.$$.fragment,e),u(Ue.$$.fragment,e),u(Je.$$.fragment,e),u(Ze.$$.fragment,e),u($e.$$.fragment,e),u(Ie.$$.fragment,e),u(je.$$.fragment,e),u(We.$$.fragment,e),u(Ge.$$.fragment,e),u(Xe.$$.fragment,e),Bt=!0)},o(e){g(B.$$.fragment,e),g(z.$$.fragment,e),g(Y.$$.fragment,e),g(q.$$.fragment,e),g(K.$$.fragment,e),g(ne.$$.fragment,e),g(ie.$$.fragment,e),g(ae.$$.fragment,e),g(re.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(we.$$.fragment,e),g(ye.$$.fragment,e),g(xe.$$.fragment,e),g(ve.$$.fragment,e),g(Te.$$.fragment,e),g(Me.$$.fragment,e),g(Ue.$$.fragment,e),g(Je.$$.fragment,e),g(Ze.$$.fragment,e),g($e.$$.fragment,e),g(Ie.$$.fragment,e),g(je.$$.fragment,e),g(We.$$.fragment,e),g(Ge.$$.fragment,e),g(Xe.$$.fragment,e),Bt=!1},d(e){e&&(n(Oe),n(qe),n(Ke),n(M),n(et),n(tt),n(U),n(nt),n(L),n(it),n(R),n(st),n(N),n(at),n(F),n(ot),n(J),n(rt),n(Q),n(lt),n(pt),n(S),n(dt),n(mt),n(H),n(ct),n(ft),n(A),n(ut),n(O),n(gt),n(ht),n(ee),n(_t),n(te),n(bt),n(wt),n(yt),n(se),n(xt),n(vt),n(oe),n(Tt),n(Mt),n(le),n(Ut),n(Jt),n(de),n(Zt),n($t),n(ce),n(It),n(jt),n(Wt),n(ge),n(Gt),n(Xt),n(Z),n(Ct),n(Pt),n(d),n(Vt),n(Dt),n(v),n(Et),n(kt),n(Ae)),n(x),h(B,e),h(z,e),h(Y,e),h(q,e),h(K,e),h(ne,e),h(ie,e),h(ae,e),h(re,e),h(pe,e),h(me,e),h(fe,e),h(ue,e),h(he,e),h(_e,e),h(be),h(we),h(ye),h(xe),h(ve),h(Te),h(Me),h(Ue),h(Je),h(Ze),h($e),h(Ie),h(je),h(We,e),h(Ge),h(Xe,e)}}}const wi='{"title":"UniDiffuser","local":"unidiffuser","sections":[{"title":"Usage Examples","local":"usage-examples","sections":[{"title":"Unconditional Image and Text Generation","local":"unconditional-image-and-text-generation","sections":[],"depth":3},{"title":"Text-to-Image Generation","local":"text-to-image-generation","sections":[],"depth":3},{"title":"Image-to-Text Generation","local":"image-to-text-generation","sections":[],"depth":3},{"title":"Image Variation","local":"image-variation","sections":[],"depth":3},{"title":"Text Variation","local":"text-variation","sections":[],"depth":3}],"depth":2},{"title":"UniDiffuserPipeline","local":"diffusers.UniDiffuserPipeline","sections":[],"depth":2},{"title":"ImageTextPipelineOutput","local":"diffusers.ImageTextPipelineOutput","sections":[],"depth":2}],"depth":1}';function yi($n){return fi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ji extends ui{constructor(x){super(),gi(this,x,yi,bi,mi,{})}}export{Ji as component};
