import{s as us,n as _s,o as bs}from"../chunks/scheduler.888833de.js";import{S as Ts,i as ys,e as r,s as n,c as d,q as hs,h as ws,a as l,d as t,b as s,f as u,j as p,g as c,r as gs,k as _,l as a,m as i,n as m,t as f,o as h,p as g}from"../chunks/index.128ce987.js";import{D as v}from"../chunks/Docstring.23ed6b62.js";import{C as y}from"../chunks/CodeBlock.37df032e.js";import{H as w,E as vs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function xs(xn){let U,Vt,Jt,kt,C,Zn="<p>This pipeline is deprecated but it can still be used. However, we won’t test the pipeline anymore and won’t accept any changes to it. If you run into any issues, reinstall the last Diffusers version that supported this model.</p>",It,D,Ct,X,Mn='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',Xt,Q,Jn='<a href="https://huggingface.co/papers/2303.13439" rel="nofollow">Text2Video-Zero: Text-to-Image Diffusion Models are Zero-Shot Video Generators</a> is by Levon Khachatryan, Andranik Movsisyan, Vahram Tadevosyan, Roberto Henschel, <a href="https://www.ece.utexas.edu/people/faculty/atlas-wang" rel="nofollow">Zhangyang Wang</a>, Shant Navasardyan, <a href="https://www.humphreyshi.com" rel="nofollow">Humphrey Shi</a>.',Wt,E,Un="Text2Video-Zero enables zero-shot video generation using either:",Gt,Y,jn="<li>A textual prompt</li> <li>A prompt combined with guidance from poses or edges</li> <li>Video Instruct-Pix2Pix (instruction-guided video editing)</li>",Nt,F,Vn="Results are temporally consistent and closely follow the guidance and textual prompts.",$t,H,kn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/t2v_zero_teaser.png" alt="teaser-img"/>',St,q,In="The abstract from the paper is:",Bt,A,Cn=`<em>Recent text-to-video generation approaches rely on computationally heavy training and require large-scale video datasets. In this paper, we introduce a new task of zero-shot text-to-video generation and propose a low-cost approach (without any training or optimization) by leveraging the power of existing text-to-image synthesis methods (e.g., Stable Diffusion), making them suitable for the video domain.
Our key modifications include (i) enriching the latent codes of the generated frames with motion dynamics to keep the global scene and the background time consistent; and (ii) reprogramming frame-level self-attention using a new cross-frame attention of each frame on the first frame, to preserve the context, appearance, and identity of the foreground object.
Experiments show that this leads to low overhead, yet high-quality and remarkably consistent video generation. Moreover, our approach is not limited to text-to-video synthesis but is also applicable to other tasks such as conditional and content-specialized video generation, and Video Instruct-Pix2Pix, i.e., instruction-guided video editing.
As experiments show, our method performs comparably or sometimes better than recent approaches, despite not being trained on additional video data.</em>`,Pt,O,Xn='You can find additional information about Text2Video-Zero on the <a href="https://text2video-zero.github.io/" rel="nofollow">project page</a>, <a href="https://huggingface.co/papers/2303.13439" rel="nofollow">paper</a>, and <a href="https://github.com/Picsart-AI-Research/Text2Video-Zero" rel="nofollow">original codebase</a>.',Lt,K,Rt,ee,zt,te,Wn="To generate a video from prompt, run the following Python code:",Dt,oe,Qt,ne,Gn="You can change these parameters in the pipeline call:",Et,se,Nn='<li>Motion field strength (see the <a href="https://huggingface.co/papers/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1):<ul><li><code>motion_field_strength_x</code> and <code>motion_field_strength_y</code>. Default: <code>motion_field_strength_x=12</code>, <code>motion_field_strength_y=12</code></li></ul></li> <li><code>T</code> and <code>T&#39;</code> (see the <a href="https://huggingface.co/papers/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1)<ul><li><code>t0</code> and <code>t1</code> in the range <code>{0, ..., num_inference_steps}</code>. Default: <code>t0=45</code>, <code>t1=48</code></li></ul></li> <li>Video length:<ul><li><code>video_length</code>, the number of frames video_length to be generated. Default: <code>video_length=8</code></li></ul></li>',Yt,ae,$n="We can also generate longer videos by doing the processing in a chunk-by-chunk manner:",Ft,ie,Ht,Oe,W,re,Po,Ke,Sn="TextToVideoZeroSDXLPipeline",Lo,qt,le,At,pe,Ot,de,Bn="To generate a video from prompt with additional pose control",Kt,et,ce,tt,Pn="Download a demo video",Ro,me,eo,j,V,ot,Ln="Read video containing extracted pose images",zo,fe,Do,nt,Rn='To extract pose from actual video, read <a href="controlnet">ControlNet documentation</a>.',Qo,he,st,zn="Run <code>StableDiffusionControlNetPipeline</code> with our custom attention processor",Eo,ge,to,at,k,ue,Yo,it,Dn="Since our attention processor also works with SDXL, it can be utilized to generate a video from prompt using ControlNet models powered by SDXL:",Fo,_e,oo,be,no,Te,Qn='To generate a video from prompt with additional Canny edge control, follow the same steps described above for pose-guided generation using <a href="https://huggingface.co/lllyasviel/sd-controlnet-canny" rel="nofollow">Canny edge ControlNet model</a>.',so,ye,ao,we,En='To perform text-guided video editing (with <a href="pix2pix">InstructPix2Pix</a>):',io,x,ve,rt,Yn="Download a demo video",Ho,xe,qo,Ze,lt,Fn="Read video from path",Ao,Me,Oo,Je,pt,Hn="Run <code>StableDiffusionInstructPix2PixPipeline</code> with our custom attention processor",Ko,Ue,ro,je,lo,Ve,qn=`Methods <strong>Text-To-Video</strong>, <strong>Text-To-Video with Pose Control</strong> and <strong>Text-To-Video with Edge Control</strong>
can run with custom <a href="../../training/dreambooth">DreamBooth</a> models, as shown below for
<a href="https://huggingface.co/lllyasviel/sd-controlnet-canny" rel="nofollow">Canny edge ControlNet model</a> and
<a href="https://huggingface.co/PAIR/text2video-zero-controlnet-canny-avatar" rel="nofollow">Avatar style DreamBooth</a> model:`,po,Z,ke,dt,An="Download a demo video",en,Ie,tn,Ce,ct,On="Read video from path",on,Xe,nn,We,mt,Kn="Run <code>StableDiffusionControlNetPipeline</code> with custom trained DreamBooth model",sn,Ge,co,Ne,es='You can filter out some available DreamBooth-trained models with <a href="https://huggingface.co/models?search=dreambooth" rel="nofollow">this link</a>.',mo,G,ts='<p>Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.</p>',fo,$e,ho,b,Se,an,N,Be,rn,ft,os="The call function to the pipeline for generation.",ln,$,Pe,pn,ht,ns="Perform backward process given list of time steps.",dn,S,Le,cn,gt,ss="Encodes the prompt into text encoder hidden states.",mn,B,Re,fn,ut,as="Perform DDPM forward process from time t0 to t1. This is the same as adding noise with corresponding variance.",go,ze,uo,T,De,hn,P,Qe,gn,_t,is="Function invoked when calling the pipeline for generation.",un,L,Ee,_n,bt,rs="Perform backward process given list of time steps",bn,R,Ye,Tn,Tt,ls="Encodes the prompt into text encoder hidden states.",yn,z,Fe,wn,yt,ps="Perform DDPM forward process from time t0 to t1. This is the same as adding noise with corresponding variance.",_o,He,bo,I,qe,vn,wt,ds="Output class for zero-shot text-to-video pipeline.",To,Ae,yo,Ut,wo;return D=new w({props:{title:"Text2Video-Zero",local:"text2video-zero",headingTag:"h1"}}),K=new w({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),ee=new w({props:{title:"Text-To-Video",local:"text-to-video",headingTag:"h3"}}),oe=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9aZXJvUGlwZWxpbmUlMEFpbXBvcnQlMjBpbWFnZWlvJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlJTIwJTNEJTIwVGV4dFRvVmlkZW9aZXJvUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBwYW5kYSUyMGlzJTIwcGxheWluZyUyMGd1aXRhciUyMG9uJTIwdGltZXMlMjBzcXVhcmUlMjIlMEFyZXN1bHQlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCkuaW1hZ2VzJTBBcmVzdWx0JTIwJTNEJTIwJTVCKHIlMjAqJTIwMjU1KS5hc3R5cGUoJTIydWludDglMjIpJTIwZm9yJTIwciUyMGluJTIwcmVzdWx0JTVEJTBBaW1hZ2Vpby5taW1zYXZlKCUyMnZpZGVvLm1wNCUyMiUyQyUyMHJlc3VsdCUyQyUyMGZwcyUzRDQp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoZeroPipeline
<span class="hljs-keyword">import</span> imageio

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipe = TextToVideoZeroPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A panda is playing guitar on times square&quot;</span>
result = pipe(prompt=prompt).images
result = [(r * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> result]
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),ie=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9aZXJvUGlwZWxpbmUlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBUZXh0VG9WaWRlb1plcm9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBc2VlZCUyMCUzRCUyMDAlMEF2aWRlb19sZW5ndGglMjAlM0QlMjAyNCUyMCUyMCUyMzI0JTIwJUMzJUI3JTIwNGZwcyUyMCUzRCUyMDYlMjBzZWNvbmRzJTBBY2h1bmtfc2l6ZSUyMCUzRCUyMDglMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwcGFuZGElMjBpcyUyMHBsYXlpbmclMjBndWl0YXIlMjBvbiUyMHRpbWVzJTIwc3F1YXJlJTIyJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjB0aGUlMjB2aWRlbyUyMGNodW5rLWJ5LWNodW5rJTBBcmVzdWx0JTIwJTNEJTIwJTVCJTVEJTBBY2h1bmtfaWRzJTIwJTNEJTIwbnAuYXJhbmdlKDAlMkMlMjB2aWRlb19sZW5ndGglMkMlMjBjaHVua19zaXplJTIwLSUyMDEpJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGNodW5rX2lkcykpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlByb2Nlc3NpbmclMjBjaHVuayUyMCU3QmklMjAlMkIlMjAxJTdEJTIwJTJGJTIwJTdCbGVuKGNodW5rX2lkcyklN0QlMjIpJTBBJTIwJTIwJTIwJTIwY2hfc3RhcnQlMjAlM0QlMjBjaHVua19pZHMlNUJpJTVEJTBBJTIwJTIwJTIwJTIwY2hfZW5kJTIwJTNEJTIwdmlkZW9fbGVuZ3RoJTIwaWYlMjBpJTIwJTNEJTNEJTIwbGVuKGNodW5rX2lkcyklMjAtJTIwMSUyMGVsc2UlMjBjaHVua19pZHMlNUJpJTIwJTJCJTIwMSU1RCUwQSUyMCUyMCUyMCUyMCUyMyUyMEF0dGFjaCUyMHRoZSUyMGZpcnN0JTIwZnJhbWUlMjBmb3IlMjBDcm9zcyUyMEZyYW1lJTIwQXR0ZW50aW9uJTBBJTIwJTIwJTIwJTIwZnJhbWVfaWRzJTIwJTNEJTIwJTVCMCU1RCUyMCUyQiUyMGxpc3QocmFuZ2UoY2hfc3RhcnQlMkMlMjBjaF9lbmQpKSUwQSUyMCUyMCUyMCUyMCUyMyUyMEZpeCUyMHRoZSUyMHNlZWQlMjBmb3IlMjB0aGUlMjB0ZW1wb3JhbCUyMGNvbnNpc3RlbmN5JTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yLm1hbnVhbF9zZWVkKHNlZWQpJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjB2aWRlb19sZW5ndGglM0RsZW4oZnJhbWVfaWRzKSUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMGZyYW1lX2lkcyUzRGZyYW1lX2lkcyklMEElMjAlMjAlMjAlMjByZXN1bHQuYXBwZW5kKG91dHB1dC5pbWFnZXMlNUIxJTNBJTVEKSUwQSUwQSUyMyUyMENvbmNhdGVuYXRlJTIwY2h1bmtzJTIwYW5kJTIwc2F2ZSUwQXJlc3VsdCUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKHJlc3VsdCklMEFyZXN1bHQlMjAlM0QlMjAlNUIociUyMColMjAyNTUpLmFzdHlwZSglMjJ1aW50OCUyMiklMjBmb3IlMjByJTIwaW4lMjByZXN1bHQlNUQlMEFpbWFnZWlvLm1pbXNhdmUoJTIydmlkZW8ubXA0JTIyJTJDJTIwcmVzdWx0JTJDJTIwZnBzJTNENCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoZeroPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipe = TextToVideoZeroPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
seed = <span class="hljs-number">0</span>
video_length = <span class="hljs-number">24</span>  <span class="hljs-comment">#24 ÷ 4fps = 6 seconds</span>
chunk_size = <span class="hljs-number">8</span>
prompt = <span class="hljs-string">&quot;A panda is playing guitar on times square&quot;</span>

<span class="hljs-comment"># Generate the video chunk-by-chunk</span>
result = []
chunk_ids = np.arange(<span class="hljs-number">0</span>, video_length, chunk_size - <span class="hljs-number">1</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(chunk_ids)):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Processing chunk <span class="hljs-subst">{i + <span class="hljs-number">1</span>}</span> / <span class="hljs-subst">{<span class="hljs-built_in">len</span>(chunk_ids)}</span>&quot;</span>)
    ch_start = chunk_ids[i]
    ch_end = video_length <span class="hljs-keyword">if</span> i == <span class="hljs-built_in">len</span>(chunk_ids) - <span class="hljs-number">1</span> <span class="hljs-keyword">else</span> chunk_ids[i + <span class="hljs-number">1</span>]
    <span class="hljs-comment"># Attach the first frame for Cross Frame Attention</span>
    frame_ids = [<span class="hljs-number">0</span>] + <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(ch_start, ch_end))
    <span class="hljs-comment"># Fix the seed for the temporal consistency</span>
    generator.manual_seed(seed)
    output = pipe(prompt=prompt, video_length=<span class="hljs-built_in">len</span>(frame_ids), generator=generator, frame_ids=frame_ids)
    result.append(output.images[<span class="hljs-number">1</span>:])

<span class="hljs-comment"># Concatenate chunks and save</span>
result = np.concatenate(result)
result = [(r * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> result]
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),re=new w({props:{title:"SDXL Support",local:"sdxl-support",headingTag:"h4"}}),le=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9aZXJvU0RYTFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMEFwaXBlJTIwJTNEJTIwVGV4dFRvVmlkZW9aZXJvU0RYTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSkudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoZeroSDXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
pipe = TextToVideoZeroSDXLPipeline.from_pretrained(
    model_id, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),pe=new w({props:{title:"Text-To-Video with Pose Control",local:"text-to-video-with-pose-control",headingTag:"h3"}}),me=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyX19hc3NldHNfXyUyRnBvc2VzX3NrZWxldG9uX2dpZnMlMkZkYW5jZTFfY29yci5tcDQlMjIlMEFyZXBvX2lkJTIwJTNEJTIwJTIyUEFJUiUyRlRleHQyVmlkZW8tWmVybyUyMiUwQXZpZGVvX3BhdGglMjAlM0QlMjBoZl9odWJfZG93bmxvYWQocmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUyMGZpbGVuYW1lJTNEZmlsZW5hbWUp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

filename = <span class="hljs-string">&quot;__assets__/poses_skeleton_gifs/dance1_corr.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)`,wrap:!1}}),fe=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQXBvc2VfaW1hZ2VzJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
pose_images = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`,wrap:!1}}),ge=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMudGV4dF90b192aWRlb19zeW50aGVzaXMucGlwZWxpbmVfdGV4dF90b192aWRlb196ZXJvJTIwaW1wb3J0JTIwQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmxsbHlhc3ZpZWwlMkZzZC1jb250cm9sbmV0LW9wZW5wb3NlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwU2V0JTIwdGhlJTIwYXR0ZW50aW9uJTIwcHJvY2Vzc29yJTBBcGlwZS51bmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMikpJTBBcGlwZS5jb250cm9sbmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMikpJTBBJTBBJTIzJTIwZml4JTIwbGF0ZW50cyUyMGZvciUyMGFsbCUyMGZyYW1lcyUwQWxhdGVudHMlMjAlM0QlMjB0b3JjaC5yYW5kbigoMSUyQyUyMDQlMkMlMjA2NCUyQyUyMDY0KSUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnJlcGVhdChsZW4ocG9zZV9pbWFnZXMpJTJDJTIwMSUyQyUyMDElMkMlMjAxKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkRhcnRoJTIwVmFkZXIlMjBkYW5jaW5nJTIwaW4lMjBhJTIwZGVzZXJ0JTIyJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlM0QlNUJwcm9tcHQlNUQlMjAqJTIwbGVuKHBvc2VfaW1hZ2VzKSUyQyUyMGltYWdlJTNEcG9zZV9pbWFnZXMlMkMlMjBsYXRlbnRzJTNEbGF0ZW50cykuaW1hZ2VzJTBBaW1hZ2Vpby5taW1zYXZlKCUyMnZpZGVvLm1wNCUyMiUyQyUyMHJlc3VsdCUyQyUyMGZwcyUzRDQp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-openpose&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    model_id, controlnet=controlnet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Set the attention processor</span>
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))
pipe.controlnet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))

<span class="hljs-comment"># fix latents for all frames</span>
latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16).repeat(<span class="hljs-built_in">len</span>(pose_images), <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)

prompt = <span class="hljs-string">&quot;Darth Vader dancing in a desert&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(pose_images), image=pose_images, latents=latents).images
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),ue=new w({props:{title:"SDXL Support",local:"sdxl-support",headingTag:"h4"}}),_e=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0UGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMEFmcm9tJTIwZGlmZnVzZXJzLnBpcGVsaW5lcy50ZXh0X3RvX3ZpZGVvX3N5bnRoZXNpcy5waXBlbGluZV90ZXh0X3RvX3ZpZGVvX3plcm8lMjBpbXBvcnQlMjBDcm9zc0ZyYW1lQXR0blByb2Nlc3NvciUwQSUwQWNvbnRyb2xuZXRfbW9kZWxfaWQlMjAlM0QlMjAndGhpYmF1ZCUyRmNvbnRyb2xuZXQtb3BlbnBvc2Utc2R4bC0xLjAnJTBBbW9kZWxfaWQlMjAlM0QlMjAnc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJyUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNvbnRyb2xuZXRfbW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTA5bW9kZWxfaWQlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJ2N1ZGEnKSUwQSUwQSUyMyUyMFNldCUyMHRoZSUyMGF0dGVudGlvbiUyMHByb2Nlc3NvciUwQXBpcGUudW5ldC5zZXRfYXR0bl9wcm9jZXNzb3IoQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IoYmF0Y2hfc2l6ZSUzRDIpKSUwQXBpcGUuY29udHJvbG5ldC5zZXRfYXR0bl9wcm9jZXNzb3IoQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IoYmF0Y2hfc2l6ZSUzRDIpKSUwQSUwQSUyMyUyMGZpeCUyMGxhdGVudHMlMjBmb3IlMjBhbGwlMjBmcmFtZXMlMEFsYXRlbnRzJTIwJTNEJTIwdG9yY2gucmFuZG4oKDElMkMlMjA0JTJDJTIwMTI4JTJDJTIwMTI4KSUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnJlcGVhdChsZW4ocG9zZV9pbWFnZXMpJTJDJTIwMSUyQyUyMDElMkMlMjAxKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkRhcnRoJTIwVmFkZXIlMjBkYW5jaW5nJTIwaW4lMjBhJTIwZGVzZXJ0JTIyJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlM0QlNUJwcm9tcHQlNUQlMjAqJTIwbGVuKHBvc2VfaW1hZ2VzKSUyQyUyMGltYWdlJTNEcG9zZV9pbWFnZXMlMkMlMjBsYXRlbnRzJTNEbGF0ZW50cykuaW1hZ2VzJTBBaW1hZ2Vpby5taW1zYXZlKCUyMnZpZGVvLm1wNCUyMiUyQyUyMHJlc3VsdCUyQyUyMGZwcyUzRDQp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

controlnet_model_id = <span class="hljs-string">&#x27;thibaud/controlnet-openpose-sdxl-1.0&#x27;</span>
model_id = <span class="hljs-string">&#x27;stabilityai/stable-diffusion-xl-base-1.0&#x27;</span>

controlnet = ControlNetModel.from_pretrained(controlnet_model_id, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
	model_id, controlnet=controlnet, torch_dtype=torch.float16
).to(<span class="hljs-string">&#x27;cuda&#x27;</span>)

<span class="hljs-comment"># Set the attention processor</span>
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))
pipe.controlnet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))

<span class="hljs-comment"># fix latents for all frames</span>
latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16).repeat(<span class="hljs-built_in">len</span>(pose_images), <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)

prompt = <span class="hljs-string">&quot;Darth Vader dancing in a desert&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(pose_images), image=pose_images, latents=latents).images
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),be=new w({props:{title:"Text-To-Video with Edge Control",local:"text-to-video-with-edge-control",headingTag:"h3"}}),ye=new w({props:{title:"Video Instruct-Pix2Pix",local:"video-instruct-pix2pix",headingTag:"h3"}}),xe=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyX19hc3NldHNfXyUyRnBpeDJwaXglMjB2aWRlbyUyRmNhbWVsLm1wNCUyMiUwQXJlcG9faWQlMjAlM0QlMjAlMjJQQUlSJTJGVGV4dDJWaWRlby1aZXJvJTIyJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZChyZXBvX3R5cGUlM0QlMjJzcGFjZSUyMiUyQyUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwZmlsZW5hbWUlM0RmaWxlbmFtZSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

filename = <span class="hljs-string">&quot;__assets__/pix2pix video/camel.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)`,wrap:!1}}),Me=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQXZpZGVvJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
video = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`,wrap:!1}}),Ue=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnBpcGVsaW5lcy50ZXh0X3RvX3ZpZGVvX3N5bnRoZXNpcy5waXBlbGluZV90ZXh0X3RvX3ZpZGVvX3plcm8lMjBpbXBvcnQlMjBDcm9zc0ZyYW1lQXR0blByb2Nlc3NvciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS51bmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMykpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIybWFrZSUyMGl0JTIwVmFuJTIwR29naCUyMFN0YXJyeSUyME5pZ2h0JTIwc3R5bGUlMjIlMEFyZXN1bHQlMjAlM0QlMjBwaXBlKHByb21wdCUzRCU1QnByb21wdCU1RCUyMColMjBsZW4odmlkZW8pJTJDJTIwaW1hZ2UlM0R2aWRlbykuaW1hZ2VzJTBBaW1hZ2Vpby5taW1zYXZlKCUyMmVkaXRlZF92aWRlby5tcDQlMjIlMkMlMjByZXN1bHQlMkMlMjBmcHMlM0Q0KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

model_id = <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>
pipe = StableDiffusionInstructPix2PixPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">3</span>))

prompt = <span class="hljs-string">&quot;make it Van Gogh Starry Night style&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(video), image=video).images
imageio.mimsave(<span class="hljs-string">&quot;edited_video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),je=new w({props:{title:"DreamBooth specialization",local:"dreambooth-specialization",headingTag:"h3"}}),Ie=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyX19hc3NldHNfXyUyRmNhbm55X3ZpZGVvc19tcDQlMkZnaXJsX3R1cm5pbmcubXA0JTIyJTBBcmVwb19pZCUyMCUzRCUyMCUyMlBBSVIlMkZUZXh0MlZpZGVvLVplcm8lMjIlMEF2aWRlb19wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9fdHlwZSUzRCUyMnNwYWNlJTIyJTJDJTIwcmVwb19pZCUzRHJlcG9faWQlMkMlMjBmaWxlbmFtZSUzRGZpbGVuYW1lKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

filename = <span class="hljs-string">&quot;__assets__/canny_videos_mp4/girl_turning.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)`,wrap:!1}}),Xe=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQWNhbm55X2VkZ2VzJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
canny_edges = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`,wrap:!1}}),Ge=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMudGV4dF90b192aWRlb19zeW50aGVzaXMucGlwZWxpbmVfdGV4dF90b192aWRlb196ZXJvJTIwaW1wb3J0JTIwQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IlMEElMEElMjMlMjBzZXQlMjBtb2RlbCUyMGlkJTIwdG8lMjBjdXN0b20lMjBtb2RlbCUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyUEFJUiUyRnRleHQydmlkZW8temVyby1jb250cm9sbmV0LWNhbm55LWF2YXRhciUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmxsbHlhc3ZpZWwlMkZzZC1jb250cm9sbmV0LWNhbm55JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwU2V0JTIwdGhlJTIwYXR0ZW50aW9uJTIwcHJvY2Vzc29yJTBBcGlwZS51bmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMikpJTBBcGlwZS5jb250cm9sbmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMikpJTBBJTBBJTIzJTIwZml4JTIwbGF0ZW50cyUyMGZvciUyMGFsbCUyMGZyYW1lcyUwQWxhdGVudHMlMjAlM0QlMjB0b3JjaC5yYW5kbigoMSUyQyUyMDQlMkMlMjA2NCUyQyUyMDY0KSUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnJlcGVhdChsZW4oY2FubnlfZWRnZXMpJTJDJTIwMSUyQyUyMDElMkMlMjAxKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMm9pbCUyMHBhaW50aW5nJTIwb2YlMjBhJTIwYmVhdXRpZnVsJTIwZ2lybCUyMGF2YXRhciUyMHN0eWxlJTIyJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlM0QlNUJwcm9tcHQlNUQlMjAqJTIwbGVuKGNhbm55X2VkZ2VzKSUyQyUyMGltYWdlJTNEY2FubnlfZWRnZXMlMkMlMjBsYXRlbnRzJTNEbGF0ZW50cykuaW1hZ2VzJTBBaW1hZ2Vpby5taW1zYXZlKCUyMnZpZGVvLm1wNCUyMiUyQyUyMHJlc3VsdCUyQyUyMGZwcyUzRDQp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

<span class="hljs-comment"># set model id to custom model</span>
model_id = <span class="hljs-string">&quot;PAIR/text2video-zero-controlnet-canny-avatar&quot;</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    model_id, controlnet=controlnet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Set the attention processor</span>
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))
pipe.controlnet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))

<span class="hljs-comment"># fix latents for all frames</span>
latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16).repeat(<span class="hljs-built_in">len</span>(canny_edges), <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)

prompt = <span class="hljs-string">&quot;oil painting of a beautiful girl avatar style&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(canny_edges), image=canny_edges, latents=latents).images
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),$e=new w({props:{title:"TextToVideoZeroPipeline",local:"diffusers.TextToVideoZeroPipeline",headingTag:"h2"}}),Se=new v({props:{name:"class diffusers.TextToVideoZeroPipeline",anchor:"diffusers.TextToVideoZeroPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L298"}}),Be=new v({props:{name:"__call__",anchor:"diffusers.TextToVideoZeroPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"video_length",val:": typing.Optional[int] = 8"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"motion_field_strength_x",val:": float = 12"},{name:"motion_field_strength_y",val:": float = 12"},{name:"output_type",val:": typing.Optional[str] = 'tensor'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Optional[typing.Callable[[int, int, torch.Tensor], NoneType]] = None"},{name:"callback_steps",val:": typing.Optional[int] = 1"},{name:"t0",val:": int = 44"},{name:"t1",val:": int = 47"},{name:"frame_ids",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.video_length",description:`<strong>video_length</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of generated video frames.`,name:"video_length"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in video generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>&quot;latent&quot;</code> and <code>&quot;np&quot;</code>.`,name:"output_type"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a
<a href="/docs/diffusers/main/en/api/pipelines/text_to_video_zero#diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput">TextToVideoPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.motion_field_strength_x",description:`<strong>motion_field_strength_x</strong> (<code>float</code>, <em>optional</em>, defaults to 12) &#x2014;
Strength of motion in generated video along x-axis. See the
<a href="https://huggingface.co/papers/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"motion_field_strength_x"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.motion_field_strength_y",description:`<strong>motion_field_strength_y</strong> (<code>float</code>, <em>optional</em>, defaults to 12) &#x2014;
Strength of motion in generated video along y-axis. See the
<a href="https://huggingface.co/papers/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"motion_field_strength_y"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.t0",description:`<strong>t0</strong> (<code>int</code>, <em>optional</em>, defaults to 44) &#x2014;
Timestep t0. Should be in the range [0, num_inference_steps - 1]. See the
<a href="https://huggingface.co/papers/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"t0"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.t1",description:`<strong>t1</strong> (<code>int</code>, <em>optional</em>, defaults to 47) &#x2014;
Timestep t0. Should be in the range [t0 + 1, num_inference_steps - 1]. See the
<a href="https://huggingface.co/papers/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"t1"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.frame_ids",description:`<strong>frame_ids</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Indexes of the frames that are being generated. This is used when generating longer videos
chunk-by-chunk.`,name:"frame_ids"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L545",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The output contains a <code>ndarray</code> of the generated video, when <code>output_type</code> != <code>"latent"</code>, otherwise a
latent code of generated videos and a list of <code>bool</code>s indicating whether the corresponding generated
video contains “not-safe-for-work” (nsfw) content..</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video_zero#diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput"
>TextToVideoPipelineOutput</a></p>
`}}),Pe=new v({props:{name:"backward_loop",anchor:"diffusers.TextToVideoZeroPipeline.backward_loop",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"prompt_embeds",val:""},{name:"guidance_scale",val:""},{name:"callback",val:""},{name:"callback_steps",val:""},{name:"num_warmup_steps",val:""},{name:"extra_step_kwargs",val:""},{name:"cross_attention_kwargs",val:" = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.latents",description:`<strong>latents</strong> &#x2014;
Latents at time timesteps[0].`,name:"latents"},{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.timesteps",description:`<strong>timesteps</strong> &#x2014;
Time steps along which to perform backward process.`,name:"timesteps"},{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.prompt_embeds",description:`<strong>prompt_embeds</strong> &#x2014;
Pre-generated text embeddings.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.guidance_scale",description:`<strong>guidance_scale</strong> &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.extra_step_kwargs",description:`<strong>extra_step_kwargs</strong> &#x2014;
Extra_step_kwargs.`,name:"extra_step_kwargs"},{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.num_warmup_steps",description:`<strong>num_warmup_steps</strong> &#x2014;
number of warmup steps.`,name:"num_warmup_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L390",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Latents of backward process output at time timesteps[-1].</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>latents</p>
`}}),Le=new v({props:{name:"encode_prompt",anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.TextToVideoZeroPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L817"}}),Re=new v({props:{name:"forward_loop",anchor:"diffusers.TextToVideoZeroPipeline.forward_loop",parameters:[{name:"x_t0",val:""},{name:"t0",val:""},{name:"t1",val:""},{name:"generator",val:""}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.forward_loop.x_t0",description:`<strong>x_t0</strong> &#x2014;
Latent code at time t0.`,name:"x_t0"},{anchor:"diffusers.TextToVideoZeroPipeline.forward_loop.t0",description:`<strong>t0</strong> &#x2014;
Timestep at t0.`,name:"t0"},{anchor:"diffusers.TextToVideoZeroPipeline.forward_loop.t1",description:`<strong>t1</strong> &#x2014;
Timestamp at t1.`,name:"t1"},{anchor:"diffusers.TextToVideoZeroPipeline.forward_loop.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L366",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Forward process applied to x_t0 from time t0 to t1.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>x_t1</p>
`}}),ze=new w({props:{title:"TextToVideoZeroSDXLPipeline",local:"diffusers.TextToVideoZeroSDXLPipeline",headingTag:"h2"}}),De=new v({props:{name:"class diffusers.TextToVideoZeroSDXLPipeline",anchor:"diffusers.TextToVideoZeroSDXLPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero_sdxl.py#L348"}}),Qe=new v({props:{name:"__call__",anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"video_length",val:": typing.Optional[int] = 8"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"frame_ids",val:": typing.Optional[typing.List[int]] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"motion_field_strength_x",val:": float = 12"},{name:"motion_field_strength_y",val:": float = 12"},{name:"output_type",val:": typing.Optional[str] = 'tensor'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Optional[typing.Callable[[int, int, torch.Tensor], NoneType]] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"t0",val:": int = 44"},{name:"t1",val:": int = 47"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.video_length",description:`<strong>video_length</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of generated video frames.`,name:"video_length"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">https://huggingface.co/papers/2010.02502</a>. Only
applies to <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.frame_ids",description:`<strong>frame_ids</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Indexes of the frames that are being generated. This is used when generating longer videos
chunk-by-chunk.`,name:"frame_ids"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.motion_field_strength_x",description:`<strong>motion_field_strength_x</strong> (<code>float</code>, <em>optional</em>, defaults to 12) &#x2014;
Strength of motion in generated video along x-axis. See the
<a href="https://huggingface.co/papers/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"motion_field_strength_x"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.motion_field_strength_y",description:`<strong>motion_field_strength_y</strong> (<code>float</code>, <em>optional</em>, defaults to 12) &#x2014;
Strength of motion in generated video along y-axis. See the
<a href="https://huggingface.co/papers/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"motion_field_strength_y"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/cross_attention.py" rel="nofollow">diffusers.cross_attention</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.7) &#x2014;
Guidance rescale factor proposed by <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(width, height)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(width, height)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.t0",description:`<strong>t0</strong> (<code>int</code>, <em>optional</em>, defaults to 44) &#x2014;
Timestep t0. Should be in the range [0, num_inference_steps - 1]. See the
<a href="https://huggingface.co/papers/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"t0"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.__call__.t1",description:`<strong>t1</strong> (<code>int</code>, <em>optional</em>, defaults to 47) &#x2014;
Timestep t0. Should be in the range [t0 + 1, num_inference_steps - 1]. See the
<a href="https://huggingface.co/papers/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"t1"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero_sdxl.py#L951",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoSDXLPipelineOutput</code> or
<code>tuple</code>: <code>~pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoSDXLPipelineOutput</code>
if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the
generated images.</p>
`}}),Ee=new v({props:{name:"backward_loop",anchor:"diffusers.TextToVideoZeroSDXLPipeline.backward_loop",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"prompt_embeds",val:""},{name:"guidance_scale",val:""},{name:"callback",val:""},{name:"callback_steps",val:""},{name:"num_warmup_steps",val:""},{name:"extra_step_kwargs",val:""},{name:"add_text_embeds",val:""},{name:"add_time_ids",val:""},{name:"cross_attention_kwargs",val:" = None"},{name:"guidance_rescale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroSDXLPipeline.backward_loop.latents",description:`<strong>latents</strong> &#x2014;
Latents at time timesteps[0].`,name:"latents"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.backward_loop.timesteps",description:`<strong>timesteps</strong> &#x2014;
Time steps along which to perform backward process.`,name:"timesteps"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.backward_loop.prompt_embeds",description:`<strong>prompt_embeds</strong> &#x2014;
Pre-generated text embeddings.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.backward_loop.guidance_scale",description:`<strong>guidance_scale</strong> &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.backward_loop.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.backward_loop.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.backward_loop.extra_step_kwargs",description:`<strong>extra_step_kwargs</strong> &#x2014;
Extra_step_kwargs.`,name:"extra_step_kwargs"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.backward_loop.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.backward_loop.num_warmup_steps",description:`<strong>num_warmup_steps</strong> &#x2014;
number of warmup steps.`,name:"num_warmup_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero_sdxl.py#L862",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>latents of backward process output at time timesteps[-1]</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>latents</p>
`}}),Ye=new v({props:{name:"encode_prompt",anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": typing.Optional[str] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt_2",val:": typing.Optional[str] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero_sdxl.py#L599"}}),Fe=new v({props:{name:"forward_loop",anchor:"diffusers.TextToVideoZeroSDXLPipeline.forward_loop",parameters:[{name:"x_t0",val:""},{name:"t0",val:""},{name:"t1",val:""},{name:"generator",val:""}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroSDXLPipeline.forward_loop.x_t0",description:`<strong>x_t0</strong> &#x2014;
Latent code at time t0.`,name:"x_t0"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.forward_loop.t0",description:`<strong>t0</strong> &#x2014;
Timestep at t0.`,name:"t0"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.forward_loop.t1",description:`<strong>t1</strong> &#x2014;
Timestamp at t1.`,name:"t1"},{anchor:"diffusers.TextToVideoZeroSDXLPipeline.forward_loop.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero_sdxl.py#L838",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Forward process applied to x_t0 from time t0 to t1.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>x_t1</p>
`}}),He=new w({props:{title:"TextToVideoPipelineOutput",local:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput",headingTag:"h2"}}),qe=new v({props:{name:"class diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput",anchor:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput.images",description:`<strong>images</strong> (<code>[List[PIL.Image.Image]</code>, <code>np.ndarray</code>]) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>[List[bool]]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L197"}}),Ae=new vs({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/text_to_video_zero.md"}}),{c(){U=r("meta"),Vt=n(),Jt=r("p"),kt=n(),C=r("blockquote"),C.innerHTML=Zn,It=n(),d(D.$$.fragment),Ct=n(),X=r("div"),X.innerHTML=Mn,Xt=n(),Q=r("p"),Q.innerHTML=Jn,Wt=n(),E=r("p"),E.textContent=Un,Gt=n(),Y=r("ol"),Y.innerHTML=jn,Nt=n(),F=r("p"),F.textContent=Vn,$t=n(),H=r("p"),H.innerHTML=kn,St=n(),q=r("p"),q.textContent=In,Bt=n(),A=r("p"),A.innerHTML=Cn,Pt=n(),O=r("p"),O.innerHTML=Xn,Lt=n(),d(K.$$.fragment),Rt=n(),d(ee.$$.fragment),zt=n(),te=r("p"),te.textContent=Wn,Dt=n(),d(oe.$$.fragment),Qt=n(),ne=r("p"),ne.textContent=Gn,Et=n(),se=r("ul"),se.innerHTML=Nn,Yt=n(),ae=r("p"),ae.textContent=$n,Ft=n(),d(ie.$$.fragment),Ht=n(),Oe=r("ul"),W=r("li"),d(re.$$.fragment),Po=hs("In order to use the SDXL model when generating a video from prompt, use the "),Ke=r("code"),Ke.textContent=Sn,Lo=hs(" pipeline:"),qt=n(),d(le.$$.fragment),At=n(),d(pe.$$.fragment),Ot=n(),de=r("p"),de.textContent=Bn,Kt=n(),et=r("ol"),ce=r("li"),tt=r("p"),tt.textContent=Pn,Ro=n(),d(me.$$.fragment),eo=n(),j=r("ol"),V=r("li"),ot=r("p"),ot.textContent=Ln,zo=n(),d(fe.$$.fragment),Do=n(),nt=r("p"),nt.innerHTML=Rn,Qo=n(),he=r("li"),st=r("p"),st.innerHTML=zn,Eo=n(),d(ge.$$.fragment),to=n(),at=r("ul"),k=r("li"),d(ue.$$.fragment),Yo=n(),it=r("p"),it.textContent=Dn,Fo=n(),d(_e.$$.fragment),oo=n(),d(be.$$.fragment),no=n(),Te=r("p"),Te.innerHTML=Qn,so=n(),d(ye.$$.fragment),ao=n(),we=r("p"),we.innerHTML=En,io=n(),x=r("ol"),ve=r("li"),rt=r("p"),rt.textContent=Yn,Ho=n(),d(xe.$$.fragment),qo=n(),Ze=r("li"),lt=r("p"),lt.textContent=Fn,Ao=n(),d(Me.$$.fragment),Oo=n(),Je=r("li"),pt=r("p"),pt.innerHTML=Hn,Ko=n(),d(Ue.$$.fragment),ro=n(),d(je.$$.fragment),lo=n(),Ve=r("p"),Ve.innerHTML=qn,po=n(),Z=r("ol"),ke=r("li"),dt=r("p"),dt.textContent=An,en=n(),d(Ie.$$.fragment),tn=n(),Ce=r("li"),ct=r("p"),ct.textContent=On,on=n(),d(Xe.$$.fragment),nn=n(),We=r("li"),mt=r("p"),mt.innerHTML=Kn,sn=n(),d(Ge.$$.fragment),co=n(),Ne=r("p"),Ne.innerHTML=es,mo=n(),G=r("blockquote"),G.innerHTML=ts,fo=n(),d($e.$$.fragment),ho=n(),b=r("div"),d(Se.$$.fragment),an=n(),N=r("div"),d(Be.$$.fragment),rn=n(),ft=r("p"),ft.textContent=os,ln=n(),$=r("div"),d(Pe.$$.fragment),pn=n(),ht=r("p"),ht.textContent=ns,dn=n(),S=r("div"),d(Le.$$.fragment),cn=n(),gt=r("p"),gt.textContent=ss,mn=n(),B=r("div"),d(Re.$$.fragment),fn=n(),ut=r("p"),ut.textContent=as,go=n(),d(ze.$$.fragment),uo=n(),T=r("div"),d(De.$$.fragment),hn=n(),P=r("div"),d(Qe.$$.fragment),gn=n(),_t=r("p"),_t.textContent=is,un=n(),L=r("div"),d(Ee.$$.fragment),_n=n(),bt=r("p"),bt.textContent=rs,bn=n(),R=r("div"),d(Ye.$$.fragment),Tn=n(),Tt=r("p"),Tt.textContent=ls,yn=n(),z=r("div"),d(Fe.$$.fragment),wn=n(),yt=r("p"),yt.textContent=ps,_o=n(),d(He.$$.fragment),bo=n(),I=r("div"),d(qe.$$.fragment),vn=n(),wt=r("p"),wt.textContent=ds,To=n(),d(Ae.$$.fragment),yo=n(),Ut=r("p"),this.h()},l(e){const o=ws("svelte-u9bgzb",document.head);U=l(o,"META",{name:!0,content:!0}),o.forEach(t),Vt=s(e),Jt=l(e,"P",{}),u(Jt).forEach(t),kt=s(e),C=l(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(C)!=="svelte-124tjg"&&(C.innerHTML=Zn),It=s(e),c(D.$$.fragment,e),Ct=s(e),X=l(e,"DIV",{class:!0,"data-svelte-h":!0}),p(X)!=="svelte-si9ct8"&&(X.innerHTML=Mn),Xt=s(e),Q=l(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-16xpzkf"&&(Q.innerHTML=Jn),Wt=s(e),E=l(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1jaz0ks"&&(E.textContent=Un),Gt=s(e),Y=l(e,"OL",{"data-svelte-h":!0}),p(Y)!=="svelte-19ca1wn"&&(Y.innerHTML=jn),Nt=s(e),F=l(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-yhxhyq"&&(F.textContent=Vn),$t=s(e),H=l(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-uupw0l"&&(H.innerHTML=kn),St=s(e),q=l(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1cwsb16"&&(q.textContent=In),Bt=s(e),A=l(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1rtg145"&&(A.innerHTML=Cn),Pt=s(e),O=l(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-18vykkr"&&(O.innerHTML=Xn),Lt=s(e),c(K.$$.fragment,e),Rt=s(e),c(ee.$$.fragment,e),zt=s(e),te=l(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1dpixty"&&(te.textContent=Wn),Dt=s(e),c(oe.$$.fragment,e),Qt=s(e),ne=l(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-rs2kss"&&(ne.textContent=Gn),Et=s(e),se=l(e,"UL",{"data-svelte-h":!0}),p(se)!=="svelte-1w3gvi6"&&(se.innerHTML=Nn),Yt=s(e),ae=l(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1xdujjh"&&(ae.textContent=$n),Ft=s(e),c(ie.$$.fragment,e),Ht=s(e),Oe=l(e,"UL",{});var cs=u(Oe);W=l(cs,"LI",{});var jt=u(W);c(re.$$.fragment,jt),Po=gs(jt,"In order to use the SDXL model when generating a video from prompt, use the "),Ke=l(jt,"CODE",{"data-svelte-h":!0}),p(Ke)!=="svelte-7o0i0w"&&(Ke.textContent=Sn),Lo=gs(jt," pipeline:"),jt.forEach(t),cs.forEach(t),qt=s(e),c(le.$$.fragment,e),At=s(e),c(pe.$$.fragment,e),Ot=s(e),de=l(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-13nlg5v"&&(de.textContent=Bn),Kt=s(e),et=l(e,"OL",{});var ms=u(et);ce=l(ms,"LI",{});var vo=u(ce);tt=l(vo,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-1xo2nq1"&&(tt.textContent=Pn),Ro=s(vo),c(me.$$.fragment,vo),vo.forEach(t),ms.forEach(t),eo=s(e),j=l(e,"OL",{start:!0});var xo=u(j);V=l(xo,"LI",{});var vt=u(V);ot=l(vt,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-7pm43o"&&(ot.textContent=Ln),zo=s(vt),c(fe.$$.fragment,vt),Do=s(vt),nt=l(vt,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-mij11h"&&(nt.innerHTML=Rn),vt.forEach(t),Qo=s(xo),he=l(xo,"LI",{});var Zo=u(he);st=l(Zo,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1wsv5bt"&&(st.innerHTML=zn),Eo=s(Zo),c(ge.$$.fragment,Zo),Zo.forEach(t),xo.forEach(t),to=s(e),at=l(e,"UL",{});var fs=u(at);k=l(fs,"LI",{});var xt=u(k);c(ue.$$.fragment,xt),Yo=s(xt),it=l(xt,"P",{"data-svelte-h":!0}),p(it)!=="svelte-bcy3mo"&&(it.textContent=Dn),Fo=s(xt),c(_e.$$.fragment,xt),xt.forEach(t),fs.forEach(t),oo=s(e),c(be.$$.fragment,e),no=s(e),Te=l(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1fgx3w6"&&(Te.innerHTML=Qn),so=s(e),c(ye.$$.fragment,e),ao=s(e),we=l(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-o0vmiz"&&(we.innerHTML=En),io=s(e),x=l(e,"OL",{});var Zt=u(x);ve=l(Zt,"LI",{});var Mo=u(ve);rt=l(Mo,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-1xo2nq1"&&(rt.textContent=Yn),Ho=s(Mo),c(xe.$$.fragment,Mo),Mo.forEach(t),qo=s(Zt),Ze=l(Zt,"LI",{});var Jo=u(Ze);lt=l(Jo,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1wln6n0"&&(lt.textContent=Fn),Ao=s(Jo),c(Me.$$.fragment,Jo),Jo.forEach(t),Oo=s(Zt),Je=l(Zt,"LI",{});var Uo=u(Je);pt=l(Uo,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-14jy04z"&&(pt.innerHTML=Hn),Ko=s(Uo),c(Ue.$$.fragment,Uo),Uo.forEach(t),Zt.forEach(t),ro=s(e),c(je.$$.fragment,e),lo=s(e),Ve=l(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-x1pkth"&&(Ve.innerHTML=qn),po=s(e),Z=l(e,"OL",{});var Mt=u(Z);ke=l(Mt,"LI",{});var jo=u(ke);dt=l(jo,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-1xo2nq1"&&(dt.textContent=An),en=s(jo),c(Ie.$$.fragment,jo),jo.forEach(t),tn=s(Mt),Ce=l(Mt,"LI",{});var Vo=u(Ce);ct=l(Vo,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-1wln6n0"&&(ct.textContent=On),on=s(Vo),c(Xe.$$.fragment,Vo),Vo.forEach(t),nn=s(Mt),We=l(Mt,"LI",{});var ko=u(We);mt=l(ko,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-okpmrc"&&(mt.innerHTML=Kn),sn=s(ko),c(Ge.$$.fragment,ko),ko.forEach(t),Mt.forEach(t),co=s(e),Ne=l(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-18tnclt"&&(Ne.innerHTML=es),mo=s(e),G=l(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-r1jcqf"&&(G.innerHTML=ts),fo=s(e),c($e.$$.fragment,e),ho=s(e),b=l(e,"DIV",{class:!0});var M=u(b);c(Se.$$.fragment,M),an=s(M),N=l(M,"DIV",{class:!0});var Io=u(N);c(Be.$$.fragment,Io),rn=s(Io),ft=l(Io,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-50j04k"&&(ft.textContent=os),Io.forEach(t),ln=s(M),$=l(M,"DIV",{class:!0});var Co=u($);c(Pe.$$.fragment,Co),pn=s(Co),ht=l(Co,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-1cxzr1t"&&(ht.textContent=ns),Co.forEach(t),dn=s(M),S=l(M,"DIV",{class:!0});var Xo=u(S);c(Le.$$.fragment,Xo),cn=s(Xo),gt=l(Xo,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-16q0ax1"&&(gt.textContent=ss),Xo.forEach(t),mn=s(M),B=l(M,"DIV",{class:!0});var Wo=u(B);c(Re.$$.fragment,Wo),fn=s(Wo),ut=l(Wo,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-1d8vbe1"&&(ut.textContent=as),Wo.forEach(t),M.forEach(t),go=s(e),c(ze.$$.fragment,e),uo=s(e),T=l(e,"DIV",{class:!0});var J=u(T);c(De.$$.fragment,J),hn=s(J),P=l(J,"DIV",{class:!0});var Go=u(P);c(Qe.$$.fragment,Go),gn=s(Go),_t=l(Go,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-v78lg8"&&(_t.textContent=is),Go.forEach(t),un=s(J),L=l(J,"DIV",{class:!0});var No=u(L);c(Ee.$$.fragment,No),_n=s(No),bt=l(No,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-jp6j47"&&(bt.textContent=rs),No.forEach(t),bn=s(J),R=l(J,"DIV",{class:!0});var $o=u(R);c(Ye.$$.fragment,$o),Tn=s($o),Tt=l($o,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-16q0ax1"&&(Tt.textContent=ls),$o.forEach(t),yn=s(J),z=l(J,"DIV",{class:!0});var So=u(z);c(Fe.$$.fragment,So),wn=s(So),yt=l(So,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-1d8vbe1"&&(yt.textContent=ps),So.forEach(t),J.forEach(t),_o=s(e),c(He.$$.fragment,e),bo=s(e),I=l(e,"DIV",{class:!0});var Bo=u(I);c(qe.$$.fragment,Bo),vn=s(Bo),wt=l(Bo,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-1dgz4ei"&&(wt.textContent=ds),Bo.forEach(t),To=s(e),c(Ae.$$.fragment,e),yo=s(e),Ut=l(e,"P",{}),u(Ut).forEach(t),this.h()},h(){_(U,"name","hf:doc:metadata"),_(U,"content",Zs),_(C,"class","warning"),_(X,"class","flex flex-wrap space-x-1"),_(j,"start","2"),_(G,"class","tip"),_(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){a(document.head,U),i(e,Vt,o),i(e,Jt,o),i(e,kt,o),i(e,C,o),i(e,It,o),m(D,e,o),i(e,Ct,o),i(e,X,o),i(e,Xt,o),i(e,Q,o),i(e,Wt,o),i(e,E,o),i(e,Gt,o),i(e,Y,o),i(e,Nt,o),i(e,F,o),i(e,$t,o),i(e,H,o),i(e,St,o),i(e,q,o),i(e,Bt,o),i(e,A,o),i(e,Pt,o),i(e,O,o),i(e,Lt,o),m(K,e,o),i(e,Rt,o),m(ee,e,o),i(e,zt,o),i(e,te,o),i(e,Dt,o),m(oe,e,o),i(e,Qt,o),i(e,ne,o),i(e,Et,o),i(e,se,o),i(e,Yt,o),i(e,ae,o),i(e,Ft,o),m(ie,e,o),i(e,Ht,o),i(e,Oe,o),a(Oe,W),m(re,W,null),a(W,Po),a(W,Ke),a(W,Lo),i(e,qt,o),m(le,e,o),i(e,At,o),m(pe,e,o),i(e,Ot,o),i(e,de,o),i(e,Kt,o),i(e,et,o),a(et,ce),a(ce,tt),a(ce,Ro),m(me,ce,null),i(e,eo,o),i(e,j,o),a(j,V),a(V,ot),a(V,zo),m(fe,V,null),a(V,Do),a(V,nt),a(j,Qo),a(j,he),a(he,st),a(he,Eo),m(ge,he,null),i(e,to,o),i(e,at,o),a(at,k),m(ue,k,null),a(k,Yo),a(k,it),a(k,Fo),m(_e,k,null),i(e,oo,o),m(be,e,o),i(e,no,o),i(e,Te,o),i(e,so,o),m(ye,e,o),i(e,ao,o),i(e,we,o),i(e,io,o),i(e,x,o),a(x,ve),a(ve,rt),a(ve,Ho),m(xe,ve,null),a(x,qo),a(x,Ze),a(Ze,lt),a(Ze,Ao),m(Me,Ze,null),a(x,Oo),a(x,Je),a(Je,pt),a(Je,Ko),m(Ue,Je,null),i(e,ro,o),m(je,e,o),i(e,lo,o),i(e,Ve,o),i(e,po,o),i(e,Z,o),a(Z,ke),a(ke,dt),a(ke,en),m(Ie,ke,null),a(Z,tn),a(Z,Ce),a(Ce,ct),a(Ce,on),m(Xe,Ce,null),a(Z,nn),a(Z,We),a(We,mt),a(We,sn),m(Ge,We,null),i(e,co,o),i(e,Ne,o),i(e,mo,o),i(e,G,o),i(e,fo,o),m($e,e,o),i(e,ho,o),i(e,b,o),m(Se,b,null),a(b,an),a(b,N),m(Be,N,null),a(N,rn),a(N,ft),a(b,ln),a(b,$),m(Pe,$,null),a($,pn),a($,ht),a(b,dn),a(b,S),m(Le,S,null),a(S,cn),a(S,gt),a(b,mn),a(b,B),m(Re,B,null),a(B,fn),a(B,ut),i(e,go,o),m(ze,e,o),i(e,uo,o),i(e,T,o),m(De,T,null),a(T,hn),a(T,P),m(Qe,P,null),a(P,gn),a(P,_t),a(T,un),a(T,L),m(Ee,L,null),a(L,_n),a(L,bt),a(T,bn),a(T,R),m(Ye,R,null),a(R,Tn),a(R,Tt),a(T,yn),a(T,z),m(Fe,z,null),a(z,wn),a(z,yt),i(e,_o,o),m(He,e,o),i(e,bo,o),i(e,I,o),m(qe,I,null),a(I,vn),a(I,wt),i(e,To,o),m(Ae,e,o),i(e,yo,o),i(e,Ut,o),wo=!0},p:_s,i(e){wo||(f(D.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(oe.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(fe.$$.fragment,e),f(ge.$$.fragment,e),f(ue.$$.fragment,e),f(_e.$$.fragment,e),f(be.$$.fragment,e),f(ye.$$.fragment,e),f(xe.$$.fragment,e),f(Me.$$.fragment,e),f(Ue.$$.fragment,e),f(je.$$.fragment,e),f(Ie.$$.fragment,e),f(Xe.$$.fragment,e),f(Ge.$$.fragment,e),f($e.$$.fragment,e),f(Se.$$.fragment,e),f(Be.$$.fragment,e),f(Pe.$$.fragment,e),f(Le.$$.fragment,e),f(Re.$$.fragment,e),f(ze.$$.fragment,e),f(De.$$.fragment,e),f(Qe.$$.fragment,e),f(Ee.$$.fragment,e),f(Ye.$$.fragment,e),f(Fe.$$.fragment,e),f(He.$$.fragment,e),f(qe.$$.fragment,e),f(Ae.$$.fragment,e),wo=!0)},o(e){h(D.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(re.$$.fragment,e),h(le.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(fe.$$.fragment,e),h(ge.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(xe.$$.fragment,e),h(Me.$$.fragment,e),h(Ue.$$.fragment,e),h(je.$$.fragment,e),h(Ie.$$.fragment,e),h(Xe.$$.fragment,e),h(Ge.$$.fragment,e),h($e.$$.fragment,e),h(Se.$$.fragment,e),h(Be.$$.fragment,e),h(Pe.$$.fragment,e),h(Le.$$.fragment,e),h(Re.$$.fragment,e),h(ze.$$.fragment,e),h(De.$$.fragment,e),h(Qe.$$.fragment,e),h(Ee.$$.fragment,e),h(Ye.$$.fragment,e),h(Fe.$$.fragment,e),h(He.$$.fragment,e),h(qe.$$.fragment,e),h(Ae.$$.fragment,e),wo=!1},d(e){e&&(t(Vt),t(Jt),t(kt),t(C),t(It),t(Ct),t(X),t(Xt),t(Q),t(Wt),t(E),t(Gt),t(Y),t(Nt),t(F),t($t),t(H),t(St),t(q),t(Bt),t(A),t(Pt),t(O),t(Lt),t(Rt),t(zt),t(te),t(Dt),t(Qt),t(ne),t(Et),t(se),t(Yt),t(ae),t(Ft),t(Ht),t(Oe),t(qt),t(At),t(Ot),t(de),t(Kt),t(et),t(eo),t(j),t(to),t(at),t(oo),t(no),t(Te),t(so),t(ao),t(we),t(io),t(x),t(ro),t(lo),t(Ve),t(po),t(Z),t(co),t(Ne),t(mo),t(G),t(fo),t(ho),t(b),t(go),t(uo),t(T),t(_o),t(bo),t(I),t(To),t(yo),t(Ut)),t(U),g(D,e),g(K,e),g(ee,e),g(oe,e),g(ie,e),g(re),g(le,e),g(pe,e),g(me),g(fe),g(ge),g(ue),g(_e),g(be,e),g(ye,e),g(xe),g(Me),g(Ue),g(je,e),g(Ie),g(Xe),g(Ge),g($e,e),g(Se),g(Be),g(Pe),g(Le),g(Re),g(ze,e),g(De),g(Qe),g(Ee),g(Ye),g(Fe),g(He,e),g(qe),g(Ae,e)}}}const Zs='{"title":"Text2Video-Zero","local":"text2video-zero","sections":[{"title":"Usage example","local":"usage-example","sections":[{"title":"Text-To-Video","local":"text-to-video","sections":[{"title":"SDXL Support","local":"sdxl-support","sections":[],"depth":4}],"depth":3},{"title":"Text-To-Video with Pose Control","local":"text-to-video-with-pose-control","sections":[{"title":"SDXL Support","local":"sdxl-support","sections":[],"depth":4}],"depth":3},{"title":"Text-To-Video with Edge Control","local":"text-to-video-with-edge-control","sections":[],"depth":3},{"title":"Video Instruct-Pix2Pix","local":"video-instruct-pix2pix","sections":[],"depth":3},{"title":"DreamBooth specialization","local":"dreambooth-specialization","sections":[],"depth":3}],"depth":2},{"title":"TextToVideoZeroPipeline","local":"diffusers.TextToVideoZeroPipeline","sections":[],"depth":2},{"title":"TextToVideoZeroSDXLPipeline","local":"diffusers.TextToVideoZeroSDXLPipeline","sections":[],"depth":2},{"title":"TextToVideoPipelineOutput","local":"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput","sections":[],"depth":2}],"depth":1}';function Ms(xn){return bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends Ts{constructor(U){super(),ys(this,U,Ms,xs,us,{})}}export{Is as component};
