import{s as Me,n as be,o as ye}from"../chunks/scheduler.888833de.js";import{S as we,i as ge,e as n,s as a,c as o,h as Je,a as p,d as t,b as i,f as he,g as m,j as M,k as ie,l as Ze,m as s,n as r,t as f,o as c,p as u}from"../chunks/index.128ce987.js";import{C as ae}from"../chunks/CodeBlock.37df032e.js";import{H as N,E as Ue}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function Te(ne){let d,v,V,Q,b,S,y,pe='Stable Diffusion 2 is a text-to-image <em>latent diffusion</em> model built upon the work of the original <a href="https://stability.ai/blog/stable-diffusion-public-release" rel="nofollow">Stable Diffusion</a>, and it was led by Robin Rombach and Katherine Crowson from <a href="https://stability.ai/" rel="nofollow">Stability AI</a> and <a href="https://laion.ai/" rel="nofollow">LAION</a>.',$,w,oe=`<em>The Stable Diffusion 2.0 release includes robust text-to-image models trained using a brand new text encoder (OpenCLIP), developed by LAION with support from Stability AI, which greatly improves the quality of the generated images compared to earlier V1 releases. The text-to-image models in this release can generate images with default resolutions of both 512x512 pixels and 768x768 pixels.
These models are trained on an aesthetic subset of the <a href="https://laion.ai/blog/laion-5b/" rel="nofollow">LAION-5B dataset</a> created by the DeepFloyd team at Stability AI, which is then further filtered to remove adult content using <a href="https://openreview.net/forum?id=M3Y74vmsMcY" rel="nofollow">LAION’s NSFW filter</a>.</em>`,F,g,me='For more details about how Stable Diffusion 2 works and how it differs from the original Stable Diffusion, please refer to the official <a href="https://stability.ai/blog/stable-diffusion-v2-release" rel="nofollow">announcement post</a>.',Y,J,re='The architecture of Stable Diffusion 2 is more or less identical to the original <a href="./text2img">Stable Diffusion model</a> so check out it’s API documentation for how to use Stable Diffusion 2. We recommend using the <a href="/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> as it gives a reasonable speed/quality trade-off and can be run with as little as 20 steps.',z,Z,fe="Stable Diffusion 2 is available for tasks like text-to-image, inpainting, super-resolution, and depth-to-image:",x,U,ce='<thead><tr><th>Task</th> <th>Repository</th></tr></thead> <tbody><tr><td>text-to-image (512x512)</td> <td><a href="https://huggingface.co/stabilityai/stable-diffusion-2-base" rel="nofollow">stabilityai/stable-diffusion-2-base</a></td></tr> <tr><td>text-to-image (768x768)</td> <td><a href="https://huggingface.co/stabilityai/stable-diffusion-2" rel="nofollow">stabilityai/stable-diffusion-2</a></td></tr> <tr><td>inpainting</td> <td><a href="https://huggingface.co/stabilityai/stable-diffusion-2-inpainting" rel="nofollow">stabilityai/stable-diffusion-2-inpainting</a></td></tr> <tr><td>super-resolution</td> <td><a href="https://huggingface.co/stabilityai/stable-diffusion-x4-upscaler" rel="nofollow">stable-diffusion-x4-upscaler</a></td></tr> <tr><td>depth-to-image</td> <td><a href="https://huggingface.co/stabilityai/stable-diffusion-2-depth" rel="nofollow">stabilityai/stable-diffusion-2-depth</a></td></tr></tbody>',E,T,ue="Here are some examples for how to use Stable Diffusion 2 for each task:",H,h,de='<p>Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!</p> <p>If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!</p>',D,W,L,j,q,G,A,B,P,k,K,X,O,I,ee,R,le,_,te,C,se;return b=new N({props:{title:"Stable Diffusion 2",local:"stable-diffusion-2",headingTag:"h1"}}),W=new N({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),j=new ae({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFyZXBvX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItYmFzZSUyMiUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKSUwQSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhpZ2glMjBxdWFsaXR5JTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwaW4lMjBzcGFjZSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">import</span> torch

repo_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-base&quot;</span>
pipe = DiffusionPipeline.from_pretrained(repo_id, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)

pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;High quality photo of an astronaut riding a horse in space&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),G=new N({props:{title:"Inpainting",local:"inpainting",headingTag:"h2"}}),B=new ae({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKG1hc2tfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0yLWlucGFpbnRpbmclMjIlMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEElMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = load_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

repo_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-inpainting&quot;</span>
pipe = DiffusionPipeline.from_pretrained(repo_id, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)

pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipe(prompt=prompt, image=init_image, mask_image=mask_image, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),k=new N({props:{title:"Super-resolution",local:"super-resolution",headingTag:"h2"}}),X=new ae({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMjMlMjBsb2FkJTIwbW9kZWwlMjBhbmQlMjBzY2hlZHVsZXIlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14NC11cHNjYWxlciUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uVXBzY2FsZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwbGV0J3MlMjBkb3dubG9hZCUyMGFuJTIwJTIwaW1hZ2UlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc2QyLXVwc2NhbGUlMkZsb3dfcmVzX2NhdC5wbmclMjIlMEFsb3dfcmVzX2ltZyUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKSUwQWxvd19yZXNfaW1nJTIwJTNEJTIwbG93X3Jlc19pbWcucmVzaXplKCgxMjglMkMlMjAxMjgpKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjB3aGl0ZSUyMGNhdCUyMiUwQXVwc2NhbGVkX2ltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rsb3dfcmVzX2ltZykuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJsb3dfcmVzX2ltZy5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTJDJTIwdXBzY2FsZWRfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionUpscalePipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># load model and scheduler</span>
model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>
pipeline = StableDiffusionUpscalePipeline.from_pretrained(model_id, torch_dtype=torch.float16)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># let&#x27;s download an  image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd2-upscale/low_res_cat.png&quot;</span>
low_res_img = load_image(url)
low_res_img = low_res_img.resize((<span class="hljs-number">128</span>, <span class="hljs-number">128</span>))
prompt = <span class="hljs-string">&quot;a white cat&quot;</span>
upscaled_image = pipeline(prompt=prompt, image=low_res_img).images[<span class="hljs-number">0</span>]
make_image_grid([low_res_img.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>)), upscaled_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),I=new N({props:{title:"Depth-to-image",local:"depth-to-image",headingTag:"h2"}}),R=new ae({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uRGVwdGgySW1nUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25EZXB0aDJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItZGVwdGglMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEFwcm9tcHQlMjAlM0QlMjAlMjJ0d28lMjB0aWdlcnMlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJiYWQlMkMlMjBkZWZvcm1lZCUyQyUyMHVnbHklMkMlMjBiYWQlMjBhbm90b215JTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUyMHN0cmVuZ3RoJTNEMC43KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionDepth2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipe = StableDiffusionDepth2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-depth&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)


url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
init_image = load_image(url)
prompt = <span class="hljs-string">&quot;two tigers&quot;</span>
negative_prompt = <span class="hljs-string">&quot;bad, deformed, ugly, bad anotomy&quot;</span>
image = pipe(prompt=prompt, image=init_image, negative_prompt=negative_prompt, strength=<span class="hljs-number">0.7</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),_=new Ue({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_diffusion/stable_diffusion_2.md"}}),{c(){d=n("meta"),v=a(),V=n("p"),Q=a(),o(b.$$.fragment),S=a(),y=n("p"),y.innerHTML=pe,$=a(),w=n("p"),w.innerHTML=oe,F=a(),g=n("p"),g.innerHTML=me,Y=a(),J=n("p"),J.innerHTML=re,z=a(),Z=n("p"),Z.textContent=fe,x=a(),U=n("table"),U.innerHTML=ce,E=a(),T=n("p"),T.textContent=ue,H=a(),h=n("blockquote"),h.innerHTML=de,D=a(),o(W.$$.fragment),L=a(),o(j.$$.fragment),q=a(),o(G.$$.fragment),A=a(),o(B.$$.fragment),P=a(),o(k.$$.fragment),K=a(),o(X.$$.fragment),O=a(),o(I.$$.fragment),ee=a(),o(R.$$.fragment),le=a(),o(_.$$.fragment),te=a(),C=n("p"),this.h()},l(e){const l=Je("svelte-u9bgzb",document.head);d=p(l,"META",{name:!0,content:!0}),l.forEach(t),v=i(e),V=p(e,"P",{}),he(V).forEach(t),Q=i(e),m(b.$$.fragment,e),S=i(e),y=p(e,"P",{"data-svelte-h":!0}),M(y)!=="svelte-b1fked"&&(y.innerHTML=pe),$=i(e),w=p(e,"P",{"data-svelte-h":!0}),M(w)!=="svelte-14ofdwv"&&(w.innerHTML=oe),F=i(e),g=p(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-m1ataf"&&(g.innerHTML=me),Y=i(e),J=p(e,"P",{"data-svelte-h":!0}),M(J)!=="svelte-1fyxemw"&&(J.innerHTML=re),z=i(e),Z=p(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-lmvyuh"&&(Z.textContent=fe),x=i(e),U=p(e,"TABLE",{"data-svelte-h":!0}),M(U)!=="svelte-14nbvv4"&&(U.innerHTML=ce),E=i(e),T=p(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1y4j0tz"&&(T.textContent=ue),H=i(e),h=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(h)!=="svelte-1y59iwh"&&(h.innerHTML=de),D=i(e),m(W.$$.fragment,e),L=i(e),m(j.$$.fragment,e),q=i(e),m(G.$$.fragment,e),A=i(e),m(B.$$.fragment,e),P=i(e),m(k.$$.fragment,e),K=i(e),m(X.$$.fragment,e),O=i(e),m(I.$$.fragment,e),ee=i(e),m(R.$$.fragment,e),le=i(e),m(_.$$.fragment,e),te=i(e),C=p(e,"P",{}),he(C).forEach(t),this.h()},h(){ie(d,"name","hf:doc:metadata"),ie(d,"content",We),ie(h,"class","tip")},m(e,l){Ze(document.head,d),s(e,v,l),s(e,V,l),s(e,Q,l),r(b,e,l),s(e,S,l),s(e,y,l),s(e,$,l),s(e,w,l),s(e,F,l),s(e,g,l),s(e,Y,l),s(e,J,l),s(e,z,l),s(e,Z,l),s(e,x,l),s(e,U,l),s(e,E,l),s(e,T,l),s(e,H,l),s(e,h,l),s(e,D,l),r(W,e,l),s(e,L,l),r(j,e,l),s(e,q,l),r(G,e,l),s(e,A,l),r(B,e,l),s(e,P,l),r(k,e,l),s(e,K,l),r(X,e,l),s(e,O,l),r(I,e,l),s(e,ee,l),r(R,e,l),s(e,le,l),r(_,e,l),s(e,te,l),s(e,C,l),se=!0},p:be,i(e){se||(f(b.$$.fragment,e),f(W.$$.fragment,e),f(j.$$.fragment,e),f(G.$$.fragment,e),f(B.$$.fragment,e),f(k.$$.fragment,e),f(X.$$.fragment,e),f(I.$$.fragment,e),f(R.$$.fragment,e),f(_.$$.fragment,e),se=!0)},o(e){c(b.$$.fragment,e),c(W.$$.fragment,e),c(j.$$.fragment,e),c(G.$$.fragment,e),c(B.$$.fragment,e),c(k.$$.fragment,e),c(X.$$.fragment,e),c(I.$$.fragment,e),c(R.$$.fragment,e),c(_.$$.fragment,e),se=!1},d(e){e&&(t(v),t(V),t(Q),t(S),t(y),t($),t(w),t(F),t(g),t(Y),t(J),t(z),t(Z),t(x),t(U),t(E),t(T),t(H),t(h),t(D),t(L),t(q),t(A),t(P),t(K),t(O),t(ee),t(le),t(te),t(C)),t(d),u(b,e),u(W,e),u(j,e),u(G,e),u(B,e),u(k,e),u(X,e),u(I,e),u(R,e),u(_,e)}}}const We='{"title":"Stable Diffusion 2","local":"stable-diffusion-2","sections":[{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Inpainting","local":"inpainting","sections":[],"depth":2},{"title":"Super-resolution","local":"super-resolution","sections":[],"depth":2},{"title":"Depth-to-image","local":"depth-to-image","sections":[],"depth":2}],"depth":1}';function je(ne){return ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ie extends we{constructor(d){super(),ge(this,d,je,Te,Me,{})}}export{Ie as component};
