import{s as It,o as St,n as $t}from"../chunks/scheduler.888833de.js";import{S as Bt,i as Gt,e as s,s as a,c as m,h as Lt,a as r,d as n,b as o,f as ue,g,j as l,k as P,l as b,m as i,n as f,t as u,o as h,p as _}from"../chunks/index.128ce987.js";import{D as at}from"../chunks/Docstring.23ed6b62.js";import{C as le}from"../chunks/CodeBlock.37df032e.js";import{E as Zt}from"../chunks/ExampleCodeBlock.6d7ae280.js";import{H as ot,E as Wt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function Et(he){let d,I="Examples:",y,w,M;return w=new le({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUGl4QXJ0U2lnbWFQaXBlbGluZSUwQSUwQSUyMyUyMFlvdSUyMGNhbiUyMHJlcGxhY2UlMjB0aGUlMjBjaGVja3BvaW50JTIwaWQlMjB3aXRoJTIwJTIyUGl4QXJ0LWFscGhhJTJGUGl4QXJ0LVNpZ21hLVhMLTItNTEyLU1TJTIyJTIwdG9vLiUwQXBpcGUlMjAlM0QlMjBQaXhBcnRTaWdtYVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtU2lnbWEtWEwtMi0xMDI0LU1TJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQSUyMyUyMEVuYWJsZSUyMG1lbW9yeSUyMG9wdGltaXphdGlvbnMuJTBBJTIzJTIwcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBzbWFsbCUyMGNhY3R1cyUyMHdpdGglMjBhJTIwaGFwcHklMjBmYWNlJTIwaW4lMjB0aGUlMjBTYWhhcmElMjBkZXNlcnQuJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> PixArtSigmaPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can replace the checkpoint id with &quot;PixArt-alpha/PixArt-Sigma-XL-2-512-MS&quot; too.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = PixArtSigmaPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;PixArt-alpha/PixArt-Sigma-XL-2-1024-MS&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable memory optimizations.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># pipe.enable_model_cpu_offload()</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A small cactus with a happy face in the Sahara desert.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){d=s("p"),d.textContent=I,y=a(),m(w.$$.fragment)},l(p){d=r(p,"P",{"data-svelte-h":!0}),l(d)!=="svelte-kvfsh7"&&(d.textContent=I),y=o(p),g(w.$$.fragment,p)},m(p,T){i(p,d,T),i(p,y,T),f(w,p,T),M=!0},p:$t,i(p){M||(u(w.$$.fragment,p),M=!0)},o(p){h(w.$$.fragment,p),M=!1},d(p){p&&(n(d),n(y)),_(w,p)}}}function Ht(he){let d,I,y,w,M,p,T,st='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pixart/header_collage_sigma.jpg"/>',_e,S,rt='<a href="https://huggingface.co/papers/2403.04692" rel="nofollow">PixArt-Σ: Weak-to-Strong Training of Diffusion Transformer for 4K Text-to-Image Generation</a> is Junsong Chen, Jincheng Yu, Chongjian Ge, Lewei Yao, Enze Xie, Yue Wu, Zhongdao Wang, James Kwok, Ping Luo, Huchuan Lu, and Zhenguo Li.',be,$,lt="The abstract from the paper is:",xe,B,pt="<em>In this paper, we introduce PixArt-Σ, a Diffusion Transformer model (DiT) capable of directly generating images at 4K resolution. PixArt-Σ represents a significant advancement over its predecessor, PixArt-α, offering images of markedly higher fidelity and improved alignment with text prompts. A key feature of PixArt-Σ is its training efficiency. Leveraging the foundational pre-training of PixArt-α, it evolves from the ‘weaker’ baseline to a ‘stronger’ model via incorporating higher quality data, a process we term “weak-to-strong training”. The advancements in PixArt-Σ are twofold: (1) High-Quality Training Data: PixArt-Σ incorporates superior-quality image data, paired with more precise and detailed image captions. (2) Efficient Token Compression: we propose a novel attention module within the DiT framework that compresses both keys and values, significantly improving efficiency and facilitating ultra-high-resolution image generation. Thanks to these improvements, PixArt-Σ achieves superior image quality and user prompt adherence capabilities with significantly smaller model size (0.6B parameters) than existing text-to-image diffusion models, such as SDXL (2.6B parameters) and SD Cascade (5.1B parameters). Moreover, PixArt-Σ’s capability to generate 4K images supports the creation of high-resolution posters and wallpapers, efficiently bolstering the production of highquality visual content in industries such as film and gaming.</em>",we,G,dt='You can find the original codebase at <a href="https://github.com/PixArt-alpha/PixArt-sigma" rel="nofollow">PixArt-alpha/PixArt-sigma</a> and all the available checkpoints at <a href="https://huggingface.co/PixArt-alpha" rel="nofollow">PixArt-alpha</a>.',Me,L,ct="Some notes about this pipeline:",Te,Z,mt='<li>It uses a Transformer backbone (instead of a UNet) for denoising. As such it has a similar architecture as <a href="https://hf.co/docs/transformers/model_doc/dit" rel="nofollow">DiT</a>.</li> <li>It was trained using text conditions computed from T5. This aspect makes the pipeline better at following complex text prompts with intricate details.</li> <li>It is good at producing high-resolution images at different aspect ratios. To get the best results, the authors recommend some size brackets which can be found <a href="https://github.com/PixArt-alpha/PixArt-sigma/blob/master/diffusion/data/datasets/utils.py" rel="nofollow">here</a>.</li> <li>It rivals the quality of state-of-the-art text-to-image generation systems (as of this writing) such as PixArt-α, Stable Diffusion XL, Playground V2.0 and DALL-E 3, while being more efficient than them.</li> <li>It shows the ability of generating super high resolution images, such as 2048px or even 4K.</li> <li>It shows that text-to-image models can grow from a weak model to a stronger one through several improvements (VAEs, datasets, and so on.)</li>',ye,J,gt='<p>Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.</p>',ve,A,ft='<p>You can further improve generation quality by passing the generated image from <a href="/docs/diffusers/main/en/api/pipelines/pixart_sigma#diffusers.PixArtSigmaPipeline">PixArtSigmaPipeline</a> to the <a href="../../using-diffusers/sdxl#base-to-refiner-model">SDXL refiner</a> model.</p>',Pe,W,Je,E,ut='Run the <a href="/docs/diffusers/main/en/api/pipelines/pixart_sigma#diffusers.PixArtSigmaPipeline">PixArtSigmaPipeline</a> with under 8GB GPU VRAM by loading the text encoder in 8-bit precision. Let’s walk through a full-fledged example.',Ae,H,ht='First, install the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library:',je,V,Ue,X,_t="Then load the text encoder in 8-bit:",Ce,q,ke,Q,bt="Now, use the <code>pipe</code> to encode a prompt:",Ie,R,Se,N,xt="Since text embeddings have been computed, remove the <code>text_encoder</code> and <code>pipe</code> from the memory, and free up some GPU VRAM:",$e,Y,Be,D,wt="Then compute the latents with the prompt embeddings as inputs:",Ge,z,Le,j,Mt="<p>Notice that while initializing <code>pipe</code>, you’re setting <code>text_encoder</code> to <code>None</code> so that it’s not loaded.</p>",Ze,F,Tt="Once the latents are computed, pass it off to the VAE to decode into a real image:",We,O,Ee,K,yt='By deleting components you aren’t using and flushing the GPU VRAM, you should be able to run <a href="/docs/diffusers/main/en/api/pipelines/pixart_sigma#diffusers.PixArtSigmaPipeline">PixArtSigmaPipeline</a> with under 8GB GPU VRAM.',He,ee,vt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pixart/8bits_cat.png"/>',Ve,te,Pt='If you want a report of your memory-usage, run this <a href="https://gist.github.com/sayakpaul/3ae0f847001d342af27018a96f467e4e" rel="nofollow">script</a>.',Xe,U,Jt="<p>Text embeddings computed in 8-bit can impact the quality of the generated images because of the information loss in the representation space caused by the reduced precision. It’s recommended to compare the outputs with and without 8-bit.</p>",qe,ne,At="While loading the <code>text_encoder</code>, you set <code>load_in_8bit</code> to <code>True</code>. You could also specify <code>load_in_4bit</code> to bring your memory requirements down even further to under 7GB.",Qe,ie,Re,c,ae,Fe,pe,jt="Pipeline for text-to-image generation using PixArt-Sigma.",Oe,de,Ut=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ke,v,oe,et,ce,Ct="Function invoked when calling the pipeline for generation.",tt,C,nt,k,se,it,me,kt="Encodes the prompt into text encoder hidden states.",Ne,re,Ye,fe,De;return M=new ot({props:{title:"PixArt-Σ",local:"pixart-σ",headingTag:"h1"}}),W=new ot({props:{title:"Inference with under 8GB GPU VRAM",local:"inference-with-under-8gb-gpu-vram",headingTag:"h2"}}),V=new le({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYml0c2FuZGJ5dGVz",highlighted:"pip install -U bitsandbytes",wrap:!1}}),q=new le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFBpeEFydFNpZ21hUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRleHRfZW5jb2RlciUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtU2lnbWEtWEwtMi0xMDI0LU1TJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBQaXhBcnRTaWdtYVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtU2lnbWEtWEwtMi0xMDI0LU1TJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyJTNEdGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> PixArtSigmaPipeline
<span class="hljs-keyword">import</span> torch

text_encoder = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-Sigma-XL-2-1024-MS&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
pipe = PixArtSigmaPipeline.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-Sigma-XL-2-1024-MS&quot;</span>,
    text_encoder=text_encoder,
    transformer=<span class="hljs-literal">None</span>,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>
)`,wrap:!1}}),R=new le({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMmN1dGUlMjBjYXQlMjIlMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTJDJTIwcHJvbXB0X2F0dGVudGlvbl9tYXNrJTJDJTIwbmVnYXRpdmVfZW1iZWRzJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2F0dGVudGlvbl9tYXNrJTIwJTNEJTIwcGlwZS5lbmNvZGVfcHJvbXB0KHByb21wdCk=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    prompt = <span class="hljs-string">&quot;cute cat&quot;</span>
    prompt_embeds, prompt_attention_mask, negative_embeds, negative_prompt_attention_mask = pipe.encode_prompt(prompt)`,wrap:!1}}),Y=new le({props:{code:"aW1wb3J0JTIwZ2MlMEElMEFkZWYlMjBmbHVzaCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2MuY29sbGVjdCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5lbXB0eV9jYWNoZSgpJTBBJTBBZGVsJTIwdGV4dF9lbmNvZGVyJTBBZGVsJTIwcGlwZSUwQWZsdXNoKCk=",highlighted:`<span class="hljs-keyword">import</span> gc

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
    gc.collect()
    torch.cuda.empty_cache()

<span class="hljs-keyword">del</span> text_encoder
<span class="hljs-keyword">del</span> pipe
flush()`,wrap:!1}}),z=new le({props:{code:"cGlwZSUyMCUzRCUyMFBpeEFydFNpZ21hUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlBpeEFydC1hbHBoYSUyRlBpeEFydC1TaWdtYS1YTC0yLTEwMjQtTVMlMjIlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWxhdGVudHMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfYXR0ZW50aW9uX21hc2slM0Rwcm9tcHRfYXR0ZW50aW9uX21hc2slMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfYXR0ZW50aW9uX21hc2slM0RuZWdhdGl2ZV9wcm9tcHRfYXR0ZW50aW9uX21hc2slMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIlMkMlMEEpLmltYWdlcyUwQSUwQWRlbCUyMHBpcGUudHJhbnNmb3JtZXIlMEFmbHVzaCgp",highlighted:`pipe = PixArtSigmaPipeline.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-Sigma-XL-2-1024-MS&quot;</span>,
    text_encoder=<span class="hljs-literal">None</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

latents = pipe(
    negative_prompt=<span class="hljs-literal">None</span>,
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    prompt_attention_mask=prompt_attention_mask,
    negative_prompt_attention_mask=negative_prompt_attention_mask,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images

<span class="hljs-keyword">del</span> pipe.transformer
flush()`,wrap:!1}}),O=new le({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwcGlwZS52YWUuZGVjb2RlKGxhdGVudHMlMjAlMkYlMjBwaXBlLnZhZS5jb25maWcuc2NhbGluZ19mYWN0b3IlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlKSU1QjAlNUQlMEFpbWFnZSUyMCUzRCUyMHBpcGUuaW1hZ2VfcHJvY2Vzc29yLnBvc3Rwcm9jZXNzKGltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIpJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    image = pipe.vae.decode(latents / pipe.vae.config.scaling_factor, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
image = pipe.image_processor.postprocess(image, output_type=<span class="hljs-string">&quot;pil&quot;</span>)[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),ie=new ot({props:{title:"PixArtSigmaPipeline",local:"diffusers.PixArtSigmaPipeline",headingTag:"h2"}}),ae=new at({props:{name:"class diffusers.PixArtSigmaPipeline",anchor:"diffusers.PixArtSigmaPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKL"},{name:"transformer",val:": PixArtTransformer2DModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.PixArtSigmaPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.PixArtSigmaPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. PixArt-Alpha uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.PixArtSigmaPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.PixArtSigmaPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/pixart_transformer2d#diffusers.PixArtTransformer2DModel">PixArtTransformer2DModel</a>) &#x2014;
A text conditioned <code>PixArtTransformer2DModel</code> to denoise the encoded image latents. Initially published as
<a href="https://huggingface.co/PixArt-alpha/PixArt-Sigma-XL-2-1024-MS/blob/main/transformer/config.json#L2" rel="nofollow"><code>Transformer2DModel</code></a>
in the config, but the mismatch can be ignored.`,name:"transformer"},{anchor:"diffusers.PixArtSigmaPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_sigma.py#L185"}}),oe=new at({props:{name:"__call__",anchor:"diffusers.PixArtSigmaPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Optional[typing.Callable[[int, int, torch.Tensor], NoneType]] = None"},{name:"callback_steps",val:": int = 1"},{name:"clean_caption",val:": bool = True"},{name:"use_resolution_binning",val:": bool = True"},{name:"max_sequence_length",val:": int = 300"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.PixArtSigmaPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.5) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">https://huggingface.co/papers/2010.02502</a>. Only
applies to <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.prompt_attention_mask",description:"<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014; Pre-generated attention mask for text embeddings.",name:"prompt_attention_mask"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
<code>ASPECT_RATIO_1024_BIN</code>. After the produced latents are decoded into images, they are resized back to
the requested resolution. Useful for generating non-square images.`,name:"use_resolution_binning"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 300) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_sigma.py#L631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),C=new Zt({props:{anchor:"diffusers.PixArtSigmaPipeline.__call__.example",$$slots:{default:[Et]},$$scope:{ctx:he}}}),se=new at({props:{name:"encode_prompt",anchor:"diffusers.PixArtSigmaPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"clean_caption",val:": bool = False"},{name:"max_sequence_length",val:": int = 300"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
PixArt-Alpha, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"device"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Alpha, it&#x2019;s should be the embeddings of the &quot;&quot;
string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, defaults to 300) &#x2014; Maximum sequence length to use for the prompt.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_sigma.py#L247"}}),re=new Wt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/pixart_sigma.md"}}),{c(){d=s("meta"),I=a(),y=s("p"),w=a(),m(M.$$.fragment),p=a(),T=s("p"),T.innerHTML=st,_e=a(),S=s("p"),S.innerHTML=rt,be=a(),$=s("p"),$.textContent=lt,xe=a(),B=s("p"),B.innerHTML=pt,we=a(),G=s("p"),G.innerHTML=dt,Me=a(),L=s("p"),L.textContent=ct,Te=a(),Z=s("ul"),Z.innerHTML=mt,ye=a(),J=s("blockquote"),J.innerHTML=gt,ve=a(),A=s("blockquote"),A.innerHTML=ft,Pe=a(),m(W.$$.fragment),Je=a(),E=s("p"),E.innerHTML=ut,Ae=a(),H=s("p"),H.innerHTML=ht,je=a(),m(V.$$.fragment),Ue=a(),X=s("p"),X.textContent=_t,Ce=a(),m(q.$$.fragment),ke=a(),Q=s("p"),Q.innerHTML=bt,Ie=a(),m(R.$$.fragment),Se=a(),N=s("p"),N.innerHTML=xt,$e=a(),m(Y.$$.fragment),Be=a(),D=s("p"),D.textContent=wt,Ge=a(),m(z.$$.fragment),Le=a(),j=s("blockquote"),j.innerHTML=Mt,Ze=a(),F=s("p"),F.textContent=Tt,We=a(),m(O.$$.fragment),Ee=a(),K=s("p"),K.innerHTML=yt,He=a(),ee=s("p"),ee.innerHTML=vt,Ve=a(),te=s("p"),te.innerHTML=Pt,Xe=a(),U=s("blockquote"),U.innerHTML=Jt,qe=a(),ne=s("p"),ne.innerHTML=At,Qe=a(),m(ie.$$.fragment),Re=a(),c=s("div"),m(ae.$$.fragment),Fe=a(),pe=s("p"),pe.textContent=jt,Oe=a(),de=s("p"),de.innerHTML=Ut,Ke=a(),v=s("div"),m(oe.$$.fragment),et=a(),ce=s("p"),ce.textContent=Ct,tt=a(),m(C.$$.fragment),nt=a(),k=s("div"),m(se.$$.fragment),it=a(),me=s("p"),me.textContent=kt,Ne=a(),m(re.$$.fragment),Ye=a(),fe=s("p"),this.h()},l(e){const t=Lt("svelte-u9bgzb",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(n),I=o(e),y=r(e,"P",{}),ue(y).forEach(n),w=o(e),g(M.$$.fragment,e),p=o(e),T=r(e,"P",{"data-svelte-h":!0}),l(T)!=="svelte-1h02zzr"&&(T.innerHTML=st),_e=o(e),S=r(e,"P",{"data-svelte-h":!0}),l(S)!=="svelte-1i25npg"&&(S.innerHTML=rt),be=o(e),$=r(e,"P",{"data-svelte-h":!0}),l($)!=="svelte-1cwsb16"&&($.textContent=lt),xe=o(e),B=r(e,"P",{"data-svelte-h":!0}),l(B)!=="svelte-12smxu3"&&(B.innerHTML=pt),we=o(e),G=r(e,"P",{"data-svelte-h":!0}),l(G)!=="svelte-8e6u65"&&(G.innerHTML=dt),Me=o(e),L=r(e,"P",{"data-svelte-h":!0}),l(L)!=="svelte-v1sn1g"&&(L.textContent=ct),Te=o(e),Z=r(e,"UL",{"data-svelte-h":!0}),l(Z)!=="svelte-8ca6jo"&&(Z.innerHTML=mt),ye=o(e),J=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),l(J)!=="svelte-r1jcqf"&&(J.innerHTML=gt),ve=o(e),A=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),l(A)!=="svelte-sdcwk5"&&(A.innerHTML=ft),Pe=o(e),g(W.$$.fragment,e),Je=o(e),E=r(e,"P",{"data-svelte-h":!0}),l(E)!=="svelte-bc67kz"&&(E.innerHTML=ut),Ae=o(e),H=r(e,"P",{"data-svelte-h":!0}),l(H)!=="svelte-c2h3fb"&&(H.innerHTML=ht),je=o(e),g(V.$$.fragment,e),Ue=o(e),X=r(e,"P",{"data-svelte-h":!0}),l(X)!=="svelte-5r7318"&&(X.textContent=_t),Ce=o(e),g(q.$$.fragment,e),ke=o(e),Q=r(e,"P",{"data-svelte-h":!0}),l(Q)!=="svelte-rj1jgt"&&(Q.innerHTML=bt),Ie=o(e),g(R.$$.fragment,e),Se=o(e),N=r(e,"P",{"data-svelte-h":!0}),l(N)!=="svelte-1ux3xow"&&(N.innerHTML=xt),$e=o(e),g(Y.$$.fragment,e),Be=o(e),D=r(e,"P",{"data-svelte-h":!0}),l(D)!=="svelte-w3d4de"&&(D.textContent=wt),Ge=o(e),g(z.$$.fragment,e),Le=o(e),j=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),l(j)!=="svelte-1389ba9"&&(j.innerHTML=Mt),Ze=o(e),F=r(e,"P",{"data-svelte-h":!0}),l(F)!=="svelte-1yf7wfg"&&(F.textContent=Tt),We=o(e),g(O.$$.fragment,e),Ee=o(e),K=r(e,"P",{"data-svelte-h":!0}),l(K)!=="svelte-o4igoy"&&(K.innerHTML=yt),He=o(e),ee=r(e,"P",{"data-svelte-h":!0}),l(ee)!=="svelte-1g55ccf"&&(ee.innerHTML=vt),Ve=o(e),te=r(e,"P",{"data-svelte-h":!0}),l(te)!=="svelte-11lvu0m"&&(te.innerHTML=Pt),Xe=o(e),U=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),l(U)!=="svelte-16px8fj"&&(U.innerHTML=Jt),qe=o(e),ne=r(e,"P",{"data-svelte-h":!0}),l(ne)!=="svelte-1i82z60"&&(ne.innerHTML=At),Qe=o(e),g(ie.$$.fragment,e),Re=o(e),c=r(e,"DIV",{class:!0});var x=ue(c);g(ae.$$.fragment,x),Fe=o(x),pe=r(x,"P",{"data-svelte-h":!0}),l(pe)!=="svelte-bjkp5a"&&(pe.textContent=jt),Oe=o(x),de=r(x,"P",{"data-svelte-h":!0}),l(de)!=="svelte-wu1jmh"&&(de.innerHTML=Ut),Ke=o(x),v=r(x,"DIV",{class:!0});var ge=ue(v);g(oe.$$.fragment,ge),et=o(ge),ce=r(ge,"P",{"data-svelte-h":!0}),l(ce)!=="svelte-v78lg8"&&(ce.textContent=Ct),tt=o(ge),g(C.$$.fragment,ge),ge.forEach(n),nt=o(x),k=r(x,"DIV",{class:!0});var ze=ue(k);g(se.$$.fragment,ze),it=o(ze),me=r(ze,"P",{"data-svelte-h":!0}),l(me)!=="svelte-16q0ax1"&&(me.textContent=kt),ze.forEach(n),x.forEach(n),Ne=o(e),g(re.$$.fragment,e),Ye=o(e),fe=r(e,"P",{}),ue(fe).forEach(n),this.h()},h(){P(d,"name","hf:doc:metadata"),P(d,"content",Vt),P(J,"class","tip"),P(A,"class","tip"),P(j,"class","tip"),P(U,"class","warning"),P(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){b(document.head,d),i(e,I,t),i(e,y,t),i(e,w,t),f(M,e,t),i(e,p,t),i(e,T,t),i(e,_e,t),i(e,S,t),i(e,be,t),i(e,$,t),i(e,xe,t),i(e,B,t),i(e,we,t),i(e,G,t),i(e,Me,t),i(e,L,t),i(e,Te,t),i(e,Z,t),i(e,ye,t),i(e,J,t),i(e,ve,t),i(e,A,t),i(e,Pe,t),f(W,e,t),i(e,Je,t),i(e,E,t),i(e,Ae,t),i(e,H,t),i(e,je,t),f(V,e,t),i(e,Ue,t),i(e,X,t),i(e,Ce,t),f(q,e,t),i(e,ke,t),i(e,Q,t),i(e,Ie,t),f(R,e,t),i(e,Se,t),i(e,N,t),i(e,$e,t),f(Y,e,t),i(e,Be,t),i(e,D,t),i(e,Ge,t),f(z,e,t),i(e,Le,t),i(e,j,t),i(e,Ze,t),i(e,F,t),i(e,We,t),f(O,e,t),i(e,Ee,t),i(e,K,t),i(e,He,t),i(e,ee,t),i(e,Ve,t),i(e,te,t),i(e,Xe,t),i(e,U,t),i(e,qe,t),i(e,ne,t),i(e,Qe,t),f(ie,e,t),i(e,Re,t),i(e,c,t),f(ae,c,null),b(c,Fe),b(c,pe),b(c,Oe),b(c,de),b(c,Ke),b(c,v),f(oe,v,null),b(v,et),b(v,ce),b(v,tt),f(C,v,null),b(c,nt),b(c,k),f(se,k,null),b(k,it),b(k,me),i(e,Ne,t),f(re,e,t),i(e,Ye,t),i(e,fe,t),De=!0},p(e,[t]){const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),C.$set(x)},i(e){De||(u(M.$$.fragment,e),u(W.$$.fragment,e),u(V.$$.fragment,e),u(q.$$.fragment,e),u(R.$$.fragment,e),u(Y.$$.fragment,e),u(z.$$.fragment,e),u(O.$$.fragment,e),u(ie.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(C.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),De=!0)},o(e){h(M.$$.fragment,e),h(W.$$.fragment,e),h(V.$$.fragment,e),h(q.$$.fragment,e),h(R.$$.fragment,e),h(Y.$$.fragment,e),h(z.$$.fragment,e),h(O.$$.fragment,e),h(ie.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(C.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),De=!1},d(e){e&&(n(I),n(y),n(w),n(p),n(T),n(_e),n(S),n(be),n($),n(xe),n(B),n(we),n(G),n(Me),n(L),n(Te),n(Z),n(ye),n(J),n(ve),n(A),n(Pe),n(Je),n(E),n(Ae),n(H),n(je),n(Ue),n(X),n(Ce),n(ke),n(Q),n(Ie),n(Se),n(N),n($e),n(Be),n(D),n(Ge),n(Le),n(j),n(Ze),n(F),n(We),n(Ee),n(K),n(He),n(ee),n(Ve),n(te),n(Xe),n(U),n(qe),n(ne),n(Qe),n(Re),n(c),n(Ne),n(Ye),n(fe)),n(d),_(M,e),_(W,e),_(V,e),_(q,e),_(R,e),_(Y,e),_(z,e),_(O,e),_(ie,e),_(ae),_(oe),_(C),_(se),_(re,e)}}}const Vt='{"title":"PixArt-Σ","local":"pixart-σ","sections":[{"title":"Inference with under 8GB GPU VRAM","local":"inference-with-under-8gb-gpu-vram","sections":[],"depth":2},{"title":"PixArtSigmaPipeline","local":"diffusers.PixArtSigmaPipeline","sections":[],"depth":2}],"depth":1}';function Xt(he){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends Bt{constructor(d){super(),Gt(this,d,Xt,Ht,It,{})}}export{zt as component};
